/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.utils;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1368;
import net.minecraft.class_1379;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import speakingvillagers.sv.goals.FollowPlayerGoal;
import speakingvillagers.sv.mixin.VillagerEntityAccessor;

public class VillagerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VillagerUtils.class);

    public static void addFollowPlayerGoal(class_1646 villager, class_1657 player) {
        if (player == null) {
            LOGGER.error("Player is null when adding FollowPlayerGoal.");
            return;
        }
        VillagerEntityAccessor accessor = (VillagerEntityAccessor)villager;
        class_1355 goalSelector = accessor.getGoalSelector();
        boolean hasFollowPlayerGoal = goalSelector.method_35115().stream().anyMatch(goal -> goal.method_19058() instanceof FollowPlayerGoal);
        if (!hasFollowPlayerGoal) {
            goalSelector.method_6277(0, (class_1352)new FollowPlayerGoal(villager, player, 0.65, 2.0f, 5.0f));
            LOGGER.info("FollowPlayerGoal added to villager for player: {}", (Object)player.method_5477().getString());
        } else {
            LOGGER.info("FollowPlayerGoal already present.");
        }
    }

    public static void removeFollowPlayerGoal(class_1646 villager) {
        try {
            Field goalSelectorField = class_1646.class.getSuperclass().getDeclaredField("goalSelector");
            goalSelectorField.setAccessible(true);
            class_1355 goalSelector = (class_1355)goalSelectorField.get(villager);
            goalSelector.method_35115().removeIf(goal -> goal.method_19058() instanceof FollowPlayerGoal);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void removeConflictingGoals(class_1646 villager) {
        VillagerEntityAccessor accessor = (VillagerEntityAccessor)villager;
        class_1355 goalSelector = accessor.getGoalSelector();
        goalSelector.method_35115().removeIf(goal -> goal.method_19058() instanceof class_1379 || goal.method_19058() instanceof class_1361 || goal.method_19058() instanceof class_1367 || goal.method_19058() instanceof class_1368);
    }

    public static class_1646 findNearestVillager(class_3222 player) {
        return player.method_37908().method_8390(class_1646.class, player.method_5829().method_1014(16.0), villager -> true).stream().min((v1, v2) -> Double.compare(v1.method_5858((class_1297)player), v2.method_5858((class_1297)player))).orElse(null);
    }

    public static class_1646 getVillagerById(class_3218 serverWorld, UUID villagerId) {
        for (class_3218 world : serverWorld.method_8503().method_3738()) {
            for (class_1646 villager2 : world.method_18198((class_5575)class_1299.field_6077, villager -> true)) {
                if (!villager2.method_5667().equals(villagerId)) continue;
                return villager2;
            }
        }
        return null;
    }
}

