/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.inventory.nbt;

import com.chattriggers.ctjs.api.inventory.nbt.NBTBase;
import com.chattriggers.ctjs.api.inventory.nbt.NBTTagCompound;
import com.chattriggers.ctjs.api.inventory.nbt.NBTTagList;
import com.chattriggers.ctjs.internal.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012*\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0019\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/chattriggers/ctjs/api/inventory/nbt/NBT;", "", "<init>", "()V", "nbt", "Lorg/mozilla/javascript/NativeObject;", "options", "Lcom/chattriggers/ctjs/api/inventory/nbt/NBTBase;", "parse", "(Ljava/lang/Object;Lorg/mozilla/javascript/NativeObject;)Lcom/chattriggers/ctjs/api/inventory/nbt/NBTBase;", "Lcom/chattriggers/ctjs/api/inventory/nbt/NBTTagCompound;", "toObject", "(Lcom/chattriggers/ctjs/api/inventory/nbt/NBTTagCompound;)Lorg/mozilla/javascript/NativeObject;", "Lcom/chattriggers/ctjs/api/inventory/nbt/NBTTagList;", "Lorg/mozilla/javascript/NativeArray;", "toArray", "(Lcom/chattriggers/ctjs/api/inventory/nbt/NBTTagList;)Lorg/mozilla/javascript/NativeArray;", "Lnet/minecraft/class_2520;", "Lcom/chattriggers/ctjs/MCNbtBase;", "toNBT", "(Ljava/lang/Object;Lorg/mozilla/javascript/NativeObject;)Lnet/minecraft/class_2520;", "", "nbtData", "", "coerceNumericStrings", "parseString", "(Ljava/lang/String;Z)Lnet/minecraft/class_2520;", "Lkotlin/text/Regex;", "numberNBTFormat", "Lkotlin/text/Regex;", "ctjs"})
@SourceDebugExtension(value={"SMAP\nNBT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NBT.kt\ncom/chattriggers/ctjs/api/inventory/nbt/NBT\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1869#2,2:127\n1563#2:129\n1634#2,3:130\n1740#2,3:134\n1563#2:137\n1634#2,3:138\n1740#2,3:141\n1563#2:144\n1634#2,3:145\n1740#2,3:148\n1563#2:151\n1634#2,3:152\n1#3:133\n*S KotlinDebug\n*F\n+ 1 NBT.kt\ncom/chattriggers/ctjs/api/inventory/nbt/NBT\n*L\n58#1:127,2\n63#1:129\n63#1:130,3\n70#1:134,3\n71#1:137\n71#1:138,3\n74#1:141,3\n75#1:144\n75#1:145,3\n78#1:148,3\n79#1:151\n79#1:152,3\n*E\n"})
public final class NBT {
    @NotNull
    public static final NBT INSTANCE = new NBT();
    @NotNull
    private static final Regex numberNBTFormat = new Regex("^([+-]?\\d+\\.?\\d*)([bslfd])?$", RegexOption.IGNORE_CASE);

    private NBT() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTBase parse(@NotNull Object nbt, @Nullable NativeObject options) {
        NBTBase nBTBase;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Object object = nbt;
        if (object instanceof NativeObject) {
            class_2520 class_25202 = INSTANCE.toNBT(nbt, options);
            Intrinsics.checkNotNull((Object)class_25202, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
            nBTBase = new NBTTagCompound((class_2487)class_25202);
        } else if (object instanceof NativeArray) {
            class_2520 it = INSTANCE.toNBT(nbt, options);
            boolean bl = false;
            nBTBase = it instanceof class_2499 ? (NBTBase)new NBTTagList((class_2499)it) : new NBTBase(it);
        } else {
            nBTBase = new NBTBase(INSTANCE.toNBT(nbt, options));
        }
        return nBTBase;
    }

    public static /* synthetic */ NBTBase parse$default(Object object, NativeObject nativeObject, int n, Object object2) {
        if ((n & 2) != 0) {
            nativeObject = null;
        }
        return NBT.parse(object, nativeObject);
    }

    @JvmStatic
    @NotNull
    public static final NativeObject toObject(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return nbt.toObject();
    }

    @JvmStatic
    @NotNull
    public static final NativeArray toArray(@NotNull NBTTagList nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return nbt.toArray();
    }

    private final class_2520 toNBT(Object $this$toNBT, NativeObject options) {
        class_2520 class_25202;
        boolean preferArraysOverLists = (Boolean)ExtensionsKt.getOption(options, "preferArraysOverLists", false);
        boolean coerceNumericStrings = (Boolean)ExtensionsKt.getOption(options, "coerceNumericStrings", false);
        Object object = $this$toNBT;
        if (object instanceof NativeObject) {
            class_2487 class_24872;
            class_2487 $this$toNBT_u24lambda_u242 = class_24872 = new class_2487();
            boolean bl = false;
            Set set = ((NativeObject)$this$toNBT).entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String string = entry.getKey().toString();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                $this$toNBT_u24lambda_u242.method_10566(string, INSTANCE.toNBT(v, options));
            }
            class_25202 = (class_2520)class_24872;
        } else {
            if (object instanceof NativeArray) {
                class_2520 class_25203;
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                List normalized;
                class_2520 it;
                Object item$iv$iv;
                Object $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                boolean $i$f$map;
                Iterable $this$map$iv;
                block40: {
                    $this$map$iv = (Iterable)$this$toNBT;
                    $i$f$map = false;
                    Iterable $this$forEach$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator element$iv = $this$mapTo$iv$iv.iterator();
                    while (element$iv.hasNext()) {
                        Object bl2 = item$iv$iv = element$iv.next();
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        void v4 = it;
                        collection.add(v4 != null ? INSTANCE.toNBT(v4, options) : null);
                    }
                    normalized = (List)destination$iv$iv;
                    if (!preferArraysOverLists || normalized.isEmpty()) {
                        Iterable $this$toNBT_u24lambda_u244 = $this$map$iv = new class_2499();
                        boolean bl4 = false;
                        $this$toNBT_u24lambda_u244.addAll(normalized);
                        return (class_2520)$this$map$iv;
                    }
                    $this$all$iv = normalized;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            class_2520 it2 = (class_2520)element$iv2;
                            boolean bl5 = false;
                            if (it2 instanceof class_2481) continue;
                            bl = false;
                            break block40;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $this$map$iv = normalized;
                    $i$f$map = false;
                    Iterable bl4 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl5 = $this$mapTo$iv$iv.iterator();
                    while (bl5.hasNext()) {
                        item$iv$iv = bl5.next();
                        it = (class_2520)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtByte");
                        collection.add(((class_2481)it).method_10698());
                    }
                    byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                    class_25203 = (class_2520)new class_2479(byArray);
                } else {
                    boolean bl7;
                    block41: {
                        $this$all$iv = normalized;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                class_2520 it3 = (class_2520)element$iv2;
                                boolean bl8 = false;
                                if (it3 instanceof class_2497) continue;
                                bl7 = false;
                                break block41;
                            }
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        $this$map$iv = normalized;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator bl8 = $this$mapTo$iv$iv.iterator();
                        while (bl8.hasNext()) {
                            item$iv$iv = bl8.next();
                            it = (class_2520)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl9 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtInt");
                            collection.add(((class_2497)it).method_10701());
                        }
                        int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                        class_25203 = (class_2520)new class_2495(nArray);
                    } else {
                        boolean bl10;
                        block42: {
                            $this$all$iv = normalized;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl10 = true;
                            } else {
                                for (Object element$iv2 : $this$all$iv) {
                                    class_2520 it4 = (class_2520)element$iv2;
                                    boolean bl11 = false;
                                    if (it4 instanceof class_2503) continue;
                                    bl10 = false;
                                    break block42;
                                }
                                bl10 = true;
                            }
                        }
                        if (bl10) {
                            $this$map$iv = normalized;
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator iterator = $this$mapTo$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                item$iv$iv = iterator.next();
                                it = (class_2520)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl12 = false;
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtLong");
                                collection.add(((class_2503)it).method_10699());
                            }
                            long[] lArray = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
                            class_25203 = (class_2520)new class_2501(lArray);
                        } else {
                            class_2499 class_24992;
                            class_2499 $this$toNBT_u24lambda_u2411 = class_24992 = new class_2499();
                            boolean bl13 = false;
                            $this$toNBT_u24lambda_u2411.addAll((Collection)normalized);
                            class_25203 = (class_2520)class_24992;
                        }
                    }
                }
                return class_25203;
            }
            if (object instanceof Boolean) {
                class_2481 class_24812 = class_2481.method_23233((byte)((Boolean)$this$toNBT != false ? (byte)1 : 0));
                Intrinsics.checkNotNullExpressionValue((Object)class_24812, (String)"of(...)");
                class_25202 = (class_2520)class_24812;
            } else if (object instanceof CharSequence) {
                class_25202 = this.parseString($this$toNBT.toString(), coerceNumericStrings);
            } else if (object instanceof Byte) {
                class_2481 class_24813 = class_2481.method_23233((byte)((Number)$this$toNBT).byteValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_24813, (String)"of(...)");
                class_25202 = (class_2520)class_24813;
            } else if (object instanceof Short) {
                class_2516 class_25162 = class_2516.method_23254((short)((Number)$this$toNBT).shortValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_25162, (String)"of(...)");
                class_25202 = (class_2520)class_25162;
            } else if (object instanceof Integer) {
                class_2497 class_24972 = class_2497.method_23247((int)((Number)$this$toNBT).intValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_24972, (String)"of(...)");
                class_25202 = (class_2520)class_24972;
            } else if (object instanceof Long) {
                class_2503 class_25032 = class_2503.method_23251((long)((Number)$this$toNBT).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_25032, (String)"of(...)");
                class_25202 = (class_2520)class_25032;
            } else if (object instanceof Float) {
                class_2494 class_24942 = class_2494.method_23244((float)((Number)$this$toNBT).floatValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_24942, (String)"of(...)");
                class_25202 = (class_2520)class_24942;
            } else if (object instanceof Double) {
                class_2489 class_24892 = class_2489.method_23241((double)((Number)$this$toNBT).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)class_24892, (String)"of(...)");
                class_25202 = (class_2520)class_24892;
            } else {
                throw new IllegalArgumentException("Invalid NBT. Value provided: " + $this$toNBT);
            }
        }
        return class_25202;
    }

    private final class_2520 parseString(String nbtData, boolean coerceNumericStrings) {
        if (!coerceNumericStrings) {
            class_2519 class_25192 = class_2519.method_23256((String)nbtData);
            Intrinsics.checkNotNullExpressionValue((Object)class_25192, (String)"of(...)");
            return (class_2520)class_25192;
        }
        Object object = numberNBTFormat.matchEntire((CharSequence)nbtData);
        if (object == null || (object = object.getGroupValues()) == null) {
            class_2519 class_25193 = class_2519.method_23256((String)nbtData);
            Intrinsics.checkNotNullExpressionValue((Object)class_25193, (String)"of(...)");
            return (class_2520)class_25193;
        }
        Object res = object;
        String number = (String)res.get(1);
        String suffix = (String)res.get(2);
        String string = suffix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "" -> {
                if (StringsKt.contains$default((CharSequence)number, (CharSequence)".", (boolean)false, (int)2, null)) {
                    class_2489 var7_7 = class_2489.method_23241((double)Double.parseDouble(number));
                    Intrinsics.checkNotNull((Object)var7_7);
                    yield (class_2520)var7_7;
                }
                class_2497 var7_8 = class_2497.method_23247((int)Integer.parseInt(number));
                Intrinsics.checkNotNull((Object)var7_8);
                yield (class_2520)var7_8;
            }
            case "b" -> {
                class_2481 v5 = class_2481.method_23233((byte)Byte.parseByte(number));
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"of(...)");
                yield (class_2520)v5;
            }
            case "s" -> {
                class_2516 v6 = class_2516.method_23254((short)Short.parseShort(number));
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"of(...)");
                yield (class_2520)v6;
            }
            case "l" -> {
                class_2503 v7 = class_2503.method_23251((long)Long.parseLong(number));
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"of(...)");
                yield (class_2520)v7;
            }
            case "f" -> {
                class_2494 v8 = class_2494.method_23244((float)Float.parseFloat(number));
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"of(...)");
                yield (class_2520)v8;
            }
            case "d" -> {
                class_2489 v9 = class_2489.method_23241((double)Double.parseDouble(number));
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"of(...)");
                yield (class_2520)v9;
            }
            default -> {
                class_2519 v10 = class_2519.method_23256((String)nbtData);
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"of(...)");
                yield (class_2520)v10;
            }
        };
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTBase parse(@NotNull Object nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return NBT.parse$default(nbt, null, 2, null);
    }
}

