/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.message;

import com.chattriggers.ctjs.api.client.Client;
import com.chattriggers.ctjs.api.message.TextComponent;
import com.chattriggers.ctjs.api.render.Renderer;
import com.chattriggers.ctjs.internal.listeners.ClientListener;
import com.chattriggers.ctjs.internal.mixins.ChatHudAccessor;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.impl.command.client.ClientCommandInternals;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_634;
import net.minecraft.class_7591;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.regexp.NativeRegExp;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0004\b\b\u0010\u0007J\u0019\u0010\t\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0004\b\t\u0010\u0007J\u0019\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0019\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u0015\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u0016\u0010\rJ\u000f\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001a\u0010\rJ\u0017\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001b\u0010\rJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001c\u0010\rJ\u0017\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ+\u0010#\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001f2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0007\u00a2\u0006\u0004\b#\u0010$J+\u0010#\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\n2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0007\u00a2\u0006\u0004\b#\u0010&J+\u0010#\u001a\u00020\u00052\u0006\u0010%\u001a\u00020'2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0007\u00a2\u0006\u0004\b#\u0010(J+\u0010#\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00172\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0007\u00a2\u0006\u0004\b#\u0010*J7\u0010#\u001a\u00020\u00052\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00100+2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0007\u00a2\u0006\u0004\b#\u0010-J3\u0010/\u001a\u00020\u00052\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00100+H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u00101\u001a\u00020\u00052\u0006\u00103\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b1\u0010\u001eJ\u0017\u00101\u001a\u00020\u00052\u0006\u00103\u001a\u00020'H\u0007\u00a2\u0006\u0004\b1\u00104J\u0017\u00101\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b1\u00105J#\u00101\u001a\u00020\u00052\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00100+H\u0007\u00a2\u0006\u0004\b1\u00106J#\u00107\u001a\u00020\u00052\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00100+H\u0002\u00a2\u0006\u0004\b7\u00106J\u0015\u00109\u001a\b\u0012\u0004\u0012\u00020\n08H\u0007\u00a2\u0006\u0004\b9\u0010:J!\u0010<\u001a\u00020\u00052\b\b\u0002\u0010;\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020'H\u0000\u00a2\u0006\u0004\b>\u00104J\u000f\u0010A\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b@\u0010\u0003J\u0017\u0010E\u001a\u00020\u00052\u0006\u0010B\u001a\u00020.H\u0000\u00a2\u0006\u0004\bC\u0010DR \u0010G\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00170F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0016\u0010L\u001a\u0004\u0018\u00010I8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006M"}, d2={"Lcom/chattriggers/ctjs/api/message/ChatLib;", "", "<init>", "()V", "text", "", "chat", "(Ljava/lang/Object;)V", "actionBar", "simulateChat", "", "message", "addColor", "(Ljava/lang/String;)Ljava/lang/String;", "say", "(Ljava/lang/String;)Lkotlin/Unit;", "", "clientSide", "command", "(Ljava/lang/String;Z)V", "clearChat", "separator", "getChatBreak", "", "getChatWidth", "()I", "removeFormatting", "replaceFormatting", "getCenteredText", "copyToClipboard", "(Ljava/lang/String;)V", "Lorg/mozilla/javascript/regexp/NativeRegExp;", "regexp", "", "replacements", "editChat", "(Lorg/mozilla/javascript/regexp/NativeRegExp;[Ljava/lang/Object;)V", "toReplace", "(Ljava/lang/String;[Ljava/lang/Object;)V", "Lcom/chattriggers/ctjs/api/message/TextComponent;", "(Lcom/chattriggers/ctjs/api/message/TextComponent;[Ljava/lang/Object;)V", "chatLineId", "(I[Ljava/lang/Object;)V", "Lkotlin/Function1;", "matcher", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/Object;)V", "Lnet/minecraft/class_303;", "editLines", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "deleteChat", "(Lorg/mozilla/javascript/regexp/NativeRegExp;)V", "toDelete", "(Lcom/chattriggers/ctjs/api/message/TextComponent;)V", "(I)V", "(Lkotlin/jvm/functions/Function1;)V", "removeLines", "", "getChatLines", "()Ljava/util/List;", "index", "addToSentMessageHistory", "(ILjava/lang/String;)V", "sendMessageWithId$ctjs", "sendMessageWithId", "onChatHudClearChat$ctjs", "onChatHudClearChat", "line", "onChatHudLineRemoved$ctjs", "(Lnet/minecraft/class_303;)V", "onChatHudLineRemoved", "", "chatLineIds", "Ljava/util/Map;", "Lcom/chattriggers/ctjs/internal/mixins/ChatHudAccessor;", "getChatHudAccessor", "()Lcom/chattriggers/ctjs/internal/mixins/ChatHudAccessor;", "chatHudAccessor", "ctjs"})
@SourceDebugExtension(value={"SMAP\nChatLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatLib.kt\ncom/chattriggers/ctjs/api/message/ChatLib\n+ 2 extensions.kt\ncom/chattriggers/ctjs/internal/utils/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,423:1\n29#2:424\n1563#3:425\n1634#3,3:426\n*S KotlinDebug\n*F\n+ 1 ChatLib.kt\ncom/chattriggers/ctjs/api/message/ChatLib\n*L\n19#1:424\n381#1:425\n381#1:426,3\n*E\n"})
public final class ChatLib {
    @NotNull
    public static final ChatLib INSTANCE = new ChatLib();
    @NotNull
    private static final Map<class_303, Integer> chatLineIds = new LinkedHashMap();

    private ChatLib() {
    }

    private final ChatHudAccessor getChatHudAccessor() {
        ChatHudAccessor chatHudAccessor;
        class_338 class_3382 = Client.getChatGui();
        if (class_3382 != null) {
            class_338 $this$asMixin$iv = class_3382;
            boolean $i$f$asMixin = false;
            chatHudAccessor = (ChatHudAccessor)$this$asMixin$iv;
        } else {
            chatHudAccessor = null;
        }
        return chatHudAccessor;
    }

    @JvmStatic
    public static final void chat(@Nullable Object text) {
        TextComponent textComponent;
        Object object = text;
        if (object instanceof TextComponent) {
            textComponent = (TextComponent)text;
        } else if (object instanceof CharSequence) {
            Object[] objectArray = new Object[]{text};
            TextComponent textComponent2 = new TextComponent(objectArray);
            textComponent = textComponent2;
        } else {
            Object[] objectArray = new Object[]{String.valueOf(text)};
            TextComponent textComponent3 = new TextComponent(objectArray);
            textComponent = textComponent3;
        }
        textComponent.chat();
    }

    @JvmStatic
    public static final void actionBar(@Nullable Object text) {
        TextComponent textComponent;
        Object object = text;
        if (object instanceof TextComponent) {
            textComponent = (TextComponent)text;
        } else if (object instanceof CharSequence) {
            Object[] objectArray = new Object[]{text};
            TextComponent textComponent2 = new TextComponent(objectArray);
            textComponent = textComponent2;
        } else {
            Object[] objectArray = new Object[]{String.valueOf(text)};
            TextComponent textComponent3 = new TextComponent(objectArray);
            textComponent = textComponent3;
        }
        textComponent.actionBar();
    }

    @JvmStatic
    public static final void simulateChat(@Nullable Object text) {
        TextComponent textComponent;
        Object object = text;
        if (object instanceof TextComponent) {
            textComponent = (TextComponent)text;
        } else if (object instanceof CharSequence) {
            Object[] objectArray = new Object[]{text};
            TextComponent textComponent2 = new TextComponent(objectArray);
            textComponent = textComponent2;
        } else {
            Object[] objectArray = new Object[]{String.valueOf(text)};
            TextComponent textComponent3 = new TextComponent(objectArray);
            textComponent = textComponent3;
        }
        TextComponent.withRecursive$default(textComponent, false, 1, null).chat();
    }

    @JvmStatic
    @NotNull
    public static final String addColor(@Nullable String message2) {
        CharSequence charSequence = String.valueOf(message2);
        Regex regex = new Regex("(?<!\\\\)&(?![^0-9a-fk-or]|$)");
        String string = "\u00a7";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @Nullable
    public static final Unit say(@NotNull String text) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        class_634 class_6342 = Client.getMinecraft().method_1562();
        if (class_6342 != null) {
            class_6342.method_45729(text);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @JvmStatic
    @JvmOverloads
    public static final void command(@NotNull String text, boolean clientSide) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                if (!clientSide) break block0;
                ClientCommandInternals.executeCommand((String)text);
                break block1;
            }
            class_634 class_6342 = Client.getMinecraft().method_1562();
            if (class_6342 == null) break block1;
            class_6342.method_45730(text);
        }
    }

    public static /* synthetic */ void command$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ChatLib.command(string, bl);
    }

    @JvmStatic
    public static final void clearChat() {
        class_338 class_3382 = Client.getChatGui();
        if (class_3382 != null) {
            class_3382.method_1808(false);
        }
        chatLineIds.clear();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatBreak(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int len = Renderer.getStringWidth(separator);
        int times = INSTANCE.getChatWidth() / len;
        return StringsKt.repeat((CharSequence)separator, (int)times);
    }

    public static /* synthetic */ String getChatBreak$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "-";
        }
        return ChatLib.getChatBreak(string);
    }

    @JvmStatic
    public static final int getChatWidth() {
        class_338 class_3382 = Client.getChatGui();
        return class_3382 != null ? class_3382.method_1811() : 0;
    }

    @JvmStatic
    @NotNull
    public static final String removeFormatting(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("[\u00a7&][0-9a-fk-or]");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String replaceFormatting(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("\u00a7(?![^0-9a-fk-or]|$)");
        String string = "&";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String getCenteredText(@NotNull String text) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int textWidth = Renderer.getStringWidth(ChatLib.addColor(text));
        int chatWidth = INSTANCE.getChatWidth();
        if (textWidth >= chatWidth) {
            return text;
        }
        float spaceWidth = (float)(chatWidth - textWidth) / 2.0f;
        StringBuilder $this$getCenteredText_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = MathKt.roundToInt((float)(spaceWidth / (float)Renderer.getStringWidth(" ")));
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$getCenteredText_u24lambda_u241.append(' ');
        }
        StringBuilder spaceBuilder = stringBuilder;
        String string = spaceBuilder.append(text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    public static final void copyToClipboard(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    @JvmStatic
    public static final void editChat(@NotNull NativeRegExp regexp, Object ... replacements) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Object object = regexp.get((Object)"global");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean global = (Boolean)object;
        Object object2 = regexp.get((Object)"ignoreCase");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean ignoreCase = (Boolean)object2;
        Object object3 = regexp.get((Object)"multiline");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean multiline = (Boolean)object3;
        int flags = (ignoreCase ? 2 : 0) | (multiline ? 8 : 0);
        Object object4 = regexp.get((Object)"source");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        Pattern pattern = Pattern.compile((String)object4, flags);
        INSTANCE.editLines(replacements, (Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.editChat$lambda$2(pattern, global, arg_0)));
    }

    @JvmStatic
    public static final void editChat(@NotNull String toReplace, Object ... replacements) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editLines(replacements, (Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.editChat$lambda$3(toReplace, arg_0)));
    }

    @JvmStatic
    public static final void editChat(@NotNull TextComponent toReplace, Object ... replacements) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editLines(replacements, (Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.editChat$lambda$4(toReplace, arg_0)));
    }

    @JvmStatic
    public static final void editChat(int chatLineId, Object ... replacements) {
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editLines(replacements, (Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.editChat$lambda$5(chatLineId, arg_0)));
    }

    @JvmStatic
    public static final void editChat(@NotNull Function1<? super TextComponent, Boolean> matcher, Object ... replacements) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editLines(replacements, (Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.editChat$lambda$6(matcher, arg_0)));
    }

    private final void editLines(Object[] replacements, Function1<? super class_303, Boolean> matcher) {
        class_310 mc = Client.getMinecraft();
        class_7591 indicator = mc.method_47392() ? class_7591.method_47391() : class_7591.method_44751();
        boolean edited = false;
        Object object = this.getChatHudAccessor();
        if (object == null || (object = object.getMessages()) == null || (object = object.listIterator()) == null) {
            return;
        }
        ListIterator<class_303> it = object;
        while (it.hasNext()) {
            class_303 next = (class_303)it.next();
            Intrinsics.checkNotNull((Object)next);
            if (!((Boolean)matcher.invoke((Object)next)).booleanValue()) continue;
            edited = true;
            it.remove();
            chatLineIds.remove(next);
            for (Object replacement : replacements) {
                TextComponent textComponent = replacement instanceof TextComponent ? (TextComponent)replacement : null;
                if (textComponent == null) {
                    Object[] objectArray = new Object[]{replacement};
                    textComponent = new TextComponent(objectArray);
                }
                TextComponent message2 = textComponent;
                class_303 line = new class_303(next.comp_892(), (class_2561)message2, null, indicator);
                if (message2.getChatLineId() != -1) {
                    chatLineIds.put(line, message2.getChatLineId());
                }
                it.add(line);
            }
        }
        if (edited) {
            ChatHudAccessor chatHudAccessor = this.getChatHudAccessor();
            Intrinsics.checkNotNull((Object)chatHudAccessor);
            chatHudAccessor.invokeRefresh();
        }
    }

    @JvmStatic
    public static final void deleteChat(@NotNull NativeRegExp regexp) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        Object object = regexp.get((Object)"global");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean global = (Boolean)object;
        Object object2 = regexp.get((Object)"ignoreCase");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean ignoreCase = (Boolean)object2;
        Object object3 = regexp.get((Object)"multiline");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean multiline = (Boolean)object3;
        int flags = (ignoreCase ? 2 : 0) | (multiline ? 8 : 0);
        Object object4 = regexp.get((Object)"source");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        Pattern pattern = Pattern.compile((String)object4, flags);
        INSTANCE.removeLines((Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.deleteChat$lambda$7(pattern, global, arg_0)));
    }

    @JvmStatic
    public static final void deleteChat(@NotNull String toDelete) {
        Intrinsics.checkNotNullParameter((Object)toDelete, (String)"toDelete");
        INSTANCE.removeLines((Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.deleteChat$lambda$8(toDelete, arg_0)));
    }

    @JvmStatic
    public static final void deleteChat(@NotNull TextComponent toDelete) {
        Intrinsics.checkNotNullParameter((Object)toDelete, (String)"toDelete");
        INSTANCE.removeLines((Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.deleteChat$lambda$9(toDelete, arg_0)));
    }

    @JvmStatic
    public static final void deleteChat(int chatLineId) {
        INSTANCE.removeLines((Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.deleteChat$lambda$10(chatLineId, arg_0)));
    }

    @JvmStatic
    public static final void deleteChat(@NotNull Function1<? super TextComponent, Boolean> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        INSTANCE.removeLines((Function1<? super class_303, Boolean>)((Function1)arg_0 -> ChatLib.deleteChat$lambda$11(matcher, arg_0)));
    }

    private final void removeLines(Function1<? super class_303, Boolean> matcher) {
        boolean removed = false;
        Object object = this.getChatHudAccessor();
        if (object == null || (object = object.getMessages()) == null || (object = object.listIterator()) == null) {
            return;
        }
        ListIterator it = object;
        while (it.hasNext()) {
            class_303 next = (class_303)it.next();
            Intrinsics.checkNotNull((Object)next);
            if (!((Boolean)matcher.invoke((Object)next)).booleanValue()) continue;
            it.remove();
            chatLineIds.remove(next);
            removed = true;
        }
        if (removed) {
            ChatHudAccessor chatHudAccessor = this.getChatHudAccessor();
            Intrinsics.checkNotNull((Object)chatHudAccessor);
            chatHudAccessor.invokeRefresh();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> getChatLines() {
        void $this$mapTo$iv$iv;
        List hist = CollectionsKt.toMutableList((Collection)ClientListener.INSTANCE.getChatHistory());
        Iterable $this$map$iv = CollectionsKt.asReversedMutable((List)hist);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextComponent textComponent = (TextComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFormattedText());
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @JvmOverloads
    public static final void addToSentMessageHistory(int index, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (index == -1) {
            Client.getMinecraft().field_1705.method_1743().method_1803(message2);
        } else {
            Client.getMinecraft().field_1705.method_1743().method_1809().add(index, (Object)message2);
        }
    }

    public static /* synthetic */ void addToSentMessageHistory$default(int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        ChatLib.addToSentMessageHistory(n, string);
    }

    public final void sendMessageWithId$ctjs(@NotNull TextComponent message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!(message2.getChatLineId() != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        class_338 class_3382 = Client.getChatGui();
        if (class_3382 == null) {
            return;
        }
        class_338 chatGui = class_3382;
        chatGui.method_1812((class_2561)message2);
        ChatHudAccessor chatHudAccessor = this.getChatHudAccessor();
        Intrinsics.checkNotNull((Object)chatHudAccessor);
        class_303 newChatLine = chatHudAccessor.getMessages().get(0);
        if (!Intrinsics.areEqual((Object)message2, (Object)newChatLine.comp_893())) {
            boolean bl = false;
            String string = "Expected new chat message to be at index 0";
            throw new IllegalStateException(string.toString());
        }
        chatLineIds.put(newChatLine, message2.getChatLineId());
    }

    public final void onChatHudClearChat$ctjs() {
        chatLineIds.clear();
    }

    public final void onChatHudLineRemoved$ctjs(@NotNull class_303 line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        chatLineIds.remove(line);
    }

    @JvmStatic
    @JvmOverloads
    public static final void command(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ChatLib.command$default(text, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatBreak() {
        return ChatLib.getChatBreak$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void addToSentMessageHistory(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ChatLib.addToSentMessageHistory$default(0, message2, 1, null);
    }

    private static final boolean editChat$lambda$2(Pattern $pattern, boolean $global, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        Matcher matcher = $pattern.matcher(new TextComponent(objectArray).getUnformattedText());
        return $global ? matcher.find() : matcher.matches();
    }

    private static final boolean editChat$lambda$3(String $toReplace, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return Intrinsics.areEqual((Object)ChatLib.removeFormatting(new TextComponent(objectArray).getUnformattedText()), (Object)$toReplace);
    }

    private static final boolean editChat$lambda$4(TextComponent $toReplace, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return Intrinsics.areEqual((Object)$toReplace.getFormattedText(), (Object)new TextComponent(objectArray).getFormattedText());
    }

    private static final boolean editChat$lambda$5(int $chatLineId, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = chatLineIds.get(it);
        int n2 = $chatLineId;
        return n != null && n == n2;
    }

    private static final boolean editChat$lambda$6(Function1 $matcher, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return (Boolean)$matcher.invoke((Object)new TextComponent(objectArray));
    }

    private static final boolean deleteChat$lambda$7(Pattern $pattern, boolean $global, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        Matcher matcher = $pattern.matcher(new TextComponent(objectArray).getUnformattedText());
        return $global ? matcher.find() : matcher.matches();
    }

    private static final boolean deleteChat$lambda$8(String $toDelete, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return Intrinsics.areEqual((Object)ChatLib.removeFormatting(new TextComponent(objectArray).getUnformattedText()), (Object)$toDelete);
    }

    private static final boolean deleteChat$lambda$9(TextComponent $toDelete, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return Intrinsics.areEqual((Object)$toDelete.getFormattedText(), (Object)new TextComponent(objectArray).getFormattedText());
    }

    private static final boolean deleteChat$lambda$10(int $chatLineId, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = chatLineIds.get(it);
        int n2 = $chatLineId;
        return n != null && n == n2;
    }

    private static final boolean deleteChat$lambda$11(Function1 $matcher, class_303 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{it.comp_893()};
        return (Boolean)$matcher.invoke((Object)new TextComponent(objectArray));
    }
}

