/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.render;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.api.client.Client;
import com.chattriggers.ctjs.api.render.Renderer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 )2\u00020\u0001:\u0002*)B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR$\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u0005R\u0018\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010%\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0018\u0010'\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lcom/chattriggers/ctjs/api/render/Image;", "", "Ljava/awt/image/BufferedImage;", "image", "<init>", "(Ljava/awt/image/BufferedImage;)V", "", "getTextureWidth", "()I", "getTextureHeight", "Lnet/minecraft/class_1043;", "getTexture", "()Lnet/minecraft/class_1043;", "Lnet/minecraft/class_2960;", "getIdOrRegister$ctjs", "()Lnet/minecraft/class_2960;", "getIdOrRegister", "", "destroy", "()V", "", "x", "y", "width", "height", "draw", "(FFLjava/lang/Float;Ljava/lang/Float;)Lcom/chattriggers/ctjs/api/render/Image;", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "Lcom/chattriggers/ctjs/api/render/Image$Texture;", "texture", "Lcom/chattriggers/ctjs/api/render/Image$Texture;", "textureWidth", "I", "textureHeight", "aspectRatio", "F", "identifier", "Lnet/minecraft/class_2960;", "Companion", "Texture", "ctjs"})
@SourceDebugExtension(value={"SMAP\nImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Image.kt\ncom/chattriggers/ctjs/api/render/Image\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class Image {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferedImage image;
    @Nullable
    private Texture texture;
    private final int textureWidth;
    private final int textureHeight;
    private final float aspectRatio;
    @Nullable
    private class_2960 identifier;
    private static int nextIdentifierIndex;

    public Image(@Nullable BufferedImage image) {
        BufferedImage bufferedImage = this.image = image;
        this.textureWidth = bufferedImage != null ? bufferedImage.getWidth() : 0;
        BufferedImage bufferedImage2 = this.image;
        this.textureHeight = bufferedImage2 != null ? bufferedImage2.getHeight() : 0;
        this.aspectRatio = this.textureHeight != 0 ? (float)this.textureHeight / (float)this.textureWidth : 0.0f;
        CTJS.Companion.getImages$ctjs().add(this);
        Client.scheduleTask$default(0, () -> Image._init_$lambda$0(this), 1, null);
    }

    @Nullable
    public final BufferedImage getImage() {
        return this.image;
    }

    public final void setImage(@Nullable BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public final int getTextureWidth() {
        return this.textureWidth;
    }

    public final int getTextureHeight() {
        return this.textureHeight;
    }

    @Nullable
    public final class_1043 getTexture() {
        Texture texture = this.texture;
        return texture != null ? texture.getTexture() : null;
    }

    @NotNull
    public final class_2960 getIdOrRegister$ctjs() {
        if (this.identifier == null) {
            int n = nextIdentifierIndex;
            nextIdentifierIndex = n + 1;
            this.identifier = class_2960.method_60655((String)"ctjs", (String)("image" + n));
            if (this.texture != null) {
                class_1060 class_10602 = Client.getMinecraft().method_1531();
                class_2960 class_29602 = this.identifier;
                Intrinsics.checkNotNull((Object)class_29602);
                Texture texture = this.texture;
                Intrinsics.checkNotNull((Object)texture);
                class_10602.method_4616(class_29602, (class_1044)texture.getTexture());
            } else {
                Client.scheduleTask$default(0, () -> Image.getIdOrRegister$lambda$1(this), 1, null);
            }
        }
        class_2960 class_29603 = this.identifier;
        Intrinsics.checkNotNull((Object)class_29603);
        return class_29603;
    }

    public final void destroy() {
        Object object;
        Texture texture = this.texture;
        if (texture != null && (texture = texture.getTexture()) != null) {
            texture.close();
        }
        if ((object = this.texture) != null && (object = ((Texture)object).getBuffer()) != null) {
            Buffer p0 = (Buffer)object;
            boolean bl = false;
            MemoryUtil.memFree((Buffer)p0);
        }
        this.texture = null;
        this.image = null;
    }

    @JvmOverloads
    @NotNull
    public final Image draw(float x, float y, @Nullable Float width, @Nullable Float height) {
        Pair pair;
        Image image;
        Image $this$draw_u24lambda_u242 = image = this;
        boolean bl = false;
        if (width == null && height == null) {
            pair = TuplesKt.to((Object)Float.valueOf($this$draw_u24lambda_u242.textureWidth), (Object)Float.valueOf($this$draw_u24lambda_u242.textureHeight));
        } else if (width == null) {
            Float f = height;
            Intrinsics.checkNotNull((Object)f);
            pair = TuplesKt.to((Object)Float.valueOf(f.floatValue() / $this$draw_u24lambda_u242.aspectRatio), (Object)height);
        } else {
            pair = height == null ? TuplesKt.to((Object)width, (Object)Float.valueOf(width.floatValue() * $this$draw_u24lambda_u242.aspectRatio)) : TuplesKt.to((Object)width, (Object)height);
        }
        Pair pair2 = pair;
        float drawWidth = ((Number)pair2.component1()).floatValue();
        float drawHeight = ((Number)pair2.component2()).floatValue();
        if ($this$draw_u24lambda_u242.texture != null) {
            Renderer.drawImage($this$draw_u24lambda_u242, x, y, drawWidth, drawHeight);
        }
        return image;
    }

    public static /* synthetic */ Image draw$default(Image image, float f, float f2, Float f3, Float f4, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = null;
        }
        if ((n & 8) != 0) {
            f4 = null;
        }
        return image.draw(f, f2, f3, f4);
    }

    @JvmOverloads
    @NotNull
    public final Image draw(float x, float y, @Nullable Float width) {
        return Image.draw$default(this, x, y, width, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Image draw(float x, float y) {
        return Image.draw$default(this, x, y, null, null, 12, null);
    }

    private static final Unit _init_$lambda$0(Image this$0) {
        BufferedImage bufferedImage = this$0.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        this$0.texture = Image.Companion.toNativeTexture(bufferedImage);
        return Unit.INSTANCE;
    }

    private static final Unit getIdOrRegister$lambda$1(Image this$0) {
        class_1060 class_10602 = Client.getMinecraft().method_1531();
        class_2960 class_29602 = this$0.identifier;
        Intrinsics.checkNotNull((Object)class_29602);
        Texture texture = this$0.texture;
        Intrinsics.checkNotNull((Object)texture);
        class_10602.method_4616(class_29602, (class_1044)texture.getTexture());
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Image fromFile(@NotNull File file) {
        return Companion.fromFile(file);
    }

    @JvmStatic
    @NotNull
    public static final Image fromFile(@NotNull String file) {
        return Companion.fromFile(file);
    }

    @JvmStatic
    @NotNull
    public static final Image fromAsset(@NotNull String name) {
        return Companion.fromAsset(name);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Image fromUrl(@NotNull String url, @Nullable String cachedImageName) {
        return Companion.fromUrl(url, cachedImageName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Image fromUrl(@NotNull String url) {
        return Companion.fromUrl(url);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\nJ#\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0015\u001a\u00020\u0014*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/chattriggers/ctjs/api/render/Image$Companion;", "", "<init>", "()V", "Ljava/io/File;", "file", "Lcom/chattriggers/ctjs/api/render/Image;", "fromFile", "(Ljava/io/File;)Lcom/chattriggers/ctjs/api/render/Image;", "", "(Ljava/lang/String;)Lcom/chattriggers/ctjs/api/render/Image;", "name", "fromAsset", "url", "cachedImageName", "fromUrl", "(Ljava/lang/String;Ljava/lang/String;)Lcom/chattriggers/ctjs/api/render/Image;", "Ljava/awt/image/BufferedImage;", "getImageFromUrl", "(Ljava/lang/String;)Ljava/awt/image/BufferedImage;", "Lcom/chattriggers/ctjs/api/render/Image$Texture;", "toNativeTexture", "(Ljava/awt/image/BufferedImage;)Lcom/chattriggers/ctjs/api/render/Image$Texture;", "", "nextIdentifierIndex", "I", "ctjs"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Image fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Image(ImageIO.read(file));
        }

        @JvmStatic
        @NotNull
        public final Image fromFile(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Image(ImageIO.read(new File(file)));
        }

        @JvmStatic
        @NotNull
        public final Image fromAsset(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Image(ImageIO.read(new File(CTJS.Companion.getAssetsDir(), name)));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Image fromUrl(@NotNull String url, @Nullable String cachedImageName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (cachedImageName == null) {
                return new Image(this.getImageFromUrl(url));
            }
            File resourceFile = new File(CTJS.Companion.getAssetsDir(), cachedImageName);
            if (resourceFile.exists()) {
                return new Image(ImageIO.read(resourceFile));
            }
            BufferedImage image = this.getImageFromUrl(url);
            ImageIO.write((RenderedImage)image, "png", resourceFile);
            return new Image(image);
        }

        public static /* synthetic */ Image fromUrl$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.fromUrl(string, string2);
        }

        private final BufferedImage getImageFromUrl(String url) {
            URLConnection req = CTJS.Companion.makeWebRequest$ctjs$default(CTJS.Companion, url, null, 2, null);
            if (req instanceof HttpURLConnection) {
                ((HttpURLConnection)req).setRequestMethod("GET");
                ((HttpURLConnection)req).setDoOutput(true);
            }
            BufferedImage bufferedImage = ImageIO.read(req.getInputStream());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
            return bufferedImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Texture toNativeTexture(BufferedImage $this$toNativeTexture) {
            Texture texture;
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                ImageIO.write((RenderedImage)$this$toNativeTexture, "png", it);
                ByteBuffer buffer = MemoryUtil.memAlloc((int)it.size());
                buffer.put(it.toByteArray());
                buffer.rewind();
                class_1043 class_10432 = new class_1043(Companion::toNativeTexture$lambda$1$lambda$0, class_1011.method_4324((ByteBuffer)buffer));
                Intrinsics.checkNotNull((Object)buffer);
                texture = new Texture(class_10432, buffer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return texture;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Image fromUrl(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return com.chattriggers.ctjs.api.render.Image$Companion.fromUrl$default(this, url, null, 2, null);
        }

        private static final String toNativeTexture$lambda$1$lambda$0() {
            return "ct:" + UUID.randomUUID();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/chattriggers/ctjs/api/render/Image$Texture;", "", "Lnet/minecraft/class_1043;", "texture", "Ljava/nio/ByteBuffer;", "buffer", "<init>", "(Lnet/minecraft/class_1043;Ljava/nio/ByteBuffer;)V", "component1", "()Lnet/minecraft/class_1043;", "component2", "()Ljava/nio/ByteBuffer;", "copy", "(Lnet/minecraft/class_1043;Ljava/nio/ByteBuffer;)Lcom/chattriggers/ctjs/api/render/Image$Texture;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1043;", "getTexture", "Ljava/nio/ByteBuffer;", "getBuffer", "ctjs"})
    private static final class Texture {
        @NotNull
        private final class_1043 texture;
        @NotNull
        private final ByteBuffer buffer;

        public Texture(@NotNull class_1043 texture, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.texture = texture;
            this.buffer = buffer;
        }

        @NotNull
        public final class_1043 getTexture() {
            return this.texture;
        }

        @NotNull
        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        @NotNull
        public final class_1043 component1() {
            return this.texture;
        }

        @NotNull
        public final ByteBuffer component2() {
            return this.buffer;
        }

        @NotNull
        public final Texture copy(@NotNull class_1043 texture, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new Texture(texture, buffer);
        }

        public static /* synthetic */ Texture copy$default(Texture texture, class_1043 class_10432, ByteBuffer byteBuffer, int n, Object object) {
            if ((n & 1) != 0) {
                class_10432 = texture.texture;
            }
            if ((n & 2) != 0) {
                byteBuffer = texture.buffer;
            }
            return texture.copy(class_10432, byteBuffer);
        }

        @NotNull
        public String toString() {
            return "Texture(texture=" + this.texture + ", buffer=" + this.buffer + ")";
        }

        public int hashCode() {
            int result = this.texture.hashCode();
            result = result * 31 + this.buffer.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Texture)) {
                return false;
            }
            Texture texture = (Texture)other;
            if (!Intrinsics.areEqual((Object)this.texture, (Object)texture.texture)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buffer, (Object)texture.buffer);
        }
    }
}

