/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.render;

import com.chattriggers.ctjs.api.render.Renderer;
import com.chattriggers.ctjs.api.vec.Vec2f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\u0007J\r\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0000\u00a2\u0006\u0004\b\"\u0010\u0007J5\u0010(\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017\u00a2\u0006\u0004\b(\u0010)J-\u0010,\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001c\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0000\u00a2\u0006\u0004\b.\u0010\u0007J\u000f\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b0\u00101R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u0014038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0014038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u00107R\u0016\u00108\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lcom/chattriggers/ctjs/api/render/Shape;", "", "", "color", "<init>", "(J)V", "copy", "()Lcom/chattriggers/ctjs/api/render/Shape;", "clone", "getColor", "()J", "setColor", "(J)Lcom/chattriggers/ctjs/api/render/Shape;", "Lcom/chattriggers/ctjs/api/render/Renderer$DrawMode;", "getDrawMode", "()Lcom/chattriggers/ctjs/api/render/Renderer$DrawMode;", "drawMode", "setDrawMode", "(Lcom/chattriggers/ctjs/api/render/Renderer$DrawMode;)Lcom/chattriggers/ctjs/api/render/Shape;", "", "Lcom/chattriggers/ctjs/api/vec/Vec2f;", "getVertexes", "()Ljava/util/List;", "", "x", "y", "addVertex", "(FF)Lcom/chattriggers/ctjs/api/render/Shape;", "", "index", "insertVertex", "(IFF)Lcom/chattriggers/ctjs/api/render/Shape;", "removeVertex", "(I)Lcom/chattriggers/ctjs/api/render/Shape;", "clearVertices", "x1", "y1", "x2", "y2", "thickness", "setLine", "(FFFFF)Lcom/chattriggers/ctjs/api/render/Shape;", "radius", "steps", "setCircle", "(FFFI)Lcom/chattriggers/ctjs/api/render/Shape;", "draw", "", "updateArea", "()V", "J", "", "vertexes", "Ljava/util/List;", "reversedVertexes", "Lcom/chattriggers/ctjs/api/render/Renderer$DrawMode;", "area", "F", "ctjs"})
@SourceDebugExtension(value={"SMAP\nShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shape.kt\ncom/chattriggers/ctjs/api/render/Shape\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1#2:130\n1869#3,2:131\n1869#3,2:133\n*S KotlinDebug\n*F\n+ 1 Shape.kt\ncom/chattriggers/ctjs/api/render/Shape\n*L\n107#1:131,2\n109#1:133,2\n*E\n"})
public final class Shape {
    private long color;
    @NotNull
    private final List<Vec2f> vertexes;
    @NotNull
    private final List<Vec2f> reversedVertexes;
    @NotNull
    private Renderer.DrawMode drawMode;
    private float area;

    public Shape(long color) {
        this.color = color;
        this.vertexes = new ArrayList();
        this.reversedVertexes = CollectionsKt.asReversedMutable(this.vertexes);
        this.drawMode = Renderer.DrawMode.QUADS;
    }

    @NotNull
    public final Shape copy() {
        return this.clone();
    }

    @NotNull
    public final Shape clone() {
        Shape clone = new Shape(this.color);
        clone.vertexes.addAll((Collection<Vec2f>)this.vertexes);
        clone.setDrawMode(this.drawMode);
        return clone;
    }

    public final long getColor() {
        return this.color;
    }

    @NotNull
    public final Shape setColor(long color) {
        Shape shape;
        Shape $this$setColor_u24lambda_u240 = shape = this;
        boolean bl = false;
        $this$setColor_u24lambda_u240.color = Renderer.fixAlpha(color);
        return shape;
    }

    @NotNull
    public final Renderer.DrawMode getDrawMode() {
        return this.drawMode;
    }

    @NotNull
    public final Shape setDrawMode(@NotNull Renderer.DrawMode drawMode) {
        Shape shape;
        Intrinsics.checkNotNullParameter((Object)((Object)drawMode), (String)"drawMode");
        Shape $this$setDrawMode_u24lambda_u241 = shape = this;
        boolean bl = false;
        $this$setDrawMode_u24lambda_u241.drawMode = drawMode;
        return shape;
    }

    @NotNull
    public final List<Vec2f> getVertexes() {
        return this.vertexes;
    }

    @NotNull
    public final Shape addVertex(float x, float y) {
        Shape shape;
        Shape $this$addVertex_u24lambda_u242 = shape = this;
        boolean bl = false;
        $this$addVertex_u24lambda_u242.vertexes.add(new Vec2f(x, y));
        $this$addVertex_u24lambda_u242.updateArea();
        return shape;
    }

    @NotNull
    public final Shape insertVertex(int index, float x, float y) {
        Shape shape;
        Shape $this$insertVertex_u24lambda_u243 = shape = this;
        boolean bl = false;
        $this$insertVertex_u24lambda_u243.vertexes.add(index, new Vec2f(x, y));
        $this$insertVertex_u24lambda_u243.updateArea();
        return shape;
    }

    @NotNull
    public final Shape removeVertex(int index) {
        Shape shape;
        Shape $this$removeVertex_u24lambda_u244 = shape = this;
        boolean bl = false;
        $this$removeVertex_u24lambda_u244.vertexes.remove(index);
        $this$removeVertex_u24lambda_u244.updateArea();
        return shape;
    }

    @NotNull
    public final Shape clearVertices() {
        Shape shape;
        Shape $this$clearVertices_u24lambda_u245 = shape = this;
        boolean bl = false;
        $this$clearVertices_u24lambda_u245.vertexes.clear();
        $this$clearVertices_u24lambda_u245.area = 0.0f;
        return shape;
    }

    @NotNull
    public final Shape setLine(float x1, float y1, float x2, float y2, float thickness) {
        Shape shape;
        Shape $this$setLine_u24lambda_u246 = shape = this;
        boolean bl = false;
        $this$setLine_u24lambda_u246.vertexes.clear();
        float theta = -((float)Math.atan2(y2 - y1, x2 - x1));
        float i = (float)Math.sin(theta) * (thickness / (float)2);
        float j = (float)Math.cos(theta) * (thickness / (float)2);
        $this$setLine_u24lambda_u246.addVertex(x1 + i, y1 + j);
        $this$setLine_u24lambda_u246.addVertex(x2 + i, y2 + j);
        $this$setLine_u24lambda_u246.addVertex(x2 - i, y2 - j);
        $this$setLine_u24lambda_u246.addVertex(x1 - i, y1 - j);
        $this$setLine_u24lambda_u246.drawMode = Renderer.DrawMode.QUADS;
        return shape;
    }

    @NotNull
    public final Shape setCircle(float x, float y, float radius, int steps) {
        Shape shape;
        Shape $this$setCircle_u24lambda_u247 = shape = this;
        boolean bl = false;
        $this$setCircle_u24lambda_u247.vertexes.clear();
        double theta = Math.PI * 2 / (double)steps;
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        float xHolder = 0.0f;
        float circleX = 1.0f;
        float circleY = 0.0f;
        int i = 0;
        if (i <= steps) {
            while (true) {
                $this$setCircle_u24lambda_u247.addVertex(x, y);
                $this$setCircle_u24lambda_u247.addVertex(circleX * radius + x, circleY * radius + y);
                xHolder = circleX;
                circleX = cos * circleX - sin * circleY;
                circleY = sin * xHolder + cos * circleY;
                $this$setCircle_u24lambda_u247.addVertex(circleX * radius + x, circleY * radius + y);
                if (i == steps) break;
                ++i;
            }
        }
        $this$setCircle_u24lambda_u247.drawMode = Renderer.DrawMode.TRIANGLE_STRIP;
        return shape;
    }

    @NotNull
    public final Shape draw() {
        Renderer renderer;
        Shape shape;
        Shape $this$draw_u24lambda_u2411 = shape = this;
        boolean bl = false;
        Renderer $this$draw_u24lambda_u2411_u24lambda_u2410 = renderer = Renderer.INSTANCE;
        boolean bl2 = false;
        Renderer.begin$default($this$draw_u24lambda_u2411.drawMode, Renderer.VertexFormat.POSITION_COLOR, null, 4, null);
        if ($this$draw_u24lambda_u2411.area < 0.0f) {
            Iterable $this$forEach$iv = $this$draw_u24lambda_u2411.vertexes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec2f it = (Vec2f)element$iv;
                boolean bl3 = false;
                Renderer.pos$default(it.getX(), it.getY(), 0.0f, 4, null);
                Renderer.color($this$draw_u24lambda_u2411.color);
            }
        } else {
            Iterable $this$forEach$iv = $this$draw_u24lambda_u2411.reversedVertexes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec2f it = (Vec2f)element$iv;
                boolean bl4 = false;
                Renderer.pos$default(it.getX(), it.getY(), 0.0f, 4, null);
                Renderer.color($this$draw_u24lambda_u2411.color);
            }
        }
        Renderer.draw();
        return shape;
    }

    private final void updateArea() {
        this.area = 0.0f;
        int n = ((Collection)this.vertexes).size();
        for (int i = 0; i < n; ++i) {
            Vec2f p1 = this.vertexes.get(i);
            Vec2f p2 = this.vertexes.get((i + 1) % this.vertexes.size());
            this.area += p1.getX() * p2.getY() - p2.getX() * p1.getY();
        }
        this.area /= (float)2;
    }
}

