/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.vec;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\bJ\u0010\u0010!\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\bJ$\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\"\u0010\rJ\u001a\u0010$\u001a\u00020#2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010'\u001a\u00020&H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010)\u001a\u0004\b+\u0010\b\u00a8\u0006,"}, d2={"Lcom/chattriggers/ctjs/api/vec/Vec2f;", "", "", "x", "y", "<init>", "(FF)V", "magnitudeSquared", "()F", "magnitude", "dx", "dy", "translated", "(FF)Lcom/chattriggers/ctjs/api/vec/Vec2f;", "scale", "scaled", "(F)Lcom/chattriggers/ctjs/api/vec/Vec2f;", "xScale", "yScale", "other", "dotProduct", "(Lcom/chattriggers/ctjs/api/vec/Vec2f;)F", "angleTo", "normalized", "()Lcom/chattriggers/ctjs/api/vec/Vec2f;", "unaryMinus", "plus", "(Lcom/chattriggers/ctjs/api/vec/Vec2f;)Lcom/chattriggers/ctjs/api/vec/Vec2f;", "minus", "", "toString", "()Ljava/lang/String;", "component1", "component2", "copy", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "F", "getX", "getY", "ctjs"})
public final class Vec2f {
    private final float x;
    private final float y;

    @JvmOverloads
    public Vec2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ Vec2f(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        this(f, f2);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    @NotNull
    public final Vec2f translated(float dx, float dy) {
        return new Vec2f(this.x + dx, this.y + dy);
    }

    @NotNull
    public final Vec2f scaled(float scale) {
        return new Vec2f(this.x * scale, this.y * scale);
    }

    @NotNull
    public final Vec2f scaled(float xScale, float yScale) {
        return new Vec2f(this.x * xScale, this.y * yScale);
    }

    public final float dotProduct(@NotNull Vec2f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y;
    }

    public final float angleTo(@NotNull Vec2f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.acos(this.dotProduct(other) / RangesKt.coerceIn((float)(this.magnitude() * other.magnitude()), (float)-1.0f, (float)1.0f));
    }

    @NotNull
    public final Vec2f normalized() {
        float it = this.magnitude();
        boolean bl = false;
        return new Vec2f(this.x / it, this.y / it);
    }

    @NotNull
    public final Vec2f unaryMinus() {
        return new Vec2f(-this.x, -this.y);
    }

    @NotNull
    public final Vec2f plus(@NotNull Vec2f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec2f(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2f minus(@NotNull Vec2f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.plus(other.unaryMinus());
    }

    @NotNull
    public String toString() {
        return "Vec2f(" + this.x + ", " + this.y + ")";
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    @NotNull
    public final Vec2f copy(float x, float y) {
        return new Vec2f(x, y);
    }

    public static /* synthetic */ Vec2f copy$default(Vec2f vec2f, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = vec2f.x;
        }
        if ((n & 2) != 0) {
            f2 = vec2f.y;
        }
        return vec2f.copy(f, f2);
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vec2f)) {
            return false;
        }
        Vec2f vec2f = (Vec2f)other;
        if (Float.compare(this.x, vec2f.x) != 0) {
            return false;
        }
        return Float.compare(this.y, vec2f.y) == 0;
    }

    @JvmOverloads
    public Vec2f(float x) {
        this(x, 0.0f, 2, null);
    }

    @JvmOverloads
    public Vec2f() {
        this(0.0f, 0.0f, 3, null);
    }
}

