/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.vec;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\tJ%\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0018J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b \u0010\u0018J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b$\u0010\tJ\u0010\u0010%\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b%\u0010\tJ\u0010\u0010&\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010\tJ.\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b'\u0010\u000fJ\u001a\u0010)\u001a\u00020(2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010,\u001a\u00020+H\u00d6\u0001\u00a2\u0006\u0004\b,\u0010-R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010.\u001a\u0004\b/\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010.\u001a\u0004\b0\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010.\u001a\u0004\b1\u0010\t\u00a8\u00062"}, d2={"Lcom/chattriggers/ctjs/api/vec/Vec3f;", "", "", "x", "y", "z", "<init>", "(FFF)V", "magnitudeSquared", "()F", "magnitude", "dx", "dy", "dz", "translated", "(FFF)Lcom/chattriggers/ctjs/api/vec/Vec3f;", "scale", "scaled", "(F)Lcom/chattriggers/ctjs/api/vec/Vec3f;", "xScale", "yScale", "zScale", "other", "crossProduct", "(Lcom/chattriggers/ctjs/api/vec/Vec3f;)Lcom/chattriggers/ctjs/api/vec/Vec3f;", "dotProduct", "(Lcom/chattriggers/ctjs/api/vec/Vec3f;)F", "angleTo", "normalized", "()Lcom/chattriggers/ctjs/api/vec/Vec3f;", "unaryMinus", "plus", "minus", "", "toString", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "F", "getX", "getY", "getZ", "ctjs"})
public final class Vec3f {
    private final float x;
    private final float y;
    private final float z;

    @JvmOverloads
    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Vec3f(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        this(f, f2, f3);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    @NotNull
    public final Vec3f translated(float dx, float dy, float dz) {
        return new Vec3f(this.x + dx, this.y + dy, this.z + dz);
    }

    @NotNull
    public final Vec3f scaled(float scale) {
        return new Vec3f(this.x * scale, this.y * scale, this.z * scale);
    }

    @NotNull
    public final Vec3f scaled(float xScale, float yScale, float zScale) {
        return new Vec3f(this.x * xScale, this.y * yScale, this.z * zScale);
    }

    @NotNull
    public final Vec3f crossProduct(@NotNull Vec3f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3f(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public final float dotProduct(@NotNull Vec3f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final float angleTo(@NotNull Vec3f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.acos(this.dotProduct(other) / RangesKt.coerceIn((float)(this.magnitude() * other.magnitude()), (float)-1.0f, (float)1.0f));
    }

    @NotNull
    public final Vec3f normalized() {
        float it = this.magnitude();
        boolean bl = false;
        return new Vec3f(this.x / it, this.y / it, this.z / it);
    }

    @NotNull
    public final Vec3f unaryMinus() {
        return new Vec3f(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final Vec3f plus(@NotNull Vec3f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3f(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final Vec3f minus(@NotNull Vec3f other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.plus(other.unaryMinus());
    }

    @NotNull
    public String toString() {
        return "Vec3f(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vec3f copy(float x, float y, float z) {
        return new Vec3f(x, y, z);
    }

    public static /* synthetic */ Vec3f copy$default(Vec3f vec3f, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vec3f.x;
        }
        if ((n & 2) != 0) {
            f2 = vec3f.y;
        }
        if ((n & 4) != 0) {
            f3 = vec3f.z;
        }
        return vec3f.copy(f, f2, f3);
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        result = result * 31 + Float.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vec3f)) {
            return false;
        }
        Vec3f vec3f = (Vec3f)other;
        if (Float.compare(this.x, vec3f.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vec3f.y) != 0) {
            return false;
        }
        return Float.compare(this.z, vec3f.z) == 0;
    }

    @JvmOverloads
    public Vec3f(float x, float y) {
        this(x, y, 0.0f, 4, null);
    }

    @JvmOverloads
    public Vec3f(float x) {
        this(x, 0.0f, 0.0f, 6, null);
    }

    @JvmOverloads
    public Vec3f() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }
}

