/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.api.vec;

import com.chattriggers.ctjs.api.vec.Vec3f;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0017\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b$\u0010\u001aJ\u0018\u0010%\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b%\u0010\u001aJ\u000f\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b&\u0010\tJ\u001a\u0010(\u001a\u00020'2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010-\u001a\u0004\b.\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010-\u001a\u0004\b/\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010-\u001a\u0004\b0\u0010\t\u00a8\u00061"}, d2={"Lcom/chattriggers/ctjs/api/vec/Vec3i;", "", "", "x", "y", "z", "<init>", "(III)V", "magnitudeSquared", "()I", "", "magnitude", "()F", "dx", "dy", "dz", "translated", "(III)Lcom/chattriggers/ctjs/api/vec/Vec3i;", "scale", "scaled", "(I)Lcom/chattriggers/ctjs/api/vec/Vec3i;", "xScale", "yScale", "zScale", "other", "crossProduct", "(Lcom/chattriggers/ctjs/api/vec/Vec3i;)Lcom/chattriggers/ctjs/api/vec/Vec3i;", "dotProduct", "(Lcom/chattriggers/ctjs/api/vec/Vec3i;)I", "angleTo", "(Lcom/chattriggers/ctjs/api/vec/Vec3i;)F", "Lcom/chattriggers/ctjs/api/vec/Vec3f;", "normalized", "()Lcom/chattriggers/ctjs/api/vec/Vec3f;", "unaryMinus", "()Lcom/chattriggers/ctjs/api/vec/Vec3i;", "plus", "minus", "hashCode", "", "equals", "(Ljava/lang/Object;)Z", "", "toString", "()Ljava/lang/String;", "I", "getX", "getY", "getZ", "ctjs"})
public class Vec3i {
    private final int x;
    private final int y;
    private final int z;

    @JvmOverloads
    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Vec3i(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final int magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float magnitude() {
        return (float)Math.sqrt(this.magnitudeSquared());
    }

    @NotNull
    public Vec3i translated(int dx, int dy, int dz) {
        return new Vec3i(this.x + dx, this.y + dy, this.z + dz);
    }

    @NotNull
    public Vec3i scaled(int scale) {
        return new Vec3i(this.x * scale, this.y * scale, this.z * scale);
    }

    @NotNull
    public Vec3i scaled(int xScale, int yScale, int zScale) {
        return new Vec3i(this.x * xScale, this.y * yScale, this.z * zScale);
    }

    @NotNull
    public Vec3i crossProduct(@NotNull Vec3i other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3i(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public final int dotProduct(@NotNull Vec3i other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final float angleTo(@NotNull Vec3i other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.acos((float)this.dotProduct(other) / RangesKt.coerceIn((float)(this.magnitude() * other.magnitude()), (float)-1.0f, (float)1.0f));
    }

    @NotNull
    public final Vec3f normalized() {
        float it = this.magnitude();
        boolean bl = false;
        return new Vec3f((float)this.x / it, (float)this.y / it, (float)this.z / it);
    }

    @NotNull
    public Vec3i unaryMinus() {
        return new Vec3i(-this.x, -this.y, -this.z);
    }

    @NotNull
    public Vec3i plus(@NotNull Vec3i other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3i(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public Vec3i minus(@NotNull Vec3i other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.plus(other.unaryMinus());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.x, this.y, this.z};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Vec3i && this.x == ((Vec3i)other).x && this.y == ((Vec3i)other).y && this.z == ((Vec3i)other).z;
    }

    @NotNull
    public String toString() {
        return "Vec3i(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    @JvmOverloads
    public Vec3i(int x, int y) {
        this(x, y, 0, 4, null);
    }

    @JvmOverloads
    public Vec3i(int x) {
        this(x, 0, 0, 6, null);
    }

    @JvmOverloads
    public Vec3i() {
        this(0, 0, 0, 7, null);
    }
}

