/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.commands;

import com.chattriggers.ctjs.api.message.ChatLib;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u00120\u00112\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R&\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001aR\u0014\u0010 \u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001aR\u0014\u0010!\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001aR\u0014\u0010\"\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001aR\u0014\u0010#\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u001aR\u0014\u0010$\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001aR\u0014\u0010%\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u001aR\u0014\u0010&\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u001aR\u0014\u0010'\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\u001a\u00a8\u0006("}, d2={"Lcom/chattriggers/ctjs/internal/commands/Migration;", "", "<init>", "()V", "Ljava/io/File;", "input", "output", "", "migrate", "(Ljava/io/File;Ljava/io/File;)V", "migrateFile", "file", "", "inputText", "checkForErrors", "(Ljava/io/File;Ljava/lang/String;)V", "text", "", "Lkotlin/Pair;", "", "collectErrors", "(Ljava/lang/String;)Ljava/util/List;", "Lkotlin/text/Regex;", "migrationPatterns", "Ljava/util/List;", "removedTriggersRegex", "Lkotlin/text/Regex;", "guiMouseClickRegex", "guiMouseDragRegex", "guiOpenedRegex", "renderBlockEntityRegex", "serverConnectRegex", "scrolledRegex", "dropItemRegex", "renderEntityRegex", "spawnParticleRegex", "ctCopyRegex", "getRiderRegex", "isAirborneRegex", "getDimensionRegex", "ctjs"})
@SourceDebugExtension(value={"SMAP\nMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Migration.kt\ncom/chattriggers/ctjs/internal/commands/Migration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,212:1\n1#2:213\n1321#3,2:214\n1321#3,2:230\n1321#3,2:232\n1321#3,2:234\n774#4:216\n865#4,2:217\n1563#4:219\n1634#4,3:220\n360#4,7:223\n1563#4:236\n1634#4,3:237\n1563#4:244\n1634#4,3:245\n37#5:240\n36#5,3:241\n37#5:248\n36#5,3:249\n*S KotlinDebug\n*F\n+ 1 Migration.kt\ncom/chattriggers/ctjs/internal/commands/Migration\n*L\n106#1:214,2\n151#1:230,2\n156#1:232,2\n162#1:234,2\n132#1:216\n132#1:217,2\n132#1:219\n132#1:220,3\n135#1:223,7\n26#1:236\n26#1:237,3\n30#1:244\n30#1:245,3\n28#1:240\n28#1:241,3\n32#1:248\n32#1:249,3\n*E\n"})
public final class Migration {
    @NotNull
    public static final Migration INSTANCE;
    @NotNull
    private static final List<Pair<Regex, String>> migrationPatterns;
    @NotNull
    private static final Regex removedTriggersRegex;
    @NotNull
    private static final Regex guiMouseClickRegex;
    @NotNull
    private static final Regex guiMouseDragRegex;
    @NotNull
    private static final Regex guiOpenedRegex;
    @NotNull
    private static final Regex renderBlockEntityRegex;
    @NotNull
    private static final Regex serverConnectRegex;
    @NotNull
    private static final Regex scrolledRegex;
    @NotNull
    private static final Regex dropItemRegex;
    @NotNull
    private static final Regex renderEntityRegex;
    @NotNull
    private static final Regex spawnParticleRegex;
    @NotNull
    private static final Regex ctCopyRegex;
    @NotNull
    private static final Regex getRiderRegex;
    @NotNull
    private static final Regex isAirborneRegex;
    @NotNull
    private static final Regex getDimensionRegex;

    private Migration() {
    }

    public final void migrate(@NotNull File input, @NotNull File output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (!input.exists()) {
            boolean $i$a$-require-Migration$migrate$32 = false;
            String $i$a$-require-Migration$migrate$32 = "Input file \"" + input + "\" does not exist";
            throw new IllegalArgumentException($i$a$-require-Migration$migrate$32.toString());
        }
        if (!Intrinsics.areEqual((Object)input, (Object)output)) {
            if (!(!output.exists())) {
                boolean $i$a$-require-Migration$migrate$42 = false;
                String $i$a$-require-Migration$migrate$42 = "Output file \"" + output + "\" already exists";
                throw new IllegalArgumentException($i$a$-require-Migration$migrate$42.toString());
            }
            output.getParentFile().mkdirs();
        }
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk((File)input, (FileWalkDirection)FileWalkDirection.TOP_DOWN);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            File dest = new File(output, FilesKt.toRelativeString((File)it, (File)input));
            if (it.isFile()) {
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"js")) {
                    INSTANCE.migrateFile(it, dest);
                    continue;
                }
                Files.copy(it.toPath(), dest.toPath(), new CopyOption[0]);
                continue;
            }
            dest.mkdir();
        }
    }

    private final void migrateFile(File input, File output) {
        String text = FilesKt.readText$default((File)input, null, (int)1, null);
        for (Pair<Regex, String> pair : migrationPatterns) {
            Regex regex = (Regex)pair.component1();
            String replacement = (String)pair.component2();
            text = regex.replace((CharSequence)text, replacement);
        }
        this.checkForErrors(output, text);
        FilesKt.writeText$default((File)output, (String)text, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForErrors(File file, String inputText) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IndexedValue it;
        void $this$filterTo$iv$iv;
        String text = StringsKt.replace$default((String)StringsKt.replace$default((String)inputText, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (char)'\r', (char)'\n', (boolean)false, (int)4, null);
        List<Pair<Integer, String>> errors = this.collectErrors(text);
        Iterable $this$filter$iv = StringsKt.withIndex((CharSequence)text);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!(((Character)it.getValue()).charValue() == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIndex());
        }
        List nlIndices = (List)destination$iv$iv;
        for (Pair<Integer, String> error : errors) {
            int n;
            block9: {
                List $this$indexOfFirst$iv = nlIndices;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    int it2 = ((Number)item$iv).intValue();
                    boolean bl = false;
                    if (it2 > ((Number)error.getFirst()).intValue()) {
                        n = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            Pair pair = switch (index) {
                case -1 -> TuplesKt.to((Object)nlIndices.size(), (Object)(((Number)error.getFirst()).intValue() - ((Number)CollectionsKt.last((List)nlIndices)).intValue() + 1));
                case 0 -> TuplesKt.to((Object)1, (Object)(((Number)error.getFirst()).intValue() + 1));
                default -> TuplesKt.to((Object)index, (Object)(((Number)error.getFirst()).intValue() - ((Number)nlIndices.get(index - 1)).intValue() + 1));
            };
            int line = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            ChatLib.chat("[" + file.getParentFile().getName() + File.separatorChar + file.getName() + ":" + line + ":" + column + "] " + error.getSecond());
        }
        ChatLib.chat("&oNote: The migrated files are not guaranteed to work");
    }

    private final List<Pair<Integer, String>> collectErrors(String text) {
        List errors = new ArrayList();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)removedTriggersRegex, (CharSequence)text, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            MatchGroup matchGroup = it.getGroups().get(0);
            Intrinsics.checkNotNull((Object)matchGroup);
            Integer n = matchGroup.getRange().getFirst();
            MatchGroup matchGroup2 = it.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup2);
            errors.add(TuplesKt.to((Object)n, (Object)("&6Warning: trigger \"" + matchGroup2.getValue() + "\" was removed")));
        }
        Migration.collectErrors$warn(guiMouseClickRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$12));
        Migration.collectErrors$warn(guiMouseDragRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$13));
        Migration.collectErrors$warn(guiOpenedRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$14));
        Migration.collectErrors$warn(renderBlockEntityRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$15));
        Migration.collectErrors$warn(serverConnectRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$16));
        Migration.collectErrors$warn(scrolledRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$17));
        Migration.collectErrors$warn(dropItemRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$18));
        Migration.collectErrors$warn(renderEntityRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$19));
        Migration.collectErrors$warn(spawnParticleRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$20));
        Migration.collectErrors$error(ctCopyRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$21));
        Migration.collectErrors$error(getRiderRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$22));
        Migration.collectErrors$error(isAirborneRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$23));
        Migration.collectErrors$warn(getDimensionRegex, text, errors, (Function1<? super MatchResult, String>)((Function1)Migration::collectErrors$lambda$24));
        return errors;
    }

    private static final void collectErrors$warn(Regex $this$collectErrors_u24warn, String $text, List<Pair<Integer, String>> errors, Function1<? super MatchResult, String> block) {
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)$this$collectErrors_u24warn, (CharSequence)$text, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            MatchGroup matchGroup = it.getGroups().get(0);
            Intrinsics.checkNotNull((Object)matchGroup);
            errors.add((Pair<Integer, String>)TuplesKt.to((Object)matchGroup.getRange().getFirst(), (Object)("&6Warning: " + block.invoke((Object)it))));
        }
    }

    private static final void collectErrors$error(Regex $this$collectErrors_u24error, String $text, List<Pair<Integer, String>> errors, Function1<? super MatchResult, String> block) {
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)$this$collectErrors_u24error, (CharSequence)$text, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            MatchGroup matchGroup = it.getGroups().get(0);
            Intrinsics.checkNotNull((Object)matchGroup);
            errors.add((Pair<Integer, String>)TuplesKt.to((Object)matchGroup.getRange().getFirst(), (Object)("&cError: " + block.invoke((Object)it))));
        }
    }

    private static final String collectErrors$lambda$12(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"guiMouseClick\" activates for both click and release now, and takes an additional boolean parameter to distinguish the two";
    }

    private static final String collectErrors$lambda$13(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"guiMouseDrag\" now takes two extra parameters at the start: dx and dy";
    }

    private static final String collectErrors$lambda$14(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"guiOpened\" now takes a Screen as its first argument";
    }

    private static final String collectErrors$lambda$15(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"renderBlockEntity\" no longer passes in the entity's position as an argument. Access it by calling `<entity>.getBlockPos()`";
    }

    private static final String collectErrors$lambda$16(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MatchGroup matchGroup = it.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        return "trigger \"" + matchGroup.getValue() + "\" no longer passes an event as the third parameter";
    }

    private static final String collectErrors$lambda$17(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"scrolled\" now passes in the total delta, not just 1 or -1";
    }

    private static final String collectErrors$lambda$18(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"dropItem\" now takes different parameters. Check the migration docs for more info";
    }

    private static final String collectErrors$lambda$19(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"renderEntity\" no longer takes the entity's position as an argument. Use `<entity>.getPos()` instead";
    }

    private static final String collectErrors$lambda$20(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "trigger \"spawnParticle\" no longer passes in the particle type. Instead, compare the particle's Minecraft class (i.e. `<particle>.toMC() instanceof ...`)";
    }

    private static final String collectErrors$lambda$21(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`/ct copy` no longer exists. Use Client.copy() instead";
    }

    private static final String collectErrors$lambda$22(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`Entity.getRider()` no longer exists. Replace with `Entity.getRiders()`";
    }

    private static final String collectErrors$lambda$23(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`Entity.isAirborne()` no longer exists";
    }

    private static final String collectErrors$lambda$24(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`Entity.getDimension()` now returns `Entity.DimensionType` instead of a number";
    }

    /*
     * WARNING - void declaration
     */
    static {
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        INSTANCE = new Migration();
        SpreadBuilder spreadBuilder = new SpreadBuilder(24);
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("Renderer\\.color\\("), (Object)"Renderer.getColor("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("register\\((['\"`])renderTileEntity['\"`]", RegexOption.IGNORE_CASE), (Object)"register($1renderBlockEntity$1"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.setPacketClass\\("), (Object)".setFilteredClass("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.setPacketClasses\\("), (Object)".setFilteredClasses("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("EventLib\\.cancel\\((.+?)\\)"), (Object)"cancel($1)"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("EventLib\\.getMessage\\((.+?)\\)"), (Object)"$1.message"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("EntityLivingBase"), (Object)"LivingEntity"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.getItemInSlot\\("), (Object)".getStackInSlot("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("TileEntity"), (Object)"BlockEntity"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.isDurationMax\\("), (Object)".isInfinite("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.isDamagable\\("), (Object)".isDamageable("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.getAllTileEntities\\(\\)"), (Object)".getAllBlockEntities()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.getAllTileEntitiesOfType\\("), (Object)".getAllBlockEntitiesOfType("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.isPowered\\(\\)"), (Object)".isReceivingPower()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.getRedstoneStrength\\(\\)"), (Object)".getReceivingPower()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("\\.fromMCEnumFacing\\("), (Object)".fromMC("));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("Scoreboard\\.getScoreboardTitle\\(\\)"), (Object)"Scoreboard.getTitle()"));
        Object object = new String[]{"Cape", "Jacket", "LeftSleeve", "RightSleeve", "LeftPantsLeg", "RightPantsLeg", "Hat"};
        object = CollectionsKt.listOf((Object[])object);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new Regex("Settings\\.skin\\.get" + it + "\\(\\)"), (Object)("Settings.skin.is" + it + "Enabled")));
        }
        Object $this$toTypedArray$iv = (Object[])((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Object[] thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("GuiHandler\\.openGui\\((.+?)\\)"), (Object)"Client.currentGui.set($1)"));
        $this$toTypedArray$iv = new String[]{"Control", "Alt", "Shift"};
        $this$toTypedArray$iv = CollectionsKt.listOf((Object[])$this$toTypedArray$iv);
        spreadBuilder2 = spreadBuilder;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new Regex("\\.is" + it + "Down\\(\\)"), (Object)(".has" + it + "Down()")));
        }
        $this$toTypedArray$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("TabList\\.getFooterMessage\\(\\)"), (Object)"TabList.getFooterComponent()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("TabList\\.getHeaderMessage\\(\\)"), (Object)"TabList.getHeaderComponent()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("Client\\.getChatGUI\\(\\)"), (Object)"Client.getChatGui()"));
        spreadBuilder.add((Object)TuplesKt.to((Object)new Regex("Config\\.modulesFolder"), (Object)"ChatTriggers.MODULES_FOLDER"));
        migrationPatterns = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Pair[spreadBuilder.size()]));
        Migration it2 = INSTANCE;
        boolean bl = false;
        objectArray = new String[]{"screenshotTaken", "pickupItem", "chatComponentClicked", "chatComponentHovered", "renderSlot", "guiDrawBackground", "renderBossHealth", "renderDebug", "renderCrosshair", "renderHotbar", "renderExperience", "renderArmor", "renderHealth", "renderFood", "renderMountHealth", "renderAir", "renderPortal", "renderJumpBar", "renderChat", "renderHelmet", "renderHand", "renderScoreboard", "renderTitle", "preItemRender", "renderItemIntoGui", "noteBlockPlay", "noteBlockChange", "renderItemOverlayIntoGui", "renderSlotHighlight", "postRenderEntity", "postRenderTileEntity", "attackEntity", "hitBlock", "blockBreak", "guiMouseRelease"};
        Set triggers = SetsKt.setOf((Object[])objectArray);
        removedTriggersRegex = new Regex(StringsKt.trimIndent((String)("\n            register\\(['\"`](" + CollectionsKt.joinToString$default((Iterable)triggers, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")['\"`]\n        ")), RegexOption.IGNORE_CASE);
        guiMouseClickRegex = new Regex("register\\(['\"`]guiMouseClick['\"`]", RegexOption.IGNORE_CASE);
        guiMouseDragRegex = new Regex("register\\(['\"`]guiMouseDrag['\"`]", RegexOption.IGNORE_CASE);
        guiOpenedRegex = new Regex("register\\(['\"`]guiOpened['\"`]", RegexOption.IGNORE_CASE);
        renderBlockEntityRegex = new Regex("register\\(['\"`]renderBlockEntity['\"`]", RegexOption.IGNORE_CASE);
        serverConnectRegex = new Regex("register\\(['\"`](serverConnect|serverDisconnect)['\"`]", RegexOption.IGNORE_CASE);
        scrolledRegex = new Regex("register\\(['\"`]scrolled['\"`]", RegexOption.IGNORE_CASE);
        dropItemRegex = new Regex("register\\(['\"`]dropItem['\"`]", RegexOption.IGNORE_CASE);
        renderEntityRegex = new Regex("register\\(['\"`]renderEntity['\"`]", RegexOption.IGNORE_CASE);
        spawnParticleRegex = new Regex("register\\(['\"`]spawnParticle['\"`]", RegexOption.IGNORE_CASE);
        ctCopyRegex = new Regex("(ChatLib\\.command\\(['\"`]ct copy|ChatLib\\.say\\(['\"`]/ct copy)");
        getRiderRegex = new Regex("\\.getRider\\(\\)");
        isAirborneRegex = new Regex("\\.isAirborne\\(\\)");
        getDimensionRegex = new Regex("\\.getDimension\\(\\)");
    }
}

