/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.console;

import com.chattriggers.ctjs.engine.LogType;
import com.chattriggers.ctjs.internal.console.ConfigUpdateMessage;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J7\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010(\u00a8\u0006)"}, d2={"Lcom/chattriggers/ctjs/internal/console/TextAreaWriter;", "Ljava/io/Writer;", "Ljavax/swing/JTextPane;", "textArea", "Lkotlin/Function0;", "Lcom/chattriggers/ctjs/internal/console/ConfigUpdateMessage;", "configGetter", "<init>", "(Ljavax/swing/JTextPane;Lkotlin/jvm/functions/Function0;)V", "", "cbuf", "", "off", "len", "", "write", "([CII)V", "flush", "()V", "close", "", "s", "Lcom/chattriggers/ctjs/engine/LogType;", "logType", "", "end", "Ljava/awt/Color;", "customColor", "println", "(Ljava/lang/Object;Lcom/chattriggers/ctjs/engine/LogType;Ljava/lang/String;Ljava/awt/Color;)V", "clear", "Ljavax/swing/JTextPane;", "Lkotlin/jvm/functions/Function0;", "Ljava/io/PrintWriter;", "printWriter", "Ljava/io/PrintWriter;", "getPrintWriter", "()Ljava/io/PrintWriter;", "currentLogType", "Lcom/chattriggers/ctjs/engine/LogType;", "Ljava/awt/Color;", "ctjs"})
public final class TextAreaWriter
extends Writer {
    @NotNull
    private final JTextPane textArea;
    @NotNull
    private final Function0<ConfigUpdateMessage> configGetter;
    @NotNull
    private final PrintWriter printWriter;
    @NotNull
    private LogType currentLogType;
    @Nullable
    private Color customColor;

    public TextAreaWriter(@NotNull JTextPane textArea, @NotNull Function0<ConfigUpdateMessage> configGetter) {
        Intrinsics.checkNotNullParameter((Object)textArea, (String)"textArea");
        Intrinsics.checkNotNullParameter(configGetter, (String)"configGetter");
        this.textArea = textArea;
        this.configGetter = configGetter;
        this.printWriter = new PrintWriter(this);
        this.currentLogType = LogType.INFO;
    }

    @NotNull
    public final PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        String s = new String(cbuf, off, len);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        ConfigUpdateMessage config = (ConfigUpdateMessage)this.configGetter.invoke();
        Color color = this.customColor;
        if (color == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentLogType.ordinal()]) {
                case 1: {
                    color = new Color(config.getTextColor());
                    break;
                }
                case 2: {
                    color = new Color(config.getWarningColor());
                    break;
                }
                case 3: {
                    color = new Color(config.getErrorColor());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Color color2 = color;
        AttributeSet attributeSet = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color2);
        Intrinsics.checkNotNullExpressionValue((Object)attributeSet, (String)"addAttribute(...)");
        AttributeSet attributes = attributeSet;
        this.textArea.getDocument().insertString(this.textArea.getDocument().getLength(), s, attributes);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.currentLogType = LogType.INFO;
        this.customColor = null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType, @NotNull String end, @Nullable Color customColor) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.currentLogType = logType;
        this.customColor = customColor;
        this.printWriter.print(s);
        this.printWriter.print(end);
    }

    public static /* synthetic */ void println$default(TextAreaWriter textAreaWriter, Object object, LogType logType, String string, Color color, int n, Object object2) {
        if ((n & 2) != 0) {
            logType = LogType.INFO;
        }
        if ((n & 4) != 0) {
            string = "\n";
        }
        if ((n & 8) != 0) {
            color = null;
        }
        textAreaWriter.println(object, logType, string, color);
    }

    public final void clear() {
        this.textArea.setText("");
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType, @NotNull String end) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        TextAreaWriter.println$default(this, s, logType, end, null, 8, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object s, @NotNull LogType logType) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        TextAreaWriter.println$default(this, s, logType, null, null, 12, null);
    }

    @JvmOverloads
    public final void println(@NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        TextAreaWriter.println$default(this, s, null, null, null, 14, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogType.values().length];
            try {
                nArray[LogType.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

