/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.engine.module;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.api.Config;
import com.chattriggers.ctjs.api.message.ChatLib;
import com.chattriggers.ctjs.engine.ConsoleKt;
import com.chattriggers.ctjs.engine.LogType;
import com.chattriggers.ctjs.internal.engine.CTEvents;
import com.chattriggers.ctjs.internal.engine.module.Module;
import com.chattriggers.ctjs.internal.engine.module.ModuleManager;
import com.chattriggers.ctjs.internal.engine.module.ModuleMetadata;
import com.chattriggers.ctjs.internal.utils.ExtensionsKt;
import com.chattriggers.ctjs.internal.utils.Initializer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/chattriggers/ctjs/internal/engine/module/ModuleUpdater;", "Lcom/chattriggers/ctjs/internal/utils/Initializer;", "<init>", "()V", "", "init", "Lcom/chattriggers/ctjs/internal/engine/module/ModuleMetadata;", "module", "tryReportChangelog", "(Lcom/chattriggers/ctjs/internal/engine/module/ModuleMetadata;)V", "reportChangelog", "Lcom/chattriggers/ctjs/internal/engine/module/Module;", "updateModule", "(Lcom/chattriggers/ctjs/internal/engine/module/Module;)V", "", "moduleName", "requiredBy", "", "importModule", "(Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "name", "Lcom/chattriggers/ctjs/internal/engine/module/ModuleUpdater$DownloadResult;", "downloadModule", "(Ljava/lang/String;)Lcom/chattriggers/ctjs/internal/engine/module/ModuleUpdater$DownloadResult;", "", "changelogs", "Ljava/util/List;", "", "shouldReportChangelog", "Z", "DownloadResult", "ctjs"})
@SourceDebugExtension(value={"SMAP\nModuleUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleUpdater.kt\ncom/chattriggers/ctjs/internal/engine/module/ModuleUpdater\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n222#2:156\n222#2:157\n1761#3,3:158\n1563#3:161\n1634#3,3:162\n1869#3,2:166\n1#4:165\n*S KotlinDebug\n*F\n+ 1 ModuleUpdater.kt\ncom/chattriggers/ctjs/internal/engine/module/ModuleUpdater\n*L\n64#1:156\n78#1:157\n90#1:158,3\n115#1:161\n115#1:162,3\n31#1:166,2\n*E\n"})
public final class ModuleUpdater
implements Initializer {
    @NotNull
    public static final ModuleUpdater INSTANCE = new ModuleUpdater();
    @NotNull
    private static final List<ModuleMetadata> changelogs = new ArrayList();
    private static boolean shouldReportChangelog;

    private ModuleUpdater() {
    }

    @Override
    public void init() {
        ClientPlayConnectionEvents.JOIN.register(ModuleUpdater::init$lambda$0);
        CTEvents.RENDER_OVERLAY.register(ModuleUpdater::init$lambda$1);
    }

    private final void tryReportChangelog(ModuleMetadata module) {
        if (shouldReportChangelog) {
            this.reportChangelog(module);
        } else {
            changelogs.add(module);
        }
    }

    private final void reportChangelog(ModuleMetadata module) {
        ChatLib.chat("&a[ChatTriggers] " + module.getName() + " has updated to version " + module.getVersion());
        ChatLib.chat("&aChangelog: &r" + module.getChangelog());
    }

    /*
     * WARNING - void declaration
     */
    public final void updateModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!Config.getAutoUpdateModules()) {
            return;
        }
        ModuleMetadata metadata = module.getMetadata();
        try {
            void this_$iv;
            void it;
            if (metadata.getName() == null) {
                return;
            }
            ConsoleKt.printToConsole$default("Checking for update in " + metadata.getName(), null, 1, null);
            String url = "https://www.chattriggers.com/api/modules/" + metadata.getName() + "/metadata?modVersion=3.0.0-beta";
            URLConnection connection = CTJS.Companion.makeWebRequest$ctjs$default(CTJS.Companion, url, null, 2, null);
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String newMetadataText = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            Json this_$iv2 = CTJS.Companion.getJson$ctjs();
            boolean $i$f$decodeFromString22 = false;
            this_$iv2.getSerializersModule();
            ModuleMetadata newMetadata = (ModuleMetadata)this_$iv2.decodeFromString((DeserializationStrategy)ModuleMetadata.Companion.serializer(), newMetadataText);
            if (newMetadata.getVersion() == null) {
                ConsoleKt.printToConsole("Remote version of module " + metadata.getName() + " has no version numbers, so it will not be updated!", LogType.WARN);
                return;
            }
            if (metadata.getVersion() != null && ExtensionsKt.toVersion(metadata.getVersion()).compareTo(ExtensionsKt.toVersion(newMetadata.getVersion())) >= 0) {
                return;
            }
            this.downloadModule(metadata.getName());
            ConsoleKt.printToConsole$default("Updated module " + metadata.getName(), null, 1, null);
            File $i$f$decodeFromString22 = new File(module.getFolder(), "metadata.json");
            Module module2 = module;
            boolean bl = false;
            Json json = CTJS.Companion.getJson$ctjs();
            String string$iv = FilesKt.readText$default((File)it, null, (int)1, null);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            module2.setMetadata((ModuleMetadata)this_$iv.decodeFromString((DeserializationStrategy)ModuleMetadata.Companion.serializer(), string$iv));
            if (Config.getModuleChangelog() && module.getMetadata().getChangelog() != null) {
                this.tryReportChangelog(module.getMetadata());
            }
        }
        catch (Exception e) {
            ConsoleKt.printToConsole("Can't find page for " + metadata.getName(), LogType.WARN);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<Module> importModule(@NotNull String moduleName, @Nullable String requiredBy) {
        Iterable iterable;
        boolean alreadyImported;
        block12: {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Iterable $this$any$iv = ModuleManager.INSTANCE.getCachedModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl;
                    Module it = (Module)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.equals((String)it.getName(), (String)moduleName, (boolean)true)) {
                        if (requiredBy != null) {
                            it.getMetadata().setRequired(true);
                            it.getRequiredBy().add(requiredBy);
                        }
                        bl = true;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    v0 = true;
                    break block12;
                }
                v0 = alreadyImported = false;
            }
        }
        if (alreadyImported) {
            return CollectionsKt.emptyList();
        }
        DownloadResult downloadResult = this.downloadModule(moduleName);
        if (downloadResult == null) {
            return CollectionsKt.emptyList();
        }
        DownloadResult downloadResult2 = downloadResult;
        String realName = downloadResult2.component1();
        String modVersion = downloadResult2.component2();
        File moduleDir = new File(ModuleManager.INSTANCE.getModulesFolder(), realName);
        Module module = ModuleManager.INSTANCE.parseModule(moduleDir);
        module.setTargetModVersion(ExtensionsKt.toVersion(modVersion));
        if (requiredBy != null) {
            module.getMetadata().setRequired(true);
            module.getRequiredBy().add(requiredBy);
        }
        ModuleManager.INSTANCE.getCachedModules().add(module);
        Collection collection = CollectionsKt.listOf((Object)module);
        List<String> list = module.getMetadata().getRequires();
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable2 = list;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var12_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(INSTANCE.importModule((String)it, module.getName()));
            }
            collection = collection2;
            list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            if (list != null) {
                iterable = list;
                return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
            }
        }
        iterable = CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
    }

    public static /* synthetic */ List importModule$default(ModuleUpdater moduleUpdater, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return moduleUpdater.importModule(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DownloadResult downloadModule(String name) {
        block12: {
            File downloadZip = new File(ModuleManager.INSTANCE.getModulesFolder(), "currDownload.zip");
            try {
                DownloadResult downloadResult;
                String url = "https://www.chattriggers.com/api/modules/" + name + "/scripts?modVersion=3.0.0-beta";
                URLConnection connection = CTJS.Companion.makeWebRequest$ctjs$default(CTJS.Companion, url, null, 2, null);
                FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)downloadZip);
                Closeable closeable = FileSystems.newFileSystem(downloadZip.toPath());
                Throwable throwable = null;
                try {
                    FileSystem it = (FileSystem)closeable;
                    boolean bl = false;
                    Iterable<Path> iterable = it.getRootDirectories();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                    Iterator<Path> iterator = Files.newDirectoryStream((Path)CollectionsKt.first(iterable)).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator<Path> rootFolder = iterator;
                    if (!rootFolder.hasNext()) {
                        throw new Exception("Too small");
                    }
                    Path moduleFolder = rootFolder.next();
                    if (rootFolder.hasNext()) {
                        throw new Exception("Too big");
                    }
                    Object object = new char[]{File.separatorChar};
                    String realName = StringsKt.trimEnd((String)((Object)moduleFolder.getFileName()).toString(), (char[])object);
                    char[] $this$downloadModule_u24lambda_u248_u24lambda_u245 = object = (Object)new File(ModuleManager.INSTANCE.getModulesFolder(), realName);
                    boolean bl2 = false;
                    $this$downloadModule_u24lambda_u248_u24lambda_u245.mkdir();
                    Files.walk(moduleFolder, new FileVisitOption[0]).forEach(arg_0 -> ModuleUpdater.downloadModule$lambda$8$lambda$7(ModuleUpdater::downloadModule$lambda$8$lambda$6, arg_0));
                    String string = connection.getHeaderField("CT-Version");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHeaderField(...)");
                    downloadResult = new DownloadResult(realName, string);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Exception exception) {
                        ConsoleKt.printTraceToConsole(exception);
                        break block12;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                DownloadResult downloadResult2 = downloadResult;
                return downloadResult2;
            }
            finally {
                downloadZip.delete();
            }
        }
        return null;
    }

    private static final void init$lambda$0(class_634 class_6342, PacketSender packetSender, class_310 class_3102) {
        shouldReportChangelog = true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void init$lambda$1(class_332 class_3322, class_4587 class_45872, float f) {
        Intrinsics.checkNotNullParameter((Object)class_3322, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)class_45872, (String)"<unused var>");
        if (shouldReportChangelog) {
            void $this$forEach$iv;
            Iterable iterable = changelogs;
            ModuleUpdater moduleUpdater = INSTANCE;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleMetadata p0 = (ModuleMetadata)element$iv;
                boolean bl = false;
                moduleUpdater.reportChangelog(p0);
            }
            changelogs.clear();
        }
    }

    private static final Unit downloadModule$lambda$8$lambda$6(Path path) {
        Object[] objectArray = new String[]{((Object)path).toString()};
        Path resolvedPath = Paths.get("./config/ChatTriggers/modules", (String[])objectArray);
        if (Files.isDirectory(resolvedPath, new LinkOption[0])) {
            return Unit.INSTANCE;
        }
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(path, resolvedPath, (CopyOption[])objectArray);
        return Unit.INSTANCE;
    }

    private static final void downloadModule$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/chattriggers/ctjs/internal/engine/module/ModuleUpdater$DownloadResult;", "", "", "name", "modVersion", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lcom/chattriggers/ctjs/internal/engine/module/ModuleUpdater$DownloadResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getName", "getModVersion", "ctjs"})
    public static final class DownloadResult {
        @NotNull
        private final String name;
        @NotNull
        private final String modVersion;

        public DownloadResult(@NotNull String name, @NotNull String modVersion) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modVersion, (String)"modVersion");
            this.name = name;
            this.modVersion = modVersion;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getModVersion() {
            return this.modVersion;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.modVersion;
        }

        @NotNull
        public final DownloadResult copy(@NotNull String name, @NotNull String modVersion) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modVersion, (String)"modVersion");
            return new DownloadResult(name, modVersion);
        }

        public static /* synthetic */ DownloadResult copy$default(DownloadResult downloadResult, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadResult.name;
            }
            if ((n & 2) != 0) {
                string2 = downloadResult.modVersion;
            }
            return downloadResult.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DownloadResult(name=" + this.name + ", modVersion=" + this.modVersion + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.modVersion.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadResult)) {
                return false;
            }
            DownloadResult downloadResult = (DownloadResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)downloadResult.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modVersion, (Object)downloadResult.modVersion);
        }
    }
}

