/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.launch;

import com.chattriggers.ctjs.api.Mappings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.JavaObjectMappingProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J?\u0010\u0013\u001a\u00020\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0018\u001a\u00020\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J?\u0010\u001a\u001a\u00020\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0014J9\u0010\u001b\u001a\u00020\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/chattriggers/ctjs/internal/launch/CTJavaObjectMappingProvider;", "Lorg/mozilla/javascript/JavaObjectMappingProvider;", "<init>", "()V", "", "className", "mapClassName", "(Ljava/lang/String;)Ljava/lang/String;", "unmapClassName", "Ljava/lang/Class;", "clazz", "", "Lorg/mozilla/javascript/JavaObjectMappingProvider$MethodSignature;", "Lorg/mozilla/javascript/JavaObjectMappingProvider$RenameableMethod;", "map", "", "includeProtected", "includePrivate", "", "findExtraMethods", "(Ljava/lang/Class;Ljava/util/Map;ZZ)V", "", "Lorg/mozilla/javascript/JavaObjectMappingProvider$RenameableField;", "list", "findExtraFields", "(Ljava/lang/Class;Ljava/util/List;ZZ)V", "findRemappedMethods", "findRemappedFields", "ctjs"})
public final class CTJavaObjectMappingProvider
implements JavaObjectMappingProvider {
    @NotNull
    public static final CTJavaObjectMappingProvider INSTANCE = new CTJavaObjectMappingProvider();

    private CTJavaObjectMappingProvider() {
    }

    @Nullable
    public String mapClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String string = Mappings.mapClassName(className);
        return string != null ? StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null) : null;
    }

    @Nullable
    public String unmapClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String string = Mappings.unmapClassName(className);
        return string != null ? StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null) : null;
    }

    public void findExtraMethods(@NotNull Class<?> clazz, @NotNull Map<JavaObjectMappingProvider.MethodSignature, JavaObjectMappingProvider.RenameableMethod> map, boolean includeProtected, boolean includePrivate) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        ArrayDeque queue = new ArrayDeque();
        Class current = clazz;
        while (current != null) {
            this.findRemappedMethods(current, map, includeProtected, includePrivate);
            Class<?> superClass = current.getSuperclass();
            if (superClass != null) {
                queue.add(superClass);
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])current.getInterfaces());
            while (iterator.hasNext()) {
                Class itf = (Class)iterator.next();
                Intrinsics.checkNotNull((Object)itf);
                queue.add((Object)itf);
            }
            current = (Class)queue.removeFirstOrNull();
        }
    }

    public void findExtraFields(@NotNull Class<?> clazz, @NotNull List<JavaObjectMappingProvider.RenameableField> list, boolean includeProtected, boolean includePrivate) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            this.findRemappedFields(current, list, includeProtected, includePrivate);
        }
    }

    private final void findRemappedMethods(Class<?> clazz, Map<JavaObjectMappingProvider.MethodSignature, JavaObjectMappingProvider.RenameableMethod> map, boolean includeProtected, boolean includePrivate) {
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Mappings.MappedClass mappedClass = Mappings.INSTANCE.getMappedClass$ctjs(string);
        if (mappedClass == null) {
            return;
        }
        Mappings.MappedClass mappedClass2 = mappedClass;
        for (Map.Entry<String, List<Mappings.MappedMethod>> entry : mappedClass2.getMethods().entrySet()) {
            String unmappedMethodName = entry.getKey();
            List<Mappings.MappedMethod> mappedMethods = entry.getValue();
            for (Mappings.MappedMethod mappedMethod : mappedMethods) {
                Method method;
                Object object;
                block4: {
                    Method[] methodArray = clazz.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                    for (Object object2 : (Object[])methodArray) {
                        Method it = (Method)object2;
                        boolean bl = false;
                        boolean bl2 = !Intrinsics.areEqual((Object)it.getName(), (Object)mappedMethod.getName().getValue()) ? false : (Modifier.isProtected(it.getModifiers()) && !includeProtected ? false : !Modifier.isPrivate(it.getModifiers()) || includePrivate);
                        if (!bl2) continue;
                        object = object2;
                        break block4;
                    }
                    object = null;
                }
                if ((Method)object == null) continue;
                map.put(new JavaObjectMappingProvider.MethodSignature(unmappedMethodName, (Class[])method.getParameterTypes()), new JavaObjectMappingProvider.RenameableMethod(method, unmappedMethodName));
            }
        }
    }

    private final void findRemappedFields(Class<?> clazz, List<JavaObjectMappingProvider.RenameableField> list, boolean includeProtected, boolean includePrivate) {
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Mappings.MappedClass mappedClass = Mappings.INSTANCE.getMappedClass$ctjs(string);
        if (mappedClass == null) {
            return;
        }
        Mappings.MappedClass mappedClass2 = mappedClass;
        for (Map.Entry<String, Mappings.MappedField> entry : mappedClass2.getFields().entrySet()) {
            Field field;
            Object object;
            String unmappedFieldName;
            block3: {
                unmappedFieldName = entry.getKey();
                Mappings.MappedField mappedField = entry.getValue();
                Field[] fieldArray = clazz.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
                for (Object object2 : (Object[])fieldArray) {
                    Field it = (Field)object2;
                    boolean bl = false;
                    boolean bl2 = !Intrinsics.areEqual((Object)it.getName(), (Object)mappedField.getName().getValue()) ? false : (Modifier.isProtected(it.getModifiers()) && !includeProtected ? false : !Modifier.isPrivate(it.getModifiers()) || includePrivate);
                    if (!bl2) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            if ((Field)object == null) continue;
            list.add(new JavaObjectMappingProvider.RenameableField(field, unmappedFieldName));
        }
    }
}

