/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.launch;

import com.chattriggers.ctjs.api.Mappings;
import com.chattriggers.ctjs.internal.launch.generation.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\t\u0010\bR\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0006\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "", "", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "Lorg/objectweb/asm/Type;", "toType", "()Lorg/objectweb/asm/Type;", "toMappedType", "", "isType", "()Z", "Primitive", "Object", "Array", "Field", "Method", "New", "Parser", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Array;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Field;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$New;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Primitive;", "ctjs"})
public sealed interface Descriptor {
    public boolean isType();

    @NotNull
    public String originalDescriptor();

    @NotNull
    public String mappedDescriptor();

    @NotNull
    public Type toType();

    @NotNull
    public Type toMappedType();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J$\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0013R\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b\u001f\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Array;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "base", "", "dimensions", "<init>", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor;I)V", "", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "Lorg/objectweb/asm/Type;", "toType", "()Lorg/objectweb/asm/Type;", "toMappedType", "toString", "component1", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "component2", "()I", "copy", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor;I)Lcom/chattriggers/ctjs/internal/launch/Descriptor$Array;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "getBase", "I", "getDimensions", "ctjs"})
    public static final class Array
    implements Descriptor {
        @NotNull
        private final Descriptor base;
        private final int dimensions;

        public Array(@NotNull Descriptor base, int dimensions) {
            Intrinsics.checkNotNullParameter((java.lang.Object)base, (String)"base");
            this.base = base;
            this.dimensions = dimensions;
            if (!this.base.isType()) {
                boolean $i$a$-require-Descriptor$Array$32 = false;
                String $i$a$-require-Descriptor$Array$32 = "Cannot pass a non-type object base to Descriptor.Array";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Array$32.toString());
            }
            if (!(this.dimensions > 0)) {
                boolean bl = false;
                String string = "Cannot pass a dimensions count less than 1 to Descritor.Array";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Descriptor getBase() {
            return this.base;
        }

        public final int getDimensions() {
            return this.dimensions;
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            return StringsKt.repeat((CharSequence)"[", (int)this.dimensions) + this.base.originalDescriptor();
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            return StringsKt.repeat((CharSequence)"[", (int)this.dimensions) + this.base.mappedDescriptor();
        }

        @Override
        @NotNull
        public Type toType() {
            Type type = Type.getType((String)this.originalDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getType(...)");
            return type;
        }

        @Override
        @NotNull
        public Type toMappedType() {
            Type type = Type.getType((String)this.mappedDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getType(...)");
            return type;
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        @NotNull
        public final Descriptor component1() {
            return this.base;
        }

        public final int component2() {
            return this.dimensions;
        }

        @NotNull
        public final Array copy(@NotNull Descriptor base, int dimensions) {
            Intrinsics.checkNotNullParameter((java.lang.Object)base, (String)"base");
            return new Array(base, dimensions);
        }

        public static /* synthetic */ Array copy$default(Array array, Descriptor descriptor, int n, int n2, java.lang.Object object) {
            if ((n2 & 1) != 0) {
                descriptor = array.base;
            }
            if ((n2 & 2) != 0) {
                n = array.dimensions;
            }
            return array.copy(descriptor, n);
        }

        public int hashCode() {
            int result = this.base.hashCode();
            result = result * 31 + Integer.hashCode(this.dimensions);
            return result;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Array)) {
                return false;
            }
            Array array = (Array)other;
            if (!Intrinsics.areEqual((java.lang.Object)this.base, (java.lang.Object)array.base)) {
                return false;
            }
            return this.dimensions == array.dimensions;
        }

        @Override
        public boolean isType() {
            return DefaultImpls.isType(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isType(@NotNull Descriptor $this) {
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J2\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010\nR\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001b\u0010+\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\n\u00a8\u0006,"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Field;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "owner", "", "name", "type", "<init>", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;Ljava/lang/String;Lcom/chattriggers/ctjs/internal/launch/Descriptor;)V", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "", "toType", "()Ljava/lang/Void;", "toMappedType", "toString", "component1", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "component2", "component3", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "copy", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;Ljava/lang/String;Lcom/chattriggers/ctjs/internal/launch/Descriptor;)Lcom/chattriggers/ctjs/internal/launch/Descriptor$Field;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "getOwner", "Ljava/lang/String;", "getName", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "getType", "isType", "()Z", "mappedName$delegate", "Lkotlin/Lazy;", "getMappedName", "mappedName", "ctjs"})
    public static final class Field
    implements Descriptor {
        @Nullable
        private final Object owner;
        @NotNull
        private final String name;
        @Nullable
        private final Descriptor type;
        @NotNull
        private final Lazy mappedName$delegate;

        public Field(@Nullable Object owner, @NotNull String name, @Nullable Descriptor type) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (String)"name");
            this.owner = owner;
            this.name = name;
            this.type = type;
            this.mappedName$delegate = LazyKt.lazy(() -> Field.mappedName_delegate$lambda$0(this));
            Descriptor descriptor = this.type;
            if (!(!(descriptor != null ? !descriptor.isType() : false))) {
                boolean bl = false;
                String string = "Cannot use non-type descriptor " + this.type + " as the field type";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Nullable
        public final Object getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Descriptor getType() {
            return this.type;
        }

        @Override
        public boolean isType() {
            return false;
        }

        private final String getMappedName() {
            Lazy lazy = this.mappedName$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$originalDescriptor_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.owner != null) {
                $this$originalDescriptor_u24lambda_u242.append(this.owner.originalDescriptor());
            }
            $this$originalDescriptor_u24lambda_u242.append(this.name);
            $this$originalDescriptor_u24lambda_u242.append(':');
            if (this.type != null) {
                $this$originalDescriptor_u24lambda_u242.append(this.type.originalDescriptor());
            }
            return stringBuilder.toString();
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$mappedDescriptor_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (!(this.owner != null)) {
                boolean bl2 = false;
                String string = "Cannot build mapped field descriptor from incomplete field descriptor";
                throw new IllegalArgumentException(string.toString());
            }
            $this$mappedDescriptor_u24lambda_u244.append(this.owner.mappedDescriptor());
            $this$mappedDescriptor_u24lambda_u244.append(this.getMappedName());
            $this$mappedDescriptor_u24lambda_u244.append(':');
            if (this.type != null) {
                $this$mappedDescriptor_u24lambda_u244.append(this.type.mappedDescriptor());
            }
            return stringBuilder.toString();
        }

        @NotNull
        public Void toType() {
            throw new IllegalStateException("Cannot convert Field descriptor to Type".toString());
        }

        @NotNull
        public Void toMappedType() {
            throw new IllegalStateException("Cannot convert Field descriptor to Type".toString());
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        @Nullable
        public final Object component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final Descriptor component3() {
            return this.type;
        }

        @NotNull
        public final Field copy(@Nullable Object owner, @NotNull String name, @Nullable Descriptor type) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (String)"name");
            return new Field(owner, name, type);
        }

        public static /* synthetic */ Field copy$default(Field field, Object object, String string, Descriptor descriptor, int n, java.lang.Object object2) {
            if ((n & 1) != 0) {
                object = field.owner;
            }
            if ((n & 2) != 0) {
                string = field.name;
            }
            if ((n & 4) != 0) {
                descriptor = field.type;
            }
            return field.copy(object, string, descriptor);
        }

        public int hashCode() {
            int result = this.owner == null ? 0 : this.owner.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field field = (Field)other;
            if (!Intrinsics.areEqual((java.lang.Object)this.owner, (java.lang.Object)field.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual((java.lang.Object)this.name, (java.lang.Object)field.name)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.type, (java.lang.Object)field.type);
        }

        private static final String mappedName_delegate$lambda$0(Field this$0) {
            Object object = this$0.owner;
            Intrinsics.checkNotNull((java.lang.Object)object);
            java.lang.Object object2 = Mappings.INSTANCE.getMappedClass$ctjs(object.originalDescriptor());
            if (object2 == null || (object2 = ((Mappings.MappedClass)object2).getFields()) == null || (object2 = (Mappings.MappedField)object2.get(this$0.name)) == null || (object2 = ((Mappings.MappedField)object2).getName()) == null || (object2 = ((Mappings.Mapping)object2).getValue()) == null) {
                object2 = this$0.name;
            }
            return object2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019JD\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001f\u001a\u00020\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010\fR\u001f\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010\u0017R\u0019\u0010\b\u001a\u0004\u0018\u00010\u00018\u0006\u00a2\u0006\f\n\u0004\b\b\u0010*\u001a\u0004\b+\u0010\u0019R\u0014\u0010,\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001b\u00101\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u0010\f\u00a8\u00062"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "owner", "", "name", "", "parameters", "returnType", "<init>", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;Ljava/lang/String;Ljava/util/List;Lcom/chattriggers/ctjs/internal/launch/Descriptor;)V", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "Lorg/objectweb/asm/Type;", "toType", "()Lorg/objectweb/asm/Type;", "toMappedType", "toString", "component1", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "component2", "component3", "()Ljava/util/List;", "component4", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "copy", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;Ljava/lang/String;Ljava/util/List;Lcom/chattriggers/ctjs/internal/launch/Descriptor;)Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "getOwner", "Ljava/lang/String;", "getName", "Ljava/util/List;", "getParameters", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "getReturnType", "isType", "()Z", "mappedName$delegate", "Lkotlin/Lazy;", "getMappedName", "mappedName", "ctjs"})
    @SourceDebugExtension(value={"SMAP\nDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Method\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1869#2,2:389\n1869#2,2:391\n1869#2,2:393\n1#3:395\n*S KotlinDebug\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Method\n*L\n153#1:389,2\n173#1:391,2\n187#1:393,2\n*E\n"})
    public static final class Method
    implements Descriptor {
        @Nullable
        private final Object owner;
        @NotNull
        private final String name;
        @Nullable
        private final List<Descriptor> parameters;
        @Nullable
        private final Descriptor returnType;
        @NotNull
        private final Lazy mappedName$delegate;

        public Method(@Nullable Object owner, @NotNull String name, @Nullable List<? extends Descriptor> parameters, @Nullable Descriptor returnType) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (String)"name");
            this.owner = owner;
            this.name = name;
            this.parameters = parameters;
            this.returnType = returnType;
            this.mappedName$delegate = LazyKt.lazy(() -> Method.mappedName_delegate$lambda$1(this));
            List<Descriptor> list = this.parameters;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl = false;
                    if (it.isType()) continue;
                    boolean bl2 = false;
                    String string = "Cannot use non-type descriptor " + it + " as a method parameter";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            Descriptor descriptor = this.returnType;
            if (!(!(descriptor != null ? !descriptor.isType() : false))) {
                boolean $i$a$-require-Descriptor$Method$42 = false;
                String $i$a$-require-Descriptor$Method$42 = "Cannot use non-type descriptor " + this.returnType + " as the method return type";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Method$42.toString());
            }
            if (!(this.parameters == null == (this.returnType == null))) {
                boolean bl = false;
                String string = "Parameters and return type must both be specified or omitted in a method descriptor";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Nullable
        public final Object getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final List<Descriptor> getParameters() {
            return this.parameters;
        }

        @Nullable
        public final Descriptor getReturnType() {
            return this.returnType;
        }

        @Override
        public boolean isType() {
            return false;
        }

        private final String getMappedName() {
            Lazy lazy = this.mappedName$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$originalDescriptor_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.owner != null) {
                $this$originalDescriptor_u24lambda_u247.append(this.owner.originalDescriptor());
            }
            $this$originalDescriptor_u24lambda_u247.append(this.name);
            if (this.parameters != null) {
                $this$originalDescriptor_u24lambda_u247.append('(');
                Iterable $this$forEach$iv = this.parameters;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl2 = false;
                    $this$originalDescriptor_u24lambda_u247.append(it.originalDescriptor());
                }
                $this$originalDescriptor_u24lambda_u247.append(')');
                Descriptor descriptor = this.returnType;
                Intrinsics.checkNotNull((java.lang.Object)descriptor);
                $this$originalDescriptor_u24lambda_u247.append(descriptor.originalDescriptor());
            }
            return stringBuilder.toString();
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$mappedDescriptor_u24lambda_u2410 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (!(this.owner != null)) {
                boolean $i$a$-require-Descriptor$Method$mappedDescriptor$1$22 = false;
                String $i$a$-require-Descriptor$Method$mappedDescriptor$1$22 = "Cannot build mapped method descriptor from incomplete method descriptor";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Method$mappedDescriptor$1$22.toString());
            }
            $this$mappedDescriptor_u24lambda_u2410.append(this.owner.mappedDescriptor());
            $this$mappedDescriptor_u24lambda_u2410.append(this.getMappedName());
            if (this.parameters != null) {
                $this$mappedDescriptor_u24lambda_u2410.append('(');
                Iterable $this$forEach$iv = this.parameters;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl2 = false;
                    $this$mappedDescriptor_u24lambda_u2410.append(it.mappedDescriptor());
                }
                $this$mappedDescriptor_u24lambda_u2410.append(')');
                Descriptor descriptor = this.returnType;
                Intrinsics.checkNotNull((java.lang.Object)descriptor);
                $this$mappedDescriptor_u24lambda_u2410.append(descriptor.mappedDescriptor());
            }
            return stringBuilder.toString();
        }

        @Override
        @NotNull
        public Type toType() {
            Type type = Type.getMethodType((String)this.originalDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getMethodType(...)");
            return type;
        }

        @Override
        @NotNull
        public Type toMappedType() {
            Type type = Type.getMethodType((String)this.mappedDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getMethodType(...)");
            return type;
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        @Nullable
        public final Object component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final List<Descriptor> component3() {
            return this.parameters;
        }

        @Nullable
        public final Descriptor component4() {
            return this.returnType;
        }

        @NotNull
        public final Method copy(@Nullable Object owner, @NotNull String name, @Nullable List<? extends Descriptor> parameters, @Nullable Descriptor returnType) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (String)"name");
            return new Method(owner, name, parameters, returnType);
        }

        public static /* synthetic */ Method copy$default(Method method, Object object, String string, List list, Descriptor descriptor, int n, java.lang.Object object2) {
            if ((n & 1) != 0) {
                object = method.owner;
            }
            if ((n & 2) != 0) {
                string = method.name;
            }
            if ((n & 4) != 0) {
                list = method.parameters;
            }
            if ((n & 8) != 0) {
                descriptor = method.returnType;
            }
            return method.copy(object, string, list, descriptor);
        }

        public int hashCode() {
            int result = this.owner == null ? 0 : this.owner.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.parameters == null ? 0 : ((java.lang.Object)this.parameters).hashCode());
            result = result * 31 + (this.returnType == null ? 0 : this.returnType.hashCode());
            return result;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method method = (Method)other;
            if (!Intrinsics.areEqual((java.lang.Object)this.owner, (java.lang.Object)method.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual((java.lang.Object)this.name, (java.lang.Object)method.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parameters, method.parameters)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.returnType, (java.lang.Object)method.returnType);
        }

        /*
         * Enabled aggressive block sorting
         */
        private static final String mappedName_delegate$lambda$1(Method this$0) {
            String string;
            Object object = this$0.owner;
            Intrinsics.checkNotNull((java.lang.Object)object);
            Mappings.MappedClass mappedClass = Mappings.INSTANCE.getMappedClass$ctjs(object.originalDescriptor());
            if (mappedClass != null) {
                String string2;
                Mappings.Mapping mapping;
                Mappings.MappedMethod mappedMethod;
                Mappings.MappedClass it = mappedClass;
                boolean bl = false;
                Pair<Mappings.MappedMethod, ClassInfo.Method> pair = Utils.INSTANCE.findMethod(it, this$0);
                if (pair != null && (mappedMethod = (Mappings.MappedMethod)pair.getFirst()) != null && (mapping = mappedMethod.getName()) != null && (string2 = mapping.getValue()) != null) {
                    string = string2;
                    return string;
                }
            }
            string = this$0.name;
            return string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u0001H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J,\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001e\u001a\u0004\b\u001f\u0010\u0011R\u001f\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\u0013R\u0014\u0010\"\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$New;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "type", "", "parameters", "<init>", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor;Ljava/util/List;)V", "", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "", "toType", "()Ljava/lang/Void;", "toMappedType", "toString", "component1", "()Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "component2", "()Ljava/util/List;", "copy", "(Lcom/chattriggers/ctjs/internal/launch/Descriptor;Ljava/util/List;)Lcom/chattriggers/ctjs/internal/launch/Descriptor$New;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "getType", "Ljava/util/List;", "getParameters", "isType", "()Z", "ctjs"})
    @SourceDebugExtension(value={"SMAP\nDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$New\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1869#2,2:389\n1869#2,2:391\n1869#2,2:393\n*S KotlinDebug\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$New\n*L\n208#1:389,2\n218#1:391,2\n227#1:393,2\n*E\n"})
    public static final class New
    implements Descriptor {
        @NotNull
        private final Descriptor type;
        @Nullable
        private final List<Descriptor> parameters;

        public New(@NotNull Descriptor type, @Nullable List<? extends Descriptor> parameters) {
            block2: {
                Intrinsics.checkNotNullParameter((java.lang.Object)type, (String)"type");
                this.type = type;
                this.parameters = parameters;
                if (!(this.type instanceof Object)) {
                    boolean $i$a$-require-Descriptor$New$22 = false;
                    String $i$a$-require-Descriptor$New$22 = "New descriptor cannot use non-object descriptor as its return type";
                    throw new IllegalArgumentException($i$a$-require-Descriptor$New$22.toString());
                }
                List<Descriptor> list = this.parameters;
                if (list == null) break block2;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl = false;
                    if (it.isType()) continue;
                    boolean bl2 = false;
                    String string = "Cannot use non-type descriptor " + it + " as a new descriptor parameter";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @NotNull
        public final Descriptor getType() {
            return this.type;
        }

        @Nullable
        public final List<Descriptor> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isType() {
            return false;
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$originalDescriptor_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.parameters != null) {
                $this$originalDescriptor_u24lambda_u244.append('(');
                Iterable $this$forEach$iv = this.parameters;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl2 = false;
                    $this$originalDescriptor_u24lambda_u244.append(it.originalDescriptor());
                }
                $this$originalDescriptor_u24lambda_u244.append(')');
            }
            $this$originalDescriptor_u24lambda_u244.append(this.type.originalDescriptor());
            return stringBuilder.toString();
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            StringBuilder stringBuilder;
            StringBuilder $this$mappedDescriptor_u24lambda_u246 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.parameters != null) {
                $this$mappedDescriptor_u24lambda_u246.append('(');
                Iterable $this$forEach$iv = this.parameters;
                boolean $i$f$forEach = false;
                for (java.lang.Object element$iv : $this$forEach$iv) {
                    Descriptor it = (Descriptor)element$iv;
                    boolean bl2 = false;
                    $this$mappedDescriptor_u24lambda_u246.append(it.mappedDescriptor());
                }
                $this$mappedDescriptor_u24lambda_u246.append(')');
            }
            $this$mappedDescriptor_u24lambda_u246.append(this.type.mappedDescriptor());
            return stringBuilder.toString();
        }

        @NotNull
        public Void toType() {
            throw new IllegalStateException("Cannot convert New descriptor to Type".toString());
        }

        @NotNull
        public Void toMappedType() {
            throw new IllegalStateException("Cannot convert New descriptor to Type".toString());
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        @NotNull
        public final Descriptor component1() {
            return this.type;
        }

        @Nullable
        public final List<Descriptor> component2() {
            return this.parameters;
        }

        @NotNull
        public final New copy(@NotNull Descriptor type, @Nullable List<? extends Descriptor> parameters) {
            Intrinsics.checkNotNullParameter((java.lang.Object)type, (String)"type");
            return new New(type, parameters);
        }

        public static /* synthetic */ New copy$default(New new_, Descriptor descriptor, List list, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                descriptor = new_.type;
            }
            if ((n & 2) != 0) {
                list = new_.parameters;
            }
            return new_.copy(descriptor, list);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + (this.parameters == null ? 0 : ((java.lang.Object)this.parameters).hashCode());
            return result;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof New)) {
                return false;
            }
            New new_ = (New)other;
            if (!Intrinsics.areEqual((java.lang.Object)this.type, (java.lang.Object)new_.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.parameters, new_.parameters);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Object;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "", "descriptor", "<init>", "(Ljava/lang/String;)V", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "Lorg/objectweb/asm/Type;", "toType", "()Lorg/objectweb/asm/Type;", "toMappedType", "toString", "Ljava/lang/String;", "ctjs"})
    public static final class Object
    implements Descriptor {
        @NotNull
        private final String descriptor;

        public Object(@NotNull String descriptor) {
            Intrinsics.checkNotNullParameter((java.lang.Object)descriptor, (String)"descriptor");
            this.descriptor = descriptor;
            if (!(!Primitive.Companion.getIDENTIFIERS().contains(this.descriptor))) {
                boolean $i$a$-require-Descriptor$Object$52 = false;
                String $i$a$-require-Descriptor$Object$52 = "Cannot pass a primitive type to Descriptor.Object";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Object$52.toString());
            }
            if (!(!StringsKt.startsWith$default((CharSequence)this.descriptor, (char)'[', (boolean)false, (int)2, null))) {
                boolean $i$a$-require-Descriptor$Object$62 = false;
                String $i$a$-require-Descriptor$Object$62 = "Cannot pass an array type to Descriptor.Object";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Object$62.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)this.descriptor, (char)'(', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)this.descriptor, (char)')', (boolean)false, (int)2, null))) {
                boolean $i$a$-require-Descriptor$Object$72 = false;
                String $i$a$-require-Descriptor$Object$72 = "Cannot pass a method descriptor to Descriptor.Object";
                throw new IllegalArgumentException($i$a$-require-Descriptor$Object$72.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)this.descriptor, (char)':', (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string = "Cannot pass a field descriptor to Descriptor.Object";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            return this.descriptor;
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            for (String mappedPackage : Mappings.INSTANCE.getMappedPackages$ctjs()) {
                java.lang.Object object;
                block4: {
                    block3: {
                        if (!StringsKt.startsWith$default((String)this.descriptor, (String)mappedPackage, (boolean)false, (int)2, null)) continue;
                        object = Mappings.INSTANCE.getMappedClassName$ctjs(this.descriptor);
                        if (object == null) break block3;
                        String it = object;
                        boolean bl = false;
                        String string = "L" + it + ";";
                        object = string;
                        if (string != null) break block4;
                    }
                    throw new IllegalStateException(("Unknown class \"" + this.descriptor + "\"").toString());
                }
                return object;
            }
            return this.descriptor;
        }

        @Override
        @NotNull
        public Type toType() {
            Type type = Type.getType((String)this.originalDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getType(...)");
            return type;
        }

        @Override
        @NotNull
        public Type toMappedType() {
            Type type = Type.getType((String)this.mappedDescriptor());
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"getType(...)");
            return type;
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        @Override
        public boolean isType() {
            return DefaultImpls.isType(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010#\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Parser;", "", "", "text", "<init>", "(Ljava/lang/String;)V", "parseJavaIdentifier", "()Ljava/lang/String;", "", "full", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "parseType", "(Z)Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Field;", "parseField", "(Z)Lcom/chattriggers/ctjs/internal/launch/Descriptor$Field;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "parseMethod", "(Z)Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$New;", "parseNew", "(Z)Lcom/chattriggers/ctjs/internal/launch/Descriptor$New;", "", "parseParameters", "()Ljava/util/List;", "Ljava/lang/String;", "", "cursor", "I", "", "getCh", "()C", "ch", "getDone", "()Z", "done", "ctjs"})
    @SourceDebugExtension(value={"SMAP\nDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1#2:389\n1869#3,2:390\n230#3,2:392\n*S KotlinDebug\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Parser\n*L\n253#1:390,2\n282#1:392,2\n*E\n"})
    public static final class Parser {
        @NotNull
        private final String text;
        private int cursor;

        public Parser(@NotNull String text) {
            Intrinsics.checkNotNullParameter((java.lang.Object)text, (String)"text");
            this.text = text;
            if (!(((CharSequence)this.text).length() > 0)) {
                boolean bl = false;
                String string = "Invalid descriptor \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final char getCh() {
            return this.text.charAt(this.cursor);
        }

        private final boolean getDone() {
            return this.cursor > StringsKt.getLastIndex((CharSequence)this.text);
        }

        private final String parseJavaIdentifier() {
            if (this.getDone()) {
                return null;
            }
            java.lang.Object[] objectArray = new String[]{"<init>", "<clinit>"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((java.lang.Object[])objectArray);
            boolean $i$f$forEach = false;
            for (java.lang.Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string = this.text.substring(this.cursor);
                Intrinsics.checkNotNullExpressionValue((java.lang.Object)string, (String)"substring(...)");
                if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                this.cursor += it.length();
                return it;
            }
            if (!Character.isJavaIdentifierStart(this.getCh())) {
                return null;
            }
            int start = this.cursor;
            int n = this.cursor;
            this.cursor = n + 1;
            while (!this.getDone() && Character.isJavaIdentifierPart(this.getCh())) {
                n = this.cursor;
                this.cursor = n + 1;
            }
            String string = this.text.substring(start, this.cursor);
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)string, (String)"substring(...)");
            return string;
        }

        @NotNull
        public final Descriptor parseType(boolean full) {
            Descriptor descriptor;
            if (full && !(this.cursor == 0)) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.getCh() == 'L') {
                int semicolonIndex = StringsKt.indexOf$default((CharSequence)this.text, (char)';', (int)this.cursor, (boolean)false, (int)4, null);
                if (semicolonIndex == -1) {
                    throw new IllegalStateException(("Invalid descriptor \"" + this.text + "\": expected ';' after position " + this.cursor).toString());
                }
                String string = this.text.substring(this.cursor, semicolonIndex + 1);
                Intrinsics.checkNotNullExpressionValue((java.lang.Object)string, (String)"substring(...)");
                String objectType = string;
                this.cursor += objectType.length();
                descriptor = new Object(objectType);
            } else if (StringsKt.contains$default((CharSequence)"VZCBSIFJD", (char)this.getCh(), (boolean)false, (int)2, null)) {
                java.lang.Object element$iv2;
                block10: {
                    Iterable $this$first$iv = (Iterable)Primitive.getEntries();
                    boolean $i$f$first = false;
                    for (java.lang.Object element$iv2 : $this$first$iv) {
                        Primitive it = (Primitive)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((java.lang.Object)it.toString(), (java.lang.Object)String.valueOf(this.getCh()))) continue;
                        break block10;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Primitive primitive = (Primitive)element$iv2;
                int $this$first$iv = this.cursor;
                this.cursor = $this$first$iv + 1;
                descriptor = primitive;
            } else if (this.getCh() == '[') {
                int primitive = this.cursor;
                this.cursor = primitive + 1;
                Descriptor base = Parser.parseType$default(this, false, 1, null);
                descriptor = base instanceof Array ? new Array(((Array)base).getBase(), ((Array)base).getDimensions() + 1) : new Array(base, 1);
            } else {
                throw new IllegalArgumentException("Invalid descriptor \"" + this.text + "\": unexpected character at position " + this.cursor);
            }
            Descriptor descriptor2 = descriptor;
            if (full && !this.getDone()) {
                boolean bl = false;
                String string = "Invalid descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
            return descriptor2;
        }

        public static /* synthetic */ Descriptor parseType$default(Parser parser, boolean bl, int n, java.lang.Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return parser.parseType(bl);
        }

        @NotNull
        public final Field parseField(boolean full) {
            Descriptor type;
            Descriptor type2;
            if (!(this.cursor == 0)) {
                throw new IllegalStateException("Check failed.");
            }
            try {
                type2 = Parser.parseType$default(this, false, 1, null);
                if (!(type2 instanceof Object)) {
                    boolean $i$a$-require-Descriptor$Parser$parseField$owner$22 = false;
                    String $i$a$-require-Descriptor$Parser$parseField$owner$22 = "Cannot create field descriptor with a non-object owner";
                    throw new IllegalArgumentException($i$a$-require-Descriptor$Parser$parseField$owner$22.toString());
                }
                type2 = (Object)type2;
            }
            catch (IllegalArgumentException e) {
                if (full) {
                    throw e;
                }
                type2 = null;
            }
            Descriptor owner = type2;
            String name = this.parseJavaIdentifier();
            if (name == null) {
                boolean $i$a$-requireNotNull-Descriptor$Parser$parseField$32 = false;
                String $i$a$-requireNotNull-Descriptor$Parser$parseField$32 = "Invalid field descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException($i$a$-requireNotNull-Descriptor$Parser$parseField$32.toString());
            }
            if (!this.getDone() && this.getCh() == ':') {
                int $i$a$-require-Descriptor$Parser$parseField$owner$22 = this.cursor;
                this.cursor = $i$a$-require-Descriptor$Parser$parseField$owner$22 + 1;
                v0 = Parser.parseType$default(this, false, 1, null);
            } else {
                v0 = type = null;
            }
            if (full && type == null) {
                boolean bl = false;
                String string = "Invalid field descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
            if (!this.getDone()) {
                boolean bl = false;
                String string = "Invalid field descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
            return new Field((Object)owner, name, type);
        }

        @NotNull
        public final Method parseMethod(boolean full) {
            Descriptor returnType;
            Descriptor type;
            if (!(this.cursor == 0)) {
                throw new IllegalStateException("Check failed.");
            }
            try {
                type = Parser.parseType$default(this, false, 1, null);
                if (!(type instanceof Object)) {
                    boolean $i$a$-require-Descriptor$Parser$parseMethod$owner$22 = false;
                    String $i$a$-require-Descriptor$Parser$parseMethod$owner$22 = "Cannot create method descriptor with a non-object owner";
                    throw new IllegalArgumentException($i$a$-require-Descriptor$Parser$parseMethod$owner$22.toString());
                }
                type = (Object)type;
            }
            catch (IllegalArgumentException e) {
                if (full) {
                    throw e;
                }
                type = null;
            }
            Descriptor owner = type;
            String name = this.parseJavaIdentifier();
            if (name == null) {
                boolean $i$a$-requireNotNull-Descriptor$Parser$parseMethod$22 = false;
                String $i$a$-requireNotNull-Descriptor$Parser$parseMethod$22 = "Invalid method descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException($i$a$-requireNotNull-Descriptor$Parser$parseMethod$22.toString());
            }
            List<Descriptor> parameters = this.parseParameters();
            if (parameters == null && full) {
                throw new IllegalArgumentException("Expected full method descriptor, found \"" + this.text + "\"");
            }
            Descriptor descriptor = returnType = parameters != null ? Parser.parseType$default(this, false, 1, null) : null;
            if (!this.getDone()) {
                boolean bl = false;
                String string = "Invalid method descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
            return new Method((Object)owner, name, parameters, returnType);
        }

        @NotNull
        public final New parseNew(boolean full) {
            if (!(this.cursor == 0)) {
                throw new IllegalStateException("Check failed.");
            }
            List<Descriptor> parameters = this.parseParameters();
            if (parameters == null && full) {
                throw new IllegalArgumentException("Expected full new descriptor, found \"" + this.text + "\"");
            }
            Descriptor type = Parser.parseType$default(this, false, 1, null);
            if (!this.getDone()) {
                boolean bl = false;
                String string = "Invalid new descriptor: \"" + this.text + "\"";
                throw new IllegalArgumentException(string.toString());
            }
            return new New(type, parameters);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Descriptor> parseParameters() {
            List<Descriptor> list;
            if (!this.getDone() && this.getCh() == '(') {
                void var1_2;
                int n = this.cursor;
                this.cursor = n + 1;
                List parameters = new ArrayList();
                while (!this.getDone() && this.getCh() != ')') {
                    parameters.add(Parser.parseType$default(this, false, 1, null));
                }
                if (!(!this.getDone() && this.getCh() == ')')) {
                    boolean bl = false;
                    String string = "Invalid method descriptor: \"" + this.text + "\"";
                    throw new IllegalArgumentException(string.toString());
                }
                int n2 = this.cursor;
                this.cursor = n2 + 1;
                list = var1_2;
            } else {
                list = null;
            }
            return list;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u0000 \u00102\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0010B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\tR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000fj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Primitive;", "Lcom/chattriggers/ctjs/internal/launch/Descriptor;", "", "Lorg/objectweb/asm/Type;", "type", "<init>", "(Ljava/lang/String;ILorg/objectweb/asm/Type;)V", "", "originalDescriptor", "()Ljava/lang/String;", "mappedDescriptor", "toType", "()Lorg/objectweb/asm/Type;", "toMappedType", "toString", "Lorg/objectweb/asm/Type;", "Companion", "VOID", "BOOLEAN", "CHAR", "BYTE", "SHORT", "INT", "FLOAT", "LONG", "DOUBLE", "ctjs"})
    @SourceDebugExtension(value={"SMAP\nDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Primitive\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1563#2:389\n1634#2,3:390\n*S KotlinDebug\n*F\n+ 1 Descriptor.kt\ncom/chattriggers/ctjs/internal/launch/Descriptor$Primitive\n*L\n35#1:389\n35#1:390,3\n*E\n"})
    public static final class Primitive
    extends Enum<Primitive>
    implements Descriptor {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Type type;
        @NotNull
        private static final List<String> IDENTIFIERS;
        public static final /* enum */ Primitive VOID;
        public static final /* enum */ Primitive BOOLEAN;
        public static final /* enum */ Primitive CHAR;
        public static final /* enum */ Primitive BYTE;
        public static final /* enum */ Primitive SHORT;
        public static final /* enum */ Primitive INT;
        public static final /* enum */ Primitive FLOAT;
        public static final /* enum */ Primitive LONG;
        public static final /* enum */ Primitive DOUBLE;
        private static final /* synthetic */ Primitive[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Primitive(Type type) {
            this.type = type;
        }

        @Override
        @NotNull
        public String originalDescriptor() {
            String string = this.type.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)string, (String)"getDescriptor(...)");
            return string;
        }

        @Override
        @NotNull
        public String mappedDescriptor() {
            return this.originalDescriptor();
        }

        @Override
        @NotNull
        public Type toType() {
            return this.type;
        }

        @Override
        @NotNull
        public Type toMappedType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return this.originalDescriptor();
        }

        public static Primitive[] values() {
            return (Primitive[])$VALUES.clone();
        }

        public static Primitive valueOf(String value) {
            return Enum.valueOf(Primitive.class, value);
        }

        @NotNull
        public static EnumEntries<Primitive> getEntries() {
            return $ENTRIES;
        }

        @Override
        public boolean isType() {
            return DefaultImpls.isType(this);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            Type type = Type.VOID_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type, (String)"VOID_TYPE");
            VOID = new Primitive(type);
            Type type2 = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type2, (String)"BOOLEAN_TYPE");
            BOOLEAN = new Primitive(type2);
            Type type3 = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type3, (String)"CHAR_TYPE");
            CHAR = new Primitive(type3);
            Type type4 = Type.BYTE_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type4, (String)"BYTE_TYPE");
            BYTE = new Primitive(type4);
            Type type5 = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type5, (String)"SHORT_TYPE");
            SHORT = new Primitive(type5);
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type6, (String)"INT_TYPE");
            INT = new Primitive(type6);
            Type type7 = Type.FLOAT_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type7, (String)"FLOAT_TYPE");
            FLOAT = new Primitive(type7);
            Type type8 = Type.LONG_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type8, (String)"LONG_TYPE");
            LONG = new Primitive(type8);
            Type type9 = Type.DOUBLE_TYPE;
            Intrinsics.checkNotNullExpressionValue((java.lang.Object)type9, (String)"DOUBLE_TYPE");
            DOUBLE = new Primitive(type9);
            $VALUES = primitiveArray = new Primitive[]{Primitive.VOID, Primitive.BOOLEAN, Primitive.CHAR, Primitive.BYTE, Primitive.SHORT, Primitive.INT, Primitive.FLOAT, Primitive.LONG, Primitive.DOUBLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$map$iv = (Iterable)Primitive.getEntries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Primitive primitive = (Primitive)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            IDENTIFIERS = (List)var3_3;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/chattriggers/ctjs/internal/launch/Descriptor$Primitive$Companion;", "", "<init>", "()V", "", "", "IDENTIFIERS", "Ljava/util/List;", "getIDENTIFIERS", "()Ljava/util/List;", "ctjs"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<String> getIDENTIFIERS() {
                return IDENTIFIERS;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

