/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.internal.launch.generation;

import com.chattriggers.ctjs.api.Mappings;
import com.chattriggers.ctjs.internal.launch.At;
import com.chattriggers.ctjs.internal.launch.Constant;
import com.chattriggers.ctjs.internal.launch.Descriptor;
import com.chattriggers.ctjs.internal.launch.Local;
import com.chattriggers.ctjs.internal.launch.Slice;
import com.chattriggers.ctjs.internal.launch.generation.InjectorGenerator;
import com.chattriggers.ctjs.internal.utils.ExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerReader;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u0019J-\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020!0\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010(\u001a\u00020'2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u0013\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/chattriggers/ctjs/internal/launch/generation/Utils;", "", "<init>", "()V", "Lcom/chattriggers/ctjs/internal/launch/At;", "at", "Lorg/objectweb/asm/tree/AnnotationNode;", "createAtAnnotation", "(Lcom/chattriggers/ctjs/internal/launch/At;)Lorg/objectweb/asm/tree/AnnotationNode;", "Lcom/chattriggers/ctjs/internal/launch/Slice;", "slice", "createSliceAnnotation", "(Lcom/chattriggers/ctjs/internal/launch/Slice;)Lorg/objectweb/asm/tree/AnnotationNode;", "Lcom/chattriggers/ctjs/internal/launch/Constant;", "constant", "createConstantAnnotation", "(Lcom/chattriggers/ctjs/internal/launch/Constant;)Lorg/objectweb/asm/tree/AnnotationNode;", "Lcom/chattriggers/ctjs/api/Mappings$MappedClass;", "mappedClass", "", "fieldName", "", "isMutable", "", "widenField", "(Lcom/chattriggers/ctjs/api/Mappings$MappedClass;Ljava/lang/String;Z)V", "methodName", "widenMethod", "Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;", "descriptor", "Lkotlin/Pair;", "Lcom/chattriggers/ctjs/api/Mappings$MappedMethod;", "Lorg/spongepowered/asm/mixin/transformer/ClassInfo$Method;", "Lorg/spongepowered/asm/mixin/transformer/ClassInfo;", "findMethod", "(Lcom/chattriggers/ctjs/api/Mappings$MappedClass;Lcom/chattriggers/ctjs/internal/launch/Descriptor$Method;)Lkotlin/Pair;", "Lcom/chattriggers/ctjs/internal/launch/Local;", "local", "name", "Lcom/chattriggers/ctjs/internal/launch/generation/InjectorGenerator$Parameter;", "getParameterFromLocal", "(Lcom/chattriggers/ctjs/internal/launch/Local;Ljava/lang/String;)Lcom/chattriggers/ctjs/internal/launch/generation/InjectorGenerator$Parameter;", "ctjs"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/chattriggers/ctjs/internal/launch/generation/Utils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1761#2,3:204\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/chattriggers/ctjs/internal/launch/generation/Utils\n*L\n151#1:204,3\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final AnnotationNode createAtAnnotation(@NotNull At at) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        AnnotationNode $this$createAtAnnotation_u24lambda_u240 = annotationNode = new AnnotationNode(ExtensionsKt.descriptorString(Reflection.getOrCreateKotlinClass(org.spongepowered.asm.mixin.injection.At.class)));
        boolean bl = false;
        if (at.getId() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("id", (Object)at.getId());
        }
        $this$createAtAnnotation_u24lambda_u240.visit("value", (Object)at.getValue());
        if (at.getSlice() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("slice", (Object)at.getSlice());
        }
        if (at.getShift() != null) {
            String[] stringArray = new String[]{At.Shift.class.descriptorString(), at.getShift().name()};
            $this$createAtAnnotation_u24lambda_u240.visit("shift", (Object)stringArray);
        }
        if (at.getBy() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("by", (Object)at.getBy());
        }
        if (at.getArgs() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("args", at.getArgs());
        }
        if (at.getTarget() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("target", (Object)at.getAtTarget$ctjs().getDescriptor().mappedDescriptor());
        }
        if (at.getOrdinal() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("ordinal", (Object)at.getOrdinal());
        }
        if (at.getOpcode() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("opcode", (Object)at.getOpcode());
        }
        if (at.getRemap() != null) {
            $this$createAtAnnotation_u24lambda_u240.visit("remap", (Object)at.getRemap());
        }
        $this$createAtAnnotation_u24lambda_u240.visitEnd();
        return annotationNode;
    }

    @NotNull
    public final AnnotationNode createSliceAnnotation(@NotNull Slice slice) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        AnnotationNode $this$createSliceAnnotation_u24lambda_u241 = annotationNode = new AnnotationNode(ExtensionsKt.descriptorString(Reflection.getOrCreateKotlinClass(org.spongepowered.asm.mixin.injection.Slice.class)));
        boolean bl = false;
        if (slice.getId() != null) {
            $this$createSliceAnnotation_u24lambda_u241.visit("id", (Object)slice.getId());
        }
        if (slice.getFrom() != null) {
            $this$createSliceAnnotation_u24lambda_u241.visit("from", (Object)INSTANCE.createAtAnnotation(slice.getFrom()));
        }
        if (slice.getTo() != null) {
            $this$createSliceAnnotation_u24lambda_u241.visit("to", (Object)INSTANCE.createAtAnnotation(slice.getTo()));
        }
        $this$createSliceAnnotation_u24lambda_u241.visitEnd();
        return annotationNode;
    }

    @NotNull
    public final AnnotationNode createConstantAnnotation(@NotNull Constant constant) {
        AnnotationNode annotationNode;
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        AnnotationNode $this$createConstantAnnotation_u24lambda_u242 = annotationNode = new AnnotationNode(ExtensionsKt.descriptorString(Reflection.getOrCreateKotlinClass(org.spongepowered.asm.mixin.injection.Constant.class)));
        boolean bl = false;
        if (constant.getNullValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("nullValue", (Object)constant.getNullValue());
        }
        if (constant.getIntValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("intValue", (Object)constant.getIntValue());
        }
        if (constant.getFloatValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("floatValue", (Object)constant.getFloatValue());
        }
        if (constant.getLongValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("longValue", (Object)constant.getLongValue());
        }
        if (constant.getDoubleValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("doubleValue", (Object)constant.getDoubleValue());
        }
        if (constant.getStringValue() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("stringValue", (Object)constant.getStringValue());
        }
        if (constant.getClassValue() != null) {
            String string = Mappings.INSTANCE.getMappedClassName$ctjs(constant.getClassValue());
            if (string == null) {
                throw new IllegalStateException(("Unknown class \"" + constant.getClassValue() + "\"").toString());
            }
            String name = string;
            $this$createConstantAnnotation_u24lambda_u242.visit("classValue", (Object)Type.getObjectType((String)name));
        }
        if (constant.getOrdinal() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("ordinal", (Object)constant.getOrdinal());
        }
        if (constant.getSlice() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("slice", (Object)constant.getSlice());
        }
        if (constant.getExpandZeroConditions() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("expandZeroConditions", constant.getExpandZeroConditions());
        }
        if (constant.getLog() != null) {
            $this$createConstantAnnotation_u24lambda_u242.visit("log", (Object)constant.getLog());
        }
        return annotationNode;
    }

    public final void widenField(@NotNull Mappings.MappedClass mappedClass, @NotNull String fieldName, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)mappedClass, (String)"mappedClass");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Mappings.MappedField mappedField = mappedClass.getFields().get(fieldName);
        if (mappedField == null) {
            throw new IllegalStateException(("Unable to find field " + fieldName + " in class " + mappedClass.getName().getOriginal()).toString());
        }
        Mappings.MappedField field = mappedField;
        FabricLoaderImpl.INSTANCE.getAccessWidener().visitField(mappedClass.getName().getValue(), field.getName().getValue(), field.getType().getValue(), AccessWidenerReader.AccessType.ACCESSIBLE, false);
        if (isMutable) {
            FabricLoaderImpl.INSTANCE.getAccessWidener().visitField(mappedClass.getName().getValue(), field.getName().getValue(), field.getType().getValue(), AccessWidenerReader.AccessType.MUTABLE, false);
        }
    }

    public final void widenMethod(@NotNull Mappings.MappedClass mappedClass, @NotNull String methodName, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)mappedClass, (String)"mappedClass");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Descriptor.Method descriptor = new Descriptor.Parser(methodName).parseMethod(false);
        Mappings.MappedMethod mappedMethod = (Mappings.MappedMethod)this.findMethod(mappedClass, descriptor).getFirst();
        FabricLoaderImpl.INSTANCE.getAccessWidener().visitMethod(mappedClass.getName().getValue(), mappedMethod.getName().getValue(), mappedMethod.toDescriptor(), AccessWidenerReader.AccessType.ACCESSIBLE, false);
        if (isMutable) {
            FabricLoaderImpl.INSTANCE.getAccessWidener().visitMethod(mappedClass.getName().getValue(), mappedMethod.getName().getValue(), mappedMethod.toDescriptor(), AccessWidenerReader.AccessType.MUTABLE, false);
        }
    }

    @NotNull
    public final Pair<Mappings.MappedMethod, ClassInfo.Method> findMethod(@NotNull Mappings.MappedClass mappedClass, @NotNull Descriptor.Method descriptor) {
        Intrinsics.checkNotNullParameter((Object)mappedClass, (String)"mappedClass");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        List<Descriptor> parameters = descriptor.getParameters();
        ClassInfo classInfo = ClassInfo.forName((String)mappedClass.getName().getValue());
        List<Mappings.MappedMethod> list = mappedClass.findMethods(descriptor.getName(), classInfo);
        if (list == null) {
            throw new IllegalStateException(("Cannot find method " + descriptor.getName() + " in class " + mappedClass.getName().getOriginal()).toString());
        }
        List<Mappings.MappedMethod> mappedMethods = list;
        Pair value = null;
        for (Mappings.MappedMethod method : mappedMethods) {
            ClassInfo.Method result;
            if (parameters != null) {
                boolean bl;
                block8: {
                    if (method.getParameters().size() != parameters.size()) continue;
                    Iterable $this$any$iv = CollectionsKt.zip((Iterable)method.getParameters(), (Iterable)parameters);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)((Mappings.MappedParameter)it.getFirst()).getType().getOriginal(), (Object)((Descriptor)it.getSecond()).originalDescriptor()))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
            }
            if (classInfo.findMethodInHierarchy(method.getName().getValue(), method.toDescriptor(), ClassInfo.SearchType.ALL_CLASSES, 262154) == null) continue;
            if (value != null) {
                throw new IllegalStateException(("Multiple methods match name " + descriptor.getName() + " in class " + mappedClass.getName().getOriginal() + ", please provide a method descriptor").toString());
            }
            value = TuplesKt.to((Object)method, (Object)result);
        }
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(("Unable to match method " + descriptor + " in class " + mappedClass.getName().getOriginal()).toString());
    }

    @NotNull
    public final InjectorGenerator.Parameter getParameterFromLocal(@NotNull Local local, @NotNull String name) {
        Descriptor descriptor;
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)local.getPrint(), (Object)true)) {
            descriptor = Descriptor.Primitive.INT;
        } else if (local.getType() != null) {
            if (local.getIndex() != null) {
                if (!(local.getOrdinal() == null)) {
                    boolean $i$a$-require-Utils$getParameterFromLocal$descriptor$32 = false;
                    String $i$a$-require-Utils$getParameterFromLocal$descriptor$32 = name + " that specifies a type and index cannot specify an ordinal";
                    throw new IllegalArgumentException($i$a$-require-Utils$getParameterFromLocal$descriptor$32.toString());
                }
            } else if (!(local.getOrdinal() != null)) {
                boolean bl = false;
                String string = name + " that specifies a type must also specify an index or ordinal";
                throw new IllegalArgumentException(string.toString());
            }
            descriptor = new Descriptor.Parser(local.getType()).parseType(true);
        } else {
            throw new IllegalStateException((name + " must specify \"print\", or \"type\" and either \"ordinal\" or \"index\"").toString());
        }
        Descriptor descriptor2 = descriptor;
        if (!descriptor2.isType()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new InjectorGenerator.Parameter(descriptor2, local);
    }

    public static /* synthetic */ InjectorGenerator.Parameter getParameterFromLocal$default(Utils utils, Local local, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Local";
        }
        return utils.getParameterFromLocal(local, string);
    }
}

