/// <reference no-default-lib="true" />
/// <reference lib="es2015" />
export {};

declare interface String {
  addFormatting(): string;
  addColor(): string;
  removeFormatting(): string;
  replaceFormatting(): string;
}

declare interface Number {
  easeOut(to: number, speed: number, jump: number): number;
  easeColor(to: number, speed: number, jump: number): java.awt.Color;
}

interface RegisterTypes {
  chat(...args: (string | unknown)[]): com.chattriggers.ctjs.api.triggers.ChatTrigger;
  actionBar(...args: (string | unknown)[]): com.chattriggers.ctjs.api.triggers.ChatTrigger;
  worldLoad(): com.chattriggers.ctjs.api.triggers.Trigger;
  worldUnload(): com.chattriggers.ctjs.api.triggers.Trigger;
  clicked(mouseX: number, mouseY: number, button: number, isPressed: boolean): com.chattriggers.ctjs.api.triggers.Trigger;
  scrolled(mouseX: number, mouseY: number, scrollDelta: number): com.chattriggers.ctjs.api.triggers.Trigger;
  dragged(mouseXDelta: number, mouseYDelta: number, mouseX: number, mouseY: number, mouseButton: number): com.chattriggers.ctjs.api.triggers.Trigger;
  soundPlay(position: com.chattriggers.ctjs.api.vec.Vec3f, name: string, volume: number, pitch: number, category: net.minecraft.sound.SoundCategory, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.SoundPlayTrigger;
  tick(ticksElapsed: number): com.chattriggers.ctjs.api.triggers.Trigger;
  step(stepsElapsed: number): com.chattriggers.ctjs.api.triggers.StepTrigger;
  renderWorld(partialTicks: number): com.chattriggers.ctjs.api.triggers.Trigger;
  preRenderWorld(partialTicks: number): com.chattriggers.ctjs.api.triggers.Trigger;
  postRenderWorld(partialTicks: number): com.chattriggers.ctjs.api.triggers.Trigger;
  renderOverlay(): com.chattriggers.ctjs.api.triggers.Trigger;
  renderPlayerList(event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.EventTrigger;
  drawBlockHighlight(position: BlockPos, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  gameLoad(): com.chattriggers.ctjs.api.triggers.Trigger;
  gameUnload(): com.chattriggers.ctjs.api.triggers.Trigger;
  command(...args: string[]): com.chattriggers.ctjs.api.triggers.CommandTrigger;
  guiOpened(screen: net.minecraft.client.gui.screen.Screen, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.EventTrigger;
  guiClosed(screen: net.minecraft.client.gui.screen.Screen): com.chattriggers.ctjs.api.triggers.Trigger;
  dropItem(item: Item, entireStack: boolean, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.EventTrigger;
  messageSent(message: string, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  itemTooltip(lore: TextComponent[], item: Item, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.EventTrigger;
  playerInteract(interaction: com.chattriggers.ctjs.api.entity.PlayerInteraction, interactionTarget: Entity | Block | Item, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  entityDamage(entity: Entity, attacker: PlayerMP): com.chattriggers.ctjs.api.triggers.Trigger;
  entityDeath(entity: Entity): com.chattriggers.ctjs.api.triggers.Trigger;
  guiRender(mouseX: number, mouseY: number, screen: net.minecraft.client.gui.screen.Screen): com.chattriggers.ctjs.api.triggers.Trigger;
  guiKey(char: String, keyCode: number, screen: net.minecraft.client.gui.screen.Screen, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  guiMouseClick(mouseX: number, mouseY: number, mouseButton: number, isPressed: boolean, screen: net.minecraft.client.gui.screen.Screen, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  guiMouseDrag(mouseXDelta: number, mouseYDelta: number, mouseX: number, mouseY: number, mouseButton: number, screen: net.minecraft.client.gui.screen.Screen, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.EventTrigger;
  packetSent(packet: net.minecraft.network.packet.Packet<unknown>, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.PacketTrigger;
  packetReceived(packet: net.minecraft.network.packet.Packet<unknown>, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.PacketTrigger;
  serverConnect(): com.chattriggers.ctjs.api.triggers.Trigger;
  serverDisconnect(): com.chattriggers.ctjs.api.triggers.Trigger;
  renderEntity(entity: Entity, partialTicks: number, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.RenderEntityTrigger;
  renderBlockEntity(blockEntity: BlockEntity, partialTicks: number, event: CancellableEvent): com.chattriggers.ctjs.api.triggers.RenderBlockEntityTrigger;
  postGuiRender(mouseX: number, mouseY: number, screen: net.minecraft.client.gui.screen.Screen): com.chattriggers.ctjs.api.triggers.Trigger;
  spawnParticle(particle: Particle, event: org.spongepowered.asm.mixin.injection.callback.CallbackInfo): com.chattriggers.ctjs.api.triggers.EventTrigger;
}

declare global {
  const Java: {
    /**
     * Returns the Java Class or Package given by name. If you want to
     * enforce the name is a class, use Java.class() instead.
     */
    type(name: string): java.lang.Package | java.lang.Class<any>;

    /**
     * Returns the Java Class given by `className`. Throws an error if the
     * name is not a valid class name.
     */
    class(className: string): java.lang.Class<any>;
  };

  /**
   * Runs `func` in a Java synchronized() block with `lock` as the synchronizer
   */
  function sync(func: () => void, lock: unknown): void;

  /**
   * Runs `func` after `delayInMs` milliseconds. A new thread is spawned to accomplish
   * this, which means this function is asynchronous. If you want to avoid the Thread
   * instantiation, use `Client.scheduleTask(delayInTicks, func)`.
   */
  function setTimeout(func: () => void, delayInMs: number): void;

  const ArrayList: typeof java.util.ArrayList;
  interface ArrayList<T> extends java.util.ArrayList<T> {}
  const HashMap: typeof java.util.HashMap;
  interface HashMap<K, V> extends java.util.HashMap<K, V> {}
  
  const Keyboard: typeof gg.essential.universal.UKeyboard;
  interface Keyboard extends gg.essential.universal.UKeyboard {}
  const Hand: typeof net.minecraft.util.Hand;
  interface Hand extends net.minecraft.util.Hand {}
  const Client: typeof com.chattriggers.ctjs.api.client.Client;
  interface Client extends com.chattriggers.ctjs.api.client.Client {}
  const CPS: typeof com.chattriggers.ctjs.api.client.CPS;
  interface CPS extends com.chattriggers.ctjs.api.client.CPS {}
  const FileLib: typeof com.chattriggers.ctjs.api.client.FileLib;
  interface FileLib extends com.chattriggers.ctjs.api.client.FileLib {}
  const KeyBind: typeof com.chattriggers.ctjs.api.client.KeyBind;
  interface KeyBind extends com.chattriggers.ctjs.api.client.KeyBind {}
  const MathLib: typeof com.chattriggers.ctjs.api.client.MathLib;
  interface MathLib extends com.chattriggers.ctjs.api.client.MathLib {}
  const Player: typeof com.chattriggers.ctjs.api.client.Player;
  interface Player extends com.chattriggers.ctjs.api.client.Player {}
  const Settings: typeof com.chattriggers.ctjs.api.client.Settings;
  interface Settings extends com.chattriggers.ctjs.api.client.Settings {}
  const Sound: typeof com.chattriggers.ctjs.api.client.Sound;
  interface Sound extends com.chattriggers.ctjs.api.client.Sound {}
  const Commands: typeof com.chattriggers.ctjs.api.commands.DynamicCommands;
  interface Commands extends com.chattriggers.ctjs.api.commands.DynamicCommands {}
  const BlockEntity: typeof com.chattriggers.ctjs.api.entity.BlockEntity;
  interface BlockEntity extends com.chattriggers.ctjs.api.entity.BlockEntity {}
  const Entity: typeof com.chattriggers.ctjs.api.entity.Entity;
  interface Entity extends com.chattriggers.ctjs.api.entity.Entity {}
  const LivingEntity: typeof com.chattriggers.ctjs.api.entity.LivingEntity;
  interface LivingEntity extends com.chattriggers.ctjs.api.entity.LivingEntity {}
  const Particle: typeof com.chattriggers.ctjs.api.entity.Particle;
  interface Particle extends com.chattriggers.ctjs.api.entity.Particle {}
  const PlayerMP: typeof com.chattriggers.ctjs.api.entity.PlayerMP;
  interface PlayerMP extends com.chattriggers.ctjs.api.entity.PlayerMP {}
  const Team: typeof com.chattriggers.ctjs.api.entity.Team;
  interface Team extends com.chattriggers.ctjs.api.entity.Team {}
  const Action: typeof com.chattriggers.ctjs.api.inventory.action.Action;
  interface Action extends com.chattriggers.ctjs.api.inventory.action.Action {}
  const ClickAction: typeof com.chattriggers.ctjs.api.inventory.action.ClickAction;
  interface ClickAction extends com.chattriggers.ctjs.api.inventory.action.ClickAction {}
  const DragAction: typeof com.chattriggers.ctjs.api.inventory.action.DragAction;
  interface DragAction extends com.chattriggers.ctjs.api.inventory.action.DragAction {}
  const DropAction: typeof com.chattriggers.ctjs.api.inventory.action.DropAction;
  interface DropAction extends com.chattriggers.ctjs.api.inventory.action.DropAction {}
  const KeyAction: typeof com.chattriggers.ctjs.api.inventory.action.KeyAction;
  interface KeyAction extends com.chattriggers.ctjs.api.inventory.action.KeyAction {}
  const NBT: typeof com.chattriggers.ctjs.api.inventory.nbt.NBT;
  interface NBT extends com.chattriggers.ctjs.api.inventory.nbt.NBT {}
  const NBTBase: typeof com.chattriggers.ctjs.api.inventory.nbt.NBTBase;
  interface NBTBase extends com.chattriggers.ctjs.api.inventory.nbt.NBTBase {}
  const NBTTagCompound: typeof com.chattriggers.ctjs.api.inventory.nbt.NBTTagCompound;
  interface NBTTagCompound extends com.chattriggers.ctjs.api.inventory.nbt.NBTTagCompound {}
  const NBTTagList: typeof com.chattriggers.ctjs.api.inventory.nbt.NBTTagList;
  interface NBTTagList extends com.chattriggers.ctjs.api.inventory.nbt.NBTTagList {}
  const Inventory: typeof com.chattriggers.ctjs.api.inventory.Inventory;
  interface Inventory extends com.chattriggers.ctjs.api.inventory.Inventory {}
  const Item: typeof com.chattriggers.ctjs.api.inventory.Item;
  interface Item extends com.chattriggers.ctjs.api.inventory.Item {}
  const ItemType: typeof com.chattriggers.ctjs.api.inventory.ItemType;
  interface ItemType extends com.chattriggers.ctjs.api.inventory.ItemType {}
  const Slot: typeof com.chattriggers.ctjs.api.inventory.Slot;
  interface Slot extends com.chattriggers.ctjs.api.inventory.Slot {}
  const ChatLib: typeof com.chattriggers.ctjs.api.message.ChatLib;
  interface ChatLib extends com.chattriggers.ctjs.api.message.ChatLib {}
  const TextComponent: typeof com.chattriggers.ctjs.api.message.TextComponent;
  interface TextComponent extends com.chattriggers.ctjs.api.message.TextComponent {}
  const Book: typeof com.chattriggers.ctjs.api.render.Book;
  interface Book extends com.chattriggers.ctjs.api.render.Book {}
  const Display: typeof com.chattriggers.ctjs.api.render.Display;
  interface Display extends com.chattriggers.ctjs.api.render.Display {}
  const Gui: typeof com.chattriggers.ctjs.api.render.Gui;
  interface Gui extends com.chattriggers.ctjs.api.render.Gui {}
  const Image: typeof com.chattriggers.ctjs.api.render.Image;
  interface Image extends com.chattriggers.ctjs.api.render.Image {}
  const Rectangle: typeof com.chattriggers.ctjs.api.render.Rectangle;
  interface Rectangle extends com.chattriggers.ctjs.api.render.Rectangle {}
  const Renderer: typeof com.chattriggers.ctjs.api.render.Renderer;
  interface Renderer extends com.chattriggers.ctjs.api.render.Renderer {}
  const Renderer3d: typeof com.chattriggers.ctjs.api.render.Renderer3d;
  interface Renderer3d extends com.chattriggers.ctjs.api.render.Renderer3d {}
  const Shape: typeof com.chattriggers.ctjs.api.render.Shape;
  interface Shape extends com.chattriggers.ctjs.api.render.Shape {}
  const Text: typeof com.chattriggers.ctjs.api.render.Text;
  interface Text extends com.chattriggers.ctjs.api.render.Text {}
  const CancellableEvent: typeof com.chattriggers.ctjs.api.triggers.CancellableEvent;
  interface CancellableEvent extends com.chattriggers.ctjs.api.triggers.CancellableEvent {}
  const Vec2f: typeof com.chattriggers.ctjs.api.vec.Vec2f;
  interface Vec2f extends com.chattriggers.ctjs.api.vec.Vec2f {}
  const Vec3f: typeof com.chattriggers.ctjs.api.vec.Vec3f;
  interface Vec3f extends com.chattriggers.ctjs.api.vec.Vec3f {}
  const Vec3i: typeof com.chattriggers.ctjs.api.vec.Vec3i;
  interface Vec3i extends com.chattriggers.ctjs.api.vec.Vec3i {}
  const Block: typeof com.chattriggers.ctjs.api.world.block.Block;
  interface Block extends com.chattriggers.ctjs.api.world.block.Block {}
  const BlockFace: typeof com.chattriggers.ctjs.api.world.block.BlockFace;
  interface BlockFace extends com.chattriggers.ctjs.api.world.block.BlockFace {}
  const BlockPos: typeof com.chattriggers.ctjs.api.world.block.BlockPos;
  interface BlockPos extends com.chattriggers.ctjs.api.world.block.BlockPos {}
  const BlockType: typeof com.chattriggers.ctjs.api.world.block.BlockType;
  interface BlockType extends com.chattriggers.ctjs.api.world.block.BlockType {}
  const BossBars: typeof com.chattriggers.ctjs.api.world.BossBars;
  interface BossBars extends com.chattriggers.ctjs.api.world.BossBars {}
  const Chunk: typeof com.chattriggers.ctjs.api.world.Chunk;
  interface Chunk extends com.chattriggers.ctjs.api.world.Chunk {}
  const PotionEffect: typeof com.chattriggers.ctjs.api.world.PotionEffect;
  interface PotionEffect extends com.chattriggers.ctjs.api.world.PotionEffect {}
  const PotionEffectType: typeof com.chattriggers.ctjs.api.world.PotionEffectType;
  interface PotionEffectType extends com.chattriggers.ctjs.api.world.PotionEffectType {}
  const Scoreboard: typeof com.chattriggers.ctjs.api.world.Scoreboard;
  interface Scoreboard extends com.chattriggers.ctjs.api.world.Scoreboard {}
  const Server: typeof com.chattriggers.ctjs.api.world.Server;
  interface Server extends com.chattriggers.ctjs.api.world.Server {}
  const TabList: typeof com.chattriggers.ctjs.api.world.TabList;
  interface TabList extends com.chattriggers.ctjs.api.world.TabList {}
  const World: typeof com.chattriggers.ctjs.api.world.World;
  interface World extends com.chattriggers.ctjs.api.world.World {}
  const Config: typeof com.chattriggers.ctjs.api.Config;
  interface Config extends com.chattriggers.ctjs.api.Config {}
  const TriggerRegister: typeof com.chattriggers.ctjs.engine.Register;
  interface TriggerRegister extends com.chattriggers.ctjs.engine.Register {}
  const Thread: typeof com.chattriggers.ctjs.engine.WrappedThread;
  interface Thread extends com.chattriggers.ctjs.engine.WrappedThread {}
  const Priority: typeof com.chattriggers.ctjs.api.triggers.Trigger$Priority;
  interface Priority extends com.chattriggers.ctjs.api.triggers.Trigger$Priority {}
  const ChatTriggers: typeof com.chattriggers.ctjs.CTJS;
  interface ChatTriggers extends com.chattriggers.ctjs.CTJS {}
  const Console: typeof com.chattriggers.ctjs.engine.Console;
  interface Console extends com.chattriggers.ctjs.engine.Console {}
  const GL11: typeof org.lwjgl.opengl.GL11;
  interface GL11 extends org.lwjgl.opengl.GL11 {}
  const GL12: typeof org.lwjgl.opengl.GL12;
  interface GL12 extends org.lwjgl.opengl.GL12 {}
  const GL13: typeof org.lwjgl.opengl.GL13;
  interface GL13 extends org.lwjgl.opengl.GL13 {}
  const GL14: typeof org.lwjgl.opengl.GL14;
  interface GL14 extends org.lwjgl.opengl.GL14 {}
  const GL15: typeof org.lwjgl.opengl.GL15;
  interface GL15 extends org.lwjgl.opengl.GL15 {}
  const GL20: typeof org.lwjgl.opengl.GL20;
  interface GL20 extends org.lwjgl.opengl.GL20 {}
  const GL21: typeof org.lwjgl.opengl.GL21;
  interface GL21 extends org.lwjgl.opengl.GL21 {}
  const GL30: typeof org.lwjgl.opengl.GL30;
  interface GL30 extends org.lwjgl.opengl.GL30 {}
  const GL31: typeof org.lwjgl.opengl.GL31;
  interface GL31 extends org.lwjgl.opengl.GL31 {}
  const GL32: typeof org.lwjgl.opengl.GL32;
  interface GL32 extends org.lwjgl.opengl.GL32 {}
  const GL33: typeof org.lwjgl.opengl.GL33;
  interface GL33 extends org.lwjgl.opengl.GL33 {}
  const GL40: typeof org.lwjgl.opengl.GL40;
  interface GL40 extends org.lwjgl.opengl.GL40 {}
  const GL41: typeof org.lwjgl.opengl.GL41;
  interface GL41 extends org.lwjgl.opengl.GL41 {}
  const GL42: typeof org.lwjgl.opengl.GL42;
  interface GL42 extends org.lwjgl.opengl.GL42 {}
  const GL43: typeof org.lwjgl.opengl.GL43;
  interface GL43 extends org.lwjgl.opengl.GL43 {}
  const GL44: typeof org.lwjgl.opengl.GL44;
  interface GL44 extends org.lwjgl.opengl.GL44 {}
  const GL45: typeof org.lwjgl.opengl.GL45;
  interface GL45 extends org.lwjgl.opengl.GL45 {}
  

  /**
   * Registers a new trigger and returns it.
   */
  function register<T extends keyof RegisterTypes>(
    name: T, 
    cb: (...args: Parameters<RegisterTypes[T]>) => void,
  ): ReturnType<RegisterTypes[T]>;

  /**
   * Cancels the given event
   */
  function cancel(event: CancellableEvent | org.spongepowered.asm.mixin.injection.callback.CallbackInfo): void;

  /**
   * Creates a custom trigger. `name` can be used as the first argument of a
   * subsequent call to `register`. Returns an object that can be used to
   * invoke the trigger.
   */
  function createCustomTrigger(name: string): { trigger(...args: unknown[]) };
  
  function easeOut(start: number, finish: number, speed: number, jump?: number): number;
  function easeColor(start: number, finish: number, speed: number, jump?: number): java.awt.Color;

  function print(message: string, color?: java.awt.Color): void;
  function println(message: string, color?: java.awt.Color, end?: string): void;

  const console: {
    assert(condition: boolean, message: string): void;
    clear(): void;
    count(label?: string): void;
    debug(args: unknown[]): void;
    dir(obj: object): void;
    dirxml(obj: object): void;
    error(...args: unknown[]): void;
    group(...args: unknown[]): void;
    groupCollapsed(...args: unknown[]): void;
    groupEnd(...args: unknown[]): void;
    info(...args: unknown[]): void;
    log(...args: unknown[]): void;
    table(data: object, columns?: string[]): void;
    time(label?: string): void;
    timeEnd(label?: string): void;
    trace(...args: unknown[]): void;
    warn(...args: unknown[]): void;
  };  namespace java {
    namespace awt {
      namespace image {
        namespace renderable {
          const RenderableImage: {
            HINTS_OBSERVED: string;
          }
          interface RenderableImage { 
            getSources(): java.util.Vector<java.awt.image.renderable.RenderableImage>;
            getProperty(p0: string): any;
            getPropertyNames(): Array<string>;
            isDynamic(): boolean;
            getWidth(): number;
            getHeight(): number;
            getMinX(): number;
            getMinY(): number;
            createScaledRendering(p0: number, p1: number, p2: java.awt.RenderingHints): java.awt.image.RenderedImage;
            createDefaultRendering(): java.awt.image.RenderedImage;
            createRendering(p0: java.awt.image.renderable.RenderContext): java.awt.image.RenderedImage;
          }
          const RenderContext: {
            new(p0: java.awt.geom.AffineTransform, p1: java.awt.Shape, p2: java.awt.RenderingHints): java.awt.image.renderable.RenderContext;
            new(p0: java.awt.geom.AffineTransform): java.awt.image.renderable.RenderContext;
            new(p0: java.awt.geom.AffineTransform, p1: java.awt.RenderingHints): java.awt.image.renderable.RenderContext;
            new(p0: java.awt.geom.AffineTransform, p1: java.awt.Shape): java.awt.image.renderable.RenderContext;
          }
          interface RenderContext extends kotlin.Cloneable { 
            getRenderingHints(): java.awt.RenderingHints;
            setRenderingHints(p0: java.awt.RenderingHints): void;
            setTransform(p0: java.awt.geom.AffineTransform): void;
            preConcatenateTransform(p0: java.awt.geom.AffineTransform): void;
            preConcetenateTransform(p0: java.awt.geom.AffineTransform): void;
            concatenateTransform(p0: java.awt.geom.AffineTransform): void;
            concetenateTransform(p0: java.awt.geom.AffineTransform): void;
            getTransform(): java.awt.geom.AffineTransform;
            setAreaOfInterest(p0: java.awt.Shape): void;
            getAreaOfInterest(): java.awt.Shape;
          }
        }
        const ColorModel: {
          getRGBdefault(): java.awt.image.ColorModel;
          new(p0: number): java.awt.image.ColorModel;
        }
        interface ColorModel extends java.awt.Transparency { 
          hasAlpha(): boolean;
          isAlphaPremultiplied(): boolean;
          getTransferType(): number;
          getPixelSize(): number;
          getComponentSize(p0: number): number;
          getComponentSize(): Array<number>;
          getNumComponents(): number;
          getNumColorComponents(): number;
          getRed(p0: number): number;
          getRed(p0: any): number;
          getGreen(p0: number): number;
          getGreen(p0: any): number;
          getBlue(p0: number): number;
          getBlue(p0: any): number;
          getAlpha(p0: number): number;
          getAlpha(p0: any): number;
          getRGB(p0: number): number;
          getRGB(p0: any): number;
          getDataElements(p0: number, p1: any): any;
          getDataElements(p0: Array<number>, p1: number, p2: any): any;
          getDataElements(p0: kotlin.FloatArray, p1: number, p2: any): any;
          getComponents(p0: number, p1: Array<number>, p2: number): Array<number>;
          getComponents(p0: any, p1: Array<number>, p2: number): Array<number>;
          getUnnormalizedComponents(p0: kotlin.FloatArray, p1: number, p2: Array<number>, p3: number): Array<number>;
          getNormalizedComponents(p0: Array<number>, p1: number, p2: kotlin.FloatArray, p3: number): kotlin.FloatArray;
          getNormalizedComponents(p0: any, p1: kotlin.FloatArray, p2: number): kotlin.FloatArray;
          getDataElement(p0: Array<number>, p1: number): number;
          getDataElement(p0: kotlin.FloatArray, p1: number): number;
          getColorSpace(): java.awt.color.ColorSpace;
          coerceData(p0: java.awt.image.WritableRaster, p1: boolean): java.awt.image.ColorModel;
          isCompatibleRaster(p0: java.awt.image.Raster): boolean;
          createCompatibleWritableRaster(p0: number, p1: number): java.awt.image.WritableRaster;
          createCompatibleSampleModel(p0: number, p1: number): java.awt.image.SampleModel;
          isCompatibleSampleModel(p0: java.awt.image.SampleModel): boolean;
          getAlphaRaster(p0: java.awt.image.WritableRaster): java.awt.image.WritableRaster;
        }
        interface WritableRaster extends java.awt.image.Raster { 
          getWritableParent(): java.awt.image.WritableRaster;
          createWritableTranslatedChild(p0: number, p1: number): java.awt.image.WritableRaster;
          createWritableChild(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: Array<number>): java.awt.image.WritableRaster;
          setDataElements(p0: number, p1: number, p2: any): void;
          setDataElements(p0: number, p1: number, p2: java.awt.image.Raster): void;
          setDataElements(p0: number, p1: number, p2: number, p3: number, p4: any): void;
          setRect(p0: java.awt.image.Raster): void;
          setRect(p0: number, p1: number, p2: java.awt.image.Raster): void;
          setPixel(p0: number, p1: number, p2: Array<number>): void;
          setPixel(p0: number, p1: number, p2: kotlin.FloatArray): void;
          setPixel(p0: number, p1: number, p2: kotlin.DoubleArray): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: Array<number>): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.FloatArray): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.DoubleArray): void;
          setSample(p0: number, p1: number, p2: number, p3: number): void;
          setSample(p0: number, p1: number, p2: number, p3: number): void;
          setSample(p0: number, p1: number, p2: number, p3: number): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: Array<number>): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.FloatArray): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.DoubleArray): void;
        }
        const Raster: {
          createInterleavedRaster(p0: number, p1: number, p2: number, p3: number, p4: java.awt.Point): java.awt.image.WritableRaster;
          createInterleavedRaster(p0: number, p1: number, p2: number, p3: number, p4: number, p5: Array<number>, p6: java.awt.Point): java.awt.image.WritableRaster;
          createInterleavedRaster(p0: java.awt.image.DataBuffer, p1: number, p2: number, p3: number, p4: number, p5: Array<number>, p6: java.awt.Point): java.awt.image.WritableRaster;
          createBandedRaster(p0: number, p1: number, p2: number, p3: number, p4: java.awt.Point): java.awt.image.WritableRaster;
          createBandedRaster(p0: number, p1: number, p2: number, p3: number, p4: Array<number>, p5: Array<number>, p6: java.awt.Point): java.awt.image.WritableRaster;
          createBandedRaster(p0: java.awt.image.DataBuffer, p1: number, p2: number, p3: number, p4: Array<number>, p5: Array<number>, p6: java.awt.Point): java.awt.image.WritableRaster;
          createPackedRaster(p0: number, p1: number, p2: number, p3: Array<number>, p4: java.awt.Point): java.awt.image.WritableRaster;
          createPackedRaster(p0: number, p1: number, p2: number, p3: number, p4: number, p5: java.awt.Point): java.awt.image.WritableRaster;
          createPackedRaster(p0: java.awt.image.DataBuffer, p1: number, p2: number, p3: number, p4: Array<number>, p5: java.awt.Point): java.awt.image.WritableRaster;
          createPackedRaster(p0: java.awt.image.DataBuffer, p1: number, p2: number, p3: number, p4: java.awt.Point): java.awt.image.WritableRaster;
          createRaster(p0: java.awt.image.SampleModel, p1: java.awt.image.DataBuffer, p2: java.awt.Point): java.awt.image.Raster;
          createWritableRaster(p0: java.awt.image.SampleModel, p1: java.awt.Point): java.awt.image.WritableRaster;
          createWritableRaster(p0: java.awt.image.SampleModel, p1: java.awt.image.DataBuffer, p2: java.awt.Point): java.awt.image.WritableRaster;
        }
        interface Raster { 
          getParent(): java.awt.image.Raster;
          getSampleModelTranslateX(): number;
          getSampleModelTranslateY(): number;
          createCompatibleWritableRaster(): java.awt.image.WritableRaster;
          createCompatibleWritableRaster(p0: number, p1: number): java.awt.image.WritableRaster;
          createCompatibleWritableRaster(p0: java.awt.Rectangle): java.awt.image.WritableRaster;
          createCompatibleWritableRaster(p0: number, p1: number, p2: number, p3: number): java.awt.image.WritableRaster;
          createTranslatedChild(p0: number, p1: number): java.awt.image.Raster;
          createChild(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: Array<number>): java.awt.image.Raster;
          getBounds(): java.awt.Rectangle;
          getMinX(): number;
          getMinY(): number;
          getWidth(): number;
          getHeight(): number;
          getNumBands(): number;
          getNumDataElements(): number;
          getTransferType(): number;
          getDataBuffer(): java.awt.image.DataBuffer;
          getSampleModel(): java.awt.image.SampleModel;
          getDataElements(p0: number, p1: number, p2: any): any;
          getDataElements(p0: number, p1: number, p2: number, p3: number, p4: any): any;
          getPixel(p0: number, p1: number, p2: Array<number>): Array<number>;
          getPixel(p0: number, p1: number, p2: kotlin.FloatArray): kotlin.FloatArray;
          getPixel(p0: number, p1: number, p2: kotlin.DoubleArray): kotlin.DoubleArray;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: Array<number>): Array<number>;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.FloatArray): kotlin.FloatArray;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.DoubleArray): kotlin.DoubleArray;
          getSample(p0: number, p1: number, p2: number): number;
          getSampleFloat(p0: number, p1: number, p2: number): number;
          getSampleDouble(p0: number, p1: number, p2: number): number;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: Array<number>): Array<number>;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.FloatArray): kotlin.FloatArray;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.DoubleArray): kotlin.DoubleArray;
        }
        const DataBuffer: {
          TYPE_BYTE: number;
          TYPE_USHORT: number;
          TYPE_SHORT: number;
          TYPE_INT: number;
          TYPE_FLOAT: number;
          TYPE_DOUBLE: number;
          TYPE_UNDEFINED: number;
          getDataTypeSize(p0: number): number;
        }
        interface DataBuffer { 
          getDataType(): number;
          getSize(): number;
          getOffset(): number;
          getOffsets(): Array<number>;
          getNumBanks(): number;
          getElem(p0: number): number;
          getElem(p0: number, p1: number): number;
          setElem(p0: number, p1: number): void;
          setElem(p0: number, p1: number, p2: number): void;
          getElemFloat(p0: number): number;
          getElemFloat(p0: number, p1: number): number;
          setElemFloat(p0: number, p1: number): void;
          setElemFloat(p0: number, p1: number, p2: number): void;
          getElemDouble(p0: number): number;
          getElemDouble(p0: number, p1: number): number;
          setElemDouble(p0: number, p1: number): void;
          setElemDouble(p0: number, p1: number, p2: number): void;
        }
        const SampleModel: {
          new(p0: number, p1: number, p2: number, p3: number): java.awt.image.SampleModel;
        }
        interface SampleModel { 
          getWidth(): number;
          getHeight(): number;
          getNumBands(): number;
          getNumDataElements(): number;
          getDataType(): number;
          getTransferType(): number;
          getPixel(p0: number, p1: number, p2: Array<number>, p3: java.awt.image.DataBuffer): Array<number>;
          getPixel(p0: number, p1: number, p2: kotlin.FloatArray, p3: java.awt.image.DataBuffer): kotlin.FloatArray;
          getPixel(p0: number, p1: number, p2: kotlin.DoubleArray, p3: java.awt.image.DataBuffer): kotlin.DoubleArray;
          getDataElements(p0: number, p1: number, p2: any, p3: java.awt.image.DataBuffer): any;
          getDataElements(p0: number, p1: number, p2: number, p3: number, p4: any, p5: java.awt.image.DataBuffer): any;
          setDataElements(p0: number, p1: number, p2: any, p3: java.awt.image.DataBuffer): void;
          setDataElements(p0: number, p1: number, p2: number, p3: number, p4: any, p5: java.awt.image.DataBuffer): void;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: Array<number>, p5: java.awt.image.DataBuffer): Array<number>;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.FloatArray, p5: java.awt.image.DataBuffer): kotlin.FloatArray;
          getPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.DoubleArray, p5: java.awt.image.DataBuffer): kotlin.DoubleArray;
          getSample(p0: number, p1: number, p2: number, p3: java.awt.image.DataBuffer): number;
          getSampleFloat(p0: number, p1: number, p2: number, p3: java.awt.image.DataBuffer): number;
          getSampleDouble(p0: number, p1: number, p2: number, p3: java.awt.image.DataBuffer): number;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: Array<number>, p6: java.awt.image.DataBuffer): Array<number>;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.FloatArray, p6: java.awt.image.DataBuffer): kotlin.FloatArray;
          getSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.DoubleArray, p6: java.awt.image.DataBuffer): kotlin.DoubleArray;
          setPixel(p0: number, p1: number, p2: Array<number>, p3: java.awt.image.DataBuffer): void;
          setPixel(p0: number, p1: number, p2: kotlin.FloatArray, p3: java.awt.image.DataBuffer): void;
          setPixel(p0: number, p1: number, p2: kotlin.DoubleArray, p3: java.awt.image.DataBuffer): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: Array<number>, p5: java.awt.image.DataBuffer): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.FloatArray, p5: java.awt.image.DataBuffer): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: kotlin.DoubleArray, p5: java.awt.image.DataBuffer): void;
          setSample(p0: number, p1: number, p2: number, p3: number, p4: java.awt.image.DataBuffer): void;
          setSample(p0: number, p1: number, p2: number, p3: number, p4: java.awt.image.DataBuffer): void;
          setSample(p0: number, p1: number, p2: number, p3: number, p4: java.awt.image.DataBuffer): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: Array<number>, p6: java.awt.image.DataBuffer): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.FloatArray, p6: java.awt.image.DataBuffer): void;
          setSamples(p0: number, p1: number, p2: number, p3: number, p4: number, p5: kotlin.DoubleArray, p6: java.awt.image.DataBuffer): void;
          createCompatibleSampleModel(p0: number, p1: number): java.awt.image.SampleModel;
          createSubsetSampleModel(p0: Array<number>): java.awt.image.SampleModel;
          createDataBuffer(): java.awt.image.DataBuffer;
          getSampleSize(): Array<number>;
          getSampleSize(p0: number): number;
        }
        const BufferedImage: {
          TYPE_CUSTOM: number;
          TYPE_INT_RGB: number;
          TYPE_INT_ARGB: number;
          TYPE_INT_ARGB_PRE: number;
          TYPE_INT_BGR: number;
          TYPE_3BYTE_BGR: number;
          TYPE_4BYTE_ABGR: number;
          TYPE_4BYTE_ABGR_PRE: number;
          TYPE_USHORT_565_RGB: number;
          TYPE_USHORT_555_RGB: number;
          TYPE_BYTE_GRAY: number;
          TYPE_USHORT_GRAY: number;
          TYPE_BYTE_BINARY: number;
          TYPE_BYTE_INDEXED: number;
          new(p0: number, p1: number, p2: number): java.awt.image.BufferedImage;
          new(p0: number, p1: number, p2: number, p3: java.awt.image.IndexColorModel): java.awt.image.BufferedImage;
          new(p0: java.awt.image.ColorModel, p1: java.awt.image.WritableRaster, p2: boolean, p3: java.util.Hashtable<any, any>): java.awt.image.BufferedImage;
        }
        interface BufferedImage extends java.awt.Image, java.awt.image.WritableRenderedImage, java.awt.Transparency { 
          getType(): number;
          getRaster(): java.awt.image.WritableRaster;
          getAlphaRaster(): java.awt.image.WritableRaster;
          getRGB(p0: number, p1: number): number;
          getRGB(p0: number, p1: number, p2: number, p3: number, p4: Array<number>, p5: number, p6: number): Array<number>;
          setRGB(p0: number, p1: number, p2: number): void;
          setRGB(p0: number, p1: number, p2: number, p3: number, p4: Array<number>, p5: number, p6: number): void;
          createGraphics(): java.awt.Graphics2D;
          getSubimage(p0: number, p1: number, p2: number, p3: number): java.awt.image.BufferedImage;
          isAlphaPremultiplied(): boolean;
          coerceData(p0: boolean): void;
        }
        const ImageObserver: {
          WIDTH: number;
          HEIGHT: number;
          PROPERTIES: number;
          SOMEBITS: number;
          FRAMEBITS: number;
          ALLBITS: number;
          ERROR: number;
          ABORT: number;
        }
        interface ImageObserver { 
          imageUpdate(p0: java.awt.Image, p1: number, p2: number, p3: number, p4: number, p5: number): boolean;
        }
        interface ImageProducer { 
          addConsumer(p0: java.awt.image.ImageConsumer): void;
          isConsumer(p0: java.awt.image.ImageConsumer): boolean;
          removeConsumer(p0: java.awt.image.ImageConsumer): void;
          startProduction(p0: java.awt.image.ImageConsumer): void;
          requestTopDownLeftRightResend(p0: java.awt.image.ImageConsumer): void;
        }
        const ImageConsumer: {
          RANDOMPIXELORDER: number;
          TOPDOWNLEFTRIGHT: number;
          COMPLETESCANLINES: number;
          SINGLEPASS: number;
          SINGLEFRAME: number;
          IMAGEERROR: number;
          SINGLEFRAMEDONE: number;
          STATICIMAGEDONE: number;
          IMAGEABORTED: number;
        }
        interface ImageConsumer { 
          setDimensions(p0: number, p1: number): void;
          setProperties(p0: java.util.Hashtable<any, any>): void;
          setColorModel(p0: java.awt.image.ColorModel): void;
          setHints(p0: number): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: java.awt.image.ColorModel, p5: Array<number>, p6: number, p7: number): void;
          setPixels(p0: number, p1: number, p2: number, p3: number, p4: java.awt.image.ColorModel, p5: Array<number>, p6: number, p7: number): void;
          imageComplete(p0: number): void;
        }
        const VolatileImage: {
          IMAGE_OK: number;
          IMAGE_RESTORED: number;
          IMAGE_INCOMPATIBLE: number;
        }
        interface VolatileImage extends java.awt.Image, java.awt.Transparency { 
          getWidth(): number;
          getHeight(): number;
          getCapabilities(): java.awt.ImageCapabilities;
          getSnapshot(): java.awt.image.BufferedImage;
          createGraphics(): java.awt.Graphics2D;
          validate(p0: java.awt.GraphicsConfiguration): number;
          contentsLost(): boolean;
        }
        interface BufferedImageOp { 
          filter(p0: java.awt.image.BufferedImage, p1: java.awt.image.BufferedImage): java.awt.image.BufferedImage;
          getBounds2D(p0: java.awt.image.BufferedImage): java.awt.geom.Rectangle2D;
          createCompatibleDestImage(p0: java.awt.image.BufferedImage, p1: java.awt.image.ColorModel): java.awt.image.BufferedImage;
          getPoint2D(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Point2D;
          getRenderingHints(): java.awt.RenderingHints;
        }
        interface RenderedImage { 
          getSources(): java.util.Vector<java.awt.image.RenderedImage>;
          getProperty(p0: string): any;
          getPropertyNames(): Array<string>;
          getColorModel(): java.awt.image.ColorModel;
          getSampleModel(): java.awt.image.SampleModel;
          getWidth(): number;
          getHeight(): number;
          getMinX(): number;
          getMinY(): number;
          getNumXTiles(): number;
          getNumYTiles(): number;
          getMinTileX(): number;
          getMinTileY(): number;
          getTileWidth(): number;
          getTileHeight(): number;
          getTileGridXOffset(): number;
          getTileGridYOffset(): number;
          getTile(p0: number, p1: number): java.awt.image.Raster;
          getData(): java.awt.image.Raster;
          getData(p0: java.awt.Rectangle): java.awt.image.Raster;
          copyData(p0: java.awt.image.WritableRaster): java.awt.image.WritableRaster;
        }
        interface BufferStrategy { 
          getCapabilities(): java.awt.BufferCapabilities;
          getDrawGraphics(): java.awt.Graphics;
          contentsLost(): boolean;
          contentsRestored(): boolean;
          show(): void;
          dispose(): void;
        }
        interface WritableRenderedImage extends java.awt.image.RenderedImage { 
          addTileObserver(p0: java.awt.image.TileObserver): void;
          removeTileObserver(p0: java.awt.image.TileObserver): void;
          getWritableTile(p0: number, p1: number): java.awt.image.WritableRaster;
          releaseWritableTile(p0: number, p1: number): void;
          isTileWritable(p0: number, p1: number): boolean;
          getWritableTileIndices(): Array<java.awt.Point>;
          hasTileWriters(): boolean;
          setData(p0: java.awt.image.Raster): void;
        }
        interface TileObserver { 
          tileUpdate(p0: java.awt.image.WritableRenderedImage, p1: number, p2: number, p3: boolean): void;
        }
        const IndexColorModel: {
          new(p0: number, p1: number, p2: Array<number>, p3: Array<number>, p4: Array<number>): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: Array<number>, p4: Array<number>, p5: number): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: Array<number>, p4: Array<number>, p5: Array<number>): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: number, p4: boolean): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: number, p4: boolean, p5: number): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: number, p4: boolean, p5: number, p6: number): java.awt.image.IndexColorModel;
          new(p0: number, p1: number, p2: Array<number>, p3: number, p4: number, p5: java.math.BigInteger): java.awt.image.IndexColorModel;
        }
        interface IndexColorModel extends java.awt.image.ColorModel { 
          getMapSize(): number;
          getTransparentPixel(): number;
          getReds(p0: Array<number>): void;
          getGreens(p0: Array<number>): void;
          getBlues(p0: Array<number>): void;
          getAlphas(p0: Array<number>): void;
          getRGBs(p0: Array<number>): void;
          convertToIntDiscrete(p0: java.awt.image.Raster, p1: boolean): java.awt.image.BufferedImage;
          isValid(p0: number): boolean;
          isValid(): boolean;
          getValidPixels(): java.math.BigInteger;
        }
      }
      namespace color {
        const ColorSpace: {
          TYPE_XYZ: number;
          TYPE_Lab: number;
          TYPE_Luv: number;
          TYPE_YCbCr: number;
          TYPE_Yxy: number;
          TYPE_RGB: number;
          TYPE_GRAY: number;
          TYPE_HSV: number;
          TYPE_HLS: number;
          TYPE_CMYK: number;
          TYPE_CMY: number;
          TYPE_2CLR: number;
          TYPE_3CLR: number;
          TYPE_4CLR: number;
          TYPE_5CLR: number;
          TYPE_6CLR: number;
          TYPE_7CLR: number;
          TYPE_8CLR: number;
          TYPE_9CLR: number;
          TYPE_ACLR: number;
          TYPE_BCLR: number;
          TYPE_CCLR: number;
          TYPE_DCLR: number;
          TYPE_ECLR: number;
          TYPE_FCLR: number;
          CS_sRGB: number;
          CS_LINEAR_RGB: number;
          CS_CIEXYZ: number;
          CS_PYCC: number;
          CS_GRAY: number;
          getInstance(p0: number): java.awt.color.ColorSpace;
        }
        interface ColorSpace extends java.io.Serializable { 
          isCS_sRGB(): boolean;
          toRGB(p0: kotlin.FloatArray): kotlin.FloatArray;
          fromRGB(p0: kotlin.FloatArray): kotlin.FloatArray;
          toCIEXYZ(p0: kotlin.FloatArray): kotlin.FloatArray;
          fromCIEXYZ(p0: kotlin.FloatArray): kotlin.FloatArray;
          getType(): number;
          getNumComponents(): number;
          getName(p0: number): string;
          getMinValue(p0: number): number;
          getMaxValue(p0: number): number;
        }
      }
      namespace geom {
        const Rectangle2D: {
          Float: typeof java.awt.geom.Rectangle2D$Float;
          Double: typeof java.awt.geom.Rectangle2D$Double;
          OUT_LEFT: number;
          OUT_TOP: number;
          OUT_RIGHT: number;
          OUT_BOTTOM: number;
          intersect(p0: java.awt.geom.Rectangle2D, p1: java.awt.geom.Rectangle2D, p2: java.awt.geom.Rectangle2D): void;
          union(p0: java.awt.geom.Rectangle2D, p1: java.awt.geom.Rectangle2D, p2: java.awt.geom.Rectangle2D): void;
        }
        interface Rectangle2D extends java.awt.geom.RectangularShape { 
          setRect(p0: number, p1: number, p2: number, p3: number): void;
          setRect(p0: java.awt.geom.Rectangle2D): void;
          intersectsLine(p0: number, p1: number, p2: number, p3: number): boolean;
          intersectsLine(p0: java.awt.geom.Line2D): boolean;
          outcode(p0: number, p1: number): number;
          outcode(p0: java.awt.geom.Point2D): number;
          createIntersection(p0: java.awt.geom.Rectangle2D): java.awt.geom.Rectangle2D;
          createUnion(p0: java.awt.geom.Rectangle2D): java.awt.geom.Rectangle2D;
          add(p0: number, p1: number): void;
          add(p0: java.awt.geom.Point2D): void;
          add(p0: java.awt.geom.Rectangle2D): void;
        }
        interface RectangularShape extends java.awt.Shape, kotlin.Cloneable { 
          getX(): number;
          getY(): number;
          getWidth(): number;
          getHeight(): number;
          getMinX(): number;
          getMinY(): number;
          getMaxX(): number;
          getMaxY(): number;
          getCenterX(): number;
          getCenterY(): number;
          getFrame(): java.awt.geom.Rectangle2D;
          isEmpty(): boolean;
          setFrame(p0: number, p1: number, p2: number, p3: number): void;
          setFrame(p0: java.awt.geom.Point2D, p1: java.awt.geom.Dimension2D): void;
          setFrame(p0: java.awt.geom.Rectangle2D): void;
          setFrameFromDiagonal(p0: number, p1: number, p2: number, p3: number): void;
          setFrameFromDiagonal(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): void;
          setFrameFromCenter(p0: number, p1: number, p2: number, p3: number): void;
          setFrameFromCenter(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): void;
        }
        const Point2D: {
          Float: typeof java.awt.geom.Point2D$Float;
          Double: typeof java.awt.geom.Point2D$Double;
          distanceSq(p0: number, p1: number, p2: number, p3: number): number;
          distance(p0: number, p1: number, p2: number, p3: number): number;
        }
        interface Point2D extends kotlin.Cloneable { 
          getX(): number;
          getY(): number;
          setLocation(p0: number, p1: number): void;
          setLocation(p0: java.awt.geom.Point2D): void;
          distanceSq(p0: number, p1: number): number;
          distanceSq(p0: java.awt.geom.Point2D): number;
          distance(p0: number, p1: number): number;
          distance(p0: java.awt.geom.Point2D): number;
        }
        const Point2D$Float: {
          new(): java.awt.geom.Point2D$Float;
          new(p0: number, p1: number): java.awt.geom.Point2D$Float;
        }
        interface Point2D$Float extends java.awt.geom.Point2D, java.io.Serializable { 
          x: number;
          y: number;
          setLocation(p0: number, p1: number): void;
        }
        const Point2D$Double: {
          new(): java.awt.geom.Point2D$Double;
          new(p0: number, p1: number): java.awt.geom.Point2D$Double;
        }
        interface Point2D$Double extends java.awt.geom.Point2D, java.io.Serializable { 
          x: number;
          y: number;
        }
        const AffineTransform: {
          TYPE_IDENTITY: number;
          TYPE_TRANSLATION: number;
          TYPE_UNIFORM_SCALE: number;
          TYPE_GENERAL_SCALE: number;
          TYPE_MASK_SCALE: number;
          TYPE_FLIP: number;
          TYPE_QUADRANT_ROTATION: number;
          TYPE_GENERAL_ROTATION: number;
          TYPE_MASK_ROTATION: number;
          TYPE_GENERAL_TRANSFORM: number;
          getTranslateInstance(p0: number, p1: number): java.awt.geom.AffineTransform;
          getRotateInstance(p0: number): java.awt.geom.AffineTransform;
          getRotateInstance(p0: number, p1: number, p2: number): java.awt.geom.AffineTransform;
          getRotateInstance(p0: number, p1: number): java.awt.geom.AffineTransform;
          getRotateInstance(p0: number, p1: number, p2: number, p3: number): java.awt.geom.AffineTransform;
          getQuadrantRotateInstance(p0: number): java.awt.geom.AffineTransform;
          getQuadrantRotateInstance(p0: number, p1: number, p2: number): java.awt.geom.AffineTransform;
          getScaleInstance(p0: number, p1: number): java.awt.geom.AffineTransform;
          getShearInstance(p0: number, p1: number): java.awt.geom.AffineTransform;
          new(): java.awt.geom.AffineTransform;
          new(p0: java.awt.geom.AffineTransform): java.awt.geom.AffineTransform;
          new(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): java.awt.geom.AffineTransform;
          new(p0: kotlin.FloatArray): java.awt.geom.AffineTransform;
          new(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): java.awt.geom.AffineTransform;
          new(p0: kotlin.DoubleArray): java.awt.geom.AffineTransform;
        }
        interface AffineTransform extends kotlin.Cloneable, java.io.Serializable { 
          getType(): number;
          getDeterminant(): number;
          getMatrix(p0: kotlin.DoubleArray): void;
          getScaleX(): number;
          getScaleY(): number;
          getShearX(): number;
          getShearY(): number;
          getTranslateX(): number;
          getTranslateY(): number;
          translate(p0: number, p1: number): void;
          rotate(p0: number): void;
          rotate(p0: number, p1: number, p2: number): void;
          rotate(p0: number, p1: number): void;
          rotate(p0: number, p1: number, p2: number, p3: number): void;
          quadrantRotate(p0: number): void;
          quadrantRotate(p0: number, p1: number, p2: number): void;
          scale(p0: number, p1: number): void;
          shear(p0: number, p1: number): void;
          setToIdentity(): void;
          setToTranslation(p0: number, p1: number): void;
          setToRotation(p0: number): void;
          setToRotation(p0: number, p1: number, p2: number): void;
          setToRotation(p0: number, p1: number): void;
          setToRotation(p0: number, p1: number, p2: number, p3: number): void;
          setToQuadrantRotation(p0: number): void;
          setToQuadrantRotation(p0: number, p1: number, p2: number): void;
          setToScale(p0: number, p1: number): void;
          setToShear(p0: number, p1: number): void;
          setTransform(p0: java.awt.geom.AffineTransform): void;
          setTransform(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
          concatenate(p0: java.awt.geom.AffineTransform): void;
          preConcatenate(p0: java.awt.geom.AffineTransform): void;
          createInverse(): java.awt.geom.AffineTransform;
          invert(): void;
          transform(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Point2D;
          transform(p0: Array<java.awt.geom.Point2D>, p1: number, p2: Array<java.awt.geom.Point2D>, p3: number, p4: number): void;
          transform(p0: kotlin.FloatArray, p1: number, p2: kotlin.FloatArray, p3: number, p4: number): void;
          transform(p0: kotlin.DoubleArray, p1: number, p2: kotlin.DoubleArray, p3: number, p4: number): void;
          transform(p0: kotlin.FloatArray, p1: number, p2: kotlin.DoubleArray, p3: number, p4: number): void;
          transform(p0: kotlin.DoubleArray, p1: number, p2: kotlin.FloatArray, p3: number, p4: number): void;
          inverseTransform(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Point2D;
          inverseTransform(p0: kotlin.DoubleArray, p1: number, p2: kotlin.DoubleArray, p3: number, p4: number): void;
          deltaTransform(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Point2D;
          deltaTransform(p0: kotlin.DoubleArray, p1: number, p2: kotlin.DoubleArray, p3: number, p4: number): void;
          createTransformedShape(p0: java.awt.Shape): java.awt.Shape;
          isIdentity(): boolean;
        }
        const PathIterator: {
          WIND_EVEN_ODD: number;
          WIND_NON_ZERO: number;
          SEG_MOVETO: number;
          SEG_LINETO: number;
          SEG_QUADTO: number;
          SEG_CUBICTO: number;
          SEG_CLOSE: number;
        }
        interface PathIterator { 
          getWindingRule(): number;
          isDone(): boolean;
          next(): void;
          currentSegment(p0: kotlin.FloatArray): number;
          currentSegment(p0: kotlin.DoubleArray): number;
        }
        interface Dimension2D extends kotlin.Cloneable { 
          getWidth(): number;
          getHeight(): number;
          setSize(p0: number, p1: number): void;
          setSize(p0: java.awt.geom.Dimension2D): void;
        }
        const Rectangle2D$Float: {
          new(): java.awt.geom.Rectangle2D$Float;
          new(p0: number, p1: number, p2: number, p3: number): java.awt.geom.Rectangle2D$Float;
        }
        interface Rectangle2D$Float extends java.awt.geom.Rectangle2D, java.io.Serializable { 
          x: number;
          y: number;
          width: number;
          height: number;
          setRect(p0: number, p1: number, p2: number, p3: number): void;
        }
        const Rectangle2D$Double: {
          new(): java.awt.geom.Rectangle2D$Double;
          new(p0: number, p1: number, p2: number, p3: number): java.awt.geom.Rectangle2D$Double;
        }
        interface Rectangle2D$Double extends java.awt.geom.Rectangle2D, java.io.Serializable { 
          x: number;
          y: number;
          width: number;
          height: number;
        }
        const Line2D: {
          Float: typeof java.awt.geom.Line2D$Float;
          Double: typeof java.awt.geom.Line2D$Double;
          relativeCCW(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
          linesIntersect(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number): boolean;
          ptSegDistSq(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
          ptSegDist(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
          ptLineDistSq(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
          ptLineDist(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
        }
        interface Line2D extends java.awt.Shape, kotlin.Cloneable { 
          getX1(): number;
          getY1(): number;
          getP1(): java.awt.geom.Point2D;
          getX2(): number;
          getY2(): number;
          getP2(): java.awt.geom.Point2D;
          setLine(p0: number, p1: number, p2: number, p3: number): void;
          setLine(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): void;
          setLine(p0: java.awt.geom.Line2D): void;
          relativeCCW(p0: number, p1: number): number;
          relativeCCW(p0: java.awt.geom.Point2D): number;
          intersectsLine(p0: number, p1: number, p2: number, p3: number): boolean;
          intersectsLine(p0: java.awt.geom.Line2D): boolean;
          ptSegDistSq(p0: number, p1: number): number;
          ptSegDistSq(p0: java.awt.geom.Point2D): number;
          ptSegDist(p0: number, p1: number): number;
          ptSegDist(p0: java.awt.geom.Point2D): number;
          ptLineDistSq(p0: number, p1: number): number;
          ptLineDistSq(p0: java.awt.geom.Point2D): number;
          ptLineDist(p0: number, p1: number): number;
          ptLineDist(p0: java.awt.geom.Point2D): number;
        }
        const Line2D$Float: {
          new(): java.awt.geom.Line2D$Float;
          new(p0: number, p1: number, p2: number, p3: number): java.awt.geom.Line2D$Float;
          new(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Line2D$Float;
        }
        interface Line2D$Float extends java.awt.geom.Line2D, java.io.Serializable { 
          x1: number;
          y1: number;
          x2: number;
          y2: number;
          setLine(p0: number, p1: number, p2: number, p3: number): void;
        }
        const Line2D$Double: {
          new(): java.awt.geom.Line2D$Double;
          new(p0: number, p1: number, p2: number, p3: number): java.awt.geom.Line2D$Double;
          new(p0: java.awt.geom.Point2D, p1: java.awt.geom.Point2D): java.awt.geom.Line2D$Double;
        }
        interface Line2D$Double extends java.awt.geom.Line2D, java.io.Serializable { 
          x1: number;
          y1: number;
          x2: number;
          y2: number;
        }
      }
      namespace font {
        const FontRenderContext: {
          new(p0: java.awt.geom.AffineTransform, p1: boolean, p2: boolean): java.awt.font.FontRenderContext;
          new(p0: java.awt.geom.AffineTransform, p1: any, p2: any): java.awt.font.FontRenderContext;
        }
        interface FontRenderContext { 
          isTransformed(): boolean;
          getTransformType(): number;
          getTransform(): java.awt.geom.AffineTransform;
          isAntiAliased(): boolean;
          usesFractionalMetrics(): boolean;
          getAntiAliasingHint(): any;
          getFractionalMetricsHint(): any;
        }
        interface LineMetrics { 
          getNumChars(): number;
          getAscent(): number;
          getDescent(): number;
          getLeading(): number;
          getHeight(): number;
          getBaselineIndex(): number;
          getBaselineOffsets(): kotlin.FloatArray;
          getStrikethroughOffset(): number;
          getStrikethroughThickness(): number;
          getUnderlineOffset(): number;
          getUnderlineThickness(): number;
        }
        const GlyphVector: {
          FLAG_HAS_TRANSFORMS: number;
          FLAG_HAS_POSITION_ADJUSTMENTS: number;
          FLAG_RUN_RTL: number;
          FLAG_COMPLEX_GLYPHS: number;
          FLAG_MASK: number;
        }
        interface GlyphVector extends kotlin.Cloneable { 
          getFont(): java.awt.Font;
          getFontRenderContext(): java.awt.font.FontRenderContext;
          performDefaultLayout(): void;
          getNumGlyphs(): number;
          getGlyphCode(p0: number): number;
          getGlyphCodes(p0: number, p1: number, p2: Array<number>): Array<number>;
          getGlyphCharIndex(p0: number): number;
          getGlyphCharIndices(p0: number, p1: number, p2: Array<number>): Array<number>;
          getLogicalBounds(): java.awt.geom.Rectangle2D;
          getVisualBounds(): java.awt.geom.Rectangle2D;
          getPixelBounds(p0: java.awt.font.FontRenderContext, p1: number, p2: number): java.awt.Rectangle;
          getOutline(): java.awt.Shape;
          getOutline(p0: number, p1: number): java.awt.Shape;
          getGlyphOutline(p0: number): java.awt.Shape;
          getGlyphOutline(p0: number, p1: number, p2: number): java.awt.Shape;
          getGlyphPosition(p0: number): java.awt.geom.Point2D;
          setGlyphPosition(p0: number, p1: java.awt.geom.Point2D): void;
          getGlyphTransform(p0: number): java.awt.geom.AffineTransform;
          setGlyphTransform(p0: number, p1: java.awt.geom.AffineTransform): void;
          getLayoutFlags(): number;
          getGlyphPositions(p0: number, p1: number, p2: kotlin.FloatArray): kotlin.FloatArray;
          getGlyphLogicalBounds(p0: number): java.awt.Shape;
          getGlyphVisualBounds(p0: number): java.awt.Shape;
          getGlyphPixelBounds(p0: number, p1: java.awt.font.FontRenderContext, p2: number, p3: number): java.awt.Rectangle;
          getGlyphMetrics(p0: number): java.awt.font.GlyphMetrics;
          getGlyphJustificationInfo(p0: number): java.awt.font.GlyphJustificationInfo;
        }
        const GlyphMetrics: {
          STANDARD: number;
          LIGATURE: number;
          COMBINING: number;
          COMPONENT: number;
          WHITESPACE: number;
          new(p0: number, p1: java.awt.geom.Rectangle2D, p2: number): java.awt.font.GlyphMetrics;
          new(p0: boolean, p1: number, p2: number, p3: java.awt.geom.Rectangle2D, p4: number): java.awt.font.GlyphMetrics;
        }
        interface GlyphMetrics { 
          getAdvance(): number;
          getAdvanceX(): number;
          getAdvanceY(): number;
          getBounds2D(): java.awt.geom.Rectangle2D;
          getLSB(): number;
          getRSB(): number;
          getType(): number;
          isStandard(): boolean;
          isLigature(): boolean;
          isCombining(): boolean;
          isComponent(): boolean;
          isWhitespace(): boolean;
        }
        const GlyphJustificationInfo: {
          PRIORITY_KASHIDA: number;
          PRIORITY_WHITESPACE: number;
          PRIORITY_INTERCHAR: number;
          PRIORITY_NONE: number;
          new(p0: number, p1: boolean, p2: number, p3: number, p4: number, p5: boolean, p6: number, p7: number, p8: number): java.awt.font.GlyphJustificationInfo;
        }
        interface GlyphJustificationInfo { 
          weight: number;
          growPriority: number;
          growAbsorb: boolean;
          growLeftLimit: number;
          growRightLimit: number;
          shrinkPriority: number;
          shrinkAbsorb: boolean;
          shrinkLeftLimit: number;
          shrinkRightLimit: number;
        }
        const TextHitInfo: {
          leading(p0: number): java.awt.font.TextHitInfo;
          trailing(p0: number): java.awt.font.TextHitInfo;
          beforeOffset(p0: number): java.awt.font.TextHitInfo;
          afterOffset(p0: number): java.awt.font.TextHitInfo;
        }
        interface TextHitInfo { 
          getCharIndex(): number;
          isLeadingEdge(): boolean;
          getInsertionIndex(): number;
          getOtherHit(): java.awt.font.TextHitInfo;
          getOffsetHit(p0: number): java.awt.font.TextHitInfo;
        }
      }
      namespace event {
        interface FocusListener extends java.util.EventListener { 
          focusGained(p0: java.awt.event.FocusEvent): void;
          focusLost(p0: java.awt.event.FocusEvent): void;
        }
        const FocusEvent: {
          Cause: typeof java.awt.event.FocusEvent$Cause;
          FOCUS_FIRST: number;
          FOCUS_LAST: number;
          FOCUS_GAINED: number;
          FOCUS_LOST: number;
          new(p0: java.awt.Component, p1: number, p2: boolean, p3: java.awt.Component): java.awt.event.FocusEvent;
          new(p0: java.awt.Component, p1: number, p2: boolean, p3: java.awt.Component, p4: java.awt.event.FocusEvent$Cause): java.awt.event.FocusEvent;
          new(p0: java.awt.Component, p1: number, p2: boolean): java.awt.event.FocusEvent;
          new(p0: java.awt.Component, p1: number): java.awt.event.FocusEvent;
        }
        interface FocusEvent extends java.awt.event.ComponentEvent { 
          isTemporary(): boolean;
          getOppositeComponent(): java.awt.Component;
          getCause(): java.awt.event.FocusEvent$Cause;
        }
        const ComponentEvent: {
          COMPONENT_FIRST: number;
          COMPONENT_LAST: number;
          COMPONENT_MOVED: number;
          COMPONENT_RESIZED: number;
          COMPONENT_SHOWN: number;
          COMPONENT_HIDDEN: number;
          new(p0: java.awt.Component, p1: number): java.awt.event.ComponentEvent;
        }
        interface ComponentEvent extends java.awt.AWTEvent { 
          getComponent(): java.awt.Component;
        }
        const FocusEvent$Cause: {
          UNKNOWN: java.awt.event.FocusEvent$Cause;
          MOUSE_EVENT: java.awt.event.FocusEvent$Cause;
          TRAVERSAL: java.awt.event.FocusEvent$Cause;
          TRAVERSAL_UP: java.awt.event.FocusEvent$Cause;
          TRAVERSAL_DOWN: java.awt.event.FocusEvent$Cause;
          TRAVERSAL_FORWARD: java.awt.event.FocusEvent$Cause;
          TRAVERSAL_BACKWARD: java.awt.event.FocusEvent$Cause;
          ROLLBACK: java.awt.event.FocusEvent$Cause;
          UNEXPECTED: java.awt.event.FocusEvent$Cause;
          ACTIVATION: java.awt.event.FocusEvent$Cause;
          CLEAR_GLOBAL_FOCUS_OWNER: java.awt.event.FocusEvent$Cause;
          valueOf(value: string): java.awt.event.FocusEvent$Cause;
          values(): Array<java.awt.event.FocusEvent$Cause>;
        }
        interface FocusEvent$Cause extends kotlin.Enum<java.awt.event.FocusEvent$Cause> { 
        }
        interface ActionListener extends java.util.EventListener { 
          actionPerformed(p0: java.awt.event.ActionEvent): void;
        }
        const ActionEvent: {
          SHIFT_MASK: number;
          CTRL_MASK: number;
          META_MASK: number;
          ALT_MASK: number;
          ACTION_FIRST: number;
          ACTION_LAST: number;
          ACTION_PERFORMED: number;
          new(p0: any, p1: number, p2: string): java.awt.event.ActionEvent;
          new(p0: any, p1: number, p2: string, p3: number): java.awt.event.ActionEvent;
          new(p0: any, p1: number, p2: string, p3: number, p4: number): java.awt.event.ActionEvent;
        }
        interface ActionEvent extends java.awt.AWTEvent { 
          getActionCommand(): string;
          getWhen(): number;
          getModifiers(): number;
        }
        const InputEvent: {
          SHIFT_MASK: number;
          CTRL_MASK: number;
          META_MASK: number;
          ALT_MASK: number;
          ALT_GRAPH_MASK: number;
          BUTTON1_MASK: number;
          BUTTON2_MASK: number;
          BUTTON3_MASK: number;
          SHIFT_DOWN_MASK: number;
          CTRL_DOWN_MASK: number;
          META_DOWN_MASK: number;
          ALT_DOWN_MASK: number;
          BUTTON1_DOWN_MASK: number;
          BUTTON2_DOWN_MASK: number;
          BUTTON3_DOWN_MASK: number;
          ALT_GRAPH_DOWN_MASK: number;
          getMaskForButton(p0: number): number;
          getModifiersExText(p0: number): string;
        }
        interface InputEvent extends java.awt.event.ComponentEvent { 
          isShiftDown(): boolean;
          isControlDown(): boolean;
          isMetaDown(): boolean;
          isAltDown(): boolean;
          isAltGraphDown(): boolean;
          getWhen(): number;
          getModifiers(): number;
          getModifiersEx(): number;
        }
        interface AWTEventListener extends java.util.EventListener { 
          eventDispatched(p0: java.awt.AWTEvent): void;
        }
        interface ComponentListener extends java.util.EventListener { 
          componentResized(p0: java.awt.event.ComponentEvent): void;
          componentMoved(p0: java.awt.event.ComponentEvent): void;
          componentShown(p0: java.awt.event.ComponentEvent): void;
          componentHidden(p0: java.awt.event.ComponentEvent): void;
        }
        interface HierarchyListener extends java.util.EventListener { 
          hierarchyChanged(p0: java.awt.event.HierarchyEvent): void;
        }
        const HierarchyEvent: {
          HIERARCHY_FIRST: number;
          HIERARCHY_CHANGED: number;
          ANCESTOR_MOVED: number;
          ANCESTOR_RESIZED: number;
          HIERARCHY_LAST: number;
          PARENT_CHANGED: number;
          DISPLAYABILITY_CHANGED: number;
          SHOWING_CHANGED: number;
          new(p0: java.awt.Component, p1: number, p2: java.awt.Component, p3: java.awt.Container): java.awt.event.HierarchyEvent;
          new(p0: java.awt.Component, p1: number, p2: java.awt.Component, p3: java.awt.Container, p4: number): java.awt.event.HierarchyEvent;
        }
        interface HierarchyEvent extends java.awt.AWTEvent { 
          getComponent(): java.awt.Component;
          getChanged(): java.awt.Component;
          getChangedParent(): java.awt.Container;
          getChangeFlags(): number;
        }
        interface HierarchyBoundsListener extends java.util.EventListener { 
          ancestorMoved(p0: java.awt.event.HierarchyEvent): void;
          ancestorResized(p0: java.awt.event.HierarchyEvent): void;
        }
        interface KeyListener extends java.util.EventListener { 
          keyTyped(p0: java.awt.event.KeyEvent): void;
          keyPressed(p0: java.awt.event.KeyEvent): void;
          keyReleased(p0: java.awt.event.KeyEvent): void;
        }
        const KeyEvent: {
          KEY_FIRST: number;
          KEY_LAST: number;
          KEY_TYPED: number;
          KEY_PRESSED: number;
          KEY_RELEASED: number;
          VK_ENTER: number;
          VK_BACK_SPACE: number;
          VK_TAB: number;
          VK_CANCEL: number;
          VK_CLEAR: number;
          VK_SHIFT: number;
          VK_CONTROL: number;
          VK_ALT: number;
          VK_PAUSE: number;
          VK_CAPS_LOCK: number;
          VK_ESCAPE: number;
          VK_SPACE: number;
          VK_PAGE_UP: number;
          VK_PAGE_DOWN: number;
          VK_END: number;
          VK_HOME: number;
          VK_LEFT: number;
          VK_UP: number;
          VK_RIGHT: number;
          VK_DOWN: number;
          VK_COMMA: number;
          VK_MINUS: number;
          VK_PERIOD: number;
          VK_SLASH: number;
          VK_0: number;
          VK_1: number;
          VK_2: number;
          VK_3: number;
          VK_4: number;
          VK_5: number;
          VK_6: number;
          VK_7: number;
          VK_8: number;
          VK_9: number;
          VK_SEMICOLON: number;
          VK_EQUALS: number;
          VK_A: number;
          VK_B: number;
          VK_C: number;
          VK_D: number;
          VK_E: number;
          VK_F: number;
          VK_G: number;
          VK_H: number;
          VK_I: number;
          VK_J: number;
          VK_K: number;
          VK_L: number;
          VK_M: number;
          VK_N: number;
          VK_O: number;
          VK_P: number;
          VK_Q: number;
          VK_R: number;
          VK_S: number;
          VK_T: number;
          VK_U: number;
          VK_V: number;
          VK_W: number;
          VK_X: number;
          VK_Y: number;
          VK_Z: number;
          VK_OPEN_BRACKET: number;
          VK_BACK_SLASH: number;
          VK_CLOSE_BRACKET: number;
          VK_NUMPAD0: number;
          VK_NUMPAD1: number;
          VK_NUMPAD2: number;
          VK_NUMPAD3: number;
          VK_NUMPAD4: number;
          VK_NUMPAD5: number;
          VK_NUMPAD6: number;
          VK_NUMPAD7: number;
          VK_NUMPAD8: number;
          VK_NUMPAD9: number;
          VK_MULTIPLY: number;
          VK_ADD: number;
          VK_SEPARATER: number;
          VK_SEPARATOR: number;
          VK_SUBTRACT: number;
          VK_DECIMAL: number;
          VK_DIVIDE: number;
          VK_DELETE: number;
          VK_NUM_LOCK: number;
          VK_SCROLL_LOCK: number;
          VK_F1: number;
          VK_F2: number;
          VK_F3: number;
          VK_F4: number;
          VK_F5: number;
          VK_F6: number;
          VK_F7: number;
          VK_F8: number;
          VK_F9: number;
          VK_F10: number;
          VK_F11: number;
          VK_F12: number;
          VK_F13: number;
          VK_F14: number;
          VK_F15: number;
          VK_F16: number;
          VK_F17: number;
          VK_F18: number;
          VK_F19: number;
          VK_F20: number;
          VK_F21: number;
          VK_F22: number;
          VK_F23: number;
          VK_F24: number;
          VK_PRINTSCREEN: number;
          VK_INSERT: number;
          VK_HELP: number;
          VK_META: number;
          VK_BACK_QUOTE: number;
          VK_QUOTE: number;
          VK_KP_UP: number;
          VK_KP_DOWN: number;
          VK_KP_LEFT: number;
          VK_KP_RIGHT: number;
          VK_DEAD_GRAVE: number;
          VK_DEAD_ACUTE: number;
          VK_DEAD_CIRCUMFLEX: number;
          VK_DEAD_TILDE: number;
          VK_DEAD_MACRON: number;
          VK_DEAD_BREVE: number;
          VK_DEAD_ABOVEDOT: number;
          VK_DEAD_DIAERESIS: number;
          VK_DEAD_ABOVERING: number;
          VK_DEAD_DOUBLEACUTE: number;
          VK_DEAD_CARON: number;
          VK_DEAD_CEDILLA: number;
          VK_DEAD_OGONEK: number;
          VK_DEAD_IOTA: number;
          VK_DEAD_VOICED_SOUND: number;
          VK_DEAD_SEMIVOICED_SOUND: number;
          VK_AMPERSAND: number;
          VK_ASTERISK: number;
          VK_QUOTEDBL: number;
          VK_LESS: number;
          VK_GREATER: number;
          VK_BRACELEFT: number;
          VK_BRACERIGHT: number;
          VK_AT: number;
          VK_COLON: number;
          VK_CIRCUMFLEX: number;
          VK_DOLLAR: number;
          VK_EURO_SIGN: number;
          VK_EXCLAMATION_MARK: number;
          VK_INVERTED_EXCLAMATION_MARK: number;
          VK_LEFT_PARENTHESIS: number;
          VK_NUMBER_SIGN: number;
          VK_PLUS: number;
          VK_RIGHT_PARENTHESIS: number;
          VK_UNDERSCORE: number;
          VK_WINDOWS: number;
          VK_CONTEXT_MENU: number;
          VK_FINAL: number;
          VK_CONVERT: number;
          VK_NONCONVERT: number;
          VK_ACCEPT: number;
          VK_MODECHANGE: number;
          VK_KANA: number;
          VK_KANJI: number;
          VK_ALPHANUMERIC: number;
          VK_KATAKANA: number;
          VK_HIRAGANA: number;
          VK_FULL_WIDTH: number;
          VK_HALF_WIDTH: number;
          VK_ROMAN_CHARACTERS: number;
          VK_ALL_CANDIDATES: number;
          VK_PREVIOUS_CANDIDATE: number;
          VK_CODE_INPUT: number;
          VK_JAPANESE_KATAKANA: number;
          VK_JAPANESE_HIRAGANA: number;
          VK_JAPANESE_ROMAN: number;
          VK_KANA_LOCK: number;
          VK_INPUT_METHOD_ON_OFF: number;
          VK_CUT: number;
          VK_COPY: number;
          VK_PASTE: number;
          VK_UNDO: number;
          VK_AGAIN: number;
          VK_FIND: number;
          VK_PROPS: number;
          VK_STOP: number;
          VK_COMPOSE: number;
          VK_ALT_GRAPH: number;
          VK_BEGIN: number;
          VK_UNDEFINED: number;
          CHAR_UNDEFINED: number;
          KEY_LOCATION_UNKNOWN: number;
          KEY_LOCATION_STANDARD: number;
          KEY_LOCATION_LEFT: number;
          KEY_LOCATION_RIGHT: number;
          KEY_LOCATION_NUMPAD: number;
          getKeyText(p0: number): string;
          getKeyModifiersText(p0: number): string;
          getExtendedKeyCodeForChar(p0: number): number;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number): java.awt.event.KeyEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number): java.awt.event.KeyEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number): java.awt.event.KeyEvent;
        }
        interface KeyEvent extends java.awt.event.InputEvent { 
          getKeyCode(): number;
          setKeyCode(p0: number): void;
          getKeyChar(): number;
          setKeyChar(p0: number): void;
          setModifiers(p0: number): void;
          getKeyLocation(): number;
          isActionKey(): boolean;
          getExtendedKeyCode(): number;
        }
        interface MouseListener extends java.util.EventListener { 
          mouseClicked(p0: java.awt.event.MouseEvent): void;
          mousePressed(p0: java.awt.event.MouseEvent): void;
          mouseReleased(p0: java.awt.event.MouseEvent): void;
          mouseEntered(p0: java.awt.event.MouseEvent): void;
          mouseExited(p0: java.awt.event.MouseEvent): void;
        }
        const MouseEvent: {
          MOUSE_FIRST: number;
          MOUSE_LAST: number;
          MOUSE_CLICKED: number;
          MOUSE_PRESSED: number;
          MOUSE_RELEASED: number;
          MOUSE_MOVED: number;
          MOUSE_ENTERED: number;
          MOUSE_EXITED: number;
          MOUSE_DRAGGED: number;
          MOUSE_WHEEL: number;
          NOBUTTON: number;
          BUTTON1: number;
          BUTTON2: number;
          BUTTON3: number;
          getMouseModifiersText(p0: number): string;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: boolean, p8: number): java.awt.event.MouseEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: boolean): java.awt.event.MouseEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number, p8: number, p9: boolean, p10: number): java.awt.event.MouseEvent;
        }
        interface MouseEvent extends java.awt.event.InputEvent { 
          getLocationOnScreen(): java.awt.Point;
          getXOnScreen(): number;
          getYOnScreen(): number;
          getX(): number;
          getY(): number;
          getPoint(): java.awt.Point;
          translatePoint(p0: number, p1: number): void;
          getClickCount(): number;
          getButton(): number;
          isPopupTrigger(): boolean;
        }
        interface MouseMotionListener extends java.util.EventListener { 
          mouseDragged(p0: java.awt.event.MouseEvent): void;
          mouseMoved(p0: java.awt.event.MouseEvent): void;
        }
        interface MouseWheelListener extends java.util.EventListener { 
          mouseWheelMoved(p0: java.awt.event.MouseWheelEvent): void;
        }
        const MouseWheelEvent: {
          WHEEL_UNIT_SCROLL: number;
          WHEEL_BLOCK_SCROLL: number;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: boolean, p8: number, p9: number, p10: number): java.awt.event.MouseWheelEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number, p8: number, p9: boolean, p10: number, p11: number, p12: number): java.awt.event.MouseWheelEvent;
          new(p0: java.awt.Component, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number, p8: number, p9: boolean, p10: number, p11: number, p12: number, p13: number): java.awt.event.MouseWheelEvent;
        }
        interface MouseWheelEvent extends java.awt.event.MouseEvent { 
          getScrollType(): number;
          getScrollAmount(): number;
          getWheelRotation(): number;
          getPreciseWheelRotation(): number;
          getUnitsToScroll(): number;
        }
        interface InputMethodListener extends java.util.EventListener { 
          inputMethodTextChanged(p0: java.awt.event.InputMethodEvent): void;
          caretPositionChanged(p0: java.awt.event.InputMethodEvent): void;
        }
        const InputMethodEvent: {
          INPUT_METHOD_FIRST: number;
          INPUT_METHOD_TEXT_CHANGED: number;
          CARET_POSITION_CHANGED: number;
          INPUT_METHOD_LAST: number;
          new(p0: java.awt.Component, p1: number, p2: number, p3: java.text.AttributedCharacterIterator, p4: number, p5: java.awt.font.TextHitInfo, p6: java.awt.font.TextHitInfo): java.awt.event.InputMethodEvent;
          new(p0: java.awt.Component, p1: number, p2: java.text.AttributedCharacterIterator, p3: number, p4: java.awt.font.TextHitInfo, p5: java.awt.font.TextHitInfo): java.awt.event.InputMethodEvent;
          new(p0: java.awt.Component, p1: number, p2: java.awt.font.TextHitInfo, p3: java.awt.font.TextHitInfo): java.awt.event.InputMethodEvent;
        }
        interface InputMethodEvent extends java.awt.AWTEvent { 
          getText(): java.text.AttributedCharacterIterator;
          getCommittedCharacterCount(): number;
          getCaret(): java.awt.font.TextHitInfo;
          getVisiblePosition(): java.awt.font.TextHitInfo;
          getWhen(): number;
        }
        interface ContainerListener extends java.util.EventListener { 
          componentAdded(p0: java.awt.event.ContainerEvent): void;
          componentRemoved(p0: java.awt.event.ContainerEvent): void;
        }
        const ContainerEvent: {
          CONTAINER_FIRST: number;
          CONTAINER_LAST: number;
          COMPONENT_ADDED: number;
          COMPONENT_REMOVED: number;
          new(p0: java.awt.Component, p1: number, p2: java.awt.Component): java.awt.event.ContainerEvent;
        }
        interface ContainerEvent extends java.awt.event.ComponentEvent { 
          getContainer(): java.awt.Container;
          getChild(): java.awt.Component;
        }
        interface WindowListener extends java.util.EventListener { 
          windowOpened(p0: java.awt.event.WindowEvent): void;
          windowClosing(p0: java.awt.event.WindowEvent): void;
          windowClosed(p0: java.awt.event.WindowEvent): void;
          windowIconified(p0: java.awt.event.WindowEvent): void;
          windowDeiconified(p0: java.awt.event.WindowEvent): void;
          windowActivated(p0: java.awt.event.WindowEvent): void;
          windowDeactivated(p0: java.awt.event.WindowEvent): void;
        }
        const WindowEvent: {
          WINDOW_FIRST: number;
          WINDOW_OPENED: number;
          WINDOW_CLOSING: number;
          WINDOW_CLOSED: number;
          WINDOW_ICONIFIED: number;
          WINDOW_DEICONIFIED: number;
          WINDOW_ACTIVATED: number;
          WINDOW_DEACTIVATED: number;
          WINDOW_GAINED_FOCUS: number;
          WINDOW_LOST_FOCUS: number;
          WINDOW_STATE_CHANGED: number;
          WINDOW_LAST: number;
          new(p0: java.awt.Window, p1: number, p2: java.awt.Window, p3: number, p4: number): java.awt.event.WindowEvent;
          new(p0: java.awt.Window, p1: number, p2: java.awt.Window): java.awt.event.WindowEvent;
          new(p0: java.awt.Window, p1: number, p2: number, p3: number): java.awt.event.WindowEvent;
          new(p0: java.awt.Window, p1: number): java.awt.event.WindowEvent;
        }
        interface WindowEvent extends java.awt.event.ComponentEvent { 
          getWindow(): java.awt.Window;
          getOppositeWindow(): java.awt.Window;
          getOldState(): number;
          getNewState(): number;
        }
        interface WindowStateListener extends java.util.EventListener { 
          windowStateChanged(p0: java.awt.event.WindowEvent): void;
        }
        interface WindowFocusListener extends java.util.EventListener { 
          windowGainedFocus(p0: java.awt.event.WindowEvent): void;
          windowLostFocus(p0: java.awt.event.WindowEvent): void;
        }
      }
      namespace dnd {
        const DropTarget: {
          new(p0: java.awt.Component, p1: number, p2: java.awt.dnd.DropTargetListener, p3: boolean, p4: java.awt.datatransfer.FlavorMap): java.awt.dnd.DropTarget;
          new(p0: java.awt.Component, p1: number, p2: java.awt.dnd.DropTargetListener, p3: boolean): java.awt.dnd.DropTarget;
          new(): java.awt.dnd.DropTarget;
          new(p0: java.awt.Component, p1: java.awt.dnd.DropTargetListener): java.awt.dnd.DropTarget;
          new(p0: java.awt.Component, p1: number, p2: java.awt.dnd.DropTargetListener): java.awt.dnd.DropTarget;
        }
        interface DropTarget extends java.awt.dnd.DropTargetListener, java.io.Serializable { 
          setComponent(p0: java.awt.Component): void;
          getComponent(): java.awt.Component;
          setDefaultActions(p0: number): void;
          getDefaultActions(): number;
          setActive(p0: boolean): void;
          isActive(): boolean;
          addDropTargetListener(p0: java.awt.dnd.DropTargetListener): void;
          removeDropTargetListener(p0: java.awt.dnd.DropTargetListener): void;
          getFlavorMap(): java.awt.datatransfer.FlavorMap;
          setFlavorMap(p0: java.awt.datatransfer.FlavorMap): void;
          addNotify(): void;
          removeNotify(): void;
          getDropTargetContext(): java.awt.dnd.DropTargetContext;
        }
        interface DropTargetListener extends java.util.EventListener { 
          dragEnter(p0: java.awt.dnd.DropTargetDragEvent): void;
          dragOver(p0: java.awt.dnd.DropTargetDragEvent): void;
          dropActionChanged(p0: java.awt.dnd.DropTargetDragEvent): void;
          dragExit(p0: java.awt.dnd.DropTargetEvent): void;
          drop(p0: java.awt.dnd.DropTargetDropEvent): void;
        }
        const DropTargetDragEvent: {
          new(p0: java.awt.dnd.DropTargetContext, p1: java.awt.Point, p2: number, p3: number): java.awt.dnd.DropTargetDragEvent;
        }
        interface DropTargetDragEvent extends java.awt.dnd.DropTargetEvent { 
          getLocation(): java.awt.Point;
          getCurrentDataFlavors(): Array<java.awt.datatransfer.DataFlavor>;
          getCurrentDataFlavorsAsList(): Array<java.awt.datatransfer.DataFlavor>;
          isDataFlavorSupported(p0: java.awt.datatransfer.DataFlavor): boolean;
          getSourceActions(): number;
          getDropAction(): number;
          getTransferable(): java.awt.datatransfer.Transferable;
          acceptDrag(p0: number): void;
          rejectDrag(): void;
        }
        const DropTargetEvent: {
          new(p0: java.awt.dnd.DropTargetContext): java.awt.dnd.DropTargetEvent;
        }
        interface DropTargetEvent extends java.util.EventObject { 
          getDropTargetContext(): java.awt.dnd.DropTargetContext;
        }
        interface DropTargetContext extends java.io.Serializable { 
          getDropTarget(): java.awt.dnd.DropTarget;
          getComponent(): java.awt.Component;
          dropComplete(p0: boolean): void;
        }
        const DropTargetDropEvent: {
          new(p0: java.awt.dnd.DropTargetContext, p1: java.awt.Point, p2: number, p3: number): java.awt.dnd.DropTargetDropEvent;
          new(p0: java.awt.dnd.DropTargetContext, p1: java.awt.Point, p2: number, p3: number, p4: boolean): java.awt.dnd.DropTargetDropEvent;
        }
        interface DropTargetDropEvent extends java.awt.dnd.DropTargetEvent { 
          getLocation(): java.awt.Point;
          getCurrentDataFlavors(): Array<java.awt.datatransfer.DataFlavor>;
          getCurrentDataFlavorsAsList(): Array<java.awt.datatransfer.DataFlavor>;
          isDataFlavorSupported(p0: java.awt.datatransfer.DataFlavor): boolean;
          getSourceActions(): number;
          getDropAction(): number;
          getTransferable(): java.awt.datatransfer.Transferable;
          acceptDrop(p0: number): void;
          rejectDrop(): void;
          dropComplete(p0: boolean): void;
          isLocalTransfer(): boolean;
        }
        const DragSource: {
          DefaultCopyDrop: java.awt.Cursor;
          DefaultMoveDrop: java.awt.Cursor;
          DefaultLinkDrop: java.awt.Cursor;
          DefaultCopyNoDrop: java.awt.Cursor;
          DefaultMoveNoDrop: java.awt.Cursor;
          DefaultLinkNoDrop: java.awt.Cursor;
          getDefaultDragSource(): java.awt.dnd.DragSource;
          isDragImageSupported(): boolean;
          getDragThreshold(): number;
          new(): java.awt.dnd.DragSource;
        }
        interface DragSource extends java.io.Serializable { 
          startDrag(p0: java.awt.dnd.DragGestureEvent, p1: java.awt.Cursor, p2: java.awt.Image, p3: java.awt.Point, p4: java.awt.datatransfer.Transferable, p5: java.awt.dnd.DragSourceListener, p6: java.awt.datatransfer.FlavorMap): void;
          startDrag(p0: java.awt.dnd.DragGestureEvent, p1: java.awt.Cursor, p2: java.awt.datatransfer.Transferable, p3: java.awt.dnd.DragSourceListener, p4: java.awt.datatransfer.FlavorMap): void;
          startDrag(p0: java.awt.dnd.DragGestureEvent, p1: java.awt.Cursor, p2: java.awt.Image, p3: java.awt.Point, p4: java.awt.datatransfer.Transferable, p5: java.awt.dnd.DragSourceListener): void;
          startDrag(p0: java.awt.dnd.DragGestureEvent, p1: java.awt.Cursor, p2: java.awt.datatransfer.Transferable, p3: java.awt.dnd.DragSourceListener): void;
          getFlavorMap(): java.awt.datatransfer.FlavorMap;
          createDragGestureRecognizer<T>(p0: java.lang.Class<T>, p1: java.awt.Component, p2: number, p3: java.awt.dnd.DragGestureListener): T;
          createDefaultDragGestureRecognizer(p0: java.awt.Component, p1: number, p2: java.awt.dnd.DragGestureListener): java.awt.dnd.DragGestureRecognizer;
          addDragSourceListener(p0: java.awt.dnd.DragSourceListener): void;
          removeDragSourceListener(p0: java.awt.dnd.DragSourceListener): void;
          getDragSourceListeners(): Array<java.awt.dnd.DragSourceListener>;
          addDragSourceMotionListener(p0: java.awt.dnd.DragSourceMotionListener): void;
          removeDragSourceMotionListener(p0: java.awt.dnd.DragSourceMotionListener): void;
          getDragSourceMotionListeners(): Array<java.awt.dnd.DragSourceMotionListener>;
          getListeners<T>(p0: java.lang.Class<T>): Array<T>;
        }
        const DragGestureEvent: {
          new(p0: java.awt.dnd.DragGestureRecognizer, p1: number, p2: java.awt.Point, p3: Array<java.awt.event.InputEvent>): java.awt.dnd.DragGestureEvent;
        }
        interface DragGestureEvent extends java.util.EventObject { 
          getSourceAsDragGestureRecognizer(): java.awt.dnd.DragGestureRecognizer;
          getComponent(): java.awt.Component;
          getDragSource(): java.awt.dnd.DragSource;
          getDragOrigin(): java.awt.Point;
          iterator(): kotlin.collections.MutableIterator<java.awt.event.InputEvent>;
          toArray(): Array<any>;
          toArray(p0: Array<any>): Array<any>;
          getDragAction(): number;
          getTriggerEvent(): java.awt.event.InputEvent;
          startDrag(p0: java.awt.Cursor, p1: java.awt.datatransfer.Transferable): void;
          startDrag(p0: java.awt.Cursor, p1: java.awt.datatransfer.Transferable, p2: java.awt.dnd.DragSourceListener): void;
          startDrag(p0: java.awt.Cursor, p1: java.awt.Image, p2: java.awt.Point, p3: java.awt.datatransfer.Transferable, p4: java.awt.dnd.DragSourceListener): void;
        }
        interface DragGestureRecognizer extends java.io.Serializable { 
          getDragSource(): java.awt.dnd.DragSource;
          getComponent(): java.awt.Component;
          setComponent(p0: java.awt.Component): void;
          getSourceActions(): number;
          setSourceActions(p0: number): void;
          getTriggerEvent(): java.awt.event.InputEvent;
          resetRecognizer(): void;
          addDragGestureListener(p0: java.awt.dnd.DragGestureListener): void;
          removeDragGestureListener(p0: java.awt.dnd.DragGestureListener): void;
        }
        interface DragGestureListener extends java.util.EventListener { 
          dragGestureRecognized(p0: java.awt.dnd.DragGestureEvent): void;
        }
        interface DragSourceListener extends java.util.EventListener { 
          dragEnter(p0: java.awt.dnd.DragSourceDragEvent): void;
          dragOver(p0: java.awt.dnd.DragSourceDragEvent): void;
          dropActionChanged(p0: java.awt.dnd.DragSourceDragEvent): void;
          dragExit(p0: java.awt.dnd.DragSourceEvent): void;
          dragDropEnd(p0: java.awt.dnd.DragSourceDropEvent): void;
        }
        const DragSourceDragEvent: {
          new(p0: java.awt.dnd.DragSourceContext, p1: number, p2: number, p3: number): java.awt.dnd.DragSourceDragEvent;
          new(p0: java.awt.dnd.DragSourceContext, p1: number, p2: number, p3: number, p4: number, p5: number): java.awt.dnd.DragSourceDragEvent;
        }
        interface DragSourceDragEvent extends java.awt.dnd.DragSourceEvent { 
          getTargetActions(): number;
          getGestureModifiers(): number;
          getGestureModifiersEx(): number;
          getUserAction(): number;
          getDropAction(): number;
        }
        const DragSourceEvent: {
          new(p0: java.awt.dnd.DragSourceContext): java.awt.dnd.DragSourceEvent;
          new(p0: java.awt.dnd.DragSourceContext, p1: number, p2: number): java.awt.dnd.DragSourceEvent;
        }
        interface DragSourceEvent extends java.util.EventObject { 
          getDragSourceContext(): java.awt.dnd.DragSourceContext;
          getLocation(): java.awt.Point;
          getX(): number;
          getY(): number;
        }
        const DragSourceContext: {
          new(p0: java.awt.dnd.DragGestureEvent, p1: java.awt.Cursor, p2: java.awt.Image, p3: java.awt.Point, p4: java.awt.datatransfer.Transferable, p5: java.awt.dnd.DragSourceListener): java.awt.dnd.DragSourceContext;
        }
        interface DragSourceContext extends java.awt.dnd.DragSourceListener, java.awt.dnd.DragSourceMotionListener, java.io.Serializable { 
          getDragSource(): java.awt.dnd.DragSource;
          getComponent(): java.awt.Component;
          getTrigger(): java.awt.dnd.DragGestureEvent;
          getSourceActions(): number;
          setCursor(p0: java.awt.Cursor): void;
          getCursor(): java.awt.Cursor;
          addDragSourceListener(p0: java.awt.dnd.DragSourceListener): void;
          removeDragSourceListener(p0: java.awt.dnd.DragSourceListener): void;
          transferablesFlavorsChanged(): void;
          getTransferable(): java.awt.datatransfer.Transferable;
        }
        interface DragSourceMotionListener extends java.util.EventListener { 
          dragMouseMoved(p0: java.awt.dnd.DragSourceDragEvent): void;
        }
        const DragSourceDropEvent: {
          new(p0: java.awt.dnd.DragSourceContext, p1: number, p2: boolean): java.awt.dnd.DragSourceDropEvent;
          new(p0: java.awt.dnd.DragSourceContext, p1: number, p2: boolean, p3: number, p4: number): java.awt.dnd.DragSourceDropEvent;
          new(p0: java.awt.dnd.DragSourceContext): java.awt.dnd.DragSourceDropEvent;
        }
        interface DragSourceDropEvent extends java.awt.dnd.DragSourceEvent { 
          getDropSuccess(): boolean;
          getDropAction(): number;
        }
      }
      namespace datatransfer {
        const DataFlavor: {
          stringFlavor: java.awt.datatransfer.DataFlavor;
          imageFlavor: java.awt.datatransfer.DataFlavor;
          plainTextFlavor: java.awt.datatransfer.DataFlavor;
          javaSerializedObjectMimeType: string;
          javaFileListFlavor: java.awt.datatransfer.DataFlavor;
          javaJVMLocalObjectMimeType: string;
          javaRemoteObjectMimeType: string;
          selectionHtmlFlavor: java.awt.datatransfer.DataFlavor;
          fragmentHtmlFlavor: java.awt.datatransfer.DataFlavor;
          allHtmlFlavor: java.awt.datatransfer.DataFlavor;
          getTextPlainUnicodeFlavor(): java.awt.datatransfer.DataFlavor;
          selectBestTextFlavor(p0: Array<java.awt.datatransfer.DataFlavor>): java.awt.datatransfer.DataFlavor;
          new(): java.awt.datatransfer.DataFlavor;
          new(p0: java.lang.Class<any>, p1: string): java.awt.datatransfer.DataFlavor;
          new(p0: string, p1: string): java.awt.datatransfer.DataFlavor;
          new(p0: string, p1: string, p2: java.lang.ClassLoader): java.awt.datatransfer.DataFlavor;
          new(p0: string): java.awt.datatransfer.DataFlavor;
        }
        interface DataFlavor extends java.io.Externalizable, kotlin.Cloneable { 
          getReaderForText(p0: java.awt.datatransfer.Transferable): java.io.Reader;
          getMimeType(): string;
          getRepresentationClass(): java.lang.Class<any>;
          getHumanPresentableName(): string;
          getPrimaryType(): string;
          getSubType(): string;
          getParameter(p0: string): string;
          setHumanPresentableName(p0: string): void;
          match(p0: java.awt.datatransfer.DataFlavor): boolean;
          isMimeTypeEqual(p0: string): boolean;
          isMimeTypeEqual(p0: java.awt.datatransfer.DataFlavor): boolean;
          isMimeTypeSerializedObject(): boolean;
          getDefaultRepresentationClass(): java.lang.Class<any>;
          getDefaultRepresentationClassAsString(): string;
          isRepresentationClassInputStream(): boolean;
          isRepresentationClassReader(): boolean;
          isRepresentationClassCharBuffer(): boolean;
          isRepresentationClassByteBuffer(): boolean;
          isRepresentationClassSerializable(): boolean;
          isRepresentationClassRemote(): boolean;
          isFlavorSerializedObjectType(): boolean;
          isFlavorRemoteObjectType(): boolean;
          isFlavorJavaFileListType(): boolean;
          isFlavorTextType(): boolean;
        }
        interface Transferable { 
          getTransferDataFlavors(): Array<java.awt.datatransfer.DataFlavor>;
          isDataFlavorSupported(p0: java.awt.datatransfer.DataFlavor): boolean;
          getTransferData(p0: java.awt.datatransfer.DataFlavor): any;
        }
        interface FlavorMap { 
          getNativesForFlavors(p0: Array<java.awt.datatransfer.DataFlavor>): Map<java.awt.datatransfer.DataFlavor, string>;
          getFlavorsForNatives(p0: Array<string>): Map<string, java.awt.datatransfer.DataFlavor>;
        }
        const Clipboard: {
          new(p0: string): java.awt.datatransfer.Clipboard;
        }
        interface Clipboard { 
          getName(): string;
          setContents(p0: java.awt.datatransfer.Transferable, p1: java.awt.datatransfer.ClipboardOwner): void;
          getContents(p0: any): java.awt.datatransfer.Transferable;
          getAvailableDataFlavors(): Array<java.awt.datatransfer.DataFlavor>;
          isDataFlavorAvailable(p0: java.awt.datatransfer.DataFlavor): boolean;
          getData(p0: java.awt.datatransfer.DataFlavor): any;
          addFlavorListener(p0: java.awt.datatransfer.FlavorListener): void;
          removeFlavorListener(p0: java.awt.datatransfer.FlavorListener): void;
          getFlavorListeners(): Array<java.awt.datatransfer.FlavorListener>;
        }
        interface ClipboardOwner { 
          lostOwnership(p0: java.awt.datatransfer.Clipboard, p1: java.awt.datatransfer.Transferable): void;
        }
        interface FlavorListener extends java.util.EventListener { 
          flavorsChanged(p0: java.awt.datatransfer.FlavorEvent): void;
        }
        const FlavorEvent: {
          new(p0: java.awt.datatransfer.Clipboard): java.awt.datatransfer.FlavorEvent;
        }
        interface FlavorEvent extends java.util.EventObject { 
        }
      }
      namespace im {
        const InputMethodHighlight: {
          RAW_TEXT: number;
          CONVERTED_TEXT: number;
          UNSELECTED_RAW_TEXT_HIGHLIGHT: java.awt.im.InputMethodHighlight;
          SELECTED_RAW_TEXT_HIGHLIGHT: java.awt.im.InputMethodHighlight;
          UNSELECTED_CONVERTED_TEXT_HIGHLIGHT: java.awt.im.InputMethodHighlight;
          SELECTED_CONVERTED_TEXT_HIGHLIGHT: java.awt.im.InputMethodHighlight;
          new(p0: boolean, p1: number): java.awt.im.InputMethodHighlight;
          new(p0: boolean, p1: number, p2: number): java.awt.im.InputMethodHighlight;
          new(p0: boolean, p1: number, p2: number, p3: Map<unknown, any>): java.awt.im.InputMethodHighlight;
        }
        interface InputMethodHighlight { 
          isSelected(): boolean;
          getState(): number;
          getVariation(): number;
          getStyle(): Map<unknown, any>;
        }
        interface InputMethodRequests { 
          getTextLocation(p0: java.awt.font.TextHitInfo): java.awt.Rectangle;
          getLocationOffset(p0: number, p1: number): java.awt.font.TextHitInfo;
          getInsertPositionOffset(): number;
          getCommittedText(p0: number, p1: number, p2: Array<java.text.AttributedCharacterIterator$Attribute>): java.text.AttributedCharacterIterator;
          getCommittedTextLength(): number;
          cancelLatestCommittedText(p0: Array<java.text.AttributedCharacterIterator$Attribute>): java.text.AttributedCharacterIterator;
          getSelectedText(p0: Array<java.text.AttributedCharacterIterator$Attribute>): java.text.AttributedCharacterIterator;
        }
        const InputContext: {
          getInstance(): java.awt.im.InputContext;
        }
        interface InputContext { 
          selectInputMethod(p0: java.util.Locale): boolean;
          getLocale(): java.util.Locale;
          setCharacterSubsets(p0: Array<unknown>): void;
          setCompositionEnabled(p0: boolean): void;
          isCompositionEnabled(): boolean;
          reconvert(): void;
          dispatchEvent(p0: java.awt.AWTEvent): void;
          removeNotify(p0: java.awt.Component): void;
          endComposition(): void;
          dispose(): void;
          getInputMethodControlObject(): any;
        }
      }
      const Color: {
        white: java.awt.Color;
        WHITE: java.awt.Color;
        lightGray: java.awt.Color;
        LIGHT_GRAY: java.awt.Color;
        gray: java.awt.Color;
        GRAY: java.awt.Color;
        darkGray: java.awt.Color;
        DARK_GRAY: java.awt.Color;
        black: java.awt.Color;
        BLACK: java.awt.Color;
        red: java.awt.Color;
        RED: java.awt.Color;
        pink: java.awt.Color;
        PINK: java.awt.Color;
        orange: java.awt.Color;
        ORANGE: java.awt.Color;
        yellow: java.awt.Color;
        YELLOW: java.awt.Color;
        green: java.awt.Color;
        GREEN: java.awt.Color;
        magenta: java.awt.Color;
        MAGENTA: java.awt.Color;
        cyan: java.awt.Color;
        CYAN: java.awt.Color;
        blue: java.awt.Color;
        BLUE: java.awt.Color;
        decode(p0: string): java.awt.Color;
        getColor(p0: string): java.awt.Color;
        getColor(p0: string, p1: java.awt.Color): java.awt.Color;
        getColor(p0: string, p1: number): java.awt.Color;
        HSBtoRGB(p0: number, p1: number, p2: number): number;
        RGBtoHSB(p0: number, p1: number, p2: number, p3: kotlin.FloatArray): kotlin.FloatArray;
        getHSBColor(p0: number, p1: number, p2: number): java.awt.Color;
        new(p0: number, p1: number, p2: number): java.awt.Color;
        new(p0: number, p1: number, p2: number, p3: number): java.awt.Color;
        new(p0: number): java.awt.Color;
        new(p0: number, p1: boolean): java.awt.Color;
        new(p0: number, p1: number, p2: number): java.awt.Color;
        new(p0: number, p1: number, p2: number, p3: number): java.awt.Color;
        new(p0: java.awt.color.ColorSpace, p1: kotlin.FloatArray, p2: number): java.awt.Color;
      }
      interface Color extends java.awt.Paint, java.io.Serializable { 
        getRed(): number;
        getGreen(): number;
        getBlue(): number;
        getAlpha(): number;
        getRGB(): number;
        brighter(): java.awt.Color;
        darker(): java.awt.Color;
        getRGBComponents(p0: kotlin.FloatArray): kotlin.FloatArray;
        getRGBColorComponents(p0: kotlin.FloatArray): kotlin.FloatArray;
        getComponents(p0: kotlin.FloatArray): kotlin.FloatArray;
        getComponents(p0: java.awt.color.ColorSpace, p1: kotlin.FloatArray): kotlin.FloatArray;
        getColorComponents(p0: kotlin.FloatArray): kotlin.FloatArray;
        getColorComponents(p0: java.awt.color.ColorSpace, p1: kotlin.FloatArray): kotlin.FloatArray;
        getColorSpace(): java.awt.color.ColorSpace;
      }
      interface Paint extends java.awt.Transparency { 
        createContext(p0: java.awt.image.ColorModel, p1: java.awt.Rectangle, p2: java.awt.geom.Rectangle2D, p3: java.awt.geom.AffineTransform, p4: java.awt.RenderingHints): java.awt.PaintContext;
      }
      const Transparency: {
        OPAQUE: number;
        BITMASK: number;
        TRANSLUCENT: number;
      }
      interface Transparency { 
        getTransparency(): number;
      }
      const Rectangle: {
        new(): java.awt.Rectangle;
        new(p0: java.awt.Rectangle): java.awt.Rectangle;
        new(p0: number, p1: number, p2: number, p3: number): java.awt.Rectangle;
        new(p0: number, p1: number): java.awt.Rectangle;
        new(p0: java.awt.Point, p1: java.awt.Dimension): java.awt.Rectangle;
        new(p0: java.awt.Point): java.awt.Rectangle;
        new(p0: java.awt.Dimension): java.awt.Rectangle;
      }
      interface Rectangle extends java.awt.geom.Rectangle2D, java.awt.Shape, java.io.Serializable { 
        x: number;
        y: number;
        width: number;
        height: number;
        contains(p0: java.awt.Point): boolean;
        contains(p0: number, p1: number): boolean;
        contains(p0: java.awt.Rectangle): boolean;
        contains(p0: number, p1: number, p2: number, p3: number): boolean;
        intersects(p0: java.awt.Rectangle): boolean;
        add(p0: number, p1: number): void;
        add(p0: java.awt.Point): void;
        add(p0: java.awt.Rectangle): void;
        setBounds(p0: java.awt.Rectangle): void;
        setBounds(p0: number, p1: number, p2: number, p3: number): void;
        reshape(p0: number, p1: number, p2: number, p3: number): void;
        getLocation(): java.awt.Point;
        setLocation(p0: java.awt.Point): void;
        setLocation(p0: number, p1: number): void;
        move(p0: number, p1: number): void;
        translate(p0: number, p1: number): void;
        getSize(): java.awt.Dimension;
        setSize(p0: java.awt.Dimension): void;
        setSize(p0: number, p1: number): void;
        resize(p0: number, p1: number): void;
        inside(p0: number, p1: number): boolean;
        intersection(p0: java.awt.Rectangle): java.awt.Rectangle;
        union(p0: java.awt.Rectangle): java.awt.Rectangle;
        grow(p0: number, p1: number): void;
      }
      interface Shape { 
        getBounds(): java.awt.Rectangle;
        getBounds2D(): java.awt.geom.Rectangle2D;
        contains(p0: number, p1: number): boolean;
        contains(p0: java.awt.geom.Point2D): boolean;
        contains(p0: number, p1: number, p2: number, p3: number): boolean;
        contains(p0: java.awt.geom.Rectangle2D): boolean;
        intersects(p0: number, p1: number, p2: number, p3: number): boolean;
        intersects(p0: java.awt.geom.Rectangle2D): boolean;
        getPathIterator(p0: java.awt.geom.AffineTransform): java.awt.geom.PathIterator;
        getPathIterator(p0: java.awt.geom.AffineTransform, p1: number): java.awt.geom.PathIterator;
      }
      const Point: {
        new(): java.awt.Point;
        new(p0: java.awt.Point): java.awt.Point;
        new(p0: number, p1: number): java.awt.Point;
      }
      interface Point extends java.awt.geom.Point2D, java.io.Serializable { 
        x: number;
        y: number;
        setLocation(p0: java.awt.Point): void;
        setLocation(p0: number, p1: number): void;
        getLocation(): java.awt.Point;
        move(p0: number, p1: number): void;
        translate(p0: number, p1: number): void;
      }
      const Dimension: {
        new(): java.awt.Dimension;
        new(p0: java.awt.Dimension): java.awt.Dimension;
        new(p0: number, p1: number): java.awt.Dimension;
      }
      interface Dimension extends java.awt.geom.Dimension2D, java.io.Serializable { 
        width: number;
        height: number;
        setSize(p0: java.awt.Dimension): void;
        setSize(p0: number, p1: number): void;
        getSize(): java.awt.Dimension;
      }
      const RenderingHints: {
        Key: typeof java.awt.RenderingHints$Key;
        KEY_ANTIALIASING: java.awt.RenderingHints$Key;
        VALUE_ANTIALIAS_ON: any;
        VALUE_ANTIALIAS_OFF: any;
        VALUE_ANTIALIAS_DEFAULT: any;
        KEY_RENDERING: java.awt.RenderingHints$Key;
        VALUE_RENDER_SPEED: any;
        VALUE_RENDER_QUALITY: any;
        VALUE_RENDER_DEFAULT: any;
        KEY_DITHERING: java.awt.RenderingHints$Key;
        VALUE_DITHER_DISABLE: any;
        VALUE_DITHER_ENABLE: any;
        VALUE_DITHER_DEFAULT: any;
        KEY_TEXT_ANTIALIASING: java.awt.RenderingHints$Key;
        VALUE_TEXT_ANTIALIAS_ON: any;
        VALUE_TEXT_ANTIALIAS_OFF: any;
        VALUE_TEXT_ANTIALIAS_DEFAULT: any;
        VALUE_TEXT_ANTIALIAS_GASP: any;
        VALUE_TEXT_ANTIALIAS_LCD_HRGB: any;
        VALUE_TEXT_ANTIALIAS_LCD_HBGR: any;
        VALUE_TEXT_ANTIALIAS_LCD_VRGB: any;
        VALUE_TEXT_ANTIALIAS_LCD_VBGR: any;
        KEY_TEXT_LCD_CONTRAST: java.awt.RenderingHints$Key;
        KEY_FRACTIONALMETRICS: java.awt.RenderingHints$Key;
        VALUE_FRACTIONALMETRICS_OFF: any;
        VALUE_FRACTIONALMETRICS_ON: any;
        VALUE_FRACTIONALMETRICS_DEFAULT: any;
        KEY_INTERPOLATION: java.awt.RenderingHints$Key;
        VALUE_INTERPOLATION_NEAREST_NEIGHBOR: any;
        VALUE_INTERPOLATION_BILINEAR: any;
        VALUE_INTERPOLATION_BICUBIC: any;
        KEY_ALPHA_INTERPOLATION: java.awt.RenderingHints$Key;
        VALUE_ALPHA_INTERPOLATION_SPEED: any;
        VALUE_ALPHA_INTERPOLATION_QUALITY: any;
        VALUE_ALPHA_INTERPOLATION_DEFAULT: any;
        KEY_COLOR_RENDERING: java.awt.RenderingHints$Key;
        VALUE_COLOR_RENDER_SPEED: any;
        VALUE_COLOR_RENDER_QUALITY: any;
        VALUE_COLOR_RENDER_DEFAULT: any;
        KEY_STROKE_CONTROL: java.awt.RenderingHints$Key;
        VALUE_STROKE_DEFAULT: any;
        VALUE_STROKE_NORMALIZE: any;
        VALUE_STROKE_PURE: any;
        KEY_RESOLUTION_VARIANT: java.awt.RenderingHints$Key;
        VALUE_RESOLUTION_VARIANT_DEFAULT: any;
        VALUE_RESOLUTION_VARIANT_BASE: any;
        VALUE_RESOLUTION_VARIANT_SIZE_FIT: any;
        VALUE_RESOLUTION_VARIANT_DPI_FIT: any;
        new(p0: Map<java.awt.RenderingHints$Key, any>): java.awt.RenderingHints;
        new(p0: java.awt.RenderingHints$Key, p1: any): java.awt.RenderingHints;
      }
      interface RenderingHints extends Map<any, any>, kotlin.Cloneable { 
        add(p0: java.awt.RenderingHints): void;
      }
      interface RenderingHints$Key { 
        isCompatibleValue(p0: any): boolean;
      }
      interface PaintContext { 
        dispose(): void;
        getColorModel(): java.awt.image.ColorModel;
        getRaster(p0: number, p1: number, p2: number, p3: number): java.awt.image.Raster;
      }
      const Image: {
        UndefinedProperty: any;
        SCALE_DEFAULT: number;
        SCALE_FAST: number;
        SCALE_SMOOTH: number;
        SCALE_REPLICATE: number;
        SCALE_AREA_AVERAGING: number;
      }
      interface Image { 
        getWidth(p0: java.awt.image.ImageObserver): number;
        getHeight(p0: java.awt.image.ImageObserver): number;
        getSource(): java.awt.image.ImageProducer;
        getGraphics(): java.awt.Graphics;
        getProperty(p0: string, p1: java.awt.image.ImageObserver): any;
        getScaledInstance(p0: number, p1: number, p2: number): java.awt.Image;
        flush(): void;
        getCapabilities(p0: java.awt.GraphicsConfiguration): java.awt.ImageCapabilities;
        setAccelerationPriority(p0: number): void;
        getAccelerationPriority(): number;
      }
      interface Graphics { 
        create(): java.awt.Graphics;
        create(p0: number, p1: number, p2: number, p3: number): java.awt.Graphics;
        translate(p0: number, p1: number): void;
        getColor(): java.awt.Color;
        setColor(p0: java.awt.Color): void;
        setPaintMode(): void;
        setXORMode(p0: java.awt.Color): void;
        getFont(): java.awt.Font;
        setFont(p0: java.awt.Font): void;
        getFontMetrics(): java.awt.FontMetrics;
        getFontMetrics(p0: java.awt.Font): java.awt.FontMetrics;
        getClipBounds(): java.awt.Rectangle;
        getClipBounds(p0: java.awt.Rectangle): java.awt.Rectangle;
        clipRect(p0: number, p1: number, p2: number, p3: number): void;
        setClip(p0: number, p1: number, p2: number, p3: number): void;
        setClip(p0: java.awt.Shape): void;
        getClip(): java.awt.Shape;
        copyArea(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        drawLine(p0: number, p1: number, p2: number, p3: number): void;
        fillRect(p0: number, p1: number, p2: number, p3: number): void;
        drawRect(p0: number, p1: number, p2: number, p3: number): void;
        clearRect(p0: number, p1: number, p2: number, p3: number): void;
        drawRoundRect(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        fillRoundRect(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        draw3DRect(p0: number, p1: number, p2: number, p3: number, p4: boolean): void;
        fill3DRect(p0: number, p1: number, p2: number, p3: number, p4: boolean): void;
        drawOval(p0: number, p1: number, p2: number, p3: number): void;
        fillOval(p0: number, p1: number, p2: number, p3: number): void;
        drawArc(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        fillArc(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        drawPolyline(p0: Array<number>, p1: Array<number>, p2: number): void;
        drawPolygon(p0: Array<number>, p1: Array<number>, p2: number): void;
        drawPolygon(p0: java.awt.Polygon): void;
        fillPolygon(p0: Array<number>, p1: Array<number>, p2: number): void;
        fillPolygon(p0: java.awt.Polygon): void;
        drawString(p0: string, p1: number, p2: number): void;
        drawString(p0: java.text.AttributedCharacterIterator, p1: number, p2: number): void;
        drawChars(p0: Array<number>, p1: number, p2: number, p3: number, p4: number): void;
        drawBytes(p0: Array<number>, p1: number, p2: number, p3: number, p4: number): void;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: number, p4: number, p5: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.Color, p4: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: number, p4: number, p5: java.awt.Color, p6: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number, p8: number, p9: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.Image, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: number, p8: number, p9: java.awt.Color, p10: java.awt.image.ImageObserver): boolean;
        dispose(): void;
        getClipRect(): java.awt.Rectangle;
        hitClip(p0: number, p1: number, p2: number, p3: number): boolean;
      }
      const Font: {
        DIALOG: string;
        DIALOG_INPUT: string;
        SANS_SERIF: string;
        SERIF: string;
        MONOSPACED: string;
        PLAIN: number;
        BOLD: number;
        ITALIC: number;
        ROMAN_BASELINE: number;
        CENTER_BASELINE: number;
        HANGING_BASELINE: number;
        TRUETYPE_FONT: number;
        TYPE1_FONT: number;
        LAYOUT_LEFT_TO_RIGHT: number;
        LAYOUT_RIGHT_TO_LEFT: number;
        LAYOUT_NO_START_CONTEXT: number;
        LAYOUT_NO_LIMIT_CONTEXT: number;
        textRequiresLayout(p0: Array<number>, p1: number, p2: number): boolean;
        getFont(p0: Map<java.text.AttributedCharacterIterator$Attribute, any>): java.awt.Font;
        getFont(p0: string): java.awt.Font;
        getFont(p0: string, p1: java.awt.Font): java.awt.Font;
        createFonts(p0: java.io.InputStream): Array<java.awt.Font>;
        createFonts(p0: java.io.File): Array<java.awt.Font>;
        createFont(p0: number, p1: java.io.InputStream): java.awt.Font;
        createFont(p0: number, p1: java.io.File): java.awt.Font;
        decode(p0: string): java.awt.Font;
        new(p0: string, p1: number, p2: number): java.awt.Font;
        new(p0: Map<java.text.AttributedCharacterIterator$Attribute, any>): java.awt.Font;
      }
      interface Font extends java.io.Serializable { 
        getTransform(): java.awt.geom.AffineTransform;
        getFamily(): string;
        getFamily(p0: java.util.Locale): string;
        getPSName(): string;
        getName(): string;
        getFontName(): string;
        getFontName(p0: java.util.Locale): string;
        getStyle(): number;
        getSize(): number;
        getSize2D(): number;
        isPlain(): boolean;
        isBold(): boolean;
        isItalic(): boolean;
        isTransformed(): boolean;
        hasLayoutAttributes(): boolean;
        getNumGlyphs(): number;
        getMissingGlyphCode(): number;
        getBaselineFor(p0: number): number;
        getAttributes(): Map<unknown, any>;
        getAvailableAttributes(): Array<java.text.AttributedCharacterIterator$Attribute>;
        deriveFont(p0: number, p1: number): java.awt.Font;
        deriveFont(p0: number, p1: java.awt.geom.AffineTransform): java.awt.Font;
        deriveFont(p0: number): java.awt.Font;
        deriveFont(p0: java.awt.geom.AffineTransform): java.awt.Font;
        deriveFont(p0: number): java.awt.Font;
        deriveFont(p0: Map<java.text.AttributedCharacterIterator$Attribute, any>): java.awt.Font;
        canDisplay(p0: number): boolean;
        canDisplay(p0: number): boolean;
        canDisplayUpTo(p0: string): number;
        canDisplayUpTo(p0: Array<number>, p1: number, p2: number): number;
        canDisplayUpTo(p0: java.text.CharacterIterator, p1: number, p2: number): number;
        getItalicAngle(): number;
        hasUniformLineMetrics(): boolean;
        getLineMetrics(p0: string, p1: java.awt.font.FontRenderContext): java.awt.font.LineMetrics;
        getLineMetrics(p0: string, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.font.LineMetrics;
        getLineMetrics(p0: Array<number>, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.font.LineMetrics;
        getLineMetrics(p0: java.text.CharacterIterator, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.font.LineMetrics;
        getStringBounds(p0: string, p1: java.awt.font.FontRenderContext): java.awt.geom.Rectangle2D;
        getStringBounds(p0: string, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.geom.Rectangle2D;
        getStringBounds(p0: Array<number>, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.geom.Rectangle2D;
        getStringBounds(p0: java.text.CharacterIterator, p1: number, p2: number, p3: java.awt.font.FontRenderContext): java.awt.geom.Rectangle2D;
        getMaxCharBounds(p0: java.awt.font.FontRenderContext): java.awt.geom.Rectangle2D;
        createGlyphVector(p0: java.awt.font.FontRenderContext, p1: string): java.awt.font.GlyphVector;
        createGlyphVector(p0: java.awt.font.FontRenderContext, p1: Array<number>): java.awt.font.GlyphVector;
        createGlyphVector(p0: java.awt.font.FontRenderContext, p1: java.text.CharacterIterator): java.awt.font.GlyphVector;
        createGlyphVector(p0: java.awt.font.FontRenderContext, p1: Array<number>): java.awt.font.GlyphVector;
        layoutGlyphVector(p0: java.awt.font.FontRenderContext, p1: Array<number>, p2: number, p3: number, p4: number): java.awt.font.GlyphVector;
      }
      interface FontMetrics extends java.io.Serializable { 
        getFont(): java.awt.Font;
        getFontRenderContext(): java.awt.font.FontRenderContext;
        getLeading(): number;
        getAscent(): number;
        getDescent(): number;
        getHeight(): number;
        getMaxAscent(): number;
        getMaxDescent(): number;
        getMaxDecent(): number;
        getMaxAdvance(): number;
        charWidth(p0: number): number;
        charWidth(p0: number): number;
        stringWidth(p0: string): number;
        charsWidth(p0: Array<number>, p1: number, p2: number): number;
        bytesWidth(p0: Array<number>, p1: number, p2: number): number;
        getWidths(): Array<number>;
        hasUniformLineMetrics(): boolean;
        getLineMetrics(p0: string, p1: java.awt.Graphics): java.awt.font.LineMetrics;
        getLineMetrics(p0: string, p1: number, p2: number, p3: java.awt.Graphics): java.awt.font.LineMetrics;
        getLineMetrics(p0: Array<number>, p1: number, p2: number, p3: java.awt.Graphics): java.awt.font.LineMetrics;
        getLineMetrics(p0: java.text.CharacterIterator, p1: number, p2: number, p3: java.awt.Graphics): java.awt.font.LineMetrics;
        getStringBounds(p0: string, p1: java.awt.Graphics): java.awt.geom.Rectangle2D;
        getStringBounds(p0: string, p1: number, p2: number, p3: java.awt.Graphics): java.awt.geom.Rectangle2D;
        getStringBounds(p0: Array<number>, p1: number, p2: number, p3: java.awt.Graphics): java.awt.geom.Rectangle2D;
        getStringBounds(p0: java.text.CharacterIterator, p1: number, p2: number, p3: java.awt.Graphics): java.awt.geom.Rectangle2D;
        getMaxCharBounds(p0: java.awt.Graphics): java.awt.geom.Rectangle2D;
      }
      const Polygon: {
        new(): java.awt.Polygon;
        new(p0: Array<number>, p1: Array<number>, p2: number): java.awt.Polygon;
      }
      interface Polygon extends java.awt.Shape, java.io.Serializable { 
        npoints: number;
        xpoints: Array<number>;
        ypoints: Array<number>;
        contains(p0: java.awt.Point): boolean;
        contains(p0: number, p1: number): boolean;
        reset(): void;
        invalidate(): void;
        translate(p0: number, p1: number): void;
        addPoint(p0: number, p1: number): void;
        getBoundingBox(): java.awt.Rectangle;
        inside(p0: number, p1: number): boolean;
      }
      interface GraphicsConfiguration { 
        getDevice(): java.awt.GraphicsDevice;
        createCompatibleImage(p0: number, p1: number): java.awt.image.BufferedImage;
        createCompatibleImage(p0: number, p1: number, p2: number): java.awt.image.BufferedImage;
        createCompatibleVolatileImage(p0: number, p1: number): java.awt.image.VolatileImage;
        createCompatibleVolatileImage(p0: number, p1: number, p2: number): java.awt.image.VolatileImage;
        createCompatibleVolatileImage(p0: number, p1: number, p2: java.awt.ImageCapabilities): java.awt.image.VolatileImage;
        createCompatibleVolatileImage(p0: number, p1: number, p2: java.awt.ImageCapabilities, p3: number): java.awt.image.VolatileImage;
        getColorModel(): java.awt.image.ColorModel;
        getColorModel(p0: number): java.awt.image.ColorModel;
        getDefaultTransform(): java.awt.geom.AffineTransform;
        getNormalizingTransform(): java.awt.geom.AffineTransform;
        getBounds(): java.awt.Rectangle;
        getBufferCapabilities(): java.awt.BufferCapabilities;
        getImageCapabilities(): java.awt.ImageCapabilities;
        isTranslucencyCapable(): boolean;
      }
      const GraphicsDevice: {
        WindowTranslucency: typeof java.awt.GraphicsDevice$WindowTranslucency;
        TYPE_RASTER_SCREEN: number;
        TYPE_PRINTER: number;
        TYPE_IMAGE_BUFFER: number;
      }
      interface GraphicsDevice { 
        getType(): number;
        getIDstring(): string;
        getConfigurations(): Array<java.awt.GraphicsConfiguration>;
        getDefaultConfiguration(): java.awt.GraphicsConfiguration;
        getBestConfiguration(p0: java.awt.GraphicsConfigTemplate): java.awt.GraphicsConfiguration;
        isFullScreenSupported(): boolean;
        setFullScreenWindow(p0: java.awt.Window): void;
        getFullScreenWindow(): java.awt.Window;
        isDisplayChangeSupported(): boolean;
        setDisplayMode(p0: java.awt.DisplayMode): void;
        getDisplayMode(): java.awt.DisplayMode;
        getDisplayModes(): Array<java.awt.DisplayMode>;
        getAvailableAcceleratedMemory(): number;
        isWindowTranslucencySupported(p0: java.awt.GraphicsDevice$WindowTranslucency): boolean;
      }
      const GraphicsDevice$WindowTranslucency: {
        PERPIXEL_TRANSPARENT: java.awt.GraphicsDevice$WindowTranslucency;
        TRANSLUCENT: java.awt.GraphicsDevice$WindowTranslucency;
        PERPIXEL_TRANSLUCENT: java.awt.GraphicsDevice$WindowTranslucency;
        valueOf(value: string): java.awt.GraphicsDevice$WindowTranslucency;
        values(): Array<java.awt.GraphicsDevice$WindowTranslucency>;
      }
      interface GraphicsDevice$WindowTranslucency extends kotlin.Enum<java.awt.GraphicsDevice$WindowTranslucency> { 
      }
      const GraphicsConfigTemplate: {
        REQUIRED: number;
        PREFERRED: number;
        UNNECESSARY: number;
        new(): java.awt.GraphicsConfigTemplate;
      }
      interface GraphicsConfigTemplate extends java.io.Serializable { 
        getBestConfiguration(p0: Array<java.awt.GraphicsConfiguration>): java.awt.GraphicsConfiguration;
        isGraphicsConfigSupported(p0: java.awt.GraphicsConfiguration): boolean;
      }
      const Window: {
        Type: typeof java.awt.Window$Type;
        getWindows(): Array<java.awt.Window>;
        getOwnerlessWindows(): Array<java.awt.Window>;
        new(p0: java.awt.Frame): java.awt.Window;
        new(p0: java.awt.Window): java.awt.Window;
        new(p0: java.awt.Window, p1: java.awt.GraphicsConfiguration): java.awt.Window;
      }
      interface Window extends java.awt.Container, javax.accessibility.Accessible { 
        getIconImages(): Array<java.awt.Image>;
        setIconImages(p0: Array<java.awt.Image>): void;
        setIconImage(p0: java.awt.Image): void;
        pack(): void;
        dispose(): void;
        toFront(): void;
        toBack(): void;
        getWarningString(): string;
        getOwner(): java.awt.Window;
        getOwnedWindows(): Array<java.awt.Window>;
        setModalExclusionType(p0: java.awt.Dialog$ModalExclusionType): void;
        getModalExclusionType(): java.awt.Dialog$ModalExclusionType;
        addWindowListener(p0: java.awt.event.WindowListener): void;
        addWindowStateListener(p0: java.awt.event.WindowStateListener): void;
        addWindowFocusListener(p0: java.awt.event.WindowFocusListener): void;
        removeWindowListener(p0: java.awt.event.WindowListener): void;
        removeWindowStateListener(p0: java.awt.event.WindowStateListener): void;
        removeWindowFocusListener(p0: java.awt.event.WindowFocusListener): void;
        getWindowListeners(): Array<java.awt.event.WindowListener>;
        getWindowFocusListeners(): Array<java.awt.event.WindowFocusListener>;
        getWindowStateListeners(): Array<java.awt.event.WindowStateListener>;
        setAlwaysOnTop(p0: boolean): void;
        isAlwaysOnTopSupported(): boolean;
        isAlwaysOnTop(): boolean;
        getFocusOwner(): java.awt.Component;
        getMostRecentFocusOwner(): java.awt.Component;
        isActive(): boolean;
        isFocused(): boolean;
        isFocusableWindow(): boolean;
        getFocusableWindowState(): boolean;
        setFocusableWindowState(p0: boolean): void;
        setAutoRequestFocus(p0: boolean): void;
        isAutoRequestFocus(): boolean;
        applyResourceBundle(p0: java.util.ResourceBundle): void;
        applyResourceBundle(p0: string): void;
        setType(p0: java.awt.Window$Type): void;
        getType(): java.awt.Window$Type;
        setLocationRelativeTo(p0: java.awt.Component): void;
        setLocationByPlatform(p0: boolean): void;
        isLocationByPlatform(): boolean;
        getOpacity(): number;
        setOpacity(p0: number): void;
        getShape(): java.awt.Shape;
        setShape(p0: java.awt.Shape): void;
      }
      const Container: {
        new(): java.awt.Container;
      }
      interface Container extends java.awt.Component { 
        remove(p0: number): void;
        remove(p0: java.awt.Component): void;
        getMousePosition(p0: boolean): java.awt.Point;
        isFocusCycleRoot(): boolean;
        add(p0: java.awt.Component): java.awt.Component;
        add(p0: string, p1: java.awt.Component): java.awt.Component;
        add(p0: java.awt.Component, p1: number): java.awt.Component;
        add(p0: java.awt.Component, p1: any): void;
        add(p0: java.awt.Component, p1: any, p2: number): void;
        getComponentCount(): number;
        countComponents(): number;
        getComponent(p0: number): java.awt.Component;
        getComponents(): Array<java.awt.Component>;
        getInsets(): java.awt.Insets;
        insets(): java.awt.Insets;
        setComponentZOrder(p0: java.awt.Component, p1: number): void;
        getComponentZOrder(p0: java.awt.Component): number;
        removeAll(): void;
        getLayout(): java.awt.LayoutManager;
        setLayout(p0: java.awt.LayoutManager): void;
        isValidateRoot(): boolean;
        paintComponents(p0: java.awt.Graphics): void;
        printComponents(p0: java.awt.Graphics): void;
        addContainerListener(p0: java.awt.event.ContainerListener): void;
        removeContainerListener(p0: java.awt.event.ContainerListener): void;
        getContainerListeners(): Array<java.awt.event.ContainerListener>;
        findComponentAt(p0: number, p1: number): java.awt.Component;
        findComponentAt(p0: java.awt.Point): java.awt.Component;
        isAncestorOf(p0: java.awt.Component): boolean;
        setFocusTraversalPolicy(p0: java.awt.FocusTraversalPolicy): void;
        getFocusTraversalPolicy(): java.awt.FocusTraversalPolicy;
        isFocusTraversalPolicySet(): boolean;
        setFocusCycleRoot(p0: boolean): void;
        setFocusTraversalPolicyProvider(p0: boolean): void;
        isFocusTraversalPolicyProvider(): boolean;
        transferFocusDownCycle(): void;
      }
      const Component: {
        BaselineResizeBehavior: typeof java.awt.Component$BaselineResizeBehavior;
        TOP_ALIGNMENT: number;
        CENTER_ALIGNMENT: number;
        BOTTOM_ALIGNMENT: number;
        LEFT_ALIGNMENT: number;
        RIGHT_ALIGNMENT: number;
      }
      interface Component extends java.awt.image.ImageObserver, java.awt.MenuContainer, java.io.Serializable { 
        getName(): string;
        setName(p0: string): void;
        getParent(): java.awt.Container;
        setDropTarget(p0: java.awt.dnd.DropTarget): void;
        getDropTarget(): java.awt.dnd.DropTarget;
        getGraphicsConfiguration(): java.awt.GraphicsConfiguration;
        getTreeLock(): any;
        getToolkit(): java.awt.Toolkit;
        isValid(): boolean;
        isDisplayable(): boolean;
        isVisible(): boolean;
        getMousePosition(): java.awt.Point;
        isShowing(): boolean;
        isEnabled(): boolean;
        setEnabled(p0: boolean): void;
        enable(): void;
        enable(p0: boolean): void;
        disable(): void;
        isDoubleBuffered(): boolean;
        enableInputMethods(p0: boolean): void;
        setVisible(p0: boolean): void;
        show(): void;
        show(p0: boolean): void;
        hide(): void;
        getForeground(): java.awt.Color;
        setForeground(p0: java.awt.Color): void;
        isForegroundSet(): boolean;
        getBackground(): java.awt.Color;
        setBackground(p0: java.awt.Color): void;
        isBackgroundSet(): boolean;
        setFont(p0: java.awt.Font): void;
        isFontSet(): boolean;
        getLocale(): java.util.Locale;
        setLocale(p0: java.util.Locale): void;
        getColorModel(): java.awt.image.ColorModel;
        getLocation(): java.awt.Point;
        getLocation(p0: java.awt.Point): java.awt.Point;
        getLocationOnScreen(): java.awt.Point;
        location(): java.awt.Point;
        setLocation(p0: number, p1: number): void;
        setLocation(p0: java.awt.Point): void;
        move(p0: number, p1: number): void;
        getSize(): java.awt.Dimension;
        getSize(p0: java.awt.Dimension): java.awt.Dimension;
        size(): java.awt.Dimension;
        setSize(p0: number, p1: number): void;
        setSize(p0: java.awt.Dimension): void;
        resize(p0: number, p1: number): void;
        resize(p0: java.awt.Dimension): void;
        getBounds(): java.awt.Rectangle;
        getBounds(p0: java.awt.Rectangle): java.awt.Rectangle;
        bounds(): java.awt.Rectangle;
        setBounds(p0: number, p1: number, p2: number, p3: number): void;
        setBounds(p0: java.awt.Rectangle): void;
        reshape(p0: number, p1: number, p2: number, p3: number): void;
        getX(): number;
        getY(): number;
        getWidth(): number;
        getHeight(): number;
        isOpaque(): boolean;
        isLightweight(): boolean;
        setPreferredSize(p0: java.awt.Dimension): void;
        isPreferredSizeSet(): boolean;
        getPreferredSize(): java.awt.Dimension;
        preferredSize(): java.awt.Dimension;
        setMinimumSize(p0: java.awt.Dimension): void;
        isMinimumSizeSet(): boolean;
        getMinimumSize(): java.awt.Dimension;
        minimumSize(): java.awt.Dimension;
        setMaximumSize(p0: java.awt.Dimension): void;
        isMaximumSizeSet(): boolean;
        getMaximumSize(): java.awt.Dimension;
        getAlignmentX(): number;
        getAlignmentY(): number;
        getBaseline(p0: number, p1: number): number;
        getBaselineResizeBehavior(): java.awt.Component$BaselineResizeBehavior;
        doLayout(): void;
        layout(): void;
        validate(): void;
        invalidate(): void;
        revalidate(): void;
        getGraphics(): java.awt.Graphics;
        getFontMetrics(p0: java.awt.Font): java.awt.FontMetrics;
        setCursor(p0: java.awt.Cursor): void;
        getCursor(): java.awt.Cursor;
        isCursorSet(): boolean;
        paint(p0: java.awt.Graphics): void;
        update(p0: java.awt.Graphics): void;
        paintAll(p0: java.awt.Graphics): void;
        repaint(): void;
        repaint(p0: number): void;
        repaint(p0: number, p1: number, p2: number, p3: number): void;
        repaint(p0: number, p1: number, p2: number, p3: number, p4: number): void;
        print(p0: java.awt.Graphics): void;
        printAll(p0: java.awt.Graphics): void;
        createImage(p0: java.awt.image.ImageProducer): java.awt.Image;
        createImage(p0: number, p1: number): java.awt.Image;
        createVolatileImage(p0: number, p1: number): java.awt.image.VolatileImage;
        createVolatileImage(p0: number, p1: number, p2: java.awt.ImageCapabilities): java.awt.image.VolatileImage;
        prepareImage(p0: java.awt.Image, p1: java.awt.image.ImageObserver): boolean;
        prepareImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.image.ImageObserver): boolean;
        checkImage(p0: java.awt.Image, p1: java.awt.image.ImageObserver): number;
        checkImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.image.ImageObserver): number;
        setIgnoreRepaint(p0: boolean): void;
        getIgnoreRepaint(): boolean;
        contains(p0: number, p1: number): boolean;
        contains(p0: java.awt.Point): boolean;
        inside(p0: number, p1: number): boolean;
        getComponentAt(p0: number, p1: number): java.awt.Component;
        getComponentAt(p0: java.awt.Point): java.awt.Component;
        locate(p0: number, p1: number): java.awt.Component;
        deliverEvent(p0: java.awt.Event): void;
        dispatchEvent(p0: java.awt.AWTEvent): void;
        addComponentListener(p0: java.awt.event.ComponentListener): void;
        removeComponentListener(p0: java.awt.event.ComponentListener): void;
        getComponentListeners(): Array<java.awt.event.ComponentListener>;
        addFocusListener(p0: java.awt.event.FocusListener): void;
        removeFocusListener(p0: java.awt.event.FocusListener): void;
        getFocusListeners(): Array<java.awt.event.FocusListener>;
        addHierarchyListener(p0: java.awt.event.HierarchyListener): void;
        removeHierarchyListener(p0: java.awt.event.HierarchyListener): void;
        getHierarchyListeners(): Array<java.awt.event.HierarchyListener>;
        addHierarchyBoundsListener(p0: java.awt.event.HierarchyBoundsListener): void;
        removeHierarchyBoundsListener(p0: java.awt.event.HierarchyBoundsListener): void;
        getHierarchyBoundsListeners(): Array<java.awt.event.HierarchyBoundsListener>;
        addKeyListener(p0: java.awt.event.KeyListener): void;
        removeKeyListener(p0: java.awt.event.KeyListener): void;
        getKeyListeners(): Array<java.awt.event.KeyListener>;
        addMouseListener(p0: java.awt.event.MouseListener): void;
        removeMouseListener(p0: java.awt.event.MouseListener): void;
        getMouseListeners(): Array<java.awt.event.MouseListener>;
        addMouseMotionListener(p0: java.awt.event.MouseMotionListener): void;
        removeMouseMotionListener(p0: java.awt.event.MouseMotionListener): void;
        getMouseMotionListeners(): Array<java.awt.event.MouseMotionListener>;
        addMouseWheelListener(p0: java.awt.event.MouseWheelListener): void;
        removeMouseWheelListener(p0: java.awt.event.MouseWheelListener): void;
        getMouseWheelListeners(): Array<java.awt.event.MouseWheelListener>;
        addInputMethodListener(p0: java.awt.event.InputMethodListener): void;
        removeInputMethodListener(p0: java.awt.event.InputMethodListener): void;
        getInputMethodListeners(): Array<java.awt.event.InputMethodListener>;
        getListeners<T>(p0: java.lang.Class<T>): Array<T>;
        getInputMethodRequests(): java.awt.im.InputMethodRequests;
        getInputContext(): java.awt.im.InputContext;
        handleEvent(p0: java.awt.Event): boolean;
        mouseDown(p0: java.awt.Event, p1: number, p2: number): boolean;
        mouseDrag(p0: java.awt.Event, p1: number, p2: number): boolean;
        mouseUp(p0: java.awt.Event, p1: number, p2: number): boolean;
        mouseMove(p0: java.awt.Event, p1: number, p2: number): boolean;
        mouseEnter(p0: java.awt.Event, p1: number, p2: number): boolean;
        mouseExit(p0: java.awt.Event, p1: number, p2: number): boolean;
        keyDown(p0: java.awt.Event, p1: number): boolean;
        keyUp(p0: java.awt.Event, p1: number): boolean;
        action(p0: java.awt.Event, p1: any): boolean;
        addNotify(): void;
        removeNotify(): void;
        gotFocus(p0: java.awt.Event, p1: any): boolean;
        lostFocus(p0: java.awt.Event, p1: any): boolean;
        isFocusTraversable(): boolean;
        isFocusable(): boolean;
        setFocusable(p0: boolean): void;
        setFocusTraversalKeys(p0: number, p1: Set<unknown>): void;
        getFocusTraversalKeys(p0: number): Set<unknown>;
        areFocusTraversalKeysSet(p0: number): boolean;
        setFocusTraversalKeysEnabled(p0: boolean): void;
        getFocusTraversalKeysEnabled(): boolean;
        requestFocus(): void;
        requestFocus(p0: java.awt.event.FocusEvent$Cause): void;
        requestFocusInWindow(): boolean;
        requestFocusInWindow(p0: java.awt.event.FocusEvent$Cause): boolean;
        getFocusCycleRootAncestor(): java.awt.Container;
        isFocusCycleRoot(p0: java.awt.Container): boolean;
        transferFocus(): void;
        nextFocus(): void;
        transferFocusBackward(): void;
        transferFocusUpCycle(): void;
        hasFocus(): boolean;
        isFocusOwner(): boolean;
        add(p0: java.awt.PopupMenu): void;
        list(): void;
        list(p0: java.io.PrintStream): void;
        list(p0: java.io.PrintStream, p1: number): void;
        list(p0: java.io.PrintWriter): void;
        list(p0: java.io.PrintWriter, p1: number): void;
        addPropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        addPropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        getPropertyChangeListeners(): Array<java.beans.PropertyChangeListener>;
        getPropertyChangeListeners(p0: string): Array<java.beans.PropertyChangeListener>;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        setComponentOrientation(p0: java.awt.ComponentOrientation): void;
        getComponentOrientation(): java.awt.ComponentOrientation;
        applyComponentOrientation(p0: java.awt.ComponentOrientation): void;
        getAccessibleContext(): javax.accessibility.AccessibleContext;
        setMixingCutoutShape(p0: java.awt.Shape): void;
      }
      interface MenuContainer { 
        getFont(): java.awt.Font;
        remove(p0: java.awt.MenuComponent): void;
        postEvent(p0: java.awt.Event): boolean;
      }
      const MenuComponent: {
        new(): java.awt.MenuComponent;
      }
      interface MenuComponent extends java.io.Serializable { 
        getName(): string;
        setName(p0: string): void;
        getParent(): java.awt.MenuContainer;
        getFont(): java.awt.Font;
        setFont(p0: java.awt.Font): void;
        removeNotify(): void;
        postEvent(p0: java.awt.Event): boolean;
        dispatchEvent(p0: java.awt.AWTEvent): void;
        getAccessibleContext(): javax.accessibility.AccessibleContext;
      }
      const Event: {
        SHIFT_MASK: number;
        CTRL_MASK: number;
        META_MASK: number;
        ALT_MASK: number;
        HOME: number;
        END: number;
        PGUP: number;
        PGDN: number;
        UP: number;
        DOWN: number;
        LEFT: number;
        RIGHT: number;
        F1: number;
        F2: number;
        F3: number;
        F4: number;
        F5: number;
        F6: number;
        F7: number;
        F8: number;
        F9: number;
        F10: number;
        F11: number;
        F12: number;
        PRINT_SCREEN: number;
        SCROLL_LOCK: number;
        CAPS_LOCK: number;
        NUM_LOCK: number;
        PAUSE: number;
        INSERT: number;
        ENTER: number;
        BACK_SPACE: number;
        TAB: number;
        ESCAPE: number;
        DELETE: number;
        WINDOW_DESTROY: number;
        WINDOW_EXPOSE: number;
        WINDOW_ICONIFY: number;
        WINDOW_DEICONIFY: number;
        WINDOW_MOVED: number;
        KEY_PRESS: number;
        KEY_RELEASE: number;
        KEY_ACTION: number;
        KEY_ACTION_RELEASE: number;
        MOUSE_DOWN: number;
        MOUSE_UP: number;
        MOUSE_MOVE: number;
        MOUSE_ENTER: number;
        MOUSE_EXIT: number;
        MOUSE_DRAG: number;
        SCROLL_LINE_UP: number;
        SCROLL_LINE_DOWN: number;
        SCROLL_PAGE_UP: number;
        SCROLL_PAGE_DOWN: number;
        SCROLL_ABSOLUTE: number;
        SCROLL_BEGIN: number;
        SCROLL_END: number;
        LIST_SELECT: number;
        LIST_DESELECT: number;
        ACTION_EVENT: number;
        LOAD_FILE: number;
        SAVE_FILE: number;
        GOT_FOCUS: number;
        LOST_FOCUS: number;
        new(p0: any, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: any): java.awt.Event;
        new(p0: any, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number): java.awt.Event;
        new(p0: any, p1: number, p2: any): java.awt.Event;
      }
      interface Event extends java.io.Serializable { 
        target: any;
        when: number;
        id: number;
        x: number;
        y: number;
        key: number;
        modifiers: number;
        clickCount: number;
        arg: any;
        evt: java.awt.Event;
        translate(p0: number, p1: number): void;
        shiftDown(): boolean;
        controlDown(): boolean;
        metaDown(): boolean;
      }
      const AWTEvent: {
        COMPONENT_EVENT_MASK: number;
        CONTAINER_EVENT_MASK: number;
        FOCUS_EVENT_MASK: number;
        KEY_EVENT_MASK: number;
        MOUSE_EVENT_MASK: number;
        MOUSE_MOTION_EVENT_MASK: number;
        WINDOW_EVENT_MASK: number;
        ACTION_EVENT_MASK: number;
        ADJUSTMENT_EVENT_MASK: number;
        ITEM_EVENT_MASK: number;
        TEXT_EVENT_MASK: number;
        INPUT_METHOD_EVENT_MASK: number;
        PAINT_EVENT_MASK: number;
        INVOCATION_EVENT_MASK: number;
        HIERARCHY_EVENT_MASK: number;
        HIERARCHY_BOUNDS_EVENT_MASK: number;
        MOUSE_WHEEL_EVENT_MASK: number;
        WINDOW_STATE_EVENT_MASK: number;
        WINDOW_FOCUS_EVENT_MASK: number;
        RESERVED_ID_MAX: number;
        new(p0: java.awt.Event): java.awt.AWTEvent;
        new(p0: any, p1: number): java.awt.AWTEvent;
      }
      interface AWTEvent extends java.util.EventObject { 
        setSource(p0: any): void;
        getID(): number;
        paramString(): string;
      }
      const Cursor: {
        DEFAULT_CURSOR: number;
        CROSSHAIR_CURSOR: number;
        TEXT_CURSOR: number;
        WAIT_CURSOR: number;
        SW_RESIZE_CURSOR: number;
        SE_RESIZE_CURSOR: number;
        NW_RESIZE_CURSOR: number;
        NE_RESIZE_CURSOR: number;
        N_RESIZE_CURSOR: number;
        S_RESIZE_CURSOR: number;
        W_RESIZE_CURSOR: number;
        E_RESIZE_CURSOR: number;
        HAND_CURSOR: number;
        MOVE_CURSOR: number;
        CUSTOM_CURSOR: number;
        getPredefinedCursor(p0: number): java.awt.Cursor;
        getSystemCustomCursor(p0: string): java.awt.Cursor;
        getDefaultCursor(): java.awt.Cursor;
        new(p0: number): java.awt.Cursor;
      }
      interface Cursor extends java.io.Serializable { 
        getType(): number;
        getName(): string;
      }
      const Component$BaselineResizeBehavior: {
        CONSTANT_ASCENT: java.awt.Component$BaselineResizeBehavior;
        CONSTANT_DESCENT: java.awt.Component$BaselineResizeBehavior;
        CENTER_OFFSET: java.awt.Component$BaselineResizeBehavior;
        OTHER: java.awt.Component$BaselineResizeBehavior;
        valueOf(value: string): java.awt.Component$BaselineResizeBehavior;
        values(): Array<java.awt.Component$BaselineResizeBehavior>;
      }
      interface Component$BaselineResizeBehavior extends kotlin.Enum<java.awt.Component$BaselineResizeBehavior> { 
      }
      const Toolkit: {
        getDefaultToolkit(): java.awt.Toolkit;
        getProperty(p0: string, p1: string): string;
      }
      interface Toolkit { 
        setDynamicLayout(p0: boolean): void;
        isDynamicLayoutActive(): boolean;
        getScreenSize(): java.awt.Dimension;
        getScreenResolution(): number;
        getScreenInsets(p0: java.awt.GraphicsConfiguration): java.awt.Insets;
        getColorModel(): java.awt.image.ColorModel;
        getFontList(): Array<string>;
        getFontMetrics(p0: java.awt.Font): java.awt.FontMetrics;
        sync(): void;
        getImage(p0: string): java.awt.Image;
        getImage(p0: java.net.URL): java.awt.Image;
        createImage(p0: string): java.awt.Image;
        createImage(p0: java.net.URL): java.awt.Image;
        createImage(p0: java.awt.image.ImageProducer): java.awt.Image;
        createImage(p0: Array<number>): java.awt.Image;
        createImage(p0: Array<number>, p1: number, p2: number): java.awt.Image;
        prepareImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.image.ImageObserver): boolean;
        checkImage(p0: java.awt.Image, p1: number, p2: number, p3: java.awt.image.ImageObserver): number;
        getPrintJob(p0: java.awt.Frame, p1: string, p2: java.util.Properties): java.awt.PrintJob;
        getPrintJob(p0: java.awt.Frame, p1: string, p2: java.awt.JobAttributes, p3: java.awt.PageAttributes): java.awt.PrintJob;
        beep(): void;
        getSystemClipboard(): java.awt.datatransfer.Clipboard;
        getSystemSelection(): java.awt.datatransfer.Clipboard;
        getMenuShortcutKeyMask(): number;
        getMenuShortcutKeyMaskEx(): number;
        getLockingKeyState(p0: number): boolean;
        setLockingKeyState(p0: number, p1: boolean): void;
        createCustomCursor(p0: java.awt.Image, p1: java.awt.Point, p2: string): java.awt.Cursor;
        getBestCursorSize(p0: number, p1: number): java.awt.Dimension;
        getMaximumCursorColors(): number;
        isFrameStateSupported(p0: number): boolean;
        getSystemEventQueue(): java.awt.EventQueue;
        createDragGestureRecognizer<T>(p0: java.lang.Class<T>, p1: java.awt.dnd.DragSource, p2: java.awt.Component, p3: number, p4: java.awt.dnd.DragGestureListener): T;
        getDesktopProperty(p0: string): any;
        addPropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        getPropertyChangeListeners(): Array<java.beans.PropertyChangeListener>;
        getPropertyChangeListeners(p0: string): Array<java.beans.PropertyChangeListener>;
        isAlwaysOnTopSupported(): boolean;
        isModalityTypeSupported(p0: java.awt.Dialog$ModalityType): boolean;
        isModalExclusionTypeSupported(p0: java.awt.Dialog$ModalExclusionType): boolean;
        addAWTEventListener(p0: java.awt.event.AWTEventListener, p1: number): void;
        removeAWTEventListener(p0: java.awt.event.AWTEventListener): void;
        getAWTEventListeners(): Array<java.awt.event.AWTEventListener>;
        getAWTEventListeners(p0: number): Array<java.awt.event.AWTEventListener>;
        mapInputMethodHighlight(p0: java.awt.im.InputMethodHighlight): Map<unknown, any>;
        areExtraMouseButtonsEnabled(): boolean;
      }
      const Insets: {
        new(p0: number, p1: number, p2: number, p3: number): java.awt.Insets;
      }
      interface Insets extends kotlin.Cloneable, java.io.Serializable { 
        top: number;
        left: number;
        bottom: number;
        right: number;
        set(p0: number, p1: number, p2: number, p3: number): void;
      }
      const Frame: {
        DEFAULT_CURSOR: number;
        CROSSHAIR_CURSOR: number;
        TEXT_CURSOR: number;
        WAIT_CURSOR: number;
        SW_RESIZE_CURSOR: number;
        SE_RESIZE_CURSOR: number;
        NW_RESIZE_CURSOR: number;
        NE_RESIZE_CURSOR: number;
        N_RESIZE_CURSOR: number;
        S_RESIZE_CURSOR: number;
        W_RESIZE_CURSOR: number;
        E_RESIZE_CURSOR: number;
        HAND_CURSOR: number;
        MOVE_CURSOR: number;
        NORMAL: number;
        ICONIFIED: number;
        MAXIMIZED_HORIZ: number;
        MAXIMIZED_VERT: number;
        MAXIMIZED_BOTH: number;
        getFrames(): Array<java.awt.Frame>;
        new(): java.awt.Frame;
        new(p0: java.awt.GraphicsConfiguration): java.awt.Frame;
        new(p0: string): java.awt.Frame;
        new(p0: string, p1: java.awt.GraphicsConfiguration): java.awt.Frame;
      }
      interface Frame extends java.awt.Window, java.awt.MenuContainer { 
        setCursor(p0: number): void;
        getTitle(): string;
        setTitle(p0: string): void;
        getIconImage(): java.awt.Image;
        getMenuBar(): java.awt.MenuBar;
        setMenuBar(p0: java.awt.MenuBar): void;
        isResizable(): boolean;
        setResizable(p0: boolean): void;
        setState(p0: number): void;
        setExtendedState(p0: number): void;
        getState(): number;
        getExtendedState(): number;
        setMaximizedBounds(p0: java.awt.Rectangle): void;
        getMaximizedBounds(): java.awt.Rectangle;
        setUndecorated(p0: boolean): void;
        isUndecorated(): boolean;
        getCursorType(): number;
      }
      const MenuBar: {
        new(): java.awt.MenuBar;
      }
      interface MenuBar extends java.awt.MenuComponent, java.awt.MenuContainer, javax.accessibility.Accessible { 
        remove(p0: number): void;
        addNotify(): void;
        getHelpMenu(): java.awt.Menu;
        setHelpMenu(p0: java.awt.Menu): void;
        add(p0: java.awt.Menu): java.awt.Menu;
        getMenuCount(): number;
        countMenus(): number;
        getMenu(p0: number): java.awt.Menu;
        shortcuts(): java.util.Enumeration<java.awt.MenuShortcut>;
        getShortcutMenuItem(p0: java.awt.MenuShortcut): java.awt.MenuItem;
        deleteShortcut(p0: java.awt.MenuShortcut): void;
      }
      const Menu: {
        new(): java.awt.Menu;
        new(p0: string): java.awt.Menu;
        new(p0: string, p1: boolean): java.awt.Menu;
      }
      interface Menu extends java.awt.MenuItem, java.awt.MenuContainer, javax.accessibility.Accessible { 
        remove(p0: number): void;
        isTearOff(): boolean;
        getItemCount(): number;
        countItems(): number;
        getItem(p0: number): java.awt.MenuItem;
        add(p0: java.awt.MenuItem): java.awt.MenuItem;
        add(p0: string): void;
        insert(p0: java.awt.MenuItem, p1: number): void;
        insert(p0: string, p1: number): void;
        addSeparator(): void;
        insertSeparator(p0: number): void;
        removeAll(): void;
      }
      const MenuItem: {
        new(): java.awt.MenuItem;
        new(p0: string): java.awt.MenuItem;
        new(p0: string, p1: java.awt.MenuShortcut): java.awt.MenuItem;
      }
      interface MenuItem extends java.awt.MenuComponent, javax.accessibility.Accessible { 
        addNotify(): void;
        getLabel(): string;
        setLabel(p0: string): void;
        isEnabled(): boolean;
        setEnabled(p0: boolean): void;
        enable(): void;
        enable(p0: boolean): void;
        disable(): void;
        getShortcut(): java.awt.MenuShortcut;
        setShortcut(p0: java.awt.MenuShortcut): void;
        deleteShortcut(): void;
        setActionCommand(p0: string): void;
        getActionCommand(): string;
        addActionListener(p0: java.awt.event.ActionListener): void;
        removeActionListener(p0: java.awt.event.ActionListener): void;
        getActionListeners(): Array<java.awt.event.ActionListener>;
        getListeners<T>(p0: java.lang.Class<T>): Array<T>;
      }
      const MenuShortcut: {
        new(p0: number): java.awt.MenuShortcut;
        new(p0: number, p1: boolean): java.awt.MenuShortcut;
      }
      interface MenuShortcut extends java.io.Serializable { 
        getKey(): number;
        usesShiftModifier(): boolean;
      }
      interface PrintJob { 
        getGraphics(): java.awt.Graphics;
        getPageDimension(): java.awt.Dimension;
        getPageResolution(): number;
        lastPageFirst(): boolean;
        end(): void;
      }
      const JobAttributes: {
        DestinationType: typeof java.awt.JobAttributes$DestinationType;
        MultipleDocumentHandlingType: typeof java.awt.JobAttributes$MultipleDocumentHandlingType;
        SidesType: typeof java.awt.JobAttributes$SidesType;
        DefaultSelectionType: typeof java.awt.JobAttributes$DefaultSelectionType;
        DialogType: typeof java.awt.JobAttributes$DialogType;
        new(): java.awt.JobAttributes;
        new(p0: java.awt.JobAttributes): java.awt.JobAttributes;
        new(p0: number, p1: java.awt.JobAttributes$DefaultSelectionType, p2: java.awt.JobAttributes$DestinationType, p3: java.awt.JobAttributes$DialogType, p4: string, p5: number, p6: number, p7: java.awt.JobAttributes$MultipleDocumentHandlingType, p8: Array<Array<number>>, p9: string, p10: java.awt.JobAttributes$SidesType): java.awt.JobAttributes;
      }
      interface JobAttributes extends kotlin.Cloneable { 
        set(p0: java.awt.JobAttributes): void;
        getCopies(): number;
        setCopies(p0: number): void;
        setCopiesToDefault(): void;
        getDefaultSelection(): java.awt.JobAttributes$DefaultSelectionType;
        setDefaultSelection(p0: java.awt.JobAttributes$DefaultSelectionType): void;
        getDestination(): java.awt.JobAttributes$DestinationType;
        setDestination(p0: java.awt.JobAttributes$DestinationType): void;
        getDialog(): java.awt.JobAttributes$DialogType;
        setDialog(p0: java.awt.JobAttributes$DialogType): void;
        getFileName(): string;
        setFileName(p0: string): void;
        getFromPage(): number;
        setFromPage(p0: number): void;
        getMaxPage(): number;
        setMaxPage(p0: number): void;
        getMinPage(): number;
        setMinPage(p0: number): void;
        getMultipleDocumentHandling(): java.awt.JobAttributes$MultipleDocumentHandlingType;
        setMultipleDocumentHandling(p0: java.awt.JobAttributes$MultipleDocumentHandlingType): void;
        setMultipleDocumentHandlingToDefault(): void;
        getPageRanges(): Array<Array<number>>;
        setPageRanges(p0: Array<Array<number>>): void;
        getPrinter(): string;
        setPrinter(p0: string): void;
        getSides(): java.awt.JobAttributes$SidesType;
        setSides(p0: java.awt.JobAttributes$SidesType): void;
        setSidesToDefault(): void;
        getToPage(): number;
        setToPage(p0: number): void;
      }
      const JobAttributes$DestinationType: {
        FILE: java.awt.JobAttributes$DestinationType;
        PRINTER: java.awt.JobAttributes$DestinationType;
      }
      interface JobAttributes$DestinationType { 
      }
      const JobAttributes$MultipleDocumentHandlingType: {
        SEPARATE_DOCUMENTS_COLLATED_COPIES: java.awt.JobAttributes$MultipleDocumentHandlingType;
        SEPARATE_DOCUMENTS_UNCOLLATED_COPIES: java.awt.JobAttributes$MultipleDocumentHandlingType;
      }
      interface JobAttributes$MultipleDocumentHandlingType { 
      }
      const JobAttributes$SidesType: {
        ONE_SIDED: java.awt.JobAttributes$SidesType;
        TWO_SIDED_LONG_EDGE: java.awt.JobAttributes$SidesType;
        TWO_SIDED_SHORT_EDGE: java.awt.JobAttributes$SidesType;
      }
      interface JobAttributes$SidesType { 
      }
      const JobAttributes$DefaultSelectionType: {
        ALL: java.awt.JobAttributes$DefaultSelectionType;
        RANGE: java.awt.JobAttributes$DefaultSelectionType;
        SELECTION: java.awt.JobAttributes$DefaultSelectionType;
      }
      interface JobAttributes$DefaultSelectionType { 
      }
      const JobAttributes$DialogType: {
        COMMON: java.awt.JobAttributes$DialogType;
        NATIVE: java.awt.JobAttributes$DialogType;
        NONE: java.awt.JobAttributes$DialogType;
      }
      interface JobAttributes$DialogType { 
      }
      const PageAttributes: {
        OrientationRequestedType: typeof java.awt.PageAttributes$OrientationRequestedType;
        PrintQualityType: typeof java.awt.PageAttributes$PrintQualityType;
        MediaType: typeof java.awt.PageAttributes$MediaType;
        ColorType: typeof java.awt.PageAttributes$ColorType;
        OriginType: typeof java.awt.PageAttributes$OriginType;
        new(): java.awt.PageAttributes;
        new(p0: java.awt.PageAttributes): java.awt.PageAttributes;
        new(p0: java.awt.PageAttributes$ColorType, p1: java.awt.PageAttributes$MediaType, p2: java.awt.PageAttributes$OrientationRequestedType, p3: java.awt.PageAttributes$OriginType, p4: java.awt.PageAttributes$PrintQualityType, p5: Array<number>): java.awt.PageAttributes;
      }
      interface PageAttributes extends kotlin.Cloneable { 
        set(p0: java.awt.PageAttributes): void;
        getColor(): java.awt.PageAttributes$ColorType;
        setColor(p0: java.awt.PageAttributes$ColorType): void;
        getMedia(): java.awt.PageAttributes$MediaType;
        setMedia(p0: java.awt.PageAttributes$MediaType): void;
        setMediaToDefault(): void;
        getOrientationRequested(): java.awt.PageAttributes$OrientationRequestedType;
        setOrientationRequested(p0: java.awt.PageAttributes$OrientationRequestedType): void;
        setOrientationRequested(p0: number): void;
        setOrientationRequestedToDefault(): void;
        getOrigin(): java.awt.PageAttributes$OriginType;
        setOrigin(p0: java.awt.PageAttributes$OriginType): void;
        getPrintQuality(): java.awt.PageAttributes$PrintQualityType;
        setPrintQuality(p0: java.awt.PageAttributes$PrintQualityType): void;
        setPrintQuality(p0: number): void;
        setPrintQualityToDefault(): void;
        getPrinterResolution(): Array<number>;
        setPrinterResolution(p0: Array<number>): void;
        setPrinterResolution(p0: number): void;
        setPrinterResolutionToDefault(): void;
      }
      const PageAttributes$OrientationRequestedType: {
        PORTRAIT: java.awt.PageAttributes$OrientationRequestedType;
        LANDSCAPE: java.awt.PageAttributes$OrientationRequestedType;
      }
      interface PageAttributes$OrientationRequestedType { 
      }
      const PageAttributes$PrintQualityType: {
        HIGH: java.awt.PageAttributes$PrintQualityType;
        NORMAL: java.awt.PageAttributes$PrintQualityType;
        DRAFT: java.awt.PageAttributes$PrintQualityType;
      }
      interface PageAttributes$PrintQualityType { 
      }
      const PageAttributes$MediaType: {
        ISO_4A0: java.awt.PageAttributes$MediaType;
        ISO_2A0: java.awt.PageAttributes$MediaType;
        ISO_A0: java.awt.PageAttributes$MediaType;
        ISO_A1: java.awt.PageAttributes$MediaType;
        ISO_A2: java.awt.PageAttributes$MediaType;
        ISO_A3: java.awt.PageAttributes$MediaType;
        ISO_A4: java.awt.PageAttributes$MediaType;
        ISO_A5: java.awt.PageAttributes$MediaType;
        ISO_A6: java.awt.PageAttributes$MediaType;
        ISO_A7: java.awt.PageAttributes$MediaType;
        ISO_A8: java.awt.PageAttributes$MediaType;
        ISO_A9: java.awt.PageAttributes$MediaType;
        ISO_A10: java.awt.PageAttributes$MediaType;
        ISO_B0: java.awt.PageAttributes$MediaType;
        ISO_B1: java.awt.PageAttributes$MediaType;
        ISO_B2: java.awt.PageAttributes$MediaType;
        ISO_B3: java.awt.PageAttributes$MediaType;
        ISO_B4: java.awt.PageAttributes$MediaType;
        ISO_B5: java.awt.PageAttributes$MediaType;
        ISO_B6: java.awt.PageAttributes$MediaType;
        ISO_B7: java.awt.PageAttributes$MediaType;
        ISO_B8: java.awt.PageAttributes$MediaType;
        ISO_B9: java.awt.PageAttributes$MediaType;
        ISO_B10: java.awt.PageAttributes$MediaType;
        JIS_B0: java.awt.PageAttributes$MediaType;
        JIS_B1: java.awt.PageAttributes$MediaType;
        JIS_B2: java.awt.PageAttributes$MediaType;
        JIS_B3: java.awt.PageAttributes$MediaType;
        JIS_B4: java.awt.PageAttributes$MediaType;
        JIS_B5: java.awt.PageAttributes$MediaType;
        JIS_B6: java.awt.PageAttributes$MediaType;
        JIS_B7: java.awt.PageAttributes$MediaType;
        JIS_B8: java.awt.PageAttributes$MediaType;
        JIS_B9: java.awt.PageAttributes$MediaType;
        JIS_B10: java.awt.PageAttributes$MediaType;
        ISO_C0: java.awt.PageAttributes$MediaType;
        ISO_C1: java.awt.PageAttributes$MediaType;
        ISO_C2: java.awt.PageAttributes$MediaType;
        ISO_C3: java.awt.PageAttributes$MediaType;
        ISO_C4: java.awt.PageAttributes$MediaType;
        ISO_C5: java.awt.PageAttributes$MediaType;
        ISO_C6: java.awt.PageAttributes$MediaType;
        ISO_C7: java.awt.PageAttributes$MediaType;
        ISO_C8: java.awt.PageAttributes$MediaType;
        ISO_C9: java.awt.PageAttributes$MediaType;
        ISO_C10: java.awt.PageAttributes$MediaType;
        ISO_DESIGNATED_LONG: java.awt.PageAttributes$MediaType;
        EXECUTIVE: java.awt.PageAttributes$MediaType;
        FOLIO: java.awt.PageAttributes$MediaType;
        INVOICE: java.awt.PageAttributes$MediaType;
        LEDGER: java.awt.PageAttributes$MediaType;
        NA_LETTER: java.awt.PageAttributes$MediaType;
        NA_LEGAL: java.awt.PageAttributes$MediaType;
        QUARTO: java.awt.PageAttributes$MediaType;
        A: java.awt.PageAttributes$MediaType;
        B: java.awt.PageAttributes$MediaType;
        C: java.awt.PageAttributes$MediaType;
        D: java.awt.PageAttributes$MediaType;
        E: java.awt.PageAttributes$MediaType;
        NA_10X15_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_10X14_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_10X13_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_9X12_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_9X11_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_7X9_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_6X9_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_NUMBER_9_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_NUMBER_10_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_NUMBER_11_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_NUMBER_12_ENVELOPE: java.awt.PageAttributes$MediaType;
        NA_NUMBER_14_ENVELOPE: java.awt.PageAttributes$MediaType;
        INVITE_ENVELOPE: java.awt.PageAttributes$MediaType;
        ITALY_ENVELOPE: java.awt.PageAttributes$MediaType;
        MONARCH_ENVELOPE: java.awt.PageAttributes$MediaType;
        PERSONAL_ENVELOPE: java.awt.PageAttributes$MediaType;
        A0: java.awt.PageAttributes$MediaType;
        A1: java.awt.PageAttributes$MediaType;
        A2: java.awt.PageAttributes$MediaType;
        A3: java.awt.PageAttributes$MediaType;
        A4: java.awt.PageAttributes$MediaType;
        A5: java.awt.PageAttributes$MediaType;
        A6: java.awt.PageAttributes$MediaType;
        A7: java.awt.PageAttributes$MediaType;
        A8: java.awt.PageAttributes$MediaType;
        A9: java.awt.PageAttributes$MediaType;
        A10: java.awt.PageAttributes$MediaType;
        B0: java.awt.PageAttributes$MediaType;
        B1: java.awt.PageAttributes$MediaType;
        B2: java.awt.PageAttributes$MediaType;
        B3: java.awt.PageAttributes$MediaType;
        B4: java.awt.PageAttributes$MediaType;
        ISO_B4_ENVELOPE: java.awt.PageAttributes$MediaType;
        B5: java.awt.PageAttributes$MediaType;
        ISO_B5_ENVELOPE: java.awt.PageAttributes$MediaType;
        B6: java.awt.PageAttributes$MediaType;
        B7: java.awt.PageAttributes$MediaType;
        B8: java.awt.PageAttributes$MediaType;
        B9: java.awt.PageAttributes$MediaType;
        B10: java.awt.PageAttributes$MediaType;
        C0: java.awt.PageAttributes$MediaType;
        ISO_C0_ENVELOPE: java.awt.PageAttributes$MediaType;
        C1: java.awt.PageAttributes$MediaType;
        ISO_C1_ENVELOPE: java.awt.PageAttributes$MediaType;
        C2: java.awt.PageAttributes$MediaType;
        ISO_C2_ENVELOPE: java.awt.PageAttributes$MediaType;
        C3: java.awt.PageAttributes$MediaType;
        ISO_C3_ENVELOPE: java.awt.PageAttributes$MediaType;
        C4: java.awt.PageAttributes$MediaType;
        ISO_C4_ENVELOPE: java.awt.PageAttributes$MediaType;
        C5: java.awt.PageAttributes$MediaType;
        ISO_C5_ENVELOPE: java.awt.PageAttributes$MediaType;
        C6: java.awt.PageAttributes$MediaType;
        ISO_C6_ENVELOPE: java.awt.PageAttributes$MediaType;
        C7: java.awt.PageAttributes$MediaType;
        ISO_C7_ENVELOPE: java.awt.PageAttributes$MediaType;
        C8: java.awt.PageAttributes$MediaType;
        ISO_C8_ENVELOPE: java.awt.PageAttributes$MediaType;
        C9: java.awt.PageAttributes$MediaType;
        ISO_C9_ENVELOPE: java.awt.PageAttributes$MediaType;
        C10: java.awt.PageAttributes$MediaType;
        ISO_C10_ENVELOPE: java.awt.PageAttributes$MediaType;
        ISO_DESIGNATED_LONG_ENVELOPE: java.awt.PageAttributes$MediaType;
        STATEMENT: java.awt.PageAttributes$MediaType;
        TABLOID: java.awt.PageAttributes$MediaType;
        LETTER: java.awt.PageAttributes$MediaType;
        NOTE: java.awt.PageAttributes$MediaType;
        LEGAL: java.awt.PageAttributes$MediaType;
        ENV_10X15: java.awt.PageAttributes$MediaType;
        ENV_10X14: java.awt.PageAttributes$MediaType;
        ENV_10X13: java.awt.PageAttributes$MediaType;
        ENV_9X12: java.awt.PageAttributes$MediaType;
        ENV_9X11: java.awt.PageAttributes$MediaType;
        ENV_7X9: java.awt.PageAttributes$MediaType;
        ENV_6X9: java.awt.PageAttributes$MediaType;
        ENV_9: java.awt.PageAttributes$MediaType;
        ENV_10: java.awt.PageAttributes$MediaType;
        ENV_11: java.awt.PageAttributes$MediaType;
        ENV_12: java.awt.PageAttributes$MediaType;
        ENV_14: java.awt.PageAttributes$MediaType;
        ENV_INVITE: java.awt.PageAttributes$MediaType;
        ENV_ITALY: java.awt.PageAttributes$MediaType;
        ENV_MONARCH: java.awt.PageAttributes$MediaType;
        ENV_PERSONAL: java.awt.PageAttributes$MediaType;
        INVITE: java.awt.PageAttributes$MediaType;
        ITALY: java.awt.PageAttributes$MediaType;
        MONARCH: java.awt.PageAttributes$MediaType;
        PERSONAL: java.awt.PageAttributes$MediaType;
      }
      interface PageAttributes$MediaType { 
      }
      const PageAttributes$ColorType: {
        COLOR: java.awt.PageAttributes$ColorType;
        MONOCHROME: java.awt.PageAttributes$ColorType;
      }
      interface PageAttributes$ColorType { 
      }
      const PageAttributes$OriginType: {
        PHYSICAL: java.awt.PageAttributes$OriginType;
        PRINTABLE: java.awt.PageAttributes$OriginType;
      }
      interface PageAttributes$OriginType { 
      }
      const EventQueue: {
        getMostRecentEventTime(): number;
        getCurrentEvent(): java.awt.AWTEvent;
        isDispatchThread(): boolean;
        invokeLater(p0: java.lang.Runnable): void;
        invokeAndWait(p0: java.lang.Runnable): void;
        new(): java.awt.EventQueue;
      }
      interface EventQueue { 
        postEvent(p0: java.awt.AWTEvent): void;
        getNextEvent(): java.awt.AWTEvent;
        peekEvent(): java.awt.AWTEvent;
        peekEvent(p0: number): java.awt.AWTEvent;
        push(p0: java.awt.EventQueue): void;
        createSecondaryLoop(): java.awt.SecondaryLoop;
      }
      interface SecondaryLoop { 
        enter(): boolean;
        exit(): boolean;
      }
      const Dialog$ModalityType: {
        MODELESS: java.awt.Dialog$ModalityType;
        DOCUMENT_MODAL: java.awt.Dialog$ModalityType;
        APPLICATION_MODAL: java.awt.Dialog$ModalityType;
        TOOLKIT_MODAL: java.awt.Dialog$ModalityType;
        valueOf(value: string): java.awt.Dialog$ModalityType;
        values(): Array<java.awt.Dialog$ModalityType>;
      }
      interface Dialog$ModalityType extends kotlin.Enum<java.awt.Dialog$ModalityType> { 
      }
      const Dialog$ModalExclusionType: {
        NO_EXCLUDE: java.awt.Dialog$ModalExclusionType;
        APPLICATION_EXCLUDE: java.awt.Dialog$ModalExclusionType;
        TOOLKIT_EXCLUDE: java.awt.Dialog$ModalExclusionType;
        valueOf(value: string): java.awt.Dialog$ModalExclusionType;
        values(): Array<java.awt.Dialog$ModalExclusionType>;
      }
      interface Dialog$ModalExclusionType extends kotlin.Enum<java.awt.Dialog$ModalExclusionType> { 
      }
      const ImageCapabilities: {
        new(p0: boolean): java.awt.ImageCapabilities;
      }
      interface ImageCapabilities extends kotlin.Cloneable { 
        isAccelerated(): boolean;
        isTrueVolatile(): boolean;
      }
      interface Graphics2D extends java.awt.Graphics { 
        translate(p0: number, p1: number): void;
        drawString(p0: string, p1: number, p2: number): void;
        drawString(p0: java.text.AttributedCharacterIterator, p1: number, p2: number): void;
        drawImage(p0: java.awt.Image, p1: java.awt.geom.AffineTransform, p2: java.awt.image.ImageObserver): boolean;
        drawImage(p0: java.awt.image.BufferedImage, p1: java.awt.image.BufferedImageOp, p2: number, p3: number): void;
        draw(p0: java.awt.Shape): void;
        drawRenderedImage(p0: java.awt.image.RenderedImage, p1: java.awt.geom.AffineTransform): void;
        drawRenderableImage(p0: java.awt.image.renderable.RenderableImage, p1: java.awt.geom.AffineTransform): void;
        drawGlyphVector(p0: java.awt.font.GlyphVector, p1: number, p2: number): void;
        fill(p0: java.awt.Shape): void;
        hit(p0: java.awt.Rectangle, p1: java.awt.Shape, p2: boolean): boolean;
        getDeviceConfiguration(): java.awt.GraphicsConfiguration;
        setComposite(p0: java.awt.Composite): void;
        setPaint(p0: java.awt.Paint): void;
        setStroke(p0: java.awt.Stroke): void;
        setRenderingHint(p0: java.awt.RenderingHints$Key, p1: any): void;
        getRenderingHint(p0: java.awt.RenderingHints$Key): any;
        setRenderingHints(p0: Map<any, any>): void;
        addRenderingHints(p0: Map<any, any>): void;
        getRenderingHints(): java.awt.RenderingHints;
        rotate(p0: number): void;
        rotate(p0: number, p1: number, p2: number): void;
        scale(p0: number, p1: number): void;
        shear(p0: number, p1: number): void;
        transform(p0: java.awt.geom.AffineTransform): void;
        setTransform(p0: java.awt.geom.AffineTransform): void;
        getTransform(): java.awt.geom.AffineTransform;
        getPaint(): java.awt.Paint;
        getComposite(): java.awt.Composite;
        setBackground(p0: java.awt.Color): void;
        getBackground(): java.awt.Color;
        getStroke(): java.awt.Stroke;
        clip(p0: java.awt.Shape): void;
        getFontRenderContext(): java.awt.font.FontRenderContext;
      }
      interface Composite { 
        createContext(p0: java.awt.image.ColorModel, p1: java.awt.image.ColorModel, p2: java.awt.RenderingHints): java.awt.CompositeContext;
      }
      interface CompositeContext { 
        dispose(): void;
        compose(p0: java.awt.image.Raster, p1: java.awt.image.Raster, p2: java.awt.image.WritableRaster): void;
      }
      interface Stroke { 
        createStrokedShape(p0: java.awt.Shape): java.awt.Shape;
      }
      const PopupMenu: {
        new(): java.awt.PopupMenu;
        new(p0: string): java.awt.PopupMenu;
      }
      interface PopupMenu extends java.awt.Menu { 
        show(p0: java.awt.Component, p1: number, p2: number): void;
      }
      const ComponentOrientation: {
        LEFT_TO_RIGHT: java.awt.ComponentOrientation;
        RIGHT_TO_LEFT: java.awt.ComponentOrientation;
        UNKNOWN: java.awt.ComponentOrientation;
        getOrientation(p0: java.util.Locale): java.awt.ComponentOrientation;
        getOrientation(p0: java.util.ResourceBundle): java.awt.ComponentOrientation;
      }
      interface ComponentOrientation extends java.io.Serializable { 
        isHorizontal(): boolean;
        isLeftToRight(): boolean;
      }
      interface LayoutManager { 
        addLayoutComponent(p0: string, p1: java.awt.Component): void;
        removeLayoutComponent(p0: java.awt.Component): void;
        preferredLayoutSize(p0: java.awt.Container): java.awt.Dimension;
        minimumLayoutSize(p0: java.awt.Container): java.awt.Dimension;
        layoutContainer(p0: java.awt.Container): void;
      }
      interface FocusTraversalPolicy { 
        getComponentAfter(p0: java.awt.Container, p1: java.awt.Component): java.awt.Component;
        getComponentBefore(p0: java.awt.Container, p1: java.awt.Component): java.awt.Component;
        getFirstComponent(p0: java.awt.Container): java.awt.Component;
        getLastComponent(p0: java.awt.Container): java.awt.Component;
        getDefaultComponent(p0: java.awt.Container): java.awt.Component;
        getInitialComponent(p0: java.awt.Window): java.awt.Component;
      }
      const Window$Type: {
        NORMAL: java.awt.Window$Type;
        UTILITY: java.awt.Window$Type;
        POPUP: java.awt.Window$Type;
        valueOf(value: string): java.awt.Window$Type;
        values(): Array<java.awt.Window$Type>;
      }
      interface Window$Type extends kotlin.Enum<java.awt.Window$Type> { 
      }
      const BufferCapabilities: {
        FlipContents: typeof java.awt.BufferCapabilities$FlipContents;
        new(p0: java.awt.ImageCapabilities, p1: java.awt.ImageCapabilities, p2: java.awt.BufferCapabilities$FlipContents): java.awt.BufferCapabilities;
      }
      interface BufferCapabilities extends kotlin.Cloneable { 
        getFrontBufferCapabilities(): java.awt.ImageCapabilities;
        getBackBufferCapabilities(): java.awt.ImageCapabilities;
        isPageFlipping(): boolean;
        getFlipContents(): java.awt.BufferCapabilities$FlipContents;
        isFullScreenRequired(): boolean;
        isMultiBufferAvailable(): boolean;
      }
      const BufferCapabilities$FlipContents: {
        UNDEFINED: java.awt.BufferCapabilities$FlipContents;
        BACKGROUND: java.awt.BufferCapabilities$FlipContents;
        PRIOR: java.awt.BufferCapabilities$FlipContents;
        COPIED: java.awt.BufferCapabilities$FlipContents;
      }
      interface BufferCapabilities$FlipContents { 
      }
      const DisplayMode: {
        BIT_DEPTH_MULTI: number;
        REFRESH_RATE_UNKNOWN: number;
        new(p0: number, p1: number, p2: number, p3: number): java.awt.DisplayMode;
      }
      interface DisplayMode { 
        getHeight(): number;
        getWidth(): number;
        getBitDepth(): number;
        getRefreshRate(): number;
      }
    }
    namespace io {
      interface Serializable { 
      }
      const InputStream: {
        nullInputStream(): java.io.InputStream;
        new(): java.io.InputStream;
      }
      interface InputStream extends java.io.Closeable { 
        read(): number;
        read(p0: Array<number>): number;
        read(p0: Array<number>, p1: number, p2: number): number;
        readAllBytes(): Array<number>;
        readNBytes(p0: number): Array<number>;
        readNBytes(p0: Array<number>, p1: number, p2: number): number;
        skip(p0: number): number;
        skipNBytes(p0: number): void;
        available(): number;
        mark(p0: number): void;
        reset(): void;
        markSupported(): boolean;
        transferTo(p0: java.io.OutputStream): number;
      }
      interface Closeable extends java.lang.AutoCloseable { 
      }
      const OutputStream: {
        nullOutputStream(): java.io.OutputStream;
        new(): java.io.OutputStream;
      }
      interface OutputStream extends java.io.Closeable, java.io.Flushable { 
        write(p0: number): void;
        write(p0: Array<number>): void;
        write(p0: Array<number>, p1: number, p2: number): void;
      }
      interface Flushable { 
        flush(): void;
      }
      const PrintStream: {
        new(p0: java.io.OutputStream): java.io.PrintStream;
        new(p0: java.io.OutputStream, p1: boolean): java.io.PrintStream;
        new(p0: java.io.OutputStream, p1: boolean, p2: string): java.io.PrintStream;
        new(p0: java.io.OutputStream, p1: boolean, p2: java.nio.charset.Charset): java.io.PrintStream;
        new(p0: string): java.io.PrintStream;
        new(p0: string, p1: string): java.io.PrintStream;
        new(p0: string, p1: java.nio.charset.Charset): java.io.PrintStream;
        new(p0: java.io.File): java.io.PrintStream;
        new(p0: java.io.File, p1: string): java.io.PrintStream;
        new(p0: java.io.File, p1: java.nio.charset.Charset): java.io.PrintStream;
      }
      interface PrintStream extends java.io.FilterOutputStream, java.lang.Appendable, java.io.Closeable { 
        checkError(): boolean;
        writeBytes(p0: Array<number>): void;
        print(p0: boolean): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: Array<number>): void;
        print(p0: string): void;
        print(p0: any): void;
        println(): void;
        println(p0: boolean): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: Array<number>): void;
        println(p0: string): void;
        println(p0: any): void;
        printf(p0: string, p1: any): java.io.PrintStream;
        printf(p0: java.util.Locale, p1: string, p2: any): java.io.PrintStream;
        format(p0: string, p1: any): java.io.PrintStream;
        format(p0: java.util.Locale, p1: string, p2: any): java.io.PrintStream;
        charset(): java.nio.charset.Charset;
      }
      const FilterOutputStream: {
        new(p0: java.io.OutputStream): java.io.FilterOutputStream;
      }
      interface FilterOutputStream extends java.io.OutputStream { 
      }
      const File: {
        separatorChar: number;
        separator: string;
        pathSeparatorChar: number;
        pathSeparator: string;
        listRoots(): Array<java.io.File>;
        createTempFile(p0: string, p1: string, p2: java.io.File): java.io.File;
        createTempFile(p0: string, p1: string): java.io.File;
        new(p0: string): java.io.File;
        new(p0: string, p1: string): java.io.File;
        new(p0: java.io.File, p1: string): java.io.File;
        new(p0: java.net.URI): java.io.File;
      }
      interface File extends java.io.Serializable, kotlin.Comparable<java.io.File> { 
        getName(): string;
        getParent(): string;
        getParentFile(): java.io.File;
        getPath(): string;
        isAbsolute(): boolean;
        getAbsolutePath(): string;
        getAbsoluteFile(): java.io.File;
        getCanonicalPath(): string;
        getCanonicalFile(): java.io.File;
        toURL(): java.net.URL;
        toURI(): java.net.URI;
        canRead(): boolean;
        canWrite(): boolean;
        exists(): boolean;
        isDirectory(): boolean;
        isFile(): boolean;
        isHidden(): boolean;
        lastModified(): number;
        length(): number;
        createNewFile(): boolean;
        deleteOnExit(): void;
        list(): Array<string>;
        list(p0: java.io.FilenameFilter): Array<string>;
        listFiles(): Array<java.io.File>;
        listFiles(p0: java.io.FilenameFilter): Array<java.io.File>;
        listFiles(p0: java.io.FileFilter): Array<java.io.File>;
        mkdir(): boolean;
        mkdirs(): boolean;
        renameTo(p0: java.io.File): boolean;
        setLastModified(p0: number): boolean;
        setReadOnly(): boolean;
        setWritable(p0: boolean, p1: boolean): boolean;
        setWritable(p0: boolean): boolean;
        setReadable(p0: boolean, p1: boolean): boolean;
        setReadable(p0: boolean): boolean;
        setExecutable(p0: boolean, p1: boolean): boolean;
        setExecutable(p0: boolean): boolean;
        canExecute(): boolean;
        getTotalSpace(): number;
        getFreeSpace(): number;
        getUsableSpace(): number;
        toPath(): java.nio.file.Path;
      }
      interface FilenameFilter { 
        accept(p0: java.io.File, p1: string): boolean;
        (p0: java.io.File, p1: string): boolean;
      }
      interface FileFilter { 
        accept(p0: java.io.File): boolean;
        (p0: java.io.File): boolean;
      }
      const PrintWriter: {
        new(p0: java.io.Writer): java.io.PrintWriter;
        new(p0: java.io.Writer, p1: boolean): java.io.PrintWriter;
        new(p0: java.io.OutputStream): java.io.PrintWriter;
        new(p0: java.io.OutputStream, p1: boolean): java.io.PrintWriter;
        new(p0: java.io.OutputStream, p1: boolean, p2: java.nio.charset.Charset): java.io.PrintWriter;
        new(p0: string): java.io.PrintWriter;
        new(p0: string, p1: string): java.io.PrintWriter;
        new(p0: string, p1: java.nio.charset.Charset): java.io.PrintWriter;
        new(p0: java.io.File): java.io.PrintWriter;
        new(p0: java.io.File, p1: string): java.io.PrintWriter;
        new(p0: java.io.File, p1: java.nio.charset.Charset): java.io.PrintWriter;
      }
      interface PrintWriter extends java.io.Writer { 
        checkError(): boolean;
        print(p0: boolean): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: number): void;
        print(p0: Array<number>): void;
        print(p0: string): void;
        print(p0: any): void;
        println(): void;
        println(p0: boolean): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: number): void;
        println(p0: Array<number>): void;
        println(p0: string): void;
        println(p0: any): void;
        printf(p0: string, p1: any): java.io.PrintWriter;
        printf(p0: java.util.Locale, p1: string, p2: any): java.io.PrintWriter;
        format(p0: string, p1: any): java.io.PrintWriter;
        format(p0: java.util.Locale, p1: string, p2: any): java.io.PrintWriter;
      }
      const Writer: {
        nullWriter(): java.io.Writer;
      }
      interface Writer extends java.lang.Appendable, java.io.Closeable, java.io.Flushable { 
        write(p0: number): void;
        write(p0: Array<number>): void;
        write(p0: Array<number>, p1: number, p2: number): void;
        write(p0: string): void;
        write(p0: string, p1: number, p2: number): void;
      }
      interface Externalizable extends java.io.Serializable { 
        writeExternal(p0: java.io.ObjectOutput): void;
        readExternal(p0: java.io.ObjectInput): void;
      }
      interface ObjectOutput extends java.io.DataOutput, java.lang.AutoCloseable { 
        writeObject(p0: any): void;
        flush(): void;
      }
      interface DataOutput { 
        write(p0: number): void;
        write(p0: Array<number>): void;
        write(p0: Array<number>, p1: number, p2: number): void;
        writeBoolean(p0: boolean): void;
        writeByte(p0: number): void;
        writeShort(p0: number): void;
        writeChar(p0: number): void;
        writeInt(p0: number): void;
        writeLong(p0: number): void;
        writeFloat(p0: number): void;
        writeDouble(p0: number): void;
        writeBytes(p0: string): void;
        writeChars(p0: string): void;
        writeUTF(p0: string): void;
      }
      interface ObjectInput extends java.io.DataInput, java.lang.AutoCloseable { 
        readObject(): any;
        read(): number;
        read(p0: Array<number>): number;
        read(p0: Array<number>, p1: number, p2: number): number;
        skip(p0: number): number;
        available(): number;
      }
      interface DataInput { 
        readFully(p0: Array<number>): void;
        readFully(p0: Array<number>, p1: number, p2: number): void;
        skipBytes(p0: number): number;
        readBoolean(): boolean;
        readByte(): number;
        readUnsignedByte(): number;
        readShort(): number;
        readUnsignedShort(): number;
        readChar(): number;
        readInt(): number;
        readLong(): number;
        readFloat(): number;
        readDouble(): number;
        readLine(): string;
        readUTF(): string;
      }
      const Reader: {
        nullReader(): java.io.Reader;
      }
      interface Reader extends java.lang.Readable, java.io.Closeable { 
        read(): number;
        read(p0: Array<number>): number;
        read(p0: Array<number>, p1: number, p2: number): number;
        skip(p0: number): number;
        ready(): boolean;
        markSupported(): boolean;
        mark(p0: number): void;
        reset(): void;
        transferTo(p0: java.io.Writer): number;
      }
      const BufferedReader: {
        new(p0: java.io.Reader, p1: number): java.io.BufferedReader;
        new(p0: java.io.Reader): java.io.BufferedReader;
      }
      interface BufferedReader extends java.io.Reader { 
        readLine(): string;
        lines(): java.util.stream.Stream<string>;
      }
    }
    namespace util {
      namespace stream {
        const IntStream: {
          builder(): java.util.stream.IntStream$Builder;
          empty(): java.util.stream.IntStream;
          of(p0: number): java.util.stream.IntStream;
          of(p0: number): java.util.stream.IntStream;
          iterate(p0: number, p1: unknown): java.util.stream.IntStream;
          iterate(p0: number, p1: unknown, p2: unknown): java.util.stream.IntStream;
          generate(p0: unknown): java.util.stream.IntStream;
          range(p0: number, p1: number): java.util.stream.IntStream;
          rangeClosed(p0: number, p1: number): java.util.stream.IntStream;
          concat(p0: java.util.stream.IntStream, p1: java.util.stream.IntStream): java.util.stream.IntStream;
        }
        interface IntStream extends java.util.stream.BaseStream<number, java.util.stream.IntStream> { 
          filter(p0: unknown): java.util.stream.IntStream;
          map(p0: unknown): java.util.stream.IntStream;
          mapToObj<U>(p0: unknown): java.util.stream.Stream<U>;
          mapToLong(p0: unknown): java.util.stream.LongStream;
          mapToDouble(p0: unknown): java.util.stream.DoubleStream;
          flatMap(p0: unknown): java.util.stream.IntStream;
          mapMulti(p0: java.util.stream.IntStream$IntMapMultiConsumer): java.util.stream.IntStream;
          distinct(): java.util.stream.IntStream;
          sorted(): java.util.stream.IntStream;
          peek(p0: unknown): java.util.stream.IntStream;
          limit(p0: number): java.util.stream.IntStream;
          skip(p0: number): java.util.stream.IntStream;
          takeWhile(p0: unknown): java.util.stream.IntStream;
          dropWhile(p0: unknown): java.util.stream.IntStream;
          forEach(p0: unknown): void;
          forEachOrdered(p0: unknown): void;
          toArray(): Array<number>;
          reduce(p0: number, p1: unknown): number;
          reduce(p0: unknown): java.util.OptionalInt;
          collect<R>(p0: unknown, p1: unknown, p2: unknown): R;
          sum(): number;
          min(): java.util.OptionalInt;
          max(): java.util.OptionalInt;
          count(): number;
          average(): java.util.OptionalDouble;
          summaryStatistics(): java.util.IntSummaryStatistics;
          anyMatch(p0: unknown): boolean;
          allMatch(p0: unknown): boolean;
          noneMatch(p0: unknown): boolean;
          findFirst(): java.util.OptionalInt;
          findAny(): java.util.OptionalInt;
          asLongStream(): java.util.stream.LongStream;
          asDoubleStream(): java.util.stream.DoubleStream;
          boxed(): java.util.stream.Stream<number>;
        }
        interface BaseStream<T, S> extends java.lang.AutoCloseable { 
          iterator(): kotlin.collections.MutableIterator<T>;
          spliterator(): java.util.Spliterator<T>;
          isParallel(): boolean;
          sequential(): S;
          parallel(): S;
          unordered(): S;
          onClose(p0: java.lang.Runnable): S;
        }
        interface IntStream$IntMapMultiConsumer { 
          accept(p0: number, p1: unknown): void;
          (p0: number, p1: unknown): void;
        }
        interface IntStream$Builder { 
          add(p0: number): java.util.stream.IntStream$Builder;
          build(): java.util.stream.IntStream;
        }
        const Stream: {
          builder<T>(): java.util.stream.Stream$Builder<T>;
          empty<T>(): java.util.stream.Stream<T>;
          of<T>(p0: T): java.util.stream.Stream<T>;
          of<T>(p0: T): java.util.stream.Stream<T>;
          ofNullable<T>(p0: T): java.util.stream.Stream<T>;
          iterate<T>(p0: T, p1: unknown): java.util.stream.Stream<T>;
          iterate<T>(p0: T, p1: unknown, p2: unknown): java.util.stream.Stream<T>;
          generate<T>(p0: unknown): java.util.stream.Stream<T>;
          concat<T>(p0: java.util.stream.Stream<T>, p1: java.util.stream.Stream<T>): java.util.stream.Stream<T>;
        }
        interface Stream<T> extends java.util.stream.BaseStream<T, java.util.stream.Stream<T>> { 
          filter(p0: unknown): java.util.stream.Stream<T>;
          map<R>(p0: unknown): java.util.stream.Stream<R>;
          mapToInt(p0: unknown): java.util.stream.IntStream;
          mapToLong(p0: unknown): java.util.stream.LongStream;
          mapToDouble(p0: unknown): java.util.stream.DoubleStream;
          flatMap<R>(p0: unknown): java.util.stream.Stream<R>;
          flatMapToInt(p0: unknown): java.util.stream.IntStream;
          flatMapToLong(p0: unknown): java.util.stream.LongStream;
          flatMapToDouble(p0: unknown): java.util.stream.DoubleStream;
          mapMulti<R>(p0: unknown): java.util.stream.Stream<R>;
          mapMultiToInt(p0: unknown): java.util.stream.IntStream;
          mapMultiToLong(p0: unknown): java.util.stream.LongStream;
          mapMultiToDouble(p0: unknown): java.util.stream.DoubleStream;
          distinct(): java.util.stream.Stream<T>;
          sorted(): java.util.stream.Stream<T>;
          sorted(p0: java.util.Comparator<T>): java.util.stream.Stream<T>;
          peek(p0: unknown): java.util.stream.Stream<T>;
          limit(p0: number): java.util.stream.Stream<T>;
          skip(p0: number): java.util.stream.Stream<T>;
          takeWhile(p0: unknown): java.util.stream.Stream<T>;
          dropWhile(p0: unknown): java.util.stream.Stream<T>;
          forEach(p0: unknown): void;
          forEachOrdered(p0: unknown): void;
          toArray(): Array<any>;
          toArray<A>(p0: unknown): Array<A>;
          reduce(p0: T, p1: unknown): T;
          reduce(p0: unknown): java.util.Optional<T>;
          reduce<U>(p0: U, p1: unknown, p2: unknown): U;
          collect<R>(p0: unknown, p1: unknown, p2: unknown): R;
          collect<R, A>(p0: java.util.stream.Collector<T, A, R>): R;
          toList(): Array<T>;
          min(p0: java.util.Comparator<T>): java.util.Optional<T>;
          max(p0: java.util.Comparator<T>): java.util.Optional<T>;
          count(): number;
          anyMatch(p0: unknown): boolean;
          allMatch(p0: unknown): boolean;
          noneMatch(p0: unknown): boolean;
          findFirst(): java.util.Optional<T>;
          findAny(): java.util.Optional<T>;
        }
        interface Stream$Builder<T> { 
          add(p0: T): java.util.stream.Stream$Builder<T>;
          build(): java.util.stream.Stream<T>;
        }
        const LongStream: {
          builder(): java.util.stream.LongStream$Builder;
          empty(): java.util.stream.LongStream;
          of(p0: number): java.util.stream.LongStream;
          of(p0: number): java.util.stream.LongStream;
          iterate(p0: number, p1: unknown): java.util.stream.LongStream;
          iterate(p0: number, p1: unknown, p2: unknown): java.util.stream.LongStream;
          generate(p0: unknown): java.util.stream.LongStream;
          range(p0: number, p1: number): java.util.stream.LongStream;
          rangeClosed(p0: number, p1: number): java.util.stream.LongStream;
          concat(p0: java.util.stream.LongStream, p1: java.util.stream.LongStream): java.util.stream.LongStream;
        }
        interface LongStream extends java.util.stream.BaseStream<number, java.util.stream.LongStream> { 
          filter(p0: unknown): java.util.stream.LongStream;
          map(p0: unknown): java.util.stream.LongStream;
          mapToObj<U>(p0: unknown): java.util.stream.Stream<U>;
          mapToInt(p0: unknown): java.util.stream.IntStream;
          mapToDouble(p0: unknown): java.util.stream.DoubleStream;
          flatMap(p0: unknown): java.util.stream.LongStream;
          mapMulti(p0: java.util.stream.LongStream$LongMapMultiConsumer): java.util.stream.LongStream;
          distinct(): java.util.stream.LongStream;
          sorted(): java.util.stream.LongStream;
          peek(p0: unknown): java.util.stream.LongStream;
          limit(p0: number): java.util.stream.LongStream;
          skip(p0: number): java.util.stream.LongStream;
          takeWhile(p0: unknown): java.util.stream.LongStream;
          dropWhile(p0: unknown): java.util.stream.LongStream;
          forEach(p0: unknown): void;
          forEachOrdered(p0: unknown): void;
          toArray(): Array<number>;
          reduce(p0: number, p1: unknown): number;
          reduce(p0: unknown): java.util.OptionalLong;
          collect<R>(p0: unknown, p1: unknown, p2: unknown): R;
          sum(): number;
          min(): java.util.OptionalLong;
          max(): java.util.OptionalLong;
          count(): number;
          average(): java.util.OptionalDouble;
          summaryStatistics(): java.util.LongSummaryStatistics;
          anyMatch(p0: unknown): boolean;
          allMatch(p0: unknown): boolean;
          noneMatch(p0: unknown): boolean;
          findFirst(): java.util.OptionalLong;
          findAny(): java.util.OptionalLong;
          asDoubleStream(): java.util.stream.DoubleStream;
          boxed(): java.util.stream.Stream<number>;
        }
        interface LongStream$Builder { 
          add(p0: number): java.util.stream.LongStream$Builder;
          build(): java.util.stream.LongStream;
        }
        interface LongStream$LongMapMultiConsumer { 
          accept(p0: number, p1: unknown): void;
          (p0: number, p1: unknown): void;
        }
        const DoubleStream: {
          builder(): java.util.stream.DoubleStream$Builder;
          empty(): java.util.stream.DoubleStream;
          of(p0: number): java.util.stream.DoubleStream;
          of(p0: number): java.util.stream.DoubleStream;
          iterate(p0: number, p1: unknown): java.util.stream.DoubleStream;
          iterate(p0: number, p1: unknown, p2: unknown): java.util.stream.DoubleStream;
          generate(p0: unknown): java.util.stream.DoubleStream;
          concat(p0: java.util.stream.DoubleStream, p1: java.util.stream.DoubleStream): java.util.stream.DoubleStream;
        }
        interface DoubleStream extends java.util.stream.BaseStream<number, java.util.stream.DoubleStream> { 
          filter(p0: unknown): java.util.stream.DoubleStream;
          map(p0: unknown): java.util.stream.DoubleStream;
          mapToObj<U>(p0: unknown): java.util.stream.Stream<U>;
          mapToInt(p0: unknown): java.util.stream.IntStream;
          mapToLong(p0: unknown): java.util.stream.LongStream;
          flatMap(p0: unknown): java.util.stream.DoubleStream;
          mapMulti(p0: java.util.stream.DoubleStream$DoubleMapMultiConsumer): java.util.stream.DoubleStream;
          distinct(): java.util.stream.DoubleStream;
          sorted(): java.util.stream.DoubleStream;
          peek(p0: unknown): java.util.stream.DoubleStream;
          limit(p0: number): java.util.stream.DoubleStream;
          skip(p0: number): java.util.stream.DoubleStream;
          takeWhile(p0: unknown): java.util.stream.DoubleStream;
          dropWhile(p0: unknown): java.util.stream.DoubleStream;
          forEach(p0: unknown): void;
          forEachOrdered(p0: unknown): void;
          toArray(): kotlin.DoubleArray;
          reduce(p0: number, p1: unknown): number;
          reduce(p0: unknown): java.util.OptionalDouble;
          collect<R>(p0: unknown, p1: unknown, p2: unknown): R;
          sum(): number;
          min(): java.util.OptionalDouble;
          max(): java.util.OptionalDouble;
          count(): number;
          average(): java.util.OptionalDouble;
          summaryStatistics(): java.util.DoubleSummaryStatistics;
          anyMatch(p0: unknown): boolean;
          allMatch(p0: unknown): boolean;
          noneMatch(p0: unknown): boolean;
          findFirst(): java.util.OptionalDouble;
          findAny(): java.util.OptionalDouble;
          boxed(): java.util.stream.Stream<number>;
        }
        interface DoubleStream$Builder { 
          add(p0: number): java.util.stream.DoubleStream$Builder;
          build(): java.util.stream.DoubleStream;
        }
        interface DoubleStream$DoubleMapMultiConsumer { 
          accept(p0: number, p1: unknown): void;
          (p0: number, p1: unknown): void;
        }
        const Collector: {
          Characteristics: typeof java.util.stream.Collector$Characteristics;
          of<T, R>(p0: unknown, p1: unknown, p2: unknown, p3: java.util.stream.Collector$Characteristics): java.util.stream.Collector<T, R, R>;
          of<T, A, R>(p0: unknown, p1: unknown, p2: unknown, p3: unknown, p4: java.util.stream.Collector$Characteristics): java.util.stream.Collector<T, A, R>;
        }
        interface Collector<T, A, R> { 
          supplier(): unknown;
          accumulator(): unknown;
          combiner(): unknown;
          finisher(): unknown;
          characteristics(): Set<java.util.stream.Collector$Characteristics>;
        }
        const Collector$Characteristics: {
          CONCURRENT: java.util.stream.Collector$Characteristics;
          UNORDERED: java.util.stream.Collector$Characteristics;
          IDENTITY_FINISH: java.util.stream.Collector$Characteristics;
          valueOf(value: string): java.util.stream.Collector$Characteristics;
          values(): Array<java.util.stream.Collector$Characteristics>;
        }
        interface Collector$Characteristics extends kotlin.Enum<java.util.stream.Collector$Characteristics> { 
        }
      }
      namespace concurrent {
        namespace atomic {
          const AtomicBoolean: {
            new(p0: boolean): java.util.concurrent.atomic.AtomicBoolean;
            new(): java.util.concurrent.atomic.AtomicBoolean;
          }
          interface AtomicBoolean extends java.io.Serializable { 
            get(): boolean;
            compareAndSet(p0: boolean, p1: boolean): boolean;
            weakCompareAndSet(p0: boolean, p1: boolean): boolean;
            weakCompareAndSetPlain(p0: boolean, p1: boolean): boolean;
            set(p0: boolean): void;
            lazySet(p0: boolean): void;
            getAndSet(p0: boolean): boolean;
            getPlain(): boolean;
            setPlain(p0: boolean): void;
            getOpaque(): boolean;
            setOpaque(p0: boolean): void;
            getAcquire(): boolean;
            setRelease(p0: boolean): void;
            compareAndExchange(p0: boolean, p1: boolean): boolean;
            compareAndExchangeAcquire(p0: boolean, p1: boolean): boolean;
            compareAndExchangeRelease(p0: boolean, p1: boolean): boolean;
            weakCompareAndSetVolatile(p0: boolean, p1: boolean): boolean;
            weakCompareAndSetAcquire(p0: boolean, p1: boolean): boolean;
            weakCompareAndSetRelease(p0: boolean, p1: boolean): boolean;
          }
          const AtomicReference: {
            new<V>(p0: V): java.util.concurrent.atomic.AtomicReference<V>;
            new<V>(): java.util.concurrent.atomic.AtomicReference<V>;
          }
          interface AtomicReference<V> extends java.io.Serializable { 
            get(): V;
            set(p0: V): void;
            lazySet(p0: V): void;
            compareAndSet(p0: V, p1: V): boolean;
            weakCompareAndSet(p0: V, p1: V): boolean;
            weakCompareAndSetPlain(p0: V, p1: V): boolean;
            getAndSet(p0: V): V;
            getAndUpdate(p0: unknown): V;
            updateAndGet(p0: unknown): V;
            getAndAccumulate(p0: V, p1: unknown): V;
            accumulateAndGet(p0: V, p1: unknown): V;
            getPlain(): V;
            setPlain(p0: V): void;
            getOpaque(): V;
            setOpaque(p0: V): void;
            getAcquire(): V;
            setRelease(p0: V): void;
            compareAndExchange(p0: V, p1: V): V;
            compareAndExchangeAcquire(p0: V, p1: V): V;
            compareAndExchangeRelease(p0: V, p1: V): V;
            weakCompareAndSetVolatile(p0: V, p1: V): boolean;
            weakCompareAndSetAcquire(p0: V, p1: V): boolean;
            weakCompareAndSetRelease(p0: V, p1: V): boolean;
          }
        }
        const TimeUnit: {
          NANOSECONDS: java.util.concurrent.TimeUnit;
          MICROSECONDS: java.util.concurrent.TimeUnit;
          MILLISECONDS: java.util.concurrent.TimeUnit;
          SECONDS: java.util.concurrent.TimeUnit;
          MINUTES: java.util.concurrent.TimeUnit;
          HOURS: java.util.concurrent.TimeUnit;
          DAYS: java.util.concurrent.TimeUnit;
          of(p0: java.time.temporal.ChronoUnit): java.util.concurrent.TimeUnit;
          valueOf(value: string): java.util.concurrent.TimeUnit;
          values(): Array<java.util.concurrent.TimeUnit>;
        }
        interface TimeUnit extends kotlin.Enum<java.util.concurrent.TimeUnit> { 
          convert(p0: number, p1: java.util.concurrent.TimeUnit): number;
          convert(p0: java.time.Duration): number;
          toNanos(p0: number): number;
          toMicros(p0: number): number;
          toMillis(p0: number): number;
          toSeconds(p0: number): number;
          toMinutes(p0: number): number;
          toHours(p0: number): number;
          toDays(p0: number): number;
          timedWait(p0: any, p1: number): void;
          timedJoin(p0: java.lang.Thread, p1: number): void;
          sleep(p0: number): void;
          toChronoUnit(): java.time.temporal.ChronoUnit;
        }
        interface ThreadFactory { 
          newThread(p0: java.lang.Runnable): java.lang.Thread;
        }
        const Future: {
          State: typeof java.util.concurrent.Future$State;
        }
        interface Future<V> { 
          cancel(p0: boolean): boolean;
          isCancelled(): boolean;
          isDone(): boolean;
          get(): V;
          get(p0: number, p1: java.util.concurrent.TimeUnit): V;
          resultNow(): V;
          exceptionNow(): kotlin.Throwable;
          state(): java.util.concurrent.Future$State;
        }
        const Future$State: {
          RUNNING: java.util.concurrent.Future$State;
          SUCCESS: java.util.concurrent.Future$State;
          FAILED: java.util.concurrent.Future$State;
          CANCELLED: java.util.concurrent.Future$State;
          valueOf(value: string): java.util.concurrent.Future$State;
          values(): Array<java.util.concurrent.Future$State>;
        }
        interface Future$State extends kotlin.Enum<java.util.concurrent.Future$State> { 
        }
        interface ExecutorService extends java.util.concurrent.Executor, java.lang.AutoCloseable { 
          shutdown(): void;
          shutdownNow(): Array<java.lang.Runnable>;
          isShutdown(): boolean;
          isTerminated(): boolean;
          awaitTermination(p0: number, p1: java.util.concurrent.TimeUnit): boolean;
          submit<T>(p0: java.util.concurrent.Callable<T>): java.util.concurrent.Future<T>;
          submit<T>(p0: java.lang.Runnable, p1: T): java.util.concurrent.Future<T>;
          submit(p0: java.lang.Runnable): java.util.concurrent.Future<any>;
          invokeAll<T>(p0: Array<java.util.concurrent.Callable<T>>): Array<java.util.concurrent.Future<T>>;
          invokeAll<T>(p0: Array<java.util.concurrent.Callable<T>>, p1: number, p2: java.util.concurrent.TimeUnit): Array<java.util.concurrent.Future<T>>;
          invokeAny<T>(p0: Array<java.util.concurrent.Callable<T>>): T;
          invokeAny<T>(p0: Array<java.util.concurrent.Callable<T>>, p1: number, p2: java.util.concurrent.TimeUnit): T;
        }
        interface Executor { 
          execute(p0: java.lang.Runnable): void;
        }
        interface Callable<V> { 
          call(): V;
          (): V;
        }
        const CompletableFuture: {
          supplyAsync<U>(p0: unknown): java.util.concurrent.CompletableFuture<U>;
          supplyAsync<U>(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletableFuture<U>;
          runAsync(p0: java.lang.Runnable): java.util.concurrent.CompletableFuture<java.lang.Void>;
          runAsync(p0: java.lang.Runnable, p1: java.util.concurrent.Executor): java.util.concurrent.CompletableFuture<java.lang.Void>;
          completedFuture<U>(p0: U): java.util.concurrent.CompletableFuture<U>;
          allOf(p0: java.util.concurrent.CompletableFuture<any>): java.util.concurrent.CompletableFuture<java.lang.Void>;
          anyOf(p0: java.util.concurrent.CompletableFuture<any>): java.util.concurrent.CompletableFuture<any>;
          delayedExecutor(p0: number, p1: java.util.concurrent.TimeUnit, p2: java.util.concurrent.Executor): java.util.concurrent.Executor;
          delayedExecutor(p0: number, p1: java.util.concurrent.TimeUnit): java.util.concurrent.Executor;
          completedStage<U>(p0: U): java.util.concurrent.CompletionStage<U>;
          failedFuture<U>(p0: kotlin.Throwable): java.util.concurrent.CompletableFuture<U>;
          failedStage<U>(p0: kotlin.Throwable): java.util.concurrent.CompletionStage<U>;
          new<T>(): java.util.concurrent.CompletableFuture<T>;
        }
        interface CompletableFuture<T> extends java.util.concurrent.Future<T>, java.util.concurrent.CompletionStage<T> { 
          join(): T;
          getNow(p0: T): T;
          complete(p0: T): boolean;
          completeExceptionally(p0: kotlin.Throwable): boolean;
          isCompletedExceptionally(): boolean;
          obtrudeValue(p0: T): void;
          obtrudeException(p0: kotlin.Throwable): void;
          getNumberOfDependents(): number;
          newIncompleteFuture<U>(): java.util.concurrent.CompletableFuture<U>;
          defaultExecutor(): java.util.concurrent.Executor;
          copy(): java.util.concurrent.CompletableFuture<T>;
          minimalCompletionStage(): java.util.concurrent.CompletionStage<T>;
          completeAsync(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletableFuture<T>;
          completeAsync(p0: unknown): java.util.concurrent.CompletableFuture<T>;
          orTimeout(p0: number, p1: java.util.concurrent.TimeUnit): java.util.concurrent.CompletableFuture<T>;
          completeOnTimeout(p0: T, p1: number, p2: java.util.concurrent.TimeUnit): java.util.concurrent.CompletableFuture<T>;
        }
        interface CompletionStage<T> { 
          thenApply<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          thenApplyAsync<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          thenApplyAsync<U>(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<U>;
          thenAccept(p0: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenAcceptAsync(p0: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenAcceptAsync(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenRun(p0: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenRunAsync(p0: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenRunAsync(p0: java.lang.Runnable, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenCombine<U, V>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown): java.util.concurrent.CompletionStage<V>;
          thenCombineAsync<U, V>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown): java.util.concurrent.CompletionStage<V>;
          thenCombineAsync<U, V>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<V>;
          thenAcceptBoth<U>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenAcceptBothAsync<U>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenAcceptBothAsync<U>(p0: java.util.concurrent.CompletionStage<U>, p1: unknown, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterBoth(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterBothAsync(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterBothAsync(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          applyToEither<U>(p0: java.util.concurrent.CompletionStage<T>, p1: unknown): java.util.concurrent.CompletionStage<U>;
          applyToEitherAsync<U>(p0: java.util.concurrent.CompletionStage<T>, p1: unknown): java.util.concurrent.CompletionStage<U>;
          applyToEitherAsync<U>(p0: java.util.concurrent.CompletionStage<T>, p1: unknown, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<U>;
          acceptEither(p0: java.util.concurrent.CompletionStage<T>, p1: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          acceptEitherAsync(p0: java.util.concurrent.CompletionStage<T>, p1: unknown): java.util.concurrent.CompletionStage<java.lang.Void>;
          acceptEitherAsync(p0: java.util.concurrent.CompletionStage<T>, p1: unknown, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterEither(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterEitherAsync(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable): java.util.concurrent.CompletionStage<java.lang.Void>;
          runAfterEitherAsync(p0: java.util.concurrent.CompletionStage<any>, p1: java.lang.Runnable, p2: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<java.lang.Void>;
          thenCompose<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          thenComposeAsync<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          thenComposeAsync<U>(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<U>;
          handle<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          handleAsync<U>(p0: unknown): java.util.concurrent.CompletionStage<U>;
          handleAsync<U>(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<U>;
          whenComplete(p0: unknown): java.util.concurrent.CompletionStage<T>;
          whenCompleteAsync(p0: unknown): java.util.concurrent.CompletionStage<T>;
          whenCompleteAsync(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<T>;
          exceptionally(p0: unknown): java.util.concurrent.CompletionStage<T>;
          exceptionallyAsync(p0: unknown): java.util.concurrent.CompletionStage<T>;
          exceptionallyAsync(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<T>;
          exceptionallyCompose(p0: unknown): java.util.concurrent.CompletionStage<T>;
          exceptionallyComposeAsync(p0: unknown): java.util.concurrent.CompletionStage<T>;
          exceptionallyComposeAsync(p0: unknown, p1: java.util.concurrent.Executor): java.util.concurrent.CompletionStage<T>;
          toCompletableFuture(): java.util.concurrent.CompletableFuture<T>;
        }
        interface CompletableFuture$AsynchronousCompletionTask { 
        }
        interface ScheduledExecutorService extends java.util.concurrent.ExecutorService { 
          schedule(p0: java.lang.Runnable, p1: number, p2: java.util.concurrent.TimeUnit): java.util.concurrent.ScheduledFuture<any>;
          schedule<V>(p0: java.util.concurrent.Callable<V>, p1: number, p2: java.util.concurrent.TimeUnit): java.util.concurrent.ScheduledFuture<V>;
          scheduleAtFixedRate(p0: java.lang.Runnable, p1: number, p2: number, p3: java.util.concurrent.TimeUnit): java.util.concurrent.ScheduledFuture<any>;
          scheduleWithFixedDelay(p0: java.lang.Runnable, p1: number, p2: number, p3: java.util.concurrent.TimeUnit): java.util.concurrent.ScheduledFuture<any>;
        }
        interface ScheduledFuture<V> extends java.util.concurrent.Delayed, java.util.concurrent.Future<V> { 
        }
        interface Delayed extends kotlin.Comparable<java.util.concurrent.Delayed> { 
          getDelay(p0: java.util.concurrent.TimeUnit): number;
        }
        const CopyOnWriteArrayList: {
          new<E>(): java.util.concurrent.CopyOnWriteArrayList<E>;
          new<E>(p0: Array<E>): java.util.concurrent.CopyOnWriteArrayList<E>;
          new<E>(p0: Array<E>): java.util.concurrent.CopyOnWriteArrayList<E>;
        }
        interface CopyOnWriteArrayList<E> extends Array<E>, java.util.RandomAccess, kotlin.Cloneable, java.io.Serializable { 
          indexOf(p0: E, p1: number): number;
          lastIndexOf(p0: E, p1: number): number;
          toArray(): Array<any>;
          toArray<T>(p0: Array<T>): Array<T>;
          addIfAbsent(p0: E): boolean;
          addAllAbsent(p0: Array<E>): number;
        }
      }
      namespace random {
        const RandomGenerator: {
          of(p0: string): java.util.random.RandomGenerator;
          getDefault(): java.util.random.RandomGenerator;
        }
        interface RandomGenerator { 
          isDeprecated(): boolean;
          doubles(): java.util.stream.DoubleStream;
          doubles(p0: number, p1: number): java.util.stream.DoubleStream;
          doubles(p0: number): java.util.stream.DoubleStream;
          doubles(p0: number, p1: number, p2: number): java.util.stream.DoubleStream;
          ints(): java.util.stream.IntStream;
          ints(p0: number, p1: number): java.util.stream.IntStream;
          ints(p0: number): java.util.stream.IntStream;
          ints(p0: number, p1: number, p2: number): java.util.stream.IntStream;
          longs(): java.util.stream.LongStream;
          longs(p0: number, p1: number): java.util.stream.LongStream;
          longs(p0: number): java.util.stream.LongStream;
          longs(p0: number, p1: number, p2: number): java.util.stream.LongStream;
          nextBoolean(): boolean;
          nextBytes(p0: Array<number>): void;
          nextFloat(): number;
          nextFloat(p0: number): number;
          nextFloat(p0: number, p1: number): number;
          nextDouble(): number;
          nextDouble(p0: number): number;
          nextDouble(p0: number, p1: number): number;
          nextInt(): number;
          nextInt(p0: number): number;
          nextInt(p0: number, p1: number): number;
          nextLong(): number;
          nextLong(p0: number): number;
          nextLong(p0: number, p1: number): number;
          nextGaussian(): number;
          nextGaussian(p0: number, p1: number): number;
          nextExponential(): number;
        }
        const RandomGenerator$LeapableGenerator: {
          of(p0: string): java.util.random.RandomGenerator$LeapableGenerator;
        }
        interface RandomGenerator$LeapableGenerator extends java.util.random.RandomGenerator$JumpableGenerator { 
          leap(): void;
          leapDistance(): number;
          leaps(): java.util.stream.Stream<java.util.random.RandomGenerator$JumpableGenerator>;
          leaps(p0: number): java.util.stream.Stream<java.util.random.RandomGenerator$JumpableGenerator>;
          copyAndLeap(): java.util.random.RandomGenerator$JumpableGenerator;
        }
        const RandomGenerator$JumpableGenerator: {
          of(p0: string): java.util.random.RandomGenerator$JumpableGenerator;
        }
        interface RandomGenerator$JumpableGenerator extends java.util.random.RandomGenerator$StreamableGenerator { 
          copy(): java.util.random.RandomGenerator$JumpableGenerator;
          jump(): void;
          jumpDistance(): number;
          jumps(): java.util.stream.Stream<java.util.random.RandomGenerator>;
          jumps(p0: number): java.util.stream.Stream<java.util.random.RandomGenerator>;
          copyAndJump(): java.util.random.RandomGenerator;
        }
        const RandomGenerator$StreamableGenerator: {
          of(p0: string): java.util.random.RandomGenerator$StreamableGenerator;
        }
        interface RandomGenerator$StreamableGenerator extends java.util.random.RandomGenerator { 
          rngs(): java.util.stream.Stream<java.util.random.RandomGenerator>;
          rngs(p0: number): java.util.stream.Stream<java.util.random.RandomGenerator>;
        }
        const RandomGenerator$ArbitrarilyJumpableGenerator: {
          of(p0: string): java.util.random.RandomGenerator$ArbitrarilyJumpableGenerator;
        }
        interface RandomGenerator$ArbitrarilyJumpableGenerator extends java.util.random.RandomGenerator$LeapableGenerator { 
          jump(p0: number): void;
          jumps(p0: number): java.util.stream.Stream<java.util.random.RandomGenerator$ArbitrarilyJumpableGenerator>;
          jumps(p0: number, p1: number): java.util.stream.Stream<java.util.random.RandomGenerator$ArbitrarilyJumpableGenerator>;
          copyAndJump(p0: number): java.util.random.RandomGenerator$ArbitrarilyJumpableGenerator;
          jumpPowerOfTwo(p0: number): void;
        }
        const RandomGenerator$SplittableGenerator: {
          of(p0: string): java.util.random.RandomGenerator$SplittableGenerator;
        }
        interface RandomGenerator$SplittableGenerator extends java.util.random.RandomGenerator$StreamableGenerator { 
          split(): java.util.random.RandomGenerator$SplittableGenerator;
          split(p0: java.util.random.RandomGenerator$SplittableGenerator): java.util.random.RandomGenerator$SplittableGenerator;
          splits(): java.util.stream.Stream<java.util.random.RandomGenerator$SplittableGenerator>;
          splits(p0: number): java.util.stream.Stream<java.util.random.RandomGenerator$SplittableGenerator>;
          splits(p0: java.util.random.RandomGenerator$SplittableGenerator): java.util.stream.Stream<java.util.random.RandomGenerator$SplittableGenerator>;
          splits(p0: number, p1: java.util.random.RandomGenerator$SplittableGenerator): java.util.stream.Stream<java.util.random.RandomGenerator$SplittableGenerator>;
        }
      }
      namespace zip {
        const ZipFile: {
          OPEN_READ: number;
          OPEN_DELETE: number;
          new(p0: string): java.util.zip.ZipFile;
          new(p0: java.io.File, p1: number): java.util.zip.ZipFile;
          new(p0: java.io.File): java.util.zip.ZipFile;
          new(p0: java.io.File, p1: number, p2: java.nio.charset.Charset): java.util.zip.ZipFile;
          new(p0: string, p1: java.nio.charset.Charset): java.util.zip.ZipFile;
          new(p0: java.io.File, p1: java.nio.charset.Charset): java.util.zip.ZipFile;
        }
        interface ZipFile extends java.io.Closeable { 
          getComment(): string;
          getEntry(p0: string): java.util.zip.ZipEntry;
          getInputStream(p0: java.util.zip.ZipEntry): java.io.InputStream;
          getName(): string;
          entries(): java.util.Enumeration<java.util.zip.ZipEntry>;
          stream(): java.util.stream.Stream<java.util.zip.ZipEntry>;
          size(): number;
        }
        const ZipEntry: {
          STORED: number;
          DEFLATED: number;
          new(p0: string): java.util.zip.ZipEntry;
          new(p0: java.util.zip.ZipEntry): java.util.zip.ZipEntry;
        }
        interface ZipEntry extends kotlin.Cloneable { 
          getName(): string;
          setTime(p0: number): void;
          getTime(): number;
          setTimeLocal(p0: java.time.LocalDateTime): void;
          getTimeLocal(): java.time.LocalDateTime;
          setLastModifiedTime(p0: java.nio.file.attribute.FileTime): java.util.zip.ZipEntry;
          getLastModifiedTime(): java.nio.file.attribute.FileTime;
          setLastAccessTime(p0: java.nio.file.attribute.FileTime): java.util.zip.ZipEntry;
          getLastAccessTime(): java.nio.file.attribute.FileTime;
          setCreationTime(p0: java.nio.file.attribute.FileTime): java.util.zip.ZipEntry;
          getCreationTime(): java.nio.file.attribute.FileTime;
          setSize(p0: number): void;
          getSize(): number;
          getCompressedSize(): number;
          setCompressedSize(p0: number): void;
          setCrc(p0: number): void;
          getCrc(): number;
          setMethod(p0: number): void;
          getMethod(): number;
          setExtra(p0: Array<number>): void;
          getExtra(): Array<number>;
          setComment(p0: string): void;
          getComment(): string;
          isDirectory(): boolean;
        }
      }
      const Optional: {
        empty<T>(): java.util.Optional<T>;
        of<T>(p0: T): java.util.Optional<T>;
        ofNullable<T>(p0: T): java.util.Optional<T>;
      }
      interface Optional<T> { 
        get(): T;
        isPresent(): boolean;
        isEmpty(): boolean;
        ifPresent(p0: unknown): void;
        ifPresentOrElse(p0: unknown, p1: java.lang.Runnable): void;
        filter(p0: unknown): java.util.Optional<T>;
        map<U>(p0: unknown): java.util.Optional<U>;
        flatMap<U>(p0: unknown): java.util.Optional<U>;
        or(p0: unknown): java.util.Optional<T>;
        stream(): java.util.stream.Stream<T>;
        orElse(p0: T): T;
        orElseGet(p0: unknown): T;
        orElseThrow(): T;
        orElseThrow<X>(p0: unknown): T;
      }
      const Spliterator: {
        ORDERED: number;
        DISTINCT: number;
        SORTED: number;
        SIZED: number;
        NONNULL: number;
        IMMUTABLE: number;
        CONCURRENT: number;
        SUBSIZED: number;
      }
      interface Spliterator<T> { 
        tryAdvance(p0: unknown): boolean;
        forEachRemaining(p0: unknown): void;
        trySplit(): java.util.Spliterator<T>;
        estimateSize(): number;
        getExactSizeIfKnown(): number;
        characteristics(): number;
        hasCharacteristics(p0: number): boolean;
        getComparator(): java.util.Comparator<T>;
      }
      interface Spliterator$OfDouble extends java.util.Spliterator$OfPrimitive<number, unknown, java.util.Spliterator$OfDouble> { 
      }
      interface Spliterator$OfPrimitive<T, T_CONS, T_SPLITR> extends java.util.Spliterator<T> { 
        tryAdvance(p0: T_CONS): boolean;
        forEachRemaining(p0: T_CONS): void;
      }
      interface Spliterator$OfLong extends java.util.Spliterator$OfPrimitive<number, unknown, java.util.Spliterator$OfLong> { 
      }
      interface Spliterator$OfInt extends java.util.Spliterator$OfPrimitive<number, unknown, java.util.Spliterator$OfInt> { 
      }
      const Comparator: {
        reverseOrder<T>(): java.util.Comparator<T>;
        naturalOrder<T>(): java.util.Comparator<T>;
        nullsFirst<T>(p0: java.util.Comparator<T>): java.util.Comparator<T>;
        nullsLast<T>(p0: java.util.Comparator<T>): java.util.Comparator<T>;
        comparing<T, U>(p0: unknown, p1: java.util.Comparator<U>): java.util.Comparator<T>;
        comparing<T, U>(p0: unknown): java.util.Comparator<T>;
        comparingInt<T>(p0: unknown): java.util.Comparator<T>;
        comparingLong<T>(p0: unknown): java.util.Comparator<T>;
        comparingDouble<T>(p0: unknown): java.util.Comparator<T>;
      }
      interface Comparator<T> { 
        compare(p0: T, p1: T): number;
        reversed(): java.util.Comparator<T>;
        thenComparing(p0: java.util.Comparator<T>): java.util.Comparator<T>;
        thenComparing<U>(p0: unknown, p1: java.util.Comparator<U>): java.util.Comparator<T>;
        thenComparing<U>(p0: unknown): java.util.Comparator<T>;
        thenComparingInt(p0: unknown): java.util.Comparator<T>;
        thenComparingLong(p0: unknown): java.util.Comparator<T>;
        thenComparingDouble(p0: unknown): java.util.Comparator<T>;
        (p0: T, p1: T): number;
      }
      interface PrimitiveIterator$OfInt extends java.util.PrimitiveIterator<number, unknown> { 
        nextInt(): number;
      }
      interface PrimitiveIterator<T, T_CONS> extends kotlin.collections.MutableIterator<T> { 
        forEachRemaining(p0: T_CONS): void;
      }
      interface PrimitiveIterator$OfDouble extends java.util.PrimitiveIterator<number, unknown> { 
        nextDouble(): number;
      }
      interface PrimitiveIterator$OfLong extends java.util.PrimitiveIterator<number, unknown> { 
        nextLong(): number;
      }
      const OptionalDouble: {
        empty(): java.util.OptionalDouble;
        of(p0: number): java.util.OptionalDouble;
      }
      interface OptionalDouble { 
        getAsDouble(): number;
        isPresent(): boolean;
        isEmpty(): boolean;
        ifPresent(p0: unknown): void;
        ifPresentOrElse(p0: unknown, p1: java.lang.Runnable): void;
        stream(): java.util.stream.DoubleStream;
        orElse(p0: number): number;
        orElseGet(p0: unknown): number;
        orElseThrow(): number;
        orElseThrow<X>(p0: unknown): number;
      }
      const DoubleSummaryStatistics: {
        new(): java.util.DoubleSummaryStatistics;
        new(p0: number, p1: number, p2: number, p3: number): java.util.DoubleSummaryStatistics;
      }
      interface DoubleSummaryStatistics { 
        combine(p0: java.util.DoubleSummaryStatistics): void;
        getCount(): number;
        getSum(): number;
        getMin(): number;
        getMax(): number;
        getAverage(): number;
      }
      const OptionalLong: {
        empty(): java.util.OptionalLong;
        of(p0: number): java.util.OptionalLong;
      }
      interface OptionalLong { 
        getAsLong(): number;
        isPresent(): boolean;
        isEmpty(): boolean;
        ifPresent(p0: unknown): void;
        ifPresentOrElse(p0: unknown, p1: java.lang.Runnable): void;
        stream(): java.util.stream.LongStream;
        orElse(p0: number): number;
        orElseGet(p0: unknown): number;
        orElseThrow(): number;
        orElseThrow<X>(p0: unknown): number;
      }
      const LongSummaryStatistics: {
        new(): java.util.LongSummaryStatistics;
        new(p0: number, p1: number, p2: number, p3: number): java.util.LongSummaryStatistics;
      }
      interface LongSummaryStatistics { 
        combine(p0: java.util.LongSummaryStatistics): void;
        getCount(): number;
        getSum(): number;
        getMin(): number;
        getMax(): number;
        getAverage(): number;
      }
      interface Enumeration<E> { 
        hasMoreElements(): boolean;
        nextElement(): E;
        asIterator(): kotlin.collections.MutableIterator<E>;
      }
      const Locale: {
        FilteringMode: typeof java.util.Locale$FilteringMode;
        Builder: typeof java.util.Locale$Builder;
        Category: typeof java.util.Locale$Category;
        LanguageRange: typeof java.util.Locale$LanguageRange;
        IsoCountryCode: typeof java.util.Locale$IsoCountryCode;
        ENGLISH: java.util.Locale;
        FRENCH: java.util.Locale;
        GERMAN: java.util.Locale;
        ITALIAN: java.util.Locale;
        JAPANESE: java.util.Locale;
        KOREAN: java.util.Locale;
        CHINESE: java.util.Locale;
        SIMPLIFIED_CHINESE: java.util.Locale;
        TRADITIONAL_CHINESE: java.util.Locale;
        FRANCE: java.util.Locale;
        GERMANY: java.util.Locale;
        ITALY: java.util.Locale;
        JAPAN: java.util.Locale;
        KOREA: java.util.Locale;
        UK: java.util.Locale;
        US: java.util.Locale;
        CANADA: java.util.Locale;
        CANADA_FRENCH: java.util.Locale;
        ROOT: java.util.Locale;
        CHINA: java.util.Locale;
        PRC: java.util.Locale;
        TAIWAN: java.util.Locale;
        PRIVATE_USE_EXTENSION: number;
        UNICODE_LOCALE_EXTENSION: number;
        of(p0: string, p1: string, p2: string): java.util.Locale;
        of(p0: string, p1: string): java.util.Locale;
        of(p0: string): java.util.Locale;
        getDefault(): java.util.Locale;
        getDefault(p0: java.util.Locale$Category): java.util.Locale;
        setDefault(p0: java.util.Locale): void;
        setDefault(p0: java.util.Locale$Category, p1: java.util.Locale): void;
        getAvailableLocales(): Array<java.util.Locale>;
        availableLocales(): java.util.stream.Stream<java.util.Locale>;
        getISOCountries(): Array<string>;
        getISOCountries(p0: java.util.Locale$IsoCountryCode): Set<string>;
        getISOLanguages(): Array<string>;
        caseFoldLanguageTag(p0: string): string;
        forLanguageTag(p0: string): java.util.Locale;
        filter(p0: Array<java.util.Locale$LanguageRange>, p1: Array<java.util.Locale>, p2: java.util.Locale$FilteringMode): Array<java.util.Locale>;
        filter(p0: Array<java.util.Locale$LanguageRange>, p1: Array<java.util.Locale>): Array<java.util.Locale>;
        filterTags(p0: Array<java.util.Locale$LanguageRange>, p1: Array<string>, p2: java.util.Locale$FilteringMode): Array<string>;
        filterTags(p0: Array<java.util.Locale$LanguageRange>, p1: Array<string>): Array<string>;
        lookup(p0: Array<java.util.Locale$LanguageRange>, p1: Array<java.util.Locale>): java.util.Locale;
        lookupTag(p0: Array<java.util.Locale$LanguageRange>, p1: Array<string>): string;
        new(p0: string, p1: string, p2: string): java.util.Locale;
        new(p0: string, p1: string): java.util.Locale;
        new(p0: string): java.util.Locale;
      }
      interface Locale extends kotlin.Cloneable, java.io.Serializable { 
        getLanguage(): string;
        getScript(): string;
        getCountry(): string;
        getVariant(): string;
        hasExtensions(): boolean;
        stripExtensions(): java.util.Locale;
        getExtension(p0: number): string;
        getExtensionKeys(): Set<number>;
        getUnicodeLocaleAttributes(): Set<string>;
        getUnicodeLocaleType(p0: string): string;
        getUnicodeLocaleKeys(): Set<string>;
        toLanguageTag(): string;
        getISO3Language(): string;
        getISO3Country(): string;
        getDisplayLanguage(): string;
        getDisplayLanguage(p0: java.util.Locale): string;
        getDisplayScript(): string;
        getDisplayScript(p0: java.util.Locale): string;
        getDisplayCountry(): string;
        getDisplayCountry(p0: java.util.Locale): string;
        getDisplayVariant(): string;
        getDisplayVariant(p0: java.util.Locale): string;
        getDisplayName(): string;
        getDisplayName(p0: java.util.Locale): string;
      }
      const Locale$FilteringMode: {
        AUTOSELECT_FILTERING: java.util.Locale$FilteringMode;
        EXTENDED_FILTERING: java.util.Locale$FilteringMode;
        IGNORE_EXTENDED_RANGES: java.util.Locale$FilteringMode;
        MAP_EXTENDED_RANGES: java.util.Locale$FilteringMode;
        REJECT_EXTENDED_RANGES: java.util.Locale$FilteringMode;
        valueOf(value: string): java.util.Locale$FilteringMode;
        values(): Array<java.util.Locale$FilteringMode>;
      }
      interface Locale$FilteringMode extends kotlin.Enum<java.util.Locale$FilteringMode> { 
      }
      const Locale$Builder: {
        new(): java.util.Locale$Builder;
      }
      interface Locale$Builder { 
        setLocale(p0: java.util.Locale): java.util.Locale$Builder;
        setLanguageTag(p0: string): java.util.Locale$Builder;
        setLanguage(p0: string): java.util.Locale$Builder;
        setScript(p0: string): java.util.Locale$Builder;
        setRegion(p0: string): java.util.Locale$Builder;
        setVariant(p0: string): java.util.Locale$Builder;
        setExtension(p0: number, p1: string): java.util.Locale$Builder;
        setUnicodeLocaleKeyword(p0: string, p1: string): java.util.Locale$Builder;
        addUnicodeLocaleAttribute(p0: string): java.util.Locale$Builder;
        removeUnicodeLocaleAttribute(p0: string): java.util.Locale$Builder;
        clear(): java.util.Locale$Builder;
        clearExtensions(): java.util.Locale$Builder;
        build(): java.util.Locale;
      }
      const Locale$Category: {
        DISPLAY: java.util.Locale$Category;
        FORMAT: java.util.Locale$Category;
        valueOf(value: string): java.util.Locale$Category;
        values(): Array<java.util.Locale$Category>;
      }
      interface Locale$Category extends kotlin.Enum<java.util.Locale$Category> { 
      }
      const Locale$LanguageRange: {
        MAX_WEIGHT: number;
        MIN_WEIGHT: number;
        parse(p0: string): Array<java.util.Locale$LanguageRange>;
        parse(p0: string, p1: Map<string, Array<string>>): Array<java.util.Locale$LanguageRange>;
        mapEquivalents(p0: Array<java.util.Locale$LanguageRange>, p1: Map<string, Array<string>>): Array<java.util.Locale$LanguageRange>;
        new(p0: string): java.util.Locale$LanguageRange;
        new(p0: string, p1: number): java.util.Locale$LanguageRange;
      }
      interface Locale$LanguageRange { 
        getRange(): string;
        getWeight(): number;
      }
      const Locale$IsoCountryCode: {
        PART1_ALPHA2: java.util.Locale$IsoCountryCode;
        PART1_ALPHA3: java.util.Locale$IsoCountryCode;
        PART3: java.util.Locale$IsoCountryCode;
        valueOf(value: string): java.util.Locale$IsoCountryCode;
        values(): Array<java.util.Locale$IsoCountryCode>;
      }
      interface Locale$IsoCountryCode extends kotlin.Enum<java.util.Locale$IsoCountryCode> { 
      }
      interface SortedMap<K, V> extends java.util.SequencedMap<K, V> { 
        comparator(): java.util.Comparator<K>;
        subMap(p0: K, p1: K): java.util.SortedMap<K, V>;
        headMap(p0: K): java.util.SortedMap<K, V>;
        tailMap(p0: K): java.util.SortedMap<K, V>;
        firstKey(): K;
        lastKey(): K;
      }
      interface SequencedMap<K, V> extends Map<K, V> { 
        reversed(): java.util.SequencedMap<K, V>;
        firstEntry(): kotlin.collections.MutableMap$MutableEntry<K, V>;
        lastEntry(): kotlin.collections.MutableMap$MutableEntry<K, V>;
        pollFirstEntry(): kotlin.collections.MutableMap$MutableEntry<K, V>;
        pollLastEntry(): kotlin.collections.MutableMap$MutableEntry<K, V>;
        putFirst(p0: K, p1: V): V;
        putLast(p0: K, p1: V): V;
        sequencedKeySet(): java.util.SequencedSet<K>;
        sequencedValues(): java.util.SequencedCollection<V>;
        sequencedEntrySet(): java.util.SequencedSet<kotlin.collections.MutableMap$MutableEntry<K, V>>;
      }
      interface SequencedSet<E> extends java.util.SequencedCollection<E>, Set<E> { 
      }
      interface SequencedCollection<E> extends Array<E> { 
        reversed(): java.util.SequencedCollection<E>;
        addFirst(p0: E): void;
        addLast(p0: E): void;
        getFirst(): E;
        getLast(): E;
        removeFirst(): E;
        removeLast(): E;
      }
      const OptionalInt: {
        empty(): java.util.OptionalInt;
        of(p0: number): java.util.OptionalInt;
      }
      interface OptionalInt { 
        getAsInt(): number;
        isPresent(): boolean;
        isEmpty(): boolean;
        ifPresent(p0: unknown): void;
        ifPresentOrElse(p0: unknown, p1: java.lang.Runnable): void;
        stream(): java.util.stream.IntStream;
        orElse(p0: number): number;
        orElseGet(p0: unknown): number;
        orElseThrow(): number;
        orElseThrow<X>(p0: unknown): number;
      }
      const IntSummaryStatistics: {
        new(): java.util.IntSummaryStatistics;
        new(p0: number, p1: number, p2: number, p3: number): java.util.IntSummaryStatistics;
      }
      interface IntSummaryStatistics { 
        combine(p0: java.util.IntSummaryStatistics): void;
        getCount(): number;
        getSum(): number;
        getMin(): number;
        getMax(): number;
        getAverage(): number;
      }
      const ArrayList: {
        new<E>(p0: number): java.util.ArrayList<E>;
        new<E>(): java.util.ArrayList<E>;
        new<E>(p0: Array<E>): java.util.ArrayList<E>;
      }
      interface ArrayList<E> extends java.util.AbstractList<E>, java.util.RandomAccess, kotlin.Cloneable, java.io.Serializable, Array<E> { 
        trimToSize(): void;
        ensureCapacity(p0: number): void;
      }
      interface AbstractList<E> extends java.util.AbstractCollection<E>, Array<E> { 
      }
      interface AbstractCollection<E> extends Array<E> { 
        toArray(): Array<any>;
        toArray<T>(p0: Array<T>): Array<T>;
      }
      interface RandomAccess { 
      }
      const HashMap: {
        newHashMap<K, V>(p0: number): java.util.HashMap<K, V>;
        new<K, V>(p0: number, p1: number): java.util.HashMap<K, V>;
        new<K, V>(p0: number): java.util.HashMap<K, V>;
        new<K, V>(): java.util.HashMap<K, V>;
        new<K, V>(p0: Map<K, V>): java.util.HashMap<K, V>;
      }
      interface HashMap<K, V> extends java.util.AbstractMap<K, V>, kotlin.Cloneable, java.io.Serializable, Map<K, V> { 
      }
      const AbstractMap: {
        SimpleImmutableEntry: typeof java.util.AbstractMap$SimpleImmutableEntry;
        SimpleEntry: typeof java.util.AbstractMap$SimpleEntry;
      }
      interface AbstractMap<K, V> extends Map<K, V> { 
      }
      const AbstractMap$SimpleImmutableEntry: {
        new<K, V>(p0: K, p1: V): java.util.AbstractMap$SimpleImmutableEntry<K, V>;
        new<K, V>(p0: kotlin.collections.MutableMap$MutableEntry<K, V>): java.util.AbstractMap$SimpleImmutableEntry<K, V>;
      }
      interface AbstractMap$SimpleImmutableEntry<K, V> extends kotlin.collections.MutableMap$MutableEntry<K, V>, java.io.Serializable { 
      }
      const AbstractMap$SimpleEntry: {
        new<K, V>(p0: K, p1: V): java.util.AbstractMap$SimpleEntry<K, V>;
        new<K, V>(p0: kotlin.collections.MutableMap$MutableEntry<K, V>): java.util.AbstractMap$SimpleEntry<K, V>;
      }
      interface AbstractMap$SimpleEntry<K, V> extends kotlin.collections.MutableMap$MutableEntry<K, V>, java.io.Serializable { 
      }
      const Currency: {
        getInstance(p0: string): java.util.Currency;
        getInstance(p0: java.util.Locale): java.util.Currency;
        getAvailableCurrencies(): Set<java.util.Currency>;
      }
      interface Currency extends java.io.Serializable { 
        getCurrencyCode(): string;
        getSymbol(): string;
        getSymbol(p0: java.util.Locale): string;
        getDefaultFractionDigits(): number;
        getNumericCode(): number;
        getNumericCodeAsString(): string;
        getDisplayName(): string;
        getDisplayName(p0: java.util.Locale): string;
      }
      const EnumSet: {
        noneOf<E>(p0: java.lang.Class<E>): java.util.EnumSet<E>;
        allOf<E>(p0: java.lang.Class<E>): java.util.EnumSet<E>;
        copyOf<E>(p0: java.util.EnumSet<E>): java.util.EnumSet<E>;
        copyOf<E>(p0: Array<E>): java.util.EnumSet<E>;
        complementOf<E>(p0: java.util.EnumSet<E>): java.util.EnumSet<E>;
        of<E>(p0: E): java.util.EnumSet<E>;
        of<E>(p0: E, p1: E): java.util.EnumSet<E>;
        of<E>(p0: E, p1: E, p2: E): java.util.EnumSet<E>;
        of<E>(p0: E, p1: E, p2: E, p3: E): java.util.EnumSet<E>;
        of<E>(p0: E, p1: E, p2: E, p3: E, p4: E): java.util.EnumSet<E>;
        of<E>(p0: E, p1: E): java.util.EnumSet<E>;
        range<E>(p0: E, p1: E): java.util.EnumSet<E>;
      }
      interface EnumSet<E> extends java.util.AbstractSet<E>, kotlin.Cloneable, java.io.Serializable { 
      }
      interface AbstractSet<E> extends java.util.AbstractCollection<E>, Set<E> { 
      }
      const BitSet: {
        valueOf(p0: Array<number>): java.util.BitSet;
        valueOf(p0: java.nio.LongBuffer): java.util.BitSet;
        valueOf(p0: Array<number>): java.util.BitSet;
        valueOf(p0: java.nio.ByteBuffer): java.util.BitSet;
        new(): java.util.BitSet;
        new(p0: number): java.util.BitSet;
      }
      interface BitSet extends kotlin.Cloneable, java.io.Serializable { 
        toByteArray(): Array<number>;
        toLongArray(): Array<number>;
        flip(p0: number): void;
        flip(p0: number, p1: number): void;
        set(p0: number): void;
        set(p0: number, p1: boolean): void;
        set(p0: number, p1: number): void;
        set(p0: number, p1: number, p2: boolean): void;
        clear(p0: number): void;
        clear(p0: number, p1: number): void;
        clear(): void;
        get(p0: number): boolean;
        get(p0: number, p1: number): java.util.BitSet;
        nextSetBit(p0: number): number;
        nextClearBit(p0: number): number;
        previousSetBit(p0: number): number;
        previousClearBit(p0: number): number;
        length(): number;
        isEmpty(): boolean;
        intersects(p0: java.util.BitSet): boolean;
        cardinality(): number;
        and(p0: java.util.BitSet): void;
        or(p0: java.util.BitSet): void;
        xor(p0: java.util.BitSet): void;
        andNot(p0: java.util.BitSet): void;
        size(): number;
        stream(): java.util.stream.IntStream;
      }
      const UUID: {
        randomUUID(): java.util.UUID;
        nameUUIDFromBytes(p0: Array<number>): java.util.UUID;
        fromString(p0: string): java.util.UUID;
        new(p0: number, p1: number): java.util.UUID;
      }
      interface UUID extends java.io.Serializable, kotlin.Comparable<java.util.UUID> { 
        getLeastSignificantBits(): number;
        getMostSignificantBits(): number;
        version(): number;
        variant(): number;
        timestamp(): number;
        clockSequence(): number;
        node(): number;
      }
      const Date: {
        UTC(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
        parse(p0: string): number;
        from(p0: java.time.Instant): java.util.Date;
        new(): java.util.Date;
        new(p0: number): java.util.Date;
        new(p0: number, p1: number, p2: number): java.util.Date;
        new(p0: number, p1: number, p2: number, p3: number, p4: number): java.util.Date;
        new(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): java.util.Date;
        new(p0: string): java.util.Date;
      }
      interface Date extends java.io.Serializable, kotlin.Cloneable, kotlin.Comparable<java.util.Date> { 
        getYear(): number;
        setYear(p0: number): void;
        getMonth(): number;
        setMonth(p0: number): void;
        getDate(): number;
        setDate(p0: number): void;
        getDay(): number;
        getHours(): number;
        setHours(p0: number): void;
        getMinutes(): number;
        setMinutes(p0: number): void;
        getSeconds(): number;
        setSeconds(p0: number): void;
        getTime(): number;
        setTime(p0: number): void;
        before(p0: java.util.Date): boolean;
        after(p0: java.util.Date): boolean;
        toLocaleString(): string;
        toGMTString(): string;
        getTimezoneOffset(): number;
        toInstant(): java.time.Instant;
      }
      const Random: {
        from(p0: java.util.random.RandomGenerator): java.util.Random;
        new(): java.util.Random;
        new(p0: number): java.util.Random;
      }
      interface Random extends java.util.random.RandomGenerator, java.io.Serializable { 
        setSeed(p0: number): void;
      }
      const Calendar: {
        Builder: typeof java.util.Calendar$Builder;
        ERA: number;
        YEAR: number;
        MONTH: number;
        WEEK_OF_YEAR: number;
        WEEK_OF_MONTH: number;
        DATE: number;
        DAY_OF_MONTH: number;
        DAY_OF_YEAR: number;
        DAY_OF_WEEK: number;
        DAY_OF_WEEK_IN_MONTH: number;
        AM_PM: number;
        HOUR: number;
        HOUR_OF_DAY: number;
        MINUTE: number;
        SECOND: number;
        MILLISECOND: number;
        ZONE_OFFSET: number;
        DST_OFFSET: number;
        FIELD_COUNT: number;
        SUNDAY: number;
        MONDAY: number;
        TUESDAY: number;
        WEDNESDAY: number;
        THURSDAY: number;
        FRIDAY: number;
        SATURDAY: number;
        JANUARY: number;
        FEBRUARY: number;
        MARCH: number;
        APRIL: number;
        MAY: number;
        JUNE: number;
        JULY: number;
        AUGUST: number;
        SEPTEMBER: number;
        OCTOBER: number;
        NOVEMBER: number;
        DECEMBER: number;
        UNDECIMBER: number;
        AM: number;
        PM: number;
        ALL_STYLES: number;
        SHORT: number;
        LONG: number;
        NARROW_FORMAT: number;
        NARROW_STANDALONE: number;
        SHORT_FORMAT: number;
        LONG_FORMAT: number;
        SHORT_STANDALONE: number;
        LONG_STANDALONE: number;
        getInstance(): java.util.Calendar;
        getInstance(p0: java.util.TimeZone): java.util.Calendar;
        getInstance(p0: java.util.Locale): java.util.Calendar;
        getInstance(p0: java.util.TimeZone, p1: java.util.Locale): java.util.Calendar;
        getAvailableLocales(): Array<java.util.Locale>;
        getAvailableCalendarTypes(): Set<string>;
      }
      interface Calendar extends java.io.Serializable, kotlin.Cloneable, kotlin.Comparable<java.util.Calendar> { 
        getTime(): java.util.Date;
        setTime(p0: java.util.Date): void;
        getTimeInMillis(): number;
        setTimeInMillis(p0: number): void;
        get(p0: number): number;
        set(p0: number, p1: number): void;
        set(p0: number, p1: number, p2: number): void;
        set(p0: number, p1: number, p2: number, p3: number, p4: number): void;
        set(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): void;
        clear(): void;
        clear(p0: number): void;
        isSet(p0: number): boolean;
        getDisplayName(p0: number, p1: number, p2: java.util.Locale): string;
        getDisplayNames(p0: number, p1: number, p2: java.util.Locale): Map<string, number>;
        getCalendarType(): string;
        before(p0: any): boolean;
        after(p0: any): boolean;
        add(p0: number, p1: number): void;
        roll(p0: number, p1: boolean): void;
        roll(p0: number, p1: number): void;
        setTimeZone(p0: java.util.TimeZone): void;
        getTimeZone(): java.util.TimeZone;
        setLenient(p0: boolean): void;
        isLenient(): boolean;
        setFirstDayOfWeek(p0: number): void;
        getFirstDayOfWeek(): number;
        setMinimalDaysInFirstWeek(p0: number): void;
        getMinimalDaysInFirstWeek(): number;
        isWeekDateSupported(): boolean;
        getWeekYear(): number;
        setWeekDate(p0: number, p1: number, p2: number): void;
        getWeeksInWeekYear(): number;
        getMinimum(p0: number): number;
        getMaximum(p0: number): number;
        getGreatestMinimum(p0: number): number;
        getLeastMaximum(p0: number): number;
        getActualMinimum(p0: number): number;
        getActualMaximum(p0: number): number;
        toInstant(): java.time.Instant;
      }
      const Calendar$Builder: {
        new(): java.util.Calendar$Builder;
      }
      interface Calendar$Builder { 
        setInstant(p0: number): java.util.Calendar$Builder;
        setInstant(p0: java.util.Date): java.util.Calendar$Builder;
        set(p0: number, p1: number): java.util.Calendar$Builder;
        setFields(p0: number): java.util.Calendar$Builder;
        setDate(p0: number, p1: number, p2: number): java.util.Calendar$Builder;
        setTimeOfDay(p0: number, p1: number, p2: number): java.util.Calendar$Builder;
        setTimeOfDay(p0: number, p1: number, p2: number, p3: number): java.util.Calendar$Builder;
        setWeekDate(p0: number, p1: number, p2: number): java.util.Calendar$Builder;
        setTimeZone(p0: java.util.TimeZone): java.util.Calendar$Builder;
        setLenient(p0: boolean): java.util.Calendar$Builder;
        setCalendarType(p0: string): java.util.Calendar$Builder;
        setLocale(p0: java.util.Locale): java.util.Calendar$Builder;
        setWeekDefinition(p0: number, p1: number): java.util.Calendar$Builder;
        build(): java.util.Calendar;
      }
      const TimeZone: {
        SHORT: number;
        LONG: number;
        getTimeZone(p0: string): java.util.TimeZone;
        getTimeZone(p0: java.time.ZoneId): java.util.TimeZone;
        getAvailableIDs(p0: number): Array<string>;
        getAvailableIDs(): Array<string>;
        getDefault(): java.util.TimeZone;
        setDefault(p0: java.util.TimeZone): void;
        new(): java.util.TimeZone;
      }
      interface TimeZone extends java.io.Serializable, kotlin.Cloneable { 
        getOffset(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): number;
        getOffset(p0: number): number;
        setRawOffset(p0: number): void;
        getRawOffset(): number;
        getID(): string;
        setID(p0: string): void;
        getDisplayName(): string;
        getDisplayName(p0: java.util.Locale): string;
        getDisplayName(p0: boolean, p1: number): string;
        getDisplayName(p0: boolean, p1: number, p2: java.util.Locale): string;
        getDSTSavings(): number;
        useDaylightTime(): boolean;
        observesDaylightTime(): boolean;
        inDaylightTime(p0: java.util.Date): boolean;
        toZoneId(): java.time.ZoneId;
        hasSameRules(p0: java.util.TimeZone): boolean;
      }
      interface EventListener { 
      }
      const Properties: {
        new(): java.util.Properties;
        new(p0: number): java.util.Properties;
        new(p0: java.util.Properties): java.util.Properties;
      }
      interface Properties extends java.util.Hashtable<any, any> { 
        setProperty(p0: string, p1: string): any;
        load(p0: java.io.Reader): void;
        load(p0: java.io.InputStream): void;
        save(p0: java.io.OutputStream, p1: string): void;
        store(p0: java.io.Writer, p1: string): void;
        store(p0: java.io.OutputStream, p1: string): void;
        loadFromXML(p0: java.io.InputStream): void;
        storeToXML(p0: java.io.OutputStream, p1: string): void;
        storeToXML(p0: java.io.OutputStream, p1: string, p2: string): void;
        storeToXML(p0: java.io.OutputStream, p1: string, p2: java.nio.charset.Charset): void;
        getProperty(p0: string): string;
        getProperty(p0: string, p1: string): string;
        propertyNames(): java.util.Enumeration<any>;
        stringPropertyNames(): Set<string>;
        list(p0: java.io.PrintStream): void;
        list(p0: java.io.PrintWriter): void;
      }
      const Hashtable: {
        new<K, V>(p0: number, p1: number): java.util.Hashtable<K, V>;
        new<K, V>(p0: number): java.util.Hashtable<K, V>;
        new<K, V>(): java.util.Hashtable<K, V>;
        new<K, V>(p0: Map<K, V>): java.util.Hashtable<K, V>;
      }
      interface Hashtable<K, V> extends java.util.Dictionary<K, V>, Map<K, V>, kotlin.Cloneable, java.io.Serializable { 
        contains(p0: any): boolean;
      }
      const Dictionary: {
        new<K, V>(): java.util.Dictionary<K, V>;
      }
      interface Dictionary<K, V> { 
        size(): number;
        isEmpty(): boolean;
        keys(): java.util.Enumeration<K>;
        elements(): java.util.Enumeration<V>;
        get(p0: any): V;
        put(p0: K, p1: V): V;
        remove(p0: any): V;
      }
      interface Queue<E> extends Array<E> { 
        remove(): E;
        offer(p0: E): boolean;
        poll(): E;
        element(): E;
        peek(): E;
      }
      interface SortedSet<E> extends Set<E>, java.util.SequencedSet<E> { 
        comparator(): java.util.Comparator<E>;
        subSet(p0: E, p1: E): java.util.SortedSet<E>;
        headSet(p0: E): java.util.SortedSet<E>;
        tailSet(p0: E): java.util.SortedSet<E>;
        first(): E;
        last(): E;
      }
      interface Deque<E> extends java.util.Queue<E>, java.util.SequencedCollection<E> { 
        offerFirst(p0: E): boolean;
        offerLast(p0: E): boolean;
        pollFirst(): E;
        pollLast(): E;
        peekFirst(): E;
        peekLast(): E;
        removeFirstOccurrence(p0: any): boolean;
        removeLastOccurrence(p0: any): boolean;
        push(p0: E): void;
        pop(): E;
        descendingIterator(): kotlin.collections.MutableIterator<E>;
      }
      const Observable: {
        new(): java.util.Observable;
      }
      interface Observable { 
        addObserver(p0: java.util.Observer): void;
        deleteObserver(p0: java.util.Observer): void;
        notifyObservers(): void;
        notifyObservers(p0: any): void;
        deleteObservers(): void;
        hasChanged(): boolean;
        countObservers(): number;
      }
      interface Observer { 
        update(p0: java.util.Observable, p1: any): void;
      }
      const EventObject: {
        new(p0: any): java.util.EventObject;
      }
      interface EventObject extends java.io.Serializable { 
        getSource(): any;
      }
      const Vector: {
        new<E>(p0: number, p1: number): java.util.Vector<E>;
        new<E>(p0: number): java.util.Vector<E>;
        new<E>(): java.util.Vector<E>;
        new<E>(p0: Array<E>): java.util.Vector<E>;
      }
      interface Vector<E> extends java.util.AbstractList<E>, Array<E>, java.util.RandomAccess, kotlin.Cloneable, java.io.Serializable { 
        indexOf(p0: any, p1: number): number;
        lastIndexOf(p0: any, p1: number): number;
        copyInto(p0: Array<any>): void;
        trimToSize(): void;
        ensureCapacity(p0: number): void;
        setSize(p0: number): void;
        capacity(): number;
        elements(): java.util.Enumeration<E>;
        elementAt(p0: number): E;
        firstElement(): E;
        lastElement(): E;
        setElementAt(p0: E, p1: number): void;
        removeElementAt(p0: number): void;
        insertElementAt(p0: E, p1: number): void;
        addElement(p0: E): void;
        removeElement(p0: any): boolean;
        removeAllElements(): void;
      }
      const ResourceBundle: {
        Control: typeof java.util.ResourceBundle$Control;
        getBundle(p0: string): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.ResourceBundle$Control): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.Locale): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.lang.Module): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.Locale, p2: java.lang.Module): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.Locale, p2: java.util.ResourceBundle$Control): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.Locale, p2: java.lang.ClassLoader): java.util.ResourceBundle;
        getBundle(p0: string, p1: java.util.Locale, p2: java.lang.ClassLoader, p3: java.util.ResourceBundle$Control): java.util.ResourceBundle;
        clearCache(): void;
        clearCache(p0: java.lang.ClassLoader): void;
        new(): java.util.ResourceBundle;
      }
      interface ResourceBundle { 
        getBaseBundleName(): string;
        getString(p0: string): string;
        getStringArray(p0: string): Array<string>;
        getObject(p0: string): any;
        getLocale(): java.util.Locale;
        getKeys(): java.util.Enumeration<string>;
        containsKey(p0: string): boolean;
        keySet(): Set<string>;
      }
      const ResourceBundle$Control: {
        FORMAT_DEFAULT: Array<string>;
        FORMAT_CLASS: Array<string>;
        FORMAT_PROPERTIES: Array<string>;
        TTL_DONT_CACHE: number;
        TTL_NO_EXPIRATION_CONTROL: number;
        getControl(p0: Array<string>): java.util.ResourceBundle$Control;
        getNoFallbackControl(p0: Array<string>): java.util.ResourceBundle$Control;
      }
      interface ResourceBundle$Control { 
        getFormats(p0: string): Array<string>;
        getCandidateLocales(p0: string, p1: java.util.Locale): Array<java.util.Locale>;
        getFallbackLocale(p0: string, p1: java.util.Locale): java.util.Locale;
        newBundle(p0: string, p1: java.util.Locale, p2: string, p3: java.lang.ClassLoader, p4: boolean): java.util.ResourceBundle;
        getTimeToLive(p0: string, p1: java.util.Locale): number;
        needsReload(p0: string, p1: java.util.Locale, p2: string, p3: java.lang.ClassLoader, p4: java.util.ResourceBundle, p5: number): boolean;
        toBundleName(p0: string, p1: java.util.Locale): string;
        toResourceName(p0: string, p1: string): string;
      }
    }
    namespace lang {
      namespace reflect {
        interface GenericDeclaration extends java.lang.reflect.AnnotatedElement { 
          getTypeParameters(): Array<unknown>;
        }
        interface AnnotatedElement { 
          isAnnotationPresent(p0: java.lang.Class<kotlin.Annotation>): boolean;
          getAnnotation<T>(p0: java.lang.Class<T>): T;
          getAnnotations(): Array<kotlin.Annotation>;
          getAnnotationsByType<T>(p0: java.lang.Class<T>): Array<T>;
          getDeclaredAnnotation<T>(p0: java.lang.Class<T>): T;
          getDeclaredAnnotationsByType<T>(p0: java.lang.Class<T>): Array<T>;
          getDeclaredAnnotations(): Array<kotlin.Annotation>;
        }
        interface Type { 
          getTypeName(): string;
        }
        interface Method extends java.lang.reflect.Executable { 
          getReturnType(): java.lang.Class<any>;
          getGenericReturnType(): java.lang.reflect.Type;
          invoke(p0: any, p1: any): any;
          isBridge(): boolean;
          isDefault(): boolean;
          getDefaultValue(): any;
        }
        interface Executable extends java.lang.reflect.AccessibleObject, java.lang.reflect.Member, java.lang.reflect.GenericDeclaration { 
          getParameterTypes(): Array<java.lang.Class<any>>;
          getParameterCount(): number;
          getGenericParameterTypes(): Array<java.lang.reflect.Type>;
          getParameters(): Array<unknown>;
          getExceptionTypes(): Array<java.lang.Class<any>>;
          getGenericExceptionTypes(): Array<java.lang.reflect.Type>;
          toGenericString(): string;
          isVarArgs(): boolean;
          getParameterAnnotations(): Array<Array<kotlin.Annotation>>;
          getAnnotatedReturnType(): java.lang.reflect.AnnotatedType;
          getAnnotatedReceiverType(): java.lang.reflect.AnnotatedType;
          getAnnotatedParameterTypes(): Array<java.lang.reflect.AnnotatedType>;
          getAnnotatedExceptionTypes(): Array<java.lang.reflect.AnnotatedType>;
        }
        const AccessibleObject: {
          setAccessible(p0: Array<java.lang.reflect.AccessibleObject>, p1: boolean): void;
        }
        interface AccessibleObject extends java.lang.reflect.AnnotatedElement { 
          setAccessible(p0: boolean): void;
          trySetAccessible(): boolean;
          isAccessible(): boolean;
          canAccess(p0: any): boolean;
        }
        const Member: {
          PUBLIC: number;
          DECLARED: number;
        }
        interface Member { 
          getDeclaringClass(): java.lang.Class<any>;
          getName(): string;
          getModifiers(): number;
          accessFlags(): Set<unknown>;
          isSynthetic(): boolean;
        }
        interface AnnotatedType extends java.lang.reflect.AnnotatedElement { 
          getAnnotatedOwnerType(): java.lang.reflect.AnnotatedType;
          getType(): java.lang.reflect.Type;
        }
        interface Constructor<T> extends java.lang.reflect.Executable { 
          newInstance(p0: any): T;
        }
        interface Field extends java.lang.reflect.AccessibleObject, java.lang.reflect.Member { 
          isEnumConstant(): boolean;
          getType(): java.lang.Class<any>;
          getGenericType(): java.lang.reflect.Type;
          toGenericString(): string;
          get(p0: any): any;
          getBoolean(p0: any): boolean;
          getByte(p0: any): number;
          getChar(p0: any): number;
          getShort(p0: any): number;
          getInt(p0: any): number;
          getLong(p0: any): number;
          getFloat(p0: any): number;
          getDouble(p0: any): number;
          set(p0: any, p1: any): void;
          setBoolean(p0: any, p1: boolean): void;
          setByte(p0: any, p1: number): void;
          setChar(p0: any, p1: number): void;
          setShort(p0: any, p1: number): void;
          setInt(p0: any, p1: number): void;
          setLong(p0: any, p1: number): void;
          setFloat(p0: any, p1: number): void;
          setDouble(p0: any, p1: number): void;
          getAnnotatedType(): java.lang.reflect.AnnotatedType;
        }
      }
      namespace invoke {
        interface TypeDescriptor$OfField<F> extends java.lang.invoke.TypeDescriptor { 
          isArray(): boolean;
          isPrimitive(): boolean;
          componentType(): F;
          arrayType(): F;
        }
        interface TypeDescriptor { 
          descriptorString(): string;
        }
        interface TypeDescriptor$OfMethod<F, M> extends java.lang.invoke.TypeDescriptor { 
          parameterCount(): number;
          parameterType(p0: number): F;
          returnType(): F;
          parameterArray(): Array<F>;
          parameterList(): Array<F>;
          changeReturnType(p0: F): M;
          changeParameterType(p0: number, p1: F): M;
          dropParameterTypes(p0: number, p1: number): M;
          insertParameterTypes(p0: number, p1: F): M;
        }
        interface MethodHandle extends java.lang.constant.Constable { 
          type(): java.lang.invoke.MethodType;
          invokeExact(p0: any): any;
          invoke(p0: any): any;
          invokeWithArguments(p0: any): any;
          invokeWithArguments(p0: Array<any>): any;
          asType(p0: java.lang.invoke.MethodType): java.lang.invoke.MethodHandle;
          asSpreader(p0: java.lang.Class<any>, p1: number): java.lang.invoke.MethodHandle;
          asSpreader(p0: number, p1: java.lang.Class<any>, p2: number): java.lang.invoke.MethodHandle;
          withVarargs(p0: boolean): java.lang.invoke.MethodHandle;
          asCollector(p0: java.lang.Class<any>, p1: number): java.lang.invoke.MethodHandle;
          asCollector(p0: number, p1: java.lang.Class<any>, p2: number): java.lang.invoke.MethodHandle;
          asVarargsCollector(p0: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          isVarargsCollector(): boolean;
          asFixedArity(): java.lang.invoke.MethodHandle;
          bindTo(p0: any): java.lang.invoke.MethodHandle;
        }
        const MethodType: {
          methodType(p0: java.lang.Class<any>, p1: Array<java.lang.Class<any>>): java.lang.invoke.MethodType;
          methodType(p0: java.lang.Class<any>, p1: Array<java.lang.Class<any>>): java.lang.invoke.MethodType;
          methodType(p0: java.lang.Class<any>, p1: java.lang.Class<any>, p2: java.lang.Class<any>): java.lang.invoke.MethodType;
          methodType(p0: java.lang.Class<any>): java.lang.invoke.MethodType;
          methodType(p0: java.lang.Class<any>, p1: java.lang.Class<any>): java.lang.invoke.MethodType;
          methodType(p0: java.lang.Class<any>, p1: java.lang.invoke.MethodType): java.lang.invoke.MethodType;
          genericMethodType(p0: number, p1: boolean): java.lang.invoke.MethodType;
          genericMethodType(p0: number): java.lang.invoke.MethodType;
          fromMethodDescriptorString(p0: string, p1: java.lang.ClassLoader): java.lang.invoke.MethodType;
        }
        interface MethodType extends java.lang.constant.Constable, java.lang.invoke.TypeDescriptor$OfMethod<java.lang.Class<any>, java.lang.invoke.MethodType>, java.io.Serializable { 
          insertParameterTypes(p0: number, p1: Array<java.lang.Class<any>>): java.lang.invoke.MethodType;
          appendParameterTypes(p0: java.lang.Class<any>): java.lang.invoke.MethodType;
          appendParameterTypes(p0: Array<java.lang.Class<any>>): java.lang.invoke.MethodType;
          hasPrimitives(): boolean;
          hasWrappers(): boolean;
          erase(): java.lang.invoke.MethodType;
          generic(): java.lang.invoke.MethodType;
          wrap(): java.lang.invoke.MethodType;
          unwrap(): java.lang.invoke.MethodType;
          lastParameterType(): java.lang.Class<any>;
          toMethodDescriptorString(): string;
        }
        const VarHandle: {
          VarHandleDesc: typeof java.lang.invoke.VarHandle$VarHandleDesc;
          AccessMode: typeof java.lang.invoke.VarHandle$AccessMode;
          fullFence(): void;
          acquireFence(): void;
          releaseFence(): void;
          loadLoadFence(): void;
          storeStoreFence(): void;
        }
        interface VarHandle extends java.lang.constant.Constable { 
          hasInvokeExactBehavior(): boolean;
          get(p0: any): any;
          set(p0: any): void;
          getVolatile(p0: any): any;
          setVolatile(p0: any): void;
          getOpaque(p0: any): any;
          setOpaque(p0: any): void;
          getAcquire(p0: any): any;
          setRelease(p0: any): void;
          compareAndSet(p0: any): boolean;
          compareAndExchange(p0: any): any;
          compareAndExchangeAcquire(p0: any): any;
          compareAndExchangeRelease(p0: any): any;
          weakCompareAndSetPlain(p0: any): boolean;
          weakCompareAndSet(p0: any): boolean;
          weakCompareAndSetAcquire(p0: any): boolean;
          weakCompareAndSetRelease(p0: any): boolean;
          getAndSet(p0: any): any;
          getAndSetAcquire(p0: any): any;
          getAndSetRelease(p0: any): any;
          getAndAdd(p0: any): any;
          getAndAddAcquire(p0: any): any;
          getAndAddRelease(p0: any): any;
          getAndBitwiseOr(p0: any): any;
          getAndBitwiseOrAcquire(p0: any): any;
          getAndBitwiseOrRelease(p0: any): any;
          getAndBitwiseAnd(p0: any): any;
          getAndBitwiseAndAcquire(p0: any): any;
          getAndBitwiseAndRelease(p0: any): any;
          getAndBitwiseXor(p0: any): any;
          getAndBitwiseXorAcquire(p0: any): any;
          getAndBitwiseXorRelease(p0: any): any;
          withInvokeExactBehavior(): java.lang.invoke.VarHandle;
          withInvokeBehavior(): java.lang.invoke.VarHandle;
          varType(): java.lang.Class<any>;
          coordinateTypes(): Array<java.lang.Class<any>>;
          accessModeType(p0: java.lang.invoke.VarHandle$AccessMode): java.lang.invoke.MethodType;
          isAccessModeSupported(p0: java.lang.invoke.VarHandle$AccessMode): boolean;
          toMethodHandle(p0: java.lang.invoke.VarHandle$AccessMode): java.lang.invoke.MethodHandle;
        }
        const VarHandle$VarHandleDesc: {
          ofField(p0: java.lang.constant.ClassDesc, p1: string, p2: java.lang.constant.ClassDesc): java.lang.invoke.VarHandle$VarHandleDesc;
          ofStaticField(p0: java.lang.constant.ClassDesc, p1: string, p2: java.lang.constant.ClassDesc): java.lang.invoke.VarHandle$VarHandleDesc;
          ofArray(p0: java.lang.constant.ClassDesc): java.lang.invoke.VarHandle$VarHandleDesc;
        }
        interface VarHandle$VarHandleDesc extends java.lang.constant.DynamicConstantDesc<java.lang.invoke.VarHandle> { 
          varType(): java.lang.constant.ClassDesc;
        }
        const MethodHandles$Lookup: {
          ClassOption: typeof java.lang.invoke.MethodHandles.MethodHandles$Lookup$ClassOption;
          PUBLIC: number;
          PRIVATE: number;
          PROTECTED: number;
          PACKAGE: number;
          MODULE: number;
          UNCONDITIONAL: number;
          ORIGINAL: number;
        }
        interface MethodHandles$Lookup { 
          lookupClass(): java.lang.Class<any>;
          previousLookupClass(): java.lang.Class<any>;
          lookupModes(): number;
          dropLookupMode(p0: number): java.lang.invoke.MethodHandles$Lookup;
          defineClass(p0: Array<number>): java.lang.Class<any>;
          defineHiddenClass(p0: Array<number>, p1: boolean, p2: unknown): java.lang.invoke.MethodHandles$Lookup;
          defineHiddenClassWithClassData(p0: Array<number>, p1: any, p2: boolean, p3: unknown): java.lang.invoke.MethodHandles$Lookup;
          findStatic(p0: java.lang.Class<any>, p1: string, p2: java.lang.invoke.MethodType): java.lang.invoke.MethodHandle;
          findVirtual(p0: java.lang.Class<any>, p1: string, p2: java.lang.invoke.MethodType): java.lang.invoke.MethodHandle;
          findConstructor(p0: java.lang.Class<any>, p1: java.lang.invoke.MethodType): java.lang.invoke.MethodHandle;
          findClass(p0: string): java.lang.Class<any>;
          ensureInitialized<T>(p0: java.lang.Class<T>): java.lang.Class<T>;
          accessClass<T>(p0: java.lang.Class<T>): java.lang.Class<T>;
          findSpecial(p0: java.lang.Class<any>, p1: string, p2: java.lang.invoke.MethodType, p3: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          findGetter(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          findSetter(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          findVarHandle(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.VarHandle;
          findStaticGetter(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          findStaticSetter(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          findStaticVarHandle(p0: java.lang.Class<any>, p1: string, p2: java.lang.Class<any>): java.lang.invoke.VarHandle;
          bind(p0: any, p1: string, p2: java.lang.invoke.MethodType): java.lang.invoke.MethodHandle;
          unreflect(p0: java.lang.reflect.Method): java.lang.invoke.MethodHandle;
          unreflectSpecial(p0: java.lang.reflect.Method, p1: java.lang.Class<any>): java.lang.invoke.MethodHandle;
          unreflectConstructor(p0: java.lang.reflect.Constructor<any>): java.lang.invoke.MethodHandle;
          unreflectGetter(p0: java.lang.reflect.Field): java.lang.invoke.MethodHandle;
          unreflectSetter(p0: java.lang.reflect.Field): java.lang.invoke.MethodHandle;
          unreflectVarHandle(p0: java.lang.reflect.Field): java.lang.invoke.VarHandle;
          revealDirect(p0: java.lang.invoke.MethodHandle): java.lang.invoke.MethodHandleInfo;
          hasPrivateAccess(): boolean;
          hasFullPrivilegeAccess(): boolean;
        }
        const MethodHandles$Lookup$ClassOption: {
          NESTMATE: java.lang.invoke.MethodHandles.MethodHandles$Lookup$ClassOption;
          STRONG: java.lang.invoke.MethodHandles.MethodHandles$Lookup$ClassOption;
          valueOf(value: string): unknown;
          values(): Array<unknown>;
        }
        interface MethodHandles$Lookup$ClassOption extends kotlin.Enum<unknown> { 
        }
        const MethodHandleInfo: {
          REF_getField: number;
          REF_getStatic: number;
          REF_putField: number;
          REF_putStatic: number;
          REF_invokeVirtual: number;
          REF_invokeStatic: number;
          REF_invokeSpecial: number;
          REF_newInvokeSpecial: number;
          REF_invokeInterface: number;
          referenceKindToString(p0: number): string;
        }
        interface MethodHandleInfo { 
          getReferenceKind(): number;
          getDeclaringClass(): java.lang.Class<any>;
          getName(): string;
          getMethodType(): java.lang.invoke.MethodType;
          reflectAs<T>(p0: java.lang.Class<T>, p1: java.lang.invoke.MethodHandles$Lookup): T;
          getModifiers(): number;
          isVarArgs(): boolean;
        }
        const VarHandle$AccessMode: {
          GET: java.lang.invoke.VarHandle$AccessMode;
          SET: java.lang.invoke.VarHandle$AccessMode;
          GET_VOLATILE: java.lang.invoke.VarHandle$AccessMode;
          SET_VOLATILE: java.lang.invoke.VarHandle$AccessMode;
          GET_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          SET_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_OPAQUE: java.lang.invoke.VarHandle$AccessMode;
          SET_OPAQUE: java.lang.invoke.VarHandle$AccessMode;
          COMPARE_AND_SET: java.lang.invoke.VarHandle$AccessMode;
          COMPARE_AND_EXCHANGE: java.lang.invoke.VarHandle$AccessMode;
          COMPARE_AND_EXCHANGE_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          COMPARE_AND_EXCHANGE_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          WEAK_COMPARE_AND_SET_PLAIN: java.lang.invoke.VarHandle$AccessMode;
          WEAK_COMPARE_AND_SET: java.lang.invoke.VarHandle$AccessMode;
          WEAK_COMPARE_AND_SET_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          WEAK_COMPARE_AND_SET_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_SET: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_SET_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_SET_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_ADD: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_ADD_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_ADD_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_OR: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_OR_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_OR_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_AND: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_AND_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_AND_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_XOR: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_XOR_RELEASE: java.lang.invoke.VarHandle$AccessMode;
          GET_AND_BITWISE_XOR_ACQUIRE: java.lang.invoke.VarHandle$AccessMode;
          valueFromMethodName(p0: string): java.lang.invoke.VarHandle$AccessMode;
          valueOf(value: string): java.lang.invoke.VarHandle$AccessMode;
          values(): Array<java.lang.invoke.VarHandle$AccessMode>;
        }
        interface VarHandle$AccessMode extends kotlin.Enum<java.lang.invoke.VarHandle$AccessMode> { 
          methodName(): string;
        }
        const SwitchPoint: {
          invalidateAll(p0: Array<java.lang.invoke.SwitchPoint>): void;
          new(): java.lang.invoke.SwitchPoint;
        }
        interface SwitchPoint { 
          hasBeenInvalidated(): boolean;
          guardWithTest(p0: java.lang.invoke.MethodHandle, p1: java.lang.invoke.MethodHandle): java.lang.invoke.MethodHandle;
        }
      }
      namespace constant {
        interface Constable { 
          describeConstable(): java.util.Optional<java.lang.constant.ConstantDesc>;
        }
        const DynamicConstantDesc: {
          ofCanonical<T>(p0: java.lang.constant.DirectMethodHandleDesc, p1: string, p2: java.lang.constant.ClassDesc, p3: Array<java.lang.constant.ConstantDesc>): java.lang.constant.ConstantDesc;
          ofNamed<T>(p0: java.lang.constant.DirectMethodHandleDesc, p1: string, p2: java.lang.constant.ClassDesc, p3: java.lang.constant.ConstantDesc): java.lang.constant.DynamicConstantDesc<T>;
          of<T>(p0: java.lang.constant.DirectMethodHandleDesc, p1: java.lang.constant.ConstantDesc): java.lang.constant.DynamicConstantDesc<T>;
          of<T>(p0: java.lang.constant.DirectMethodHandleDesc): java.lang.constant.DynamicConstantDesc<T>;
        }
        interface DynamicConstantDesc<T> extends java.lang.constant.ConstantDesc { 
          constantName(): string;
          constantType(): java.lang.constant.ClassDesc;
          bootstrapMethod(): java.lang.constant.DirectMethodHandleDesc;
          bootstrapArgs(): Array<java.lang.constant.ConstantDesc>;
          bootstrapArgsList(): Array<java.lang.constant.ConstantDesc>;
        }
        interface ConstantDesc { 
          resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): any;
        }
        const ClassDesc: {
          of(p0: string): java.lang.constant.ClassDesc;
          of(p0: string, p1: string): java.lang.constant.ClassDesc;
          ofInternalName(p0: string): java.lang.constant.ClassDesc;
          ofDescriptor(p0: string): java.lang.constant.ClassDesc;
        }
        interface ClassDesc extends java.lang.constant.ConstantDesc, java.lang.invoke.TypeDescriptor$OfField<java.lang.constant.ClassDesc> { 
          arrayType(p0: number): java.lang.constant.ClassDesc;
          nested(p0: string): java.lang.constant.ClassDesc;
          nested(p0: string, p1: string): java.lang.constant.ClassDesc;
          isClassOrInterface(): boolean;
          packageName(): string;
          displayName(): string;
        }
        const DirectMethodHandleDesc: {
          Kind: typeof java.lang.constant.DirectMethodHandleDesc$Kind;
        }
        interface DirectMethodHandleDesc extends java.lang.constant.MethodHandleDesc { 
          kind(): java.lang.constant.DirectMethodHandleDesc$Kind;
          refKind(): number;
          isOwnerInterface(): boolean;
          owner(): java.lang.constant.ClassDesc;
          methodName(): string;
          lookupDescriptor(): string;
        }
        const MethodHandleDesc: {
          of(p0: java.lang.constant.DirectMethodHandleDesc$Kind, p1: java.lang.constant.ClassDesc, p2: string, p3: string): java.lang.constant.DirectMethodHandleDesc;
          ofMethod(p0: java.lang.constant.DirectMethodHandleDesc$Kind, p1: java.lang.constant.ClassDesc, p2: string, p3: java.lang.constant.MethodTypeDesc): java.lang.constant.DirectMethodHandleDesc;
          ofField(p0: java.lang.constant.DirectMethodHandleDesc$Kind, p1: java.lang.constant.ClassDesc, p2: string, p3: java.lang.constant.ClassDesc): java.lang.constant.DirectMethodHandleDesc;
          ofConstructor(p0: java.lang.constant.ClassDesc, p1: java.lang.constant.ClassDesc): java.lang.constant.DirectMethodHandleDesc;
        }
        interface MethodHandleDesc extends java.lang.constant.ConstantDesc { 
          asType(p0: java.lang.constant.MethodTypeDesc): java.lang.constant.MethodHandleDesc;
          invocationType(): java.lang.constant.MethodTypeDesc;
        }
        const MethodTypeDesc: {
          ofDescriptor(p0: string): java.lang.constant.MethodTypeDesc;
          of(p0: java.lang.constant.ClassDesc): java.lang.constant.MethodTypeDesc;
          of(p0: java.lang.constant.ClassDesc, p1: Array<java.lang.constant.ClassDesc>): java.lang.constant.MethodTypeDesc;
          of(p0: java.lang.constant.ClassDesc, p1: java.lang.constant.ClassDesc): java.lang.constant.MethodTypeDesc;
        }
        interface MethodTypeDesc extends java.lang.constant.ConstantDesc, java.lang.invoke.TypeDescriptor$OfMethod<java.lang.constant.ClassDesc, java.lang.constant.MethodTypeDesc> { 
          displayDescriptor(): string;
        }
        const DirectMethodHandleDesc$Kind: {
          STATIC: java.lang.constant.DirectMethodHandleDesc$Kind;
          INTERFACE_STATIC: java.lang.constant.DirectMethodHandleDesc$Kind;
          VIRTUAL: java.lang.constant.DirectMethodHandleDesc$Kind;
          INTERFACE_VIRTUAL: java.lang.constant.DirectMethodHandleDesc$Kind;
          SPECIAL: java.lang.constant.DirectMethodHandleDesc$Kind;
          INTERFACE_SPECIAL: java.lang.constant.DirectMethodHandleDesc$Kind;
          CONSTRUCTOR: java.lang.constant.DirectMethodHandleDesc$Kind;
          GETTER: java.lang.constant.DirectMethodHandleDesc$Kind;
          SETTER: java.lang.constant.DirectMethodHandleDesc$Kind;
          STATIC_GETTER: java.lang.constant.DirectMethodHandleDesc$Kind;
          STATIC_SETTER: java.lang.constant.DirectMethodHandleDesc$Kind;
          valueOf(p0: number): java.lang.constant.DirectMethodHandleDesc$Kind;
          valueOf(p0: number, p1: boolean): java.lang.constant.DirectMethodHandleDesc$Kind;
          valueOf(value: string): java.lang.constant.DirectMethodHandleDesc$Kind;
          values(): Array<java.lang.constant.DirectMethodHandleDesc$Kind>;
        }
        interface DirectMethodHandleDesc$Kind extends kotlin.Enum<java.lang.constant.DirectMethodHandleDesc$Kind> { 
          refKind: number;
          isInterface: boolean;
        }
      }
      namespace module {
        const ModuleDescriptor: {
          Version: typeof java.lang.module.ModuleDescriptor$Version;
          Provides: typeof java.lang.module.ModuleDescriptor$Provides;
          Exports: typeof java.lang.module.ModuleDescriptor$Exports;
          Requires: typeof java.lang.module.ModuleDescriptor$Requires;
          Opens: typeof java.lang.module.ModuleDescriptor$Opens;
          Builder: typeof java.lang.module.ModuleDescriptor$Builder;
          Modifier: typeof java.lang.module.ModuleDescriptor$Modifier;
          newModule(p0: string, p1: Set<java.lang.module.ModuleDescriptor$Modifier>): java.lang.module.ModuleDescriptor$Builder;
          newModule(p0: string): java.lang.module.ModuleDescriptor$Builder;
          newOpenModule(p0: string): java.lang.module.ModuleDescriptor$Builder;
          newAutomaticModule(p0: string): java.lang.module.ModuleDescriptor$Builder;
          read(p0: java.io.InputStream, p1: unknown): java.lang.module.ModuleDescriptor;
          read(p0: java.io.InputStream): java.lang.module.ModuleDescriptor;
          read(p0: java.nio.ByteBuffer, p1: unknown): java.lang.module.ModuleDescriptor;
          read(p0: java.nio.ByteBuffer): java.lang.module.ModuleDescriptor;
        }
        interface ModuleDescriptor extends kotlin.Comparable<java.lang.module.ModuleDescriptor> { 
          name(): string;
          modifiers(): Set<java.lang.module.ModuleDescriptor$Modifier>;
          accessFlags(): Set<unknown>;
          isOpen(): boolean;
          isAutomatic(): boolean;
          requires(): Set<java.lang.module.ModuleDescriptor$Requires>;
          exports(): Set<java.lang.module.ModuleDescriptor$Exports>;
          opens(): Set<java.lang.module.ModuleDescriptor$Opens>;
          uses(): Set<string>;
          provides(): Set<java.lang.module.ModuleDescriptor$Provides>;
          version(): java.util.Optional<java.lang.module.ModuleDescriptor$Version>;
          rawVersion(): java.util.Optional<string>;
          toNameAndVersion(): string;
          mainClass(): java.util.Optional<string>;
          packages(): Set<string>;
        }
        const ModuleDescriptor$Version: {
          parse(p0: string): java.lang.module.ModuleDescriptor$Version;
        }
        interface ModuleDescriptor$Version extends kotlin.Comparable<java.lang.module.ModuleDescriptor$Version> { 
        }
        interface ModuleDescriptor$Provides extends kotlin.Comparable<java.lang.module.ModuleDescriptor$Provides> { 
          service(): string;
          providers(): Array<string>;
        }
        const ModuleDescriptor$Exports: {
          Modifier: typeof java.lang.module.ModuleDescriptor.ModuleDescriptor$Exports$Modifier;
        }
        interface ModuleDescriptor$Exports extends kotlin.Comparable<java.lang.module.ModuleDescriptor$Exports> { 
          modifiers(): Set<unknown>;
          accessFlags(): Set<unknown>;
          isQualified(): boolean;
          source(): string;
          targets(): Set<string>;
        }
        const ModuleDescriptor$Exports$Modifier: {
          SYNTHETIC: java.lang.module.ModuleDescriptor.ModuleDescriptor$Exports$Modifier;
          MANDATED: java.lang.module.ModuleDescriptor.ModuleDescriptor$Exports$Modifier;
          valueOf(value: string): unknown;
          values(): Array<unknown>;
        }
        interface ModuleDescriptor$Exports$Modifier extends kotlin.Enum<unknown> { 
        }
        const ModuleDescriptor$Requires: {
          Modifier: typeof java.lang.module.ModuleDescriptor.ModuleDescriptor$Requires$Modifier;
        }
        interface ModuleDescriptor$Requires extends kotlin.Comparable<java.lang.module.ModuleDescriptor$Requires> { 
          modifiers(): Set<unknown>;
          accessFlags(): Set<unknown>;
          name(): string;
          compiledVersion(): java.util.Optional<java.lang.module.ModuleDescriptor$Version>;
          rawCompiledVersion(): java.util.Optional<string>;
        }
        const ModuleDescriptor$Requires$Modifier: {
          TRANSITIVE: java.lang.module.ModuleDescriptor.ModuleDescriptor$Requires$Modifier;
          STATIC: java.lang.module.ModuleDescriptor.ModuleDescriptor$Requires$Modifier;
          SYNTHETIC: java.lang.module.ModuleDescriptor.ModuleDescriptor$Requires$Modifier;
          MANDATED: java.lang.module.ModuleDescriptor.ModuleDescriptor$Requires$Modifier;
          valueOf(value: string): unknown;
          values(): Array<unknown>;
        }
        interface ModuleDescriptor$Requires$Modifier extends kotlin.Enum<unknown> { 
        }
        const ModuleDescriptor$Opens: {
          Modifier: typeof java.lang.module.ModuleDescriptor.ModuleDescriptor$Opens$Modifier;
        }
        interface ModuleDescriptor$Opens extends kotlin.Comparable<java.lang.module.ModuleDescriptor$Opens> { 
          modifiers(): Set<unknown>;
          accessFlags(): Set<unknown>;
          isQualified(): boolean;
          source(): string;
          targets(): Set<string>;
        }
        const ModuleDescriptor$Opens$Modifier: {
          SYNTHETIC: java.lang.module.ModuleDescriptor.ModuleDescriptor$Opens$Modifier;
          MANDATED: java.lang.module.ModuleDescriptor.ModuleDescriptor$Opens$Modifier;
          valueOf(value: string): unknown;
          values(): Array<unknown>;
        }
        interface ModuleDescriptor$Opens$Modifier extends kotlin.Enum<unknown> { 
        }
        interface ModuleDescriptor$Builder { 
          packages(p0: Set<string>): java.lang.module.ModuleDescriptor$Builder;
          requires(p0: java.lang.module.ModuleDescriptor$Requires): java.lang.module.ModuleDescriptor$Builder;
          requires(p0: Set<unknown>, p1: string, p2: java.lang.module.ModuleDescriptor$Version): java.lang.module.ModuleDescriptor$Builder;
          requires(p0: Set<unknown>, p1: string): java.lang.module.ModuleDescriptor$Builder;
          requires(p0: string): java.lang.module.ModuleDescriptor$Builder;
          exports(p0: java.lang.module.ModuleDescriptor$Exports): java.lang.module.ModuleDescriptor$Builder;
          exports(p0: Set<unknown>, p1: string, p2: Set<string>): java.lang.module.ModuleDescriptor$Builder;
          exports(p0: Set<unknown>, p1: string): java.lang.module.ModuleDescriptor$Builder;
          exports(p0: string, p1: Set<string>): java.lang.module.ModuleDescriptor$Builder;
          exports(p0: string): java.lang.module.ModuleDescriptor$Builder;
          opens(p0: java.lang.module.ModuleDescriptor$Opens): java.lang.module.ModuleDescriptor$Builder;
          opens(p0: Set<unknown>, p1: string, p2: Set<string>): java.lang.module.ModuleDescriptor$Builder;
          opens(p0: Set<unknown>, p1: string): java.lang.module.ModuleDescriptor$Builder;
          opens(p0: string, p1: Set<string>): java.lang.module.ModuleDescriptor$Builder;
          opens(p0: string): java.lang.module.ModuleDescriptor$Builder;
          uses(p0: string): java.lang.module.ModuleDescriptor$Builder;
          provides(p0: java.lang.module.ModuleDescriptor$Provides): java.lang.module.ModuleDescriptor$Builder;
          provides(p0: string, p1: Array<string>): java.lang.module.ModuleDescriptor$Builder;
          version(p0: java.lang.module.ModuleDescriptor$Version): java.lang.module.ModuleDescriptor$Builder;
          version(p0: string): java.lang.module.ModuleDescriptor$Builder;
          mainClass(p0: string): java.lang.module.ModuleDescriptor$Builder;
          build(): java.lang.module.ModuleDescriptor;
        }
        const ModuleDescriptor$Modifier: {
          OPEN: java.lang.module.ModuleDescriptor$Modifier;
          AUTOMATIC: java.lang.module.ModuleDescriptor$Modifier;
          SYNTHETIC: java.lang.module.ModuleDescriptor$Modifier;
          MANDATED: java.lang.module.ModuleDescriptor$Modifier;
          valueOf(value: string): java.lang.module.ModuleDescriptor$Modifier;
          values(): Array<java.lang.module.ModuleDescriptor$Modifier>;
        }
        interface ModuleDescriptor$Modifier extends kotlin.Enum<java.lang.module.ModuleDescriptor$Modifier> { 
        }
        const Configuration: {
          resolveAndBind(p0: java.lang.module.ModuleFinder, p1: Array<java.lang.module.Configuration>, p2: java.lang.module.ModuleFinder, p3: Array<string>): java.lang.module.Configuration;
          resolve(p0: java.lang.module.ModuleFinder, p1: Array<java.lang.module.Configuration>, p2: java.lang.module.ModuleFinder, p3: Array<string>): java.lang.module.Configuration;
          empty(): java.lang.module.Configuration;
        }
        interface Configuration { 
          resolve(p0: java.lang.module.ModuleFinder, p1: java.lang.module.ModuleFinder, p2: Array<string>): java.lang.module.Configuration;
          resolveAndBind(p0: java.lang.module.ModuleFinder, p1: java.lang.module.ModuleFinder, p2: Array<string>): java.lang.module.Configuration;
          parents(): Array<java.lang.module.Configuration>;
          modules(): Set<unknown>;
          findModule(p0: string): java.util.Optional<unknown>;
        }
        const ModuleFinder: {
          ofSystem(): java.lang.module.ModuleFinder;
          of(p0: java.nio.file.Path): java.lang.module.ModuleFinder;
          compose(p0: java.lang.module.ModuleFinder): java.lang.module.ModuleFinder;
        }
        interface ModuleFinder { 
          find(p0: string): java.util.Optional<unknown>;
          findAll(): Set<unknown>;
        }
      }
      namespace foreign {
        const Arena: {
          ofAuto(): java.lang.foreign.Arena;
          global(): java.lang.foreign.Arena;
          ofConfined(): java.lang.foreign.Arena;
          ofShared(): java.lang.foreign.Arena;
        }
        interface Arena extends java.lang.foreign.SegmentAllocator, java.lang.AutoCloseable { 
          scope(): java.lang.foreign.MemorySegment$Scope;
        }
        const SegmentAllocator: {
          slicingAllocator(p0: java.lang.foreign.MemorySegment): java.lang.foreign.SegmentAllocator;
          prefixAllocator(p0: java.lang.foreign.MemorySegment): java.lang.foreign.SegmentAllocator;
        }
        interface SegmentAllocator { 
          allocateUtf8String(p0: string): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfByte, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfChar, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfShort, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfInt, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfLong, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.AddressLayout, p1: java.lang.foreign.MemorySegment): java.lang.foreign.MemorySegment;
          allocate(p0: java.lang.foreign.MemoryLayout): java.lang.foreign.MemorySegment;
          allocate(p0: number): java.lang.foreign.MemorySegment;
          allocate(p0: number, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfByte, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfShort, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfChar, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfInt, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfLong, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number): java.lang.foreign.MemorySegment;
          allocateArray(p0: java.lang.foreign.MemoryLayout, p1: number): java.lang.foreign.MemorySegment;
          (p0: number, p1: number): java.lang.foreign.MemorySegment;
        }
        const MemorySegment: {
          NULL: java.lang.foreign.MemorySegment;
          ofBuffer(p0: java.nio.Buffer): java.lang.foreign.MemorySegment;
          ofArray(p0: Array<number>): java.lang.foreign.MemorySegment;
          ofArray(p0: Array<number>): java.lang.foreign.MemorySegment;
          ofArray(p0: Array<number>): java.lang.foreign.MemorySegment;
          ofArray(p0: Array<number>): java.lang.foreign.MemorySegment;
          ofArray(p0: kotlin.FloatArray): java.lang.foreign.MemorySegment;
          ofArray(p0: Array<number>): java.lang.foreign.MemorySegment;
          ofArray(p0: kotlin.DoubleArray): java.lang.foreign.MemorySegment;
          ofAddress(p0: number): java.lang.foreign.MemorySegment;
          copy(p0: java.lang.foreign.MemorySegment, p1: number, p2: java.lang.foreign.MemorySegment, p3: number, p4: number): void;
          copy(p0: java.lang.foreign.MemorySegment, p1: java.lang.foreign.ValueLayout, p2: number, p3: java.lang.foreign.MemorySegment, p4: java.lang.foreign.ValueLayout, p5: number, p6: number): void;
          copy(p0: java.lang.foreign.MemorySegment, p1: java.lang.foreign.ValueLayout, p2: number, p3: any, p4: number, p5: number): void;
          copy(p0: any, p1: number, p2: java.lang.foreign.MemorySegment, p3: java.lang.foreign.ValueLayout, p4: number, p5: number): void;
          mismatch(p0: java.lang.foreign.MemorySegment, p1: number, p2: number, p3: java.lang.foreign.MemorySegment, p4: number, p5: number): number;
        }
        interface MemorySegment { 
          address(): number;
          heapBase(): java.util.Optional<any>;
          spliterator(p0: java.lang.foreign.MemoryLayout): java.util.Spliterator<java.lang.foreign.MemorySegment>;
          elements(p0: java.lang.foreign.MemoryLayout): java.util.stream.Stream<java.lang.foreign.MemorySegment>;
          scope(): java.lang.foreign.MemorySegment$Scope;
          isAccessibleBy(p0: java.lang.Thread): boolean;
          byteSize(): number;
          asSlice(p0: number, p1: number): java.lang.foreign.MemorySegment;
          asSlice(p0: number, p1: number, p2: number): java.lang.foreign.MemorySegment;
          asSlice(p0: number, p1: java.lang.foreign.MemoryLayout): java.lang.foreign.MemorySegment;
          asSlice(p0: number): java.lang.foreign.MemorySegment;
          reinterpret(p0: number): java.lang.foreign.MemorySegment;
          reinterpret(p0: java.lang.foreign.Arena, p1: unknown): java.lang.foreign.MemorySegment;
          reinterpret(p0: number, p1: java.lang.foreign.Arena, p2: unknown): java.lang.foreign.MemorySegment;
          isReadOnly(): boolean;
          asReadOnly(): java.lang.foreign.MemorySegment;
          isNative(): boolean;
          isMapped(): boolean;
          asOverlappingSlice(p0: java.lang.foreign.MemorySegment): java.util.Optional<java.lang.foreign.MemorySegment>;
          segmentOffset(p0: java.lang.foreign.MemorySegment): number;
          fill(p0: number): java.lang.foreign.MemorySegment;
          copyFrom(p0: java.lang.foreign.MemorySegment): java.lang.foreign.MemorySegment;
          mismatch(p0: java.lang.foreign.MemorySegment): number;
          isLoaded(): boolean;
          load(): void;
          unload(): void;
          force(): void;
          asByteBuffer(): java.nio.ByteBuffer;
          toArray(p0: java.lang.foreign.ValueLayout$OfByte): Array<number>;
          toArray(p0: java.lang.foreign.ValueLayout$OfShort): Array<number>;
          toArray(p0: java.lang.foreign.ValueLayout$OfChar): Array<number>;
          toArray(p0: java.lang.foreign.ValueLayout$OfInt): Array<number>;
          toArray(p0: java.lang.foreign.ValueLayout$OfFloat): kotlin.FloatArray;
          toArray(p0: java.lang.foreign.ValueLayout$OfLong): Array<number>;
          toArray(p0: java.lang.foreign.ValueLayout$OfDouble): kotlin.DoubleArray;
          getUtf8String(p0: number): string;
          setUtf8String(p0: number, p1: string): void;
          get(p0: java.lang.foreign.ValueLayout$OfByte, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfBoolean, p1: number): boolean;
          get(p0: java.lang.foreign.ValueLayout$OfChar, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfShort, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfInt, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfLong, p1: number): number;
          get(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number): number;
          get(p0: java.lang.foreign.AddressLayout, p1: number): java.lang.foreign.MemorySegment;
          set(p0: java.lang.foreign.ValueLayout$OfByte, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfBoolean, p1: number, p2: boolean): void;
          set(p0: java.lang.foreign.ValueLayout$OfChar, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfShort, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfInt, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfLong, p1: number, p2: number): void;
          set(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number, p2: number): void;
          set(p0: java.lang.foreign.AddressLayout, p1: number, p2: java.lang.foreign.MemorySegment): void;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfByte, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfBoolean, p1: number): boolean;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfChar, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfShort, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfInt, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfLong, p1: number): number;
          getAtIndex(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number): number;
          getAtIndex(p0: java.lang.foreign.AddressLayout, p1: number): java.lang.foreign.MemorySegment;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfChar, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfByte, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfBoolean, p1: number, p2: boolean): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfShort, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfInt, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfFloat, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfLong, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.ValueLayout$OfDouble, p1: number, p2: number): void;
          setAtIndex(p0: java.lang.foreign.AddressLayout, p1: number, p2: java.lang.foreign.MemorySegment): void;
        }
        interface MemorySegment$Scope { 
          isAlive(): boolean;
        }
        const MemoryLayout: {
          paddingLayout(p0: number): java.lang.foreign.PaddingLayout;
          sequenceLayout(p0: number, p1: java.lang.foreign.MemoryLayout): java.lang.foreign.SequenceLayout;
          sequenceLayout(p0: java.lang.foreign.MemoryLayout): java.lang.foreign.SequenceLayout;
          structLayout(p0: java.lang.foreign.MemoryLayout): java.lang.foreign.StructLayout;
          unionLayout(p0: java.lang.foreign.MemoryLayout): java.lang.foreign.UnionLayout;
        }
        interface MemoryLayout { 
          byteSize(): number;
          name(): java.util.Optional<string>;
          withName(p0: string): java.lang.foreign.MemoryLayout;
          withoutName(): java.lang.foreign.MemoryLayout;
          byteAlignment(): number;
          withByteAlignment(p0: number): java.lang.foreign.MemoryLayout;
          byteOffset(p0: java.lang.foreign.MemoryLayout$PathElement): number;
          byteOffsetHandle(p0: java.lang.foreign.MemoryLayout$PathElement): java.lang.invoke.MethodHandle;
          varHandle(p0: java.lang.foreign.MemoryLayout$PathElement): java.lang.invoke.VarHandle;
          sliceHandle(p0: java.lang.foreign.MemoryLayout$PathElement): java.lang.invoke.MethodHandle;
          select(p0: java.lang.foreign.MemoryLayout$PathElement): java.lang.foreign.MemoryLayout;
        }
        const MemoryLayout$PathElement: {
          groupElement(p0: string): java.lang.foreign.MemoryLayout$PathElement;
          groupElement(p0: number): java.lang.foreign.MemoryLayout$PathElement;
          sequenceElement(p0: number): java.lang.foreign.MemoryLayout$PathElement;
          sequenceElement(p0: number, p1: number): java.lang.foreign.MemoryLayout$PathElement;
          sequenceElement(): java.lang.foreign.MemoryLayout$PathElement;
          dereferenceElement(): java.lang.foreign.MemoryLayout$PathElement;
        }
        interface MemoryLayout$PathElement { 
        }
        interface PaddingLayout extends java.lang.foreign.MemoryLayout { 
        }
        interface SequenceLayout extends java.lang.foreign.MemoryLayout { 
          elementLayout(): java.lang.foreign.MemoryLayout;
          elementCount(): number;
          withElementCount(p0: number): java.lang.foreign.SequenceLayout;
          reshape(p0: number): java.lang.foreign.SequenceLayout;
          flatten(): java.lang.foreign.SequenceLayout;
        }
        interface StructLayout extends java.lang.foreign.GroupLayout { 
        }
        interface GroupLayout extends java.lang.foreign.MemoryLayout { 
          memberLayouts(): Array<java.lang.foreign.MemoryLayout>;
        }
        interface UnionLayout extends java.lang.foreign.GroupLayout { 
        }
        interface ValueLayout$OfByte extends java.lang.foreign.ValueLayout { 
        }
        const ValueLayout: {
          ADDRESS: java.lang.foreign.AddressLayout;
          JAVA_BYTE: java.lang.foreign.ValueLayout$OfByte;
          JAVA_BOOLEAN: java.lang.foreign.ValueLayout$OfBoolean;
          JAVA_CHAR: java.lang.foreign.ValueLayout$OfChar;
          JAVA_SHORT: java.lang.foreign.ValueLayout$OfShort;
          JAVA_INT: java.lang.foreign.ValueLayout$OfInt;
          JAVA_LONG: java.lang.foreign.ValueLayout$OfLong;
          JAVA_FLOAT: java.lang.foreign.ValueLayout$OfFloat;
          JAVA_DOUBLE: java.lang.foreign.ValueLayout$OfDouble;
          ADDRESS_UNALIGNED: java.lang.foreign.AddressLayout;
          JAVA_CHAR_UNALIGNED: java.lang.foreign.ValueLayout$OfChar;
          JAVA_SHORT_UNALIGNED: java.lang.foreign.ValueLayout$OfShort;
          JAVA_INT_UNALIGNED: java.lang.foreign.ValueLayout$OfInt;
          JAVA_LONG_UNALIGNED: java.lang.foreign.ValueLayout$OfLong;
          JAVA_FLOAT_UNALIGNED: java.lang.foreign.ValueLayout$OfFloat;
          JAVA_DOUBLE_UNALIGNED: java.lang.foreign.ValueLayout$OfDouble;
        }
        interface ValueLayout extends java.lang.foreign.MemoryLayout { 
          order(): java.nio.ByteOrder;
          withOrder(p0: java.nio.ByteOrder): java.lang.foreign.ValueLayout;
          arrayElementVarHandle(p0: number): java.lang.invoke.VarHandle;
          carrier(): java.lang.Class<any>;
        }
        interface ValueLayout$OfShort extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfDouble extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfBoolean extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfChar extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfFloat extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfLong extends java.lang.foreign.ValueLayout { 
        }
        interface ValueLayout$OfInt extends java.lang.foreign.ValueLayout { 
        }
        interface AddressLayout extends java.lang.foreign.ValueLayout { 
          withTargetLayout(p0: java.lang.foreign.MemoryLayout): java.lang.foreign.AddressLayout;
          withoutTargetLayout(): java.lang.foreign.AddressLayout;
          targetLayout(): java.util.Optional<java.lang.foreign.MemoryLayout>;
        }
      }
      interface AutoCloseable { 
        close(): void;
      }
      interface Runnable { 
        run(): void;
        (): void;
      }
      const Class: {
        forName(p0: string): java.lang.Class<any>;
        forName(p0: string, p1: boolean, p2: java.lang.ClassLoader): java.lang.Class<any>;
        forName(p0: java.lang.Module, p1: string): java.lang.Class<any>;
      }
      interface Class<T> extends java.io.Serializable, java.lang.reflect.GenericDeclaration, java.lang.reflect.Type, java.lang.reflect.AnnotatedElement, java.lang.invoke.TypeDescriptor$OfField<java.lang.Class<any>>, java.lang.constant.Constable { 
        toGenericString(): string;
        newInstance(): T;
        isInstance(p0: any): boolean;
        isAssignableFrom(p0: java.lang.Class<any>): boolean;
        isInterface(): boolean;
        isAnnotation(): boolean;
        isSynthetic(): boolean;
        getName(): string;
        getClassLoader(): java.lang.ClassLoader;
        getModule(): java.lang.Module;
        getSuperclass(): java.lang.Class<T>;
        getGenericSuperclass(): java.lang.reflect.Type;
        getPackage(): java.lang.Package;
        getPackageName(): string;
        getInterfaces(): Array<java.lang.Class<any>>;
        getGenericInterfaces(): Array<java.lang.reflect.Type>;
        getComponentType(): java.lang.Class<any>;
        getModifiers(): number;
        accessFlags(): Set<unknown>;
        getSigners(): Array<any>;
        getEnclosingMethod(): java.lang.reflect.Method;
        getEnclosingConstructor(): java.lang.reflect.Constructor<any>;
        getDeclaringClass(): java.lang.Class<any>;
        getEnclosingClass(): java.lang.Class<any>;
        getSimpleName(): string;
        getCanonicalName(): string;
        isUnnamedClass(): boolean;
        isAnonymousClass(): boolean;
        isLocalClass(): boolean;
        isMemberClass(): boolean;
        getClasses(): Array<java.lang.Class<any>>;
        getFields(): Array<java.lang.reflect.Field>;
        getMethods(): Array<java.lang.reflect.Method>;
        getConstructors(): Array<java.lang.reflect.Constructor<any>>;
        getField(p0: string): java.lang.reflect.Field;
        getMethod(p0: string, p1: java.lang.Class<any>): java.lang.reflect.Method;
        getConstructor(p0: java.lang.Class<any>): java.lang.reflect.Constructor<T>;
        getDeclaredClasses(): Array<java.lang.Class<any>>;
        getDeclaredFields(): Array<java.lang.reflect.Field>;
        getRecordComponents(): Array<unknown>;
        getDeclaredMethods(): Array<java.lang.reflect.Method>;
        getDeclaredConstructors(): Array<java.lang.reflect.Constructor<any>>;
        getDeclaredField(p0: string): java.lang.reflect.Field;
        getDeclaredMethod(p0: string, p1: java.lang.Class<any>): java.lang.reflect.Method;
        getDeclaredConstructor(p0: java.lang.Class<any>): java.lang.reflect.Constructor<T>;
        getResourceAsStream(p0: string): java.io.InputStream;
        getResource(p0: string): java.net.URL;
        getProtectionDomain(): java.security.ProtectionDomain;
        desiredAssertionStatus(): boolean;
        isEnum(): boolean;
        isRecord(): boolean;
        getEnumConstants(): Array<T>;
        cast(p0: any): T;
        asSubclass<U>(p0: java.lang.Class<U>): java.lang.Class<U>;
        getAnnotatedSuperclass(): java.lang.reflect.AnnotatedType;
        getAnnotatedInterfaces(): Array<java.lang.reflect.AnnotatedType>;
        getNestHost(): java.lang.Class<any>;
        isNestmateOf(p0: java.lang.Class<any>): boolean;
        getNestMembers(): Array<java.lang.Class<any>>;
        isHidden(): boolean;
        getPermittedSubclasses(): Array<java.lang.Class<any>>;
        isSealed(): boolean;
      }
      const ClassLoader: {
        getSystemResource(p0: string): java.net.URL;
        getSystemResources(p0: string): java.util.Enumeration<java.net.URL>;
        getSystemResourceAsStream(p0: string): java.io.InputStream;
        getPlatformClassLoader(): java.lang.ClassLoader;
        getSystemClassLoader(): java.lang.ClassLoader;
      }
      interface ClassLoader { 
        getName(): string;
        loadClass(p0: string): java.lang.Class<any>;
        getResource(p0: string): java.net.URL;
        getResources(p0: string): java.util.Enumeration<java.net.URL>;
        resources(p0: string): java.util.stream.Stream<java.net.URL>;
        isRegisteredAsParallelCapable(): boolean;
        getResourceAsStream(p0: string): java.io.InputStream;
        getParent(): java.lang.ClassLoader;
        getUnnamedModule(): java.lang.Module;
        getDefinedPackage(p0: string): java.lang.Package;
        getDefinedPackages(): Array<java.lang.Package>;
        setDefaultAssertionStatus(p0: boolean): void;
        setPackageAssertionStatus(p0: string, p1: boolean): void;
        setClassAssertionStatus(p0: string, p1: boolean): void;
        clearAssertionStatus(): void;
      }
      interface Appendable { 
        append(p0: kotlin.CharSequence): java.lang.Appendable;
        append(p0: kotlin.CharSequence, p1: number, p2: number): java.lang.Appendable;
        append(p0: number): java.lang.Appendable;
      }
      interface Readable { 
        read(p0: java.nio.CharBuffer): number;
      }
      interface Module extends java.lang.reflect.AnnotatedElement { 
        isNamed(): boolean;
        getName(): string;
        getClassLoader(): java.lang.ClassLoader;
        getDescriptor(): java.lang.module.ModuleDescriptor;
        getLayer(): java.lang.ModuleLayer;
        isNativeAccessEnabled(): boolean;
        canRead(p0: java.lang.Module): boolean;
        addReads(p0: java.lang.Module): java.lang.Module;
        isExported(p0: string, p1: java.lang.Module): boolean;
        isExported(p0: string): boolean;
        isOpen(p0: string, p1: java.lang.Module): boolean;
        isOpen(p0: string): boolean;
        addExports(p0: string, p1: java.lang.Module): java.lang.Module;
        addOpens(p0: string, p1: java.lang.Module): java.lang.Module;
        addUses(p0: java.lang.Class<any>): java.lang.Module;
        canUse(p0: java.lang.Class<any>): boolean;
        getPackages(): Set<string>;
        getResourceAsStream(p0: string): java.io.InputStream;
      }
      const ModuleLayer: {
        Controller: typeof java.lang.ModuleLayer$Controller;
        defineModulesWithOneLoader(p0: java.lang.module.Configuration, p1: Array<java.lang.ModuleLayer>, p2: java.lang.ClassLoader): java.lang.ModuleLayer$Controller;
        defineModulesWithManyLoaders(p0: java.lang.module.Configuration, p1: Array<java.lang.ModuleLayer>, p2: java.lang.ClassLoader): java.lang.ModuleLayer$Controller;
        defineModules(p0: java.lang.module.Configuration, p1: Array<java.lang.ModuleLayer>, p2: unknown): java.lang.ModuleLayer$Controller;
        empty(): java.lang.ModuleLayer;
        boot(): java.lang.ModuleLayer;
      }
      interface ModuleLayer { 
        defineModulesWithOneLoader(p0: java.lang.module.Configuration, p1: java.lang.ClassLoader): java.lang.ModuleLayer;
        defineModulesWithManyLoaders(p0: java.lang.module.Configuration, p1: java.lang.ClassLoader): java.lang.ModuleLayer;
        defineModules(p0: java.lang.module.Configuration, p1: unknown): java.lang.ModuleLayer;
        configuration(): java.lang.module.Configuration;
        parents(): Array<java.lang.ModuleLayer>;
        modules(): Set<java.lang.Module>;
        findModule(p0: string): java.util.Optional<java.lang.Module>;
        findLoader(p0: string): java.lang.ClassLoader;
      }
      interface ModuleLayer$Controller { 
        layer(): java.lang.ModuleLayer;
        addReads(p0: java.lang.Module, p1: java.lang.Module): java.lang.ModuleLayer$Controller;
        addExports(p0: java.lang.Module, p1: string, p2: java.lang.Module): java.lang.ModuleLayer$Controller;
        addOpens(p0: java.lang.Module, p1: string, p2: java.lang.Module): java.lang.ModuleLayer$Controller;
        enableNativeAccess(p0: java.lang.Module): java.lang.ModuleLayer$Controller;
      }
      const Thread: {
        State: typeof java.lang.Thread$State;
        MIN_PRIORITY: number;
        NORM_PRIORITY: number;
        MAX_PRIORITY: number;
        currentThread(): java.lang.Thread;
        yield(): void;
        sleep(p0: number): void;
        sleep(p0: number, p1: number): void;
        sleep(p0: java.time.Duration): void;
        onSpinWait(): void;
        ofPlatform(): unknown;
        ofVirtual(): unknown;
        startVirtualThread(p0: java.lang.Runnable): java.lang.Thread;
        interrupted(): boolean;
        activeCount(): number;
        enumerate(p0: Array<java.lang.Thread>): number;
        dumpStack(): void;
        holdsLock(p0: any): boolean;
        getAllStackTraces(): Map<java.lang.Thread, Array<java.lang.StackTraceElement>>;
        setDefaultUncaughtExceptionHandler(p0: java.lang.Thread$UncaughtExceptionHandler): void;
        getDefaultUncaughtExceptionHandler(): java.lang.Thread$UncaughtExceptionHandler;
        new(): java.lang.Thread;
        new(p0: java.lang.Runnable): java.lang.Thread;
        new(p0: java.lang.ThreadGroup, p1: java.lang.Runnable): java.lang.Thread;
        new(p0: string): java.lang.Thread;
        new(p0: java.lang.ThreadGroup, p1: string): java.lang.Thread;
        new(p0: java.lang.Runnable, p1: string): java.lang.Thread;
        new(p0: java.lang.ThreadGroup, p1: java.lang.Runnable, p2: string): java.lang.Thread;
        new(p0: java.lang.ThreadGroup, p1: java.lang.Runnable, p2: string, p3: number): java.lang.Thread;
        new(p0: java.lang.ThreadGroup, p1: java.lang.Runnable, p2: string, p3: number, p4: boolean): java.lang.Thread;
      }
      interface Thread extends java.lang.Runnable { 
        isVirtual(): boolean;
        start(): void;
        stop(): void;
        interrupt(): void;
        isInterrupted(): boolean;
        isAlive(): boolean;
        suspend(): void;
        resume(): void;
        setPriority(p0: number): void;
        getPriority(): number;
        setName(p0: string): void;
        getName(): string;
        getThreadGroup(): java.lang.ThreadGroup;
        countStackFrames(): number;
        join(p0: number): void;
        join(p0: number, p1: number): void;
        join(): void;
        join(p0: java.time.Duration): boolean;
        setDaemon(p0: boolean): void;
        isDaemon(): boolean;
        checkAccess(): void;
        getContextClassLoader(): java.lang.ClassLoader;
        setContextClassLoader(p0: java.lang.ClassLoader): void;
        getStackTrace(): Array<java.lang.StackTraceElement>;
        getId(): number;
        threadId(): number;
        getState(): java.lang.Thread$State;
        getUncaughtExceptionHandler(): java.lang.Thread$UncaughtExceptionHandler;
        setUncaughtExceptionHandler(p0: java.lang.Thread$UncaughtExceptionHandler): void;
      }
      const Thread$State: {
        NEW: java.lang.Thread$State;
        RUNNABLE: java.lang.Thread$State;
        BLOCKED: java.lang.Thread$State;
        WAITING: java.lang.Thread$State;
        TIMED_WAITING: java.lang.Thread$State;
        TERMINATED: java.lang.Thread$State;
        valueOf(value: string): java.lang.Thread$State;
        values(): Array<java.lang.Thread$State>;
      }
      interface Thread$State extends kotlin.Enum<java.lang.Thread$State> { 
      }
      interface Thread$Builder { 
        name(p0: string): java.lang.Thread$Builder;
        name(p0: string, p1: number): java.lang.Thread$Builder;
        inheritInheritableThreadLocals(p0: boolean): java.lang.Thread$Builder;
        uncaughtExceptionHandler(p0: java.lang.Thread$UncaughtExceptionHandler): java.lang.Thread$Builder;
        unstarted(p0: java.lang.Runnable): java.lang.Thread;
        start(p0: java.lang.Runnable): java.lang.Thread;
        factory(): java.util.concurrent.ThreadFactory;
      }
      interface Thread$Builder$OfPlatform extends java.lang.Thread$Builder { 
        group(p0: java.lang.ThreadGroup): unknown;
        daemon(p0: boolean): unknown;
        daemon(): unknown;
        priority(p0: number): unknown;
        stackSize(p0: number): unknown;
      }
      interface Thread$UncaughtExceptionHandler { 
        uncaughtException(p0: java.lang.Thread, p1: kotlin.Throwable): void;
        (p0: java.lang.Thread, p1: kotlin.Throwable): void;
      }
      const ThreadGroup: {
        new(p0: string): java.lang.ThreadGroup;
        new(p0: java.lang.ThreadGroup, p1: string): java.lang.ThreadGroup;
      }
      interface ThreadGroup extends java.lang.Thread$UncaughtExceptionHandler { 
        getName(): string;
        getParent(): java.lang.ThreadGroup;
        getMaxPriority(): number;
        isDaemon(): boolean;
        isDestroyed(): boolean;
        setDaemon(p0: boolean): void;
        setMaxPriority(p0: number): void;
        parentOf(p0: java.lang.ThreadGroup): boolean;
        checkAccess(): void;
        activeCount(): number;
        enumerate(p0: Array<java.lang.Thread>): number;
        enumerate(p0: Array<java.lang.Thread>, p1: boolean): number;
        enumerate(p0: Array<java.lang.ThreadGroup>): number;
        enumerate(p0: Array<java.lang.ThreadGroup>, p1: boolean): number;
        activeGroupCount(): number;
        stop(): void;
        interrupt(): void;
        suspend(): void;
        resume(): void;
        destroy(): void;
        list(): void;
      }
      interface Thread$Builder$OfVirtual extends java.lang.Thread$Builder { 
      }
      const Package: {
        getPackage(p0: string): java.lang.Package;
        getPackages(): Array<java.lang.Package>;
      }
      interface Package extends java.lang.reflect.AnnotatedElement { 
        getName(): string;
        getSpecificationTitle(): string;
        getSpecificationVersion(): string;
        getSpecificationVendor(): string;
        getImplementationTitle(): string;
        getImplementationVersion(): string;
        getImplementationVendor(): string;
        isSealed(): boolean;
        isSealed(p0: java.net.URL): boolean;
        isCompatibleWith(p0: string): boolean;
      }
      interface Record { 
      }
      const Exception: {
        new(): java.lang.Exception;
        new(p0: string): java.lang.Exception;
        new(p0: string, p1: kotlin.Throwable): java.lang.Exception;
        new(p0: kotlin.Throwable): java.lang.Exception;
      }
      interface Exception extends kotlin.Throwable { 
      }
      const StringBuilder: {
        new(): java.lang.StringBuilder;
        new(p0: number): java.lang.StringBuilder;
        new(p0: string): java.lang.StringBuilder;
        new(p0: kotlin.CharSequence): java.lang.StringBuilder;
      }
      interface StringBuilder extends java.lang.Appendable, java.io.Serializable, kotlin.Comparable<java.lang.StringBuilder>, kotlin.CharSequence { 
      }
      const StringBuffer: {
        new(): java.lang.StringBuffer;
        new(p0: number): java.lang.StringBuffer;
        new(p0: string): java.lang.StringBuffer;
        new(p0: kotlin.CharSequence): java.lang.StringBuffer;
      }
      interface StringBuffer extends java.lang.Appendable, java.io.Serializable, kotlin.Comparable<java.lang.StringBuffer>, kotlin.CharSequence { 
      }
      const StackTraceElement: {
        new(p0: string, p1: string, p2: string, p3: number): java.lang.StackTraceElement;
        new(p0: string, p1: string, p2: string, p3: string, p4: string, p5: string, p6: number): java.lang.StackTraceElement;
      }
      interface StackTraceElement extends java.io.Serializable { 
        getFileName(): string;
        getLineNumber(): number;
        getModuleName(): string;
        getModuleVersion(): string;
        getClassLoaderName(): string;
        getClassName(): string;
        getMethodName(): string;
        isNativeMethod(): boolean;
      }
      const RuntimeException: {
        new(): java.lang.RuntimeException;
        new(p0: string): java.lang.RuntimeException;
        new(p0: string, p1: kotlin.Throwable): java.lang.RuntimeException;
        new(p0: kotlin.Throwable): java.lang.RuntimeException;
      }
      interface RuntimeException extends java.lang.Exception { 
      }
      const Void: {
        TYPE: java.lang.Class<java.lang.Void>;
      }
      interface Void { 
      }
      const IllegalStateException: {
        new(): java.lang.IllegalStateException;
        new(p0: string): java.lang.IllegalStateException;
        new(p0: string, p1: kotlin.Throwable): java.lang.IllegalStateException;
        new(p0: kotlin.Throwable): java.lang.IllegalStateException;
      }
      interface IllegalStateException extends java.lang.RuntimeException { 
      }
    }
    namespace security {
      namespace spec {
        interface AlgorithmParameterSpec { 
        }
      }
      namespace cert {
        interface Certificate extends java.io.Serializable { 
          getType(): string;
          getEncoded(): Array<number>;
          verify(p0: java.security.PublicKey): void;
          verify(p0: java.security.PublicKey, p1: string): void;
          verify(p0: java.security.PublicKey, p1: java.security.Provider): void;
          getPublicKey(): java.security.PublicKey;
        }
      }
      const ProtectionDomain: {
        new(p0: java.security.CodeSource, p1: java.security.PermissionCollection): java.security.ProtectionDomain;
        new(p0: java.security.CodeSource, p1: java.security.PermissionCollection, p2: java.lang.ClassLoader, p3: Array<java.security.Principal>): java.security.ProtectionDomain;
      }
      interface ProtectionDomain { 
        getCodeSource(): java.security.CodeSource;
        getClassLoader(): java.lang.ClassLoader;
        getPrincipals(): Array<java.security.Principal>;
        getPermissions(): java.security.PermissionCollection;
        staticPermissionsOnly(): boolean;
        implies(p0: java.security.Permission): boolean;
      }
      const CodeSource: {
        new(p0: java.net.URL, p1: Array<java.security.cert.Certificate>): java.security.CodeSource;
        new(p0: java.net.URL, p1: Array<unknown>): java.security.CodeSource;
      }
      interface CodeSource extends java.io.Serializable { 
        getLocation(): java.net.URL;
        getCertificates(): Array<java.security.cert.Certificate>;
        getCodeSigners(): Array<unknown>;
        implies(p0: java.security.CodeSource): boolean;
      }
      const Permission: {
        new(p0: string): java.security.Permission;
      }
      interface Permission extends java.security.Guard, java.io.Serializable { 
        implies(p0: java.security.Permission): boolean;
        getName(): string;
        getActions(): string;
        newPermissionCollection(): java.security.PermissionCollection;
      }
      interface Guard { 
        checkGuard(p0: any): void;
      }
      const PermissionCollection: {
        new(): java.security.PermissionCollection;
      }
      interface PermissionCollection extends java.io.Serializable { 
        add(p0: java.security.Permission): void;
        implies(p0: java.security.Permission): boolean;
        elements(): java.util.Enumeration<java.security.Permission>;
        elementsAsStream(): java.util.stream.Stream<java.security.Permission>;
        setReadOnly(): void;
        isReadOnly(): boolean;
      }
      interface Principal { 
        getName(): string;
        implies(p0: javax.security.auth.Subject): boolean;
      }
      const AccessControlContext: {
        new(p0: Array<java.security.ProtectionDomain>): java.security.AccessControlContext;
        new(p0: java.security.AccessControlContext, p1: java.security.DomainCombiner): java.security.AccessControlContext;
      }
      interface AccessControlContext { 
        getDomainCombiner(): java.security.DomainCombiner;
        checkPermission(p0: java.security.Permission): void;
      }
      interface DomainCombiner { 
        combine(p0: Array<java.security.ProtectionDomain>, p1: Array<java.security.ProtectionDomain>): Array<java.security.ProtectionDomain>;
      }
      interface PrivilegedAction<T> { 
        run(): T;
        (): T;
      }
      interface PrivilegedExceptionAction<T> { 
        run(): T;
        (): T;
      }
      const PublicKey: {
        serialVersionUID: number;
      }
      interface PublicKey extends java.security.Key { 
      }
      const Key: {
        serialVersionUID: number;
      }
      interface Key extends java.io.Serializable { 
        getAlgorithm(): string;
        getFormat(): string;
        getEncoded(): Array<number>;
      }
      const KeyPair: {
        new(p0: java.security.PublicKey, p1: java.security.PrivateKey): java.security.KeyPair;
      }
      interface KeyPair extends java.io.Serializable { 
        getPublic(): java.security.PublicKey;
        getPrivate(): java.security.PrivateKey;
      }
      const PrivateKey: {
        serialVersionUID: number;
      }
      interface PrivateKey extends java.security.Key, javax.security.auth.Destroyable { 
      }
      const Provider: {
        Service: typeof java.security.Provider$Service;
      }
      interface Provider extends java.util.Properties { 
        configure(p0: string): java.security.Provider;
        isConfigured(): boolean;
        getName(): string;
        getVersion(): number;
        getVersionStr(): string;
        getInfo(): string;
        getService(p0: string, p1: string): java.security.Provider$Service;
        getServices(): Set<java.security.Provider$Service>;
      }
      const Provider$Service: {
        new(p0: java.security.Provider, p1: string, p2: string, p3: string, p4: Array<string>, p5: Map<string, string>): java.security.Provider$Service;
      }
      interface Provider$Service { 
        getType(): string;
        getAlgorithm(): string;
        getProvider(): java.security.Provider;
        getClassName(): string;
        getAttribute(p0: string): string;
        newInstance(p0: any): any;
        supportsParameter(p0: any): boolean;
      }
      const AlgorithmParameters: {
        getInstance(p0: string): java.security.AlgorithmParameters;
        getInstance(p0: string, p1: string): java.security.AlgorithmParameters;
        getInstance(p0: string, p1: java.security.Provider): java.security.AlgorithmParameters;
      }
      interface AlgorithmParameters { 
        getAlgorithm(): string;
        getProvider(): java.security.Provider;
        init(p0: java.security.spec.AlgorithmParameterSpec): void;
        init(p0: Array<number>): void;
        init(p0: Array<number>, p1: string): void;
        getParameterSpec<T>(p0: java.lang.Class<T>): T;
        getEncoded(): Array<number>;
        getEncoded(p0: string): Array<number>;
      }
      const AlgorithmParametersSpi: {
        new(): java.security.AlgorithmParametersSpi;
      }
      interface AlgorithmParametersSpi { 
      }
      const SecureRandom: {
        getInstance(p0: string): java.security.SecureRandom;
        getInstance(p0: string, p1: string): java.security.SecureRandom;
        getInstance(p0: string, p1: java.security.Provider): java.security.SecureRandom;
        getInstance(p0: string, p1: java.security.SecureRandomParameters): java.security.SecureRandom;
        getInstance(p0: string, p1: java.security.SecureRandomParameters, p2: string): java.security.SecureRandom;
        getInstance(p0: string, p1: java.security.SecureRandomParameters, p2: java.security.Provider): java.security.SecureRandom;
        getSeed(p0: number): Array<number>;
        getInstanceStrong(): java.security.SecureRandom;
        new(): java.security.SecureRandom;
        new(p0: Array<number>): java.security.SecureRandom;
      }
      interface SecureRandom extends java.util.Random { 
        nextBytes(p0: Array<number>, p1: java.security.SecureRandomParameters): void;
        setSeed(p0: Array<number>): void;
        getProvider(): java.security.Provider;
        getAlgorithm(): string;
        getParameters(): java.security.SecureRandomParameters;
        generateSeed(p0: number): Array<number>;
        reseed(): void;
        reseed(p0: java.security.SecureRandomParameters): void;
      }
      interface SecureRandomParameters { 
      }
      const SecureRandomSpi: {
        new(): java.security.SecureRandomSpi;
      }
      interface SecureRandomSpi extends java.io.Serializable { 
      }
    }
    namespace net {
      const URL: {
        of(p0: java.net.URI, p1: java.net.URLStreamHandler): java.net.URL;
        setURLStreamHandlerFactory(p0: java.net.URLStreamHandlerFactory): void;
        new(p0: string, p1: string, p2: number, p3: string): java.net.URL;
        new(p0: string, p1: string, p2: string): java.net.URL;
        new(p0: string, p1: string, p2: number, p3: string, p4: java.net.URLStreamHandler): java.net.URL;
        new(p0: string): java.net.URL;
        new(p0: java.net.URL, p1: string): java.net.URL;
        new(p0: java.net.URL, p1: string, p2: java.net.URLStreamHandler): java.net.URL;
      }
      interface URL extends java.io.Serializable { 
        getQuery(): string;
        getPath(): string;
        getUserInfo(): string;
        getAuthority(): string;
        getPort(): number;
        getDefaultPort(): number;
        getProtocol(): string;
        getHost(): string;
        getFile(): string;
        getRef(): string;
        sameFile(p0: java.net.URL): boolean;
        toExternalForm(): string;
        toURI(): java.net.URI;
        openConnection(): java.net.URLConnection;
        openConnection(p0: java.net.Proxy): java.net.URLConnection;
        openStream(): java.io.InputStream;
        getContent(): any;
        getContent(p0: Array<java.lang.Class<any>>): any;
      }
      const URI: {
        create(p0: string): java.net.URI;
        new(p0: string): java.net.URI;
        new(p0: string, p1: string, p2: string, p3: number, p4: string, p5: string, p6: string): java.net.URI;
        new(p0: string, p1: string, p2: string, p3: string, p4: string): java.net.URI;
        new(p0: string, p1: string, p2: string, p3: string): java.net.URI;
        new(p0: string, p1: string, p2: string): java.net.URI;
      }
      interface URI extends kotlin.Comparable<java.net.URI>, java.io.Serializable { 
        parseServerAuthority(): java.net.URI;
        normalize(): java.net.URI;
        resolve(p0: java.net.URI): java.net.URI;
        resolve(p0: string): java.net.URI;
        relativize(p0: java.net.URI): java.net.URI;
        toURL(): java.net.URL;
        getScheme(): string;
        isAbsolute(): boolean;
        isOpaque(): boolean;
        getRawSchemeSpecificPart(): string;
        getSchemeSpecificPart(): string;
        getRawAuthority(): string;
        getAuthority(): string;
        getRawUserInfo(): string;
        getUserInfo(): string;
        getHost(): string;
        getPort(): number;
        getRawPath(): string;
        getPath(): string;
        getRawQuery(): string;
        getQuery(): string;
        getRawFragment(): string;
        getFragment(): string;
        toASCIIString(): string;
      }
      const URLConnection: {
        getFileNameMap(): java.net.FileNameMap;
        setFileNameMap(p0: java.net.FileNameMap): void;
        setDefaultAllowUserInteraction(p0: boolean): void;
        getDefaultAllowUserInteraction(): boolean;
        setDefaultUseCaches(p0: string, p1: boolean): void;
        getDefaultUseCaches(p0: string): boolean;
        setDefaultRequestProperty(p0: string, p1: string): void;
        getDefaultRequestProperty(p0: string): string;
        setContentHandlerFactory(p0: java.net.ContentHandlerFactory): void;
        guessContentTypeFromName(p0: string): string;
        guessContentTypeFromStream(p0: java.io.InputStream): string;
      }
      interface URLConnection { 
        connect(): void;
        setConnectTimeout(p0: number): void;
        getConnectTimeout(): number;
        setReadTimeout(p0: number): void;
        getReadTimeout(): number;
        getURL(): java.net.URL;
        getContentLength(): number;
        getContentLengthLong(): number;
        getContentType(): string;
        getContentEncoding(): string;
        getExpiration(): number;
        getDate(): number;
        getLastModified(): number;
        getHeaderField(p0: string): string;
        getHeaderField(p0: number): string;
        getHeaderFields(): Map<string, Array<string>>;
        getHeaderFieldInt(p0: string, p1: number): number;
        getHeaderFieldLong(p0: string, p1: number): number;
        getHeaderFieldDate(p0: string, p1: number): number;
        getHeaderFieldKey(p0: number): string;
        getContent(): any;
        getContent(p0: Array<java.lang.Class<any>>): any;
        getPermission(): java.security.Permission;
        getInputStream(): java.io.InputStream;
        getOutputStream(): java.io.OutputStream;
        setDoInput(p0: boolean): void;
        getDoInput(): boolean;
        setDoOutput(p0: boolean): void;
        getDoOutput(): boolean;
        setAllowUserInteraction(p0: boolean): void;
        getAllowUserInteraction(): boolean;
        setUseCaches(p0: boolean): void;
        getUseCaches(): boolean;
        setIfModifiedSince(p0: number): void;
        getIfModifiedSince(): number;
        getDefaultUseCaches(): boolean;
        setDefaultUseCaches(p0: boolean): void;
        setRequestProperty(p0: string, p1: string): void;
        addRequestProperty(p0: string, p1: string): void;
        getRequestProperty(p0: string): string;
        getRequestProperties(): Map<string, Array<string>>;
      }
      interface FileNameMap { 
        getContentTypeFor(p0: string): string;
      }
      interface ContentHandlerFactory { 
        createContentHandler(p0: string): java.net.ContentHandler;
      }
      const ContentHandler: {
        new(): java.net.ContentHandler;
      }
      interface ContentHandler { 
        getContent(p0: java.net.URLConnection): any;
        getContent(p0: java.net.URLConnection, p1: Array<java.lang.Class<any>>): any;
      }
      const Proxy: {
        Type: typeof java.net.Proxy$Type;
        NO_PROXY: java.net.Proxy;
        new(p0: java.net.Proxy$Type, p1: java.net.SocketAddress): java.net.Proxy;
      }
      interface Proxy { 
        type(): java.net.Proxy$Type;
        address(): java.net.SocketAddress;
      }
      const Proxy$Type: {
        DIRECT: java.net.Proxy$Type;
        HTTP: java.net.Proxy$Type;
        SOCKS: java.net.Proxy$Type;
        valueOf(value: string): java.net.Proxy$Type;
        values(): Array<java.net.Proxy$Type>;
      }
      interface Proxy$Type extends kotlin.Enum<java.net.Proxy$Type> { 
      }
      const SocketAddress: {
        new(): java.net.SocketAddress;
      }
      interface SocketAddress extends java.io.Serializable { 
      }
      const URLStreamHandler: {
        new(): java.net.URLStreamHandler;
      }
      interface URLStreamHandler { 
      }
      const InetAddress: {
        getByAddress(p0: string, p1: Array<number>): java.net.InetAddress;
        getByAddress(p0: Array<number>): java.net.InetAddress;
        getByName(p0: string): java.net.InetAddress;
        getAllByName(p0: string): Array<java.net.InetAddress>;
        getLoopbackAddress(): java.net.InetAddress;
        getLocalHost(): java.net.InetAddress;
      }
      interface InetAddress extends java.io.Serializable { 
        isMulticastAddress(): boolean;
        isAnyLocalAddress(): boolean;
        isLoopbackAddress(): boolean;
        isLinkLocalAddress(): boolean;
        isSiteLocalAddress(): boolean;
        isMCGlobal(): boolean;
        isMCNodeLocal(): boolean;
        isMCLinkLocal(): boolean;
        isMCSiteLocal(): boolean;
        isMCOrgLocal(): boolean;
        isReachable(p0: number): boolean;
        isReachable(p0: java.net.NetworkInterface, p1: number, p2: number): boolean;
        getHostName(): string;
        getCanonicalHostName(): string;
        getAddress(): Array<number>;
        getHostAddress(): string;
      }
      const NetworkInterface: {
        getByName(p0: string): java.net.NetworkInterface;
        getByIndex(p0: number): java.net.NetworkInterface;
        getByInetAddress(p0: java.net.InetAddress): java.net.NetworkInterface;
        getNetworkInterfaces(): java.util.Enumeration<java.net.NetworkInterface>;
        networkInterfaces(): java.util.stream.Stream<java.net.NetworkInterface>;
      }
      interface NetworkInterface { 
        getName(): string;
        getInetAddresses(): java.util.Enumeration<java.net.InetAddress>;
        inetAddresses(): java.util.stream.Stream<java.net.InetAddress>;
        getInterfaceAddresses(): Array<unknown>;
        getSubInterfaces(): java.util.Enumeration<java.net.NetworkInterface>;
        subInterfaces(): java.util.stream.Stream<java.net.NetworkInterface>;
        getParent(): java.net.NetworkInterface;
        getIndex(): number;
        getDisplayName(): string;
        isUp(): boolean;
        isLoopback(): boolean;
        isPointToPoint(): boolean;
        supportsMulticast(): boolean;
        getHardwareAddress(): Array<number>;
        getMTU(): number;
        isVirtual(): boolean;
      }
      interface URLStreamHandlerFactory { 
        createURLStreamHandler(p0: string): java.net.URLStreamHandler;
      }
      const InetSocketAddress: {
        createUnresolved(p0: string, p1: number): java.net.InetSocketAddress;
        new(p0: number): java.net.InetSocketAddress;
        new(p0: java.net.InetAddress, p1: number): java.net.InetSocketAddress;
        new(p0: string, p1: number): java.net.InetSocketAddress;
      }
      interface InetSocketAddress extends java.net.SocketAddress { 
        getPort(): number;
        getAddress(): java.net.InetAddress;
        getHostName(): string;
        getHostString(): string;
        isUnresolved(): boolean;
      }
    }
    namespace nio {
      namespace file {
        namespace spi {
          const FileSystemProvider: {
            installedProviders(): Array<java.nio.file.spi.FileSystemProvider>;
          }
          interface FileSystemProvider { 
            getScheme(): string;
            newFileSystem(p0: java.net.URI, p1: Map<string, any>): java.nio.file.FileSystem;
            newFileSystem(p0: java.nio.file.Path, p1: Map<string, any>): java.nio.file.FileSystem;
            getFileSystem(p0: java.net.URI): java.nio.file.FileSystem;
            getPath(p0: java.net.URI): java.nio.file.Path;
            newInputStream(p0: java.nio.file.Path, p1: java.nio.file.OpenOption): java.io.InputStream;
            newOutputStream(p0: java.nio.file.Path, p1: java.nio.file.OpenOption): java.io.OutputStream;
            newFileChannel(p0: java.nio.file.Path, p1: Set<java.nio.file.OpenOption>, p2: java.nio.file.attribute.FileAttribute<any>): java.nio.channels.FileChannel;
            newAsynchronousFileChannel(p0: java.nio.file.Path, p1: Set<java.nio.file.OpenOption>, p2: java.util.concurrent.ExecutorService, p3: java.nio.file.attribute.FileAttribute<any>): java.nio.channels.AsynchronousFileChannel;
            newByteChannel(p0: java.nio.file.Path, p1: Set<java.nio.file.OpenOption>, p2: java.nio.file.attribute.FileAttribute<any>): java.nio.channels.SeekableByteChannel;
            newDirectoryStream(p0: java.nio.file.Path, p1: java.nio.file.DirectoryStream$Filter<java.nio.file.Path>): java.nio.file.DirectoryStream<java.nio.file.Path>;
            createDirectory(p0: java.nio.file.Path, p1: java.nio.file.attribute.FileAttribute<any>): void;
            createSymbolicLink(p0: java.nio.file.Path, p1: java.nio.file.Path, p2: java.nio.file.attribute.FileAttribute<any>): void;
            createLink(p0: java.nio.file.Path, p1: java.nio.file.Path): void;
            deleteIfExists(p0: java.nio.file.Path): boolean;
            readSymbolicLink(p0: java.nio.file.Path): java.nio.file.Path;
            copy(p0: java.nio.file.Path, p1: java.nio.file.Path, p2: java.nio.file.CopyOption): void;
            move(p0: java.nio.file.Path, p1: java.nio.file.Path, p2: java.nio.file.CopyOption): void;
            isSameFile(p0: java.nio.file.Path, p1: java.nio.file.Path): boolean;
            isHidden(p0: java.nio.file.Path): boolean;
            getFileStore(p0: java.nio.file.Path): java.nio.file.FileStore;
            checkAccess(p0: java.nio.file.Path, p1: java.nio.file.AccessMode): void;
            getFileAttributeView<V>(p0: java.nio.file.Path, p1: java.lang.Class<V>, p2: java.nio.file.LinkOption): V;
            readAttributes<A>(p0: java.nio.file.Path, p1: java.lang.Class<A>, p2: java.nio.file.LinkOption): A;
            readAttributes(p0: java.nio.file.Path, p1: string, p2: java.nio.file.LinkOption): Map<string, any>;
            setAttribute(p0: java.nio.file.Path, p1: string, p2: any, p3: java.nio.file.LinkOption): void;
            exists(p0: java.nio.file.Path, p1: java.nio.file.LinkOption): boolean;
            readAttributesIfExists<A>(p0: java.nio.file.Path, p1: java.lang.Class<A>, p2: java.nio.file.LinkOption): A;
          }
        }
        namespace attribute {
          interface FileAttribute<T> { 
            name(): string;
            value(): T;
          }
          interface UserPrincipalLookupService { 
            lookupPrincipalByName(p0: string): java.nio.file.attribute.UserPrincipal;
            lookupPrincipalByGroupName(p0: string): java.nio.file.attribute.GroupPrincipal;
          }
          interface UserPrincipal extends java.security.Principal { 
          }
          interface GroupPrincipal extends java.nio.file.attribute.UserPrincipal { 
          }
          const FileTime: {
            from(p0: number, p1: java.util.concurrent.TimeUnit): java.nio.file.attribute.FileTime;
            from(p0: java.time.Instant): java.nio.file.attribute.FileTime;
            fromMillis(p0: number): java.nio.file.attribute.FileTime;
          }
          interface FileTime extends kotlin.Comparable<java.nio.file.attribute.FileTime> { 
            to(p0: java.util.concurrent.TimeUnit): number;
            toMillis(): number;
            toInstant(): java.time.Instant;
          }
        }
        const Path: {
          of(p0: string, p1: string): java.nio.file.Path;
          of(p0: java.net.URI): java.nio.file.Path;
        }
        interface Path extends kotlin.Comparable<java.nio.file.Path>, kotlin.collections.MutableIterable<java.nio.file.Path>, java.nio.file.Watchable { 
          getFileSystem(): java.nio.file.FileSystem;
          isAbsolute(): boolean;
          getRoot(): java.nio.file.Path;
          getFileName(): java.nio.file.Path;
          getParent(): java.nio.file.Path;
          getNameCount(): number;
          getName(p0: number): java.nio.file.Path;
          subpath(p0: number, p1: number): java.nio.file.Path;
          startsWith(p0: java.nio.file.Path): boolean;
          startsWith(p0: string): boolean;
          endsWith(p0: java.nio.file.Path): boolean;
          endsWith(p0: string): boolean;
          normalize(): java.nio.file.Path;
          resolve(p0: java.nio.file.Path): java.nio.file.Path;
          resolve(p0: string): java.nio.file.Path;
          resolveSibling(p0: java.nio.file.Path): java.nio.file.Path;
          resolveSibling(p0: string): java.nio.file.Path;
          relativize(p0: java.nio.file.Path): java.nio.file.Path;
          toUri(): java.net.URI;
          toAbsolutePath(): java.nio.file.Path;
          toRealPath(p0: java.nio.file.LinkOption): java.nio.file.Path;
          toFile(): java.io.File;
        }
        interface Watchable { 
          register(p0: java.nio.file.WatchService, p1: Array<java.nio.file.WatchEvent$Kind<any>>, p2: java.nio.file.WatchEvent$Modifier): java.nio.file.WatchKey;
          register(p0: java.nio.file.WatchService, p1: java.nio.file.WatchEvent$Kind<any>): java.nio.file.WatchKey;
        }
        interface WatchService extends java.io.Closeable { 
          poll(): java.nio.file.WatchKey;
          poll(p0: number, p1: java.util.concurrent.TimeUnit): java.nio.file.WatchKey;
          take(): java.nio.file.WatchKey;
        }
        interface WatchKey { 
          isValid(): boolean;
          pollEvents(): Array<unknown>;
          reset(): boolean;
          cancel(): void;
          watchable(): java.nio.file.Watchable;
        }
        interface WatchEvent$Modifier { 
          name(): string;
        }
        interface WatchEvent$Kind<T> { 
          name(): string;
          type(): java.lang.Class<T>;
        }
        interface FileSystem extends java.io.Closeable { 
          provider(): java.nio.file.spi.FileSystemProvider;
          isOpen(): boolean;
          isReadOnly(): boolean;
          getSeparator(): string;
          getRootDirectories(): kotlin.collections.MutableIterable<java.nio.file.Path>;
          getFileStores(): kotlin.collections.MutableIterable<java.nio.file.FileStore>;
          supportedFileAttributeViews(): Set<string>;
          getPath(p0: string, p1: string): java.nio.file.Path;
          getPathMatcher(p0: string): java.nio.file.PathMatcher;
          getUserPrincipalLookupService(): java.nio.file.attribute.UserPrincipalLookupService;
          newWatchService(): java.nio.file.WatchService;
        }
        interface OpenOption { 
        }
        interface DirectoryStream$Filter<T> { 
          accept(p0: T): boolean;
          (p0: T): boolean;
        }
        interface DirectoryStream<T> extends java.io.Closeable, kotlin.collections.MutableIterable<T> { 
        }
        interface CopyOption { 
        }
        interface FileStore { 
          name(): string;
          type(): string;
          isReadOnly(): boolean;
          getTotalSpace(): number;
          getUsableSpace(): number;
          getUnallocatedSpace(): number;
          getBlockSize(): number;
          supportsFileAttributeView(p0: java.lang.Class<unknown>): boolean;
          supportsFileAttributeView(p0: string): boolean;
          getFileStoreAttributeView<V>(p0: java.lang.Class<V>): V;
          getAttribute(p0: string): any;
        }
        const AccessMode: {
          READ: java.nio.file.AccessMode;
          WRITE: java.nio.file.AccessMode;
          EXECUTE: java.nio.file.AccessMode;
          valueOf(value: string): java.nio.file.AccessMode;
          values(): Array<java.nio.file.AccessMode>;
        }
        interface AccessMode extends kotlin.Enum<java.nio.file.AccessMode> { 
        }
        const LinkOption: {
          NOFOLLOW_LINKS: java.nio.file.LinkOption;
          valueOf(value: string): java.nio.file.LinkOption;
          values(): Array<java.nio.file.LinkOption>;
        }
        interface LinkOption extends kotlin.Enum<java.nio.file.LinkOption>, java.nio.file.OpenOption, java.nio.file.CopyOption { 
        }
        interface PathMatcher { 
          matches(p0: java.nio.file.Path): boolean;
          (p0: java.nio.file.Path): boolean;
        }
      }
      namespace charset {
        const Charset: {
          isSupported(p0: string): boolean;
          forName(p0: string): java.nio.charset.Charset;
          forName(p0: string, p1: java.nio.charset.Charset): java.nio.charset.Charset;
          availableCharsets(): java.util.SortedMap<string, java.nio.charset.Charset>;
          defaultCharset(): java.nio.charset.Charset;
        }
        interface Charset extends kotlin.Comparable<java.nio.charset.Charset> { 
          name(): string;
          aliases(): Set<string>;
          displayName(): string;
          displayName(p0: java.util.Locale): string;
          isRegistered(): boolean;
          contains(p0: java.nio.charset.Charset): boolean;
          newDecoder(): java.nio.charset.CharsetDecoder;
          newEncoder(): java.nio.charset.CharsetEncoder;
          canEncode(): boolean;
          decode(p0: java.nio.ByteBuffer): java.nio.CharBuffer;
          encode(p0: java.nio.CharBuffer): java.nio.ByteBuffer;
          encode(p0: string): java.nio.ByteBuffer;
        }
        interface CharsetDecoder { 
          charset(): java.nio.charset.Charset;
          replacement(): string;
          replaceWith(p0: string): java.nio.charset.CharsetDecoder;
          malformedInputAction(): java.nio.charset.CodingErrorAction;
          onMalformedInput(p0: java.nio.charset.CodingErrorAction): java.nio.charset.CharsetDecoder;
          unmappableCharacterAction(): java.nio.charset.CodingErrorAction;
          onUnmappableCharacter(p0: java.nio.charset.CodingErrorAction): java.nio.charset.CharsetDecoder;
          averageCharsPerByte(): number;
          maxCharsPerByte(): number;
          decode(p0: java.nio.ByteBuffer, p1: java.nio.CharBuffer, p2: boolean): java.nio.charset.CoderResult;
          decode(p0: java.nio.ByteBuffer): java.nio.CharBuffer;
          flush(p0: java.nio.CharBuffer): java.nio.charset.CoderResult;
          reset(): java.nio.charset.CharsetDecoder;
          isAutoDetecting(): boolean;
          isCharsetDetected(): boolean;
          detectedCharset(): java.nio.charset.Charset;
        }
        const CodingErrorAction: {
          IGNORE: java.nio.charset.CodingErrorAction;
          REPLACE: java.nio.charset.CodingErrorAction;
          REPORT: java.nio.charset.CodingErrorAction;
        }
        interface CodingErrorAction { 
        }
        const CoderResult: {
          UNDERFLOW: java.nio.charset.CoderResult;
          OVERFLOW: java.nio.charset.CoderResult;
          malformedForLength(p0: number): java.nio.charset.CoderResult;
          unmappableForLength(p0: number): java.nio.charset.CoderResult;
        }
        interface CoderResult { 
          isUnderflow(): boolean;
          isOverflow(): boolean;
          isError(): boolean;
          isMalformed(): boolean;
          isUnmappable(): boolean;
          length(): number;
          throwException(): void;
        }
        interface CharsetEncoder { 
          charset(): java.nio.charset.Charset;
          replacement(): Array<number>;
          replaceWith(p0: Array<number>): java.nio.charset.CharsetEncoder;
          isLegalReplacement(p0: Array<number>): boolean;
          malformedInputAction(): java.nio.charset.CodingErrorAction;
          onMalformedInput(p0: java.nio.charset.CodingErrorAction): java.nio.charset.CharsetEncoder;
          unmappableCharacterAction(): java.nio.charset.CodingErrorAction;
          onUnmappableCharacter(p0: java.nio.charset.CodingErrorAction): java.nio.charset.CharsetEncoder;
          averageBytesPerChar(): number;
          maxBytesPerChar(): number;
          encode(p0: java.nio.CharBuffer, p1: java.nio.ByteBuffer, p2: boolean): java.nio.charset.CoderResult;
          encode(p0: java.nio.CharBuffer): java.nio.ByteBuffer;
          flush(p0: java.nio.ByteBuffer): java.nio.charset.CoderResult;
          reset(): java.nio.charset.CharsetEncoder;
          canEncode(p0: number): boolean;
          canEncode(p0: kotlin.CharSequence): boolean;
        }
      }
      namespace channels {
        namespace spi {
          interface AbstractInterruptibleChannel extends java.nio.channels.Channel, java.nio.channels.InterruptibleChannel { 
          }
        }
        const FileChannel: {
          MapMode: typeof java.nio.channels.FileChannel$MapMode;
          open(p0: java.nio.file.Path, p1: Set<java.nio.file.OpenOption>, p2: java.nio.file.attribute.FileAttribute<any>): java.nio.channels.FileChannel;
          open(p0: java.nio.file.Path, p1: java.nio.file.OpenOption): java.nio.channels.FileChannel;
        }
        interface FileChannel extends java.nio.channels.spi.AbstractInterruptibleChannel, java.nio.channels.SeekableByteChannel, java.nio.channels.GatheringByteChannel, java.nio.channels.ScatteringByteChannel { 
          read(p0: java.nio.ByteBuffer, p1: number): number;
          write(p0: java.nio.ByteBuffer, p1: number): number;
          force(p0: boolean): void;
          transferTo(p0: number, p1: number, p2: java.nio.channels.WritableByteChannel): number;
          transferFrom(p0: java.nio.channels.ReadableByteChannel, p1: number, p2: number): number;
          map(p0: java.nio.channels.FileChannel$MapMode, p1: number, p2: number): java.nio.MappedByteBuffer;
          map(p0: java.nio.channels.FileChannel$MapMode, p1: number, p2: number, p3: java.lang.foreign.Arena): java.lang.foreign.MemorySegment;
          lock(p0: number, p1: number, p2: boolean): java.nio.channels.FileLock;
          lock(): java.nio.channels.FileLock;
          tryLock(p0: number, p1: number, p2: boolean): java.nio.channels.FileLock;
          tryLock(): java.nio.channels.FileLock;
        }
        interface Channel extends java.io.Closeable { 
          isOpen(): boolean;
        }
        interface InterruptibleChannel extends java.nio.channels.Channel { 
        }
        interface SeekableByteChannel extends java.nio.channels.ByteChannel { 
          position(): number;
          position(p0: number): java.nio.channels.SeekableByteChannel;
          size(): number;
          truncate(p0: number): java.nio.channels.SeekableByteChannel;
        }
        interface ByteChannel extends java.nio.channels.ReadableByteChannel, java.nio.channels.WritableByteChannel { 
        }
        interface ReadableByteChannel extends java.nio.channels.Channel { 
          read(p0: java.nio.ByteBuffer): number;
        }
        interface WritableByteChannel extends java.nio.channels.Channel { 
          write(p0: java.nio.ByteBuffer): number;
        }
        interface GatheringByteChannel extends java.nio.channels.WritableByteChannel { 
          write(p0: Array<java.nio.ByteBuffer>, p1: number, p2: number): number;
          write(p0: Array<java.nio.ByteBuffer>): number;
        }
        interface ScatteringByteChannel extends java.nio.channels.ReadableByteChannel { 
          read(p0: Array<java.nio.ByteBuffer>, p1: number, p2: number): number;
          read(p0: Array<java.nio.ByteBuffer>): number;
        }
        const FileChannel$MapMode: {
          READ_ONLY: java.nio.channels.FileChannel$MapMode;
          READ_WRITE: java.nio.channels.FileChannel$MapMode;
          PRIVATE: java.nio.channels.FileChannel$MapMode;
        }
        interface FileChannel$MapMode { 
        }
        interface FileLock extends java.lang.AutoCloseable { 
          channel(): java.nio.channels.FileChannel;
          acquiredBy(): java.nio.channels.Channel;
          position(): number;
          size(): number;
          isShared(): boolean;
          overlaps(p0: number, p1: number): boolean;
          isValid(): boolean;
          release(): void;
        }
        const AsynchronousFileChannel: {
          open(p0: java.nio.file.Path, p1: Set<java.nio.file.OpenOption>, p2: java.util.concurrent.ExecutorService, p3: java.nio.file.attribute.FileAttribute<any>): java.nio.channels.AsynchronousFileChannel;
          open(p0: java.nio.file.Path, p1: java.nio.file.OpenOption): java.nio.channels.AsynchronousFileChannel;
        }
        interface AsynchronousFileChannel extends java.nio.channels.AsynchronousChannel { 
          size(): number;
          truncate(p0: number): java.nio.channels.AsynchronousFileChannel;
          force(p0: boolean): void;
          lock<A>(p0: number, p1: number, p2: boolean, p3: A, p4: java.nio.channels.CompletionHandler<java.nio.channels.FileLock, A>): void;
          lock<A>(p0: A, p1: java.nio.channels.CompletionHandler<java.nio.channels.FileLock, A>): void;
          lock(p0: number, p1: number, p2: boolean): java.util.concurrent.Future<java.nio.channels.FileLock>;
          lock(): java.util.concurrent.Future<java.nio.channels.FileLock>;
          tryLock(p0: number, p1: number, p2: boolean): java.nio.channels.FileLock;
          tryLock(): java.nio.channels.FileLock;
          read<A>(p0: java.nio.ByteBuffer, p1: number, p2: A, p3: java.nio.channels.CompletionHandler<number, A>): void;
          read(p0: java.nio.ByteBuffer, p1: number): java.util.concurrent.Future<number>;
          write<A>(p0: java.nio.ByteBuffer, p1: number, p2: A, p3: java.nio.channels.CompletionHandler<number, A>): void;
          write(p0: java.nio.ByteBuffer, p1: number): java.util.concurrent.Future<number>;
        }
        interface AsynchronousChannel extends java.nio.channels.Channel { 
        }
        interface CompletionHandler<V, A> { 
          completed(p0: V, p1: A): void;
          failed(p0: kotlin.Throwable, p1: A): void;
        }
      }
      const ByteBuffer: {
        allocateDirect(p0: number): java.nio.ByteBuffer;
        allocate(p0: number): java.nio.ByteBuffer;
        wrap(p0: Array<number>, p1: number, p2: number): java.nio.ByteBuffer;
        wrap(p0: Array<number>): java.nio.ByteBuffer;
      }
      interface ByteBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.ByteBuffer> { 
        asReadOnlyBuffer(): java.nio.ByteBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: Array<number>, p1: number, p2: number): java.nio.ByteBuffer;
        get(p0: Array<number>): java.nio.ByteBuffer;
        get(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.ByteBuffer;
        get(p0: number, p1: Array<number>): java.nio.ByteBuffer;
        put(p0: number): java.nio.ByteBuffer;
        put(p0: number, p1: number): java.nio.ByteBuffer;
        put(p0: java.nio.ByteBuffer): java.nio.ByteBuffer;
        put(p0: number, p1: java.nio.ByteBuffer, p2: number, p3: number): java.nio.ByteBuffer;
        put(p0: Array<number>, p1: number, p2: number): java.nio.ByteBuffer;
        put(p0: Array<number>): java.nio.ByteBuffer;
        put(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.ByteBuffer;
        put(p0: number, p1: Array<number>): java.nio.ByteBuffer;
        compact(): java.nio.ByteBuffer;
        mismatch(p0: java.nio.ByteBuffer): number;
        order(): java.nio.ByteOrder;
        order(p0: java.nio.ByteOrder): java.nio.ByteBuffer;
        alignmentOffset(p0: number, p1: number): number;
        alignedSlice(p0: number): java.nio.ByteBuffer;
        getChar(): number;
        getChar(p0: number): number;
        putChar(p0: number): java.nio.ByteBuffer;
        putChar(p0: number, p1: number): java.nio.ByteBuffer;
        asCharBuffer(): java.nio.CharBuffer;
        getShort(): number;
        getShort(p0: number): number;
        putShort(p0: number): java.nio.ByteBuffer;
        putShort(p0: number, p1: number): java.nio.ByteBuffer;
        asShortBuffer(): java.nio.ShortBuffer;
        getInt(): number;
        getInt(p0: number): number;
        putInt(p0: number): java.nio.ByteBuffer;
        putInt(p0: number, p1: number): java.nio.ByteBuffer;
        asIntBuffer(): java.nio.IntBuffer;
        getLong(): number;
        getLong(p0: number): number;
        putLong(p0: number): java.nio.ByteBuffer;
        putLong(p0: number, p1: number): java.nio.ByteBuffer;
        asLongBuffer(): java.nio.LongBuffer;
        getFloat(): number;
        getFloat(p0: number): number;
        putFloat(p0: number): java.nio.ByteBuffer;
        putFloat(p0: number, p1: number): java.nio.ByteBuffer;
        asFloatBuffer(): java.nio.FloatBuffer;
        getDouble(): number;
        getDouble(p0: number): number;
        putDouble(p0: number): java.nio.ByteBuffer;
        putDouble(p0: number, p1: number): java.nio.ByteBuffer;
        asDoubleBuffer(): java.nio.DoubleBuffer;
      }
      interface Buffer { 
        capacity(): number;
        position(): number;
        position(p0: number): java.nio.Buffer;
        limit(): number;
        limit(p0: number): java.nio.Buffer;
        mark(): java.nio.Buffer;
        reset(): java.nio.Buffer;
        clear(): java.nio.Buffer;
        flip(): java.nio.Buffer;
        rewind(): java.nio.Buffer;
        remaining(): number;
        hasRemaining(): boolean;
        isReadOnly(): boolean;
        hasArray(): boolean;
        array(): any;
        arrayOffset(): number;
        isDirect(): boolean;
        slice(): java.nio.Buffer;
        slice(p0: number, p1: number): java.nio.Buffer;
        duplicate(): java.nio.Buffer;
      }
      const ByteOrder: {
        BIG_ENDIAN: java.nio.ByteOrder;
        LITTLE_ENDIAN: java.nio.ByteOrder;
        nativeOrder(): java.nio.ByteOrder;
      }
      interface ByteOrder { 
      }
      const CharBuffer: {
        allocate(p0: number): java.nio.CharBuffer;
        wrap(p0: Array<number>, p1: number, p2: number): java.nio.CharBuffer;
        wrap(p0: Array<number>): java.nio.CharBuffer;
        wrap(p0: kotlin.CharSequence, p1: number, p2: number): java.nio.CharBuffer;
        wrap(p0: kotlin.CharSequence): java.nio.CharBuffer;
      }
      interface CharBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.CharBuffer>, java.lang.Appendable, kotlin.CharSequence, java.lang.Readable { 
        get(): number;
        get(index: number): number;
        get(p0: Array<number>, p1: number, p2: number): java.nio.CharBuffer;
        get(p0: Array<number>): java.nio.CharBuffer;
        get(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.CharBuffer;
        get(p0: number, p1: Array<number>): java.nio.CharBuffer;
        asReadOnlyBuffer(): java.nio.CharBuffer;
        put(p0: number): java.nio.CharBuffer;
        put(p0: number, p1: number): java.nio.CharBuffer;
        put(p0: java.nio.CharBuffer): java.nio.CharBuffer;
        put(p0: number, p1: java.nio.CharBuffer, p2: number, p3: number): java.nio.CharBuffer;
        put(p0: Array<number>, p1: number, p2: number): java.nio.CharBuffer;
        put(p0: Array<number>): java.nio.CharBuffer;
        put(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.CharBuffer;
        put(p0: number, p1: Array<number>): java.nio.CharBuffer;
        put(p0: string, p1: number, p2: number): java.nio.CharBuffer;
        put(p0: string): java.nio.CharBuffer;
        compact(): java.nio.CharBuffer;
        mismatch(p0: java.nio.CharBuffer): number;
        order(): java.nio.ByteOrder;
      }
      const ShortBuffer: {
        allocate(p0: number): java.nio.ShortBuffer;
        wrap(p0: Array<number>, p1: number, p2: number): java.nio.ShortBuffer;
        wrap(p0: Array<number>): java.nio.ShortBuffer;
      }
      interface ShortBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.ShortBuffer> { 
        asReadOnlyBuffer(): java.nio.ShortBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: Array<number>, p1: number, p2: number): java.nio.ShortBuffer;
        get(p0: Array<number>): java.nio.ShortBuffer;
        get(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.ShortBuffer;
        get(p0: number, p1: Array<number>): java.nio.ShortBuffer;
        put(p0: number): java.nio.ShortBuffer;
        put(p0: number, p1: number): java.nio.ShortBuffer;
        put(p0: java.nio.ShortBuffer): java.nio.ShortBuffer;
        put(p0: number, p1: java.nio.ShortBuffer, p2: number, p3: number): java.nio.ShortBuffer;
        put(p0: Array<number>, p1: number, p2: number): java.nio.ShortBuffer;
        put(p0: Array<number>): java.nio.ShortBuffer;
        put(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.ShortBuffer;
        put(p0: number, p1: Array<number>): java.nio.ShortBuffer;
        compact(): java.nio.ShortBuffer;
        mismatch(p0: java.nio.ShortBuffer): number;
        order(): java.nio.ByteOrder;
      }
      const IntBuffer: {
        allocate(p0: number): java.nio.IntBuffer;
        wrap(p0: Array<number>, p1: number, p2: number): java.nio.IntBuffer;
        wrap(p0: Array<number>): java.nio.IntBuffer;
      }
      interface IntBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.IntBuffer> { 
        asReadOnlyBuffer(): java.nio.IntBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: Array<number>, p1: number, p2: number): java.nio.IntBuffer;
        get(p0: Array<number>): java.nio.IntBuffer;
        get(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.IntBuffer;
        get(p0: number, p1: Array<number>): java.nio.IntBuffer;
        put(p0: number): java.nio.IntBuffer;
        put(p0: number, p1: number): java.nio.IntBuffer;
        put(p0: java.nio.IntBuffer): java.nio.IntBuffer;
        put(p0: number, p1: java.nio.IntBuffer, p2: number, p3: number): java.nio.IntBuffer;
        put(p0: Array<number>, p1: number, p2: number): java.nio.IntBuffer;
        put(p0: Array<number>): java.nio.IntBuffer;
        put(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.IntBuffer;
        put(p0: number, p1: Array<number>): java.nio.IntBuffer;
        compact(): java.nio.IntBuffer;
        mismatch(p0: java.nio.IntBuffer): number;
        order(): java.nio.ByteOrder;
      }
      const LongBuffer: {
        allocate(p0: number): java.nio.LongBuffer;
        wrap(p0: Array<number>, p1: number, p2: number): java.nio.LongBuffer;
        wrap(p0: Array<number>): java.nio.LongBuffer;
      }
      interface LongBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.LongBuffer> { 
        asReadOnlyBuffer(): java.nio.LongBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: Array<number>, p1: number, p2: number): java.nio.LongBuffer;
        get(p0: Array<number>): java.nio.LongBuffer;
        get(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.LongBuffer;
        get(p0: number, p1: Array<number>): java.nio.LongBuffer;
        put(p0: number): java.nio.LongBuffer;
        put(p0: number, p1: number): java.nio.LongBuffer;
        put(p0: java.nio.LongBuffer): java.nio.LongBuffer;
        put(p0: number, p1: java.nio.LongBuffer, p2: number, p3: number): java.nio.LongBuffer;
        put(p0: Array<number>, p1: number, p2: number): java.nio.LongBuffer;
        put(p0: Array<number>): java.nio.LongBuffer;
        put(p0: number, p1: Array<number>, p2: number, p3: number): java.nio.LongBuffer;
        put(p0: number, p1: Array<number>): java.nio.LongBuffer;
        compact(): java.nio.LongBuffer;
        mismatch(p0: java.nio.LongBuffer): number;
        order(): java.nio.ByteOrder;
      }
      const FloatBuffer: {
        allocate(p0: number): java.nio.FloatBuffer;
        wrap(p0: kotlin.FloatArray, p1: number, p2: number): java.nio.FloatBuffer;
        wrap(p0: kotlin.FloatArray): java.nio.FloatBuffer;
      }
      interface FloatBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.FloatBuffer> { 
        asReadOnlyBuffer(): java.nio.FloatBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: kotlin.FloatArray, p1: number, p2: number): java.nio.FloatBuffer;
        get(p0: kotlin.FloatArray): java.nio.FloatBuffer;
        get(p0: number, p1: kotlin.FloatArray, p2: number, p3: number): java.nio.FloatBuffer;
        get(p0: number, p1: kotlin.FloatArray): java.nio.FloatBuffer;
        put(p0: number): java.nio.FloatBuffer;
        put(p0: number, p1: number): java.nio.FloatBuffer;
        put(p0: java.nio.FloatBuffer): java.nio.FloatBuffer;
        put(p0: number, p1: java.nio.FloatBuffer, p2: number, p3: number): java.nio.FloatBuffer;
        put(p0: kotlin.FloatArray, p1: number, p2: number): java.nio.FloatBuffer;
        put(p0: kotlin.FloatArray): java.nio.FloatBuffer;
        put(p0: number, p1: kotlin.FloatArray, p2: number, p3: number): java.nio.FloatBuffer;
        put(p0: number, p1: kotlin.FloatArray): java.nio.FloatBuffer;
        compact(): java.nio.FloatBuffer;
        mismatch(p0: java.nio.FloatBuffer): number;
        order(): java.nio.ByteOrder;
      }
      const DoubleBuffer: {
        allocate(p0: number): java.nio.DoubleBuffer;
        wrap(p0: kotlin.DoubleArray, p1: number, p2: number): java.nio.DoubleBuffer;
        wrap(p0: kotlin.DoubleArray): java.nio.DoubleBuffer;
      }
      interface DoubleBuffer extends java.nio.Buffer, kotlin.Comparable<java.nio.DoubleBuffer> { 
        asReadOnlyBuffer(): java.nio.DoubleBuffer;
        get(): number;
        get(p0: number): number;
        get(p0: kotlin.DoubleArray, p1: number, p2: number): java.nio.DoubleBuffer;
        get(p0: kotlin.DoubleArray): java.nio.DoubleBuffer;
        get(p0: number, p1: kotlin.DoubleArray, p2: number, p3: number): java.nio.DoubleBuffer;
        get(p0: number, p1: kotlin.DoubleArray): java.nio.DoubleBuffer;
        put(p0: number): java.nio.DoubleBuffer;
        put(p0: number, p1: number): java.nio.DoubleBuffer;
        put(p0: java.nio.DoubleBuffer): java.nio.DoubleBuffer;
        put(p0: number, p1: java.nio.DoubleBuffer, p2: number, p3: number): java.nio.DoubleBuffer;
        put(p0: kotlin.DoubleArray, p1: number, p2: number): java.nio.DoubleBuffer;
        put(p0: kotlin.DoubleArray): java.nio.DoubleBuffer;
        put(p0: number, p1: kotlin.DoubleArray, p2: number, p3: number): java.nio.DoubleBuffer;
        put(p0: number, p1: kotlin.DoubleArray): java.nio.DoubleBuffer;
        compact(): java.nio.DoubleBuffer;
        mismatch(p0: java.nio.DoubleBuffer): number;
        order(): java.nio.ByteOrder;
      }
      interface MappedByteBuffer extends java.nio.ByteBuffer { 
        isLoaded(): boolean;
        load(): java.nio.MappedByteBuffer;
        force(): java.nio.MappedByteBuffer;
        force(p0: number, p1: number): java.nio.MappedByteBuffer;
      }
    }
    namespace time {
      namespace temporal {
        interface TemporalAmount { 
          get(p0: java.time.temporal.TemporalUnit): number;
          getUnits(): Array<java.time.temporal.TemporalUnit>;
          addTo(p0: java.time.temporal.Temporal): java.time.temporal.Temporal;
          subtractFrom(p0: java.time.temporal.Temporal): java.time.temporal.Temporal;
        }
        interface TemporalUnit { 
          getDuration(): java.time.Duration;
          isDurationEstimated(): boolean;
          isDateBased(): boolean;
          isTimeBased(): boolean;
          isSupportedBy(p0: java.time.temporal.Temporal): boolean;
          addTo<R>(p0: R, p1: number): R;
          between(p0: java.time.temporal.Temporal, p1: java.time.temporal.Temporal): number;
        }
        interface Temporal extends java.time.temporal.TemporalAccessor { 
          isSupported(p0: java.time.temporal.TemporalUnit): boolean;
          plus(p0: java.time.temporal.TemporalAmount): java.time.temporal.Temporal;
          plus(p0: number, p1: java.time.temporal.TemporalUnit): java.time.temporal.Temporal;
          minus(p0: java.time.temporal.TemporalAmount): java.time.temporal.Temporal;
          minus(p0: number, p1: java.time.temporal.TemporalUnit): java.time.temporal.Temporal;
          until(p0: java.time.temporal.Temporal, p1: java.time.temporal.TemporalUnit): number;
        }
        interface TemporalAccessor { 
          isSupported(p0: java.time.temporal.TemporalField): boolean;
          range(p0: java.time.temporal.TemporalField): java.time.temporal.ValueRange;
          get(p0: java.time.temporal.TemporalField): number;
          getLong(p0: java.time.temporal.TemporalField): number;
          query<R>(p0: java.time.temporal.TemporalQuery<R>): R;
        }
        interface TemporalField { 
          getDisplayName(p0: java.util.Locale): string;
          getBaseUnit(): java.time.temporal.TemporalUnit;
          getRangeUnit(): java.time.temporal.TemporalUnit;
          range(): java.time.temporal.ValueRange;
          isDateBased(): boolean;
          isTimeBased(): boolean;
          isSupportedBy(p0: java.time.temporal.TemporalAccessor): boolean;
          rangeRefinedBy(p0: java.time.temporal.TemporalAccessor): java.time.temporal.ValueRange;
          getFrom(p0: java.time.temporal.TemporalAccessor): number;
          adjustInto<R>(p0: R, p1: number): R;
          resolve(p0: Map<java.time.temporal.TemporalField, number>, p1: java.time.temporal.TemporalAccessor, p2: java.time.format.ResolverStyle): java.time.temporal.TemporalAccessor;
        }
        const ValueRange: {
          of(p0: number, p1: number): java.time.temporal.ValueRange;
          of(p0: number, p1: number, p2: number): java.time.temporal.ValueRange;
          of(p0: number, p1: number, p2: number, p3: number): java.time.temporal.ValueRange;
        }
        interface ValueRange extends java.io.Serializable { 
          isFixed(): boolean;
          getMinimum(): number;
          getLargestMinimum(): number;
          getSmallestMaximum(): number;
          getMaximum(): number;
          isIntValue(): boolean;
          isValidValue(p0: number): boolean;
          isValidIntValue(p0: number): boolean;
          checkValidValue(p0: number, p1: java.time.temporal.TemporalField): number;
          checkValidIntValue(p0: number, p1: java.time.temporal.TemporalField): number;
        }
        interface TemporalQuery<R> { 
          queryFrom(p0: java.time.temporal.TemporalAccessor): R;
          (p0: java.time.temporal.TemporalAccessor): R;
        }
        interface TemporalAdjuster { 
          adjustInto(p0: java.time.temporal.Temporal): java.time.temporal.Temporal;
          (p0: java.time.temporal.Temporal): java.time.temporal.Temporal;
        }
        const ChronoUnit: {
          NANOS: java.time.temporal.ChronoUnit;
          MICROS: java.time.temporal.ChronoUnit;
          MILLIS: java.time.temporal.ChronoUnit;
          SECONDS: java.time.temporal.ChronoUnit;
          MINUTES: java.time.temporal.ChronoUnit;
          HOURS: java.time.temporal.ChronoUnit;
          HALF_DAYS: java.time.temporal.ChronoUnit;
          DAYS: java.time.temporal.ChronoUnit;
          WEEKS: java.time.temporal.ChronoUnit;
          MONTHS: java.time.temporal.ChronoUnit;
          YEARS: java.time.temporal.ChronoUnit;
          DECADES: java.time.temporal.ChronoUnit;
          CENTURIES: java.time.temporal.ChronoUnit;
          MILLENNIA: java.time.temporal.ChronoUnit;
          ERAS: java.time.temporal.ChronoUnit;
          FOREVER: java.time.temporal.ChronoUnit;
          valueOf(value: string): java.time.temporal.ChronoUnit;
          values(): Array<java.time.temporal.ChronoUnit>;
        }
        interface ChronoUnit extends kotlin.Enum<java.time.temporal.ChronoUnit>, java.time.temporal.TemporalUnit { 
        }
        const ChronoField: {
          NANO_OF_SECOND: java.time.temporal.ChronoField;
          NANO_OF_DAY: java.time.temporal.ChronoField;
          MICRO_OF_SECOND: java.time.temporal.ChronoField;
          MICRO_OF_DAY: java.time.temporal.ChronoField;
          MILLI_OF_SECOND: java.time.temporal.ChronoField;
          MILLI_OF_DAY: java.time.temporal.ChronoField;
          SECOND_OF_MINUTE: java.time.temporal.ChronoField;
          SECOND_OF_DAY: java.time.temporal.ChronoField;
          MINUTE_OF_HOUR: java.time.temporal.ChronoField;
          MINUTE_OF_DAY: java.time.temporal.ChronoField;
          HOUR_OF_AMPM: java.time.temporal.ChronoField;
          CLOCK_HOUR_OF_AMPM: java.time.temporal.ChronoField;
          HOUR_OF_DAY: java.time.temporal.ChronoField;
          CLOCK_HOUR_OF_DAY: java.time.temporal.ChronoField;
          AMPM_OF_DAY: java.time.temporal.ChronoField;
          DAY_OF_WEEK: java.time.temporal.ChronoField;
          ALIGNED_DAY_OF_WEEK_IN_MONTH: java.time.temporal.ChronoField;
          ALIGNED_DAY_OF_WEEK_IN_YEAR: java.time.temporal.ChronoField;
          DAY_OF_MONTH: java.time.temporal.ChronoField;
          DAY_OF_YEAR: java.time.temporal.ChronoField;
          EPOCH_DAY: java.time.temporal.ChronoField;
          ALIGNED_WEEK_OF_MONTH: java.time.temporal.ChronoField;
          ALIGNED_WEEK_OF_YEAR: java.time.temporal.ChronoField;
          MONTH_OF_YEAR: java.time.temporal.ChronoField;
          PROLEPTIC_MONTH: java.time.temporal.ChronoField;
          YEAR_OF_ERA: java.time.temporal.ChronoField;
          YEAR: java.time.temporal.ChronoField;
          ERA: java.time.temporal.ChronoField;
          INSTANT_SECONDS: java.time.temporal.ChronoField;
          OFFSET_SECONDS: java.time.temporal.ChronoField;
          valueOf(value: string): java.time.temporal.ChronoField;
          values(): Array<java.time.temporal.ChronoField>;
        }
        interface ChronoField extends kotlin.Enum<java.time.temporal.ChronoField>, java.time.temporal.TemporalField { 
          checkValidValue(p0: number): number;
          checkValidIntValue(p0: number): number;
        }
      }
      namespace format {
        const ResolverStyle: {
          STRICT: java.time.format.ResolverStyle;
          SMART: java.time.format.ResolverStyle;
          LENIENT: java.time.format.ResolverStyle;
          valueOf(value: string): java.time.format.ResolverStyle;
          values(): Array<java.time.format.ResolverStyle>;
        }
        interface ResolverStyle extends kotlin.Enum<java.time.format.ResolverStyle> { 
        }
        const TextStyle: {
          FULL: java.time.format.TextStyle;
          FULL_STANDALONE: java.time.format.TextStyle;
          SHORT: java.time.format.TextStyle;
          SHORT_STANDALONE: java.time.format.TextStyle;
          NARROW: java.time.format.TextStyle;
          NARROW_STANDALONE: java.time.format.TextStyle;
          valueOf(value: string): java.time.format.TextStyle;
          values(): Array<java.time.format.TextStyle>;
        }
        interface TextStyle extends kotlin.Enum<java.time.format.TextStyle> { 
          isStandalone(): boolean;
          asStandalone(): java.time.format.TextStyle;
          asNormal(): java.time.format.TextStyle;
        }
        const DateTimeFormatter: {
          ISO_LOCAL_DATE: java.time.format.DateTimeFormatter;
          ISO_OFFSET_DATE: java.time.format.DateTimeFormatter;
          ISO_DATE: java.time.format.DateTimeFormatter;
          ISO_LOCAL_TIME: java.time.format.DateTimeFormatter;
          ISO_OFFSET_TIME: java.time.format.DateTimeFormatter;
          ISO_TIME: java.time.format.DateTimeFormatter;
          ISO_LOCAL_DATE_TIME: java.time.format.DateTimeFormatter;
          ISO_OFFSET_DATE_TIME: java.time.format.DateTimeFormatter;
          ISO_ZONED_DATE_TIME: java.time.format.DateTimeFormatter;
          ISO_DATE_TIME: java.time.format.DateTimeFormatter;
          ISO_ORDINAL_DATE: java.time.format.DateTimeFormatter;
          ISO_WEEK_DATE: java.time.format.DateTimeFormatter;
          ISO_INSTANT: java.time.format.DateTimeFormatter;
          BASIC_ISO_DATE: java.time.format.DateTimeFormatter;
          RFC_1123_DATE_TIME: java.time.format.DateTimeFormatter;
          ofPattern(p0: string): java.time.format.DateTimeFormatter;
          ofPattern(p0: string, p1: java.util.Locale): java.time.format.DateTimeFormatter;
          ofLocalizedDate(p0: java.time.format.FormatStyle): java.time.format.DateTimeFormatter;
          ofLocalizedTime(p0: java.time.format.FormatStyle): java.time.format.DateTimeFormatter;
          ofLocalizedDateTime(p0: java.time.format.FormatStyle): java.time.format.DateTimeFormatter;
          ofLocalizedDateTime(p0: java.time.format.FormatStyle, p1: java.time.format.FormatStyle): java.time.format.DateTimeFormatter;
          ofLocalizedPattern(p0: string): java.time.format.DateTimeFormatter;
          parsedExcessDays(): java.time.temporal.TemporalQuery<java.time.Period>;
          parsedLeapSecond(): java.time.temporal.TemporalQuery<boolean>;
        }
        interface DateTimeFormatter { 
          getLocale(): java.util.Locale;
          withLocale(p0: java.util.Locale): java.time.format.DateTimeFormatter;
          localizedBy(p0: java.util.Locale): java.time.format.DateTimeFormatter;
          getDecimalStyle(): java.time.format.DecimalStyle;
          withDecimalStyle(p0: java.time.format.DecimalStyle): java.time.format.DateTimeFormatter;
          getChronology(): java.time.chrono.Chronology;
          withChronology(p0: java.time.chrono.Chronology): java.time.format.DateTimeFormatter;
          getZone(): java.time.ZoneId;
          withZone(p0: java.time.ZoneId): java.time.format.DateTimeFormatter;
          getResolverStyle(): java.time.format.ResolverStyle;
          withResolverStyle(p0: java.time.format.ResolverStyle): java.time.format.DateTimeFormatter;
          getResolverFields(): Set<java.time.temporal.TemporalField>;
          withResolverFields(p0: java.time.temporal.TemporalField): java.time.format.DateTimeFormatter;
          withResolverFields(p0: Set<java.time.temporal.TemporalField>): java.time.format.DateTimeFormatter;
          format(p0: java.time.temporal.TemporalAccessor): string;
          formatTo(p0: java.time.temporal.TemporalAccessor, p1: java.lang.Appendable): void;
          parse(p0: kotlin.CharSequence): java.time.temporal.TemporalAccessor;
          parse(p0: kotlin.CharSequence, p1: java.text.ParsePosition): java.time.temporal.TemporalAccessor;
          parse<T>(p0: kotlin.CharSequence, p1: java.time.temporal.TemporalQuery<T>): T;
          parseBest(p0: kotlin.CharSequence, p1: java.time.temporal.TemporalQuery<any>): java.time.temporal.TemporalAccessor;
          parseUnresolved(p0: kotlin.CharSequence, p1: java.text.ParsePosition): java.time.temporal.TemporalAccessor;
          toFormat(): java.text.Format;
          toFormat(p0: java.time.temporal.TemporalQuery<any>): java.text.Format;
        }
        const DecimalStyle: {
          STANDARD: java.time.format.DecimalStyle;
          getAvailableLocales(): Set<java.util.Locale>;
          ofDefaultLocale(): java.time.format.DecimalStyle;
          of(p0: java.util.Locale): java.time.format.DecimalStyle;
        }
        interface DecimalStyle { 
          getZeroDigit(): number;
          withZeroDigit(p0: number): java.time.format.DecimalStyle;
          getPositiveSign(): number;
          withPositiveSign(p0: number): java.time.format.DecimalStyle;
          getNegativeSign(): number;
          withNegativeSign(p0: number): java.time.format.DecimalStyle;
          getDecimalSeparator(): number;
          withDecimalSeparator(p0: number): java.time.format.DecimalStyle;
        }
        const FormatStyle: {
          FULL: java.time.format.FormatStyle;
          LONG: java.time.format.FormatStyle;
          MEDIUM: java.time.format.FormatStyle;
          SHORT: java.time.format.FormatStyle;
          valueOf(value: string): java.time.format.FormatStyle;
          values(): Array<java.time.format.FormatStyle>;
        }
        interface FormatStyle extends kotlin.Enum<java.time.format.FormatStyle> { 
        }
      }
      namespace zone {
        const ZoneRules: {
          of(p0: java.time.ZoneOffset, p1: java.time.ZoneOffset, p2: Array<java.time.zone.ZoneOffsetTransition>, p3: Array<java.time.zone.ZoneOffsetTransition>, p4: Array<unknown>): java.time.zone.ZoneRules;
          of(p0: java.time.ZoneOffset): java.time.zone.ZoneRules;
        }
        interface ZoneRules extends java.io.Serializable { 
          isFixedOffset(): boolean;
          getOffset(p0: java.time.Instant): java.time.ZoneOffset;
          getOffset(p0: java.time.LocalDateTime): java.time.ZoneOffset;
          getValidOffsets(p0: java.time.LocalDateTime): Array<java.time.ZoneOffset>;
          getTransition(p0: java.time.LocalDateTime): java.time.zone.ZoneOffsetTransition;
          getStandardOffset(p0: java.time.Instant): java.time.ZoneOffset;
          getDaylightSavings(p0: java.time.Instant): java.time.Duration;
          isDaylightSavings(p0: java.time.Instant): boolean;
          isValidOffset(p0: java.time.LocalDateTime, p1: java.time.ZoneOffset): boolean;
          nextTransition(p0: java.time.Instant): java.time.zone.ZoneOffsetTransition;
          previousTransition(p0: java.time.Instant): java.time.zone.ZoneOffsetTransition;
          getTransitions(): Array<java.time.zone.ZoneOffsetTransition>;
          getTransitionRules(): Array<unknown>;
        }
        const ZoneOffsetTransition: {
          of(p0: java.time.LocalDateTime, p1: java.time.ZoneOffset, p2: java.time.ZoneOffset): java.time.zone.ZoneOffsetTransition;
        }
        interface ZoneOffsetTransition extends kotlin.Comparable<java.time.zone.ZoneOffsetTransition>, java.io.Serializable { 
          getInstant(): java.time.Instant;
          toEpochSecond(): number;
          getDateTimeBefore(): java.time.LocalDateTime;
          getDateTimeAfter(): java.time.LocalDateTime;
          getOffsetBefore(): java.time.ZoneOffset;
          getOffsetAfter(): java.time.ZoneOffset;
          getDuration(): java.time.Duration;
          isGap(): boolean;
          isOverlap(): boolean;
          isValidOffset(p0: java.time.ZoneOffset): boolean;
        }
      }
      namespace chrono {
        const ChronoLocalDateTime: {
          timeLineOrder(): java.util.Comparator<java.time.chrono.ChronoLocalDateTime<any>>;
          from(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoLocalDateTime<any>;
        }
        interface ChronoLocalDateTime<D> extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.chrono.ChronoLocalDateTime<any>> { 
          getChronology(): java.time.chrono.Chronology;
          toLocalDate(): D;
          toLocalTime(): java.time.LocalTime;
          format(p0: java.time.format.DateTimeFormatter): string;
          atZone(p0: java.time.ZoneId): java.time.chrono.ChronoZonedDateTime<D>;
          toInstant(p0: java.time.ZoneOffset): java.time.Instant;
          toEpochSecond(p0: java.time.ZoneOffset): number;
          isAfter(p0: java.time.chrono.ChronoLocalDateTime<any>): boolean;
          isBefore(p0: java.time.chrono.ChronoLocalDateTime<any>): boolean;
          isEqual(p0: java.time.chrono.ChronoLocalDateTime<any>): boolean;
        }
        const Chronology: {
          from(p0: java.time.temporal.TemporalAccessor): java.time.chrono.Chronology;
          ofLocale(p0: java.util.Locale): java.time.chrono.Chronology;
          of(p0: string): java.time.chrono.Chronology;
          getAvailableChronologies(): Set<java.time.chrono.Chronology>;
        }
        interface Chronology extends kotlin.Comparable<java.time.chrono.Chronology> { 
          getId(): string;
          getCalendarType(): string;
          date(p0: java.time.chrono.Era, p1: number, p2: number, p3: number): java.time.chrono.ChronoLocalDate;
          date(p0: number, p1: number, p2: number): java.time.chrono.ChronoLocalDate;
          date(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoLocalDate;
          dateYearDay(p0: java.time.chrono.Era, p1: number, p2: number): java.time.chrono.ChronoLocalDate;
          dateYearDay(p0: number, p1: number): java.time.chrono.ChronoLocalDate;
          dateEpochDay(p0: number): java.time.chrono.ChronoLocalDate;
          dateNow(): java.time.chrono.ChronoLocalDate;
          dateNow(p0: java.time.ZoneId): java.time.chrono.ChronoLocalDate;
          dateNow(p0: java.time.Clock): java.time.chrono.ChronoLocalDate;
          localDateTime(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoLocalDateTime<java.time.chrono.ChronoLocalDate>;
          zonedDateTime(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoZonedDateTime<java.time.chrono.ChronoLocalDate>;
          zonedDateTime(p0: java.time.Instant, p1: java.time.ZoneId): java.time.chrono.ChronoZonedDateTime<java.time.chrono.ChronoLocalDate>;
          isLeapYear(p0: number): boolean;
          prolepticYear(p0: java.time.chrono.Era, p1: number): number;
          eraOf(p0: number): java.time.chrono.Era;
          eras(): Array<java.time.chrono.Era>;
          range(p0: java.time.temporal.ChronoField): java.time.temporal.ValueRange;
          getDisplayName(p0: java.time.format.TextStyle, p1: java.util.Locale): string;
          resolveDate(p0: Map<java.time.temporal.TemporalField, number>, p1: java.time.format.ResolverStyle): java.time.chrono.ChronoLocalDate;
          period(p0: number, p1: number, p2: number): java.time.chrono.ChronoPeriod;
          epochSecond(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: java.time.ZoneOffset): number;
          epochSecond(p0: java.time.chrono.Era, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: java.time.ZoneOffset): number;
          isIsoBased(): boolean;
        }
        interface Era extends java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster { 
          getValue(): number;
          getDisplayName(p0: java.time.format.TextStyle, p1: java.util.Locale): string;
        }
        const ChronoLocalDate: {
          timeLineOrder(): java.util.Comparator<java.time.chrono.ChronoLocalDate>;
          from(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoLocalDate;
        }
        interface ChronoLocalDate extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.chrono.ChronoLocalDate> { 
          until(p0: java.time.chrono.ChronoLocalDate): java.time.chrono.ChronoPeriod;
          getChronology(): java.time.chrono.Chronology;
          getEra(): java.time.chrono.Era;
          isLeapYear(): boolean;
          lengthOfMonth(): number;
          lengthOfYear(): number;
          format(p0: java.time.format.DateTimeFormatter): string;
          atTime(p0: java.time.LocalTime): java.time.chrono.ChronoLocalDateTime<any>;
          toEpochDay(): number;
          isAfter(p0: java.time.chrono.ChronoLocalDate): boolean;
          isBefore(p0: java.time.chrono.ChronoLocalDate): boolean;
          isEqual(p0: java.time.chrono.ChronoLocalDate): boolean;
        }
        const ChronoPeriod: {
          between(p0: java.time.chrono.ChronoLocalDate, p1: java.time.chrono.ChronoLocalDate): java.time.chrono.ChronoPeriod;
        }
        interface ChronoPeriod extends java.time.temporal.TemporalAmount { 
          getChronology(): java.time.chrono.Chronology;
          isZero(): boolean;
          isNegative(): boolean;
          plus(p0: java.time.temporal.TemporalAmount): java.time.chrono.ChronoPeriod;
          minus(p0: java.time.temporal.TemporalAmount): java.time.chrono.ChronoPeriod;
          multipliedBy(p0: number): java.time.chrono.ChronoPeriod;
          negated(): java.time.chrono.ChronoPeriod;
          normalized(): java.time.chrono.ChronoPeriod;
        }
        const IsoChronology: {
          INSTANCE: java.time.chrono.IsoChronology;
        }
        interface IsoChronology extends java.time.chrono.AbstractChronology, java.io.Serializable { 
        }
        interface AbstractChronology extends java.time.chrono.Chronology { 
        }
        const ChronoZonedDateTime: {
          timeLineOrder(): java.util.Comparator<java.time.chrono.ChronoZonedDateTime<any>>;
          from(p0: java.time.temporal.TemporalAccessor): java.time.chrono.ChronoZonedDateTime<any>;
        }
        interface ChronoZonedDateTime<D> extends java.time.temporal.Temporal, kotlin.Comparable<java.time.chrono.ChronoZonedDateTime<any>> { 
          toLocalDate(): D;
          toLocalTime(): java.time.LocalTime;
          toLocalDateTime(): java.time.chrono.ChronoLocalDateTime<D>;
          getChronology(): java.time.chrono.Chronology;
          getOffset(): java.time.ZoneOffset;
          getZone(): java.time.ZoneId;
          withEarlierOffsetAtOverlap(): java.time.chrono.ChronoZonedDateTime<D>;
          withLaterOffsetAtOverlap(): java.time.chrono.ChronoZonedDateTime<D>;
          withZoneSameLocal(p0: java.time.ZoneId): java.time.chrono.ChronoZonedDateTime<D>;
          withZoneSameInstant(p0: java.time.ZoneId): java.time.chrono.ChronoZonedDateTime<D>;
          format(p0: java.time.format.DateTimeFormatter): string;
          toInstant(): java.time.Instant;
          toEpochSecond(): number;
          isBefore(p0: java.time.chrono.ChronoZonedDateTime<any>): boolean;
          isAfter(p0: java.time.chrono.ChronoZonedDateTime<any>): boolean;
          isEqual(p0: java.time.chrono.ChronoZonedDateTime<any>): boolean;
        }
        const IsoEra: {
          BCE: java.time.chrono.IsoEra;
          CE: java.time.chrono.IsoEra;
          of(p0: number): java.time.chrono.IsoEra;
          valueOf(value: string): java.time.chrono.IsoEra;
          values(): Array<java.time.chrono.IsoEra>;
        }
        interface IsoEra extends kotlin.Enum<java.time.chrono.IsoEra>, java.time.chrono.Era { 
        }
      }
      const Duration: {
        ZERO: java.time.Duration;
        ofDays(p0: number): java.time.Duration;
        ofHours(p0: number): java.time.Duration;
        ofMinutes(p0: number): java.time.Duration;
        ofSeconds(p0: number): java.time.Duration;
        ofSeconds(p0: number, p1: number): java.time.Duration;
        ofMillis(p0: number): java.time.Duration;
        ofNanos(p0: number): java.time.Duration;
        of(p0: number, p1: java.time.temporal.TemporalUnit): java.time.Duration;
        from(p0: java.time.temporal.TemporalAmount): java.time.Duration;
        parse(p0: kotlin.CharSequence): java.time.Duration;
        between(p0: java.time.temporal.Temporal, p1: java.time.temporal.Temporal): java.time.Duration;
      }
      interface Duration extends java.time.temporal.TemporalAmount, kotlin.Comparable<java.time.Duration>, java.io.Serializable { 
        isPositive(): boolean;
        isZero(): boolean;
        isNegative(): boolean;
        getSeconds(): number;
        getNano(): number;
        withSeconds(p0: number): java.time.Duration;
        withNanos(p0: number): java.time.Duration;
        plus(p0: java.time.Duration): java.time.Duration;
        plus(p0: number, p1: java.time.temporal.TemporalUnit): java.time.Duration;
        plusDays(p0: number): java.time.Duration;
        plusHours(p0: number): java.time.Duration;
        plusMinutes(p0: number): java.time.Duration;
        plusSeconds(p0: number): java.time.Duration;
        plusMillis(p0: number): java.time.Duration;
        plusNanos(p0: number): java.time.Duration;
        minus(p0: java.time.Duration): java.time.Duration;
        minus(p0: number, p1: java.time.temporal.TemporalUnit): java.time.Duration;
        minusDays(p0: number): java.time.Duration;
        minusHours(p0: number): java.time.Duration;
        minusMinutes(p0: number): java.time.Duration;
        minusSeconds(p0: number): java.time.Duration;
        minusMillis(p0: number): java.time.Duration;
        minusNanos(p0: number): java.time.Duration;
        multipliedBy(p0: number): java.time.Duration;
        dividedBy(p0: number): java.time.Duration;
        dividedBy(p0: java.time.Duration): number;
        negated(): java.time.Duration;
        abs(): java.time.Duration;
        toDays(): number;
        toHours(): number;
        toMinutes(): number;
        toSeconds(): number;
        toMillis(): number;
        toNanos(): number;
        toDaysPart(): number;
        toHoursPart(): number;
        toMinutesPart(): number;
        toSecondsPart(): number;
        toMillisPart(): number;
        toNanosPart(): number;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.Duration;
      }
      const Instant: {
        EPOCH: java.time.Instant;
        MIN: java.time.Instant;
        MAX: java.time.Instant;
        now(): java.time.Instant;
        now(p0: java.time.Clock): java.time.Instant;
        ofEpochSecond(p0: number): java.time.Instant;
        ofEpochSecond(p0: number, p1: number): java.time.Instant;
        ofEpochMilli(p0: number): java.time.Instant;
        from(p0: java.time.temporal.TemporalAccessor): java.time.Instant;
        parse(p0: kotlin.CharSequence): java.time.Instant;
      }
      interface Instant extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.Instant>, java.io.Serializable { 
        getEpochSecond(): number;
        getNano(): number;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.Instant;
        plusSeconds(p0: number): java.time.Instant;
        plusMillis(p0: number): java.time.Instant;
        plusNanos(p0: number): java.time.Instant;
        minusSeconds(p0: number): java.time.Instant;
        minusMillis(p0: number): java.time.Instant;
        minusNanos(p0: number): java.time.Instant;
        atOffset(p0: java.time.ZoneOffset): java.time.OffsetDateTime;
        atZone(p0: java.time.ZoneId): java.time.ZonedDateTime;
        toEpochMilli(): number;
        isAfter(p0: java.time.Instant): boolean;
        isBefore(p0: java.time.Instant): boolean;
      }
      const ZoneOffset: {
        UTC: java.time.ZoneOffset;
        MIN: java.time.ZoneOffset;
        MAX: java.time.ZoneOffset;
        of(p0: string): java.time.ZoneOffset;
        ofHours(p0: number): java.time.ZoneOffset;
        ofHoursMinutes(p0: number, p1: number): java.time.ZoneOffset;
        ofHoursMinutesSeconds(p0: number, p1: number, p2: number): java.time.ZoneOffset;
        from(p0: java.time.temporal.TemporalAccessor): java.time.ZoneOffset;
        ofTotalSeconds(p0: number): java.time.ZoneOffset;
      }
      interface ZoneOffset extends java.time.ZoneId, java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.ZoneOffset>, java.io.Serializable { 
        getTotalSeconds(): number;
      }
      const ZoneId: {
        SHORT_IDS: Map<string, string>;
        systemDefault(): java.time.ZoneId;
        getAvailableZoneIds(): Set<string>;
        of(p0: string, p1: Map<string, string>): java.time.ZoneId;
        of(p0: string): java.time.ZoneId;
        ofOffset(p0: string, p1: java.time.ZoneOffset): java.time.ZoneId;
        from(p0: java.time.temporal.TemporalAccessor): java.time.ZoneId;
      }
      interface ZoneId extends java.io.Serializable { 
        getId(): string;
        getDisplayName(p0: java.time.format.TextStyle, p1: java.util.Locale): string;
        getRules(): java.time.zone.ZoneRules;
        normalized(): java.time.ZoneId;
      }
      const LocalDateTime: {
        MIN: java.time.LocalDateTime;
        MAX: java.time.LocalDateTime;
        now(): java.time.LocalDateTime;
        now(p0: java.time.ZoneId): java.time.LocalDateTime;
        now(p0: java.time.Clock): java.time.LocalDateTime;
        of(p0: number, p1: java.time.Month, p2: number, p3: number, p4: number): java.time.LocalDateTime;
        of(p0: number, p1: java.time.Month, p2: number, p3: number, p4: number, p5: number): java.time.LocalDateTime;
        of(p0: number, p1: java.time.Month, p2: number, p3: number, p4: number, p5: number, p6: number): java.time.LocalDateTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: number): java.time.LocalDateTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number): java.time.LocalDateTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number): java.time.LocalDateTime;
        of(p0: java.time.LocalDate, p1: java.time.LocalTime): java.time.LocalDateTime;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.LocalDateTime;
        ofEpochSecond(p0: number, p1: number, p2: java.time.ZoneOffset): java.time.LocalDateTime;
        from(p0: java.time.temporal.TemporalAccessor): java.time.LocalDateTime;
        parse(p0: kotlin.CharSequence): java.time.LocalDateTime;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.LocalDateTime;
      }
      interface LocalDateTime extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDateTime<java.time.LocalDate>, java.io.Serializable { 
        getYear(): number;
        getMonthValue(): number;
        getMonth(): java.time.Month;
        getDayOfMonth(): number;
        getDayOfYear(): number;
        getDayOfWeek(): java.time.DayOfWeek;
        getHour(): number;
        getMinute(): number;
        getSecond(): number;
        getNano(): number;
        withYear(p0: number): java.time.LocalDateTime;
        withMonth(p0: number): java.time.LocalDateTime;
        withDayOfMonth(p0: number): java.time.LocalDateTime;
        withDayOfYear(p0: number): java.time.LocalDateTime;
        withHour(p0: number): java.time.LocalDateTime;
        withMinute(p0: number): java.time.LocalDateTime;
        withSecond(p0: number): java.time.LocalDateTime;
        withNano(p0: number): java.time.LocalDateTime;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.LocalDateTime;
        plusYears(p0: number): java.time.LocalDateTime;
        plusMonths(p0: number): java.time.LocalDateTime;
        plusWeeks(p0: number): java.time.LocalDateTime;
        plusDays(p0: number): java.time.LocalDateTime;
        plusHours(p0: number): java.time.LocalDateTime;
        plusMinutes(p0: number): java.time.LocalDateTime;
        plusSeconds(p0: number): java.time.LocalDateTime;
        plusNanos(p0: number): java.time.LocalDateTime;
        minusYears(p0: number): java.time.LocalDateTime;
        minusMonths(p0: number): java.time.LocalDateTime;
        minusWeeks(p0: number): java.time.LocalDateTime;
        minusDays(p0: number): java.time.LocalDateTime;
        minusHours(p0: number): java.time.LocalDateTime;
        minusMinutes(p0: number): java.time.LocalDateTime;
        minusSeconds(p0: number): java.time.LocalDateTime;
        minusNanos(p0: number): java.time.LocalDateTime;
        atOffset(p0: java.time.ZoneOffset): java.time.OffsetDateTime;
      }
      const LocalTime: {
        MIN: java.time.LocalTime;
        MAX: java.time.LocalTime;
        MIDNIGHT: java.time.LocalTime;
        NOON: java.time.LocalTime;
        now(): java.time.LocalTime;
        now(p0: java.time.ZoneId): java.time.LocalTime;
        now(p0: java.time.Clock): java.time.LocalTime;
        of(p0: number, p1: number): java.time.LocalTime;
        of(p0: number, p1: number, p2: number): java.time.LocalTime;
        of(p0: number, p1: number, p2: number, p3: number): java.time.LocalTime;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.LocalTime;
        ofSecondOfDay(p0: number): java.time.LocalTime;
        ofNanoOfDay(p0: number): java.time.LocalTime;
        from(p0: java.time.temporal.TemporalAccessor): java.time.LocalTime;
        parse(p0: kotlin.CharSequence): java.time.LocalTime;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.LocalTime;
      }
      interface LocalTime extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.LocalTime>, java.io.Serializable { 
        getHour(): number;
        getMinute(): number;
        getSecond(): number;
        getNano(): number;
        withHour(p0: number): java.time.LocalTime;
        withMinute(p0: number): java.time.LocalTime;
        withSecond(p0: number): java.time.LocalTime;
        withNano(p0: number): java.time.LocalTime;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.LocalTime;
        plusHours(p0: number): java.time.LocalTime;
        plusMinutes(p0: number): java.time.LocalTime;
        plusSeconds(p0: number): java.time.LocalTime;
        plusNanos(p0: number): java.time.LocalTime;
        minusHours(p0: number): java.time.LocalTime;
        minusMinutes(p0: number): java.time.LocalTime;
        minusSeconds(p0: number): java.time.LocalTime;
        minusNanos(p0: number): java.time.LocalTime;
        format(p0: java.time.format.DateTimeFormatter): string;
        atDate(p0: java.time.LocalDate): java.time.LocalDateTime;
        atOffset(p0: java.time.ZoneOffset): java.time.OffsetTime;
        toSecondOfDay(): number;
        toNanoOfDay(): number;
        toEpochSecond(p0: java.time.LocalDate, p1: java.time.ZoneOffset): number;
        isAfter(p0: java.time.LocalTime): boolean;
        isBefore(p0: java.time.LocalTime): boolean;
      }
      const LocalDate: {
        MIN: java.time.LocalDate;
        MAX: java.time.LocalDate;
        EPOCH: java.time.LocalDate;
        now(): java.time.LocalDate;
        now(p0: java.time.ZoneId): java.time.LocalDate;
        now(p0: java.time.Clock): java.time.LocalDate;
        of(p0: number, p1: java.time.Month, p2: number): java.time.LocalDate;
        of(p0: number, p1: number, p2: number): java.time.LocalDate;
        ofYearDay(p0: number, p1: number): java.time.LocalDate;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.LocalDate;
        ofEpochDay(p0: number): java.time.LocalDate;
        from(p0: java.time.temporal.TemporalAccessor): java.time.LocalDate;
        parse(p0: kotlin.CharSequence): java.time.LocalDate;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.LocalDate;
      }
      interface LocalDate extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDate, java.io.Serializable { 
        atTime(p0: number, p1: number): java.time.LocalDateTime;
        atTime(p0: number, p1: number, p2: number): java.time.LocalDateTime;
        atTime(p0: number, p1: number, p2: number, p3: number): java.time.LocalDateTime;
        atTime(p0: java.time.OffsetTime): java.time.OffsetDateTime;
        getYear(): number;
        getMonthValue(): number;
        getMonth(): java.time.Month;
        getDayOfMonth(): number;
        getDayOfYear(): number;
        getDayOfWeek(): java.time.DayOfWeek;
        withYear(p0: number): java.time.LocalDate;
        withMonth(p0: number): java.time.LocalDate;
        withDayOfMonth(p0: number): java.time.LocalDate;
        withDayOfYear(p0: number): java.time.LocalDate;
        plusYears(p0: number): java.time.LocalDate;
        plusMonths(p0: number): java.time.LocalDate;
        plusWeeks(p0: number): java.time.LocalDate;
        plusDays(p0: number): java.time.LocalDate;
        minusYears(p0: number): java.time.LocalDate;
        minusMonths(p0: number): java.time.LocalDate;
        minusWeeks(p0: number): java.time.LocalDate;
        minusDays(p0: number): java.time.LocalDate;
        datesUntil(p0: java.time.LocalDate): java.util.stream.Stream<java.time.LocalDate>;
        datesUntil(p0: java.time.LocalDate, p1: java.time.Period): java.util.stream.Stream<java.time.LocalDate>;
        atStartOfDay(): java.time.LocalDateTime;
        atStartOfDay(p0: java.time.ZoneId): java.time.ZonedDateTime;
        toEpochSecond(p0: java.time.LocalTime, p1: java.time.ZoneOffset): number;
      }
      const Period: {
        ZERO: java.time.Period;
        ofYears(p0: number): java.time.Period;
        ofMonths(p0: number): java.time.Period;
        ofWeeks(p0: number): java.time.Period;
        ofDays(p0: number): java.time.Period;
        of(p0: number, p1: number, p2: number): java.time.Period;
        from(p0: java.time.temporal.TemporalAmount): java.time.Period;
        parse(p0: kotlin.CharSequence): java.time.Period;
        between(p0: java.time.LocalDate, p1: java.time.LocalDate): java.time.Period;
      }
      interface Period extends java.time.chrono.ChronoPeriod, java.io.Serializable { 
        getYears(): number;
        getMonths(): number;
        getDays(): number;
        withYears(p0: number): java.time.Period;
        withMonths(p0: number): java.time.Period;
        withDays(p0: number): java.time.Period;
        plusYears(p0: number): java.time.Period;
        plusMonths(p0: number): java.time.Period;
        plusDays(p0: number): java.time.Period;
        minusYears(p0: number): java.time.Period;
        minusMonths(p0: number): java.time.Period;
        minusDays(p0: number): java.time.Period;
        toTotalMonths(): number;
      }
      const Clock: {
        systemUTC(): java.time.Clock;
        systemDefaultZone(): java.time.Clock;
        system(p0: java.time.ZoneId): java.time.Clock;
        tickMillis(p0: java.time.ZoneId): java.time.Clock;
        tickSeconds(p0: java.time.ZoneId): java.time.Clock;
        tickMinutes(p0: java.time.ZoneId): java.time.Clock;
        tick(p0: java.time.Clock, p1: java.time.Duration): java.time.Clock;
        fixed(p0: java.time.Instant, p1: java.time.ZoneId): java.time.Clock;
        offset(p0: java.time.Clock, p1: java.time.Duration): java.time.Clock;
      }
      interface Clock extends java.time.InstantSource { 
        getZone(): java.time.ZoneId;
      }
      const InstantSource: {
        system(): java.time.InstantSource;
        tick(p0: java.time.InstantSource, p1: java.time.Duration): java.time.InstantSource;
        fixed(p0: java.time.Instant): java.time.InstantSource;
        offset(p0: java.time.InstantSource, p1: java.time.Duration): java.time.InstantSource;
      }
      interface InstantSource { 
        instant(): java.time.Instant;
        millis(): number;
        withZone(p0: java.time.ZoneId): java.time.Clock;
      }
      const ZonedDateTime: {
        now(): java.time.ZonedDateTime;
        now(p0: java.time.ZoneId): java.time.ZonedDateTime;
        now(p0: java.time.Clock): java.time.ZonedDateTime;
        of(p0: java.time.LocalDate, p1: java.time.LocalTime, p2: java.time.ZoneId): java.time.ZonedDateTime;
        of(p0: java.time.LocalDateTime, p1: java.time.ZoneId): java.time.ZonedDateTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: java.time.ZoneId): java.time.ZonedDateTime;
        ofLocal(p0: java.time.LocalDateTime, p1: java.time.ZoneId, p2: java.time.ZoneOffset): java.time.ZonedDateTime;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.ZonedDateTime;
        ofInstant(p0: java.time.LocalDateTime, p1: java.time.ZoneOffset, p2: java.time.ZoneId): java.time.ZonedDateTime;
        ofStrict(p0: java.time.LocalDateTime, p1: java.time.ZoneOffset, p2: java.time.ZoneId): java.time.ZonedDateTime;
        from(p0: java.time.temporal.TemporalAccessor): java.time.ZonedDateTime;
        parse(p0: kotlin.CharSequence): java.time.ZonedDateTime;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.ZonedDateTime;
      }
      interface ZonedDateTime extends java.time.temporal.Temporal, java.time.chrono.ChronoZonedDateTime<java.time.LocalDate>, java.io.Serializable { 
        withFixedOffsetZone(): java.time.ZonedDateTime;
        getYear(): number;
        getMonthValue(): number;
        getMonth(): java.time.Month;
        getDayOfMonth(): number;
        getDayOfYear(): number;
        getDayOfWeek(): java.time.DayOfWeek;
        getHour(): number;
        getMinute(): number;
        getSecond(): number;
        getNano(): number;
        withYear(p0: number): java.time.ZonedDateTime;
        withMonth(p0: number): java.time.ZonedDateTime;
        withDayOfMonth(p0: number): java.time.ZonedDateTime;
        withDayOfYear(p0: number): java.time.ZonedDateTime;
        withHour(p0: number): java.time.ZonedDateTime;
        withMinute(p0: number): java.time.ZonedDateTime;
        withSecond(p0: number): java.time.ZonedDateTime;
        withNano(p0: number): java.time.ZonedDateTime;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.ZonedDateTime;
        plusYears(p0: number): java.time.ZonedDateTime;
        plusMonths(p0: number): java.time.ZonedDateTime;
        plusWeeks(p0: number): java.time.ZonedDateTime;
        plusDays(p0: number): java.time.ZonedDateTime;
        plusHours(p0: number): java.time.ZonedDateTime;
        plusMinutes(p0: number): java.time.ZonedDateTime;
        plusSeconds(p0: number): java.time.ZonedDateTime;
        plusNanos(p0: number): java.time.ZonedDateTime;
        minusYears(p0: number): java.time.ZonedDateTime;
        minusMonths(p0: number): java.time.ZonedDateTime;
        minusWeeks(p0: number): java.time.ZonedDateTime;
        minusDays(p0: number): java.time.ZonedDateTime;
        minusHours(p0: number): java.time.ZonedDateTime;
        minusMinutes(p0: number): java.time.ZonedDateTime;
        minusSeconds(p0: number): java.time.ZonedDateTime;
        minusNanos(p0: number): java.time.ZonedDateTime;
        toOffsetDateTime(): java.time.OffsetDateTime;
      }
      const Month: {
        JANUARY: java.time.Month;
        FEBRUARY: java.time.Month;
        MARCH: java.time.Month;
        APRIL: java.time.Month;
        MAY: java.time.Month;
        JUNE: java.time.Month;
        JULY: java.time.Month;
        AUGUST: java.time.Month;
        SEPTEMBER: java.time.Month;
        OCTOBER: java.time.Month;
        NOVEMBER: java.time.Month;
        DECEMBER: java.time.Month;
        of(p0: number): java.time.Month;
        from(p0: java.time.temporal.TemporalAccessor): java.time.Month;
        valueOf(value: string): java.time.Month;
        values(): Array<java.time.Month>;
      }
      interface Month extends kotlin.Enum<java.time.Month>, java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster { 
        getValue(): number;
        getDisplayName(p0: java.time.format.TextStyle, p1: java.util.Locale): string;
        plus(p0: number): java.time.Month;
        minus(p0: number): java.time.Month;
        length(p0: boolean): number;
        minLength(): number;
        maxLength(): number;
        firstDayOfYear(p0: boolean): number;
        firstMonthOfQuarter(): java.time.Month;
      }
      const DayOfWeek: {
        MONDAY: java.time.DayOfWeek;
        TUESDAY: java.time.DayOfWeek;
        WEDNESDAY: java.time.DayOfWeek;
        THURSDAY: java.time.DayOfWeek;
        FRIDAY: java.time.DayOfWeek;
        SATURDAY: java.time.DayOfWeek;
        SUNDAY: java.time.DayOfWeek;
        of(p0: number): java.time.DayOfWeek;
        from(p0: java.time.temporal.TemporalAccessor): java.time.DayOfWeek;
        valueOf(value: string): java.time.DayOfWeek;
        values(): Array<java.time.DayOfWeek>;
      }
      interface DayOfWeek extends kotlin.Enum<java.time.DayOfWeek>, java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster { 
        getValue(): number;
        getDisplayName(p0: java.time.format.TextStyle, p1: java.util.Locale): string;
        plus(p0: number): java.time.DayOfWeek;
        minus(p0: number): java.time.DayOfWeek;
      }
      const OffsetDateTime: {
        MIN: java.time.OffsetDateTime;
        MAX: java.time.OffsetDateTime;
        timeLineOrder(): java.util.Comparator<java.time.OffsetDateTime>;
        now(): java.time.OffsetDateTime;
        now(p0: java.time.ZoneId): java.time.OffsetDateTime;
        now(p0: java.time.Clock): java.time.OffsetDateTime;
        of(p0: java.time.LocalDate, p1: java.time.LocalTime, p2: java.time.ZoneOffset): java.time.OffsetDateTime;
        of(p0: java.time.LocalDateTime, p1: java.time.ZoneOffset): java.time.OffsetDateTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: number, p7: java.time.ZoneOffset): java.time.OffsetDateTime;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.OffsetDateTime;
        from(p0: java.time.temporal.TemporalAccessor): java.time.OffsetDateTime;
        parse(p0: kotlin.CharSequence): java.time.OffsetDateTime;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.OffsetDateTime;
      }
      interface OffsetDateTime extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.OffsetDateTime>, java.io.Serializable { 
        getOffset(): java.time.ZoneOffset;
        withOffsetSameLocal(p0: java.time.ZoneOffset): java.time.OffsetDateTime;
        withOffsetSameInstant(p0: java.time.ZoneOffset): java.time.OffsetDateTime;
        toLocalDateTime(): java.time.LocalDateTime;
        toLocalDate(): java.time.LocalDate;
        getYear(): number;
        getMonthValue(): number;
        getMonth(): java.time.Month;
        getDayOfMonth(): number;
        getDayOfYear(): number;
        getDayOfWeek(): java.time.DayOfWeek;
        toLocalTime(): java.time.LocalTime;
        getHour(): number;
        getMinute(): number;
        getSecond(): number;
        getNano(): number;
        withYear(p0: number): java.time.OffsetDateTime;
        withMonth(p0: number): java.time.OffsetDateTime;
        withDayOfMonth(p0: number): java.time.OffsetDateTime;
        withDayOfYear(p0: number): java.time.OffsetDateTime;
        withHour(p0: number): java.time.OffsetDateTime;
        withMinute(p0: number): java.time.OffsetDateTime;
        withSecond(p0: number): java.time.OffsetDateTime;
        withNano(p0: number): java.time.OffsetDateTime;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.OffsetDateTime;
        plusYears(p0: number): java.time.OffsetDateTime;
        plusMonths(p0: number): java.time.OffsetDateTime;
        plusWeeks(p0: number): java.time.OffsetDateTime;
        plusDays(p0: number): java.time.OffsetDateTime;
        plusHours(p0: number): java.time.OffsetDateTime;
        plusMinutes(p0: number): java.time.OffsetDateTime;
        plusSeconds(p0: number): java.time.OffsetDateTime;
        plusNanos(p0: number): java.time.OffsetDateTime;
        minusYears(p0: number): java.time.OffsetDateTime;
        minusMonths(p0: number): java.time.OffsetDateTime;
        minusWeeks(p0: number): java.time.OffsetDateTime;
        minusDays(p0: number): java.time.OffsetDateTime;
        minusHours(p0: number): java.time.OffsetDateTime;
        minusMinutes(p0: number): java.time.OffsetDateTime;
        minusSeconds(p0: number): java.time.OffsetDateTime;
        minusNanos(p0: number): java.time.OffsetDateTime;
        format(p0: java.time.format.DateTimeFormatter): string;
        atZoneSameInstant(p0: java.time.ZoneId): java.time.ZonedDateTime;
        atZoneSimilarLocal(p0: java.time.ZoneId): java.time.ZonedDateTime;
        toOffsetTime(): java.time.OffsetTime;
        toZonedDateTime(): java.time.ZonedDateTime;
        toInstant(): java.time.Instant;
        toEpochSecond(): number;
        isAfter(p0: java.time.OffsetDateTime): boolean;
        isBefore(p0: java.time.OffsetDateTime): boolean;
        isEqual(p0: java.time.OffsetDateTime): boolean;
      }
      const OffsetTime: {
        MIN: java.time.OffsetTime;
        MAX: java.time.OffsetTime;
        now(): java.time.OffsetTime;
        now(p0: java.time.ZoneId): java.time.OffsetTime;
        now(p0: java.time.Clock): java.time.OffsetTime;
        of(p0: java.time.LocalTime, p1: java.time.ZoneOffset): java.time.OffsetTime;
        of(p0: number, p1: number, p2: number, p3: number, p4: java.time.ZoneOffset): java.time.OffsetTime;
        ofInstant(p0: java.time.Instant, p1: java.time.ZoneId): java.time.OffsetTime;
        from(p0: java.time.temporal.TemporalAccessor): java.time.OffsetTime;
        parse(p0: kotlin.CharSequence): java.time.OffsetTime;
        parse(p0: kotlin.CharSequence, p1: java.time.format.DateTimeFormatter): java.time.OffsetTime;
      }
      interface OffsetTime extends java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, kotlin.Comparable<java.time.OffsetTime>, java.io.Serializable { 
        getOffset(): java.time.ZoneOffset;
        withOffsetSameLocal(p0: java.time.ZoneOffset): java.time.OffsetTime;
        withOffsetSameInstant(p0: java.time.ZoneOffset): java.time.OffsetTime;
        toLocalTime(): java.time.LocalTime;
        getHour(): number;
        getMinute(): number;
        getSecond(): number;
        getNano(): number;
        withHour(p0: number): java.time.OffsetTime;
        withMinute(p0: number): java.time.OffsetTime;
        withSecond(p0: number): java.time.OffsetTime;
        withNano(p0: number): java.time.OffsetTime;
        truncatedTo(p0: java.time.temporal.TemporalUnit): java.time.OffsetTime;
        plusHours(p0: number): java.time.OffsetTime;
        plusMinutes(p0: number): java.time.OffsetTime;
        plusSeconds(p0: number): java.time.OffsetTime;
        plusNanos(p0: number): java.time.OffsetTime;
        minusHours(p0: number): java.time.OffsetTime;
        minusMinutes(p0: number): java.time.OffsetTime;
        minusSeconds(p0: number): java.time.OffsetTime;
        minusNanos(p0: number): java.time.OffsetTime;
        format(p0: java.time.format.DateTimeFormatter): string;
        atDate(p0: java.time.LocalDate): java.time.OffsetDateTime;
        toEpochSecond(p0: java.time.LocalDate): number;
        isAfter(p0: java.time.OffsetTime): boolean;
        isBefore(p0: java.time.OffsetTime): boolean;
        isEqual(p0: java.time.OffsetTime): boolean;
      }
    }
    namespace text {
      const NumberFormat: {
        Field: typeof java.text.NumberFormat$Field;
        Style: typeof java.text.NumberFormat$Style;
        INTEGER_FIELD: number;
        FRACTION_FIELD: number;
        getInstance(): java.text.NumberFormat;
        getInstance(p0: java.util.Locale): java.text.NumberFormat;
        getNumberInstance(): java.text.NumberFormat;
        getNumberInstance(p0: java.util.Locale): java.text.NumberFormat;
        getIntegerInstance(): java.text.NumberFormat;
        getIntegerInstance(p0: java.util.Locale): java.text.NumberFormat;
        getCurrencyInstance(): java.text.NumberFormat;
        getCurrencyInstance(p0: java.util.Locale): java.text.NumberFormat;
        getPercentInstance(): java.text.NumberFormat;
        getPercentInstance(p0: java.util.Locale): java.text.NumberFormat;
        getCompactNumberInstance(): java.text.NumberFormat;
        getCompactNumberInstance(p0: java.util.Locale, p1: java.text.NumberFormat$Style): java.text.NumberFormat;
        getAvailableLocales(): Array<java.util.Locale>;
      }
      interface NumberFormat extends java.text.Format { 
        format(p0: number): string;
        format(p0: number): string;
        format(p0: number, p1: java.lang.StringBuffer, p2: java.text.FieldPosition): java.lang.StringBuffer;
        format(p0: number, p1: java.lang.StringBuffer, p2: java.text.FieldPosition): java.lang.StringBuffer;
        parse(p0: string, p1: java.text.ParsePosition): kotlin.Number;
        parse(p0: string): kotlin.Number;
        isParseIntegerOnly(): boolean;
        setParseIntegerOnly(p0: boolean): void;
        isGroupingUsed(): boolean;
        setGroupingUsed(p0: boolean): void;
        getMaximumIntegerDigits(): number;
        setMaximumIntegerDigits(p0: number): void;
        getMinimumIntegerDigits(): number;
        setMinimumIntegerDigits(p0: number): void;
        getMaximumFractionDigits(): number;
        setMaximumFractionDigits(p0: number): void;
        getMinimumFractionDigits(): number;
        setMinimumFractionDigits(p0: number): void;
        getCurrency(): java.util.Currency;
        setCurrency(p0: java.util.Currency): void;
        getRoundingMode(): java.math.RoundingMode;
        setRoundingMode(p0: java.math.RoundingMode): void;
      }
      const Format: {
        Field: typeof java.text.Format$Field;
      }
      interface Format extends java.io.Serializable, kotlin.Cloneable { 
        format(p0: any): string;
        format(p0: any, p1: java.lang.StringBuffer, p2: java.text.FieldPosition): java.lang.StringBuffer;
        formatToCharacterIterator(p0: any): java.text.AttributedCharacterIterator;
        parseObject(p0: string, p1: java.text.ParsePosition): any;
        parseObject(p0: string): any;
      }
      interface Format$Field extends java.text.AttributedCharacterIterator$Attribute { 
      }
      const AttributedCharacterIterator$Attribute: {
        LANGUAGE: java.text.AttributedCharacterIterator$Attribute;
        READING: java.text.AttributedCharacterIterator$Attribute;
        INPUT_METHOD_SEGMENT: java.text.AttributedCharacterIterator$Attribute;
      }
      interface AttributedCharacterIterator$Attribute extends java.io.Serializable { 
      }
      const FieldPosition: {
        new(p0: number): java.text.FieldPosition;
        new(p0: java.text.Format$Field): java.text.FieldPosition;
        new(p0: java.text.Format$Field, p1: number): java.text.FieldPosition;
      }
      interface FieldPosition { 
        getFieldAttribute(): java.text.Format$Field;
        getField(): number;
        getBeginIndex(): number;
        getEndIndex(): number;
        setBeginIndex(p0: number): void;
        setEndIndex(p0: number): void;
      }
      const AttributedCharacterIterator: {
        Attribute: typeof java.text.AttributedCharacterIterator$Attribute;
      }
      interface AttributedCharacterIterator extends java.text.CharacterIterator { 
        getRunStart(): number;
        getRunStart(p0: java.text.AttributedCharacterIterator$Attribute): number;
        getRunStart(p0: Set<java.text.AttributedCharacterIterator$Attribute>): number;
        getRunLimit(): number;
        getRunLimit(p0: java.text.AttributedCharacterIterator$Attribute): number;
        getRunLimit(p0: Set<java.text.AttributedCharacterIterator$Attribute>): number;
        getAttributes(): Map<java.text.AttributedCharacterIterator$Attribute, any>;
        getAttribute(p0: java.text.AttributedCharacterIterator$Attribute): any;
        getAllAttributeKeys(): Set<java.text.AttributedCharacterIterator$Attribute>;
      }
      const CharacterIterator: {
        DONE: number;
      }
      interface CharacterIterator extends kotlin.Cloneable { 
        first(): number;
        last(): number;
        current(): number;
        next(): number;
        previous(): number;
        setIndex(p0: number): number;
        getBeginIndex(): number;
        getEndIndex(): number;
        getIndex(): number;
      }
      const ParsePosition: {
        new(p0: number): java.text.ParsePosition;
      }
      interface ParsePosition { 
        getIndex(): number;
        setIndex(p0: number): void;
        setErrorIndex(p0: number): void;
        getErrorIndex(): number;
      }
      const NumberFormat$Field: {
        INTEGER: java.text.NumberFormat$Field;
        FRACTION: java.text.NumberFormat$Field;
        EXPONENT: java.text.NumberFormat$Field;
        DECIMAL_SEPARATOR: java.text.NumberFormat$Field;
        SIGN: java.text.NumberFormat$Field;
        GROUPING_SEPARATOR: java.text.NumberFormat$Field;
        EXPONENT_SYMBOL: java.text.NumberFormat$Field;
        PERCENT: java.text.NumberFormat$Field;
        PERMILLE: java.text.NumberFormat$Field;
        CURRENCY: java.text.NumberFormat$Field;
        EXPONENT_SIGN: java.text.NumberFormat$Field;
        PREFIX: java.text.NumberFormat$Field;
        SUFFIX: java.text.NumberFormat$Field;
      }
      interface NumberFormat$Field extends java.text.Format$Field { 
      }
      const NumberFormat$Style: {
        SHORT: java.text.NumberFormat$Style;
        LONG: java.text.NumberFormat$Style;
        valueOf(value: string): java.text.NumberFormat$Style;
        values(): Array<java.text.NumberFormat$Style>;
      }
      interface NumberFormat$Style extends kotlin.Enum<java.text.NumberFormat$Style> { 
      }
      const SimpleDateFormat: {
        new(): java.text.SimpleDateFormat;
        new(p0: string): java.text.SimpleDateFormat;
        new(p0: string, p1: java.util.Locale): java.text.SimpleDateFormat;
        new(p0: string, p1: java.text.DateFormatSymbols): java.text.SimpleDateFormat;
      }
      interface SimpleDateFormat extends java.text.DateFormat { 
        set2DigitYearStart(p0: java.util.Date): void;
        get2DigitYearStart(): java.util.Date;
        toPattern(): string;
        toLocalizedPattern(): string;
        applyPattern(p0: string): void;
        applyLocalizedPattern(p0: string): void;
        getDateFormatSymbols(): java.text.DateFormatSymbols;
        setDateFormatSymbols(p0: java.text.DateFormatSymbols): void;
      }
      const DateFormat: {
        Field: typeof java.text.DateFormat$Field;
        ERA_FIELD: number;
        YEAR_FIELD: number;
        MONTH_FIELD: number;
        DATE_FIELD: number;
        HOUR_OF_DAY1_FIELD: number;
        HOUR_OF_DAY0_FIELD: number;
        MINUTE_FIELD: number;
        SECOND_FIELD: number;
        MILLISECOND_FIELD: number;
        DAY_OF_WEEK_FIELD: number;
        DAY_OF_YEAR_FIELD: number;
        DAY_OF_WEEK_IN_MONTH_FIELD: number;
        WEEK_OF_YEAR_FIELD: number;
        WEEK_OF_MONTH_FIELD: number;
        AM_PM_FIELD: number;
        HOUR1_FIELD: number;
        HOUR0_FIELD: number;
        TIMEZONE_FIELD: number;
        FULL: number;
        LONG: number;
        MEDIUM: number;
        SHORT: number;
        DEFAULT: number;
        getTimeInstance(): java.text.DateFormat;
        getTimeInstance(p0: number): java.text.DateFormat;
        getTimeInstance(p0: number, p1: java.util.Locale): java.text.DateFormat;
        getDateInstance(): java.text.DateFormat;
        getDateInstance(p0: number): java.text.DateFormat;
        getDateInstance(p0: number, p1: java.util.Locale): java.text.DateFormat;
        getDateTimeInstance(): java.text.DateFormat;
        getDateTimeInstance(p0: number, p1: number): java.text.DateFormat;
        getDateTimeInstance(p0: number, p1: number, p2: java.util.Locale): java.text.DateFormat;
        getInstance(): java.text.DateFormat;
        getAvailableLocales(): Array<java.util.Locale>;
      }
      interface DateFormat extends java.text.Format { 
        format(p0: java.util.Date, p1: java.lang.StringBuffer, p2: java.text.FieldPosition): java.lang.StringBuffer;
        format(p0: java.util.Date): string;
        parse(p0: string): java.util.Date;
        parse(p0: string, p1: java.text.ParsePosition): java.util.Date;
        setCalendar(p0: java.util.Calendar): void;
        getCalendar(): java.util.Calendar;
        setNumberFormat(p0: java.text.NumberFormat): void;
        getNumberFormat(): java.text.NumberFormat;
        setTimeZone(p0: java.util.TimeZone): void;
        getTimeZone(): java.util.TimeZone;
        setLenient(p0: boolean): void;
        isLenient(): boolean;
      }
      const DateFormat$Field: {
        ERA: java.text.DateFormat$Field;
        YEAR: java.text.DateFormat$Field;
        MONTH: java.text.DateFormat$Field;
        DAY_OF_MONTH: java.text.DateFormat$Field;
        HOUR_OF_DAY1: java.text.DateFormat$Field;
        HOUR_OF_DAY0: java.text.DateFormat$Field;
        MINUTE: java.text.DateFormat$Field;
        SECOND: java.text.DateFormat$Field;
        MILLISECOND: java.text.DateFormat$Field;
        DAY_OF_WEEK: java.text.DateFormat$Field;
        DAY_OF_YEAR: java.text.DateFormat$Field;
        DAY_OF_WEEK_IN_MONTH: java.text.DateFormat$Field;
        WEEK_OF_YEAR: java.text.DateFormat$Field;
        WEEK_OF_MONTH: java.text.DateFormat$Field;
        AM_PM: java.text.DateFormat$Field;
        HOUR1: java.text.DateFormat$Field;
        HOUR0: java.text.DateFormat$Field;
        TIME_ZONE: java.text.DateFormat$Field;
        ofCalendarField(p0: number): java.text.DateFormat$Field;
      }
      interface DateFormat$Field extends java.text.Format$Field { 
        getCalendarField(): number;
      }
      const DateFormatSymbols: {
        getAvailableLocales(): Array<java.util.Locale>;
        getInstance(): java.text.DateFormatSymbols;
        getInstance(p0: java.util.Locale): java.text.DateFormatSymbols;
        new(): java.text.DateFormatSymbols;
        new(p0: java.util.Locale): java.text.DateFormatSymbols;
      }
      interface DateFormatSymbols extends java.io.Serializable, kotlin.Cloneable { 
        getEras(): Array<string>;
        setEras(p0: Array<string>): void;
        getMonths(): Array<string>;
        setMonths(p0: Array<string>): void;
        getShortMonths(): Array<string>;
        setShortMonths(p0: Array<string>): void;
        getWeekdays(): Array<string>;
        setWeekdays(p0: Array<string>): void;
        getShortWeekdays(): Array<string>;
        setShortWeekdays(p0: Array<string>): void;
        getAmPmStrings(): Array<string>;
        setAmPmStrings(p0: Array<string>): void;
        getZoneStrings(): Array<Array<string>>;
        setZoneStrings(p0: Array<Array<string>>): void;
        getLocalPatternChars(): string;
        setLocalPatternChars(p0: string): void;
      }
      const DecimalFormat: {
        new(): java.text.DecimalFormat;
        new(p0: string): java.text.DecimalFormat;
        new(p0: string, p1: java.text.DecimalFormatSymbols): java.text.DecimalFormat;
      }
      interface DecimalFormat extends java.text.NumberFormat { 
        getDecimalFormatSymbols(): java.text.DecimalFormatSymbols;
        setDecimalFormatSymbols(p0: java.text.DecimalFormatSymbols): void;
        getPositivePrefix(): string;
        setPositivePrefix(p0: string): void;
        getNegativePrefix(): string;
        setNegativePrefix(p0: string): void;
        getPositiveSuffix(): string;
        setPositiveSuffix(p0: string): void;
        getNegativeSuffix(): string;
        setNegativeSuffix(p0: string): void;
        getMultiplier(): number;
        setMultiplier(p0: number): void;
        getGroupingSize(): number;
        setGroupingSize(p0: number): void;
        isDecimalSeparatorAlwaysShown(): boolean;
        setDecimalSeparatorAlwaysShown(p0: boolean): void;
        isParseBigDecimal(): boolean;
        setParseBigDecimal(p0: boolean): void;
        toPattern(): string;
        toLocalizedPattern(): string;
        applyPattern(p0: string): void;
        applyLocalizedPattern(p0: string): void;
      }
      const DecimalFormatSymbols: {
        getAvailableLocales(): Array<java.util.Locale>;
        getInstance(): java.text.DecimalFormatSymbols;
        getInstance(p0: java.util.Locale): java.text.DecimalFormatSymbols;
        new(): java.text.DecimalFormatSymbols;
        new(p0: java.util.Locale): java.text.DecimalFormatSymbols;
      }
      interface DecimalFormatSymbols extends kotlin.Cloneable, java.io.Serializable { 
        getLocale(): java.util.Locale;
        getZeroDigit(): number;
        setZeroDigit(p0: number): void;
        getGroupingSeparator(): number;
        setGroupingSeparator(p0: number): void;
        getDecimalSeparator(): number;
        setDecimalSeparator(p0: number): void;
        getPerMill(): number;
        setPerMill(p0: number): void;
        getPercent(): number;
        setPercent(p0: number): void;
        getDigit(): number;
        setDigit(p0: number): void;
        getPatternSeparator(): number;
        setPatternSeparator(p0: number): void;
        getInfinity(): string;
        setInfinity(p0: string): void;
        getNaN(): string;
        setNaN(p0: string): void;
        getMinusSign(): number;
        setMinusSign(p0: number): void;
        getCurrencySymbol(): string;
        setCurrencySymbol(p0: string): void;
        getInternationalCurrencySymbol(): string;
        setInternationalCurrencySymbol(p0: string): void;
        getCurrency(): java.util.Currency;
        setCurrency(p0: java.util.Currency): void;
        getMonetaryDecimalSeparator(): number;
        setMonetaryDecimalSeparator(p0: number): void;
        getExponentSeparator(): string;
        setExponentSeparator(p0: string): void;
        getMonetaryGroupingSeparator(): number;
        setMonetaryGroupingSeparator(p0: number): void;
      }
    }
    namespace math {
      const RoundingMode: {
        UP: java.math.RoundingMode;
        DOWN: java.math.RoundingMode;
        CEILING: java.math.RoundingMode;
        FLOOR: java.math.RoundingMode;
        HALF_UP: java.math.RoundingMode;
        HALF_DOWN: java.math.RoundingMode;
        HALF_EVEN: java.math.RoundingMode;
        UNNECESSARY: java.math.RoundingMode;
        valueOf(p0: number): java.math.RoundingMode;
        valueOf(value: string): java.math.RoundingMode;
        values(): Array<java.math.RoundingMode>;
      }
      interface RoundingMode extends kotlin.Enum<java.math.RoundingMode> { 
      }
      const BigDecimal: {
        ZERO: java.math.BigDecimal;
        ONE: java.math.BigDecimal;
        TWO: java.math.BigDecimal;
        TEN: java.math.BigDecimal;
        ROUND_UP: number;
        ROUND_DOWN: number;
        ROUND_CEILING: number;
        ROUND_FLOOR: number;
        ROUND_HALF_UP: number;
        ROUND_HALF_DOWN: number;
        ROUND_HALF_EVEN: number;
        ROUND_UNNECESSARY: number;
        valueOf(p0: number, p1: number): java.math.BigDecimal;
        valueOf(p0: number): java.math.BigDecimal;
        valueOf(p0: number): java.math.BigDecimal;
        new(p0: Array<number>, p1: number, p2: number): java.math.BigDecimal;
        new(p0: Array<number>, p1: number, p2: number, p3: java.math.MathContext): java.math.BigDecimal;
        new(p0: Array<number>): java.math.BigDecimal;
        new(p0: Array<number>, p1: java.math.MathContext): java.math.BigDecimal;
        new(p0: string): java.math.BigDecimal;
        new(p0: string, p1: java.math.MathContext): java.math.BigDecimal;
        new(p0: number): java.math.BigDecimal;
        new(p0: number, p1: java.math.MathContext): java.math.BigDecimal;
        new(p0: java.math.BigInteger): java.math.BigDecimal;
        new(p0: java.math.BigInteger, p1: java.math.MathContext): java.math.BigDecimal;
        new(p0: java.math.BigInteger, p1: number): java.math.BigDecimal;
        new(p0: java.math.BigInteger, p1: number, p2: java.math.MathContext): java.math.BigDecimal;
        new(p0: number): java.math.BigDecimal;
        new(p0: number, p1: java.math.MathContext): java.math.BigDecimal;
        new(p0: number): java.math.BigDecimal;
        new(p0: number, p1: java.math.MathContext): java.math.BigDecimal;
      }
      interface BigDecimal extends kotlin.Number, kotlin.Comparable<java.math.BigDecimal> { 
        add(p0: java.math.BigDecimal): java.math.BigDecimal;
        add(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        subtract(p0: java.math.BigDecimal): java.math.BigDecimal;
        subtract(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        multiply(p0: java.math.BigDecimal): java.math.BigDecimal;
        multiply(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal, p1: number, p2: number): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal, p1: number, p2: java.math.RoundingMode): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal, p1: number): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal, p1: java.math.RoundingMode): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal): java.math.BigDecimal;
        divide(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        divideToIntegralValue(p0: java.math.BigDecimal): java.math.BigDecimal;
        divideToIntegralValue(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        remainder(p0: java.math.BigDecimal): java.math.BigDecimal;
        remainder(p0: java.math.BigDecimal, p1: java.math.MathContext): java.math.BigDecimal;
        divideAndRemainder(p0: java.math.BigDecimal): Array<java.math.BigDecimal>;
        divideAndRemainder(p0: java.math.BigDecimal, p1: java.math.MathContext): Array<java.math.BigDecimal>;
        sqrt(p0: java.math.MathContext): java.math.BigDecimal;
        pow(p0: number): java.math.BigDecimal;
        pow(p0: number, p1: java.math.MathContext): java.math.BigDecimal;
        abs(): java.math.BigDecimal;
        abs(p0: java.math.MathContext): java.math.BigDecimal;
        negate(): java.math.BigDecimal;
        negate(p0: java.math.MathContext): java.math.BigDecimal;
        plus(): java.math.BigDecimal;
        plus(p0: java.math.MathContext): java.math.BigDecimal;
        signum(): number;
        scale(): number;
        precision(): number;
        unscaledValue(): java.math.BigInteger;
        round(p0: java.math.MathContext): java.math.BigDecimal;
        setScale(p0: number, p1: java.math.RoundingMode): java.math.BigDecimal;
        setScale(p0: number, p1: number): java.math.BigDecimal;
        setScale(p0: number): java.math.BigDecimal;
        movePointLeft(p0: number): java.math.BigDecimal;
        movePointRight(p0: number): java.math.BigDecimal;
        scaleByPowerOfTen(p0: number): java.math.BigDecimal;
        stripTrailingZeros(): java.math.BigDecimal;
        min(p0: java.math.BigDecimal): java.math.BigDecimal;
        max(p0: java.math.BigDecimal): java.math.BigDecimal;
        toEngineeringString(): string;
        toPlainString(): string;
        toBigInteger(): java.math.BigInteger;
        toBigIntegerExact(): java.math.BigInteger;
        longValueExact(): number;
        intValueExact(): number;
        shortValueExact(): number;
        byteValueExact(): number;
        ulp(): java.math.BigDecimal;
      }
      const MathContext: {
        UNLIMITED: java.math.MathContext;
        DECIMAL32: java.math.MathContext;
        DECIMAL64: java.math.MathContext;
        DECIMAL128: java.math.MathContext;
        new(p0: number): java.math.MathContext;
        new(p0: number, p1: java.math.RoundingMode): java.math.MathContext;
        new(p0: string): java.math.MathContext;
      }
      interface MathContext extends java.io.Serializable { 
        getPrecision(): number;
        getRoundingMode(): java.math.RoundingMode;
      }
      const BigInteger: {
        ZERO: java.math.BigInteger;
        ONE: java.math.BigInteger;
        TWO: java.math.BigInteger;
        TEN: java.math.BigInteger;
        probablePrime(p0: number, p1: java.util.Random): java.math.BigInteger;
        valueOf(p0: number): java.math.BigInteger;
        new(p0: Array<number>, p1: number, p2: number): java.math.BigInteger;
        new(p0: Array<number>): java.math.BigInteger;
        new(p0: number, p1: Array<number>, p2: number, p3: number): java.math.BigInteger;
        new(p0: number, p1: Array<number>): java.math.BigInteger;
        new(p0: string, p1: number): java.math.BigInteger;
        new(p0: string): java.math.BigInteger;
        new(p0: number, p1: java.util.Random): java.math.BigInteger;
        new(p0: number, p1: number, p2: java.util.Random): java.math.BigInteger;
      }
      interface BigInteger extends kotlin.Number, kotlin.Comparable<java.math.BigInteger> { 
        nextProbablePrime(): java.math.BigInteger;
        add(p0: java.math.BigInteger): java.math.BigInteger;
        subtract(p0: java.math.BigInteger): java.math.BigInteger;
        multiply(p0: java.math.BigInteger): java.math.BigInteger;
        parallelMultiply(p0: java.math.BigInteger): java.math.BigInteger;
        divide(p0: java.math.BigInteger): java.math.BigInteger;
        divideAndRemainder(p0: java.math.BigInteger): Array<java.math.BigInteger>;
        remainder(p0: java.math.BigInteger): java.math.BigInteger;
        pow(p0: number): java.math.BigInteger;
        sqrt(): java.math.BigInteger;
        sqrtAndRemainder(): Array<java.math.BigInteger>;
        gcd(p0: java.math.BigInteger): java.math.BigInteger;
        abs(): java.math.BigInteger;
        negate(): java.math.BigInteger;
        signum(): number;
        mod(p0: java.math.BigInteger): java.math.BigInteger;
        modPow(p0: java.math.BigInteger, p1: java.math.BigInteger): java.math.BigInteger;
        modInverse(p0: java.math.BigInteger): java.math.BigInteger;
        shiftLeft(p0: number): java.math.BigInteger;
        shiftRight(p0: number): java.math.BigInteger;
        and(p0: java.math.BigInteger): java.math.BigInteger;
        or(p0: java.math.BigInteger): java.math.BigInteger;
        xor(p0: java.math.BigInteger): java.math.BigInteger;
        not(): java.math.BigInteger;
        andNot(p0: java.math.BigInteger): java.math.BigInteger;
        testBit(p0: number): boolean;
        setBit(p0: number): java.math.BigInteger;
        clearBit(p0: number): java.math.BigInteger;
        flipBit(p0: number): java.math.BigInteger;
        getLowestSetBit(): number;
        bitLength(): number;
        bitCount(): number;
        isProbablePrime(p0: number): boolean;
        min(p0: java.math.BigInteger): java.math.BigInteger;
        max(p0: java.math.BigInteger): java.math.BigInteger;
        toByteArray(): Array<number>;
        longValueExact(): number;
        intValueExact(): number;
        shortValueExact(): number;
        byteValueExact(): number;
      }
    }
    namespace beans {
      interface PropertyChangeListener extends java.util.EventListener { 
        propertyChange(p0: java.beans.PropertyChangeEvent): void;
      }
      const PropertyChangeEvent: {
        new(p0: any, p1: string, p2: any, p3: any): java.beans.PropertyChangeEvent;
      }
      interface PropertyChangeEvent extends java.util.EventObject { 
        getPropertyName(): string;
        getNewValue(): any;
        getOldValue(): any;
        setPropagationId(p0: any): void;
        getPropagationId(): any;
      }
      const PropertyChangeSupport: {
        new(p0: any): java.beans.PropertyChangeSupport;
      }
      interface PropertyChangeSupport extends java.io.Serializable { 
        addPropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        addPropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: string, p1: java.beans.PropertyChangeListener): void;
        getPropertyChangeListeners(): Array<java.beans.PropertyChangeListener>;
        getPropertyChangeListeners(p0: string): Array<java.beans.PropertyChangeListener>;
        firePropertyChange(p0: string, p1: any, p2: any): void;
        firePropertyChange(p0: string, p1: number, p2: number): void;
        firePropertyChange(p0: string, p1: boolean, p2: boolean): void;
        firePropertyChange(p0: java.beans.PropertyChangeEvent): void;
        fireIndexedPropertyChange(p0: string, p1: number, p2: any, p3: any): void;
        fireIndexedPropertyChange(p0: string, p1: number, p2: number, p3: number): void;
        fireIndexedPropertyChange(p0: string, p1: number, p2: boolean, p3: boolean): void;
        hasListeners(p0: string): boolean;
      }
    }
  }
  namespace kotlin {
    namespace collections {
      interface MutableIterator<T> extends kotlin.collections.Iterator<T> { 
        remove(): void;
      }
      interface Iterator<T> { 
        forEachRemaining(p0: unknown): void;
        hasNext(): boolean;
        next(): T;
      }
      const DoubleIterator: {
        new(): kotlin.collections.DoubleIterator;
      }
      interface DoubleIterator extends kotlin.collections.Iterator<number> { 
        nextDouble(): number;
      }
      const LongIterator: {
        new(): kotlin.collections.LongIterator;
      }
      interface LongIterator extends kotlin.collections.Iterator<number> { 
        nextLong(): number;
      }
      interface MutableList<E> extends Array<E>, Array<E> { 
        add(index: number, element: E): void;
        addAll(index: number, elements: Array<E>): boolean;
        removeAt(index: number): E;
        replaceAll(p0: unknown): void;
        set(index: number, element: E): E;
        sort(p0: java.util.Comparator<E>): void;
      }
      interface List<E> extends Array<E> { 
        get(index: number): E;
        indexOf(element: E): number;
        lastIndexOf(element: E): number;
        listIterator(): kotlin.collections.ListIterator<E>;
        listIterator(index: number): kotlin.collections.ListIterator<E>;
        subList(fromIndex: number, toIndex: number): Array<E>;
      }
      interface Collection<E> extends kotlin.collections.Iterable<E> { 
        size(): number;
        contains(element: E): boolean;
        containsAll(elements: Array<E>): boolean;
        isEmpty(): boolean;
        parallelStream(): java.util.stream.Stream<E>;
        stream(): java.util.stream.Stream<E>;
        toArray<T>(p0: unknown): Array<T>;
      }
      interface Iterable<T> { 
        forEach(p0: unknown): void;
        iterator(): kotlin.collections.Iterator<T>;
        spliterator(): java.util.Spliterator<T>;
      }
      interface ListIterator<T> extends kotlin.collections.Iterator<T> { 
        hasPrevious(): boolean;
        nextIndex(): number;
        previous(): T;
        previousIndex(): number;
      }
      interface MutableCollection<E> extends Array<E>, kotlin.collections.MutableIterable<E> { 
        add(element: E): boolean;
        addAll(elements: Array<E>): boolean;
        clear(): void;
        remove(element: E): boolean;
        removeAll(elements: Array<E>): boolean;
        removeIf(p0: unknown): boolean;
        retainAll(elements: Array<E>): boolean;
      }
      interface MutableIterable<T> extends kotlin.collections.Iterable<T> { 
      }
      interface MutableListIterator<T> extends kotlin.collections.ListIterator<T>, kotlin.collections.MutableIterator<T> { 
        add(element: T): void;
        set(element: T): void;
      }
      const ByteIterator: {
        new(): kotlin.collections.ByteIterator;
      }
      interface ByteIterator extends kotlin.collections.Iterator<number> { 
        nextByte(): number;
      }
      interface MutableMap<K, V> extends Map<K, V> { 
        clear(): void;
        compute(p0: K, p1: unknown): V;
        computeIfAbsent(p0: K, p1: unknown): V;
        computeIfPresent(p0: K, p1: unknown): V;
        merge(p0: K, p1: V, p2: unknown): V;
        put(key: K, value: V): V;
        putAll(from: Map<K, V>): void;
        putIfAbsent(p0: K, p1: V): V;
        remove(key: K): V;
        remove(key: K, value: V): boolean;
        replace(p0: K, p1: V, p2: V): boolean;
        replace(p0: K, p1: V): V;
        replaceAll(p0: unknown): void;
      }
      interface Map<K, V> { 
        entrySet(): Set<kotlin.collections.Map$Entry<K, V>>;
        keySet(): Set<K>;
        size(): number;
        values(): Array<V>;
        containsKey(key: K): boolean;
        containsValue(value: V): boolean;
        forEach(p0: unknown): void;
        get(key: K): V;
        getOrDefault(key: K, defaultValue: V): V;
        isEmpty(): boolean;
      }
      interface Set<E> extends Array<E> { 
      }
      interface Map$Entry<K, V> { 
        getKey(): K;
        getValue(): V;
      }
      interface MutableSet<E> extends Set<E>, Array<E> { 
      }
      interface MutableMap$MutableEntry<K, V> extends kotlin.collections.Map$Entry<K, V> { 
        setValue(newValue: V): V;
      }
      const CharIterator: {
        new(): kotlin.collections.CharIterator;
      }
      interface CharIterator extends kotlin.collections.Iterator<number> { 
        nextChar(): number;
      }
      const ShortIterator: {
        new(): kotlin.collections.ShortIterator;
      }
      interface ShortIterator extends kotlin.collections.Iterator<number> { 
        nextShort(): number;
      }
      const IntIterator: {
        new(): kotlin.collections.IntIterator;
      }
      interface IntIterator extends kotlin.collections.Iterator<number> { 
        nextInt(): number;
      }
      const FloatIterator: {
        new(): kotlin.collections.FloatIterator;
      }
      interface FloatIterator extends kotlin.collections.Iterator<number> { 
        nextFloat(): number;
      }
      const BooleanIterator: {
        new(): kotlin.collections.BooleanIterator;
      }
      interface BooleanIterator extends kotlin.collections.Iterator<boolean> { 
        nextBoolean(): boolean;
      }
    }
    namespace ranges {
      const CharRange: {
        new(start: number, endInclusive: number): kotlin.ranges.CharRange;
      }
      interface CharRange extends kotlin.ranges.CharProgression, kotlin.ranges.ClosedRange<number>, kotlin.ranges.OpenEndRange<number> { 
      }
      interface CharProgression extends kotlin.collections.Iterable<number> { 
        getFirst(): number;
        getLast(): number;
        getStep(): number;
        isEmpty(): boolean;
      }
      interface CharProgression$Companion { 
        fromClosedRange(rangeStart: number, rangeEnd: number, step: number): kotlin.ranges.CharProgression;
      }
      interface ClosedRange<T> { 
        getEndInclusive(): T;
        getStart(): T;
        contains(value: T): boolean;
        isEmpty(): boolean;
      }
      interface OpenEndRange<T> { 
        getEndExclusive(): T;
        getStart(): T;
        contains(value: T): boolean;
        isEmpty(): boolean;
      }
      interface CharRange$Companion { 
        getEMPTY(): kotlin.ranges.CharRange;
      }
      const LongRange: {
        new(start: number, endInclusive: number): kotlin.ranges.LongRange;
      }
      interface LongRange extends kotlin.ranges.LongProgression, kotlin.ranges.ClosedRange<number>, kotlin.ranges.OpenEndRange<number> { 
      }
      interface LongProgression extends kotlin.collections.Iterable<number> { 
        getFirst(): number;
        getLast(): number;
        getStep(): number;
        isEmpty(): boolean;
      }
      interface LongProgression$Companion { 
        fromClosedRange(rangeStart: number, rangeEnd: number, step: number): kotlin.ranges.LongProgression;
      }
      interface LongRange$Companion { 
        getEMPTY(): kotlin.ranges.LongRange;
      }
      const IntRange: {
        new(start: number, endInclusive: number): kotlin.ranges.IntRange;
      }
      interface IntRange extends kotlin.ranges.IntProgression, kotlin.ranges.ClosedRange<number>, kotlin.ranges.OpenEndRange<number> { 
      }
      interface IntProgression extends kotlin.collections.Iterable<number> { 
        getFirst(): number;
        getLast(): number;
        getStep(): number;
        isEmpty(): boolean;
      }
      interface IntProgression$Companion { 
        fromClosedRange(rangeStart: number, rangeEnd: number, step: number): kotlin.ranges.IntProgression;
      }
      interface IntRange$Companion { 
        getEMPTY(): kotlin.ranges.IntRange;
      }
    }
    namespace reflect {
      interface KClass<T> extends kotlin.reflect.KDeclarationContainer, kotlin.reflect.KAnnotatedElement, kotlin.reflect.KClassifier { 
        getConstructors(): Array<kotlin.reflect.KFunction<T>>;
        isAbstract(): boolean;
        isCompanion(): boolean;
        isData(): boolean;
        isFinal(): boolean;
        isFun(): boolean;
        isInner(): boolean;
        isOpen(): boolean;
        isSealed(): boolean;
        isValue(): boolean;
        getNestedClasses(): Array<kotlin.reflect.KClass<any>>;
        getObjectInstance(): T;
        getQualifiedName(): string | null | undefined;
        getSealedSubclasses(): Array<kotlin.reflect.KClass<T>>;
        getSimpleName(): string | null | undefined;
        getSupertypes(): Array<kotlin.reflect.KType>;
        getTypeParameters(): Array<unknown>;
        getVisibility(): kotlin.reflect.KVisibility | null | undefined;
        isInstance(value: any | null | undefined): boolean;
      }
      interface KDeclarationContainer { 
        getMembers(): Array<kotlin.reflect.KCallable<any>>;
      }
      interface KAnnotatedElement { 
        getAnnotations(): Array<kotlin.Annotation>;
      }
      interface KClassifier { 
      }
      const KVisibility: {
        PUBLIC: kotlin.reflect.KVisibility;
        PROTECTED: kotlin.reflect.KVisibility;
        INTERNAL: kotlin.reflect.KVisibility;
        PRIVATE: kotlin.reflect.KVisibility;
        valueOf(value: string): kotlin.reflect.KVisibility;
        values(): Array<kotlin.reflect.KVisibility>;
      }
      interface KVisibility extends kotlin.Enum<kotlin.reflect.KVisibility> { 
      }
      interface KProperty<V> extends kotlin.reflect.KCallable<V> { 
        getGetter(): kotlin.reflect.KProperty$Getter<V>;
        isConst(): boolean;
        isLateinit(): boolean;
      }
      interface KCallable<R> extends kotlin.reflect.KAnnotatedElement { 
        isAbstract(): boolean;
        isFinal(): boolean;
        isOpen(): boolean;
        isSuspend(): boolean;
        getName(): string;
        getParameters(): Array<unknown>;
        getReturnType(): kotlin.reflect.KType;
        getTypeParameters(): Array<unknown>;
        getVisibility(): kotlin.reflect.KVisibility | null | undefined;
        call(args: any | null | undefined): R;
        callBy(args: Map<unknown, any | null | undefined>): R;
      }
      interface KType extends kotlin.reflect.KAnnotatedElement { 
        getArguments(): Array<unknown>;
        getClassifier(): kotlin.reflect.KClassifier | null | undefined;
        isMarkedNullable(): boolean;
      }
      interface KProperty$Getter<V> extends kotlin.reflect.KProperty$Accessor<V>, kotlin.reflect.KFunction<V> { 
      }
      interface KProperty$Accessor<V> { 
        getProperty(): kotlin.reflect.KProperty<V>;
      }
      interface KFunction<R> extends kotlin.reflect.KCallable<R>, kotlin.Function<R> { 
        isExternal(): boolean;
        isInfix(): boolean;
        isInline(): boolean;
        isOperator(): boolean;
      }
      interface KMutableProperty0<V> extends kotlin.reflect.KProperty0<V>, kotlin.reflect.KMutableProperty<V> { 
        set(value: V): void;
      }
      interface KProperty0<V> extends kotlin.reflect.KProperty<V>, kotlin.Function0<V> { 
        get(): V;
        getDelegate(): any | null | undefined;
      }
      interface KProperty0$Getter<V> extends kotlin.reflect.KProperty$Getter<V>, kotlin.Function0<V> { 
      }
      interface KMutableProperty<V> extends kotlin.reflect.KProperty<V> { 
        getSetter(): kotlin.reflect.KMutableProperty$Setter<V>;
      }
      interface KMutableProperty$Setter<V> extends kotlin.reflect.KProperty$Accessor<V>, kotlin.reflect.KFunction<void> { 
      }
      interface KMutableProperty0$Setter<V> extends kotlin.reflect.KMutableProperty$Setter<V>, kotlin.Function1<V, void> { 
      }
    }
    const Any: {
      new(): any;
    }
    interface Any { 
    }
    interface Boolean extends kotlin.Comparable<boolean>, java.io.Serializable { 
      and(other: boolean): boolean;
      describeConstable(): java.util.Optional<java.lang.constant.DynamicConstantDesc<boolean>>;
      not(): boolean;
      or(other: boolean): boolean;
      xor(other: boolean): boolean;
    }
    interface Comparable<T> { 
    }
    interface Int extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      and(other: number): number;
      dec(): number;
      describeConstable(): java.util.Optional<number>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      inv(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      or(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): number;
      shl(bitCount: number): number;
      shr(bitCount: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
      ushr(bitCount: number): number;
      xor(other: number): number;
    }
    const Number: {
      new(): number;
    }
    interface Number extends java.io.Serializable { 
      toByte(): number;
      toChar(): number;
      toDouble(): number;
      toFloat(): number;
      toInt(): number;
      toLong(): number;
      toShort(): number;
    }
    interface Byte extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      dec(): number;
      describeConstable(): java.util.Optional<java.lang.constant.DynamicConstantDesc<number>>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
    }
    interface Short extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      dec(): number;
      describeConstable(): java.util.Optional<java.lang.constant.DynamicConstantDesc<number>>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.IntRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.IntRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
    }
    interface Long extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      and(other: number): number;
      dec(): number;
      describeConstable(): java.util.Optional<number>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      inv(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      or(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeTo(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rangeUntil(other: number): kotlin.ranges.LongRange;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): number;
      shl(bitCount: number): number;
      shr(bitCount: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
      ushr(bitCount: number): number;
      xor(other: number): number;
    }
    interface Float extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      dec(): number;
      describeConstable(): java.util.Optional<number>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
    }
    interface Double extends kotlin.Number, kotlin.Comparable<number>, java.io.Serializable { 
      dec(): number;
      describeConstable(): java.util.Optional<number>;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      div(other: number): number;
      inc(): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      minus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      plus(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      rem(other: number): number;
      resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      times(other: number): number;
      unaryMinus(): number;
      unaryPlus(): number;
    }
    const String: {
      new(): string;
    }
    interface String extends kotlin.Comparable<string>, kotlin.CharSequence, java.io.Serializable { 
      describeConstable(): java.util.Optional<string>;
      formatted(p0: any): string;
      indent(p0: number): string;
      indexOf(p0: number, p1: number, p2: number): number;
      indexOf(p0: string, p1: number, p2: number): number;
      plus(other: any | null | undefined): string;
      resolveConstantDesc(p0: java.lang.invoke.MethodHandles$Lookup): string;
      splitWithDelimiters(p0: string, p1: number): Array<string>;
      strip(): string;
      stripIndent(): string;
      stripLeading(): string;
      stripTrailing(): string;
      transform<R>(p0: unknown): R;
      translateEscapes(): string;
    }
    interface CharSequence { 
      length(): number;
      chars(): java.util.stream.IntStream;
      codePoints(): java.util.stream.IntStream;
      get(index: number): number;
      isEmpty(): boolean;
      subSequence(startIndex: number, endIndex: number): kotlin.CharSequence;
    }
    interface Unit { 
    }
    const DoubleArray: {
      new(size: number, init: kotlin.Function1<number, number>): kotlin.DoubleArray;
      new(size: number): kotlin.DoubleArray;
    }
    interface DoubleArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.DoubleIterator;
      set(index: number, value: number): void;
    }
    interface Cloneable { 
    }
    interface Function1<P1, R> extends kotlin.Function<R> { 
      invoke(p1: P1): R;
      (p1: P1): R;
    }
    interface Function<R> { 
    }
    const LongArray: {
      new(size: number, init: kotlin.Function1<number, number>): Array<number>;
      new(size: number): Array<number>;
    }
    interface LongArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.LongIterator;
      set(index: number, value: number): void;
    }
    const Array: {
      new<T>(size: number, init: kotlin.Function1<number, T>): Array<T>;
    }
    interface Array<T> extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): T;
      iterator(): kotlin.collections.Iterator<T>;
      set(index: number, value: T): void;
    }
    const Enum: {
      new<E>(name: string, ordinal: number): kotlin.Enum<E>;
    }
    interface Enum<E> extends kotlin.Comparable<E>, java.io.Serializable { 
      name(): string;
      ordinal(): number;
      getDeclaringClass(): java.lang.Class<E>;
    }
    const ByteArray: {
      new(size: number, init: kotlin.Function1<number, number>): Array<number>;
      new(size: number): Array<number>;
    }
    interface ByteArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.ByteIterator;
      set(index: number, value: number): void;
    }
    interface Char extends kotlin.Comparable<number>, java.io.Serializable { 
      dec(): number;
      describeConstable(): java.util.Optional<java.lang.constant.DynamicConstantDesc<number>>;
      inc(): number;
      minus(other: number): number;
      minus(other: number): number;
      plus(other: number): number;
      rangeTo(other: number): kotlin.ranges.CharRange;
      rangeUntil(other: number): kotlin.ranges.CharRange;
      toByte(): number;
      toChar(): number;
      toDouble(): number;
      toFloat(): number;
      toInt(): number;
      toLong(): number;
      toShort(): number;
    }
    interface Char$Companion { 
      getMAX_HIGH_SURROGATE(): number;
      getMAX_LOW_SURROGATE(): number;
      getMAX_SURROGATE(): number;
      getMAX_VALUE(): number;
      getMIN_HIGH_SURROGATE(): number;
      getMIN_LOW_SURROGATE(): number;
      getMIN_SURROGATE(): number;
      getMIN_VALUE(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    const CharArray: {
      new(size: number, init: kotlin.Function1<number, number>): Array<number>;
      new(size: number): Array<number>;
    }
    interface CharArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.CharIterator;
      set(index: number, value: number): void;
    }
    const ShortArray: {
      new(size: number, init: kotlin.Function1<number, number>): Array<number>;
      new(size: number): Array<number>;
    }
    interface ShortArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.ShortIterator;
      set(index: number, value: number): void;
    }
    const IntArray: {
      new(size: number, init: kotlin.Function1<number, number>): Array<number>;
      new(size: number): Array<number>;
    }
    interface IntArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.IntIterator;
      set(index: number, value: number): void;
    }
    const FloatArray: {
      new(size: number, init: kotlin.Function1<number, number>): kotlin.FloatArray;
      new(size: number): kotlin.FloatArray;
    }
    interface FloatArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): number;
      iterator(): kotlin.collections.FloatIterator;
      set(index: number, value: number): void;
    }
    const Throwable: {
      new(message: string | null | undefined): kotlin.Throwable;
      new(cause: kotlin.Throwable | null | undefined): kotlin.Throwable;
      new(): kotlin.Throwable;
      new(message: string | null | undefined, cause: kotlin.Throwable | null | undefined): kotlin.Throwable;
    }
    interface Throwable extends java.io.Serializable { 
      getCause(): kotlin.Throwable | null | undefined;
      getMessage(): string | null | undefined;
      addSuppressed(p0: kotlin.Throwable): void;
      fillInStackTrace(): kotlin.Throwable;
      getLocalizedMessage(): string;
      getStackTrace(): Array<java.lang.StackTraceElement>;
      getSuppressed(): Array<kotlin.Throwable>;
      initCause(p0: kotlin.Throwable): kotlin.Throwable;
      printStackTrace(): void;
      printStackTrace(p0: java.io.PrintStream): void;
      printStackTrace(p0: java.io.PrintWriter): void;
      setStackTrace(p0: Array<java.lang.StackTraceElement>): void;
    }
    interface Enum$Companion { 
    }
    interface String$Companion { 
    }
    interface Double$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getNEGATIVE_INFINITY(): number;
      getNaN(): number;
      getPOSITIVE_INFINITY(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Float$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getNEGATIVE_INFINITY(): number;
      getNaN(): number;
      getPOSITIVE_INFINITY(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Long$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Short$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Byte$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Int$Companion { 
      getMAX_VALUE(): number;
      getMIN_VALUE(): number;
      getSIZE_BITS(): number;
      getSIZE_BYTES(): number;
    }
    interface Boolean$Companion { 
    }
    const BooleanArray: {
      new(size: number, init: kotlin.Function1<number, boolean>): kotlin.BooleanArray;
      new(size: number): kotlin.BooleanArray;
    }
    interface BooleanArray extends kotlin.Cloneable, java.io.Serializable { 
      getSize(): number;
      get(index: number): boolean;
      iterator(): kotlin.collections.BooleanIterator;
      set(index: number, value: boolean): void;
    }
    interface Annotation { 
    }
    interface Nothing { 
    }
    interface Function0<R> extends kotlin.Function<R> { 
      invoke(): R;
      (): R;
    }
    const Pair: {
      new<A, B>(first: A, second: B): kotlin.Pair<A, B>;
    }
    interface Pair<A, B> extends java.io.Serializable { 
      getFirst(): A;
      getSecond(): B;
      component1(): A;
      component2(): B;
      copy(first: A, second: B): kotlin.Pair<A, B>;
    }
    interface Function2<P1, P2, R> extends kotlin.Function<R> { 
      invoke(p1: P1, p2: P2): R;
      (p1: P1, p2: P2): R;
    }
    interface Function3<P1, P2, P3, R> extends kotlin.Function<R> { 
      invoke(p1: P1, p2: P2, p3: P3): R;
      (p1: P1, p2: P2, p3: P3): R;
    }
    interface Function4<P1, P2, P3, P4, R> extends kotlin.Function<R> { 
      invoke(p1: P1, p2: P2, p3: P3, p4: P4): R;
      (p1: P1, p2: P2, p3: P3, p4: P4): R;
    }
  }
  namespace javax {
    namespace security {
      namespace auth {
        const Subject: {
          getSubject(p0: java.security.AccessControlContext): javax.security.auth.Subject;
          current(): javax.security.auth.Subject;
          callAs<T>(p0: javax.security.auth.Subject, p1: java.util.concurrent.Callable<T>): T;
          doAs<T>(p0: javax.security.auth.Subject, p1: java.security.PrivilegedAction<T>): T;
          doAs<T>(p0: javax.security.auth.Subject, p1: java.security.PrivilegedExceptionAction<T>): T;
          doAsPrivileged<T>(p0: javax.security.auth.Subject, p1: java.security.PrivilegedAction<T>, p2: java.security.AccessControlContext): T;
          doAsPrivileged<T>(p0: javax.security.auth.Subject, p1: java.security.PrivilegedExceptionAction<T>, p2: java.security.AccessControlContext): T;
          new(): javax.security.auth.Subject;
          new(p0: boolean, p1: Set<java.security.Principal>, p2: Set<any>, p3: Set<any>): javax.security.auth.Subject;
        }
        interface Subject extends java.io.Serializable { 
          setReadOnly(): void;
          isReadOnly(): boolean;
          getPrincipals(): Set<java.security.Principal>;
          getPrincipals<T>(p0: java.lang.Class<T>): Set<T>;
          getPublicCredentials(): Set<any>;
          getPublicCredentials<T>(p0: java.lang.Class<T>): Set<T>;
          getPrivateCredentials(): Set<any>;
          getPrivateCredentials<T>(p0: java.lang.Class<T>): Set<T>;
        }
        interface Destroyable { 
          destroy(): void;
          isDestroyed(): boolean;
        }
      }
    }
    namespace crypto {
      const Cipher: {
        ENCRYPT_MODE: number;
        DECRYPT_MODE: number;
        WRAP_MODE: number;
        UNWRAP_MODE: number;
        PUBLIC_KEY: number;
        PRIVATE_KEY: number;
        SECRET_KEY: number;
        getInstance(p0: string): javax.crypto.Cipher;
        getInstance(p0: string, p1: string): javax.crypto.Cipher;
        getInstance(p0: string, p1: java.security.Provider): javax.crypto.Cipher;
        getMaxAllowedKeyLength(p0: string): number;
        getMaxAllowedParameterSpec(p0: string): java.security.spec.AlgorithmParameterSpec;
      }
      interface Cipher { 
        getProvider(): java.security.Provider;
        getAlgorithm(): string;
        getBlockSize(): number;
        getOutputSize(p0: number): number;
        getIV(): Array<number>;
        getParameters(): java.security.AlgorithmParameters;
        getExemptionMechanism(): javax.crypto.ExemptionMechanism;
        init(p0: number, p1: java.security.Key): void;
        init(p0: number, p1: java.security.Key, p2: java.security.SecureRandom): void;
        init(p0: number, p1: java.security.Key, p2: java.security.spec.AlgorithmParameterSpec): void;
        init(p0: number, p1: java.security.Key, p2: java.security.spec.AlgorithmParameterSpec, p3: java.security.SecureRandom): void;
        init(p0: number, p1: java.security.Key, p2: java.security.AlgorithmParameters): void;
        init(p0: number, p1: java.security.Key, p2: java.security.AlgorithmParameters, p3: java.security.SecureRandom): void;
        init(p0: number, p1: java.security.cert.Certificate): void;
        init(p0: number, p1: java.security.cert.Certificate, p2: java.security.SecureRandom): void;
        update(p0: Array<number>): Array<number>;
        update(p0: Array<number>, p1: number, p2: number): Array<number>;
        update(p0: Array<number>, p1: number, p2: number, p3: Array<number>): number;
        update(p0: Array<number>, p1: number, p2: number, p3: Array<number>, p4: number): number;
        update(p0: java.nio.ByteBuffer, p1: java.nio.ByteBuffer): number;
        doFinal(): Array<number>;
        doFinal(p0: Array<number>, p1: number): number;
        doFinal(p0: Array<number>): Array<number>;
        doFinal(p0: Array<number>, p1: number, p2: number): Array<number>;
        doFinal(p0: Array<number>, p1: number, p2: number, p3: Array<number>): number;
        doFinal(p0: Array<number>, p1: number, p2: number, p3: Array<number>, p4: number): number;
        doFinal(p0: java.nio.ByteBuffer, p1: java.nio.ByteBuffer): number;
        wrap(p0: java.security.Key): Array<number>;
        unwrap(p0: Array<number>, p1: string, p2: number): java.security.Key;
        updateAAD(p0: Array<number>): void;
        updateAAD(p0: Array<number>, p1: number, p2: number): void;
        updateAAD(p0: java.nio.ByteBuffer): void;
      }
      const ExemptionMechanism: {
        getInstance(p0: string): javax.crypto.ExemptionMechanism;
        getInstance(p0: string, p1: string): javax.crypto.ExemptionMechanism;
        getInstance(p0: string, p1: java.security.Provider): javax.crypto.ExemptionMechanism;
      }
      interface ExemptionMechanism { 
        getName(): string;
        getProvider(): java.security.Provider;
        isCryptoAllowed(p0: java.security.Key): boolean;
        getOutputSize(p0: number): number;
        init(p0: java.security.Key): void;
        init(p0: java.security.Key, p1: java.security.spec.AlgorithmParameterSpec): void;
        init(p0: java.security.Key, p1: java.security.AlgorithmParameters): void;
        genExemptionBlob(): Array<number>;
        genExemptionBlob(p0: Array<number>): number;
        genExemptionBlob(p0: Array<number>, p1: number): number;
      }
      const ExemptionMechanismSpi: {
        new(): javax.crypto.ExemptionMechanismSpi;
      }
      interface ExemptionMechanismSpi { 
      }
      const CipherSpi: {
        new(): javax.crypto.CipherSpi;
      }
      interface CipherSpi { 
      }
    }
    namespace accessibility {
      const AccessibleContext: {
        ACCESSIBLE_NAME_PROPERTY: string;
        ACCESSIBLE_DESCRIPTION_PROPERTY: string;
        ACCESSIBLE_STATE_PROPERTY: string;
        ACCESSIBLE_VALUE_PROPERTY: string;
        ACCESSIBLE_SELECTION_PROPERTY: string;
        ACCESSIBLE_CARET_PROPERTY: string;
        ACCESSIBLE_VISIBLE_DATA_PROPERTY: string;
        ACCESSIBLE_CHILD_PROPERTY: string;
        ACCESSIBLE_ACTIVE_DESCENDANT_PROPERTY: string;
        ACCESSIBLE_TABLE_CAPTION_CHANGED: string;
        ACCESSIBLE_TABLE_SUMMARY_CHANGED: string;
        ACCESSIBLE_TABLE_MODEL_CHANGED: string;
        ACCESSIBLE_TABLE_ROW_HEADER_CHANGED: string;
        ACCESSIBLE_TABLE_ROW_DESCRIPTION_CHANGED: string;
        ACCESSIBLE_TABLE_COLUMN_HEADER_CHANGED: string;
        ACCESSIBLE_TABLE_COLUMN_DESCRIPTION_CHANGED: string;
        ACCESSIBLE_ACTION_PROPERTY: string;
        ACCESSIBLE_HYPERTEXT_OFFSET: string;
        ACCESSIBLE_TEXT_PROPERTY: string;
        ACCESSIBLE_INVALIDATE_CHILDREN: string;
        ACCESSIBLE_TEXT_ATTRIBUTES_CHANGED: string;
        ACCESSIBLE_COMPONENT_BOUNDS_CHANGED: string;
      }
      interface AccessibleContext { 
        getAccessibleName(): string;
        setAccessibleName(p0: string): void;
        getAccessibleDescription(): string;
        setAccessibleDescription(p0: string): void;
        getAccessibleRole(): javax.accessibility.AccessibleRole;
        getAccessibleStateSet(): javax.accessibility.AccessibleStateSet;
        getAccessibleParent(): javax.accessibility.Accessible;
        setAccessibleParent(p0: javax.accessibility.Accessible): void;
        getAccessibleIndexInParent(): number;
        getAccessibleChildrenCount(): number;
        getAccessibleChild(p0: number): javax.accessibility.Accessible;
        getLocale(): java.util.Locale;
        addPropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        removePropertyChangeListener(p0: java.beans.PropertyChangeListener): void;
        getAccessibleAction(): javax.accessibility.AccessibleAction;
        getAccessibleComponent(): javax.accessibility.AccessibleComponent;
        getAccessibleSelection(): javax.accessibility.AccessibleSelection;
        getAccessibleText(): javax.accessibility.AccessibleText;
        getAccessibleEditableText(): javax.accessibility.AccessibleEditableText;
        getAccessibleValue(): javax.accessibility.AccessibleValue;
        getAccessibleIcon(): Array<unknown>;
        getAccessibleRelationSet(): javax.accessibility.AccessibleRelationSet;
        getAccessibleTable(): javax.accessibility.AccessibleTable;
        firePropertyChange(p0: string, p1: any, p2: any): void;
      }
      const AccessibleRole: {
        ALERT: javax.accessibility.AccessibleRole;
        COLUMN_HEADER: javax.accessibility.AccessibleRole;
        CANVAS: javax.accessibility.AccessibleRole;
        COMBO_BOX: javax.accessibility.AccessibleRole;
        DESKTOP_ICON: javax.accessibility.AccessibleRole;
        HTML_CONTAINER: javax.accessibility.AccessibleRole;
        INTERNAL_FRAME: javax.accessibility.AccessibleRole;
        DESKTOP_PANE: javax.accessibility.AccessibleRole;
        OPTION_PANE: javax.accessibility.AccessibleRole;
        WINDOW: javax.accessibility.AccessibleRole;
        FRAME: javax.accessibility.AccessibleRole;
        DIALOG: javax.accessibility.AccessibleRole;
        COLOR_CHOOSER: javax.accessibility.AccessibleRole;
        DIRECTORY_PANE: javax.accessibility.AccessibleRole;
        FILE_CHOOSER: javax.accessibility.AccessibleRole;
        FILLER: javax.accessibility.AccessibleRole;
        HYPERLINK: javax.accessibility.AccessibleRole;
        ICON: javax.accessibility.AccessibleRole;
        LABEL: javax.accessibility.AccessibleRole;
        ROOT_PANE: javax.accessibility.AccessibleRole;
        GLASS_PANE: javax.accessibility.AccessibleRole;
        LAYERED_PANE: javax.accessibility.AccessibleRole;
        LIST: javax.accessibility.AccessibleRole;
        LIST_ITEM: javax.accessibility.AccessibleRole;
        MENU_BAR: javax.accessibility.AccessibleRole;
        POPUP_MENU: javax.accessibility.AccessibleRole;
        MENU: javax.accessibility.AccessibleRole;
        MENU_ITEM: javax.accessibility.AccessibleRole;
        SEPARATOR: javax.accessibility.AccessibleRole;
        PAGE_TAB_LIST: javax.accessibility.AccessibleRole;
        PAGE_TAB: javax.accessibility.AccessibleRole;
        PANEL: javax.accessibility.AccessibleRole;
        PROGRESS_BAR: javax.accessibility.AccessibleRole;
        PASSWORD_TEXT: javax.accessibility.AccessibleRole;
        PUSH_BUTTON: javax.accessibility.AccessibleRole;
        TOGGLE_BUTTON: javax.accessibility.AccessibleRole;
        CHECK_BOX: javax.accessibility.AccessibleRole;
        RADIO_BUTTON: javax.accessibility.AccessibleRole;
        ROW_HEADER: javax.accessibility.AccessibleRole;
        SCROLL_PANE: javax.accessibility.AccessibleRole;
        SCROLL_BAR: javax.accessibility.AccessibleRole;
        VIEWPORT: javax.accessibility.AccessibleRole;
        SLIDER: javax.accessibility.AccessibleRole;
        SPLIT_PANE: javax.accessibility.AccessibleRole;
        TABLE: javax.accessibility.AccessibleRole;
        TEXT: javax.accessibility.AccessibleRole;
        TREE: javax.accessibility.AccessibleRole;
        TOOL_BAR: javax.accessibility.AccessibleRole;
        TOOL_TIP: javax.accessibility.AccessibleRole;
        AWT_COMPONENT: javax.accessibility.AccessibleRole;
        SWING_COMPONENT: javax.accessibility.AccessibleRole;
        UNKNOWN: javax.accessibility.AccessibleRole;
        STATUS_BAR: javax.accessibility.AccessibleRole;
        DATE_EDITOR: javax.accessibility.AccessibleRole;
        SPIN_BOX: javax.accessibility.AccessibleRole;
        FONT_CHOOSER: javax.accessibility.AccessibleRole;
        GROUP_BOX: javax.accessibility.AccessibleRole;
        HEADER: javax.accessibility.AccessibleRole;
        FOOTER: javax.accessibility.AccessibleRole;
        PARAGRAPH: javax.accessibility.AccessibleRole;
        RULER: javax.accessibility.AccessibleRole;
        EDITBAR: javax.accessibility.AccessibleRole;
        PROGRESS_MONITOR: javax.accessibility.AccessibleRole;
      }
      interface AccessibleRole extends javax.accessibility.AccessibleBundle { 
      }
      const AccessibleBundle: {
        new(): javax.accessibility.AccessibleBundle;
      }
      interface AccessibleBundle { 
        toDisplayString(p0: java.util.Locale): string;
        toDisplayString(): string;
      }
      const AccessibleStateSet: {
        new(): javax.accessibility.AccessibleStateSet;
        new(p0: Array<javax.accessibility.AccessibleState>): javax.accessibility.AccessibleStateSet;
      }
      interface AccessibleStateSet { 
        add(p0: javax.accessibility.AccessibleState): boolean;
        addAll(p0: Array<javax.accessibility.AccessibleState>): void;
        remove(p0: javax.accessibility.AccessibleState): boolean;
        clear(): void;
        contains(p0: javax.accessibility.AccessibleState): boolean;
        toArray(): Array<javax.accessibility.AccessibleState>;
      }
      const AccessibleState: {
        ACTIVE: javax.accessibility.AccessibleState;
        PRESSED: javax.accessibility.AccessibleState;
        ARMED: javax.accessibility.AccessibleState;
        BUSY: javax.accessibility.AccessibleState;
        CHECKED: javax.accessibility.AccessibleState;
        EDITABLE: javax.accessibility.AccessibleState;
        EXPANDABLE: javax.accessibility.AccessibleState;
        COLLAPSED: javax.accessibility.AccessibleState;
        EXPANDED: javax.accessibility.AccessibleState;
        ENABLED: javax.accessibility.AccessibleState;
        FOCUSABLE: javax.accessibility.AccessibleState;
        FOCUSED: javax.accessibility.AccessibleState;
        ICONIFIED: javax.accessibility.AccessibleState;
        MODAL: javax.accessibility.AccessibleState;
        OPAQUE: javax.accessibility.AccessibleState;
        RESIZABLE: javax.accessibility.AccessibleState;
        MULTISELECTABLE: javax.accessibility.AccessibleState;
        SELECTABLE: javax.accessibility.AccessibleState;
        SELECTED: javax.accessibility.AccessibleState;
        SHOWING: javax.accessibility.AccessibleState;
        VISIBLE: javax.accessibility.AccessibleState;
        VERTICAL: javax.accessibility.AccessibleState;
        HORIZONTAL: javax.accessibility.AccessibleState;
        SINGLE_LINE: javax.accessibility.AccessibleState;
        MULTI_LINE: javax.accessibility.AccessibleState;
        TRANSIENT: javax.accessibility.AccessibleState;
        MANAGES_DESCENDANTS: javax.accessibility.AccessibleState;
        INDETERMINATE: javax.accessibility.AccessibleState;
        TRUNCATED: javax.accessibility.AccessibleState;
      }
      interface AccessibleState extends javax.accessibility.AccessibleBundle { 
      }
      interface Accessible { 
        getAccessibleContext(): javax.accessibility.AccessibleContext;
      }
      const AccessibleAction: {
        TOGGLE_EXPAND: string;
        INCREMENT: string;
        DECREMENT: string;
        CLICK: string;
        TOGGLE_POPUP: string;
      }
      interface AccessibleAction { 
        getAccessibleActionCount(): number;
        getAccessibleActionDescription(p0: number): string;
        doAccessibleAction(p0: number): boolean;
      }
      interface AccessibleComponent { 
        getBackground(): java.awt.Color;
        setBackground(p0: java.awt.Color): void;
        getForeground(): java.awt.Color;
        setForeground(p0: java.awt.Color): void;
        getCursor(): java.awt.Cursor;
        setCursor(p0: java.awt.Cursor): void;
        getFont(): java.awt.Font;
        setFont(p0: java.awt.Font): void;
        getFontMetrics(p0: java.awt.Font): java.awt.FontMetrics;
        isEnabled(): boolean;
        setEnabled(p0: boolean): void;
        isVisible(): boolean;
        setVisible(p0: boolean): void;
        isShowing(): boolean;
        contains(p0: java.awt.Point): boolean;
        getLocationOnScreen(): java.awt.Point;
        getLocation(): java.awt.Point;
        setLocation(p0: java.awt.Point): void;
        getBounds(): java.awt.Rectangle;
        setBounds(p0: java.awt.Rectangle): void;
        getSize(): java.awt.Dimension;
        setSize(p0: java.awt.Dimension): void;
        getAccessibleAt(p0: java.awt.Point): javax.accessibility.Accessible;
        isFocusTraversable(): boolean;
        requestFocus(): void;
        addFocusListener(p0: java.awt.event.FocusListener): void;
        removeFocusListener(p0: java.awt.event.FocusListener): void;
      }
      interface AccessibleSelection { 
        getAccessibleSelectionCount(): number;
        getAccessibleSelection(p0: number): javax.accessibility.Accessible;
        isAccessibleChildSelected(p0: number): boolean;
        addAccessibleSelection(p0: number): void;
        removeAccessibleSelection(p0: number): void;
        clearAccessibleSelection(): void;
        selectAllAccessibleSelection(): void;
      }
      const AccessibleText: {
        CHARACTER: number;
        WORD: number;
        SENTENCE: number;
      }
      interface AccessibleText { 
        getIndexAtPoint(p0: java.awt.Point): number;
        getCharacterBounds(p0: number): java.awt.Rectangle;
        getCharCount(): number;
        getCaretPosition(): number;
        getAtIndex(p0: number, p1: number): string;
        getAfterIndex(p0: number, p1: number): string;
        getBeforeIndex(p0: number, p1: number): string;
        getCharacterAttribute(p0: number): javax.swing.text.AttributeSet;
        getSelectionStart(): number;
        getSelectionEnd(): number;
        getSelectedText(): string;
      }
      interface AccessibleEditableText extends javax.accessibility.AccessibleText { 
        setTextContents(p0: string): void;
        insertTextAtIndex(p0: number, p1: string): void;
        getTextRange(p0: number, p1: number): string;
        cut(p0: number, p1: number): void;
        paste(p0: number): void;
        replaceText(p0: number, p1: number, p2: string): void;
        selectText(p0: number, p1: number): void;
        setAttributes(p0: number, p1: number, p2: javax.swing.text.AttributeSet): void;
      }
      interface AccessibleValue { 
        getCurrentAccessibleValue(): kotlin.Number;
        setCurrentAccessibleValue(p0: kotlin.Number): boolean;
        getMinimumAccessibleValue(): kotlin.Number;
        getMaximumAccessibleValue(): kotlin.Number;
      }
      const AccessibleRelationSet: {
        new(): javax.accessibility.AccessibleRelationSet;
        new(p0: Array<javax.accessibility.AccessibleRelation>): javax.accessibility.AccessibleRelationSet;
      }
      interface AccessibleRelationSet { 
        add(p0: javax.accessibility.AccessibleRelation): boolean;
        addAll(p0: Array<javax.accessibility.AccessibleRelation>): void;
        remove(p0: javax.accessibility.AccessibleRelation): boolean;
        clear(): void;
        size(): number;
        contains(p0: string): boolean;
        get(p0: string): javax.accessibility.AccessibleRelation;
        toArray(): Array<javax.accessibility.AccessibleRelation>;
      }
      const AccessibleRelation: {
        LABEL_FOR: string;
        LABELED_BY: string;
        MEMBER_OF: string;
        CONTROLLER_FOR: string;
        CONTROLLED_BY: string;
        FLOWS_TO: string;
        FLOWS_FROM: string;
        SUBWINDOW_OF: string;
        PARENT_WINDOW_OF: string;
        EMBEDS: string;
        EMBEDDED_BY: string;
        CHILD_NODE_OF: string;
        LABEL_FOR_PROPERTY: string;
        LABELED_BY_PROPERTY: string;
        MEMBER_OF_PROPERTY: string;
        CONTROLLER_FOR_PROPERTY: string;
        CONTROLLED_BY_PROPERTY: string;
        FLOWS_TO_PROPERTY: string;
        FLOWS_FROM_PROPERTY: string;
        SUBWINDOW_OF_PROPERTY: string;
        PARENT_WINDOW_OF_PROPERTY: string;
        EMBEDS_PROPERTY: string;
        EMBEDDED_BY_PROPERTY: string;
        CHILD_NODE_OF_PROPERTY: string;
        new(p0: string): javax.accessibility.AccessibleRelation;
        new(p0: string, p1: any): javax.accessibility.AccessibleRelation;
        new(p0: string, p1: Array<any>): javax.accessibility.AccessibleRelation;
      }
      interface AccessibleRelation extends javax.accessibility.AccessibleBundle { 
        getKey(): string;
        getTarget(): Array<any>;
        setTarget(p0: any): void;
        setTarget(p0: Array<any>): void;
      }
      interface AccessibleTable { 
        getAccessibleCaption(): javax.accessibility.Accessible;
        setAccessibleCaption(p0: javax.accessibility.Accessible): void;
        getAccessibleSummary(): javax.accessibility.Accessible;
        setAccessibleSummary(p0: javax.accessibility.Accessible): void;
        getAccessibleRowCount(): number;
        getAccessibleColumnCount(): number;
        getAccessibleAt(p0: number, p1: number): javax.accessibility.Accessible;
        getAccessibleRowExtentAt(p0: number, p1: number): number;
        getAccessibleColumnExtentAt(p0: number, p1: number): number;
        getAccessibleRowHeader(): javax.accessibility.AccessibleTable;
        setAccessibleRowHeader(p0: javax.accessibility.AccessibleTable): void;
        getAccessibleColumnHeader(): javax.accessibility.AccessibleTable;
        setAccessibleColumnHeader(p0: javax.accessibility.AccessibleTable): void;
        getAccessibleRowDescription(p0: number): javax.accessibility.Accessible;
        setAccessibleRowDescription(p0: number, p1: javax.accessibility.Accessible): void;
        getAccessibleColumnDescription(p0: number): javax.accessibility.Accessible;
        setAccessibleColumnDescription(p0: number, p1: javax.accessibility.Accessible): void;
        isAccessibleSelected(p0: number, p1: number): boolean;
        isAccessibleRowSelected(p0: number): boolean;
        isAccessibleColumnSelected(p0: number): boolean;
        getSelectedAccessibleRows(): Array<number>;
        getSelectedAccessibleColumns(): Array<number>;
      }
    }
    namespace swing {
      namespace text {
        const AttributeSet: {
          NameAttribute: any;
          ResolveAttribute: any;
        }
        interface AttributeSet { 
          getAttributeCount(): number;
          isDefined(p0: any): boolean;
          isEqual(p0: javax.swing.text.AttributeSet): boolean;
          copyAttributes(): javax.swing.text.AttributeSet;
          getAttribute(p0: any): any;
          getAttributeNames(): java.util.Enumeration<any>;
          containsAttribute(p0: any, p1: any): boolean;
          containsAttributes(p0: javax.swing.text.AttributeSet): boolean;
          getResolveParent(): javax.swing.text.AttributeSet;
        }
        interface AttributeSet$ParagraphAttribute { 
        }
        interface AttributeSet$CharacterAttribute { 
        }
        interface AttributeSet$ColorAttribute { 
        }
        interface AttributeSet$FontAttribute { 
        }
      }
    }
  }
  namespace gg {
    namespace essential {
      namespace universal {
        const UKeyboard: {
          Modifiers: typeof gg.essential.universal.UKeyboard$Modifiers;
          KEY_0: number;
          KEY_1: number;
          KEY_2: number;
          KEY_3: number;
          KEY_4: number;
          KEY_5: number;
          KEY_6: number;
          KEY_7: number;
          KEY_8: number;
          KEY_9: number;
          KEY_A: number;
          KEY_ADD: number;
          KEY_APOSTROPHE: number;
          KEY_B: number;
          KEY_BACKSLASH: number;
          KEY_BACKSPACE: number;
          KEY_C: number;
          KEY_CAPITAL: number;
          KEY_COMMA: number;
          KEY_D: number;
          KEY_DECIMAL: number;
          KEY_DELETE: number;
          KEY_DIVIDE: number;
          KEY_DOWN: number;
          KEY_E: number;
          KEY_END: number;
          KEY_ENTER: number;
          KEY_EQUALS: number;
          KEY_ESCAPE: number;
          KEY_F: number;
          KEY_F1: number;
          KEY_F10: number;
          KEY_F11: number;
          KEY_F12: number;
          KEY_F13: number;
          KEY_F14: number;
          KEY_F15: number;
          KEY_F16: number;
          KEY_F17: number;
          KEY_F18: number;
          KEY_F19: number;
          KEY_F2: number;
          KEY_F3: number;
          KEY_F4: number;
          KEY_F5: number;
          KEY_F6: number;
          KEY_F7: number;
          KEY_F8: number;
          KEY_F9: number;
          KEY_G: number;
          KEY_GRAVE: number;
          KEY_H: number;
          KEY_HOME: number;
          KEY_I: number;
          KEY_J: number;
          KEY_K: number;
          KEY_L: number;
          KEY_LBRACKET: number;
          KEY_LCONTROL: number;
          KEY_LEFT: number;
          KEY_LMENU: number;
          KEY_LMETA: number;
          KEY_LSHIFT: number;
          KEY_M: number;
          KEY_MENU: number;
          KEY_MINUS: number;
          KEY_MULTIPLY: number;
          KEY_N: number;
          KEY_NONE: number;
          KEY_NUMLOCK: number;
          KEY_NUMPAD0: number;
          KEY_NUMPAD1: number;
          KEY_NUMPAD2: number;
          KEY_NUMPAD3: number;
          KEY_NUMPAD4: number;
          KEY_NUMPAD5: number;
          KEY_NUMPAD6: number;
          KEY_NUMPAD7: number;
          KEY_NUMPAD8: number;
          KEY_NUMPAD9: number;
          KEY_NUMPADENTER: number;
          KEY_O: number;
          KEY_P: number;
          KEY_PERIOD: number;
          KEY_Q: number;
          KEY_R: number;
          KEY_RBRACKET: number;
          KEY_RCONTROL: number;
          KEY_RIGHT: number;
          KEY_RMENU: number;
          KEY_RMETA: number;
          KEY_RSHIFT: number;
          KEY_S: number;
          KEY_SCROLL: number;
          KEY_SEMICOLON: number;
          KEY_SLASH: number;
          KEY_SPACE: number;
          KEY_SUBTRACT: number;
          KEY_T: number;
          KEY_TAB: number;
          KEY_U: number;
          KEY_UP: number;
          KEY_V: number;
          KEY_W: number;
          KEY_X: number;
          KEY_Y: number;
          KEY_Z: number;
          allowRepeatEvents(enabled: boolean): void;
          getKeyName(keyCode: number): string | null | undefined;
          getKeyName(keyCode: number, scanCode: number): string | null | undefined;
          getKeyName(keyBinding: net.minecraft.client.option.KeyBinding): string | null | undefined;
          getModifiers(): gg.essential.universal.UKeyboard$Modifiers;
          isAltKeyDown(): boolean;
          isCtrlKeyDown(): boolean;
          isEnterKey(key: number): boolean;
          isKeyComboCtrlA(key: number): boolean;
          isKeyComboCtrlC(key: number): boolean;
          isKeyComboCtrlShiftZ(key: number): boolean;
          isKeyComboCtrlV(key: number): boolean;
          isKeyComboCtrlX(key: number): boolean;
          isKeyComboCtrlY(key: number): boolean;
          isKeyComboCtrlZ(key: number): boolean;
          isKeyDown(key: number): boolean;
          isShiftKeyDown(): boolean;
        }
        interface UKeyboard { 
          KEY_0: number;
          KEY_1: number;
          KEY_2: number;
          KEY_3: number;
          KEY_4: number;
          KEY_5: number;
          KEY_6: number;
          KEY_7: number;
          KEY_8: number;
          KEY_9: number;
          KEY_A: number;
          KEY_ADD: number;
          KEY_APOSTROPHE: number;
          KEY_B: number;
          KEY_BACKSLASH: number;
          KEY_BACKSPACE: number;
          KEY_C: number;
          KEY_CAPITAL: number;
          KEY_COMMA: number;
          KEY_D: number;
          KEY_DECIMAL: number;
          KEY_DELETE: number;
          KEY_DIVIDE: number;
          KEY_DOWN: number;
          KEY_E: number;
          KEY_END: number;
          KEY_ENTER: number;
          KEY_EQUALS: number;
          KEY_ESCAPE: number;
          KEY_F: number;
          KEY_F1: number;
          KEY_F10: number;
          KEY_F11: number;
          KEY_F12: number;
          KEY_F13: number;
          KEY_F14: number;
          KEY_F15: number;
          KEY_F16: number;
          KEY_F17: number;
          KEY_F18: number;
          KEY_F19: number;
          KEY_F2: number;
          KEY_F3: number;
          KEY_F4: number;
          KEY_F5: number;
          KEY_F6: number;
          KEY_F7: number;
          KEY_F8: number;
          KEY_F9: number;
          KEY_G: number;
          KEY_GRAVE: number;
          KEY_H: number;
          KEY_HOME: number;
          KEY_I: number;
          KEY_J: number;
          KEY_K: number;
          KEY_L: number;
          KEY_LBRACKET: number;
          KEY_LCONTROL: number;
          KEY_LEFT: number;
          KEY_LMENU: number;
          KEY_LMETA: number;
          KEY_LSHIFT: number;
          KEY_M: number;
          KEY_MENU: number;
          KEY_MINUS: number;
          KEY_MULTIPLY: number;
          KEY_N: number;
          KEY_NONE: number;
          KEY_NUMLOCK: number;
          KEY_NUMPAD0: number;
          KEY_NUMPAD1: number;
          KEY_NUMPAD2: number;
          KEY_NUMPAD3: number;
          KEY_NUMPAD4: number;
          KEY_NUMPAD5: number;
          KEY_NUMPAD6: number;
          KEY_NUMPAD7: number;
          KEY_NUMPAD8: number;
          KEY_NUMPAD9: number;
          KEY_NUMPADENTER: number;
          KEY_O: number;
          KEY_P: number;
          KEY_PERIOD: number;
          KEY_Q: number;
          KEY_R: number;
          KEY_RBRACKET: number;
          KEY_RCONTROL: number;
          KEY_RIGHT: number;
          KEY_RMENU: number;
          KEY_RMETA: number;
          KEY_RSHIFT: number;
          KEY_S: number;
          KEY_SCROLL: number;
          KEY_SEMICOLON: number;
          KEY_SLASH: number;
          KEY_SPACE: number;
          KEY_SUBTRACT: number;
          KEY_T: number;
          KEY_TAB: number;
          KEY_U: number;
          KEY_UP: number;
          KEY_V: number;
          KEY_W: number;
          KEY_X: number;
          KEY_Y: number;
          KEY_Z: number;
          allowRepeatEvents(enabled: boolean): void;
          getKeyName(keyCode: number): string | null | undefined;
          getKeyName(keyCode: number, scanCode: number): string | null | undefined;
          getKeyName(keyBinding: net.minecraft.client.option.KeyBinding): string | null | undefined;
          getModifiers(): gg.essential.universal.UKeyboard$Modifiers;
          isAltKeyDown(): boolean;
          isCtrlKeyDown(): boolean;
          isEnterKey(key: number): boolean;
          isKeyComboCtrlA(key: number): boolean;
          isKeyComboCtrlC(key: number): boolean;
          isKeyComboCtrlShiftZ(key: number): boolean;
          isKeyComboCtrlV(key: number): boolean;
          isKeyComboCtrlX(key: number): boolean;
          isKeyComboCtrlY(key: number): boolean;
          isKeyComboCtrlZ(key: number): boolean;
          isKeyDown(key: number): boolean;
          isShiftKeyDown(): boolean;
        }
        const UKeyboard$Modifiers: {
          new(isCtrl: boolean, isShift: boolean, isAlt: boolean): gg.essential.universal.UKeyboard$Modifiers;
        }
        interface UKeyboard$Modifiers { 
          isAlt(): boolean;
          isCtrl(): boolean;
          isShift(): boolean;
          component1(): boolean;
          component2(): boolean;
          component3(): boolean;
          copy(isCtrl: boolean, isShift: boolean, isAlt: boolean): gg.essential.universal.UKeyboard$Modifiers;
        }
        const UScreen: {
          new(): gg.essential.universal.UScreen;
          new(restoreCurrentGuiOnClose: boolean): gg.essential.universal.UScreen;
          new(restoreCurrentGuiOnClose: boolean, newGuiScale: number): gg.essential.universal.UScreen;
          new(restoreCurrentGuiOnClose: boolean, newGuiScale: gg.essential.universal.GuiScale): gg.essential.universal.UScreen;
          new(restoreCurrentGuiOnClose: boolean, newGuiScale: number, unlocalizedName: string | null | undefined): gg.essential.universal.UScreen;
        }
        interface UScreen extends net.minecraft.client.gui.screen.Screen { 
          getNewGuiScale(): number;
          setNewGuiScale(value: number): void;
          getRestoreCurrentGuiOnClose(): boolean;
          getUnlocalizedName(): string | null | undefined;
          setUnlocalizedName(value: string | null | undefined): void;
          initScreen(width: number, height: number): void;
          onDrawBackground(matrixStack: gg.essential.universal.UMatrixStack, tint: number): void;
          onDrawBackground(tint: number): void;
          onDrawBackgroundCompat(matrixStack: gg.essential.universal.UMatrixStack, tint: number): void;
          onDrawScreen(matrixStack: gg.essential.universal.UMatrixStack, mouseX: number, mouseY: number, partialTicks: number): void;
          onDrawScreen(mouseX: number, mouseY: number, partialTicks: number): void;
          onKeyPressed(keyCode: number, typedChar: number, modifiers: gg.essential.universal.UKeyboard$Modifiers | null | undefined): void;
          onKeyReleased(keyCode: number, typedChar: number, modifiers: gg.essential.universal.UKeyboard$Modifiers | null | undefined): void;
          onMouseClicked(mouseX: number, mouseY: number, mouseButton: number): void;
          onMouseDragged(x: number, y: number, clickedButton: number, timeSinceLastClick: number): void;
          onMouseReleased(mouseX: number, mouseY: number, state: number): void;
          onMouseScrolled(delta: number): void;
          onScreenClose(): void;
          onTick(): void;
          restorePreviousScreen(): void;
          updateGuiScale(): void;
        }
        const UMatrixStack: {
          Entry: typeof gg.essential.universal.UMatrixStack$Entry;
          new(): gg.essential.universal.UMatrixStack;
          new(mc: net.minecraft.client.util.math.MatrixStack): gg.essential.universal.UMatrixStack;
          new(mc: net.minecraft.client.util.math.MatrixStack$Entry): gg.essential.universal.UMatrixStack;
          new(mc: org.joml.Matrix3x2f): gg.essential.universal.UMatrixStack;
        }
        interface UMatrixStack { 
          applyToGlobalState(): void;
          fork(): gg.essential.universal.UMatrixStack;
          isEmpty(): boolean;
          multiply(quaternion: org.joml.Quaternionf): void;
          peek(): gg.essential.universal.UMatrixStack$Entry;
          pop(): void;
          push(): void;
          replaceGlobalState(): void;
          rotate(angle: number, x: number, y: number, z: number): void;
          rotate(angle: number, x: number, y: number, z: number, degrees: boolean): void;
          runReplacingGlobalState<R>(block: kotlin.Function0<R>): R;
          runReplacingGlobalState(block: java.lang.Runnable): void;
          runWithGlobalState<R>(block: kotlin.Function0<R>): R;
          runWithGlobalState(block: java.lang.Runnable): void;
          scale(x: number, y: number, z: number): void;
          scale(x: number, y: number, z: number): void;
          to3x2Joml(dst: org.joml.Matrix3x2f): org.joml.Matrix3x2f;
          toMC(): net.minecraft.client.util.math.MatrixStack;
          translate(x: number, y: number, z: number): void;
          translate(x: number, y: number, z: number): void;
        }
        const UMatrixStack$Entry: {
          new(model: org.joml.Matrix4f, normal: org.joml.Matrix3f): gg.essential.universal.UMatrixStack$Entry;
        }
        interface UMatrixStack$Entry { 
          getModel(): org.joml.Matrix4f;
          getModelAsArray(): kotlin.FloatArray;
          getNormal(): org.joml.Matrix3f;
          component1(): org.joml.Matrix4f;
          component2(): org.joml.Matrix3f;
          copy(model: org.joml.Matrix4f, normal: org.joml.Matrix3f): gg.essential.universal.UMatrixStack$Entry;
          deepCopy(): gg.essential.universal.UMatrixStack$Entry;
          toMCStack(): net.minecraft.client.util.math.MatrixStack;
        }
        const UMatrixStack$Companion: {
          UNIT: gg.essential.universal.UMatrixStack;
        }
        interface UMatrixStack$Companion { 
          UNIT: gg.essential.universal.UMatrixStack;
        }
        interface UMatrixStack$Compat { 
          getDEPRECATED(): string;
          get(): gg.essential.universal.UMatrixStack;
          runLegacyMethod<R>(matrixStack: gg.essential.universal.UMatrixStack, block: kotlin.Function0<R>): R;
        }
        const UScreen$Companion: {
          getCurrentScreen(): net.minecraft.client.gui.screen.Screen | null | undefined;
          displayScreen(screen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
        }
        interface UScreen$Companion { 
          getCurrentScreen(): net.minecraft.client.gui.screen.Screen | null | undefined;
          displayScreen(screen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
        }
        const GuiScale: {
          Auto: gg.essential.universal.GuiScale;
          Small: gg.essential.universal.GuiScale;
          Medium: gg.essential.universal.GuiScale;
          Large: gg.essential.universal.GuiScale;
          VeryLarge: gg.essential.universal.GuiScale;
          valueOf(value: string): gg.essential.universal.GuiScale;
          values(): Array<gg.essential.universal.GuiScale>;
        }
        interface GuiScale extends kotlin.Enum<gg.essential.universal.GuiScale> { 
        }
        const GuiScale$Companion: {
          fromNumber(number: number): gg.essential.universal.GuiScale;
          scaleForScreenSize(): gg.essential.universal.GuiScale;
          scaleForScreenSize(step: number): gg.essential.universal.GuiScale;
        }
        interface GuiScale$Companion { 
          fromNumber(number: number): gg.essential.universal.GuiScale;
          scaleForScreenSize(): gg.essential.universal.GuiScale;
          scaleForScreenSize(step: number): gg.essential.universal.GuiScale;
        }
        const UGraphics$DrawMode: {
          LINES: gg.essential.universal.UGraphics$DrawMode;
          LINE_STRIP: gg.essential.universal.UGraphics$DrawMode;
          TRIANGLES: gg.essential.universal.UGraphics$DrawMode;
          TRIANGLE_STRIP: gg.essential.universal.UGraphics$DrawMode;
          TRIANGLE_FAN: gg.essential.universal.UGraphics$DrawMode;
          QUADS: gg.essential.universal.UGraphics$DrawMode;
          fromGl(glMode: number): gg.essential.universal.UGraphics$DrawMode;
          fromRenderLayer(renderLayer: net.minecraft.client.render.RenderLayer): gg.essential.universal.UGraphics$DrawMode;
          valueOf(value: string): gg.essential.universal.UGraphics$DrawMode;
          values(): Array<gg.essential.universal.UGraphics$DrawMode>;
        }
        interface UGraphics$DrawMode extends kotlin.Enum<gg.essential.universal.UGraphics$DrawMode> { 
          glMode: number;
          mcMode: com.mojang.blaze3d.vertex.VertexFormat$DrawMode;
        }
      }
      namespace vigilance {
        namespace data {
          const SortingBehavior: {
            new(): gg.essential.vigilance.data.SortingBehavior;
          }
          interface SortingBehavior { 
            getCategoryComparator(): java.util.Comparator<T>;
            getPropertyComparator(): java.util.Comparator<T>;
            getSubcategoryComparator(): java.util.Comparator<T>;
          }
          const Category: {
            new(name: string, items: Array<unknown>, description: string | null | undefined): gg.essential.vigilance.data.Category;
          }
          interface Category { 
            getDescription(): string | null | undefined;
            getItems(): Array<unknown>;
            getName(): string;
          }
          const PropertyData: {
            new(attributesExt: gg.essential.vigilance.data.PropertyAttributesExt, value: gg.essential.vigilance.data.PropertyValue, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
            new(attributes: gg.essential.vigilance.data.PropertyAttributes, value: gg.essential.vigilance.data.PropertyValue, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
          }
          interface PropertyData { 
            getAction(): kotlin.Function1<any | null | undefined, void> | null | undefined;
            setAction(value: kotlin.Function1<any | null | undefined, void> | null | undefined): void;
            getAttributes(): gg.essential.vigilance.data.PropertyAttributes;
            getAttributesExt(): gg.essential.vigilance.data.PropertyAttributesExt;
            getDependencyPredicate(): kotlin.Function1<any | null | undefined, boolean> | null | undefined;
            setDependencyPredicate(value: kotlin.Function1<any | null | undefined, boolean> | null | undefined): void;
            getDependsOn(): gg.essential.vigilance.data.PropertyData | null | undefined;
            setDependsOn(value: gg.essential.vigilance.data.PropertyData | null | undefined): void;
            getHasDependants(): boolean;
            setHasDependants(value: boolean): void;
            getInstance(): gg.essential.vigilance.Vigilant;
            getInverseDependency(): boolean;
            setInverseDependency(value: boolean): void;
            getValue(): gg.essential.vigilance.data.PropertyValue;
            component1(): gg.essential.vigilance.data.PropertyAttributes;
            component2(): gg.essential.vigilance.data.PropertyValue;
            component3(): gg.essential.vigilance.Vigilant;
            copy(attributes: gg.essential.vigilance.data.PropertyAttributes, value: gg.essential.vigilance.data.PropertyValue, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
            getAs<T>(clazz: java.lang.Class<T>): T;
            getAsAny(): any | null | undefined;
            getAsBoolean(): boolean;
            getDataType(): gg.essential.vigilance.data.PropertyType;
            getValue<T>(): T;
            isHidden(): boolean;
            setCallbackConsumer(callback: unknown): void;
            setValue(value: any | null | undefined): void;
          }
          const PropertyAttributes: {
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean): gg.essential.vigilance.data.PropertyAttributes;
          }
          interface PropertyAttributes { 
            getAllowAlpha(): boolean;
            getCategory(): string;
            getDecimalPlaces(): number;
            getDescription(): string;
            getHidden(): boolean;
            setHidden(value: boolean): void;
            getIncrement(): number;
            getMax(): number;
            getMaxF(): number;
            getMin(): number;
            getMinF(): number;
            getName(): string;
            getOptions(): Array<string>;
            getPlaceholder(): string;
            getProtected(): boolean;
            getSubcategory(): string;
            getTriggerActionOnInitialization(): boolean;
            getType(): gg.essential.vigilance.data.PropertyType;
            component1(): gg.essential.vigilance.data.PropertyType;
            component10(): number;
            component11(): number;
            component12(): Array<string>;
            component13(): boolean;
            component14(): string;
            component15(): boolean;
            component16(): boolean;
            component17(): boolean;
            component2(): string;
            component3(): string;
            component4(): string;
            component5(): string;
            component6(): number;
            component7(): number;
            component8(): number;
            component9(): number;
            copy(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean): gg.essential.vigilance.data.PropertyAttributes;
          }
          const PropertyType: {
            SWITCH: gg.essential.vigilance.data.PropertyType;
            CHECKBOX: gg.essential.vigilance.data.PropertyType;
            TEXT: gg.essential.vigilance.data.PropertyType;
            PARAGRAPH: gg.essential.vigilance.data.PropertyType;
            PERCENT_SLIDER: gg.essential.vigilance.data.PropertyType;
            SLIDER: gg.essential.vigilance.data.PropertyType;
            DECIMAL_SLIDER: gg.essential.vigilance.data.PropertyType;
            NUMBER: gg.essential.vigilance.data.PropertyType;
            COLOR: gg.essential.vigilance.data.PropertyType;
            SELECTOR: gg.essential.vigilance.data.PropertyType;
            BUTTON: gg.essential.vigilance.data.PropertyType;
            CUSTOM: gg.essential.vigilance.data.PropertyType;
            valueOf(value: string): gg.essential.vigilance.data.PropertyType;
            values(): Array<gg.essential.vigilance.data.PropertyType>;
          }
          interface PropertyType extends kotlin.Enum<gg.essential.vigilance.data.PropertyType> { 
            getType(): java.lang.Class<any>;
            isFieldValid(field: java.lang.reflect.Field): boolean;
          }
          interface PropertyAttributes$Companion { 
            fromPropertyAnnotation(property: gg.essential.vigilance.data.Property): gg.essential.vigilance.data.PropertyAttributes;
          }
          const Property: {
            new(type: gg.essential.vigilance.data.PropertyType, name: string, i18nName: string, category: string, i18nCategory: string, subcategory: string, i18nSubcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protectedText: boolean, triggerActionOnInitialization: boolean, hidden: boolean, searchTags: Array<string>, customPropertyInfo: kotlin.reflect.KClass<unknown>): gg.essential.vigilance.data.Property;
          }
          interface Property extends kotlin.Annotation { 
            allowAlpha(): boolean;
            category(): string;
            customPropertyInfo(): kotlin.reflect.KClass<unknown>;
            decimalPlaces(): number;
            description(): string;
            hidden(): boolean;
            i18nCategory(): string;
            i18nName(): string;
            i18nSubcategory(): string;
            increment(): number;
            max(): number;
            maxF(): number;
            min(): number;
            minF(): number;
            name(): string;
            options(): Array<string>;
            placeholder(): string;
            protectedText(): boolean;
            searchTags(): Array<string>;
            subcategory(): string;
            triggerActionOnInitialization(): boolean;
            type(): gg.essential.vigilance.data.PropertyType;
          }
          const PropertyAttributesExt: {
            new(propertyAttributes: gg.essential.vigilance.data.PropertyAttributes): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean, searchTags: Array<string>): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean, searchTags: Array<string>, i18nName: string, i18nCategory: string, i18nSubcategory: string): gg.essential.vigilance.data.PropertyAttributesExt;
            new(type: gg.essential.vigilance.data.PropertyType, name: string, category: string, subcategory: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, protected: boolean, triggerActionOnInitialization: boolean, hidden: boolean, searchTags: Array<string>, i18nName: string, i18nCategory: string, i18nSubcategory: string, customPropertyInfo: java.lang.Class<unknown>): gg.essential.vigilance.data.PropertyAttributesExt;
          }
          interface PropertyAttributesExt { 
            getAllowAlpha(): boolean;
            getCategory(): string;
            getCustomPropertyInfo(): java.lang.Class<unknown>;
            getDecimalPlaces(): number;
            getDescription(): string;
            getHidden(): boolean;
            setHidden(value: boolean): void;
            getIncrement(): number;
            getMax(): number;
            getMaxF(): number;
            getMin(): number;
            getMinF(): number;
            getName(): string;
            getOptions(): Array<string>;
            getPlaceholder(): string;
            getProtected(): boolean;
            getSearchTags(): Array<string>;
            getSubcategory(): string;
            getTriggerActionOnInitialization(): boolean;
            getType(): gg.essential.vigilance.data.PropertyType;
          }
          interface PropertyAttributesExt$Companion { 
            fromPropertyAnnotation(property: gg.essential.vigilance.data.Property): gg.essential.vigilance.data.PropertyAttributesExt;
          }
          const PropertyValue: {
            new(): gg.essential.vigilance.data.PropertyValue;
          }
          interface PropertyValue { 
            getInitialized(): boolean;
            setInitialized(value: boolean): void;
            getWriteDataToFile(): boolean;
            getValue(instance: gg.essential.vigilance.Vigilant): any | null | undefined;
            setValue(value: any | null | undefined, instance: gg.essential.vigilance.Vigilant): void;
          }
          interface PropertyData$Companion { 
            fromField(property: gg.essential.vigilance.data.Property, field: java.lang.reflect.Field, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
            fromField(propertyAttributes: gg.essential.vigilance.data.PropertyAttributes, field: java.lang.reflect.Field, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
            fromMethod(property: gg.essential.vigilance.data.Property, method: java.lang.reflect.Method, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
            withValue(property: gg.essential.vigilance.data.Property, obj: any | null | undefined, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.data.PropertyData;
          }
          const PropertyCollector: {
            new(): gg.essential.vigilance.data.PropertyCollector;
          }
          interface PropertyCollector { 
            addProperty(propertyData: gg.essential.vigilance.data.PropertyData): void;
            getProperties(): Array<gg.essential.vigilance.data.PropertyData>;
            initialize(instance: gg.essential.vigilance.Vigilant): void;
          }
        }
        namespace gui {
          const SettingsGui: {
            new(config: gg.essential.vigilance.Vigilant): gg.essential.vigilance.gui.SettingsGui;
          }
          interface SettingsGui extends gg.essential.elementa.WindowScreen { 
            selectCategory(category: gg.essential.vigilance.data.Category): void;
          }
          interface SettingsGui$Companion { 
            getAnimTime(): number;
          }
        }
        const Vigilant: {
          CategoryDescription: typeof gg.essential.vigilance.Vigilant$CategoryDescription;
          CategoryPropertyBuilder: typeof gg.essential.vigilance.Vigilant$CategoryPropertyBuilder;
          new(file: java.io.File): gg.essential.vigilance.Vigilant;
          new(file: java.io.File, guiTitle: string): gg.essential.vigilance.Vigilant;
          new(file: java.io.File, guiTitle: string, propertyCollector: gg.essential.vigilance.data.PropertyCollector): gg.essential.vigilance.Vigilant;
          new(file: java.io.File, guiTitle: string, propertyCollector: gg.essential.vigilance.data.PropertyCollector, sortingBehavior: gg.essential.vigilance.data.SortingBehavior): gg.essential.vigilance.Vigilant;
        }
        interface Vigilant { 
          getGuiTitle(): string;
          getSortingBehavior(): gg.essential.vigilance.data.SortingBehavior;
          addDependency(field: java.lang.reflect.Field, dependency: java.lang.reflect.Field): void;
          addDependency<T>(field: java.lang.reflect.Field, dependency: java.lang.reflect.Field, predicate: kotlin.Function1<T, boolean>): void;
          addDependency(propertyName: string, dependencyName: string): void;
          addDependency<T>(propertyName: string, dependencyName: string, predicate: kotlin.Function1<T, boolean>): void;
          addDependency<T>(property: kotlin.reflect.KProperty<T>, dependency: kotlin.reflect.KProperty<T>): void;
          addInverseDependency(field: java.lang.reflect.Field, dependency: java.lang.reflect.Field): void;
          addInverseDependency(propertyName: string, dependencyName: string): void;
          category(name: string, builder: kotlin.Function1<gg.essential.vigilance.Vigilant$CategoryPropertyBuilder, void>): void;
          getCategories(): Array<gg.essential.vigilance.data.Category>;
          getCategoryFromSearch(term: string): gg.essential.vigilance.data.Category;
          gui(): gg.essential.vigilance.gui.SettingsGui | null | undefined;
          hidePropertyIf(field: java.lang.reflect.Field, condition: kotlin.Function0<boolean>): void;
          hidePropertyIf(field: java.lang.reflect.Field, condition: boolean): void;
          hidePropertyIf(propertyName: string, condition: kotlin.Function0<boolean>): void;
          hidePropertyIf<T>(property: kotlin.reflect.KProperty<T>, condition: kotlin.Function0<boolean>): void;
          initialize(): void;
          loadData(): void;
          markDirty(): void;
          preload(): void;
          registerListener<T>(field: java.lang.reflect.Field, listener: unknown): void;
          registerListener<T>(propertyName: string, listener: unknown): void;
          registerListener<T>(property: kotlin.reflect.KProperty<T>, listener: kotlin.Function1<T, void>): void;
          registerProperty(prop: gg.essential.vigilance.data.PropertyData): void;
          setCategoryDescription(category: string, description: string): void;
          setSubcategoryDescription(category: string, subcategory: string, description: string): void;
          writeData(): void;
          dependsOn<T>(dependency: kotlin.reflect.KProperty<T>): void;
          hiddenIf<T>(condition: kotlin.Function0<boolean>): void;
        }
        const Vigilant$CategoryDescription: {
          new(description: string | null | undefined, subcategoryDescriptions: Map<string, string>): gg.essential.vigilance.Vigilant$CategoryDescription;
        }
        interface Vigilant$CategoryDescription { 
          getDescription(): string | null | undefined;
          setDescription(value: string | null | undefined): void;
          getSubcategoryDescriptions(): Map<string, string>;
          component1(): string | null | undefined;
          component2(): Map<string, string>;
          copy(description: string | null | undefined, subcategoryDescriptions: Map<string, string>): gg.essential.vigilance.Vigilant$CategoryDescription;
        }
        const Vigilant$CategoryPropertyBuilder: {
          new(category: string, subcategory: string, instance: gg.essential.vigilance.Vigilant): gg.essential.vigilance.Vigilant$CategoryPropertyBuilder;
        }
        interface Vigilant$CategoryPropertyBuilder { 
          button(name: string, description: string, buttonText: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function0<void>): void;
          checkbox(field: kotlin.reflect.KMutableProperty0<boolean>, name: string, description: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<boolean, void> | null | undefined): void;
          color(field: kotlin.reflect.KMutableProperty0<java.awt.Color>, name: string, description: string, allowAlpha: boolean, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<java.awt.Color, void> | null | undefined): void;
          custom(field: kotlin.reflect.KMutableProperty0<any | null | undefined>, customPropertyInfo: kotlin.reflect.KClass<unknown>, name: string, description: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<any | null | undefined, void> | null | undefined): void;
          decimalSlider(field: kotlin.reflect.KMutableProperty0<number>, name: string, description: string, min: number, max: number, decimalPlaces: number, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<number, void> | null | undefined): void;
          number(field: kotlin.reflect.KMutableProperty0<number>, name: string, description: string, min: number, max: number, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<number, void> | null | undefined): void;
          paragraph(field: kotlin.reflect.KMutableProperty0<string>, name: string, description: string, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<string, void> | null | undefined): void;
          percentSlider(field: kotlin.reflect.KMutableProperty0<number>, name: string, description: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<number, void> | null | undefined): void;
          property<T>(value: gg.essential.vigilance.data.PropertyValue, type: gg.essential.vigilance.data.PropertyType, name: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<T, void> | null | undefined): void;
          property<T>(value: gg.essential.vigilance.data.PropertyValue, type: gg.essential.vigilance.data.PropertyType, name: string, description: string, searchTags: Array<string>, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<T, void> | null | undefined): void;
          property<T>(field: kotlin.reflect.KMutableProperty0<T>, type: gg.essential.vigilance.data.PropertyType, name: string, description: string, min: number, max: number, minF: number, maxF: number, decimalPlaces: number, increment: number, options: Array<string>, allowAlpha: boolean, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<T, void> | null | undefined): void;
          selector(field: kotlin.reflect.KMutableProperty0<number>, name: string, description: string, options: Array<string>, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<number, void> | null | undefined): void;
          slider(field: kotlin.reflect.KMutableProperty0<number>, name: string, description: string, min: number, max: number, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<number, void> | null | undefined): void;
          subcategory(subcategory: string, builder: kotlin.Function1<gg.essential.vigilance.Vigilant$CategoryPropertyBuilder, void>): void;
          text(field: kotlin.reflect.KMutableProperty0<string>, name: string, description: string, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, action: kotlin.Function1<string, void> | null | undefined): void;
          text(field: kotlin.reflect.KMutableProperty0<string>, name: string, description: string, placeholder: string, triggerActionOnInitialization: boolean, hidden: boolean, protectedText: boolean, action: kotlin.Function1<string, void> | null | undefined): void;
        }
      }
      namespace elementa {
        namespace components {
          const Window: {
            new(): gg.essential.elementa.components.Window;
            new(animationFPS: number): gg.essential.elementa.components.Window;
            new(version: gg.essential.elementa.ElementaVersion): gg.essential.elementa.components.Window;
            new(version: gg.essential.elementa.ElementaVersion, animationFPS: number): gg.essential.elementa.components.Window;
          }
          interface Window extends gg.essential.elementa.UIComponent { 
            getAnimationFPS(): number;
            getAnimationTimeMs(): number;
            getAnimationTimeNs(): number;
            getFocusedComponent(): gg.essential.elementa.UIComponent | null | undefined;
            getHasErrored(): boolean;
            getHoveredFloatingComponent(): gg.essential.elementa.UIComponent | null | undefined;
            setHoveredFloatingComponent(value: gg.essential.elementa.UIComponent | null | undefined): void;
            addFloatingComponent(component: gg.essential.elementa.UIComponent): void;
            drawFloatingComponents(): void;
            drawFloatingComponents(matrixStack: gg.essential.universal.UMatrixStack): void;
            focus(component: gg.essential.elementa.UIComponent): void;
            invalidateCachedConstraints(): void;
            isAreaVisible(left: number, top: number, right: number, bottom: number): boolean;
            removeFloatingComponent(component: gg.essential.elementa.UIComponent): void;
            unfocus(): void;
          }
          interface Window$Companion { 
            enqueueRenderOperation(operation: kotlin.Function0<void>): void;
            enqueueRenderOperation(operation: java.lang.Runnable): void;
            of(component: gg.essential.elementa.UIComponent): gg.essential.elementa.components.Window;
            ofOrNull(component: gg.essential.elementa.UIComponent): gg.essential.elementa.components.Window | null | undefined;
          }
        }
        namespace state {
          namespace v2 {
            interface ReferenceHolder { 
              holdOnto(listener: any): kotlin.Function0<void>;
            }
            interface ReferenceHolder$Weak extends gg.essential.elementa.state.v2.ReferenceHolder { 
            }
          }
        }
        namespace utils {
          const ObservableList: {
            new<T>(wrapped: Array<T>): gg.essential.elementa.utils.ObservableList<T>;
          }
          interface ObservableList<T> extends java.util.Observable, Array<T> { 
          }
          interface TriConsumer<T, U, V> { 
            accept(t: T, u: U, v: V): void;
            (t: T, u: U, v: V): void;
          }
        }
        namespace constraints {
          namespace resolution {
            const ConstraintVisitor: {
              new(graph: gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<unknown>, component: gg.essential.elementa.UIComponent): gg.essential.elementa.constraints.resolution.ConstraintVisitor;
            }
            interface ConstraintVisitor { 
              getComponent(): gg.essential.elementa.UIComponent;
              setConstraint(constraint: gg.essential.elementa.constraints.SuperConstraint<any>, type: gg.essential.elementa.constraints.ConstraintType): void;
              visitChildren(type: gg.essential.elementa.constraints.ConstraintType): void;
              visitParent(type: gg.essential.elementa.constraints.ConstraintType): void;
              visitSelf(type: gg.essential.elementa.constraints.ConstraintType): void;
              visitSibling(type: gg.essential.elementa.constraints.ConstraintType, index: number): void;
            }
            const DirectedAcyclicGraph: {
              new<T>(): gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<T>;
            }
            interface DirectedAcyclicGraph<T> { 
              addEdge(first: T, second: T): gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<T>;
              addEdges(edges: kotlin.Pair<T, T>): gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<T>;
              addVertex(vertex: T): gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<T>;
              addVertices(vertices: T): gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph<T>;
              getCyclicLoop(): Array<T> | null | undefined;
            }
          }
          namespace animation {
            const AnimatingConstraints: {
              new(component: gg.essential.elementa.UIComponent, oldConstraints: gg.essential.elementa.UIConstraints): gg.essential.elementa.constraints.animation.AnimatingConstraints;
            }
            interface AnimatingConstraints extends gg.essential.elementa.UIConstraints { 
              getCompleteAction(): kotlin.Function0<void>;
              setCompleteAction(value: kotlin.Function0<void>): void;
              begin(): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              onComplete(method: kotlin.Function0<void>): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              onCompleteRunnable(method: java.lang.Runnable): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setColorAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.ColorConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setColorAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.ColorConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setExtraDelay(delay: number): void;
              setHeightAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setHeightAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.HeightConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setRadiusAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.RadiusConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setRadiusAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.RadiusConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setTextScaleAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setTextScaleAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.HeightConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setWidthAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.WidthConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setWidthAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.WidthConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setXAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.XConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setXAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.XConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setYAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.YConstraint): gg.essential.elementa.constraints.animation.AnimatingConstraints;
              setYAnimation(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newConstraint: gg.essential.elementa.constraints.YConstraint, delay: number): gg.essential.elementa.constraints.animation.AnimatingConstraints;
            }
            interface AnimationStrategy { 
              getValue(percentComplete: number): number;
            }
          }
          interface ColorConstraint extends gg.essential.elementa.constraints.SuperConstraint<java.awt.Color> { 
            getColor(component: gg.essential.elementa.UIComponent): java.awt.Color;
            getColorImpl(component: gg.essential.elementa.UIComponent): java.awt.Color;
          }
          interface SuperConstraint<T> { 
            getCachedValue(): T;
            setCachedValue(value: T): void;
            getConstrainTo(): gg.essential.elementa.UIComponent | null | undefined;
            setConstrainTo(value: gg.essential.elementa.UIComponent | null | undefined): void;
            getRecalculate(): boolean;
            setRecalculate(value: boolean): void;
            animationFrame(): void;
            pauseIfSupported(): void;
            resumeIfSupported(): void;
            stopIfSupported(): void;
            to(component: gg.essential.elementa.UIComponent): gg.essential.elementa.constraints.SuperConstraint<T>;
            visit(visitor: gg.essential.elementa.constraints.resolution.ConstraintVisitor, type: gg.essential.elementa.constraints.ConstraintType, setNewConstraint: boolean): void;
            visitImpl(visitor: gg.essential.elementa.constraints.resolution.ConstraintVisitor, type: gg.essential.elementa.constraints.ConstraintType): void;
          }
          const ConstraintType: {
            X: gg.essential.elementa.constraints.ConstraintType;
            Y: gg.essential.elementa.constraints.ConstraintType;
            WIDTH: gg.essential.elementa.constraints.ConstraintType;
            HEIGHT: gg.essential.elementa.constraints.ConstraintType;
            RADIUS: gg.essential.elementa.constraints.ConstraintType;
            COLOR: gg.essential.elementa.constraints.ConstraintType;
            FONT_PROVIDER: gg.essential.elementa.constraints.ConstraintType;
            TEXT_SCALE: gg.essential.elementa.constraints.ConstraintType;
            valueOf(value: string): gg.essential.elementa.constraints.ConstraintType;
            values(): Array<gg.essential.elementa.constraints.ConstraintType>;
          }
          interface ConstraintType extends kotlin.Enum<gg.essential.elementa.constraints.ConstraintType> { 
            getPrettyName(): string;
          }
          interface HeightConstraint extends gg.essential.elementa.constraints.SuperConstraint<number> { 
            getHeight(component: gg.essential.elementa.UIComponent): number;
            getHeightImpl(component: gg.essential.elementa.UIComponent): number;
            getTextScale(component: gg.essential.elementa.UIComponent): number;
          }
          interface RadiusConstraint extends gg.essential.elementa.constraints.SuperConstraint<number> { 
            getRadius(component: gg.essential.elementa.UIComponent): number;
            getRadiusImpl(component: gg.essential.elementa.UIComponent): number;
          }
          interface WidthConstraint extends gg.essential.elementa.constraints.SuperConstraint<number> { 
            getWidth(component: gg.essential.elementa.UIComponent): number;
            getWidthImpl(component: gg.essential.elementa.UIComponent): number;
          }
          interface XConstraint extends gg.essential.elementa.constraints.SuperConstraint<number> { 
            getXPosition(component: gg.essential.elementa.UIComponent): number;
            getXPositionImpl(component: gg.essential.elementa.UIComponent): number;
          }
          interface YConstraint extends gg.essential.elementa.constraints.SuperConstraint<number> { 
            getYPosition(component: gg.essential.elementa.UIComponent): number;
            getYPositionImpl(component: gg.essential.elementa.UIComponent): number;
          }
        }
        namespace font {
          interface FontProvider extends gg.essential.elementa.constraints.SuperConstraint<gg.essential.elementa.font.FontProvider> { 
            drawString(matrixStack: gg.essential.universal.UMatrixStack, string: string, color: java.awt.Color, x: number, y: number, originalPointSize: number, scale: number, shadow: boolean, shadowColor: java.awt.Color | null | undefined): void;
            drawString(string: string, color: java.awt.Color, x: number, y: number, originalPointSize: number, scale: number, shadow: boolean, shadowColor: java.awt.Color | null | undefined): void;
            getBaseLineHeight(): number;
            getBelowLineHeight(): number;
            getShadowHeight(): number;
            getStringHeight(string: string, pointSize: number): number;
            getStringWidth(string: string, pointSize: number): number;
          }
        }
        namespace effects {
          const Effect: {
            new(): gg.essential.elementa.effects.Effect;
          }
          interface Effect { 
            afterDraw(): void;
            afterDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
            afterDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
            animationFrame(): void;
            beforeChildrenDraw(): void;
            beforeChildrenDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
            beforeChildrenDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
            beforeDraw(): void;
            beforeDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
            beforeDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
            bindComponent(component: gg.essential.elementa.UIComponent): void;
            setup(): void;
          }
        }
        namespace events {
          const UIClickEvent: {
            new(absoluteX: number, absoluteY: number, mouseButton: number, target: gg.essential.elementa.UIComponent, currentTarget: gg.essential.elementa.UIComponent, clickCount: number): gg.essential.elementa.events.UIClickEvent;
          }
          interface UIClickEvent extends gg.essential.elementa.events.UIEvent { 
            getAbsoluteX(): number;
            getAbsoluteY(): number;
            getClickCount(): number;
            getCurrentTarget(): gg.essential.elementa.UIComponent;
            getMouseButton(): number;
            getRelativeX(): number;
            getRelativeY(): number;
            getTarget(): gg.essential.elementa.UIComponent;
            component1(): number;
            component2(): number;
            component3(): number;
            component4(): gg.essential.elementa.UIComponent;
            component5(): gg.essential.elementa.UIComponent;
            component6(): number;
            copy(absoluteX: number, absoluteY: number, mouseButton: number, target: gg.essential.elementa.UIComponent, currentTarget: gg.essential.elementa.UIComponent, clickCount: number): gg.essential.elementa.events.UIClickEvent;
          }
          const UIEvent: {
            new(): gg.essential.elementa.events.UIEvent;
          }
          interface UIEvent { 
            getPropagationStopped(): boolean;
            setPropagationStopped(value: boolean): void;
            getPropagationStoppedImmediately(): boolean;
            setPropagationStoppedImmediately(value: boolean): void;
            stopImmediatePropagation(): void;
            stopPropagation(): void;
          }
          const UIScrollEvent: {
            new(delta: number, target: gg.essential.elementa.UIComponent, currentTarget: gg.essential.elementa.UIComponent): gg.essential.elementa.events.UIScrollEvent;
          }
          interface UIScrollEvent extends gg.essential.elementa.events.UIEvent { 
            getCurrentTarget(): gg.essential.elementa.UIComponent;
            getDelta(): number;
            getTarget(): gg.essential.elementa.UIComponent;
            component1(): number;
            component2(): gg.essential.elementa.UIComponent;
            component3(): gg.essential.elementa.UIComponent;
            copy(delta: number, target: gg.essential.elementa.UIComponent, currentTarget: gg.essential.elementa.UIComponent): gg.essential.elementa.events.UIScrollEvent;
          }
        }
        const WindowScreen: {
          new(): gg.essential.elementa.WindowScreen;
          new(enableRepeatKeys: boolean): gg.essential.elementa.WindowScreen;
          new(enableRepeatKeys: boolean, drawDefaultBackground: boolean): gg.essential.elementa.WindowScreen;
          new(enableRepeatKeys: boolean, drawDefaultBackground: boolean, restoreCurrentGuiOnClose: boolean): gg.essential.elementa.WindowScreen;
          new(enableRepeatKeys: boolean, drawDefaultBackground: boolean, restoreCurrentGuiOnClose: boolean, newGuiScale: number): gg.essential.elementa.WindowScreen;
          new(version: gg.essential.elementa.ElementaVersion): gg.essential.elementa.WindowScreen;
          new(version: gg.essential.elementa.ElementaVersion, enableRepeatKeys: boolean): gg.essential.elementa.WindowScreen;
          new(version: gg.essential.elementa.ElementaVersion, enableRepeatKeys: boolean, drawDefaultBackground: boolean): gg.essential.elementa.WindowScreen;
          new(version: gg.essential.elementa.ElementaVersion, enableRepeatKeys: boolean, drawDefaultBackground: boolean, restoreCurrentGuiOnClose: boolean): gg.essential.elementa.WindowScreen;
          new(version: gg.essential.elementa.ElementaVersion, enableRepeatKeys: boolean, drawDefaultBackground: boolean, restoreCurrentGuiOnClose: boolean, newGuiScale: number): gg.essential.elementa.WindowScreen;
        }
        interface WindowScreen extends gg.essential.universal.UScreen { 
          getWindow(): gg.essential.elementa.components.Window;
          afterInitialization(): void;
          defaultKeyBehavior(typedChar: number, keyCode: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: java.awt.Color, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          stopAnimating(): void;
        }
        const UIComponent: {
          new(): gg.essential.elementa.UIComponent;
        }
        interface UIComponent extends java.util.Observable, gg.essential.elementa.state.v2.ReferenceHolder { 
          getChildren(): gg.essential.elementa.utils.ObservableList<gg.essential.elementa.UIComponent>;
          getComponentName(): string;
          setComponentName(value: string): void;
          getConstraints(): gg.essential.elementa.UIConstraints;
          setConstraints(value: gg.essential.elementa.UIConstraints): void;
          getEffects(): Array<gg.essential.elementa.effects.Effect>;
          getHasParent(): boolean;
          isFloating(): boolean;
          setIsFloating(value: boolean): void;
          getKeyTypedListeners(): Array<kotlin.Function3<gg.essential.elementa.UIComponent, number, number, void>>;
          getLastDraggedMouseX(): number | null | undefined;
          setLastDraggedMouseX(value: number | null | undefined): void;
          getLastDraggedMouseY(): number | null | undefined;
          setLastDraggedMouseY(value: number | null | undefined): void;
          getMouseClickListeners(): Array<kotlin.Function2<gg.essential.elementa.UIComponent, gg.essential.elementa.events.UIClickEvent, void>>;
          getMouseDragListeners(): Array<kotlin.Function4<gg.essential.elementa.UIComponent, number, number, number, void>>;
          getMouseEnterListeners(): Array<kotlin.Function1<gg.essential.elementa.UIComponent, void>>;
          getMouseLeaveListeners(): Array<kotlin.Function1<gg.essential.elementa.UIComponent, void>>;
          getMouseReleaseListeners(): Array<kotlin.Function1<gg.essential.elementa.UIComponent, void>>;
          getMouseScrollListeners(): Array<kotlin.Function2<gg.essential.elementa.UIComponent, gg.essential.elementa.events.UIScrollEvent, void>>;
          setMouseScrollListeners(value: Array<kotlin.Function2<gg.essential.elementa.UIComponent, gg.essential.elementa.events.UIScrollEvent, void>>): void;
          getParent(): gg.essential.elementa.UIComponent;
          setParent(value: gg.essential.elementa.UIComponent): void;
          addChild(component: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          addChildren(components: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          addUpdateFunc(func: kotlin.Function2<number, number, void>): void;
          afterDraw(): void;
          afterDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
          afterDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
          afterInitialization(): void;
          alwaysDrawChildren(): boolean;
          animateAfterUnhide(animation: kotlin.Function1<gg.essential.elementa.constraints.animation.AnimatingConstraints, void>): gg.essential.elementa.UIComponent;
          animateBeforeHide(animation: kotlin.Function1<gg.essential.elementa.constraints.animation.AnimatingConstraints, void>): gg.essential.elementa.UIComponent;
          animateTo(constraints: gg.essential.elementa.constraints.animation.AnimatingConstraints): void;
          animationFrame(): void;
          beforeChildrenDraw(): void;
          beforeChildrenDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
          beforeChildrenDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
          beforeDraw(): void;
          beforeDraw(matrixStack: gg.essential.universal.UMatrixStack): void;
          beforeDrawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
          childrenOfType<T>(): Array<T>;
          childrenOfType<T>(clazz: java.lang.Class<T>): Array<T>;
          clearChildren(): gg.essential.elementa.UIComponent;
          delay(delay: number, callback: kotlin.Function0<void>): kotlin.Function0<void>;
          depth(): number;
          dragMouse(mouseX: number, mouseY: number, button: number): void;
          dragMouse(mouseX: number, mouseY: number, button: number): void;
          draw(): void;
          draw(matrixStack: gg.essential.universal.UMatrixStack): void;
          drawCompat(matrixStack: gg.essential.universal.UMatrixStack): void;
          enableEffect(effect: gg.essential.elementa.effects.Effect): gg.essential.elementa.UIComponent;
          enableEffects(effects: gg.essential.elementa.effects.Effect): gg.essential.elementa.UIComponent;
          focus(): void;
          getBottom(): number;
          getColor(): java.awt.Color;
          getFontProvider(): gg.essential.elementa.font.FontProvider;
          getHeight(): number;
          getLeft(): number;
          getRadius(): number;
          getRight(): number;
          getTextScale(): number;
          getTop(): number;
          getWidth(): number;
          grabWindowFocus(): void;
          hasFocus(): boolean;
          hide(): void;
          hide(instantly: boolean): void;
          hitTest(x: number, y: number): gg.essential.elementa.UIComponent;
          insertChildAfter(newComponent: gg.essential.elementa.UIComponent, targetComponent: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          insertChildAt(component: gg.essential.elementa.UIComponent, index: number): gg.essential.elementa.UIComponent;
          insertChildBefore(newComponent: gg.essential.elementa.UIComponent, targetComponent: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          isChildOf(component: gg.essential.elementa.UIComponent): boolean;
          isHovered(): boolean;
          isPointInside(x: number, y: number): boolean;
          isPositionCenter(): boolean;
          keyType(typedChar: number, keyCode: number): void;
          loseFocus(): void;
          makeAnimation(): gg.essential.elementa.constraints.animation.AnimatingConstraints;
          mouseClick(mouseX: number, mouseY: number, button: number): void;
          mouseDrag(mouseX: number, mouseY: number, button: number): void;
          mouseMove(window: gg.essential.elementa.components.Window): void;
          mouseRelease(): void;
          mouseScroll(delta: number): void;
          onFocus(listener: kotlin.Function1<gg.essential.elementa.UIComponent, void>): gg.essential.elementa.UIComponent;
          onFocusLost(listener: kotlin.Function1<gg.essential.elementa.UIComponent, void>): gg.essential.elementa.UIComponent;
          onKeyType(method: kotlin.Function3<gg.essential.elementa.UIComponent, number, number, void>): gg.essential.elementa.UIComponent;
          onKeyTypeConsumer(method: unknown): void;
          onMouseClick(method: kotlin.Function2<gg.essential.elementa.UIComponent, gg.essential.elementa.events.UIClickEvent, void>): gg.essential.elementa.UIComponent;
          onMouseClickConsumer(method: unknown): gg.essential.elementa.UIComponent;
          onMouseDrag(method: kotlin.Function4<gg.essential.elementa.UIComponent, number, number, number, void>): gg.essential.elementa.UIComponent;
          onMouseDragConsumer(method: gg.essential.elementa.utils.TriConsumer<number, number, number>): gg.essential.elementa.UIComponent;
          onMouseEnter(method: kotlin.Function1<gg.essential.elementa.UIComponent, void>): gg.essential.elementa.UIComponent;
          onMouseEnterRunnable(method: java.lang.Runnable): gg.essential.elementa.UIComponent;
          onMouseLeave(method: kotlin.Function1<gg.essential.elementa.UIComponent, void>): gg.essential.elementa.UIComponent;
          onMouseLeaveRunnable(method: java.lang.Runnable): gg.essential.elementa.UIComponent;
          onMouseRelease(method: kotlin.Function1<gg.essential.elementa.UIComponent, void>): gg.essential.elementa.UIComponent;
          onMouseReleaseRunnable(method: java.lang.Runnable): gg.essential.elementa.UIComponent;
          onMouseScroll(method: kotlin.Function2<gg.essential.elementa.UIComponent, gg.essential.elementa.events.UIScrollEvent, void>): gg.essential.elementa.UIComponent;
          onMouseScrollConsumer(method: unknown): gg.essential.elementa.UIComponent;
          onWindowResize(): void;
          releaseWindowFocus(): void;
          removeChild(component: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          removeEffect<T>(): void;
          removeEffect(effect: gg.essential.elementa.effects.Effect): void;
          removeEffect<T>(clazz: java.lang.Class<T>): void;
          removeUpdateFunc(func: kotlin.Function2<number, number, void>): void;
          replaceChild(newComponent: gg.essential.elementa.UIComponent, componentToReplace: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          setChildOf(parent: gg.essential.elementa.UIComponent): gg.essential.elementa.UIComponent;
          setColor(constraint: gg.essential.elementa.constraints.ColorConstraint): gg.essential.elementa.UIComponent;
          setColor(color: java.awt.Color): gg.essential.elementa.UIComponent;
          setFloating(floating: boolean): void;
          setFontProvider(fontProvider: gg.essential.elementa.font.FontProvider): gg.essential.elementa.UIComponent;
          setHeight(constraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.UIComponent;
          setRadius(constraint: gg.essential.elementa.constraints.RadiusConstraint): gg.essential.elementa.UIComponent;
          setTextScale(constraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.UIComponent;
          setWidth(constraint: gg.essential.elementa.constraints.WidthConstraint): gg.essential.elementa.UIComponent;
          setX(constraint: gg.essential.elementa.constraints.XConstraint): gg.essential.elementa.UIComponent;
          setY(constraint: gg.essential.elementa.constraints.YConstraint): gg.essential.elementa.UIComponent;
          startDelay(delay: number, callback: kotlin.Function0<void>): number;
          startTimer(interval: number, delay: number, callback: kotlin.Function1<number, void>): number;
          stopDelay(id: number): boolean;
          stopTimer(id: number): boolean;
          timer(interval: number, delay: number, callback: kotlin.Function1<number, void>): kotlin.Function0<void>;
          unhide(useLastPosition: boolean): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: java.awt.Color, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          animate(strategy: gg.essential.elementa.constraints.animation.AnimationStrategy, time: number, newValue: number, delay: number): void;
          stopAnimating(): void;
        }
        const UIConstraints: {
          new(component: gg.essential.elementa.UIComponent): gg.essential.elementa.UIConstraints;
        }
        interface UIConstraints extends java.util.Observable { 
          getColor(): gg.essential.elementa.constraints.ColorConstraint;
          setColor(value: gg.essential.elementa.constraints.ColorConstraint): void;
          getFontProvider(): gg.essential.elementa.font.FontProvider;
          setFontProvider(value: gg.essential.elementa.font.FontProvider): void;
          getHeight(): gg.essential.elementa.constraints.HeightConstraint;
          setHeight(value: gg.essential.elementa.constraints.HeightConstraint): void;
          getRadius(): gg.essential.elementa.constraints.RadiusConstraint;
          setRadius(value: gg.essential.elementa.constraints.RadiusConstraint): void;
          getTextScale(): gg.essential.elementa.constraints.HeightConstraint;
          setTextScale(value: gg.essential.elementa.constraints.HeightConstraint): void;
          getWidth(): gg.essential.elementa.constraints.WidthConstraint;
          setWidth(value: gg.essential.elementa.constraints.WidthConstraint): void;
          getX(): gg.essential.elementa.constraints.XConstraint;
          setX(value: gg.essential.elementa.constraints.XConstraint): void;
          getY(): gg.essential.elementa.constraints.YConstraint;
          setY(value: gg.essential.elementa.constraints.YConstraint): void;
          copy(): gg.essential.elementa.UIConstraints;
          finish(): gg.essential.elementa.UIComponent;
          getColor(): java.awt.Color;
          getHeight(): number;
          getRadius(): number;
          getTextScale(): number;
          getWidth(): number;
          getX(): number;
          getY(): number;
          withColor(constraint: gg.essential.elementa.constraints.ColorConstraint): gg.essential.elementa.UIConstraints;
          withFontProvider(setFontProvider: gg.essential.elementa.font.FontProvider): void;
          withHeight(constraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.UIConstraints;
          withRadius(constraint: gg.essential.elementa.constraints.RadiusConstraint): gg.essential.elementa.UIConstraints;
          withTextScale(constraint: gg.essential.elementa.constraints.HeightConstraint): gg.essential.elementa.UIConstraints;
          withWidth(constraint: gg.essential.elementa.constraints.WidthConstraint): gg.essential.elementa.UIConstraints;
          withX(constraint: gg.essential.elementa.constraints.XConstraint): gg.essential.elementa.UIConstraints;
          withY(constraint: gg.essential.elementa.constraints.YConstraint): gg.essential.elementa.UIConstraints;
        }
        const ElementaVersion: {
          V0: gg.essential.elementa.ElementaVersion;
          V1: gg.essential.elementa.ElementaVersion;
          V2: gg.essential.elementa.ElementaVersion;
          V3: gg.essential.elementa.ElementaVersion;
          V4: gg.essential.elementa.ElementaVersion;
          V5: gg.essential.elementa.ElementaVersion;
          V6: gg.essential.elementa.ElementaVersion;
          V7: gg.essential.elementa.ElementaVersion;
          V8: gg.essential.elementa.ElementaVersion;
          V9: gg.essential.elementa.ElementaVersion;
          V10: gg.essential.elementa.ElementaVersion;
          valueOf(value: string): gg.essential.elementa.ElementaVersion;
          values(): Array<gg.essential.elementa.ElementaVersion>;
        }
        interface ElementaVersion extends kotlin.Enum<gg.essential.elementa.ElementaVersion> { 
          enableFor<T>(block: kotlin.Function0<T>): T;
        }
        interface ElementaVersion$Companion { 
        }
        interface UIComponent$Companion { 
          getDEBUG_OUTLINE_WIDTH(): number;
          guiHint(number: number, roundDown: boolean): number;
          guiHint(number: number, roundDown: boolean): number;
        }
      }
    }
  }
  namespace net {
    namespace minecraft {
      namespace client {
        namespace option {
          const KeyBinding: {
            Category: typeof net.minecraft.client.option.KeyBinding$Category;
            onKeyPressed(key: net.minecraft.client.util.InputUtil$Key): void;
            setKeyPressed(key: net.minecraft.client.util.InputUtil$Key, pressed: boolean): void;
            updatePressedStates(): void;
            unpressAll(): void;
            restoreToggleStates(): void;
            untoggleStickyKeys(): void;
            updateKeysByCode(): void;
            getLocalizedName(id: string): unknown;
            byId(id: string): net.minecraft.client.option.KeyBinding | null | undefined;
            new(id: string, code: number, category: net.minecraft.client.option.KeyBinding$Category): net.minecraft.client.option.KeyBinding;
            new(id: string, type: net.minecraft.client.util.InputUtil$Type, code: number, category: net.minecraft.client.option.KeyBinding$Category): net.minecraft.client.option.KeyBinding;
          }
          interface KeyBinding extends kotlin.Comparable<net.minecraft.client.option.KeyBinding> { 
            isPressed(): boolean;
            getCategory(): net.minecraft.client.option.KeyBinding$Category;
            wasPressed(): boolean;
            getId(): string;
            getDefaultKey(): net.minecraft.client.util.InputUtil$Key;
            setBoundKey(boundKey: net.minecraft.client.util.InputUtil$Key): void;
            isUnbound(): boolean;
            matchesKey(key: net.minecraft.client.input.KeyInput): boolean;
            matchesMouse(click: net.minecraft.client.gui.Click): boolean;
            getBoundKeyLocalizedText(): net.minecraft.text.Text;
            isDefault(): boolean;
            getBoundKeyTranslationKey(): string;
            setPressed(pressed: boolean): void;
          }
          const KeyBinding$Category: {
            MOVEMENT: net.minecraft.client.option.KeyBinding$Category;
            MISC: net.minecraft.client.option.KeyBinding$Category;
            MULTIPLAYER: net.minecraft.client.option.KeyBinding$Category;
            GAMEPLAY: net.minecraft.client.option.KeyBinding$Category;
            INVENTORY: net.minecraft.client.option.KeyBinding$Category;
            CREATIVE: net.minecraft.client.option.KeyBinding$Category;
            SPECTATOR: net.minecraft.client.option.KeyBinding$Category;
            create(id: net.minecraft.util.Identifier): net.minecraft.client.option.KeyBinding$Category;
            new(identifier: net.minecraft.util.Identifier): net.minecraft.client.option.KeyBinding$Category;
          }
          interface KeyBinding$Category extends java.lang.Record { 
            getLabel(): net.minecraft.text.Text;
            id(): net.minecraft.util.Identifier;
          }
          const GameOptions: {
            field_32150: number;
            field_32153: number;
            field_32154: number;
            field_32155: number;
            EMPTY_STRING: string;
            MAX_FPS_LIMIT: number;
            GUI_SCALE_AUTO: number;
            getGenericValueText(prefix: net.minecraft.text.Text, value: net.minecraft.text.Text): net.minecraft.text.Text;
            getGenericValueText(prefix: net.minecraft.text.Text, value: number): net.minecraft.text.Text;
            getGenericValueOrOffText(prefix: net.minecraft.text.Text, value: number): net.minecraft.text.Text;
            new(client: net.minecraft.client.MinecraftClient, optionsFile: java.io.File): net.minecraft.client.option.GameOptions;
          }
          interface GameOptions { 
            resourcePacks: Array<string>;
            incompatibleResourcePacks: Array<string>;
            fullscreenResolution: string | null | undefined;
            hideServerAddress: boolean;
            advancedItemTooltips: boolean;
            pauseOnLostFocus: boolean;
            overrideWidth: number;
            overrideHeight: number;
            useNativeTransport: boolean;
            tutorialStep: net.minecraft.client.tutorial.TutorialStep;
            joinedFirstServer: boolean;
            glDebugVerbosity: number;
            skipMultiplayerWarning: boolean;
            forwardKey: net.minecraft.client.option.KeyBinding;
            leftKey: net.minecraft.client.option.KeyBinding;
            backKey: net.minecraft.client.option.KeyBinding;
            rightKey: net.minecraft.client.option.KeyBinding;
            jumpKey: net.minecraft.client.option.KeyBinding;
            sneakKey: net.minecraft.client.option.KeyBinding;
            sprintKey: net.minecraft.client.option.KeyBinding;
            inventoryKey: net.minecraft.client.option.KeyBinding;
            swapHandsKey: net.minecraft.client.option.KeyBinding;
            dropKey: net.minecraft.client.option.KeyBinding;
            useKey: net.minecraft.client.option.KeyBinding;
            attackKey: net.minecraft.client.option.KeyBinding;
            pickItemKey: net.minecraft.client.option.KeyBinding;
            chatKey: net.minecraft.client.option.KeyBinding;
            playerListKey: net.minecraft.client.option.KeyBinding;
            commandKey: net.minecraft.client.option.KeyBinding;
            socialInteractionsKey: net.minecraft.client.option.KeyBinding;
            screenshotKey: net.minecraft.client.option.KeyBinding;
            togglePerspectiveKey: net.minecraft.client.option.KeyBinding;
            smoothCameraKey: net.minecraft.client.option.KeyBinding;
            fullscreenKey: net.minecraft.client.option.KeyBinding;
            advancementsKey: net.minecraft.client.option.KeyBinding;
            quickActionsKey: net.minecraft.client.option.KeyBinding;
            hotbarKeys: Array<net.minecraft.client.option.KeyBinding>;
            saveToolbarActivatorKey: net.minecraft.client.option.KeyBinding;
            loadToolbarActivatorKey: net.minecraft.client.option.KeyBinding;
            spectatorOutlinesKey: net.minecraft.client.option.KeyBinding;
            spectatorHotbarKey: net.minecraft.client.option.KeyBinding;
            allKeys: Array<net.minecraft.client.option.KeyBinding>;
            hudHidden: boolean;
            lastServer: string;
            smoothCameraEnabled: boolean;
            language: string;
            onboardAccessibility: boolean;
            syncChunkWrites: boolean;
            startedCleanly: boolean;
            getMonochromeLogo(): net.minecraft.client.option.SimpleOption<boolean>;
            getHideLightningFlashes(): net.minecraft.client.option.SimpleOption<boolean>;
            getHideSplashTexts(): net.minecraft.client.option.SimpleOption<boolean>;
            getMouseSensitivity(): net.minecraft.client.option.SimpleOption<number>;
            getViewDistance(): net.minecraft.client.option.SimpleOption<number>;
            getSimulationDistance(): net.minecraft.client.option.SimpleOption<number>;
            getEntityDistanceScaling(): net.minecraft.client.option.SimpleOption<number>;
            getMaxFps(): net.minecraft.client.option.SimpleOption<number>;
            getInactivityFpsLimit(): net.minecraft.client.option.SimpleOption<unknown>;
            getCloudRenderMode(): net.minecraft.client.option.SimpleOption<net.minecraft.client.option.CloudRenderMode>;
            getCloudRenderDistance(): net.minecraft.client.option.SimpleOption<number>;
            getGraphicsMode(): net.minecraft.client.option.SimpleOption<net.minecraft.client.option.GraphicsMode>;
            getAo(): net.minecraft.client.option.SimpleOption<boolean>;
            getChunkBuilderMode(): net.minecraft.client.option.SimpleOption<unknown>;
            refreshResourcePacks(resourcePackManager: net.minecraft.resource.ResourcePackManager): void;
            getChatVisibility(): net.minecraft.client.option.SimpleOption<net.minecraft.network.message.ChatVisibility>;
            getChatOpacity(): net.minecraft.client.option.SimpleOption<number>;
            getChatLineSpacing(): net.minecraft.client.option.SimpleOption<number>;
            getMenuBackgroundBlurriness(): net.minecraft.client.option.SimpleOption<number>;
            getMenuBackgroundBlurrinessValue(): number;
            getTextBackgroundOpacity(): net.minecraft.client.option.SimpleOption<number>;
            getTextBackgroundOpacity(fallback: number): number;
            getPanoramaSpeed(): net.minecraft.client.option.SimpleOption<number>;
            getHighContrast(): net.minecraft.client.option.SimpleOption<boolean>;
            getHighContrastBlockOutline(): net.minecraft.client.option.SimpleOption<boolean>;
            getNarratorHotkey(): net.minecraft.client.option.SimpleOption<boolean>;
            getMainArm(): net.minecraft.client.option.SimpleOption<net.minecraft.util.Arm>;
            getChatScale(): net.minecraft.client.option.SimpleOption<number>;
            getChatWidth(): net.minecraft.client.option.SimpleOption<number>;
            getChatHeightUnfocused(): net.minecraft.client.option.SimpleOption<number>;
            getChatHeightFocused(): net.minecraft.client.option.SimpleOption<number>;
            getChatDelay(): net.minecraft.client.option.SimpleOption<number>;
            getNotificationDisplayTime(): net.minecraft.client.option.SimpleOption<number>;
            getMipmapLevels(): net.minecraft.client.option.SimpleOption<number>;
            getAttackIndicator(): net.minecraft.client.option.SimpleOption<unknown>;
            getBiomeBlendRadius(): net.minecraft.client.option.SimpleOption<number>;
            getMouseWheelSensitivity(): net.minecraft.client.option.SimpleOption<number>;
            getRawMouseInput(): net.minecraft.client.option.SimpleOption<boolean>;
            getAllowCursorChanges(): net.minecraft.client.option.SimpleOption<boolean>;
            getAutoJump(): net.minecraft.client.option.SimpleOption<boolean>;
            getRotateWithMinecart(): net.minecraft.client.option.SimpleOption<boolean>;
            getOperatorItemsTab(): net.minecraft.client.option.SimpleOption<boolean>;
            getAutoSuggestions(): net.minecraft.client.option.SimpleOption<boolean>;
            getChatColors(): net.minecraft.client.option.SimpleOption<boolean>;
            getChatLinks(): net.minecraft.client.option.SimpleOption<boolean>;
            getChatLinksPrompt(): net.minecraft.client.option.SimpleOption<boolean>;
            getEnableVsync(): net.minecraft.client.option.SimpleOption<boolean>;
            getEntityShadows(): net.minecraft.client.option.SimpleOption<boolean>;
            getForceUnicodeFont(): net.minecraft.client.option.SimpleOption<boolean>;
            getJapaneseGlyphVariants(): net.minecraft.client.option.SimpleOption<boolean>;
            getInvertMouseX(): net.minecraft.client.option.SimpleOption<boolean>;
            getInvertMouseY(): net.minecraft.client.option.SimpleOption<boolean>;
            getDiscreteMouseScroll(): net.minecraft.client.option.SimpleOption<boolean>;
            getRealmsNotifications(): net.minecraft.client.option.SimpleOption<boolean>;
            getAllowServerListing(): net.minecraft.client.option.SimpleOption<boolean>;
            getReducedDebugInfo(): net.minecraft.client.option.SimpleOption<boolean>;
            getSoundVolume(category: net.minecraft.sound.SoundCategory): number;
            getCategorySoundVolume(category: net.minecraft.sound.SoundCategory): number;
            getSoundVolumeOption(category: net.minecraft.sound.SoundCategory): net.minecraft.client.option.SimpleOption<number>;
            getShowSubtitles(): net.minecraft.client.option.SimpleOption<boolean>;
            getDirectionalAudio(): net.minecraft.client.option.SimpleOption<boolean>;
            getBackgroundForChatOnly(): net.minecraft.client.option.SimpleOption<boolean>;
            getTouchscreen(): net.minecraft.client.option.SimpleOption<boolean>;
            getFullscreen(): net.minecraft.client.option.SimpleOption<boolean>;
            getBobView(): net.minecraft.client.option.SimpleOption<boolean>;
            getSneakToggled(): net.minecraft.client.option.SimpleOption<boolean>;
            getSprintToggled(): net.minecraft.client.option.SimpleOption<boolean>;
            getAttackToggled(): net.minecraft.client.option.SimpleOption<boolean>;
            getUseToggled(): net.minecraft.client.option.SimpleOption<boolean>;
            getSprintWindow(): net.minecraft.client.option.SimpleOption<number>;
            getHideMatchedNames(): net.minecraft.client.option.SimpleOption<boolean>;
            getShowAutosaveIndicator(): net.minecraft.client.option.SimpleOption<boolean>;
            getOnlyShowSecureChat(): net.minecraft.client.option.SimpleOption<boolean>;
            getChatDrafts(): net.minecraft.client.option.SimpleOption<boolean>;
            getFov(): net.minecraft.client.option.SimpleOption<number>;
            getTelemetryOptInExtra(): net.minecraft.client.option.SimpleOption<boolean>;
            getDistortionEffectScale(): net.minecraft.client.option.SimpleOption<number>;
            getFovEffectScale(): net.minecraft.client.option.SimpleOption<number>;
            getDarknessEffectScale(): net.minecraft.client.option.SimpleOption<number>;
            getGlintSpeed(): net.minecraft.client.option.SimpleOption<number>;
            getGlintStrength(): net.minecraft.client.option.SimpleOption<number>;
            getDamageTiltStrength(): net.minecraft.client.option.SimpleOption<number>;
            getGamma(): net.minecraft.client.option.SimpleOption<number>;
            getGuiScale(): net.minecraft.client.option.SimpleOption<number>;
            getParticles(): net.minecraft.client.option.SimpleOption<net.minecraft.particle.ParticlesMode>;
            getNarrator(): net.minecraft.client.option.SimpleOption<net.minecraft.client.option.NarratorMode>;
            getSoundDevice(): net.minecraft.client.option.SimpleOption<string>;
            setAccessibilityOnboarded(): void;
            getMusicFrequency(): net.minecraft.client.option.SimpleOption<net.minecraft.client.sound.MusicTracker$MusicFrequency>;
            getShowNowPlayingToast(): net.minecraft.client.option.SimpleOption<boolean>;
            getTextBackgroundColor(fallbackOpacity: number): number;
            getTextBackgroundColor(fallbackColor: number): number;
            load(): void;
            write(): void;
            getSyncedOptions(): net.minecraft.network.packet.c2s.common.SyncedClientOptions;
            sendClientSettings(): void;
            setPlayerModelPart(part: net.minecraft.entity.player.PlayerModelPart, enabled: boolean): void;
            isPlayerModelPartEnabled(part: net.minecraft.entity.player.PlayerModelPart): boolean;
            getCloudRenderModeValue(): net.minecraft.client.option.CloudRenderMode;
            shouldUseNativeTransport(): boolean;
            addResourcePackProfilesToManager(manager: net.minecraft.resource.ResourcePackManager): void;
            getPerspective(): net.minecraft.client.option.Perspective;
            setPerspective(perspective: net.minecraft.client.option.Perspective): void;
            getOptionsFile(): java.io.File;
            collectProfiledOptions(): string;
            setServerViewDistance(serverViewDistance: number): void;
            getClampedViewDistance(): number;
          }
          interface GameOptions$Visitor { 
            visitInt(key: string, current: number): number;
            visitBoolean(key: string, current: boolean): boolean;
            visitString(key: string, current: string): string;
            visitFloat(key: string, current: number): number;
            visitObject<T>(key: string, current: T, decoder: unknown, encoder: unknown): T;
          }
          const SimpleOption: {
            ValidatingIntSliderCallbacks: typeof net.minecraft.client.option.SimpleOption$ValidatingIntSliderCallbacks;
            DoubleSliderCallbacks: typeof net.minecraft.client.option.SimpleOption$DoubleSliderCallbacks;
            MaxSuppliableIntCallbacks: typeof net.minecraft.client.option.SimpleOption$MaxSuppliableIntCallbacks;
            LazyCyclingCallbacks: typeof net.minecraft.client.option.SimpleOption$LazyCyclingCallbacks;
            OptionSliderWidgetImpl: typeof net.minecraft.client.option.SimpleOption$OptionSliderWidgetImpl;
            AlternateValuesSupportingCyclingCallbacks: typeof net.minecraft.client.option.SimpleOption$AlternateValuesSupportingCyclingCallbacks;
            PotentialValuesBasedCallbacks: typeof net.minecraft.client.option.SimpleOption$PotentialValuesBasedCallbacks;
            BOOLEAN: net.minecraft.client.option.SimpleOption$PotentialValuesBasedCallbacks<boolean>;
            BOOLEAN_TEXT_GETTER: net.minecraft.client.option.SimpleOption$ValueTextGetter<boolean>;
            ofBoolean(key: string, defaultValue: boolean, changeCallback: unknown): net.minecraft.client.option.SimpleOption<boolean>;
            ofBoolean(key: string, defaultValue: boolean): net.minecraft.client.option.SimpleOption<boolean>;
            ofBoolean(key: string, tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<boolean>, defaultValue: boolean): net.minecraft.client.option.SimpleOption<boolean>;
            ofBoolean(key: string, tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<boolean>, defaultValue: boolean, changeCallback: unknown): net.minecraft.client.option.SimpleOption<boolean>;
            ofBoolean(key: string, tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<boolean>, valueTextGetter: net.minecraft.client.option.SimpleOption$ValueTextGetter<boolean>, defaultValue: boolean, changeCallback: unknown): net.minecraft.client.option.SimpleOption<boolean>;
            emptyTooltip<T>(): net.minecraft.client.option.SimpleOption$TooltipFactory<T>;
            constantTooltip<T>(text: net.minecraft.text.Text): net.minecraft.client.option.SimpleOption$TooltipFactory<T>;
            enumValueText<T>(): net.minecraft.client.option.SimpleOption$ValueTextGetter<T>;
            new<T>(key: string, tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<T>, valueTextGetter: net.minecraft.client.option.SimpleOption$ValueTextGetter<T>, callbacks: unknown, defaultValue: T, changeCallback: unknown): net.minecraft.client.option.SimpleOption<T>;
            new<T>(key: string, tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<T>, valueTextGetter: net.minecraft.client.option.SimpleOption$ValueTextGetter<T>, callbacks: unknown, codec: com.mojang.serialization.Codec<T>, defaultValue: T, changeCallback: unknown): net.minecraft.client.option.SimpleOption<T>;
          }
          interface SimpleOption<T> { 
            createWidget(options: net.minecraft.client.option.GameOptions): net.minecraft.client.gui.widget.ClickableWidget;
            createWidget(options: net.minecraft.client.option.GameOptions, x: number, y: number, width: number): net.minecraft.client.gui.widget.ClickableWidget;
            createWidget(options: net.minecraft.client.option.GameOptions, x: number, y: number, width: number, changeCallback: unknown): net.minecraft.client.gui.widget.ClickableWidget;
            getValue(): T;
            getCodec(): com.mojang.serialization.Codec<T>;
            setValue(value: T): void;
            getCallbacks(): unknown;
          }
          const SimpleOption$ValidatingIntSliderCallbacks: {
            new(minInclusive: number, maxInclusive: number): net.minecraft.client.option.SimpleOption$ValidatingIntSliderCallbacks;
            new(i: number, j: number, bl: boolean): net.minecraft.client.option.SimpleOption$ValidatingIntSliderCallbacks;
          }
          interface SimpleOption$ValidatingIntSliderCallbacks extends java.lang.Record { 
          }
          const SimpleOption$DoubleSliderCallbacks: {
            INSTANCE: net.minecraft.client.option.SimpleOption$DoubleSliderCallbacks;
            valueOf(value: string): net.minecraft.client.option.SimpleOption$DoubleSliderCallbacks;
            values(): Array<net.minecraft.client.option.SimpleOption$DoubleSliderCallbacks>;
          }
          interface SimpleOption$DoubleSliderCallbacks extends kotlin.Enum<net.minecraft.client.option.SimpleOption$DoubleSliderCallbacks> { 
            withModifier<R>(sliderProgressValueToValue: unknown, valueToSliderProgressValue: unknown): unknown;
          }
          const SimpleOption$MaxSuppliableIntCallbacks: {
            new(i: number, intSupplier: unknown, j: number): net.minecraft.client.option.SimpleOption$MaxSuppliableIntCallbacks;
          }
          interface SimpleOption$MaxSuppliableIntCallbacks extends java.lang.Record { 
            maxSupplier(): unknown;
            encodableMaxInclusive(): number;
          }
          const SimpleOption$LazyCyclingCallbacks: {
            new<T>(supplier: unknown, function_: unknown, codec: com.mojang.serialization.Codec<T>): net.minecraft.client.option.SimpleOption$LazyCyclingCallbacks<T>;
          }
          interface SimpleOption$LazyCyclingCallbacks<T> extends java.lang.Record { 
            values(): unknown;
            validateValue(): unknown;
          }
          interface SimpleOption$ValueTextGetter<T> { 
          }
          interface SimpleOption$TooltipFactory<T> { 
            apply(value: T): net.minecraft.client.gui.tooltip.Tooltip | null | undefined;
            (value: T): net.minecraft.client.gui.tooltip.Tooltip | null | undefined;
          }
          interface SimpleOption$OptionSliderWidgetImpl<N> extends net.minecraft.client.gui.widget.OptionSliderWidget { 
            applyPendingValue(): void;
          }
          const SimpleOption$AlternateValuesSupportingCyclingCallbacks: {
            new<T>(list: Array<T>, list2: Array<T>, booleanSupplier: unknown, valueSetter: unknown, codec: com.mojang.serialization.Codec<T>): net.minecraft.client.option.SimpleOption$AlternateValuesSupportingCyclingCallbacks<T>;
          }
          interface SimpleOption$AlternateValuesSupportingCyclingCallbacks<T> extends java.lang.Record { 
            values(): Array<T>;
            altValues(): Array<T>;
            altCondition(): unknown;
          }
          interface SimpleOption$CyclingCallbacks$ValueSetter<T> { 
            set(option: net.minecraft.client.option.SimpleOption<T>, value: T): void;
          }
          const SimpleOption$PotentialValuesBasedCallbacks: {
            new<T>(list: Array<T>, codec: com.mojang.serialization.Codec<T>): net.minecraft.client.option.SimpleOption$PotentialValuesBasedCallbacks<T>;
          }
          interface SimpleOption$PotentialValuesBasedCallbacks<T> extends java.lang.Record { 
            values(): Array<T>;
          }
          const CloudRenderMode: {
            OFF: net.minecraft.client.option.CloudRenderMode;
            FAST: net.minecraft.client.option.CloudRenderMode;
            FANCY: net.minecraft.client.option.CloudRenderMode;
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.option.CloudRenderMode>;
            valueOf(value: string): net.minecraft.client.option.CloudRenderMode;
            values(): Array<net.minecraft.client.option.CloudRenderMode>;
          }
          interface CloudRenderMode extends kotlin.Enum<net.minecraft.client.option.CloudRenderMode>, net.minecraft.util.TranslatableOption, net.minecraft.util.StringIdentifiable { 
          }
          const Perspective: {
            FIRST_PERSON: net.minecraft.client.option.Perspective;
            THIRD_PERSON_BACK: net.minecraft.client.option.Perspective;
            THIRD_PERSON_FRONT: net.minecraft.client.option.Perspective;
            valueOf(value: string): net.minecraft.client.option.Perspective;
            values(): Array<net.minecraft.client.option.Perspective>;
          }
          interface Perspective extends kotlin.Enum<net.minecraft.client.option.Perspective> { 
            isFirstPerson(): boolean;
            isFrontView(): boolean;
            next(): net.minecraft.client.option.Perspective;
          }
          const HotbarStorage: {
            STORAGE_ENTRY_COUNT: number;
            new(directory: java.nio.file.Path, dataFixer: com.mojang.datafixers.DataFixer): net.minecraft.client.option.HotbarStorage;
          }
          interface HotbarStorage { 
            save(): void;
            getSavedHotbar(i: number): net.minecraft.client.option.HotbarStorageEntry;
          }
          const HotbarStorageEntry: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.option.HotbarStorageEntry>;
            new(): net.minecraft.client.option.HotbarStorageEntry;
          }
          interface HotbarStorageEntry { 
            deserialize(registries: net.minecraft.registry.RegistryWrapper$WrapperLookup): Array<net.minecraft.item.ItemStack>;
            serialize(playerInventory: net.minecraft.entity.player.PlayerInventory, registryManager: net.minecraft.registry.DynamicRegistryManager): void;
            isEmpty(): boolean;
          }
          const InactivityFpsLimiter: {
            LimitReason: typeof net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            new(options: net.minecraft.client.option.GameOptions, client: net.minecraft.client.MinecraftClient): net.minecraft.client.option.InactivityFpsLimiter;
          }
          interface InactivityFpsLimiter { 
            update(): number;
            getLimitReason(): net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            shouldDisableProfilerTimeout(): boolean;
            setMaxFps(maxFps: number): void;
            onInput(): void;
          }
          const InactivityFpsLimiter$LimitReason: {
            NONE: net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            WINDOW_ICONIFIED: net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            LONG_AFK: net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            SHORT_AFK: net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            OUT_OF_LEVEL_MENU: net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            valueOf(value: string): net.minecraft.client.option.InactivityFpsLimiter$LimitReason;
            values(): Array<net.minecraft.client.option.InactivityFpsLimiter$LimitReason>;
          }
          interface InactivityFpsLimiter$LimitReason extends kotlin.Enum<net.minecraft.client.option.InactivityFpsLimiter$LimitReason> { 
          }
          const NarratorMode: {
            OFF: net.minecraft.client.option.NarratorMode;
            ALL: net.minecraft.client.option.NarratorMode;
            CHAT: net.minecraft.client.option.NarratorMode;
            SYSTEM: net.minecraft.client.option.NarratorMode;
            byId(id: number): net.minecraft.client.option.NarratorMode;
            valueOf(value: string): net.minecraft.client.option.NarratorMode;
            values(): Array<net.minecraft.client.option.NarratorMode>;
          }
          interface NarratorMode extends kotlin.Enum<net.minecraft.client.option.NarratorMode> { 
            getId(): number;
            getName(): net.minecraft.text.Text;
            shouldNarrateChat(): boolean;
            shouldNarrateSystem(): boolean;
            shouldNarrate(): boolean;
          }
          const GraphicsMode: {
            FAST: net.minecraft.client.option.GraphicsMode;
            FANCY: net.minecraft.client.option.GraphicsMode;
            FABULOUS: net.minecraft.client.option.GraphicsMode;
            byId(id: number): net.minecraft.client.option.GraphicsMode;
            valueOf(value: string): net.minecraft.client.option.GraphicsMode;
            values(): Array<net.minecraft.client.option.GraphicsMode>;
          }
          interface GraphicsMode extends kotlin.Enum<net.minecraft.client.option.GraphicsMode>, net.minecraft.util.TranslatableOption { 
          }
        }
        namespace util {
          namespace tracy {
            const TracyFrameCapturer: {
              new(): net.minecraft.client.util.tracy.TracyFrameCapturer;
            }
            interface TracyFrameCapturer extends java.lang.AutoCloseable { 
              capture(framebuffer: net.minecraft.client.gl.Framebuffer): void;
              upload(): void;
              markFrame(): void;
            }
          }
          namespace math {
            const MatrixStack$Entry: {
              new(): net.minecraft.client.util.math.MatrixStack$Entry;
            }
            interface MatrixStack$Entry { 
              copy(entry: net.minecraft.client.util.math.MatrixStack$Entry): void;
              copy(): net.minecraft.client.util.math.MatrixStack$Entry;
              getPositionMatrix(): org.joml.Matrix4f;
              getNormalMatrix(): org.joml.Matrix3f;
              transformNormal(vec: org.joml.Vector3fc, dest: org.joml.Vector3f): org.joml.Vector3f;
              transformNormal(x: number, y: number, z: number, dest: org.joml.Vector3f): org.joml.Vector3f;
              translate(x: number, y: number, z: number): org.joml.Matrix4f;
              scale(x: number, y: number, z: number): void;
              rotate(quaternion: org.joml.Quaternionfc): void;
              rotateAround(quaternion: org.joml.Quaternionfc, originX: number, originY: number, originZ: number): void;
              loadIdentity(): void;
              multiplyPositionMatrix(matrix: org.joml.Matrix4fc): void;
            }
            const Vec3fArray: {
              new(size: number): net.minecraft.client.util.math.Vec3fArray;
            }
            interface Vec3fArray { 
              size(): number;
              set(index: number, vec: org.joml.Vector3fc): void;
              set(index: number, x: number, y: number, z: number): void;
              get(index: number, vec: org.joml.Vector3f): org.joml.Vector3f;
              getX(index: number): number;
              getY(index: number): number;
              getZ(index: number): number;
            }
            const MatrixStack: {
              Entry: typeof net.minecraft.client.util.math.MatrixStack$Entry;
              new(): net.minecraft.client.util.math.MatrixStack;
            }
            interface MatrixStack { 
              translate(x: number, y: number, z: number): void;
              translate(x: number, y: number, z: number): void;
              translate(vec: net.minecraft.util.math.Vec3d): void;
              scale(x: number, y: number, z: number): void;
              multiply(quaternion: org.joml.Quaternionfc): void;
              multiply(quaternion: org.joml.Quaternionfc, originX: number, originY: number, originZ: number): void;
              push(): void;
              pop(): void;
              peek(): net.minecraft.client.util.math.MatrixStack$Entry;
              isEmpty(): boolean;
              loadIdentity(): void;
              multiplyPositionMatrix(matrix: org.joml.Matrix4fc): void;
            }
          }
          interface InputUtil$Key { 
            getCategory(): net.minecraft.client.util.InputUtil$Type;
            getCode(): number;
            getTranslationKey(): string;
            getLocalizedText(): net.minecraft.text.Text;
            toInt(): java.util.OptionalInt;
          }
          const InputUtil$Type: {
            KEYSYM: net.minecraft.client.util.InputUtil$Type;
            SCANCODE: net.minecraft.client.util.InputUtil$Type;
            MOUSE: net.minecraft.client.util.InputUtil$Type;
            valueOf(value: string): net.minecraft.client.util.InputUtil$Type;
            values(): Array<net.minecraft.client.util.InputUtil$Type>;
          }
          interface InputUtil$Type extends kotlin.Enum<net.minecraft.client.util.InputUtil$Type> { 
            createFromCode(code: number): net.minecraft.client.util.InputUtil$Key;
          }
          const Window: {
            GlErroredException: typeof net.minecraft.client.util.Window$GlErroredException;
            field_52250: number;
            field_52251: number;
            getGlfwPlatform(): string;
            acceptError(consumer: unknown): void;
            new(eventHandler: net.minecraft.client.WindowEventHandler, monitorTracker: net.minecraft.client.util.MonitorTracker, settings: net.minecraft.client.WindowSettings, fullscreenVideoMode: string | null | undefined, title: string): net.minecraft.client.util.Window;
          }
          interface Window extends java.lang.AutoCloseable { 
            getRefreshRate(): number;
            shouldClose(): boolean;
            setIcon(resourcePack: net.minecraft.resource.ResourcePack, icons: net.minecraft.client.util.Icons): void;
            setPhase(phase: string): void;
            logGlError(error: number, description: number): void;
            logOnGlError(): void;
            setVsync(vsync: boolean): void;
            swapBuffers(capturer: net.minecraft.client.util.tracy.TracyFrameCapturer | null | undefined): void;
            getFullscreenVideoMode(): java.util.Optional<net.minecraft.client.util.VideoMode>;
            setFullscreenVideoMode(fullscreenVideoMode: java.util.Optional<net.minecraft.client.util.VideoMode>): void;
            applyFullscreenVideoMode(): void;
            toggleFullscreen(): void;
            setWindowedSize(width: number, height: number): void;
            calculateScaleFactor(guiScale: number, forceUnicodeFont: boolean): number;
            setScaleFactor(scaleFactor: number): void;
            setTitle(title: string): void;
            getHandle(): number;
            isFullscreen(): boolean;
            isMinimized(): boolean;
            getFramebufferWidth(): number;
            getFramebufferHeight(): number;
            setFramebufferWidth(framebufferWidth: number): void;
            setFramebufferHeight(framebufferHeight: number): void;
            getWidth(): number;
            getHeight(): number;
            getScaledWidth(): number;
            getScaledHeight(): number;
            getX(): number;
            getY(): number;
            getScaleFactor(): number;
            getMonitor(): net.minecraft.client.util.Monitor | null | undefined;
            setRawMouseMotion(rawMouseMotion: boolean): void;
            setCloseCallback(callback: java.lang.Runnable): void;
            hasZeroWidthOrHeight(): boolean;
            setAllowCursorChanges(allowCursorChanges: boolean): void;
            setCursor(cursor: net.minecraft.client.gui.cursor.Cursor): void;
          }
          interface Window$GlErroredException extends net.minecraft.client.util.GlException { 
          }
          const GlException: {
            new(message: string): net.minecraft.client.util.GlException;
            new(message: string, cause: kotlin.Throwable): net.minecraft.client.util.GlException;
          }
          interface GlException extends java.lang.RuntimeException { 
          }
          const Icons: {
            RELEASE: net.minecraft.client.util.Icons;
            SNAPSHOT: net.minecraft.client.util.Icons;
            valueOf(value: string): net.minecraft.client.util.Icons;
            values(): Array<net.minecraft.client.util.Icons>;
          }
          interface Icons extends kotlin.Enum<net.minecraft.client.util.Icons> { 
            getIcons(resourcePack: net.minecraft.resource.ResourcePack): Array<net.minecraft.resource.InputSupplier<java.io.InputStream>>;
            getMacIcon(resourcePack: net.minecraft.resource.ResourcePack): net.minecraft.resource.InputSupplier<java.io.InputStream>;
          }
          const Monitor: {
            new(handle: number): net.minecraft.client.util.Monitor;
          }
          interface Monitor { 
            populateVideoModes(): void;
            findClosestVideoMode(videoMode: java.util.Optional<net.minecraft.client.util.VideoMode>): net.minecraft.client.util.VideoMode;
            findClosestVideoModeIndex(videoMode: net.minecraft.client.util.VideoMode): number;
            getCurrentVideoMode(): net.minecraft.client.util.VideoMode;
            getViewportX(): number;
            getViewportY(): number;
            getVideoMode(index: number): net.minecraft.client.util.VideoMode;
            getVideoModeCount(): number;
            getHandle(): number;
          }
          const VideoMode: {
            fromString(string: string | null | undefined): java.util.Optional<net.minecraft.client.util.VideoMode>;
            new(width: number, height: number, redBits: number, greenBits: number, blueBits: number, refreshRate: number): net.minecraft.client.util.VideoMode;
            new(buffer: org.lwjgl.glfw.GLFWVidMode$Buffer): net.minecraft.client.util.VideoMode;
            new(vidMode: org.lwjgl.glfw.GLFWVidMode): net.minecraft.client.util.VideoMode;
          }
          interface VideoMode { 
            getWidth(): number;
            getHeight(): number;
            getRedBits(): number;
            getGreenBits(): number;
            getBlueBits(): number;
            getRefreshRate(): number;
            asString(): string;
          }
          const MonitorTracker: {
            clamp(value: number, min: number, max: number): number;
            new(monitorFactory: net.minecraft.client.util.MonitorFactory): net.minecraft.client.util.MonitorTracker;
          }
          interface MonitorTracker { 
            getMonitor(pointer: number): net.minecraft.client.util.Monitor | null | undefined;
            getMonitor(window: net.minecraft.client.util.Window): net.minecraft.client.util.Monitor | null | undefined;
            stop(): void;
          }
          interface MonitorFactory { 
            createMonitor(pointer: number): net.minecraft.client.util.Monitor;
          }
          const BufferAllocator: {
            CloseableBuffer: typeof net.minecraft.client.util.BufferAllocator$CloseableBuffer;
            fixedSized(size: number): net.minecraft.client.util.BufferAllocator;
            new(size: number, maxSize: number): net.minecraft.client.util.BufferAllocator;
            new(size: number): net.minecraft.client.util.BufferAllocator;
          }
          interface BufferAllocator extends java.lang.AutoCloseable { 
            allocate(size: number): number;
            getAllocated(): net.minecraft.client.util.BufferAllocator$CloseableBuffer | null | undefined;
            clear(): void;
            reset(): void;
          }
          interface BufferAllocator$CloseableBuffer extends java.lang.AutoCloseable { 
            getBuffer(): java.nio.ByteBuffer;
          }
          const SpriteIdentifier: {
            COMPARATOR: java.util.Comparator<net.minecraft.client.util.SpriteIdentifier>;
            new(atlas: net.minecraft.util.Identifier, texture: net.minecraft.util.Identifier): net.minecraft.client.util.SpriteIdentifier;
          }
          interface SpriteIdentifier { 
            getAtlasId(): net.minecraft.util.Identifier;
            getTextureId(): net.minecraft.util.Identifier;
            getRenderLayer(layerFactory: unknown): net.minecraft.client.render.RenderLayer;
            getVertexConsumer(spriteHolder: net.minecraft.client.texture.SpriteHolder, vertexConsumerProvider: net.minecraft.client.render.VertexConsumerProvider, function_: unknown): net.minecraft.client.render.VertexConsumer;
            getVertexConsumer(spriteHolder: net.minecraft.client.texture.SpriteHolder, vertexConsumerProvider: net.minecraft.client.render.VertexConsumerProvider, function_: unknown, bl: boolean, bl2: boolean): net.minecraft.client.render.VertexConsumer;
          }
          const Handle: {
            EMPTY: net.minecraft.client.util.Handle<any>;
            empty<T>(): net.minecraft.client.util.Handle<T>;
          }
          interface Handle<T> { 
            get(): T;
          }
          interface ClosableFactory<T> { 
            create(): T;
            prepare(value: T): void;
            close(value: T): void;
          }
          const ObjectAllocator: {
            TRIVIAL: net.minecraft.client.util.ObjectAllocator;
          }
          interface ObjectAllocator { 
            acquire<T>(factory: net.minecraft.client.util.ClosableFactory<T>): T;
            release<T>(factory: net.minecraft.client.util.ClosableFactory<T>, value: T): void;
          }
          const NarratorManager: {
            InactiveNarratorLibraryException: typeof net.minecraft.client.util.NarratorManager$InactiveNarratorLibraryException;
            EMPTY: net.minecraft.text.Text;
            new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.util.NarratorManager;
          }
          interface NarratorManager { 
            narrateChatMessage(message: net.minecraft.text.Text): void;
            narrate(message: net.minecraft.text.Text): void;
            narrateSystemMessage(message: net.minecraft.text.Text): void;
            narrateSystemImmediately(text: net.minecraft.text.Text): void;
            narrateSystemImmediately(text: string): void;
            onModeChange(mode: net.minecraft.client.option.NarratorMode): void;
            isActive(): boolean;
            clear(): void;
            destroy(): void;
            checkNarratorLibrary(narratorEnabled: boolean): void;
          }
          const NarratorManager$InactiveNarratorLibraryException: {
            new(string: string): net.minecraft.client.util.NarratorManager$InactiveNarratorLibraryException;
          }
          interface NarratorManager$InactiveNarratorLibraryException extends net.minecraft.client.util.GlException { 
          }
          const Backoff: {
            ONE_CYCLE: net.minecraft.client.util.Backoff;
            exponential(maxSkippableCycles: number): net.minecraft.client.util.Backoff;
          }
          interface Backoff { 
            success(): number;
            fail(): number;
          }
          const CommandHistoryManager: {
            new(directoryPath: java.nio.file.Path): net.minecraft.client.util.CommandHistoryManager;
          }
          interface CommandHistoryManager { 
            add(command: string): void;
            getHistory(): Array<string>;
          }
        }
        namespace input {
          const KeyInput: {
            new(i: number, j: number, k: number): net.minecraft.client.input.KeyInput;
          }
          interface KeyInput extends java.lang.Record, net.minecraft.client.input.AbstractInput { 
            key(): number;
            scancode(): number;
          }
          const AbstractInput: {
            field_62593: number;
          }
          interface AbstractInput { 
            getKeycode(): number;
            modifiers(): number;
            isEnterOrSpace(): boolean;
            isEnter(): boolean;
            isEscape(): boolean;
            isLeft(): boolean;
            isRight(): boolean;
            isUp(): boolean;
            isDown(): boolean;
            isTab(): boolean;
            asNumber(): number;
            hasAlt(): boolean;
            hasShift(): boolean;
            hasCtrl(): boolean;
            isSelectAll(): boolean;
            isCopy(): boolean;
            isPaste(): boolean;
            isCut(): boolean;
          }
          const MouseInput: {
            new(i: number, j: number): net.minecraft.client.input.MouseInput;
          }
          interface MouseInput extends java.lang.Record, net.minecraft.client.input.AbstractInput { 
            button(): number;
          }
          const CharInput: {
            new(i: number, j: number): net.minecraft.client.input.CharInput;
          }
          interface CharInput extends java.lang.Record { 
            asString(): string;
            isValidChar(): boolean;
            codepoint(): number;
            modifiers(): number;
          }
          const Input: {
            new(): net.minecraft.client.input.Input;
          }
          interface Input { 
            playerInput: net.minecraft.util.PlayerInput;
            tick(): void;
            getMovementInput(): net.minecraft.util.math.Vec2f;
            hasForwardMovement(): boolean;
            jump(): void;
          }
        }
        namespace gui {
          namespace screen {
            namespace dialog {
              interface DialogNetworkAccess { 
                disconnect(reason: net.minecraft.text.Text): void;
                runClickEventCommand(command: string, afterActionScreen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
                showDialog(dialog: net.minecraft.registry.entry.RegistryEntry<unknown>, afterActionScreen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
                sendCustomClickActionPacket(id: net.minecraft.util.Identifier, payload: java.util.Optional<net.minecraft.nbt.NbtElement>): void;
                getServerLinks(): net.minecraft.server.ServerLinks;
              }
            }
            namespace narration {
              interface NarrationMessageBuilder { 
                put(part: net.minecraft.client.gui.screen.narration.NarrationPart, text: net.minecraft.text.Text): void;
                put(part: net.minecraft.client.gui.screen.narration.NarrationPart, string: string): void;
                put(part: net.minecraft.client.gui.screen.narration.NarrationPart, texts: net.minecraft.text.Text): void;
                put(part: net.minecraft.client.gui.screen.narration.NarrationPart, narration: net.minecraft.client.gui.screen.narration.Narration<any>): void;
                nextMessage(): net.minecraft.client.gui.screen.narration.NarrationMessageBuilder;
              }
              const NarrationPart: {
                TITLE: net.minecraft.client.gui.screen.narration.NarrationPart;
                POSITION: net.minecraft.client.gui.screen.narration.NarrationPart;
                HINT: net.minecraft.client.gui.screen.narration.NarrationPart;
                USAGE: net.minecraft.client.gui.screen.narration.NarrationPart;
                valueOf(value: string): net.minecraft.client.gui.screen.narration.NarrationPart;
                values(): Array<net.minecraft.client.gui.screen.narration.NarrationPart>;
              }
              interface NarrationPart extends kotlin.Enum<net.minecraft.client.gui.screen.narration.NarrationPart> { 
              }
              const Narration: {
                EMPTY: net.minecraft.client.gui.screen.narration.Narration<any>;
                string(string: string): net.minecraft.client.gui.screen.narration.Narration<any>;
                text(text: net.minecraft.text.Text): net.minecraft.client.gui.screen.narration.Narration<any>;
                texts(texts: Array<net.minecraft.text.Text>): net.minecraft.client.gui.screen.narration.Narration<any>;
              }
              interface Narration<T> { 
                forEachSentence(consumer: unknown): void;
              }
            }
            namespace world {
              const CreateWorldScreen: {
                TAB_HEADER_BACKGROUND_TEXTURE: net.minecraft.util.Identifier;
                show(client: net.minecraft.client.MinecraftClient, runnable: java.lang.Runnable): void;
                show(client: net.minecraft.client.MinecraftClient, runnable: java.lang.Runnable, callback: net.minecraft.client.gui.screen.world.CreateWorldCallback): void;
                showTestWorld(client: net.minecraft.client.MinecraftClient, runnable: java.lang.Runnable): void;
                create(client: net.minecraft.client.MinecraftClient, runnable: java.lang.Runnable, levelInfo: net.minecraft.world.level.LevelInfo, generatorOptionsHolder: net.minecraft.client.world.GeneratorOptionsHolder, dataPackTempDir: java.nio.file.Path | null | undefined): net.minecraft.client.gui.screen.world.CreateWorldScreen;
                copyDataPack(srcFolder: java.nio.file.Path, client: net.minecraft.client.MinecraftClient): java.nio.file.Path | null | undefined;
              }
              interface CreateWorldScreen extends net.minecraft.client.gui.screen.Screen { 
                getWorldCreator(): net.minecraft.client.gui.screen.world.WorldCreator;
                onCloseScreen(): void;
              }
              const WorldCreator: {
                Mode: typeof net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                WorldType: typeof net.minecraft.client.gui.screen.world.WorldCreator$WorldType;
                new(savesDirectory: java.nio.file.Path, generatorOptionsHolder: net.minecraft.client.world.GeneratorOptionsHolder, defaultWorldType: java.util.Optional<net.minecraft.registry.RegistryKey<unknown>>, seed: java.util.OptionalLong): net.minecraft.client.gui.screen.world.WorldCreator;
              }
              interface WorldCreator { 
                addListener(listener: unknown): void;
                update(): void;
                setWorldName(worldName: string): void;
                getWorldName(): string;
                getWorldDirectoryName(): string;
                setGameMode(gameMode: net.minecraft.client.gui.screen.world.WorldCreator$Mode): void;
                getGameMode(): net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                setDifficulty(difficulty: net.minecraft.world.Difficulty): void;
                getDifficulty(): net.minecraft.world.Difficulty;
                isHardcore(): boolean;
                setCheatsEnabled(cheatsEnabled: boolean): void;
                areCheatsEnabled(): boolean;
                setSeed(seed: string): void;
                getSeed(): string;
                setGenerateStructures(generateStructures: boolean): void;
                shouldGenerateStructures(): boolean;
                setBonusChestEnabled(bonusChestEnabled: boolean): void;
                isBonusChestEnabled(): boolean;
                setGeneratorOptionsHolder(generatorOptionsHolder: net.minecraft.client.world.GeneratorOptionsHolder): void;
                getGeneratorOptionsHolder(): net.minecraft.client.world.GeneratorOptionsHolder;
                applyModifier(modifier: net.minecraft.client.world.GeneratorOptionsHolder$RegistryAwareModifier): void;
                isDebug(): boolean;
                setWorldType(worldType: net.minecraft.client.gui.screen.world.WorldCreator$WorldType): void;
                getWorldType(): net.minecraft.client.gui.screen.world.WorldCreator$WorldType;
                getLevelScreenProvider(): net.minecraft.client.gui.screen.world.LevelScreenProvider | null | undefined;
                getNormalWorldTypes(): Array<net.minecraft.client.gui.screen.world.WorldCreator$WorldType>;
                getExtendedWorldTypes(): Array<net.minecraft.client.gui.screen.world.WorldCreator$WorldType>;
                setGameRules(gameRules: net.minecraft.world.GameRules): void;
                getGameRules(): net.minecraft.world.GameRules;
              }
              const WorldCreator$Mode: {
                SURVIVAL: net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                HARDCORE: net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                CREATIVE: net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                DEBUG: net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                valueOf(value: string): net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                values(): Array<net.minecraft.client.gui.screen.world.WorldCreator$Mode>;
              }
              interface WorldCreator$Mode extends kotlin.Enum<net.minecraft.client.gui.screen.world.WorldCreator$Mode> { 
                defaultGameMode: net.minecraft.world.GameMode;
                name: net.minecraft.text.Text;
                getInfo(): net.minecraft.text.Text;
              }
              const WorldCreator$WorldType: {
                new(registryEntry: net.minecraft.registry.entry.RegistryEntry<unknown> | null | undefined): net.minecraft.client.gui.screen.world.WorldCreator$WorldType;
              }
              interface WorldCreator$WorldType extends java.lang.Record { 
                getName(): net.minecraft.text.Text;
                isAmplified(): boolean;
                preset(): net.minecraft.registry.entry.RegistryEntry<unknown> | null | undefined;
              }
              const InitialWorldOptions: {
                new(mode: net.minecraft.client.gui.screen.world.WorldCreator$Mode, set: Set<net.minecraft.world.GameRules$Key<net.minecraft.world.GameRules$BooleanRule>>, registryKey: net.minecraft.registry.RegistryKey<unknown> | null | undefined): net.minecraft.client.gui.screen.world.InitialWorldOptions;
              }
              interface InitialWorldOptions extends java.lang.Record { 
                selectedGameMode(): net.minecraft.client.gui.screen.world.WorldCreator$Mode;
                disabledGameRules(): Set<net.minecraft.world.GameRules$Key<net.minecraft.world.GameRules$BooleanRule>>;
                flatLevelPreset(): net.minecraft.registry.RegistryKey<unknown> | null | undefined;
              }
              const LevelScreenProvider: {
                WORLD_PRESET_TO_SCREEN_PROVIDER: Map<java.util.Optional<net.minecraft.registry.RegistryKey<unknown>>, net.minecraft.client.gui.screen.world.LevelScreenProvider>;
                createModifier(config: net.minecraft.world.gen.chunk.FlatChunkGeneratorConfig): net.minecraft.client.world.GeneratorOptionsHolder$RegistryAwareModifier;
              }
              interface LevelScreenProvider { 
                createEditScreen(parent: net.minecraft.client.gui.screen.world.CreateWorldScreen, generatorOptionsHolder: net.minecraft.client.world.GeneratorOptionsHolder): net.minecraft.client.gui.screen.Screen;
              }
              interface CreateWorldCallback { 
                create(screen: net.minecraft.client.gui.screen.world.CreateWorldScreen, dynamicRegistries: net.minecraft.registry.CombinedDynamicRegistries<unknown>, levelProperties: net.minecraft.world.level.LevelProperties, dataPackTempDir: java.nio.file.Path | null | undefined): boolean;
                (screen: net.minecraft.client.gui.screen.world.CreateWorldScreen, dynamicRegistries: net.minecraft.registry.CombinedDynamicRegistries<unknown>, levelProperties: net.minecraft.world.level.LevelProperties, dataPackTempDir: java.nio.file.Path | null | undefined): boolean;
              }
            }
            namespace ingame {
              const HandledScreen: {
                BACKGROUND_TEXTURE: net.minecraft.util.Identifier;
                new<T>(handler: T, inventory: net.minecraft.entity.player.PlayerInventory, title: net.minecraft.text.Text): net.minecraft.client.gui.screen.ingame.HandledScreen<T>;
              }
              interface HandledScreen<T> extends net.minecraft.client.gui.screen.Screen, net.minecraft.client.gui.screen.ingame.ScreenHandlerProvider<T> { 
                renderMain(context: net.minecraft.client.gui.DrawContext, mouseX: number, mouseY: number, deltaTicks: number): void;
                renderCursorStack(context: net.minecraft.client.gui.DrawContext, mouseX: number, mouseY: number): void;
                renderLetGoTouchStack(context: net.minecraft.client.gui.DrawContext): void;
                endTouchDrag(): void;
              }
              interface ScreenHandlerProvider<T> { 
                getScreenHandler(): T;
              }
            }
            const Screen: {
              SelectedElementNarrationData: typeof net.minecraft.client.gui.screen.Screen$SelectedElementNarrationData;
              MENU_BACKGROUND_TEXTURE: net.minecraft.util.Identifier;
              HEADER_SEPARATOR_TEXTURE: net.minecraft.util.Identifier;
              FOOTER_SEPARATOR_TEXTURE: net.minecraft.util.Identifier;
              INWORLD_HEADER_SEPARATOR_TEXTURE: net.minecraft.util.Identifier;
              INWORLD_FOOTER_SEPARATOR_TEXTURE: net.minecraft.util.Identifier;
              getTooltipFromItem(client: net.minecraft.client.MinecraftClient, stack: net.minecraft.item.ItemStack): Array<net.minecraft.text.Text>;
              renderBackgroundTexture(context: net.minecraft.client.gui.DrawContext, texture: net.minecraft.util.Identifier, x: number, y: number, u: number, v: number, width: number, height: number): void;
              findSelectedElementData(selectables: Array<net.minecraft.client.gui.Selectable>, selectable: net.minecraft.client.gui.Selectable | null | undefined): net.minecraft.client.gui.screen.Screen$SelectedElementNarrationData | null | undefined;
            }
            interface Screen extends net.minecraft.client.gui.AbstractParentElement, net.minecraft.client.gui.Drawable { 
              width: number;
              height: number;
              getTitle(): net.minecraft.text.Text;
              getNarratedTitle(): net.minecraft.text.Text;
              renderWithTooltip(context: net.minecraft.client.gui.DrawContext, mouseX: number, mouseY: number, deltaTicks: number): void;
              blur(): void;
              shouldCloseOnEsc(): boolean;
              close(): void;
              handleTextClick(style: net.minecraft.text.Style): boolean;
              init(client: net.minecraft.client.MinecraftClient, width: number, height: number): void;
              tick(): void;
              removed(): void;
              onDisplayed(): void;
              renderBackground(context: net.minecraft.client.gui.DrawContext, mouseX: number, mouseY: number, deltaTicks: number): void;
              renderInGameBackground(context: net.minecraft.client.gui.DrawContext): void;
              shouldPause(): boolean;
              deferSubtitles(): boolean;
              keepOpenThroughPortal(): boolean;
              resize(client: net.minecraft.client.MinecraftClient, width: number, height: number): void;
              addCrashReportSection(report: net.minecraft.util.crash.CrashReport): void;
              onFilesDropped(paths: Array<java.nio.file.Path>): void;
              applyMouseMoveNarratorDelay(): void;
              applyMousePressScrollNarratorDelay(): void;
              applyKeyPressNarratorDelay(): void;
              updateNarrator(): void;
              narrateScreenIfNarrationEnabled(onlyChangedNarrations: boolean): void;
              refreshNarrator(previouslyDisabled: boolean): void;
              getTextRenderer(): net.minecraft.client.font.TextRenderer;
              showsStatusEffects(): boolean;
              canInterruptOtherScreen(): boolean;
              getMusic(): net.minecraft.sound.MusicSound | null | undefined;
            }
            const Overlay: {
              new(): net.minecraft.client.gui.screen.Overlay;
            }
            interface Overlay extends net.minecraft.client.gui.Drawable { 
              pausesGame(): boolean;
              tick(): void;
            }
            const SplashTextRenderer: {
              MERRY_X_MAS_: net.minecraft.client.gui.screen.SplashTextRenderer;
              HAPPY_NEW_YEAR_: net.minecraft.client.gui.screen.SplashTextRenderer;
              OOOOO_O_O_OOOOO__SPOOKY_: net.minecraft.client.gui.screen.SplashTextRenderer;
              new(text: string): net.minecraft.client.gui.screen.SplashTextRenderer;
            }
            interface SplashTextRenderer { 
              render(context: net.minecraft.client.gui.DrawContext, screenWidth: number, textRenderer: net.minecraft.client.font.TextRenderer, alpha: number): void;
            }
            interface ChatScreen$Factory<T> { 
              create(string: string, draft: boolean): T;
              (string: string, draft: boolean): T;
            }
            const ChatScreen: {
              SHIFT_SCROLL_AMOUNT: number;
              new(text: string, draft: boolean): net.minecraft.client.gui.screen.ChatScreen;
            }
            interface ChatScreen extends net.minecraft.client.gui.screen.Screen { 
              setChatFromHistory(offset: number): void;
              sendMessage(chatText: string, addToHistory: boolean): void;
              normalize(chatText: string): string;
            }
            const Screen$SelectedElementNarrationData: {
              new(selectable: net.minecraft.client.gui.Selectable, index: number, selectType: net.minecraft.client.gui.Selectable$SelectionType): net.minecraft.client.gui.screen.Screen$SelectedElementNarrationData;
            }
            interface Screen$SelectedElementNarrationData extends java.lang.Record { 
              selectable(): net.minecraft.client.gui.Selectable;
              index(): number;
              selectType(): net.minecraft.client.gui.Selectable$SelectionType;
            }
          }
          namespace navigation {
            interface Navigable { 
              getNavigationOrder(): number;
            }
            const GuiNavigation: {
              Down: typeof net.minecraft.client.gui.navigation.GuiNavigation$Down;
              Tab: typeof net.minecraft.client.gui.navigation.GuiNavigation$Tab;
              Arrow: typeof net.minecraft.client.gui.navigation.GuiNavigation$Arrow;
            }
            interface GuiNavigation { 
              getDirection(): net.minecraft.client.gui.navigation.NavigationDirection;
            }
            const GuiNavigation$Down: {
              new(): net.minecraft.client.gui.navigation.GuiNavigation$Down;
            }
            interface GuiNavigation$Down extends net.minecraft.client.gui.navigation.GuiNavigation { 
            }
            const NavigationDirection: {
              UP: net.minecraft.client.gui.navigation.NavigationDirection;
              DOWN: net.minecraft.client.gui.navigation.NavigationDirection;
              LEFT: net.minecraft.client.gui.navigation.NavigationDirection;
              RIGHT: net.minecraft.client.gui.navigation.NavigationDirection;
              valueOf(value: string): net.minecraft.client.gui.navigation.NavigationDirection;
              values(): Array<net.minecraft.client.gui.navigation.NavigationDirection>;
            }
            interface NavigationDirection extends kotlin.Enum<net.minecraft.client.gui.navigation.NavigationDirection> { 
              getAxis(): net.minecraft.client.gui.navigation.NavigationAxis;
              getOpposite(): net.minecraft.client.gui.navigation.NavigationDirection;
              isPositive(): boolean;
              isAfter(a: number, b: number): boolean;
              isBefore(a: number, b: number): boolean;
              getComparator(): it.unimi.dsi.fastutil.ints.IntComparator;
            }
            const NavigationAxis: {
              HORIZONTAL: net.minecraft.client.gui.navigation.NavigationAxis;
              VERTICAL: net.minecraft.client.gui.navigation.NavigationAxis;
              valueOf(value: string): net.minecraft.client.gui.navigation.NavigationAxis;
              values(): Array<net.minecraft.client.gui.navigation.NavigationAxis>;
            }
            interface NavigationAxis extends kotlin.Enum<net.minecraft.client.gui.navigation.NavigationAxis> { 
              getOther(): net.minecraft.client.gui.navigation.NavigationAxis;
              getPositiveDirection(): net.minecraft.client.gui.navigation.NavigationDirection;
              getNegativeDirection(): net.minecraft.client.gui.navigation.NavigationDirection;
              getDirection(positive: boolean): net.minecraft.client.gui.navigation.NavigationDirection;
            }
            const GuiNavigation$Tab: {
              new(bl: boolean): net.minecraft.client.gui.navigation.GuiNavigation$Tab;
            }
            interface GuiNavigation$Tab extends java.lang.Record, net.minecraft.client.gui.navigation.GuiNavigation { 
              forward(): boolean;
            }
            const GuiNavigation$Arrow: {
              new(navigationDirection: net.minecraft.client.gui.navigation.NavigationDirection): net.minecraft.client.gui.navigation.GuiNavigation$Arrow;
            }
            interface GuiNavigation$Arrow extends java.lang.Record, net.minecraft.client.gui.navigation.GuiNavigation { 
              direction(): net.minecraft.client.gui.navigation.NavigationDirection;
            }
            const GuiNavigationPath: {
              IntermediaryNode: typeof net.minecraft.client.gui.navigation.GuiNavigationPath$IntermediaryNode;
              Leaf: typeof net.minecraft.client.gui.navigation.GuiNavigationPath$Leaf;
              of(leaf: net.minecraft.client.gui.Element): net.minecraft.client.gui.navigation.GuiNavigationPath;
              of(element: net.minecraft.client.gui.ParentElement, childPath: net.minecraft.client.gui.navigation.GuiNavigationPath | null | undefined): net.minecraft.client.gui.navigation.GuiNavigationPath | null | undefined;
              of(leaf: net.minecraft.client.gui.Element, elements: net.minecraft.client.gui.ParentElement): net.minecraft.client.gui.navigation.GuiNavigationPath;
            }
            interface GuiNavigationPath { 
              component(): net.minecraft.client.gui.Element;
              setFocused(focused: boolean): void;
            }
            const GuiNavigationPath$IntermediaryNode: {
              new(parentElement: net.minecraft.client.gui.ParentElement, guiNavigationPath: net.minecraft.client.gui.navigation.GuiNavigationPath): net.minecraft.client.gui.navigation.GuiNavigationPath$IntermediaryNode;
            }
            interface GuiNavigationPath$IntermediaryNode extends java.lang.Record, net.minecraft.client.gui.navigation.GuiNavigationPath { 
              childPath(): net.minecraft.client.gui.navigation.GuiNavigationPath;
            }
            const GuiNavigationPath$Leaf: {
              new(element: net.minecraft.client.gui.Element): net.minecraft.client.gui.navigation.GuiNavigationPath$Leaf;
            }
            interface GuiNavigationPath$Leaf extends java.lang.Record, net.minecraft.client.gui.navigation.GuiNavigationPath { 
            }
            const GuiNavigationType: {
              NONE: net.minecraft.client.gui.navigation.GuiNavigationType;
              MOUSE: net.minecraft.client.gui.navigation.GuiNavigationType;
              KEYBOARD_ARROW: net.minecraft.client.gui.navigation.GuiNavigationType;
              KEYBOARD_TAB: net.minecraft.client.gui.navigation.GuiNavigationType;
              valueOf(value: string): net.minecraft.client.gui.navigation.GuiNavigationType;
              values(): Array<net.minecraft.client.gui.navigation.GuiNavigationType>;
            }
            interface GuiNavigationType extends kotlin.Enum<net.minecraft.client.gui.navigation.GuiNavigationType> { 
              isMouse(): boolean;
              isKeyboard(): boolean;
            }
          }
          namespace cursor {
            const Cursor: {
              DEFAULT: net.minecraft.client.gui.cursor.Cursor;
              createStandard(handle: number, name: string, fallback: net.minecraft.client.gui.cursor.Cursor): net.minecraft.client.gui.cursor.Cursor;
            }
            interface Cursor { 
              applyTo(window: net.minecraft.client.util.Window): void;
            }
          }
          namespace tooltip {
            interface TooltipPositioner { 
              getPosition(screenWidth: number, screenHeight: number, x: number, y: number, width: number, height: number): org.joml.Vector2ic;
            }
            const Tooltip: {
              of(content: net.minecraft.text.Text, narration: net.minecraft.text.Text | null | undefined): net.minecraft.client.gui.tooltip.Tooltip;
              of(content: net.minecraft.text.Text): net.minecraft.client.gui.tooltip.Tooltip;
              wrapLines(client: net.minecraft.client.MinecraftClient, text: net.minecraft.text.Text): Array<net.minecraft.text.OrderedText>;
            }
            interface Tooltip extends net.minecraft.client.gui.Narratable { 
              getLines(client: net.minecraft.client.MinecraftClient): Array<net.minecraft.text.OrderedText>;
            }
            interface TooltipSubmenuHandler { 
              isApplicableTo(slot: net.minecraft.screen.slot.Slot): boolean;
              onScroll(horizontal: number, vertical: number, slotId: number, item: net.minecraft.item.ItemStack): boolean;
              reset(slot: net.minecraft.screen.slot.Slot): void;
              onMouseClick(slot: net.minecraft.screen.slot.Slot, actionType: net.minecraft.screen.slot.SlotActionType): void;
            }
          }
          namespace hud {
            namespace debug {
              namespace chart {
                const PieChart: {
                  field_52773: number;
                  field_59836: number;
                  new(textRenderer: net.minecraft.client.font.TextRenderer): net.minecraft.client.gui.hud.debug.chart.PieChart;
                }
                interface PieChart { 
                  setProfileResult(profileResult: net.minecraft.util.profiler.ProfileResult | null | undefined): void;
                  setBottomMargin(bottomMargin: number): void;
                  render(context: net.minecraft.client.gui.DrawContext): void;
                  select(index: number): void;
                }
              }
              const DebugHudProfile: {
                new(file: java.io.File): net.minecraft.client.gui.hud.debug.DebugHudProfile;
              }
              interface DebugHudProfile { 
                readProfileFile(): void;
                setProfileType(type: net.minecraft.client.gui.hud.debug.DebugProfileType): void;
                getVisibility(entryId: net.minecraft.util.Identifier): net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility;
                isEntryVisible(entryId: net.minecraft.util.Identifier): boolean;
                setEntryVisibility(entryId: net.minecraft.util.Identifier, visibility: net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility): void;
                toggleVisibility(entryId: net.minecraft.util.Identifier): boolean;
                getVisibleEntries(): Array<net.minecraft.util.Identifier>;
                toggleF3Enabled(): void;
                setF3Enabled(f3Enabled: boolean): void;
                isF3Enabled(): boolean;
                updateVisibleEntries(): void;
                getVersion(): number;
                profileTypeMatches(type: net.minecraft.client.gui.hud.debug.DebugProfileType): boolean;
                saveProfileFile(): void;
              }
              const DebugProfileType: {
                DEFAULT: net.minecraft.client.gui.hud.debug.DebugProfileType;
                PERFORMANCE: net.minecraft.client.gui.hud.debug.DebugProfileType;
                CODEC: net.minecraft.util.StringIdentifiable$EnumCodec<net.minecraft.client.gui.hud.debug.DebugProfileType>;
                valueOf(value: string): net.minecraft.client.gui.hud.debug.DebugProfileType;
                values(): Array<net.minecraft.client.gui.hud.debug.DebugProfileType>;
              }
              interface DebugProfileType extends kotlin.Enum<net.minecraft.client.gui.hud.debug.DebugProfileType>, net.minecraft.util.StringIdentifiable { 
                getTranslationKey(): string;
              }
              const DebugHudEntryVisibility: {
                ALWAYS_ON: net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility;
                IN_F3: net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility;
                NEVER: net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility;
                CODEC: net.minecraft.util.StringIdentifiable$EnumCodec<net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility>;
                valueOf(value: string): net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility;
                values(): Array<net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility>;
              }
              interface DebugHudEntryVisibility extends kotlin.Enum<net.minecraft.client.gui.hud.debug.DebugHudEntryVisibility>, net.minecraft.util.StringIdentifiable { 
              }
            }
            namespace spectator {
              interface SpectatorMenuCloseCallback { 
                close(menu: net.minecraft.client.gui.hud.spectator.SpectatorMenu): void;
              }
              const SpectatorMenu: {
                BLANK_COMMAND: net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand;
                new(closeCallback: net.minecraft.client.gui.hud.spectator.SpectatorMenuCloseCallback): net.minecraft.client.gui.hud.spectator.SpectatorMenu;
              }
              interface SpectatorMenu { 
                getCommand(slot: number): net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand;
                getCommands(): Array<net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand>;
                getSelectedCommand(): net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand;
                getCurrentGroup(): net.minecraft.client.gui.hud.spectator.SpectatorMenuCommandGroup;
                useCommand(slot: number): void;
                close(): void;
                getSelectedSlot(): number;
                selectElement(group: net.minecraft.client.gui.hud.spectator.SpectatorMenuCommandGroup): void;
                getCurrentState(): net.minecraft.client.gui.hud.spectator.SpectatorMenuState;
              }
              interface SpectatorMenuCommand { 
                use(menu: net.minecraft.client.gui.hud.spectator.SpectatorMenu): void;
                getName(): net.minecraft.text.Text;
                renderIcon(context: net.minecraft.client.gui.DrawContext, brightness: number, alpha: number): void;
                isEnabled(): boolean;
              }
              interface SpectatorMenuCommandGroup { 
                getCommands(): Array<net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand>;
                getPrompt(): net.minecraft.text.Text;
              }
              const SpectatorMenuState: {
                field_32444: number;
                new(commands: Array<net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand>, selectedSlot: number): net.minecraft.client.gui.hud.spectator.SpectatorMenuState;
              }
              interface SpectatorMenuState { 
                getCommand(slot: number): net.minecraft.client.gui.hud.spectator.SpectatorMenuCommand;
                getSelectedSlot(): number;
              }
            }
            const ChatHud$ChatMethod: {
              MESSAGE: net.minecraft.client.gui.hud.ChatHud$ChatMethod;
              COMMAND: net.minecraft.client.gui.hud.ChatHud$ChatMethod;
              valueOf(value: string): net.minecraft.client.gui.hud.ChatHud$ChatMethod;
              values(): Array<net.minecraft.client.gui.hud.ChatHud$ChatMethod>;
            }
            interface ChatHud$ChatMethod extends kotlin.Enum<net.minecraft.client.gui.hud.ChatHud$ChatMethod> { 
              getReplacement(): string;
              shouldKeepDraft(draft: net.minecraft.client.gui.hud.ChatHud$Draft): boolean;
            }
            const ChatHud$Draft: {
              new(string: string, chatMethod: net.minecraft.client.gui.hud.ChatHud$ChatMethod): net.minecraft.client.gui.hud.ChatHud$Draft;
            }
            interface ChatHud$Draft extends java.lang.Record { 
              text(): string;
              chatMethod(): net.minecraft.client.gui.hud.ChatHud$ChatMethod;
            }
            const DebugHud: {
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.gui.hud.DebugHud;
            }
            interface DebugHud { 
              resetChunk(): void;
              render(context: net.minecraft.client.gui.DrawContext): void;
              shouldShowDebugHud(): boolean;
              shouldShowRenderingChart(): boolean;
              shouldShowPacketSizeAndPingCharts(): boolean;
              shouldRenderTickCharts(): boolean;
              togglePacketSizeAndPingCharts(): void;
              toggleRenderingAndTickCharts(): void;
              toggleRenderingChart(): void;
              pushToFrameLog(value: number): void;
              getTickNanosLog(): net.minecraft.util.profiler.MultiValueDebugSampleLogImpl;
              getPingLog(): net.minecraft.util.profiler.MultiValueDebugSampleLogImpl;
              getPacketSizeLog(): net.minecraft.util.profiler.MultiValueDebugSampleLogImpl;
              getPieChart(): net.minecraft.client.gui.hud.debug.chart.PieChart;
              set(values: Array<number>, type: net.minecraft.util.profiler.log.DebugSampleType): void;
              clear(): void;
              renderDebugCrosshair(camera: net.minecraft.client.render.Camera): void;
            }
            const InGameHud: {
              NAUSEA_TEXTURE: net.minecraft.util.Identifier;
              getEffectTexture(effect: net.minecraft.registry.entry.RegistryEntry<net.minecraft.entity.effect.StatusEffect>): net.minecraft.util.Identifier;
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.gui.hud.InGameHud;
            }
            interface InGameHud { 
              vignetteDarkness: number;
              setDefaultTitleFade(): void;
              render(context: net.minecraft.client.gui.DrawContext, tickCounter: net.minecraft.client.render.RenderTickCounter): void;
              renderDebugHud(context: net.minecraft.client.gui.DrawContext): void;
              renderDeferredSubtitles(): void;
              tick(paused: boolean): void;
              setRecordPlayingOverlay(description: net.minecraft.text.Text): void;
              setOverlayMessage(message: net.minecraft.text.Text, tinted: boolean): void;
              setCanShowChatDisabledScreen(canShowChatDisabledScreen: boolean): void;
              shouldShowChatDisabledScreen(): boolean;
              setTitleTicks(fadeInTicks: number, stayTicks: number, fadeOutTicks: number): void;
              setSubtitle(subtitle: net.minecraft.text.Text): void;
              setTitle(title: net.minecraft.text.Text): void;
              clearTitle(): void;
              getChatHud(): net.minecraft.client.gui.hud.ChatHud;
              getTicks(): number;
              getTextRenderer(): net.minecraft.client.font.TextRenderer;
              getSpectatorHud(): net.minecraft.client.gui.hud.SpectatorHud;
              getPlayerListHud(): net.minecraft.client.gui.hud.PlayerListHud;
              clear(): void;
              getBossBarHud(): net.minecraft.client.gui.hud.BossBarHud;
              getDebugHud(): net.minecraft.client.gui.hud.DebugHud;
              resetDebugHudChunk(): void;
              renderAutosaveIndicator(context: net.minecraft.client.gui.DrawContext, tickCounter: net.minecraft.client.render.RenderTickCounter): void;
            }
            interface InGameHud$Renderable { 
              render(context: net.minecraft.client.gui.DrawContext, tickCounter: net.minecraft.client.render.RenderTickCounter): void;
            }
            const ChatHud: {
              Draft: typeof net.minecraft.client.gui.hud.ChatHud$Draft;
              ChatState: typeof net.minecraft.client.gui.hud.ChatHud$ChatState;
              ChatMethod: typeof net.minecraft.client.gui.hud.ChatHud$ChatMethod;
              getWidth(widthOption: number): number;
              getHeight(heightOption: number): number;
              getDefaultUnfocusedHeight(): number;
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.gui.hud.ChatHud;
            }
            interface ChatHud { 
              tickRemovalQueueIfExists(): void;
              render(context: net.minecraft.client.gui.DrawContext, currentTick: number, mouseX: number, mouseY: number, focused: boolean): void;
              clear(clearHistory: boolean): void;
              addMessage(message: net.minecraft.text.Text): void;
              addMessage(message: net.minecraft.text.Text, signatureData: net.minecraft.network.message.MessageSignatureData | null | undefined, indicator: net.minecraft.client.gui.hud.MessageIndicator | null | undefined): void;
              removeMessage(signature: net.minecraft.network.message.MessageSignatureData): void;
              reset(): void;
              getMessageHistory(): net.minecraft.util.collection.ArrayListDeque<string>;
              addToMessageHistory(message: string): void;
              resetScroll(): void;
              scroll(scroll: number): void;
              mouseClicked(mouseX: number, mouseY: number): boolean;
              getTextStyleAt(x: number, y: number): net.minecraft.text.Style | null | undefined;
              getIndicatorAt(mouseX: number, mouseY: number): net.minecraft.client.gui.hud.MessageIndicator | null | undefined;
              isChatFocused(): boolean;
              getWidth(): number;
              getHeight(): number;
              getChatScale(): number;
              getVisibleLineCount(): number;
              saveDraft(text: string): void;
              discardDraft(): void;
              createScreen<T>(method: net.minecraft.client.gui.hud.ChatHud$ChatMethod, factory: net.minecraft.client.gui.screen.ChatScreen$Factory<T>): T;
              setClientScreen(method: net.minecraft.client.gui.hud.ChatHud$ChatMethod, factory: net.minecraft.client.gui.screen.ChatScreen$Factory<any>): void;
              setScreen(): void;
              removeScreen(): net.minecraft.client.gui.screen.ChatScreen | null | undefined;
              toChatState(): net.minecraft.client.gui.hud.ChatHud$ChatState;
              restoreChatState(state: net.minecraft.client.gui.hud.ChatHud$ChatState): void;
            }
            const ChatHud$ChatState: {
              new(messages: Array<net.minecraft.client.gui.hud.ChatHudLine>, messageHistory: Array<string>, removalQueue: Array<unknown>): net.minecraft.client.gui.hud.ChatHud$ChatState;
            }
            interface ChatHud$ChatState { 
            }
            const MessageIndicator: {
              Icon: typeof net.minecraft.client.gui.hud.MessageIndicator$Icon;
              system(): net.minecraft.client.gui.hud.MessageIndicator;
              singlePlayer(): net.minecraft.client.gui.hud.MessageIndicator;
              notSecure(): net.minecraft.client.gui.hud.MessageIndicator;
              modified(originalText: string): net.minecraft.client.gui.hud.MessageIndicator;
              chatError(): net.minecraft.client.gui.hud.MessageIndicator;
              new(i: number, icon: net.minecraft.client.gui.hud.MessageIndicator$Icon | null | undefined, text: net.minecraft.text.Text | null | undefined, string: string | null | undefined): net.minecraft.client.gui.hud.MessageIndicator;
            }
            interface MessageIndicator extends java.lang.Record { 
              indicatorColor(): number;
              icon(): net.minecraft.client.gui.hud.MessageIndicator$Icon | null | undefined;
              text(): net.minecraft.text.Text | null | undefined;
              loggedName(): string | null | undefined;
            }
            const MessageIndicator$Icon: {
              CHAT_MODIFIED: net.minecraft.client.gui.hud.MessageIndicator$Icon;
              valueOf(value: string): net.minecraft.client.gui.hud.MessageIndicator$Icon;
              values(): Array<net.minecraft.client.gui.hud.MessageIndicator$Icon>;
            }
            interface MessageIndicator$Icon extends kotlin.Enum<net.minecraft.client.gui.hud.MessageIndicator$Icon> { 
              texture: net.minecraft.util.Identifier;
              width: number;
              height: number;
              draw(context: net.minecraft.client.gui.DrawContext, x: number, y: number): void;
            }
            const SpectatorHud: {
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.gui.hud.SpectatorHud;
            }
            interface SpectatorHud extends net.minecraft.client.gui.hud.spectator.SpectatorMenuCloseCallback { 
              selectSlot(slot: number): void;
              renderSpectatorMenu(context: net.minecraft.client.gui.DrawContext): void;
              render(context: net.minecraft.client.gui.DrawContext): void;
              isOpen(): boolean;
              cycleSlot(offset: number): void;
              useSelectedCommand(): void;
            }
            const PlayerListHud: {
              MAX_ROWS: number;
              new(client: net.minecraft.client.MinecraftClient, inGameHud: net.minecraft.client.gui.hud.InGameHud): net.minecraft.client.gui.hud.PlayerListHud;
            }
            interface PlayerListHud { 
              getPlayerName(entry: net.minecraft.client.network.PlayerListEntry): net.minecraft.text.Text;
              setVisible(visible: boolean): void;
              render(context: net.minecraft.client.gui.DrawContext, scaledWindowWidth: number, scoreboard: net.minecraft.scoreboard.Scoreboard, objective: net.minecraft.scoreboard.ScoreboardObjective | null | undefined): void;
              setFooter(footer: net.minecraft.text.Text | null | undefined): void;
              setHeader(header: net.minecraft.text.Text | null | undefined): void;
              clear(): void;
            }
            const BossBarHud: {
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.gui.hud.BossBarHud;
            }
            interface BossBarHud { 
              render(context: net.minecraft.client.gui.DrawContext): void;
              handlePacket(packet: net.minecraft.network.packet.s2c.play.BossBarS2CPacket): void;
              clear(): void;
              shouldPlayDragonMusic(): boolean;
              shouldDarkenSky(): boolean;
              shouldThickenFog(): boolean;
            }
            const ChatHudLine: {
              Visible: typeof net.minecraft.client.gui.hud.ChatHudLine$Visible;
              new(creationTick: number, text: net.minecraft.text.Text, messageSignatureData: net.minecraft.network.message.MessageSignatureData | null | undefined, messageIndicator: net.minecraft.client.gui.hud.MessageIndicator | null | undefined): net.minecraft.client.gui.hud.ChatHudLine;
            }
            interface ChatHudLine extends java.lang.Record { 
              getIcon(): net.minecraft.client.gui.hud.MessageIndicator$Icon | null | undefined;
              creationTick(): number;
              content(): net.minecraft.text.Text;
              signature(): net.minecraft.network.message.MessageSignatureData | null | undefined;
              indicator(): net.minecraft.client.gui.hud.MessageIndicator | null | undefined;
            }
            const ChatHudLine$Visible: {
              new(i: number, orderedText: net.minecraft.text.OrderedText, messageIndicator: net.minecraft.client.gui.hud.MessageIndicator | null | undefined, bl: boolean): net.minecraft.client.gui.hud.ChatHudLine$Visible;
            }
            interface ChatHudLine$Visible extends java.lang.Record { 
              addedTime(): number;
              content(): net.minecraft.text.OrderedText;
              indicator(): net.minecraft.client.gui.hud.MessageIndicator | null | undefined;
              endOfEntry(): boolean;
            }
            const ClientBossBar: {
              new(uuid: java.util.UUID, name: net.minecraft.text.Text, percent: number, color: net.minecraft.entity.boss.BossBar$Color, style: net.minecraft.entity.boss.BossBar$Style, darkenSky: boolean, dragonMusic: boolean, thickenFog: boolean): net.minecraft.client.gui.hud.ClientBossBar;
            }
            interface ClientBossBar extends net.minecraft.entity.boss.BossBar { 
            }
          }
          namespace widget {
            const CyclingButtonWidget$Values: {
              of<T>(values: Array<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Values<T>;
              of<T>(alternativeToggle: unknown, defaults: Array<T>, alternatives: Array<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Values<T>;
            }
            interface CyclingButtonWidget$Values<T> { 
              getCurrent(): Array<T>;
              getDefaults(): Array<T>;
            }
            interface OptionSliderWidget extends net.minecraft.client.gui.widget.SliderWidget { 
            }
            const SliderWidget: {
              field_60708: number;
              new(x: number, y: number, width: number, height: number, text: net.minecraft.text.Text, value: number): net.minecraft.client.gui.widget.SliderWidget;
            }
            interface SliderWidget extends net.minecraft.client.gui.widget.ClickableWidget { 
            }
            const ClickableWidget: {
              getNarrationMessage(message: net.minecraft.text.Text): net.minecraft.text.MutableText;
              playClickSound(soundManager: net.minecraft.client.sound.SoundManager): void;
              new(x: number, y: number, width: number, height: number, message: net.minecraft.text.Text): net.minecraft.client.gui.widget.ClickableWidget;
            }
            interface ClickableWidget extends net.minecraft.client.gui.Drawable, net.minecraft.client.gui.Element, net.minecraft.client.gui.widget.Widget, net.minecraft.client.gui.Selectable { 
              active: boolean;
              visible: boolean;
              setTooltip(tooltip: net.minecraft.client.gui.tooltip.Tooltip | null | undefined): void;
              setTooltipDelay(tooltipDelay: java.time.Duration): void;
              onClick(click: net.minecraft.client.gui.Click, doubled: boolean): void;
              onRelease(click: net.minecraft.client.gui.Click): void;
              playDownSound(soundManager: net.minecraft.client.sound.SoundManager): void;
              setWidth(width: number): void;
              setHeight(height: number): void;
              setAlpha(alpha: number): void;
              setMessage(message: net.minecraft.text.Text): void;
              getMessage(): net.minecraft.text.Text;
              isHovered(): boolean;
              isSelected(): boolean;
              getRight(): number;
              getBottom(): number;
              setDimensions(width: number, height: number): void;
              setDimensionsAndPosition(width: number, height: number, x: number, y: number): void;
              setNavigationOrder(navigationOrder: number): void;
            }
            interface Widget { 
              setX(x: number): void;
              setY(y: number): void;
              getX(): number;
              getY(): number;
              getWidth(): number;
              getHeight(): number;
              getNavigationFocus(): net.minecraft.client.gui.ScreenRect;
              setPosition(x: number, y: number): void;
              forEachChild(consumer: unknown): void;
            }
            const TextFieldWidget: {
              field_32194: number;
              field_32195: number;
              DEFAULT_EDITABLE_COLOR: number;
              PLACEHOLDER_STYLE: net.minecraft.text.Style;
              SEARCH_STYLE: net.minecraft.text.Style;
              new(textRenderer: net.minecraft.client.font.TextRenderer, width: number, height: number, text: net.minecraft.text.Text): net.minecraft.client.gui.widget.TextFieldWidget;
              new(textRenderer: net.minecraft.client.font.TextRenderer, x: number, y: number, width: number, height: number, text: net.minecraft.text.Text): net.minecraft.client.gui.widget.TextFieldWidget;
              new(textRenderer: net.minecraft.client.font.TextRenderer, x: number, y: number, width: number, height: number, copyFrom: net.minecraft.client.gui.widget.TextFieldWidget | null | undefined, text: net.minecraft.text.Text): net.minecraft.client.gui.widget.TextFieldWidget;
            }
            interface TextFieldWidget extends net.minecraft.client.gui.widget.ClickableWidget { 
              setChangedListener(changedListener: unknown): void;
              addFormatter(formatter: net.minecraft.client.gui.widget.TextFieldWidget$Formatter): void;
              setText(text: string): void;
              getText(): string;
              getSelectedText(): string;
              setTextPredicate(textPredicate: unknown): void;
              write(text: string): void;
              eraseWords(wordOffset: number): void;
              eraseCharacters(characterOffset: number): void;
              eraseCharactersTo(position: number): void;
              getWordSkipPosition(wordOffset: number): number;
              moveCursor(offset: number, shiftKeyPressed: boolean): void;
              setCursor(cursor: number, select: boolean): void;
              setSelectionStart(cursor: number): void;
              setCursorToStart(shiftKeyPressed: boolean): void;
              setCursorToEnd(shiftKeyPressed: boolean): void;
              isActive(): boolean;
              setMaxLength(maxLength: number): void;
              getCursor(): number;
              drawsBackground(): boolean;
              setDrawsBackground(drawsBackground: boolean): void;
              setEditableColor(editableColor: number): void;
              setUneditableColor(uneditableColor: number): void;
              setEditable(editable: boolean): void;
              setCentered(centered: boolean): void;
              setTextShadow(textShadow: boolean): void;
              getInnerWidth(): number;
              setSelectionEnd(index: number): void;
              setFocusUnlocked(focusUnlocked: boolean): void;
              isVisible(): boolean;
              setVisible(visible: boolean): void;
              setSuggestion(suggestion: string | null | undefined): void;
              getCharacterX(index: number): number;
              setPlaceholder(placeholder: net.minecraft.text.Text): void;
            }
            interface TextFieldWidget$Formatter { 
              format(string: string, firstCharacterIndex: number): net.minecraft.text.OrderedText | null | undefined;
              (string: string, firstCharacterIndex: number): net.minecraft.text.OrderedText | null | undefined;
            }
            const CyclingButtonWidget: {
              Builder: typeof net.minecraft.client.gui.widget.CyclingButtonWidget$Builder;
              HAS_ALT_DOWN: unknown;
              builder<T>(valueToText: unknown): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              onOffBuilder(on: net.minecraft.text.Text, off: net.minecraft.text.Text): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<boolean>;
              onOffBuilder(): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<boolean>;
              onOffBuilder(initialValue: boolean): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<boolean>;
            }
            interface CyclingButtonWidget<T> extends net.minecraft.client.gui.widget.PressableWidget { 
              getValue(): T;
              setValue(value: T): void;
              getGenericNarrationMessage(): net.minecraft.text.MutableText;
            }
            const PressableWidget: {
              new(i: number, j: number, k: number, l: number, text: net.minecraft.text.Text): net.minecraft.client.gui.widget.PressableWidget;
            }
            interface PressableWidget extends net.minecraft.client.gui.widget.ClickableWidget { 
              onPress(input: net.minecraft.client.input.AbstractInput): void;
              drawMessage(context: net.minecraft.client.gui.DrawContext, textRenderer: net.minecraft.client.font.TextRenderer, color: number): void;
            }
            const CyclingButtonWidget$Builder: {
              new<T>(valueToText: unknown): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
            }
            interface CyclingButtonWidget$Builder<T> { 
              values(values: Array<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              values(values: T): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              values(defaults: Array<T>, alternatives: Array<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              values(alternativeToggle: unknown, defaults: Array<T>, alternatives: Array<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              values(values: net.minecraft.client.gui.widget.CyclingButtonWidget$Values<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              tooltip(tooltipFactory: net.minecraft.client.option.SimpleOption$TooltipFactory<T>): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              initially(value: T): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              narration(narrationMessageFactory: unknown): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              optionTextOmitted(optionTextOmitted: boolean): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              omitKeyText(): net.minecraft.client.gui.widget.CyclingButtonWidget$Builder<T>;
              build(optionText: net.minecraft.text.Text, callback: net.minecraft.client.gui.widget.CyclingButtonWidget$UpdateCallback<T>): net.minecraft.client.gui.widget.CyclingButtonWidget<T>;
              build(x: number, y: number, width: number, height: number, optionText: net.minecraft.text.Text): net.minecraft.client.gui.widget.CyclingButtonWidget<T>;
              build(x: number, y: number, width: number, height: number, optionText: net.minecraft.text.Text, callback: net.minecraft.client.gui.widget.CyclingButtonWidget$UpdateCallback<T>): net.minecraft.client.gui.widget.CyclingButtonWidget<T>;
            }
            interface CyclingButtonWidget$UpdateCallback<T> { 
              onValueChange(button: net.minecraft.client.gui.widget.CyclingButtonWidget<T>, value: T): void;
              (button: net.minecraft.client.gui.widget.CyclingButtonWidget<T>, value: T): void;
            }
            const ButtonWidget: {
              Builder: typeof net.minecraft.client.gui.widget.ButtonWidget$Builder;
              DEFAULT_WIDTH_SMALL: number;
              DEFAULT_WIDTH: number;
              field_49479: number;
              DEFAULT_HEIGHT: number;
              field_46856: number;
              builder(message: net.minecraft.text.Text, onPress: net.minecraft.client.gui.widget.ButtonWidget$PressAction): net.minecraft.client.gui.widget.ButtonWidget$Builder;
            }
            interface ButtonWidget extends net.minecraft.client.gui.widget.PressableWidget { 
            }
            interface ButtonWidget$NarrationSupplier { 
              createNarrationMessage(textSupplier: unknown): net.minecraft.text.MutableText;
            }
            const ButtonWidget$Builder: {
              new(message: net.minecraft.text.Text, onPress: net.minecraft.client.gui.widget.ButtonWidget$PressAction): net.minecraft.client.gui.widget.ButtonWidget$Builder;
            }
            interface ButtonWidget$Builder { 
              position(x: number, y: number): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              width(width: number): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              size(width: number, height: number): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              dimensions(x: number, y: number, width: number, height: number): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              tooltip(tooltip: net.minecraft.client.gui.tooltip.Tooltip | null | undefined): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              narrationSupplier(narrationSupplier: net.minecraft.client.gui.widget.ButtonWidget$NarrationSupplier): net.minecraft.client.gui.widget.ButtonWidget$Builder;
              build(): net.minecraft.client.gui.widget.ButtonWidget;
            }
            interface ButtonWidget$PressAction { 
              onPress(button: net.minecraft.client.gui.widget.ButtonWidget): void;
            }
          }
          namespace render {
            namespace state {
              namespace special {
                const SpecialGuiElementRenderState: {
                  createBounds(x1: number, y1: number, x2: number, y2: number, scissorArea: net.minecraft.client.gui.ScreenRect | null | undefined): net.minecraft.client.gui.ScreenRect | null | undefined;
                }
                interface SpecialGuiElementRenderState extends net.minecraft.client.gui.render.state.GuiElementRenderState { 
                  x1(): number;
                  x2(): number;
                  y1(): number;
                  y2(): number;
                  scale(): number;
                  pose(): org.joml.Matrix3x2f;
                  scissorArea(): net.minecraft.client.gui.ScreenRect | null | undefined;
                }
              }
              const GuiRenderState: {
                LayerFilter: typeof net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter;
                new(): net.minecraft.client.gui.render.state.GuiRenderState;
              }
              interface GuiRenderState { 
                createNewRootLayer(): void;
                applyBlur(): void;
                goUpLayer(): void;
                addItem(state: net.minecraft.client.gui.render.state.ItemGuiElementRenderState): void;
                addText(state: net.minecraft.client.gui.render.state.TextGuiElementRenderState): void;
                addSpecialElement(state: net.minecraft.client.gui.render.state.special.SpecialGuiElementRenderState): void;
                addSimpleElement(state: net.minecraft.client.gui.render.state.SimpleGuiElementRenderState): void;
                addSimpleElementToCurrentLayer(state: net.minecraft.client.gui.render.state.TexturedQuadGuiElementRenderState): void;
                addPreparedTextElement(state: net.minecraft.client.gui.render.state.SimpleGuiElementRenderState): void;
                getItemModelKeys(): Set<any>;
                forEachSimpleElement(consumer: unknown, filter: net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter): void;
                forEachItemElement(itemElementStateConsumer: unknown): void;
                forEachTextElement(textElementStateConsumer: unknown): void;
                forEachSpecialElement(specialElementStateConsumer: unknown): void;
                sortSimpleElements(simpleElementStateComparator: java.util.Comparator<net.minecraft.client.gui.render.state.SimpleGuiElementRenderState>): void;
                clear(): void;
              }
              const GuiRenderState$LayerFilter: {
                ALL: net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter;
                BEFORE_BLUR: net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter;
                AFTER_BLUR: net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter;
                valueOf(value: string): net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter;
                values(): Array<net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter>;
              }
              interface GuiRenderState$LayerFilter extends kotlin.Enum<net.minecraft.client.gui.render.state.GuiRenderState$LayerFilter> { 
              }
              const ItemGuiElementRenderState: {
                new(name: string, pose: org.joml.Matrix3x2f, state: net.minecraft.client.render.item.KeyedItemRenderState, x: number, y: number, scissor: net.minecraft.client.gui.ScreenRect | null | undefined): net.minecraft.client.gui.render.state.ItemGuiElementRenderState;
              }
              interface ItemGuiElementRenderState extends net.minecraft.client.gui.render.state.GuiElementRenderState { 
                name(): string;
                pose(): org.joml.Matrix3x2f;
                state(): net.minecraft.client.render.item.KeyedItemRenderState;
                x(): number;
                y(): number;
                scissorArea(): net.minecraft.client.gui.ScreenRect | null | undefined;
                oversizedBounds(): net.minecraft.client.gui.ScreenRect | null | undefined;
              }
              interface GuiElementRenderState { 
                bounds(): net.minecraft.client.gui.ScreenRect | null | undefined;
              }
              const TextGuiElementRenderState: {
                new(textRenderer: net.minecraft.client.font.TextRenderer, orderedText: net.minecraft.text.OrderedText, matrix: org.joml.Matrix3x2f, x: number, y: number, color: number, backgroundColor: number, shadow: boolean, clipBounds: net.minecraft.client.gui.ScreenRect | null | undefined): net.minecraft.client.gui.render.state.TextGuiElementRenderState;
              }
              interface TextGuiElementRenderState extends net.minecraft.client.gui.render.state.GuiElementRenderState { 
                textRenderer: net.minecraft.client.font.TextRenderer;
                orderedText: net.minecraft.text.OrderedText;
                matrix: org.joml.Matrix3x2f;
                x: number;
                y: number;
                color: number;
                backgroundColor: number;
                shadow: boolean;
                clipBounds: net.minecraft.client.gui.ScreenRect | null | undefined;
                prepare(): net.minecraft.client.font.TextRenderer$GlyphDrawable;
              }
              interface SimpleGuiElementRenderState extends net.minecraft.client.gui.render.state.GuiElementRenderState { 
                setupVertices(vertices: net.minecraft.client.render.VertexConsumer): void;
                pipeline(): com.mojang.blaze3d.pipeline.RenderPipeline;
                textureSetup(): net.minecraft.client.texture.TextureSetup;
                scissorArea(): net.minecraft.client.gui.ScreenRect | null | undefined;
              }
              const TexturedQuadGuiElementRenderState: {
                new(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, textureSetup: net.minecraft.client.texture.TextureSetup, pose: org.joml.Matrix3x2f, x1: number, y1: number, x2: number, y2: number, u1: number, u2: number, v1: number, v2: number, color: number, scissorArea: net.minecraft.client.gui.ScreenRect | null | undefined): net.minecraft.client.gui.render.state.TexturedQuadGuiElementRenderState;
                new(renderPipeline: com.mojang.blaze3d.pipeline.RenderPipeline, textureSetup: net.minecraft.client.texture.TextureSetup, matrix3x2f: org.joml.Matrix3x2f, i: number, j: number, k: number, l: number, f: number, g: number, h: number, m: number, n: number, screenRect: net.minecraft.client.gui.ScreenRect | null | undefined, screenRect2: net.minecraft.client.gui.ScreenRect | null | undefined): net.minecraft.client.gui.render.state.TexturedQuadGuiElementRenderState;
              }
              interface TexturedQuadGuiElementRenderState extends java.lang.Record, net.minecraft.client.gui.render.state.SimpleGuiElementRenderState { 
                pose(): org.joml.Matrix3x2f;
                x1(): number;
                y1(): number;
                x2(): number;
                y2(): number;
                u1(): number;
                u2(): number;
                v1(): number;
                v2(): number;
                color(): number;
              }
            }
          }
          const Click: {
            new(d: number, e: number, mouseInput: net.minecraft.client.input.MouseInput): net.minecraft.client.gui.Click;
          }
          interface Click extends java.lang.Record, net.minecraft.client.input.AbstractInput { 
            button(): number;
            x(): number;
            y(): number;
            buttonInfo(): net.minecraft.client.input.MouseInput;
          }
          const AbstractParentElement: {
            new(): net.minecraft.client.gui.AbstractParentElement;
          }
          interface AbstractParentElement extends net.minecraft.client.gui.ParentElement { 
          }
          interface ParentElement extends net.minecraft.client.gui.Element { 
            setFocused(focused: net.minecraft.client.gui.Element | null | undefined): void;
            children(): Array<net.minecraft.client.gui.Element>;
            hoveredElement(mouseX: number, mouseY: number): java.util.Optional<net.minecraft.client.gui.Element>;
            isDragging(): boolean;
            setDragging(dragging: boolean): void;
            getFocused(): net.minecraft.client.gui.Element | null | undefined;
          }
          interface Element extends net.minecraft.client.gui.navigation.Navigable { 
            mouseMoved(mouseX: number, mouseY: number): void;
            mouseClicked(click: net.minecraft.client.gui.Click, doubled: boolean): boolean;
            mouseReleased(click: net.minecraft.client.gui.Click): boolean;
            mouseDragged(click: net.minecraft.client.gui.Click, offsetX: number, offsetY: number): boolean;
            mouseScrolled(mouseX: number, mouseY: number, horizontalAmount: number, verticalAmount: number): boolean;
            keyPressed(input: net.minecraft.client.input.KeyInput): boolean;
            keyReleased(input: net.minecraft.client.input.KeyInput): boolean;
            charTyped(input: net.minecraft.client.input.CharInput): boolean;
            getNavigationPath(navigation: net.minecraft.client.gui.navigation.GuiNavigation): net.minecraft.client.gui.navigation.GuiNavigationPath | null | undefined;
            isMouseOver(mouseX: number, mouseY: number): boolean;
            setFocused(focused: boolean): void;
            isFocused(): boolean;
            isClickable(): boolean;
            getFocusedPath(): net.minecraft.client.gui.navigation.GuiNavigationPath | null | undefined;
            getNavigationFocus(): net.minecraft.client.gui.ScreenRect;
            getBorder(direction: net.minecraft.client.gui.navigation.NavigationDirection): net.minecraft.client.gui.ScreenRect;
          }
          const ScreenRect: {
            empty(): net.minecraft.client.gui.ScreenRect;
            of(axis: net.minecraft.client.gui.navigation.NavigationAxis, sameAxisCoord: number, otherAxisCoord: number, sameAxisLength: number, otherAxisLength: number): net.minecraft.client.gui.ScreenRect;
            new(sameAxis: number, otherAxis: number, width: number, height: number): net.minecraft.client.gui.ScreenRect;
            new(screenPos: net.minecraft.client.gui.ScreenPos, i: number, j: number): net.minecraft.client.gui.ScreenRect;
          }
          interface ScreenRect extends java.lang.Record { 
            add(direction: net.minecraft.client.gui.navigation.NavigationDirection): net.minecraft.client.gui.ScreenRect;
            getLength(axis: net.minecraft.client.gui.navigation.NavigationAxis): number;
            getBoundingCoordinate(direction: net.minecraft.client.gui.navigation.NavigationDirection): number;
            getBorder(direction: net.minecraft.client.gui.navigation.NavigationDirection): net.minecraft.client.gui.ScreenRect;
            overlaps(other: net.minecraft.client.gui.ScreenRect): boolean;
            overlaps(other: net.minecraft.client.gui.ScreenRect, axis: net.minecraft.client.gui.navigation.NavigationAxis): boolean;
            getCenter(axis: net.minecraft.client.gui.navigation.NavigationAxis): number;
            intersection(other: net.minecraft.client.gui.ScreenRect): net.minecraft.client.gui.ScreenRect | null | undefined;
            intersects(other: net.minecraft.client.gui.ScreenRect): boolean;
            contains(other: net.minecraft.client.gui.ScreenRect): boolean;
            contains(x: number, y: number): boolean;
            getTop(): number;
            getBottom(): number;
            getLeft(): number;
            getRight(): number;
            transform(transformation: org.joml.Matrix3x2f): net.minecraft.client.gui.ScreenRect;
            transformEachVertex(transformation: org.joml.Matrix3x2f): net.minecraft.client.gui.ScreenRect;
            position(): net.minecraft.client.gui.ScreenPos;
            width(): number;
            height(): number;
          }
          const ScreenPos: {
            of(axis: net.minecraft.client.gui.navigation.NavigationAxis, sameAxis: number, otherAxis: number): net.minecraft.client.gui.ScreenPos;
            new(i: number, j: number): net.minecraft.client.gui.ScreenPos;
          }
          interface ScreenPos extends java.lang.Record { 
            add(direction: net.minecraft.client.gui.navigation.NavigationDirection): net.minecraft.client.gui.ScreenPos;
            getComponent(axis: net.minecraft.client.gui.navigation.NavigationAxis): number;
            x(): number;
            y(): number;
          }
          interface Drawable { 
            render(context: net.minecraft.client.gui.DrawContext, mouseX: number, mouseY: number, deltaTicks: number): void;
          }
          const DrawContext: {
            ScissorStack: typeof net.minecraft.client.gui.DrawContext$ScissorStack;
            new(client: net.minecraft.client.MinecraftClient, state: net.minecraft.client.gui.render.state.GuiRenderState): net.minecraft.client.gui.DrawContext;
          }
          interface DrawContext { 
            scissorStack: net.minecraft.client.gui.DrawContext$ScissorStack;
            state: net.minecraft.client.gui.render.state.GuiRenderState;
            setCursor(cursor: net.minecraft.client.gui.cursor.Cursor): void;
            applyCursorTo(window: net.minecraft.client.util.Window): void;
            getScaledWindowWidth(): number;
            getScaledWindowHeight(): number;
            createNewRootLayer(): void;
            applyBlur(): void;
            getMatrices(): org.joml.Matrix3x2fStack;
            drawHorizontalLine(x1: number, x2: number, y: number, color: number): void;
            drawVerticalLine(x: number, y1: number, y2: number, color: number): void;
            enableScissor(x1: number, y1: number, x2: number, y2: number): void;
            disableScissor(): void;
            scissorContains(x: number, y: number): boolean;
            fill(x1: number, y1: number, x2: number, y2: number, color: number): void;
            fill(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, x1: number, y1: number, x2: number, y2: number, color: number): void;
            fill(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, textureSetup: net.minecraft.client.texture.TextureSetup, x1: number, y1: number, x2: number, y2: number): void;
            fillGradient(startX: number, startY: number, endX: number, endY: number, colorStart: number, colorEnd: number): void;
            drawSelection(x1: number, y1: number, x2: number, y2: number): void;
            drawCenteredTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: string, centerX: number, y: number, color: number): void;
            drawCenteredTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, centerX: number, y: number, color: number): void;
            drawCenteredTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.OrderedText, centerX: number, y: number, color: number): void;
            drawTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: string | null | undefined, x: number, y: number, color: number): void;
            drawTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.OrderedText, x: number, y: number, color: number): void;
            drawTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, x: number, y: number, color: number): void;
            drawText(textRenderer: net.minecraft.client.font.TextRenderer, text: string | null | undefined, x: number, y: number, color: number, shadow: boolean): void;
            drawText(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.OrderedText, x: number, y: number, color: number, shadow: boolean): void;
            drawText(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, x: number, y: number, color: number, shadow: boolean): void;
            drawWrappedTextWithShadow(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.StringVisitable, x: number, y: number, width: number, color: number): void;
            drawWrappedText(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.StringVisitable, x: number, y: number, width: number, color: number, shadow: boolean): void;
            drawTextWithBackground(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, x: number, y: number, width: number, color: number): void;
            drawStrokedRectangle(x: number, y: number, width: number, height: number, color: number): void;
            drawGuiTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, width: number, height: number): void;
            drawGuiTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, width: number, height: number, alpha: number): void;
            drawGuiTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, width: number, height: number, color: number): void;
            drawGuiTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, textureWidth: number, textureHeight: number, u: number, v: number, x: number, y: number, width: number, height: number): void;
            drawGuiTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, textureWidth: number, textureHeight: number, u: number, v: number, x: number, y: number, width: number, height: number, color: number): void;
            drawSpriteStretched(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.client.texture.Sprite, x: number, y: number, width: number, height: number): void;
            drawSpriteStretched(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.client.texture.Sprite, x: number, y: number, width: number, height: number, color: number): void;
            drawTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, u: number, v: number, width: number, height: number, textureWidth: number, textureHeight: number, color: number): void;
            drawTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, u: number, v: number, width: number, height: number, textureWidth: number, textureHeight: number): void;
            drawTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, u: number, v: number, width: number, height: number, regionWidth: number, regionHeight: number, textureWidth: number, textureHeight: number): void;
            drawTexture(pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, sprite: net.minecraft.util.Identifier, x: number, y: number, u: number, v: number, width: number, height: number, regionWidth: number, regionHeight: number, textureWidth: number, textureHeight: number, color: number): void;
            drawTexturedQuad(sprite: net.minecraft.util.Identifier, x1: number, y1: number, x2: number, y2: number, u1: number, u2: number, v1: number, v2: number): void;
            drawItem(item: net.minecraft.item.ItemStack, x: number, y: number): void;
            drawItem(stack: net.minecraft.item.ItemStack, x: number, y: number, seed: number): void;
            drawItem(entity: net.minecraft.entity.LivingEntity, stack: net.minecraft.item.ItemStack, x: number, y: number, seed: number): void;
            drawItemWithoutEntity(stack: net.minecraft.item.ItemStack, x: number, y: number): void;
            drawItemWithoutEntity(stack: net.minecraft.item.ItemStack, x: number, y: number, seed: number): void;
            drawStackOverlay(textRenderer: net.minecraft.client.font.TextRenderer, stack: net.minecraft.item.ItemStack, x: number, y: number): void;
            drawStackOverlay(textRenderer: net.minecraft.client.font.TextRenderer, stack: net.minecraft.item.ItemStack, x: number, y: number, stackCountText: string | null | undefined): void;
            drawTooltip(text: net.minecraft.text.Text, x: number, y: number): void;
            drawTooltip(text: Array<net.minecraft.text.OrderedText>, x: number, y: number): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.Text>, data: java.util.Optional<unknown>, x: number, y: number): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.Text>, data: java.util.Optional<unknown>, x: number, y: number, texture: net.minecraft.util.Identifier | null | undefined): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, x: number, y: number): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: net.minecraft.text.Text, x: number, y: number, texture: net.minecraft.util.Identifier | null | undefined): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.Text>, x: number, y: number): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.Text>, x: number, y: number, texture: net.minecraft.util.Identifier | null | undefined): void;
            drawTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.OrderedText>, positioner: net.minecraft.client.gui.tooltip.TooltipPositioner, x: number, y: number, focused: boolean): void;
            drawItemTooltip(textRenderer: net.minecraft.client.font.TextRenderer, stack: net.minecraft.item.ItemStack, x: number, y: number): void;
            drawOrderedTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.OrderedText>, x: number, y: number): void;
            drawOrderedTooltip(textRenderer: net.minecraft.client.font.TextRenderer, text: Array<net.minecraft.text.OrderedText>, x: number, y: number, texture: net.minecraft.util.Identifier | null | undefined): void;
            drawTooltipImmediately(textRenderer: net.minecraft.client.font.TextRenderer, components: Array<unknown>, x: number, y: number, positioner: net.minecraft.client.gui.tooltip.TooltipPositioner, texture: net.minecraft.util.Identifier | null | undefined): void;
            drawDeferredElements(): void;
            drawHoverEvent(textRenderer: net.minecraft.client.font.TextRenderer, style: net.minecraft.text.Style | null | undefined, x: number, y: number): void;
            drawMap(mapState: net.minecraft.client.render.MapRenderState): void;
            addEntity(entityState: net.minecraft.client.render.entity.state.EntityRenderState, scale: number, translation: org.joml.Vector3f, rotation: org.joml.Quaternionf, overrideCameraAngle: org.joml.Quaternionf | null | undefined, x1: number, y1: number, x2: number, y2: number): void;
            addPlayerSkin(playerModel: net.minecraft.client.render.entity.model.PlayerEntityModel, texture: net.minecraft.util.Identifier, scale: number, xRotation: number, yRotation: number, yPivot: number, x1: number, y1: number, x2: number, y2: number): void;
            addBookModel(bookModel: net.minecraft.client.render.entity.model.BookModel, texture: net.minecraft.util.Identifier, scale: number, open: number, flip: number, x1: number, y1: number, x2: number, y2: number): void;
            addBannerResult(bannerModel: net.minecraft.client.render.block.entity.model.BannerFlagBlockModel, baseColor: net.minecraft.util.DyeColor, resultBannerPatterns: net.minecraft.component.type.BannerPatternsComponent, x1: number, y1: number, x2: number, y2: number): void;
            addSign(model: net.minecraft.client.model.Model$SinglePartModel, scale: number, woodType: net.minecraft.block.WoodType, x1: number, y1: number, x2: number, y2: number): void;
            addProfilerChart(chartData: Array<unknown>, x1: number, y1: number, x2: number, y2: number): void;
            getSprite(id: net.minecraft.client.util.SpriteIdentifier): net.minecraft.client.texture.Sprite;
          }
          interface DrawContext$ScissorStack { 
            push(rect: net.minecraft.client.gui.ScreenRect): net.minecraft.client.gui.ScreenRect;
            pop(): net.minecraft.client.gui.ScreenRect | null | undefined;
            peekLast(): net.minecraft.client.gui.ScreenRect | null | undefined;
            contains(x: number, y: number): boolean;
          }
          interface Narratable { 
            appendNarrations(builder: net.minecraft.client.gui.screen.narration.NarrationMessageBuilder): void;
          }
          const Selectable: {
            SelectionType: typeof net.minecraft.client.gui.Selectable$SelectionType;
          }
          interface Selectable extends net.minecraft.client.gui.navigation.Navigable, net.minecraft.client.gui.Narratable { 
            getType(): net.minecraft.client.gui.Selectable$SelectionType;
            isInteractable(): boolean;
            getNarratedParts(): Array<net.minecraft.client.gui.Selectable>;
          }
          const Selectable$SelectionType: {
            NONE: net.minecraft.client.gui.Selectable$SelectionType;
            HOVERED: net.minecraft.client.gui.Selectable$SelectionType;
            FOCUSED: net.minecraft.client.gui.Selectable$SelectionType;
            valueOf(value: string): net.minecraft.client.gui.Selectable$SelectionType;
            values(): Array<net.minecraft.client.gui.Selectable$SelectionType>;
          }
          interface Selectable$SelectionType extends kotlin.Enum<net.minecraft.client.gui.Selectable$SelectionType> { 
            isFocused(): boolean;
          }
          const RotatingCubeMapRenderer: {
            OVERLAY_TEXTURE: net.minecraft.util.Identifier;
            new(cubeMap: net.minecraft.client.gui.CubeMapRenderer): net.minecraft.client.gui.RotatingCubeMapRenderer;
          }
          interface RotatingCubeMapRenderer { 
            render(context: net.minecraft.client.gui.DrawContext, width: number, height: number, rotate: boolean): void;
            registerTextures(textureManager: net.minecraft.client.texture.TextureManager): void;
          }
          const CubeMapRenderer: {
            new(id: net.minecraft.util.Identifier): net.minecraft.client.gui.CubeMapRenderer;
          }
          interface CubeMapRenderer extends java.lang.AutoCloseable { 
            draw(client: net.minecraft.client.MinecraftClient, x: number, y: number): void;
            registerTextures(textureManager: net.minecraft.client.texture.TextureManager): void;
          }
        }
        namespace gl {
          const Framebuffer: {
            new(name: string | null | undefined, useDepthAttachment: boolean): net.minecraft.client.gl.Framebuffer;
          }
          interface Framebuffer { 
            textureWidth: number;
            textureHeight: number;
            useDepthAttachment: boolean;
            filterMode: com.mojang.blaze3d.textures.FilterMode;
            resize(width: number, height: number): void;
            copyDepthFrom(framebuffer: net.minecraft.client.gl.Framebuffer): void;
            initFbo(width: number, height: number): void;
            setFilter(filter: com.mojang.blaze3d.textures.FilterMode): void;
            blitToScreen(): void;
            drawBlit(texture: com.mojang.blaze3d.textures.GpuTextureView): void;
            getColorAttachment(): com.mojang.blaze3d.textures.GpuTexture | null | undefined;
            getColorAttachmentView(): com.mojang.blaze3d.textures.GpuTextureView | null | undefined;
            getDepthAttachment(): com.mojang.blaze3d.textures.GpuTexture | null | undefined;
            getDepthAttachmentView(): com.mojang.blaze3d.textures.GpuTextureView | null | undefined;
          }
          const UniformType: {
            UNIFORM_BUFFER: net.minecraft.client.gl.UniformType;
            TEXEL_BUFFER: net.minecraft.client.gl.UniformType;
            valueOf(value: string): net.minecraft.client.gl.UniformType;
            values(): Array<net.minecraft.client.gl.UniformType>;
          }
          interface UniformType extends kotlin.Enum<net.minecraft.client.gl.UniformType> { 
          }
          const Defines: {
            Builder: typeof net.minecraft.client.gl.Defines$Builder;
            EMPTY: net.minecraft.client.gl.Defines;
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.Defines>;
            builder(): net.minecraft.client.gl.Defines$Builder;
            new(map: Map<string, string>, set: Set<string>): net.minecraft.client.gl.Defines;
          }
          interface Defines extends java.lang.Record { 
            withMerged(other: net.minecraft.client.gl.Defines): net.minecraft.client.gl.Defines;
            toSource(): string;
            isEmpty(): boolean;
            values(): Map<string, string>;
            flags(): Set<string>;
          }
          interface Defines$Builder { 
            define(key: string, value: string): net.minecraft.client.gl.Defines$Builder;
            define(key: string, value: number): net.minecraft.client.gl.Defines$Builder;
            define(name: string, value: number): net.minecraft.client.gl.Defines$Builder;
            flag(flag: string): net.minecraft.client.gl.Defines$Builder;
            build(): net.minecraft.client.gl.Defines;
          }
          const ShaderLoader: {
            Definitions: typeof net.minecraft.client.gl.ShaderLoader$Definitions;
            LoadException: typeof net.minecraft.client.gl.ShaderLoader$LoadException;
            field_53936: number;
            SHADERS_PATH: string;
            new(textureManager: net.minecraft.client.texture.TextureManager, onError: unknown): net.minecraft.client.gl.ShaderLoader;
          }
          interface ShaderLoader extends net.minecraft.resource.SinglePreparationResourceReloader<net.minecraft.client.gl.ShaderLoader$Definitions>, java.lang.AutoCloseable { 
            loadPostEffect(id: net.minecraft.util.Identifier, availableExternalTargets: Set<net.minecraft.util.Identifier>): net.minecraft.client.gl.PostEffectProcessor | null | undefined;
            getSource(id: net.minecraft.util.Identifier, type: com.mojang.blaze3d.shaders.ShaderType): string;
          }
          const ShaderLoader$Definitions: {
            EMPTY: net.minecraft.client.gl.ShaderLoader$Definitions;
            new(map: Map<unknown, string>, map2: Map<net.minecraft.util.Identifier, net.minecraft.client.gl.PostEffectPipeline>): net.minecraft.client.gl.ShaderLoader$Definitions;
          }
          interface ShaderLoader$Definitions extends java.lang.Record { 
            shaderSources(): Map<unknown, string>;
            postChains(): Map<net.minecraft.util.Identifier, net.minecraft.client.gl.PostEffectPipeline>;
          }
          const ShaderLoader$LoadException: {
            new(message: string): net.minecraft.client.gl.ShaderLoader$LoadException;
          }
          interface ShaderLoader$LoadException extends java.lang.Exception { 
          }
          const PostEffectProcessor: {
            MAIN: net.minecraft.util.Identifier;
            parseEffect(pipeline: net.minecraft.client.gl.PostEffectPipeline, textureManager: net.minecraft.client.texture.TextureManager, availableExternalTargets: Set<net.minecraft.util.Identifier>, id: net.minecraft.util.Identifier, projectionMatrix: net.minecraft.client.render.ProjectionMatrix2): net.minecraft.client.gl.PostEffectProcessor;
          }
          interface PostEffectProcessor extends java.lang.AutoCloseable { 
            render(builder: net.minecraft.client.render.FrameGraphBuilder, textureWidth: number, textureHeight: number, framebufferSet: net.minecraft.client.gl.PostEffectProcessor$FramebufferSet): void;
            render(framebuffer: net.minecraft.client.gl.Framebuffer, objectAllocator: net.minecraft.client.util.ObjectAllocator): void;
          }
          const PostEffectProcessor$FramebufferSet: {
            singleton(id: net.minecraft.util.Identifier, framebuffer: net.minecraft.client.util.Handle<net.minecraft.client.gl.Framebuffer>): net.minecraft.client.gl.PostEffectProcessor$FramebufferSet;
          }
          interface PostEffectProcessor$FramebufferSet { 
            set(id: net.minecraft.util.Identifier, framebuffer: net.minecraft.client.util.Handle<net.minecraft.client.gl.Framebuffer>): void;
            get(id: net.minecraft.util.Identifier): net.minecraft.client.util.Handle<net.minecraft.client.gl.Framebuffer> | null | undefined;
            getOrThrow(id: net.minecraft.util.Identifier): net.minecraft.client.util.Handle<net.minecraft.client.gl.Framebuffer>;
          }
          const PostEffectPipeline: {
            TextureSampler: typeof net.minecraft.client.gl.PostEffectPipeline$TextureSampler;
            Pass: typeof net.minecraft.client.gl.PostEffectPipeline$Pass;
            TargetSampler: typeof net.minecraft.client.gl.PostEffectPipeline$TargetSampler;
            Targets: typeof net.minecraft.client.gl.PostEffectPipeline$Targets;
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline>;
            new(map: Map<net.minecraft.util.Identifier, net.minecraft.client.gl.PostEffectPipeline$Targets>, list: Array<net.minecraft.client.gl.PostEffectPipeline$Pass>): net.minecraft.client.gl.PostEffectPipeline;
          }
          interface PostEffectPipeline extends java.lang.Record { 
            internalTargets(): Map<net.minecraft.util.Identifier, net.minecraft.client.gl.PostEffectPipeline$Targets>;
            passes(): Array<net.minecraft.client.gl.PostEffectPipeline$Pass>;
          }
          const PostEffectPipeline$TextureSampler: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline$TextureSampler>;
            new(string: string, identifier: net.minecraft.util.Identifier, i: number, j: number, bl: boolean): net.minecraft.client.gl.PostEffectPipeline$TextureSampler;
          }
          interface PostEffectPipeline$TextureSampler extends java.lang.Record, net.minecraft.client.gl.PostEffectPipeline$Input { 
            location(): net.minecraft.util.Identifier;
            width(): number;
            height(): number;
            bilinear(): boolean;
          }
          const PostEffectPipeline$Input: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline$Input>;
          }
          interface PostEffectPipeline$Input { 
            samplerName(): string;
            getTargetId(): Set<net.minecraft.util.Identifier>;
          }
          const PostEffectPipeline$Pass: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline$Pass>;
            new(identifier: net.minecraft.util.Identifier, identifier2: net.minecraft.util.Identifier, list: Array<net.minecraft.client.gl.PostEffectPipeline$Input>, identifier3: net.minecraft.util.Identifier, map: Map<string, Array<unknown>>): net.minecraft.client.gl.PostEffectPipeline$Pass;
          }
          interface PostEffectPipeline$Pass extends java.lang.Record { 
            streamTargets(): java.util.stream.Stream<net.minecraft.util.Identifier>;
            vertexShaderId(): net.minecraft.util.Identifier;
            fragmentShaderId(): net.minecraft.util.Identifier;
            inputs(): Array<net.minecraft.client.gl.PostEffectPipeline$Input>;
            outputTarget(): net.minecraft.util.Identifier;
            uniforms(): Map<string, Array<unknown>>;
          }
          const PostEffectPipeline$TargetSampler: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline$TargetSampler>;
            new(string: string, identifier: net.minecraft.util.Identifier, bl: boolean, bl2: boolean): net.minecraft.client.gl.PostEffectPipeline$TargetSampler;
          }
          interface PostEffectPipeline$TargetSampler extends java.lang.Record, net.minecraft.client.gl.PostEffectPipeline$Input { 
            targetId(): net.minecraft.util.Identifier;
            useDepthBuffer(): boolean;
            bilinear(): boolean;
          }
          const PostEffectPipeline$Targets: {
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.gl.PostEffectPipeline$Targets>;
            new(optional: java.util.Optional<number>, optional2: java.util.Optional<number>, bl: boolean, i: number): net.minecraft.client.gl.PostEffectPipeline$Targets;
          }
          interface PostEffectPipeline$Targets extends java.lang.Record { 
            width(): java.util.Optional<number>;
            height(): java.util.Optional<number>;
            persistent(): boolean;
            clearColor(): number;
          }
          const GlobalSettings: {
            SIZE: number;
            new(): net.minecraft.client.gl.GlobalSettings;
          }
          interface GlobalSettings extends java.lang.AutoCloseable { 
            set(width: number, height: number, glintStrength: number, time: number, tickCounter: net.minecraft.client.render.RenderTickCounter, menuBackgroundBlurriness: number): void;
          }
        }
        namespace texture {
          const TextureSetup: {
            withoutGlTexture(texture: com.mojang.blaze3d.textures.GpuTextureView): net.minecraft.client.texture.TextureSetup;
            of(texture: com.mojang.blaze3d.textures.GpuTextureView): net.minecraft.client.texture.TextureSetup;
            of(texture0: com.mojang.blaze3d.textures.GpuTextureView, texture1: com.mojang.blaze3d.textures.GpuTextureView): net.minecraft.client.texture.TextureSetup;
            empty(): net.minecraft.client.texture.TextureSetup;
            shuffleRenderingOrder(): void;
            new(gpuTextureView: com.mojang.blaze3d.textures.GpuTextureView | null | undefined, gpuTextureView2: com.mojang.blaze3d.textures.GpuTextureView | null | undefined, gpuTextureView3: com.mojang.blaze3d.textures.GpuTextureView | null | undefined): net.minecraft.client.texture.TextureSetup;
          }
          interface TextureSetup extends java.lang.Record { 
            getSortKey(): number;
            texure0(): com.mojang.blaze3d.textures.GpuTextureView | null | undefined;
            texure1(): com.mojang.blaze3d.textures.GpuTextureView | null | undefined;
            texure2(): com.mojang.blaze3d.textures.GpuTextureView | null | undefined;
          }
          interface Sprite { 
            getX(): number;
            getY(): number;
            getMinU(): number;
            getMaxU(): number;
            getContents(): net.minecraft.client.texture.SpriteContents;
            createAnimation(): net.minecraft.client.texture.Sprite$TickableAnimation | null | undefined;
            getFrameU(frame: number): number;
            getFrameFromU(u: number): number;
            getMinV(): number;
            getMaxV(): number;
            getFrameV(frame: number): number;
            getFrameFromV(v: number): number;
            getAtlasId(): net.minecraft.util.Identifier;
            upload(texture: com.mojang.blaze3d.textures.GpuTexture): void;
            getUvScaleDelta(): number;
            getTextureSpecificVertexConsumer(consumer: net.minecraft.client.render.VertexConsumer): net.minecraft.client.render.VertexConsumer;
          }
          interface Sprite$TickableAnimation extends java.lang.AutoCloseable { 
            tick(texture: com.mojang.blaze3d.textures.GpuTexture): void;
          }
          const SpriteContents: {
            new(id: net.minecraft.util.Identifier, dimensions: net.minecraft.client.texture.SpriteDimensions, image: net.minecraft.client.texture.NativeImage): net.minecraft.client.texture.SpriteContents;
            new(id: net.minecraft.util.Identifier, dimensions: net.minecraft.client.texture.SpriteDimensions, image: net.minecraft.client.texture.NativeImage, animationResourceMetadata: java.util.Optional<unknown>, additionalMetadata: Array<net.minecraft.resource.metadata.ResourceMetadataSerializer$Value<any>>): net.minecraft.client.texture.SpriteContents;
          }
          interface SpriteContents extends net.minecraft.client.texture.TextureStitcher$Stitchable, java.lang.AutoCloseable { 
            generateMipmaps(mipmapLevels: number): void;
            isAnimated(): boolean;
            upload(x: number, y: number, texture: com.mojang.blaze3d.textures.GpuTexture): void;
            getDistinctFrameCount(): java.util.stream.IntStream;
            createAnimator(): net.minecraft.client.texture.Animator | null | undefined;
            getAdditionalMetadataValue<T>(serializer: net.minecraft.resource.metadata.ResourceMetadataSerializer<T>): java.util.Optional<T>;
            isPixelTransparent(frame: number, x: number, y: number): boolean;
          }
          interface TextureStitcher$Stitchable { 
            getWidth(): number;
            getHeight(): number;
            getId(): net.minecraft.util.Identifier;
          }
          interface Animator extends java.lang.AutoCloseable { 
            tick(x: number, y: number, texture: com.mojang.blaze3d.textures.GpuTexture): void;
          }
          const SpriteDimensions: {
            new(i: number, j: number): net.minecraft.client.texture.SpriteDimensions;
          }
          interface SpriteDimensions extends java.lang.Record { 
            width(): number;
            height(): number;
          }
          const NativeImage: {
            Format: typeof net.minecraft.client.texture.NativeImage$Format;
            read(stream: java.io.InputStream): net.minecraft.client.texture.NativeImage;
            read(format: net.minecraft.client.texture.NativeImage$Format | null | undefined, stream: java.io.InputStream): net.minecraft.client.texture.NativeImage;
            read(buffer: java.nio.ByteBuffer): net.minecraft.client.texture.NativeImage;
            read(bytes: Array<number>): net.minecraft.client.texture.NativeImage;
            read(format: net.minecraft.client.texture.NativeImage$Format | null | undefined, buffer: java.nio.ByteBuffer): net.minecraft.client.texture.NativeImage;
            new(width: number, height: number, useStb: boolean): net.minecraft.client.texture.NativeImage;
            new(format: net.minecraft.client.texture.NativeImage$Format, width: number, height: number, useStb: boolean): net.minecraft.client.texture.NativeImage;
            new(format: net.minecraft.client.texture.NativeImage$Format, width: number, height: number, useStb: boolean, pointer: number): net.minecraft.client.texture.NativeImage;
          }
          interface NativeImage extends java.lang.AutoCloseable { 
            getWidth(): number;
            getHeight(): number;
            getFormat(): net.minecraft.client.texture.NativeImage$Format;
            getColorArgb(x: number, y: number): number;
            setColor(x: number, y: number, color: number): void;
            setColorArgb(x: number, y: number, color: number): void;
            applyToCopy(operator: unknown): net.minecraft.client.texture.NativeImage;
            copyPixelsAbgr(): Array<number>;
            copyPixelsArgb(): Array<number>;
            getOpacity(x: number, y: number): number;
            makePixelArray(): Array<number>;
            writeTo(path: java.io.File): void;
            writeTo(path: java.nio.file.Path): void;
            makeGlyphBitmapSubpixel(face: org.lwjgl.util.freetype.FT_Face, glyphIndex: number): boolean;
            copyFrom(image: net.minecraft.client.texture.NativeImage): void;
            fillRect(x: number, y: number, width: number, height: number, color: number): void;
            copyRect(x: number, y: number, translateX: number, translateY: number, width: number, height: number, flipX: boolean, flipY: boolean): void;
            copyRect(image: net.minecraft.client.texture.NativeImage, x: number, y: number, destX: number, destY: number, width: number, height: number, flipX: boolean, flipY: boolean): void;
            resizeSubRectTo(x: number, y: number, width: number, height: number, targetImage: net.minecraft.client.texture.NativeImage): void;
            untrack(): void;
            imageId(): number;
          }
          const NativeImage$Format: {
            RGBA: net.minecraft.client.texture.NativeImage$Format;
            RGB: net.minecraft.client.texture.NativeImage$Format;
            LUMINANCE_ALPHA: net.minecraft.client.texture.NativeImage$Format;
            LUMINANCE: net.minecraft.client.texture.NativeImage$Format;
            valueOf(value: string): net.minecraft.client.texture.NativeImage$Format;
            values(): Array<net.minecraft.client.texture.NativeImage$Format>;
          }
          interface NativeImage$Format extends kotlin.Enum<net.minecraft.client.texture.NativeImage$Format> { 
            getChannelCount(): number;
            hasRed(): boolean;
            hasGreen(): boolean;
            hasBlue(): boolean;
            hasLuminance(): boolean;
            hasAlpha(): boolean;
            getRedOffset(): number;
            getGreenOffset(): number;
            getBlueOffset(): number;
            getLuminanceOffset(): number;
            getAlphaOffset(): number;
            hasRedChannel(): boolean;
            hasGreenChannel(): boolean;
            hasBlueChannel(): boolean;
            hasOpacityChannel(): boolean;
            getRedChannelOffset(): number;
            getGreenChannelOffset(): number;
            getBlueChannelOffset(): number;
            getOpacityChannelOffset(): number;
            isWriteable(): boolean;
          }
          interface SpriteHolder { 
            getSprite(id: net.minecraft.client.util.SpriteIdentifier): net.minecraft.client.texture.Sprite;
          }
          const PlayerSkinCache: {
            Entry: typeof net.minecraft.client.texture.PlayerSkinCache$Entry;
            DEFAULT_RENDER_LAYER: net.minecraft.client.render.RenderLayer;
            TIME_TO_LIVE: java.time.Duration;
            new(textureManager: net.minecraft.client.texture.TextureManager, playerSkinProvider: net.minecraft.client.texture.PlayerSkinProvider, gameProfileResolver: net.minecraft.server.GameProfileResolver): net.minecraft.client.texture.PlayerSkinCache;
          }
          interface PlayerSkinCache { 
            get(profile: net.minecraft.component.type.ProfileComponent): net.minecraft.client.texture.PlayerSkinCache$Entry;
            getSupplier(profile: net.minecraft.component.type.ProfileComponent): unknown;
            getFuture(profile: net.minecraft.component.type.ProfileComponent): java.util.concurrent.CompletableFuture<java.util.Optional<net.minecraft.client.texture.PlayerSkinCache$Entry>>;
          }
          const PlayerSkinCache$Entry: {
            new(profile: com.mojang.authlib.GameProfile, textures: net.minecraft.entity.player.SkinTextures, skinOverride: net.minecraft.entity.player.SkinTextures$SkinOverride): net.minecraft.client.texture.PlayerSkinCache$Entry;
          }
          interface PlayerSkinCache$Entry { 
            getProfile(): com.mojang.authlib.GameProfile;
            getTextures(): net.minecraft.entity.player.SkinTextures;
            getRenderLayer(): net.minecraft.client.render.RenderLayer;
            getTextureView(): com.mojang.blaze3d.textures.GpuTextureView;
            getTextRenderLayers(): net.minecraft.client.font.TextRenderLayerSet;
          }
          const TextureManager: {
            MISSING_IDENTIFIER: net.minecraft.util.Identifier;
            new(resourceManager: net.minecraft.resource.ResourceManager): net.minecraft.client.texture.TextureManager;
          }
          interface TextureManager extends net.minecraft.resource.ResourceReloader, net.minecraft.client.texture.TextureTickListener, java.lang.AutoCloseable { 
            registerTexture(id: net.minecraft.util.Identifier, texture: net.minecraft.client.texture.ReloadableTexture): void;
            registerTexture(id: net.minecraft.util.Identifier): void;
            registerTexture(id: net.minecraft.util.Identifier, texture: net.minecraft.client.texture.AbstractTexture): void;
            getTexture(id: net.minecraft.util.Identifier): net.minecraft.client.texture.AbstractTexture;
            destroyTexture(id: net.minecraft.util.Identifier): void;
            dumpDynamicTextures(path: java.nio.file.Path): void;
          }
          interface TextureTickListener { 
            tick(): void;
          }
          const ReloadableTexture: {
            new(textureId: net.minecraft.util.Identifier): net.minecraft.client.texture.ReloadableTexture;
          }
          interface ReloadableTexture extends net.minecraft.client.texture.AbstractTexture { 
            getId(): net.minecraft.util.Identifier;
            reload(contents: net.minecraft.client.texture.TextureContents): void;
            loadContents(resourceManager: net.minecraft.resource.ResourceManager): net.minecraft.client.texture.TextureContents;
          }
          const AbstractTexture: {
            new(): net.minecraft.client.texture.AbstractTexture;
          }
          interface AbstractTexture extends java.lang.AutoCloseable { 
            setClamp(clamp: boolean): void;
            setFilter(bilinear: boolean, mipmap: boolean): void;
            setUseMipmaps(useMipmaps: boolean): void;
            getGlTexture(): com.mojang.blaze3d.textures.GpuTexture;
            getGlTextureView(): com.mojang.blaze3d.textures.GpuTextureView;
          }
          const TextureContents: {
            load(resourceManager: net.minecraft.resource.ResourceManager, textureId: net.minecraft.util.Identifier): net.minecraft.client.texture.TextureContents;
            createMissing(): net.minecraft.client.texture.TextureContents;
            new(nativeImage: net.minecraft.client.texture.NativeImage, textureResourceMetadata: net.minecraft.client.resource.metadata.TextureResourceMetadata | null | undefined): net.minecraft.client.texture.TextureContents;
          }
          interface TextureContents extends java.lang.Record, java.io.Closeable { 
            blur(): boolean;
            clamp(): boolean;
            image(): net.minecraft.client.texture.NativeImage;
            metadata(): net.minecraft.client.resource.metadata.TextureResourceMetadata | null | undefined;
          }
          const PlayerSkinProvider: {
            new(cacheDirectory: java.nio.file.Path, apiServices: net.minecraft.util.ApiServices, downloader: net.minecraft.client.texture.PlayerSkinTextureDownloader, executor: java.util.concurrent.Executor): net.minecraft.client.texture.PlayerSkinProvider;
          }
          interface PlayerSkinProvider { 
            supplySkinTextures(profile: com.mojang.authlib.GameProfile, requireSecure: boolean): unknown;
            fetchSkinTextures(profile: com.mojang.authlib.GameProfile): java.util.concurrent.CompletableFuture<java.util.Optional<net.minecraft.entity.player.SkinTextures>>;
          }
          const PlayerSkinTextureDownloader: {
            new(proxy: java.net.Proxy, textureManager: net.minecraft.client.texture.TextureManager, executor: java.util.concurrent.Executor): net.minecraft.client.texture.PlayerSkinTextureDownloader;
          }
          interface PlayerSkinTextureDownloader { 
            downloadAndRegisterTexture(id: net.minecraft.util.Identifier, path: java.nio.file.Path, string: string, remap: boolean): java.util.concurrent.CompletableFuture<net.minecraft.util.AssetInfo$TextureAsset>;
          }
          const SpriteAtlasTexture: {
            BLOCK_ATLAS_TEXTURE: net.minecraft.util.Identifier;
            PARTICLE_ATLAS_TEXTURE: net.minecraft.util.Identifier;
            new(id: net.minecraft.util.Identifier): net.minecraft.client.texture.SpriteAtlasTexture;
          }
          interface SpriteAtlasTexture extends net.minecraft.client.texture.AbstractTexture, net.minecraft.client.texture.DynamicTexture, net.minecraft.client.texture.TextureTickListener, net.fabricmc.fabric.api.renderer.v1.sprite.FabricSpriteAtlasTexture { 
            upload(stitchResult: net.minecraft.client.texture.SpriteLoader$StitchResult): void;
            tickAnimatedSprites(): void;
            getSprite(id: net.minecraft.util.Identifier): net.minecraft.client.texture.Sprite;
            getMissingSprite(): net.minecraft.client.texture.Sprite;
            clear(): void;
            getId(): net.minecraft.util.Identifier;
            getMaxTextureSize(): number;
          }
          interface DynamicTexture { 
            save(id: net.minecraft.util.Identifier, path: java.nio.file.Path): void;
          }
          const SpriteLoader$StitchResult: {
            new(i: number, j: number, k: number, sprite: net.minecraft.client.texture.Sprite, map: Map<net.minecraft.util.Identifier, net.minecraft.client.texture.Sprite>, completableFuture: java.util.concurrent.CompletableFuture<java.lang.Void>): net.minecraft.client.texture.SpriteLoader$StitchResult;
          }
          interface SpriteLoader$StitchResult extends java.lang.Record, net.fabricmc.fabric.api.renderer.v1.sprite.FabricStitchResult { 
            getSprite(id: net.minecraft.util.Identifier): net.minecraft.client.texture.Sprite | null | undefined;
            width(): number;
            height(): number;
            mipLevel(): number;
            missing(): net.minecraft.client.texture.Sprite;
            sprites(): Map<net.minecraft.util.Identifier, net.minecraft.client.texture.Sprite>;
            readyForUpload(): java.util.concurrent.CompletableFuture<java.lang.Void>;
          }
          const AtlasManager: {
            Stitch: typeof net.minecraft.client.texture.AtlasManager$Stitch;
            Metadata: typeof net.minecraft.client.texture.AtlasManager$Metadata;
            stitchKey: net.minecraft.resource.ResourceReloader$Key<net.minecraft.client.texture.AtlasManager$Stitch>;
            new(textureManager: net.minecraft.client.texture.TextureManager, mipmapLevels: number): net.minecraft.client.texture.AtlasManager;
          }
          interface AtlasManager extends net.minecraft.resource.ResourceReloader, net.minecraft.client.texture.SpriteHolder, java.lang.AutoCloseable { 
            getAtlasTexture(id: net.minecraft.util.Identifier): net.minecraft.client.texture.SpriteAtlasTexture;
            acceptAtlasTextures(consumer: unknown): void;
            setMipmapLevels(mipmapLevels: number): void;
          }
          interface AtlasManager$Stitch { 
            createSpriteMap(): Map<net.minecraft.client.util.SpriteIdentifier, net.minecraft.client.texture.Sprite>;
            getPreparations(atlasTextureId: net.minecraft.util.Identifier): java.util.concurrent.CompletableFuture<net.minecraft.client.texture.SpriteLoader$StitchResult>;
          }
          const AtlasManager$Metadata: {
            new(textureId: net.minecraft.util.Identifier, definitionId: net.minecraft.util.Identifier, createMipmaps: boolean): net.minecraft.client.texture.AtlasManager$Metadata;
            new(identifier: net.minecraft.util.Identifier, identifier2: net.minecraft.util.Identifier, bl: boolean, set: Set<net.minecraft.resource.metadata.ResourceMetadataSerializer<any>>): net.minecraft.client.texture.AtlasManager$Metadata;
          }
          interface AtlasManager$Metadata extends java.lang.Record { 
            textureId(): net.minecraft.util.Identifier;
            definitionId(): net.minecraft.util.Identifier;
            createMipmaps(): boolean;
            additionalMetadata(): Set<net.minecraft.resource.metadata.ResourceMetadataSerializer<any>>;
          }
          const MapTextureManager: {
            new(textureManager: net.minecraft.client.texture.TextureManager): net.minecraft.client.texture.MapTextureManager;
          }
          interface MapTextureManager extends java.lang.AutoCloseable { 
            setNeedsUpdate(mapIdComponent: net.minecraft.component.type.MapIdComponent, mapState: net.minecraft.item.map.MapState): void;
            getTextureId(mapIdComponent: net.minecraft.component.type.MapIdComponent, mapState: net.minecraft.item.map.MapState): net.minecraft.util.Identifier;
            clear(): void;
          }
          const NativeImageBackedTexture: {
            new(nameSupplier: unknown, image: net.minecraft.client.texture.NativeImage): net.minecraft.client.texture.NativeImageBackedTexture;
            new(name: string, width: number, height: number, useStb: boolean): net.minecraft.client.texture.NativeImageBackedTexture;
            new(nameSupplier: unknown, width: number, height: number, useStb: boolean): net.minecraft.client.texture.NativeImageBackedTexture;
          }
          interface NativeImageBackedTexture extends net.minecraft.client.texture.AbstractTexture, net.minecraft.client.texture.DynamicTexture { 
            upload(): void;
            getImage(): net.minecraft.client.texture.NativeImage | null | undefined;
            setImage(image: net.minecraft.client.texture.NativeImage): void;
          }
        }
        namespace font {
          const TextRenderer: {
            TextLayerType: typeof net.minecraft.client.font.TextRenderer$TextLayerType;
            FORWARD_SHIFT: number;
            field_55090: number;
            new(fonts: net.minecraft.client.font.TextRenderer$GlyphsProvider): net.minecraft.client.font.TextRenderer;
          }
          interface TextRenderer { 
            fontHeight: number;
            mirror(text: string): string;
            draw(string: string, x: number, y: number, color: number, shadow: boolean, matrix: org.joml.Matrix4f, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, layerType: net.minecraft.client.font.TextRenderer$TextLayerType, backgroundColor: number, light: number): void;
            draw(text: net.minecraft.text.Text, x: number, y: number, color: number, shadow: boolean, matrix: org.joml.Matrix4f, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, layerType: net.minecraft.client.font.TextRenderer$TextLayerType, backgroundColor: number, light: number): void;
            draw(text: net.minecraft.text.OrderedText, x: number, y: number, color: number, shadow: boolean, matrix: org.joml.Matrix4f, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, layerType: net.minecraft.client.font.TextRenderer$TextLayerType, backgroundColor: number, light: number): void;
            drawWithOutline(text: net.minecraft.text.OrderedText, x: number, y: number, color: number, outlineColor: number, matrix: org.joml.Matrix4f, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, light: number): void;
            prepare(string: string, x: number, y: number, color: number, shadow: boolean, backgroundColor: number): net.minecraft.client.font.TextRenderer$GlyphDrawable;
            prepare(text: net.minecraft.text.OrderedText, x: number, y: number, color: number, shadow: boolean, backgroundColor: number): net.minecraft.client.font.TextRenderer$GlyphDrawable;
            getWidth(text: string): number;
            getWidth(text: net.minecraft.text.StringVisitable): number;
            getWidth(text: net.minecraft.text.OrderedText): number;
            trimToWidth(text: string, maxWidth: number, backwards: boolean): string;
            trimToWidth(text: string, maxWidth: number): string;
            trimToWidth(text: net.minecraft.text.StringVisitable, width: number): net.minecraft.text.StringVisitable;
            getWrappedLinesHeight(text: string, maxWidth: number): number;
            getWrappedLinesHeight(text: net.minecraft.text.StringVisitable, maxWidth: number): number;
            wrapLines(text: net.minecraft.text.StringVisitable, width: number): Array<net.minecraft.text.OrderedText>;
            wrapLinesWithoutLanguage(text: net.minecraft.text.StringVisitable, width: number): Array<net.minecraft.text.StringVisitable>;
            isRightToLeft(): boolean;
            getTextHandler(): net.minecraft.client.font.TextHandler;
          }
          const TextRenderer$TextLayerType: {
            NORMAL: net.minecraft.client.font.TextRenderer$TextLayerType;
            SEE_THROUGH: net.minecraft.client.font.TextRenderer$TextLayerType;
            POLYGON_OFFSET: net.minecraft.client.font.TextRenderer$TextLayerType;
            valueOf(value: string): net.minecraft.client.font.TextRenderer$TextLayerType;
            values(): Array<net.minecraft.client.font.TextRenderer$TextLayerType>;
          }
          interface TextRenderer$TextLayerType extends kotlin.Enum<net.minecraft.client.font.TextRenderer$TextLayerType> { 
          }
          interface TextRenderer$GlyphsProvider { 
            getGlyphs(source: net.minecraft.text.StyleSpriteSource): net.minecraft.client.font.GlyphProvider;
            getRectangleGlyph(): net.minecraft.client.font.EffectGlyph;
          }
          interface GlyphProvider { 
            get(codePoint: number): net.minecraft.client.font.BakedGlyph;
            getObfuscated(random: net.minecraft.util.math.random.Random, width: number): net.minecraft.client.font.BakedGlyph;
          }
          interface BakedGlyph { 
            getMetrics(): net.minecraft.client.font.GlyphMetrics;
            create(x: number, y: number, color: number, shadowColor: number, style: net.minecraft.text.Style, boldOffset: number, shadowOffset: number): net.minecraft.client.font.TextDrawable | null | undefined;
          }
          const GlyphMetrics: {
            empty(advance: number): net.minecraft.client.font.GlyphMetrics;
          }
          interface GlyphMetrics { 
            getAdvance(): number;
            getAdvance(bold: boolean): number;
            getBoldOffset(): number;
            getShadowOffset(): number;
          }
          interface TextDrawable { 
            render(matrix4f: org.joml.Matrix4f, consumer: net.minecraft.client.render.VertexConsumer, light: number, noDepth: boolean): void;
            getRenderLayer(type: net.minecraft.client.font.TextRenderer$TextLayerType): net.minecraft.client.render.RenderLayer;
            textureView(): com.mojang.blaze3d.textures.GpuTextureView;
            getPipeline(): com.mojang.blaze3d.pipeline.RenderPipeline;
            getEffectiveMinX(): number;
            getEffectiveMinY(): number;
            getEffectiveMaxX(): number;
            getEffectiveMaxY(): number;
          }
          interface EffectGlyph { 
            create(minX: number, minY: number, maxX: number, maxY: number, depth: number, color: number, shadowColor: number, shadowOffset: number): net.minecraft.client.font.TextDrawable;
          }
          interface TextRenderer$GlyphDrawable { 
            draw(glyphDrawer: net.minecraft.client.font.TextRenderer$GlyphDrawer): void;
            getScreenRect(): net.minecraft.client.gui.ScreenRect | null | undefined;
          }
          const TextRenderer$GlyphDrawer: {
            drawing(vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, matrix: org.joml.Matrix4f, layerType: net.minecraft.client.font.TextRenderer$TextLayerType, light: number): net.minecraft.client.font.TextRenderer$GlyphDrawer;
          }
          interface TextRenderer$GlyphDrawer { 
            drawGlyph(glyph: net.minecraft.client.font.TextDrawable): void;
            drawRectangle(bakedGlyph: net.minecraft.client.font.TextDrawable): void;
          }
          const TextHandler: {
            moveCursorByWords(text: string, offset: number, cursor: number, consumeSpaceOrBreak: boolean): number;
            new(widthRetriever: net.minecraft.client.font.TextHandler$WidthRetriever): net.minecraft.client.font.TextHandler;
          }
          interface TextHandler { 
            getWidth(text: string | null | undefined): number;
            getWidth(text: net.minecraft.text.StringVisitable): number;
            getWidth(text: net.minecraft.text.OrderedText): number;
            getTrimmedLength(text: string, maxWidth: number, style: net.minecraft.text.Style): number;
            trimToWidth(text: string, maxWidth: number, style: net.minecraft.text.Style): string;
            trimToWidth(text: net.minecraft.text.StringVisitable, width: number, style: net.minecraft.text.Style): net.minecraft.text.StringVisitable;
            trimToWidthBackwards(text: string, maxWidth: number, style: net.minecraft.text.Style): string;
            getLimitedStringLength(text: string, maxWidth: number, style: net.minecraft.text.Style): number;
            getStyleAt(text: net.minecraft.text.StringVisitable, x: number): net.minecraft.text.Style | null | undefined;
            getStyleAt(text: net.minecraft.text.OrderedText, x: number): net.minecraft.text.Style | null | undefined;
            limitString(text: string, maxWidth: number, style: net.minecraft.text.Style): string;
            getEndingIndex(text: string, maxWidth: number, style: net.minecraft.text.Style): number;
            wrapLines(text: string, maxWidth: number, style: net.minecraft.text.Style, retainTrailingWordSplit: boolean, consumer: net.minecraft.client.font.TextHandler$LineWrappingConsumer): void;
            wrapLines(text: string, maxWidth: number, style: net.minecraft.text.Style): Array<net.minecraft.text.StringVisitable>;
            wrapLines(text: net.minecraft.text.StringVisitable, maxWidth: number, style: net.minecraft.text.Style): Array<net.minecraft.text.StringVisitable>;
            wrapLines(text: net.minecraft.text.StringVisitable, maxWidth: number, style: net.minecraft.text.Style, wrappedLinePrefix: net.minecraft.text.StringVisitable): Array<net.minecraft.text.StringVisitable>;
            wrapLines(text: net.minecraft.text.StringVisitable, maxWidth: number, style: net.minecraft.text.Style, lineConsumer: unknown): void;
          }
          interface TextHandler$LineWrappingConsumer { 
            accept(style: net.minecraft.text.Style, start: number, end: number): void;
            (style: net.minecraft.text.Style, start: number, end: number): void;
          }
          interface TextHandler$WidthRetriever { 
            getWidth(codePoint: number, style: net.minecraft.text.Style): number;
            (codePoint: number, style: net.minecraft.text.Style): number;
          }
          const TextRenderLayerSet: {
            ofIntensity(textureId: net.minecraft.util.Identifier): net.minecraft.client.font.TextRenderLayerSet;
            of(textureId: net.minecraft.util.Identifier): net.minecraft.client.font.TextRenderLayerSet;
            new(renderLayer: net.minecraft.client.render.RenderLayer, renderLayer2: net.minecraft.client.render.RenderLayer, renderLayer3: net.minecraft.client.render.RenderLayer, renderPipeline: com.mojang.blaze3d.pipeline.RenderPipeline): net.minecraft.client.font.TextRenderLayerSet;
          }
          interface TextRenderLayerSet extends java.lang.Record { 
            getRenderLayer(layerType: net.minecraft.client.font.TextRenderer$TextLayerType): net.minecraft.client.render.RenderLayer;
            normal(): net.minecraft.client.render.RenderLayer;
            seeThrough(): net.minecraft.client.render.RenderLayer;
            polygonOffset(): net.minecraft.client.render.RenderLayer;
            guiPipeline(): com.mojang.blaze3d.pipeline.RenderPipeline;
          }
        }
        namespace render {
          namespace model {
            namespace json {
              const Transformation: {
                IDENTITY: net.minecraft.client.render.model.json.Transformation;
                new(vector3fc: org.joml.Vector3fc, vector3fc2: org.joml.Vector3fc, vector3fc3: org.joml.Vector3fc): net.minecraft.client.render.model.json.Transformation;
              }
              interface Transformation extends java.lang.Record { 
                apply(leftHanded: boolean, entry: net.minecraft.client.util.math.MatrixStack$Entry): void;
                rotation(): org.joml.Vector3fc;
                translation(): org.joml.Vector3fc;
                scale(): org.joml.Vector3fc;
              }
              const ModelTransformation: {
                NONE: net.minecraft.client.render.model.json.ModelTransformation;
                new(thirdPersonLeftHand: net.minecraft.client.render.model.json.Transformation, thirdPersonRightHand: net.minecraft.client.render.model.json.Transformation, firstPersonLeftHand: net.minecraft.client.render.model.json.Transformation, firstPersonRightHand: net.minecraft.client.render.model.json.Transformation, head: net.minecraft.client.render.model.json.Transformation, gui: net.minecraft.client.render.model.json.Transformation, ground: net.minecraft.client.render.model.json.Transformation, fixed: net.minecraft.client.render.model.json.Transformation, transformation: net.minecraft.client.render.model.json.Transformation): net.minecraft.client.render.model.json.ModelTransformation;
              }
              interface ModelTransformation extends java.lang.Record { 
                getTransformation(renderMode: net.minecraft.item.ItemDisplayContext): net.minecraft.client.render.model.json.Transformation;
                thirdPersonLeftHand(): net.minecraft.client.render.model.json.Transformation;
                thirdPersonRightHand(): net.minecraft.client.render.model.json.Transformation;
                firstPersonLeftHand(): net.minecraft.client.render.model.json.Transformation;
                firstPersonRightHand(): net.minecraft.client.render.model.json.Transformation;
                head(): net.minecraft.client.render.model.json.Transformation;
                gui(): net.minecraft.client.render.model.json.Transformation;
                ground(): net.minecraft.client.render.model.json.Transformation;
                fixed(): net.minecraft.client.render.model.json.Transformation;
                fixedFromBottom(): net.minecraft.client.render.model.json.Transformation;
              }
            }
            const BakedQuad: {
              new(vertexData: Array<number>, tintIndex: number, face: net.minecraft.util.math.Direction, sprite: net.minecraft.client.texture.Sprite, shade: boolean, lightEmission: number): net.minecraft.client.render.model.BakedQuad;
            }
            interface BakedQuad extends java.lang.Record { 
              hasTint(): boolean;
              vertexData(): Array<number>;
              tintIndex(): number;
              face(): net.minecraft.util.math.Direction;
              sprite(): net.minecraft.client.texture.Sprite;
              shade(): boolean;
              lightEmission(): number;
            }
            const BlockStateModel: {
              CachedUnbaked: typeof net.minecraft.client.render.model.BlockStateModel$CachedUnbaked;
            }
            interface BlockStateModel extends net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel { 
              particleSprite(): net.minecraft.client.texture.Sprite;
              addParts(random: net.minecraft.util.math.random.Random, parts: Array<unknown>): void;
              getParts(random: net.minecraft.util.math.random.Random): Array<unknown>;
            }
            const BlockStateModel$Unbaked: {
              WEIGHTED_VARIANT_CODEC: com.mojang.serialization.Codec<net.minecraft.util.collection.Weighted<unknown>>;
              WEIGHTED_CODEC: com.mojang.serialization.Codec<unknown>;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.render.model.BlockStateModel$Unbaked>;
            }
            interface BlockStateModel$Unbaked extends net.minecraft.client.render.model.ResolvableModel { 
              bake(baker: net.minecraft.client.render.model.Baker): net.minecraft.client.render.model.BlockStateModel;
              cached(): net.minecraft.client.render.model.BlockStateModel$UnbakedGrouped;
            }
            interface ResolvableModel { 
              resolve(resolver: net.minecraft.client.render.model.ResolvableModel$Resolver): void;
            }
            interface ResolvableModel$Resolver { 
              markDependency(id: net.minecraft.util.Identifier): void;
            }
            interface Baker { 
              getModel(id: net.minecraft.util.Identifier): net.minecraft.client.render.model.BakedSimpleModel;
              getSpriteGetter(): net.minecraft.client.render.model.ErrorCollectingSpriteGetter;
              compute<T>(key: net.minecraft.client.render.model.Baker$ResolvableCacheKey<T>): T;
            }
            interface Baker$ResolvableCacheKey<T> { 
              compute(baker: net.minecraft.client.render.model.Baker): T;
              (baker: net.minecraft.client.render.model.Baker): T;
            }
            const BakedSimpleModel: {
              DEFAULT_AMBIENT_OCCLUSION: boolean;
              DEFAULT_GUI_LIGHT: net.minecraft.client.render.model.UnbakedModel$GuiLight;
              getTextures(model: net.minecraft.client.render.model.BakedSimpleModel): net.minecraft.client.render.model.ModelTextures;
              getAmbientOcclusion(model: net.minecraft.client.render.model.BakedSimpleModel): boolean;
              getGuiLight(model: net.minecraft.client.render.model.BakedSimpleModel): net.minecraft.client.render.model.UnbakedModel$GuiLight;
              getGeometry(model: net.minecraft.client.render.model.BakedSimpleModel): net.minecraft.client.render.model.Geometry;
              getParticleTexture(textures: net.minecraft.client.render.model.ModelTextures, baker: net.minecraft.client.render.model.Baker, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.texture.Sprite;
              extractTransformation(model: net.minecraft.client.render.model.BakedSimpleModel, mode: net.minecraft.item.ItemDisplayContext): net.minecraft.client.render.model.json.Transformation;
              copyTransformations(model: net.minecraft.client.render.model.BakedSimpleModel): net.minecraft.client.render.model.json.ModelTransformation;
            }
            interface BakedSimpleModel extends net.minecraft.client.render.model.SimpleModel { 
              getModel(): net.minecraft.client.render.model.UnbakedModel;
              getParent(): net.minecraft.client.render.model.BakedSimpleModel | null | undefined;
              getTextures(): net.minecraft.client.render.model.ModelTextures;
              getAmbientOcclusion(): boolean;
              getGuiLight(): net.minecraft.client.render.model.UnbakedModel$GuiLight;
              getGeometry(): net.minecraft.client.render.model.Geometry;
              bakeGeometry(textures: net.minecraft.client.render.model.ModelTextures, baker: net.minecraft.client.render.model.Baker, settings: net.minecraft.client.render.model.ModelBakeSettings): net.minecraft.client.render.model.BakedGeometry;
              getParticleTexture(textures: net.minecraft.client.render.model.ModelTextures, baker: net.minecraft.client.render.model.Baker): net.minecraft.client.texture.Sprite;
              getTransformations(): net.minecraft.client.render.model.json.ModelTransformation;
            }
            interface SimpleModel { 
              name(): string;
              (): string;
            }
            const UnbakedModel: {
              GuiLight: typeof net.minecraft.client.render.model.UnbakedModel$GuiLight;
              PARTICLE_TEXTURE: string;
            }
            interface UnbakedModel { 
              ambientOcclusion(): boolean | null | undefined;
              guiLight(): net.minecraft.client.render.model.UnbakedModel$GuiLight | null | undefined;
              transformations(): net.minecraft.client.render.model.json.ModelTransformation | null | undefined;
              textures(): net.minecraft.client.render.model.ModelTextures$Textures;
              geometry(): net.minecraft.client.render.model.Geometry | null | undefined;
              parent(): net.minecraft.util.Identifier | null | undefined;
            }
            const UnbakedModel$GuiLight: {
              ITEM: net.minecraft.client.render.model.UnbakedModel$GuiLight;
              BLOCK: net.minecraft.client.render.model.UnbakedModel$GuiLight;
              byName(value: string): net.minecraft.client.render.model.UnbakedModel$GuiLight;
              valueOf(value: string): net.minecraft.client.render.model.UnbakedModel$GuiLight;
              values(): Array<net.minecraft.client.render.model.UnbakedModel$GuiLight>;
            }
            interface UnbakedModel$GuiLight extends kotlin.Enum<net.minecraft.client.render.model.UnbakedModel$GuiLight> { 
              isSide(): boolean;
            }
            const ModelTextures$Textures: {
              Builder: typeof net.minecraft.client.render.model.ModelTextures.ModelTextures$Textures$Builder;
              EMPTY: net.minecraft.client.render.model.ModelTextures$Textures;
              new(map: Map<string, net.minecraft.client.render.model.ModelTextures$Entry>): net.minecraft.client.render.model.ModelTextures$Textures;
            }
            interface ModelTextures$Textures extends java.lang.Record { 
              values(): Map<string, net.minecraft.client.render.model.ModelTextures$Entry>;
            }
            const ModelTextures$Textures$Builder: {
              new(): unknown;
            }
            interface ModelTextures$Textures$Builder { 
              addTextureReference(textureId: string, target: string): unknown;
              addSprite(textureId: string, spriteId: net.minecraft.client.util.SpriteIdentifier): unknown;
              build(): net.minecraft.client.render.model.ModelTextures$Textures;
            }
            const Geometry: {
              EMPTY: net.minecraft.client.render.model.Geometry;
            }
            interface Geometry { 
              bake(textures: net.minecraft.client.render.model.ModelTextures, baker: net.minecraft.client.render.model.Baker, settings: net.minecraft.client.render.model.ModelBakeSettings, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.render.model.BakedGeometry;
              (textures: net.minecraft.client.render.model.ModelTextures, baker: net.minecraft.client.render.model.Baker, settings: net.minecraft.client.render.model.ModelBakeSettings, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.render.model.BakedGeometry;
            }
            const ModelTextures: {
              Builder: typeof net.minecraft.client.render.model.ModelTextures$Builder;
              Textures: typeof net.minecraft.client.render.model.ModelTextures$Textures;
              EMPTY: net.minecraft.client.render.model.ModelTextures;
              fromJson(json: com.google.gson.JsonObject, atlasTexture: net.minecraft.util.Identifier): net.minecraft.client.render.model.ModelTextures$Textures;
            }
            interface ModelTextures { 
              get(textureId: string): net.minecraft.client.util.SpriteIdentifier | null | undefined;
            }
            const ModelTextures$Builder: {
              new(): net.minecraft.client.render.model.ModelTextures$Builder;
            }
            interface ModelTextures$Builder { 
              addLast(textures: net.minecraft.client.render.model.ModelTextures$Textures): net.minecraft.client.render.model.ModelTextures$Builder;
              addFirst(textures: net.minecraft.client.render.model.ModelTextures$Textures): net.minecraft.client.render.model.ModelTextures$Builder;
              build(modelNameSupplier: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.render.model.ModelTextures;
            }
            interface ModelTextures$Entry { 
            }
            const ModelBakeSettings: {
              TRANSFORM_NONE: org.joml.Matrix4fc;
            }
            interface ModelBakeSettings { 
              getRotation(): net.minecraft.util.math.AffineTransformation;
              forward(facing: net.minecraft.util.math.Direction): org.joml.Matrix4fc;
              reverse(facing: net.minecraft.util.math.Direction): org.joml.Matrix4fc;
            }
            const BakedGeometry: {
              Builder: typeof net.minecraft.client.render.model.BakedGeometry$Builder;
              EMPTY: net.minecraft.client.render.model.BakedGeometry;
            }
            interface BakedGeometry { 
              getQuads(side: net.minecraft.util.math.Direction | null | undefined): Array<net.minecraft.client.render.model.BakedQuad>;
              getAllQuads(): Array<net.minecraft.client.render.model.BakedQuad>;
            }
            const BakedGeometry$Builder: {
              new(): net.minecraft.client.render.model.BakedGeometry$Builder;
            }
            interface BakedGeometry$Builder { 
              add(side: net.minecraft.util.math.Direction, quad: net.minecraft.client.render.model.BakedQuad): net.minecraft.client.render.model.BakedGeometry$Builder;
              add(quad: net.minecraft.client.render.model.BakedQuad): net.minecraft.client.render.model.BakedGeometry$Builder;
              build(): net.minecraft.client.render.model.BakedGeometry;
            }
            interface ErrorCollectingSpriteGetter extends net.fabricmc.fabric.api.renderer.v1.sprite.FabricErrorCollectingSpriteGetter { 
              get(id: net.minecraft.client.util.SpriteIdentifier, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.texture.Sprite;
              get(texture: net.minecraft.client.render.model.ModelTextures, name: string, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.texture.Sprite;
              getMissing(name: string, model: net.minecraft.client.render.model.SimpleModel): net.minecraft.client.texture.Sprite;
            }
            interface BlockStateModel$UnbakedGrouped extends net.minecraft.client.render.model.ResolvableModel { 
              bake(state: net.minecraft.block.BlockState, baker: net.minecraft.client.render.model.Baker): net.minecraft.client.render.model.BlockStateModel;
              getEqualityGroup(state: net.minecraft.block.BlockState): any;
            }
            const BlockStateModel$CachedUnbaked: {
              new(delegate: net.minecraft.client.render.model.BlockStateModel$Unbaked): net.minecraft.client.render.model.BlockStateModel$CachedUnbaked;
            }
            interface BlockStateModel$CachedUnbaked extends net.minecraft.client.render.model.BlockStateModel$UnbakedGrouped { 
            }
            const BakedModelManager: {
              new(blockColors: net.minecraft.client.color.block.BlockColors, atlasManager: net.minecraft.client.texture.AtlasManager, playerSkinCache: net.minecraft.client.texture.PlayerSkinCache): net.minecraft.client.render.model.BakedModelManager;
            }
            interface BakedModelManager extends net.minecraft.resource.ResourceReloader, net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager { 
              getMissingModel(): net.minecraft.client.render.model.BlockStateModel;
              getItemModel(id: net.minecraft.util.Identifier): net.minecraft.client.render.item.model.ItemModel;
              getItemProperties(id: net.minecraft.util.Identifier): net.minecraft.client.item.ItemAsset$Properties;
              getBlockModels(): net.minecraft.client.render.block.BlockModels;
              shouldRerender(from: net.minecraft.block.BlockState, to: net.minecraft.block.BlockState): boolean;
              getBlockEntityModelsSupplier(): unknown;
              getEntityModelsSupplier(): unknown;
            }
          }
          namespace entity {
            namespace state {
              const EntityRenderState: {
                ShadowPiece: typeof net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece;
                LeashData: typeof net.minecraft.client.render.entity.state.EntityRenderState$LeashData;
                NO_OUTLINE: number;
                new(): net.minecraft.client.render.entity.state.EntityRenderState;
              }
              interface EntityRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
                entityType: net.minecraft.entity.EntityType<any>;
                x: number;
                y: number;
                z: number;
                age: number;
                width: number;
                height: number;
                standingEyeHeight: number;
                squaredDistanceToCamera: number;
                invisible: boolean;
                sneaking: boolean;
                onFire: boolean;
                light: number;
                outlineColor: number;
                positionOffset: net.minecraft.util.math.Vec3d | null | undefined;
                displayName: net.minecraft.text.Text | null | undefined;
                nameLabelPos: net.minecraft.util.math.Vec3d | null | undefined;
                leashDatas: Array<net.minecraft.client.render.entity.state.EntityRenderState$LeashData> | null | undefined;
                hitbox: net.minecraft.client.render.entity.state.EntityHitboxAndView | null | undefined;
                debugInfo: net.minecraft.client.render.entity.state.EntityDebugInfo | null | undefined;
                shadowRadius: number;
                shadowPieces: Array<net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece>;
                hasOutline(): boolean;
                addCrashReportDetails(crashReportSection: net.minecraft.util.crash.CrashReportSection): void;
              }
              const EntityRenderState$ShadowPiece: {
                new(f: number, g: number, h: number, voxelShape: net.minecraft.util.shape.VoxelShape, i: number): net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece;
              }
              interface EntityRenderState$ShadowPiece extends java.lang.Record { 
                relativeX(): number;
                relativeY(): number;
                relativeZ(): number;
                shapeBelow(): net.minecraft.util.shape.VoxelShape;
                alpha(): number;
              }
              const EntityRenderState$LeashData: {
                new(): net.minecraft.client.render.entity.state.EntityRenderState$LeashData;
              }
              interface EntityRenderState$LeashData { 
                offset: net.minecraft.util.math.Vec3d;
                startPos: net.minecraft.util.math.Vec3d;
                endPos: net.minecraft.util.math.Vec3d;
                leashedEntityBlockLight: number;
                leashHolderBlockLight: number;
                leashedEntitySkyLight: number;
                leashHolderSkyLight: number;
                slack: boolean;
              }
              const EntityHitboxAndView: {
                new(d: number, e: number, f: number, immutableList: com.google.common.collect.ImmutableList<unknown>): net.minecraft.client.render.entity.state.EntityHitboxAndView;
              }
              interface EntityHitboxAndView extends java.lang.Record { 
                viewX(): number;
                viewY(): number;
                viewZ(): number;
                hitboxes(): com.google.common.collect.ImmutableList<unknown>;
              }
              const EntityDebugInfo: {
                new(missing: boolean): net.minecraft.client.render.entity.state.EntityDebugInfo;
                new(bl: boolean, d: number, e: number, f: number, g: number, h: number, i: number, j: number, entityHitboxAndView: net.minecraft.client.render.entity.state.EntityHitboxAndView | null | undefined): net.minecraft.client.render.entity.state.EntityDebugInfo;
              }
              interface EntityDebugInfo extends java.lang.Record { 
                missing(): boolean;
                serverEntityX(): number;
                serverEntityY(): number;
                serverEntityZ(): number;
                deltaMovementX(): number;
                deltaMovementY(): number;
                deltaMovementZ(): number;
                eyeHeight(): number;
                hitboxes(): net.minecraft.client.render.entity.state.EntityHitboxAndView | null | undefined;
              }
              const BipedEntityRenderState: {
                new(): net.minecraft.client.render.entity.state.BipedEntityRenderState;
              }
              interface BipedEntityRenderState extends net.minecraft.client.render.entity.state.ArmedEntityRenderState { 
                leaningPitch: number;
                handSwingProgress: number;
                limbAmplitudeInverse: number;
                crossbowPullTime: number;
                itemUseTime: number;
                preferredArm: net.minecraft.util.Arm;
                activeHand: net.minecraft.util.Hand;
                isInSneakingPose: boolean;
                isGliding: boolean;
                isSwimming: boolean;
                hasVehicle: boolean;
                isUsingItem: boolean;
                leftWingPitch: number;
                leftWingYaw: number;
                leftWingRoll: number;
                equippedHeadStack: net.minecraft.item.ItemStack;
                equippedChestStack: net.minecraft.item.ItemStack;
                equippedLegsStack: net.minecraft.item.ItemStack;
                equippedFeetStack: net.minecraft.item.ItemStack;
              }
              const ArmedEntityRenderState: {
                updateRenderState(entity: net.minecraft.entity.LivingEntity, state: net.minecraft.client.render.entity.state.ArmedEntityRenderState, itemModelManager: net.minecraft.client.item.ItemModelManager): void;
                new(): net.minecraft.client.render.entity.state.ArmedEntityRenderState;
              }
              interface ArmedEntityRenderState extends net.minecraft.client.render.entity.state.LivingEntityRenderState { 
                mainArm: net.minecraft.util.Arm;
                rightArmPose: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                rightHandItemState: net.minecraft.client.render.item.ItemRenderState;
                leftArmPose: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                leftHandItemState: net.minecraft.client.render.item.ItemRenderState;
                getMainHandItemState(): net.minecraft.client.render.item.ItemRenderState;
              }
              const LivingEntityRenderState: {
                new(): net.minecraft.client.render.entity.state.LivingEntityRenderState;
              }
              interface LivingEntityRenderState extends net.minecraft.client.render.entity.state.EntityRenderState { 
                bodyYaw: number;
                relativeHeadYaw: number;
                pitch: number;
                deathTime: number;
                limbSwingAnimationProgress: number;
                limbSwingAmplitude: number;
                baseScale: number;
                ageScale: number;
                flipUpsideDown: boolean;
                shaking: boolean;
                baby: boolean;
                touchingWater: boolean;
                usingRiptide: boolean;
                hurt: boolean;
                invisibleToPlayer: boolean;
                sleepingDirection: net.minecraft.util.math.Direction | null | undefined;
                pose: net.minecraft.entity.EntityPose;
                headItemRenderState: net.minecraft.client.render.item.ItemRenderState;
                headItemAnimationProgress: number;
                wearingSkullType: net.minecraft.block.SkullBlock$SkullType | null | undefined;
                wearingSkullProfile: net.minecraft.component.type.ProfileComponent | null | undefined;
                isInPose(pose: net.minecraft.entity.EntityPose): boolean;
              }
              const PlayerEntityRenderState: {
                new(): net.minecraft.client.render.entity.state.PlayerEntityRenderState;
              }
              interface PlayerEntityRenderState extends net.minecraft.client.render.entity.state.BipedEntityRenderState { 
                skinTextures: net.minecraft.entity.player.SkinTextures;
                field_53536: number;
                field_53537: number;
                field_53538: number;
                stuckArrowCount: number;
                stingerCount: number;
                spectator: boolean;
                hatVisible: boolean;
                jacketVisible: boolean;
                leftPantsLegVisible: boolean;
                rightPantsLegVisible: boolean;
                leftSleeveVisible: boolean;
                rightSleeveVisible: boolean;
                capeVisible: boolean;
                glidingTicks: number;
                applyFlyingRotation: boolean;
                flyingRotation: number;
                playerName: net.minecraft.text.Text | null | undefined;
                leftShoulderParrotVariant: net.minecraft.entity.passive.ParrotEntity$Variant | null | undefined;
                rightShoulderParrotVariant: net.minecraft.entity.passive.ParrotEntity$Variant | null | undefined;
                id: number;
                extraEars: boolean;
                spyglassState: net.minecraft.client.render.item.ItemRenderState;
                getGlidingProgress(): number;
              }
            }
            namespace model {
              const PlayerEntityModel: {
                getTexturedModelData(dilation: net.minecraft.client.model.Dilation, slim: boolean): net.minecraft.client.model.ModelData;
                createEquipmentModelData(hatDilation: net.minecraft.client.model.Dilation, armorDilation: net.minecraft.client.model.Dilation): net.minecraft.client.render.entity.model.EquipmentModelData<net.minecraft.client.model.ModelData>;
                new(root: net.minecraft.client.model.ModelPart, thinArms: boolean): net.minecraft.client.render.entity.model.PlayerEntityModel;
              }
              interface PlayerEntityModel extends net.minecraft.client.render.entity.model.BipedEntityModel<net.minecraft.client.render.entity.state.PlayerEntityRenderState> { 
                leftSleeve: net.minecraft.client.model.ModelPart;
                rightSleeve: net.minecraft.client.model.ModelPart;
                leftPants: net.minecraft.client.model.ModelPart;
                rightPants: net.minecraft.client.model.ModelPart;
                jacket: net.minecraft.client.model.ModelPart;
                setArmAngle(playerEntityRenderState: net.minecraft.client.render.entity.state.PlayerEntityRenderState, arm: net.minecraft.util.Arm, matrixStack: net.minecraft.client.util.math.MatrixStack): void;
                getRandomPart(random: net.minecraft.util.math.random.Random): net.minecraft.client.model.ModelPart;
              }
              const BipedEntityModel: {
                ArmPose: typeof net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                BABY_TRANSFORMER: net.minecraft.client.render.entity.model.ModelTransformer;
                field_32505: number;
                field_32506: number;
                field_42513: number;
                field_39069: number;
                field_39070: number;
                getModelData(dilation: net.minecraft.client.model.Dilation, pivotOffsetY: number): net.minecraft.client.model.ModelData;
                createEquipmentModelData(hatDilation: net.minecraft.client.model.Dilation, armorDilation: net.minecraft.client.model.Dilation): net.minecraft.client.render.entity.model.EquipmentModelData<net.minecraft.client.model.ModelData>;
                new<T>(modelPart: net.minecraft.client.model.ModelPart): net.minecraft.client.render.entity.model.BipedEntityModel<T>;
                new<T>(modelPart: net.minecraft.client.model.ModelPart, function_: unknown): net.minecraft.client.render.entity.model.BipedEntityModel<T>;
              }
              interface BipedEntityModel<T> extends net.minecraft.client.render.entity.model.EntityModel<T>, net.minecraft.client.render.entity.model.ModelWithArms<T>, net.minecraft.client.render.entity.model.ModelWithHead { 
                head: net.minecraft.client.model.ModelPart;
                hat: net.minecraft.client.model.ModelPart;
                body: net.minecraft.client.model.ModelPart;
                rightArm: net.minecraft.client.model.ModelPart;
                leftArm: net.minecraft.client.model.ModelPart;
                rightLeg: net.minecraft.client.model.ModelPart;
                leftLeg: net.minecraft.client.model.ModelPart;
                setVisible(visible: boolean): void;
              }
              const EntityModel: {
                field_52908: number;
              }
              interface EntityModel<T> extends net.minecraft.client.model.Model<T> { 
              }
              interface ModelWithArms<T> { 
                setArmAngle(state: T, arm: net.minecraft.util.Arm, matrices: net.minecraft.client.util.math.MatrixStack): void;
              }
              interface ModelWithHead { 
                getHead(): net.minecraft.client.model.ModelPart;
                applyTransform(matrices: net.minecraft.client.util.math.MatrixStack): void;
              }
              const BipedEntityModel$ArmPose: {
                EMPTY: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                ITEM: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                BLOCK: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                BOW_AND_ARROW: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                THROW_SPEAR: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                CROSSBOW_CHARGE: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                CROSSBOW_HOLD: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                SPYGLASS: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                TOOT_HORN: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                BRUSH: net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                valueOf(value: string): net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose;
                values(): Array<net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose>;
              }
              interface BipedEntityModel$ArmPose extends kotlin.Enum<net.minecraft.client.render.entity.model.BipedEntityModel$ArmPose> { 
                isTwoHanded(): boolean;
              }
              const LoadedEntityModels: {
                EMPTY: net.minecraft.client.render.entity.model.LoadedEntityModels;
                copy(): net.minecraft.client.render.entity.model.LoadedEntityModels;
                new(modelParts: Map<net.minecraft.client.render.entity.model.EntityModelLayer, net.minecraft.client.model.TexturedModelData>): net.minecraft.client.render.entity.model.LoadedEntityModels;
              }
              interface LoadedEntityModels { 
                getModelPart(layer: net.minecraft.client.render.entity.model.EntityModelLayer): net.minecraft.client.model.ModelPart;
              }
              const EntityModelLayer: {
                new(id: net.minecraft.util.Identifier, name: string): net.minecraft.client.render.entity.model.EntityModelLayer;
              }
              interface EntityModelLayer extends java.lang.Record { 
                id(): net.minecraft.util.Identifier;
                name(): string;
              }
              const ModelTransformer: {
                NO_OP: net.minecraft.client.render.entity.model.ModelTransformer;
                scaling(scale: number): net.minecraft.client.render.entity.model.ModelTransformer;
              }
              interface ModelTransformer { 
                apply(modelData: net.minecraft.client.model.ModelData): net.minecraft.client.model.ModelData;
                (modelData: net.minecraft.client.model.ModelData): net.minecraft.client.model.ModelData;
              }
              const EquipmentModelData: {
                mapToEntityModel<M>(data: net.minecraft.client.render.entity.model.EquipmentModelData<net.minecraft.client.render.entity.model.EntityModelLayer>, models: net.minecraft.client.render.entity.model.LoadedEntityModels, modelPartToModel: unknown): net.minecraft.client.render.entity.model.EquipmentModelData<M>;
                new<T>(object: T, object2: T, object3: T, object4: T): net.minecraft.client.render.entity.model.EquipmentModelData<T>;
              }
              interface EquipmentModelData<T> extends java.lang.Record { 
                getModelData(slot: net.minecraft.entity.EquipmentSlot): T;
                map<U>(f: unknown): net.minecraft.client.render.entity.model.EquipmentModelData<U>;
                addTo(texturedModelData: net.minecraft.client.render.entity.model.EquipmentModelData<net.minecraft.client.model.TexturedModelData>, builder: com.google.common.collect.ImmutableMap$Builder<T, net.minecraft.client.model.TexturedModelData>): void;
                head(): T;
                chest(): T;
                legs(): T;
                feet(): T;
              }
              const BookModel: {
                BookModelState: typeof net.minecraft.client.render.entity.model.BookModel$BookModelState;
                getTexturedModelData(): net.minecraft.client.model.TexturedModelData;
                new(root: net.minecraft.client.model.ModelPart): net.minecraft.client.render.entity.model.BookModel;
              }
              interface BookModel extends net.minecraft.client.model.Model<net.minecraft.client.render.entity.model.BookModel$BookModelState> { 
              }
              const BookModel$BookModelState: {
                new(f: number, g: number, h: number, i: number): net.minecraft.client.render.entity.model.BookModel$BookModelState;
              }
              interface BookModel$BookModelState extends java.lang.Record { 
                pageTurnAmount(): number;
                leftFlipAmount(): number;
                rightFlipAmount(): number;
                pageTurnSpeed(): number;
              }
            }
            namespace equipment {
              const EquipmentModelLoader: {
                EMPTY: net.minecraft.client.render.entity.equipment.EquipmentModel;
                new(): net.minecraft.client.render.entity.equipment.EquipmentModelLoader;
              }
              interface EquipmentModelLoader extends net.minecraft.resource.JsonDataLoader<net.minecraft.client.render.entity.equipment.EquipmentModel> { 
                get(assetKey: net.minecraft.registry.RegistryKey<unknown>): net.minecraft.client.render.entity.equipment.EquipmentModel;
              }
              const EquipmentModel: {
                Builder: typeof net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                Dyeable: typeof net.minecraft.client.render.entity.equipment.EquipmentModel$Dyeable;
                Layer: typeof net.minecraft.client.render.entity.equipment.EquipmentModel$Layer;
                LayerType: typeof net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                CODEC: com.mojang.serialization.Codec<net.minecraft.client.render.entity.equipment.EquipmentModel>;
                builder(): net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                new(map: Map<net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType, Array<net.minecraft.client.render.entity.equipment.EquipmentModel$Layer>>): net.minecraft.client.render.entity.equipment.EquipmentModel;
              }
              interface EquipmentModel extends java.lang.Record { 
                getLayers(layerType: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType): Array<net.minecraft.client.render.entity.equipment.EquipmentModel$Layer>;
                layers(): Map<net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType, Array<net.minecraft.client.render.entity.equipment.EquipmentModel$Layer>>;
              }
              interface EquipmentModel$Builder { 
                addHumanoidLayers(textureId: net.minecraft.util.Identifier): net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                addHumanoidLayers(textureId: net.minecraft.util.Identifier, dyeable: boolean): net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                addMainHumanoidLayer(textureId: net.minecraft.util.Identifier, dyeable: boolean): net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                addLayers(layerType: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType, layers: net.minecraft.client.render.entity.equipment.EquipmentModel$Layer): net.minecraft.client.render.entity.equipment.EquipmentModel$Builder;
                build(): net.minecraft.client.render.entity.equipment.EquipmentModel;
              }
              const EquipmentModel$LayerType: {
                HUMANOID: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                HUMANOID_LEGGINGS: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                WINGS: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                WOLF_BODY: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                HORSE_BODY: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                LLAMA_BODY: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                PIG_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                STRIDER_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                CAMEL_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                HORSE_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                DONKEY_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                MULE_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                ZOMBIE_HORSE_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                SKELETON_HORSE_SADDLE: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                HAPPY_GHAST_BODY: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                CODEC: com.mojang.serialization.Codec<net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType>;
                valueOf(value: string): net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType;
                values(): Array<net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType>;
              }
              interface EquipmentModel$LayerType extends kotlin.Enum<net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType>, net.minecraft.util.StringIdentifiable { 
                getTrimsDirectory(): string;
              }
              const EquipmentModel$Layer: {
                CODEC: com.mojang.serialization.Codec<net.minecraft.client.render.entity.equipment.EquipmentModel$Layer>;
                createWithLeatherColor(textureId: net.minecraft.util.Identifier, dyeable: boolean): net.minecraft.client.render.entity.equipment.EquipmentModel$Layer;
                create(textureId: net.minecraft.util.Identifier, dyeable: boolean): net.minecraft.client.render.entity.equipment.EquipmentModel$Layer;
                new(textureId: net.minecraft.util.Identifier): net.minecraft.client.render.entity.equipment.EquipmentModel$Layer;
                new(identifier: net.minecraft.util.Identifier, optional: java.util.Optional<net.minecraft.client.render.entity.equipment.EquipmentModel$Dyeable>, bl: boolean): net.minecraft.client.render.entity.equipment.EquipmentModel$Layer;
              }
              interface EquipmentModel$Layer extends java.lang.Record { 
                getFullTextureId(layerType: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType): net.minecraft.util.Identifier;
                textureId(): net.minecraft.util.Identifier;
                dyeable(): java.util.Optional<net.minecraft.client.render.entity.equipment.EquipmentModel$Dyeable>;
                usePlayerTexture(): boolean;
              }
              const EquipmentModel$Dyeable: {
                CODEC: com.mojang.serialization.Codec<net.minecraft.client.render.entity.equipment.EquipmentModel$Dyeable>;
                new(optional: java.util.Optional<number>): net.minecraft.client.render.entity.equipment.EquipmentModel$Dyeable;
              }
              interface EquipmentModel$Dyeable extends java.lang.Record { 
                colorWhenUndyed(): java.util.Optional<number>;
              }
              const EquipmentRenderer: {
                new(equipmentModelLoader: net.minecraft.client.render.entity.equipment.EquipmentModelLoader, armorTrimsAtlas: net.minecraft.client.texture.SpriteAtlasTexture): net.minecraft.client.render.entity.equipment.EquipmentRenderer;
              }
              interface EquipmentRenderer { 
                render<S>(layerType: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType, assetKey: net.minecraft.registry.RegistryKey<unknown>, model: net.minecraft.client.model.Model<S>, object: S, itemStack: net.minecraft.item.ItemStack, matrixStack: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue, i: number, j: number): void;
                render<S>(layerType: net.minecraft.client.render.entity.equipment.EquipmentModel$LayerType, assetKey: net.minecraft.registry.RegistryKey<unknown>, model: net.minecraft.client.model.Model<S>, object: S, itemStack: net.minecraft.item.ItemStack, matrixStack: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue, i: number, identifier: net.minecraft.util.Identifier | null | undefined, j: number, k: number): void;
              }
            }
            namespace feature {
              interface FeatureRendererContext<S, M> { 
                getModel(): M;
              }
              const FeatureRenderer: {
                new<S, M>(context: net.minecraft.client.render.entity.feature.FeatureRendererContext<S, M>): net.minecraft.client.render.entity.feature.FeatureRenderer<S, M>;
              }
              interface FeatureRenderer<S, M> { 
                getContextModel(): M;
                render(matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number, state: S, limbAngle: number, limbDistance: number): void;
              }
            }
            const EntityRenderManager: {
              new(client: net.minecraft.client.MinecraftClient, textureManager: net.minecraft.client.texture.TextureManager, itemModelManager: net.minecraft.client.item.ItemModelManager, itemRenderer: net.minecraft.client.render.item.ItemRenderer, mapRenderer: net.minecraft.client.render.MapRenderer, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager, atlasManager: net.minecraft.client.texture.AtlasManager, textRenderer: net.minecraft.client.font.TextRenderer, gameOptions: net.minecraft.client.option.GameOptions, entityModelsGetter: unknown, equipmentModelLoader: net.minecraft.client.render.entity.equipment.EquipmentModelLoader, skinCache: net.minecraft.client.texture.PlayerSkinCache): net.minecraft.client.render.entity.EntityRenderManager;
            }
            interface EntityRenderManager extends net.minecraft.resource.SynchronousResourceReloader { 
              textureManager: net.minecraft.client.texture.TextureManager;
              camera: net.minecraft.client.render.Camera | null | undefined;
              targetedEntity: net.minecraft.entity.Entity;
              gameOptions: net.minecraft.client.option.GameOptions;
              getLight<E>(entity: E, tickProgress: number): number;
              getRenderer<T>(entity: T): net.minecraft.client.render.entity.EntityRenderer<T, any>;
              getRenderer<S>(state: S): net.minecraft.client.render.entity.EntityRenderer<any, S>;
              getPlayerRenderer(player: net.minecraft.client.network.AbstractClientPlayerEntity): net.minecraft.client.render.entity.PlayerEntityRenderer<net.minecraft.client.network.AbstractClientPlayerEntity>;
              configure(camera: net.minecraft.client.render.Camera, targetedEntity: net.minecraft.entity.Entity): void;
              shouldRender<E>(entity: E, frustum: net.minecraft.client.render.Frustum, x: number, y: number, z: number): boolean;
              getAndUpdateRenderState<E>(entity: E, tickProgress: number): net.minecraft.client.render.entity.state.EntityRenderState;
              render<S>(renderState: S, cameraRenderState: net.minecraft.client.render.state.CameraRenderState, d: number, e: number, f: number, matrixStack: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue): void;
              clearCamera(): void;
              getSquaredDistanceToCamera(entity: net.minecraft.entity.Entity): number;
              getHeldItemRenderer(): net.minecraft.client.render.item.HeldItemRenderer;
            }
            const EntityRenderer: {
              field_32921: number;
            }
            interface EntityRenderer<T, S> { 
              getLight(entity: T, tickProgress: number): number;
              shouldRender(entity: T, frustum: net.minecraft.client.render.Frustum, x: number, y: number, z: number): boolean;
              getPositionOffset(state: S): net.minecraft.util.math.Vec3d;
              render(renderState: S, matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, cameraState: net.minecraft.client.render.state.CameraRenderState): void;
              getTextRenderer(): net.minecraft.client.font.TextRenderer;
              createRenderState(): S;
              getAndUpdateRenderState(entity: T, tickProgress: number): S;
              updateRenderState(entity: T, state: S, tickProgress: number): void;
            }
            const EntityRendererFactory$Context: {
              new(renderDispatcher: net.minecraft.client.render.entity.EntityRenderManager, itemRenderer: net.minecraft.client.item.ItemModelManager, mapRenderer: net.minecraft.client.render.MapRenderer, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager, resourceManager: net.minecraft.resource.ResourceManager, entityModels: net.minecraft.client.render.entity.model.LoadedEntityModels, equipmentModelLoader: net.minecraft.client.render.entity.equipment.EquipmentModelLoader, atlasManager: net.minecraft.client.texture.AtlasManager, textRenderer: net.minecraft.client.font.TextRenderer, playerSkinCache: net.minecraft.client.texture.PlayerSkinCache): net.minecraft.client.render.entity.EntityRendererFactory$Context;
            }
            interface EntityRendererFactory$Context { 
              getRenderDispatcher(): net.minecraft.client.render.entity.EntityRenderManager;
              getItemModelManager(): net.minecraft.client.item.ItemModelManager;
              getMapRenderer(): net.minecraft.client.render.MapRenderer;
              getBlockRenderManager(): net.minecraft.client.render.block.BlockRenderManager;
              getResourceManager(): net.minecraft.resource.ResourceManager;
              getEntityModels(): net.minecraft.client.render.entity.model.LoadedEntityModels;
              getEquipmentModelLoader(): net.minecraft.client.render.entity.equipment.EquipmentModelLoader;
              getEquipmentRenderer(): net.minecraft.client.render.entity.equipment.EquipmentRenderer;
              getSpriteHolder(): net.minecraft.client.texture.SpriteHolder;
              getSpriteAtlasTexture(id: net.minecraft.util.Identifier): net.minecraft.client.texture.SpriteAtlasTexture;
              getPart(layer: net.minecraft.client.render.entity.model.EntityModelLayer): net.minecraft.client.model.ModelPart;
              getTextRenderer(): net.minecraft.client.font.TextRenderer;
              getPlayerSkinCache(): net.minecraft.client.texture.PlayerSkinCache;
            }
            const PlayerEntityRenderer: {
              shouldFlipUpsideDown(player: net.minecraft.entity.player.PlayerEntity): boolean;
              new<AvatarlikeEntity>(ctx: net.minecraft.client.render.entity.EntityRendererFactory$Context, slim: boolean): net.minecraft.client.render.entity.PlayerEntityRenderer<AvatarlikeEntity>;
            }
            interface PlayerEntityRenderer<AvatarlikeEntity> extends net.minecraft.client.render.entity.LivingEntityRenderer<AvatarlikeEntity, net.minecraft.client.render.entity.state.PlayerEntityRenderState, net.minecraft.client.render.entity.model.PlayerEntityModel> { 
              renderRightArm(matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number, skinTexture: net.minecraft.util.Identifier, sleeveVisible: boolean): void;
              renderLeftArm(matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number, skinTexture: net.minecraft.util.Identifier, sleeveVisible: boolean): void;
            }
            const LivingEntityRenderer: {
              getOverlay(state: net.minecraft.client.render.entity.state.LivingEntityRenderState, whiteOverlayProgress: number): number;
              new<T, S, M>(ctx: net.minecraft.client.render.entity.EntityRendererFactory$Context, model: M, shadowRadius: number): net.minecraft.client.render.entity.LivingEntityRenderer<T, S, M>;
            }
            interface LivingEntityRenderer<T, S, M> extends net.minecraft.client.render.entity.EntityRenderer<T, S>, net.minecraft.client.render.entity.feature.FeatureRendererContext<S, M> { 
              getTexture(state: S): net.minecraft.util.Identifier;
              shouldFlipUpsideDown(entity: T): boolean;
            }
          }
          namespace item {
            namespace model {
              namespace special {
                interface SpecialModelRenderer<T> { 
                  render(data: T, displayContext: net.minecraft.item.ItemDisplayContext, matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number, overlay: number, glint: boolean, i: number): void;
                  collectVertices(vertices: Set<org.joml.Vector3f>): void;
                  getData(stack: net.minecraft.item.ItemStack): T;
                }
                const SpecialModelRenderer$BakeContext: {
                  Simple: typeof net.minecraft.client.render.item.model.special.SpecialModelRenderer.SpecialModelRenderer$BakeContext$Simple;
                }
                interface SpecialModelRenderer$BakeContext { 
                  entityModelSet(): net.minecraft.client.render.entity.model.LoadedEntityModels;
                  spriteHolder(): net.minecraft.client.texture.SpriteHolder;
                  playerSkinRenderCache(): net.minecraft.client.texture.PlayerSkinCache;
                }
                const SpecialModelRenderer$BakeContext$Simple: {
                  new(loadedEntityModels: net.minecraft.client.render.entity.model.LoadedEntityModels, spriteHolder: net.minecraft.client.texture.SpriteHolder, playerSkinCache: net.minecraft.client.texture.PlayerSkinCache): unknown;
                }
                interface SpecialModelRenderer$BakeContext$Simple extends java.lang.Record, net.minecraft.client.render.item.model.special.SpecialModelRenderer$BakeContext { 
                }
                interface SpecialModelRenderer$Unbaked { 
                  bake(context: net.minecraft.client.render.item.model.special.SpecialModelRenderer$BakeContext): net.minecraft.client.render.item.model.special.SpecialModelRenderer<any> | null | undefined;
                  getCodec(): com.mojang.serialization.MapCodec<net.minecraft.client.render.item.model.special.SpecialModelRenderer$Unbaked>;
                }
              }
              const ItemModel: {
                BakeContext: typeof net.minecraft.client.render.item.model.ItemModel$BakeContext;
              }
              interface ItemModel { 
                update(state: net.minecraft.client.render.item.ItemRenderState, stack: net.minecraft.item.ItemStack, resolver: net.minecraft.client.item.ItemModelManager, displayContext: net.minecraft.item.ItemDisplayContext, world: net.minecraft.client.world.ClientWorld | null | undefined, heldItemContext: net.minecraft.util.HeldItemContext | null | undefined, seed: number): void;
              }
              const ItemModel$BakeContext: {
                new(baker: net.minecraft.client.render.model.Baker, loadedEntityModels: net.minecraft.client.render.entity.model.LoadedEntityModels, spriteHolder: net.minecraft.client.texture.SpriteHolder, playerSkinCache: net.minecraft.client.texture.PlayerSkinCache, itemModel: net.minecraft.client.render.item.model.ItemModel, contextSwapper: net.minecraft.registry.ContextSwapper | null | undefined): net.minecraft.client.render.item.model.ItemModel$BakeContext;
              }
              interface ItemModel$BakeContext extends java.lang.Record, net.minecraft.client.render.item.model.special.SpecialModelRenderer$BakeContext { 
                blockModelBaker(): net.minecraft.client.render.model.Baker;
                missingItemModel(): net.minecraft.client.render.item.model.ItemModel;
                contextSwapper(): net.minecraft.registry.ContextSwapper | null | undefined;
              }
              interface ItemModel$Unbaked extends net.minecraft.client.render.model.ResolvableModel { 
                getCodec(): com.mojang.serialization.MapCodec<net.minecraft.client.render.item.model.ItemModel$Unbaked>;
                bake(context: net.minecraft.client.render.item.model.ItemModel$BakeContext): net.minecraft.client.render.item.model.ItemModel;
              }
            }
            const ItemRenderState: {
              Glint: typeof net.minecraft.client.render.item.ItemRenderState$Glint;
              LayerRenderState: typeof net.minecraft.client.render.item.ItemRenderState$LayerRenderState;
              new(): net.minecraft.client.render.item.ItemRenderState;
            }
            interface ItemRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              addLayers(add: number): void;
              newLayer(): net.minecraft.client.render.item.ItemRenderState$LayerRenderState;
              clear(): void;
              markAnimated(): void;
              isAnimated(): boolean;
              addModelKey(modelKey: any): void;
              isEmpty(): boolean;
              isSideLit(): boolean;
              getParticleSprite(random: net.minecraft.util.math.random.Random): net.minecraft.client.texture.Sprite | null | undefined;
              load(posConsumer: unknown): void;
              render(matrices: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number, overlay: number, i: number): void;
              getModelBoundingBox(): net.minecraft.util.math.Box;
              setOversizedInGui(oversizedInGui: boolean): void;
              isOversizedInGui(): boolean;
            }
            const ItemRenderState$Glint: {
              NONE: net.minecraft.client.render.item.ItemRenderState$Glint;
              STANDARD: net.minecraft.client.render.item.ItemRenderState$Glint;
              SPECIAL: net.minecraft.client.render.item.ItemRenderState$Glint;
              valueOf(value: string): net.minecraft.client.render.item.ItemRenderState$Glint;
              values(): Array<net.minecraft.client.render.item.ItemRenderState$Glint>;
            }
            interface ItemRenderState$Glint extends kotlin.Enum<net.minecraft.client.render.item.ItemRenderState$Glint> { 
            }
            const ItemRenderState$LayerRenderState: {
              DEFAULT: unknown;
              new(): net.minecraft.client.render.item.ItemRenderState$LayerRenderState;
            }
            interface ItemRenderState$LayerRenderState extends net.fabricmc.fabric.api.renderer.v1.render.FabricLayerRenderState, net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              clear(): void;
              getQuads(): Array<net.minecraft.client.render.model.BakedQuad>;
              setRenderLayer(layer: net.minecraft.client.render.RenderLayer): void;
              setUseLight(useLight: boolean): void;
              setVertices(vertices: unknown): void;
              setParticle(particle: net.minecraft.client.texture.Sprite): void;
              setTransform(transform: net.minecraft.client.render.model.json.Transformation): void;
              setSpecialModel<T>(specialModelType: net.minecraft.client.render.item.model.special.SpecialModelRenderer<T>, data: T): void;
              setGlint(glint: net.minecraft.client.render.item.ItemRenderState$Glint): void;
              initTints(maxIndex: number): Array<number>;
            }
            const HeldItemRenderer: {
              new(client: net.minecraft.client.MinecraftClient, entityRenderDispatcher: net.minecraft.client.render.entity.EntityRenderManager, itemRenderer: net.minecraft.client.render.item.ItemRenderer, itemModelManager: net.minecraft.client.item.ItemModelManager): net.minecraft.client.render.item.HeldItemRenderer;
            }
            interface HeldItemRenderer { 
              renderItem(entity: net.minecraft.entity.LivingEntity, stack: net.minecraft.item.ItemStack, renderMode: net.minecraft.item.ItemDisplayContext, matrices: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue, light: number): void;
              renderItem(tickProgress: number, matrices: net.minecraft.client.util.math.MatrixStack, orderedRenderCommandQueue: net.minecraft.client.render.command.OrderedRenderCommandQueue, player: net.minecraft.client.network.ClientPlayerEntity, light: number): void;
              updateHeldItems(): void;
              resetEquipProgress(hand: net.minecraft.util.Hand): void;
            }
            const ItemRenderer: {
              ENTITY_ENCHANTMENT_GLINT: net.minecraft.util.Identifier;
              ITEM_ENCHANTMENT_GLINT: net.minecraft.util.Identifier;
              field_60154: number;
              field_60155: number;
              field_60156: number;
              NO_TINT: number;
              renderItem(displayContext: net.minecraft.item.ItemDisplayContext, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, light: number, overlay: number, tints: Array<number>, quads: Array<net.minecraft.client.render.model.BakedQuad>, layer: net.minecraft.client.render.RenderLayer, glint: net.minecraft.client.render.item.ItemRenderState$Glint): void;
              getItemGlintConsumer(vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, layer: net.minecraft.client.render.RenderLayer, solid: boolean, glint: boolean): net.minecraft.client.render.VertexConsumer;
              getGlintRenderLayers(renderLayer: net.minecraft.client.render.RenderLayer, solid: boolean, transparent: boolean): Array<net.minecraft.client.render.RenderLayer>;
              new(): net.minecraft.client.render.item.ItemRenderer;
            }
            interface ItemRenderer { 
            }
            const KeyedItemRenderState: {
              new(): net.minecraft.client.render.item.KeyedItemRenderState;
            }
            interface KeyedItemRenderState extends net.minecraft.client.render.item.ItemRenderState { 
              getModelKey(): any;
            }
          }
          namespace command {
            interface OrderedRenderCommandQueue extends net.minecraft.client.render.command.RenderCommandQueue { 
              getBatchingQueue(order: number): net.minecraft.client.render.command.RenderCommandQueue;
            }
            interface RenderCommandQueue extends net.fabricmc.fabric.api.renderer.v1.render.FabricRenderCommandQueue { 
              submitBlock(matrices: net.minecraft.client.util.math.MatrixStack, state: net.minecraft.block.BlockState, light: number, overlay: number, outlineColor: number): void;
              submitBlockStateModel(matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, model: net.minecraft.client.render.model.BlockStateModel, r: number, g: number, b: number, light: number, overlay: number, outlineColor: number): void;
              submitDebugHitbox(matrices: net.minecraft.client.util.math.MatrixStack, renderState: net.minecraft.client.render.entity.state.EntityRenderState, debugHitbox: net.minecraft.client.render.entity.state.EntityHitboxAndView): void;
              submitShadowPieces(matrices: net.minecraft.client.util.math.MatrixStack, shadowRadius: number, shadowPieces: Array<net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece>): void;
              submitLabel(matrices: net.minecraft.client.util.math.MatrixStack, nameLabelPos: net.minecraft.util.math.Vec3d | null | undefined, y: number, label: net.minecraft.text.Text, notSneaking: boolean, light: number, squaredDistanceToCamera: number, cameraState: net.minecraft.client.render.state.CameraRenderState): void;
              submitText(matrices: net.minecraft.client.util.math.MatrixStack, x: number, y: number, text: net.minecraft.text.OrderedText, dropShadow: boolean, layerType: net.minecraft.client.font.TextRenderer$TextLayerType, light: number, color: number, backgroundColor: number, outlineColor: number): void;
              submitFire(matrices: net.minecraft.client.util.math.MatrixStack, renderState: net.minecraft.client.render.entity.state.EntityRenderState, rotation: org.joml.Quaternionf): void;
              submitLeash(matrices: net.minecraft.client.util.math.MatrixStack, leashData: net.minecraft.client.render.entity.state.EntityRenderState$LeashData): void;
              submitModel<S>(model: net.minecraft.client.model.Model<S>, state: S, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, tintedColor: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, outlineColor: number, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): void;
              submitModel<S>(model: net.minecraft.client.model.Model<S>, state: S, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, outlineColor: number, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): void;
              submitModelPart(part: net.minecraft.client.model.ModelPart, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, sprite: net.minecraft.client.texture.Sprite | null | undefined): void;
              submitModelPart(part: net.minecraft.client.model.ModelPart, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, tintedColor: number, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): void;
              submitModelPart(part: net.minecraft.client.model.ModelPart, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, sheeted: boolean, hasGlint: boolean): void;
              submitModelPart(part: net.minecraft.client.model.ModelPart, matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, light: number, overlay: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, sheeted: boolean, hasGlint: boolean, tintedColor: number, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined, i: number): void;
              submitMovingBlock(matrices: net.minecraft.client.util.math.MatrixStack, state: net.minecraft.client.render.block.MovingBlockRenderState): void;
              submitItem(matrices: net.minecraft.client.util.math.MatrixStack, displayContext: net.minecraft.item.ItemDisplayContext, light: number, overlay: number, outlineColors: number, tintLayers: Array<number>, quads: Array<net.minecraft.client.render.model.BakedQuad>, renderLayer: net.minecraft.client.render.RenderLayer, glintType: net.minecraft.client.render.item.ItemRenderState$Glint): void;
              submitCustom(matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, customRenderer: net.minecraft.client.render.command.OrderedRenderCommandQueue$Custom): void;
              submitCustom(customRenderer: net.minecraft.client.render.command.OrderedRenderCommandQueue$LayeredCustom): void;
            }
            const ModelCommandRenderer$CrumblingOverlayCommand: {
              new(i: number, entry: net.minecraft.client.util.math.MatrixStack$Entry): net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand;
            }
            interface ModelCommandRenderer$CrumblingOverlayCommand extends java.lang.Record { 
              progress(): number;
              cameraMatricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
            }
            interface OrderedRenderCommandQueue$Custom { 
              render(matricesEntry: net.minecraft.client.util.math.MatrixStack$Entry, vertexConsumer: net.minecraft.client.render.VertexConsumer): void;
            }
            interface OrderedRenderCommandQueue$LayeredCustom { 
              submit(cache: net.minecraft.client.render.command.LayeredCustomCommandRenderer$VerticesCache): net.minecraft.client.particle.BillboardParticleSubmittable$Buffers | null | undefined;
              render(buffers: net.minecraft.client.particle.BillboardParticleSubmittable$Buffers, cache: net.minecraft.client.render.command.LayeredCustomCommandRenderer$VerticesCache, renderPass: com.mojang.blaze3d.systems.RenderPass, manager: net.minecraft.client.texture.TextureManager, translucent: boolean): void;
            }
            const LayeredCustomCommandRenderer$VerticesCache: {
              new(): net.minecraft.client.render.command.LayeredCustomCommandRenderer$VerticesCache;
            }
            interface LayeredCustomCommandRenderer$VerticesCache extends java.lang.AutoCloseable { 
              write(byteBuffer: java.nio.ByteBuffer): void;
              get(): com.mojang.blaze3d.buffers.GpuBuffer;
            }
            const RenderDispatcher: {
              new(queue: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider$Immediate, atlasManager: net.minecraft.client.texture.AtlasManager, outlineVertexConsumers: net.minecraft.client.render.OutlineVertexConsumerProvider, crumblingOverlayVertexConsumers: net.minecraft.client.render.VertexConsumerProvider$Immediate, textRenderer: net.minecraft.client.font.TextRenderer): net.minecraft.client.render.command.RenderDispatcher;
            }
            interface RenderDispatcher extends java.lang.AutoCloseable { 
              render(): void;
              endLayeredCustoms(): void;
              getQueue(): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl;
            }
            const OrderedRenderCommandQueueImpl: {
              BlockCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockCommand;
              CustomCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$CustomCommand;
              ShadowPiecesCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ShadowPiecesCommand;
              ModelCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelCommand;
              DebugHitboxCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$DebugHitboxCommand;
              ItemCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ItemCommand;
              LabelCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$LabelCommand;
              FireCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$FireCommand;
              ModelPartCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelPartCommand;
              BlendedModelCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlendedModelCommand;
              LeashCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$LeashCommand;
              MovingBlockCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$MovingBlockCommand;
              BlockStateModelCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockStateModelCommand;
              TextCommand: typeof net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$TextCommand;
              new(): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl;
            }
            interface OrderedRenderCommandQueueImpl extends net.minecraft.client.render.command.OrderedRenderCommandQueue { 
              clear(): void;
              onNextFrame(): void;
              getBatchingQueues(): it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap<net.minecraft.client.render.command.BatchingRenderCommandQueue>;
            }
            const OrderedRenderCommandQueueImpl$BlockCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, blockState: net.minecraft.block.BlockState, i: number, j: number, k: number): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockCommand;
            }
            interface OrderedRenderCommandQueueImpl$BlockCommand extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              state(): net.minecraft.block.BlockState;
              lightCoords(): number;
              overlayCoords(): number;
              outlineColor(): number;
            }
            const OrderedRenderCommandQueueImpl$CustomCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, custom: net.minecraft.client.render.command.OrderedRenderCommandQueue$Custom): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$CustomCommand;
            }
            interface OrderedRenderCommandQueueImpl$CustomCommand extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              customRenderer(): net.minecraft.client.render.command.OrderedRenderCommandQueue$Custom;
            }
            const OrderedRenderCommandQueueImpl$ShadowPiecesCommand: {
              new(matrix4f: org.joml.Matrix4f, f: number, list: Array<net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece>): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ShadowPiecesCommand;
            }
            interface OrderedRenderCommandQueueImpl$ShadowPiecesCommand extends java.lang.Record { 
              matricesEntry(): org.joml.Matrix4f;
              radius(): number;
              pieces(): Array<net.minecraft.client.render.entity.state.EntityRenderState$ShadowPiece>;
            }
            const OrderedRenderCommandQueueImpl$ModelCommand: {
              new<S>(entry: net.minecraft.client.util.math.MatrixStack$Entry, model: net.minecraft.client.model.Model<S>, object: S, i: number, j: number, k: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, l: number, crumblingOverlayCommand: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelCommand<S>;
            }
            interface OrderedRenderCommandQueueImpl$ModelCommand<S> extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              model(): net.minecraft.client.model.Model<S>;
              state(): S;
              lightCoords(): number;
              overlayCoords(): number;
              tintedColor(): number;
              sprite(): net.minecraft.client.texture.Sprite | null | undefined;
              outlineColor(): number;
              crumblingOverlay(): net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined;
            }
            const OrderedRenderCommandQueueImpl$DebugHitboxCommand: {
              new(matrix4f: org.joml.Matrix4f, entityRenderState: net.minecraft.client.render.entity.state.EntityRenderState, entityHitboxAndView: net.minecraft.client.render.entity.state.EntityHitboxAndView): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$DebugHitboxCommand;
            }
            interface OrderedRenderCommandQueueImpl$DebugHitboxCommand extends java.lang.Record { 
              pose(): org.joml.Matrix4f;
              renderState(): net.minecraft.client.render.entity.state.EntityRenderState;
              debugHitbox(): net.minecraft.client.render.entity.state.EntityHitboxAndView;
            }
            const OrderedRenderCommandQueueImpl$ItemCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, itemDisplayContext: net.minecraft.item.ItemDisplayContext, i: number, j: number, k: number, is: Array<number>, list: Array<net.minecraft.client.render.model.BakedQuad>, renderLayer: net.minecraft.client.render.RenderLayer, glint: net.minecraft.client.render.item.ItemRenderState$Glint): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ItemCommand;
            }
            interface OrderedRenderCommandQueueImpl$ItemCommand extends java.lang.Record { 
              positionMatrix(): net.minecraft.client.util.math.MatrixStack$Entry;
              displayContext(): net.minecraft.item.ItemDisplayContext;
              lightCoords(): number;
              overlayCoords(): number;
              outlineColor(): number;
              tintLayers(): Array<number>;
              quads(): Array<net.minecraft.client.render.model.BakedQuad>;
              renderLayer(): net.minecraft.client.render.RenderLayer;
              glintType(): net.minecraft.client.render.item.ItemRenderState$Glint;
            }
            const OrderedRenderCommandQueueImpl$LabelCommand: {
              new(matrix4f: org.joml.Matrix4f, f: number, g: number, text: net.minecraft.text.Text, i: number, j: number, k: number, d: number): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$LabelCommand;
            }
            interface OrderedRenderCommandQueueImpl$LabelCommand extends java.lang.Record { 
              matricesEntry(): org.joml.Matrix4f;
              x(): number;
              y(): number;
              text(): net.minecraft.text.Text;
              lightCoords(): number;
              color(): number;
              backgroundColor(): number;
              distanceToCameraSq(): number;
            }
            const OrderedRenderCommandQueueImpl$FireCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, entityRenderState: net.minecraft.client.render.entity.state.EntityRenderState, quaternionf: org.joml.Quaternionf): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$FireCommand;
            }
            interface OrderedRenderCommandQueueImpl$FireCommand extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              renderState(): net.minecraft.client.render.entity.state.EntityRenderState;
              rotation(): org.joml.Quaternionf;
            }
            const OrderedRenderCommandQueueImpl$ModelPartCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, modelPart: net.minecraft.client.model.ModelPart, i: number, j: number, sprite: net.minecraft.client.texture.Sprite | null | undefined, bl: boolean, bl2: boolean, k: number, crumblingOverlayCommand: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined, l: number): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelPartCommand;
            }
            interface OrderedRenderCommandQueueImpl$ModelPartCommand extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              modelPart(): net.minecraft.client.model.ModelPart;
              lightCoords(): number;
              overlayCoords(): number;
              sprite(): net.minecraft.client.texture.Sprite | null | undefined;
              sheeted(): boolean;
              hasGlint(): boolean;
              tintedColor(): number;
              crumblingOverlay(): net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined;
              outlineColor(): number;
            }
            const OrderedRenderCommandQueueImpl$BlendedModelCommand: {
              new<S>(modelCommand: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelCommand<S>, renderLayer: net.minecraft.client.render.RenderLayer, vector3f: org.joml.Vector3f): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlendedModelCommand<S>;
            }
            interface OrderedRenderCommandQueueImpl$BlendedModelCommand<S> extends java.lang.Record { 
              model(): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelCommand<S>;
              renderType(): net.minecraft.client.render.RenderLayer;
              position(): org.joml.Vector3f;
            }
            const OrderedRenderCommandQueueImpl$LeashCommand: {
              new(matrix4f: org.joml.Matrix4f, leashData: net.minecraft.client.render.entity.state.EntityRenderState$LeashData): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$LeashCommand;
            }
            interface OrderedRenderCommandQueueImpl$LeashCommand extends java.lang.Record { 
              matricesEntry(): org.joml.Matrix4f;
              leashState(): net.minecraft.client.render.entity.state.EntityRenderState$LeashData;
            }
            const OrderedRenderCommandQueueImpl$MovingBlockCommand: {
              new(matrix4f: org.joml.Matrix4f, movingBlockRenderState: net.minecraft.client.render.block.MovingBlockRenderState): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$MovingBlockCommand;
            }
            interface OrderedRenderCommandQueueImpl$MovingBlockCommand extends java.lang.Record { 
              matricesEntry(): org.joml.Matrix4f;
              movingBlockRenderState(): net.minecraft.client.render.block.MovingBlockRenderState;
            }
            const OrderedRenderCommandQueueImpl$BlockStateModelCommand: {
              new(entry: net.minecraft.client.util.math.MatrixStack$Entry, renderLayer: net.minecraft.client.render.RenderLayer, blockStateModel: net.minecraft.client.render.model.BlockStateModel, f: number, g: number, h: number, i: number, j: number, k: number): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockStateModelCommand;
            }
            interface OrderedRenderCommandQueueImpl$BlockStateModelCommand extends java.lang.Record { 
              matricesEntry(): net.minecraft.client.util.math.MatrixStack$Entry;
              renderLayer(): net.minecraft.client.render.RenderLayer;
              model(): net.minecraft.client.render.model.BlockStateModel;
              r(): number;
              g(): number;
              b(): number;
              lightCoords(): number;
              overlayCoords(): number;
              outlineColor(): number;
            }
            const OrderedRenderCommandQueueImpl$TextCommand: {
              new(matrix4f: org.joml.Matrix4f, f: number, g: number, orderedText: net.minecraft.text.OrderedText, bl: boolean, textLayerType: net.minecraft.client.font.TextRenderer$TextLayerType, i: number, j: number, k: number, l: number): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$TextCommand;
            }
            interface OrderedRenderCommandQueueImpl$TextCommand extends java.lang.Record { 
              matricesEntry(): org.joml.Matrix4f;
              x(): number;
              y(): number;
              text(): net.minecraft.text.OrderedText;
              dropShadow(): boolean;
              layerType(): net.minecraft.client.font.TextRenderer$TextLayerType;
              lightCoords(): number;
              color(): number;
              backgroundColor(): number;
              outlineColor(): number;
            }
            const BatchingRenderCommandQueue: {
              new(orderedQueueImpl: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl): net.minecraft.client.render.command.BatchingRenderCommandQueue;
            }
            interface BatchingRenderCommandQueue extends net.minecraft.client.render.command.RenderCommandQueue { 
              getShadowPiecesCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ShadowPiecesCommand>;
              getFireCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$FireCommand>;
              getLabelCommands(): net.minecraft.client.render.command.LabelCommandRenderer$Commands;
              getTextCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$TextCommand>;
              getDebugHitboxCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$DebugHitboxCommand>;
              getLeashCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$LeashCommand>;
              getBlockCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockCommand>;
              getMovingBlockCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$MovingBlockCommand>;
              getBlockStateModelCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$BlockStateModelCommand>;
              getModelPartCommands(): net.minecraft.client.render.command.ModelPartCommandRenderer$Commands;
              getItemCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ItemCommand>;
              getLayeredCustomCommands(): Array<net.minecraft.client.render.command.OrderedRenderCommandQueue$LayeredCustom>;
              getModelCommands(): net.minecraft.client.render.command.ModelCommandRenderer$Commands;
              getCustomCommands(): net.minecraft.client.render.command.CustomCommandRenderer$Commands;
              hasCommands(): boolean;
              clear(): void;
              onNextFrame(): void;
            }
            const LabelCommandRenderer$Commands: {
              new(): net.minecraft.client.render.command.LabelCommandRenderer$Commands;
            }
            interface LabelCommandRenderer$Commands { 
              add(matrices: net.minecraft.client.util.math.MatrixStack, pos: net.minecraft.util.math.Vec3d | null | undefined, y: number, label: net.minecraft.text.Text, notSneaking: boolean, light: number, squaredDistanceToCamera: number, cameraState: net.minecraft.client.render.state.CameraRenderState): void;
              clear(): void;
            }
            const ModelPartCommandRenderer$Commands: {
              new(): net.minecraft.client.render.command.ModelPartCommandRenderer$Commands;
            }
            interface ModelPartCommandRenderer$Commands { 
              add(renderLayer: net.minecraft.client.render.RenderLayer, command: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelPartCommand): void;
              clear(): void;
              nextFrame(): void;
            }
            const ModelCommandRenderer$Commands: {
              new(): net.minecraft.client.render.command.ModelCommandRenderer$Commands;
            }
            interface ModelCommandRenderer$Commands { 
              add(renderLayer: net.minecraft.client.render.RenderLayer, modelCommand: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl$ModelCommand<any>): void;
              clear(): void;
              nextFrame(): void;
            }
            const CustomCommandRenderer$Commands: {
              new(): net.minecraft.client.render.command.CustomCommandRenderer$Commands;
            }
            interface CustomCommandRenderer$Commands { 
              add(matrices: net.minecraft.client.util.math.MatrixStack, renderLayer: net.minecraft.client.render.RenderLayer, custom: net.minecraft.client.render.command.OrderedRenderCommandQueue$Custom): void;
              clear(): void;
              nextFrame(): void;
            }
          }
          namespace state {
            const CameraRenderState: {
              new(): net.minecraft.client.render.state.CameraRenderState;
            }
            interface CameraRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              blockPos: net.minecraft.util.math.BlockPos;
              pos: net.minecraft.util.math.Vec3d;
              initialized: boolean;
              entityPos: net.minecraft.util.math.Vec3d;
              orientation: org.joml.Quaternionf;
            }
            const WorldRenderState: {
              new(): net.minecraft.client.render.state.WorldRenderState;
            }
            interface WorldRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              cameraRenderState: net.minecraft.client.render.state.CameraRenderState;
              entityRenderStates: Array<net.minecraft.client.render.entity.state.EntityRenderState>;
              blockEntityRenderStates: Array<unknown>;
              hasOutline: boolean;
              outlineRenderState: net.minecraft.client.render.state.OutlineRenderState | null | undefined;
              breakingBlockRenderStates: Array<unknown>;
              weatherRenderState: net.minecraft.client.render.state.WeatherRenderState;
              worldBorderRenderState: net.minecraft.client.render.state.WorldBorderRenderState;
              skyRenderState: net.minecraft.client.render.state.SkyRenderState;
              clear(): void;
            }
            const OutlineRenderState: {
              new(pos: net.minecraft.util.math.BlockPos, isTranslucent: boolean, highContrast: boolean, shape: net.minecraft.util.shape.VoxelShape): net.minecraft.client.render.state.OutlineRenderState;
              new(blockPos: net.minecraft.util.math.BlockPos, bl: boolean, bl2: boolean, voxelShape: net.minecraft.util.shape.VoxelShape, voxelShape2: net.minecraft.util.shape.VoxelShape | null | undefined, voxelShape3: net.minecraft.util.shape.VoxelShape | null | undefined, voxelShape4: net.minecraft.util.shape.VoxelShape | null | undefined): net.minecraft.client.render.state.OutlineRenderState;
            }
            interface OutlineRenderState extends java.lang.Record, net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              pos(): net.minecraft.util.math.BlockPos;
              isTranslucent(): boolean;
              highContrast(): boolean;
              shape(): net.minecraft.util.shape.VoxelShape;
              collisionShape(): net.minecraft.util.shape.VoxelShape | null | undefined;
              occlusionShape(): net.minecraft.util.shape.VoxelShape | null | undefined;
              interactionShape(): net.minecraft.util.shape.VoxelShape | null | undefined;
            }
            const WeatherRenderState: {
              new(): net.minecraft.client.render.state.WeatherRenderState;
            }
            interface WeatherRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              rainPieces: Array<unknown>;
              snowPieces: Array<unknown>;
              intensity: number;
              radius: number;
              clear(): void;
            }
            const WorldBorderRenderState: {
              Distance: typeof net.minecraft.client.render.state.WorldBorderRenderState$Distance;
              new(): net.minecraft.client.render.state.WorldBorderRenderState;
            }
            interface WorldBorderRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              minX: number;
              maxX: number;
              minZ: number;
              maxZ: number;
              tint: number;
              alpha: number;
              nearestBorder(x: number, z: number): Array<net.minecraft.client.render.state.WorldBorderRenderState$Distance>;
              clear(): void;
            }
            const WorldBorderRenderState$Distance: {
              new(direction: net.minecraft.util.math.Direction, d: number): net.minecraft.client.render.state.WorldBorderRenderState$Distance;
            }
            interface WorldBorderRenderState$Distance extends java.lang.Record { 
              direction(): net.minecraft.util.math.Direction;
              value(): number;
            }
            const SkyRenderState: {
              new(): net.minecraft.client.render.state.SkyRenderState;
            }
            interface SkyRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              skyType: net.minecraft.client.render.DimensionEffects$SkyType;
              isSunTransition: boolean;
              shouldRenderSkyDark: boolean;
              solarAngle: number;
              time: number;
              rainGradient: number;
              starBrightness: number;
              sunriseAndSunsetColor: number;
              moonPhase: number;
              skyColor: number;
              endFlashIntensity: number;
              endFlashPitch: number;
              endFlashYaw: number;
              clear(): void;
            }
          }
          namespace block {
            namespace entity {
              namespace model {
                const BannerFlagBlockModel: {
                  getTexturedModelData(standing: boolean): net.minecraft.client.model.TexturedModelData;
                  new(root: net.minecraft.client.model.ModelPart): net.minecraft.client.render.block.entity.model.BannerFlagBlockModel;
                }
                interface BannerFlagBlockModel extends net.minecraft.client.model.Model<number> { 
                }
              }
              const BlockEntityRenderManager: {
                new(textRenderer: net.minecraft.client.font.TextRenderer, entityModelsGetter: unknown, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager, itemModelManager: net.minecraft.client.item.ItemModelManager, itemRenderer: net.minecraft.client.render.item.ItemRenderer, entityRenderDispatcher: net.minecraft.client.render.entity.EntityRenderManager, spriteHolder: net.minecraft.client.texture.SpriteHolder, playerSkinCache: net.minecraft.client.texture.PlayerSkinCache): net.minecraft.client.render.block.entity.BlockEntityRenderManager;
              }
              interface BlockEntityRenderManager extends net.minecraft.resource.SynchronousResourceReloader { 
                get<E, S>(blockEntity: E): net.minecraft.client.render.block.entity.BlockEntityRenderer<E, S> | null | undefined;
                getByRenderState<E, S>(renderState: S): net.minecraft.client.render.block.entity.BlockEntityRenderer<E, S> | null | undefined;
                configure(camera: net.minecraft.client.render.Camera): void;
                getRenderState<E, S>(blockEntity: E, tickProgress: number, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): S;
                render<S>(renderState: S, matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, cameraRenderState: net.minecraft.client.render.state.CameraRenderState): void;
              }
              interface BlockEntityRenderer<T, S> { 
                createRenderState(): S;
                updateRenderState(blockEntity: T, state: S, tickProgress: number, cameraPos: net.minecraft.util.math.Vec3d, crumblingOverlay: net.minecraft.client.render.command.ModelCommandRenderer$CrumblingOverlayCommand | null | undefined): void;
                render(state: S, matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, cameraState: net.minecraft.client.render.state.CameraRenderState): void;
                rendersOutsideBoundingBox(): boolean;
                getRenderDistance(): number;
                isInRenderDistance(blockEntity: T, pos: net.minecraft.util.math.Vec3d): boolean;
              }
            }
            const MovingBlockRenderState: {
              new(): net.minecraft.client.render.block.MovingBlockRenderState;
            }
            interface MovingBlockRenderState extends net.minecraft.world.BlockRenderView, net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
              fallingBlockPos: net.minecraft.util.math.BlockPos;
              entityBlockPos: net.minecraft.util.math.BlockPos;
              blockState: net.minecraft.block.BlockState;
              biome: net.minecraft.registry.entry.RegistryEntry<net.minecraft.world.biome.Biome> | null | undefined;
              world: net.minecraft.world.BlockRenderView;
            }
            const BlockRenderManager: {
              new(models: net.minecraft.client.render.block.BlockModels, spriteHolder: net.minecraft.client.texture.SpriteHolder, blockEntityModelsGetter: unknown, blockColors: net.minecraft.client.color.block.BlockColors): net.minecraft.client.render.block.BlockRenderManager;
            }
            interface BlockRenderManager extends net.minecraft.resource.SynchronousResourceReloader, net.fabricmc.fabric.api.renderer.v1.render.FabricBlockRenderManager { 
              renderBlockAsEntity(state: net.minecraft.block.BlockState, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, light: number, overlay: number): void;
              getModels(): net.minecraft.client.render.block.BlockModels;
              renderDamage(state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos, world: net.minecraft.world.BlockRenderView, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer): void;
              renderBlock(state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos, world: net.minecraft.world.BlockRenderView, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer, cull: boolean, parts: Array<unknown>): void;
              renderFluid(pos: net.minecraft.util.math.BlockPos, world: net.minecraft.world.BlockRenderView, vertexConsumer: net.minecraft.client.render.VertexConsumer, blockState: net.minecraft.block.BlockState, fluidState: net.minecraft.fluid.FluidState): void;
              getModelRenderer(): net.minecraft.client.render.block.BlockModelRenderer;
              getModel(state: net.minecraft.block.BlockState): net.minecraft.client.render.model.BlockStateModel;
            }
            const BlockModels: {
              new(modelManager: net.minecraft.client.render.model.BakedModelManager): net.minecraft.client.render.block.BlockModels;
            }
            interface BlockModels extends net.fabricmc.fabric.api.renderer.v1.model.FabricBlockModels { 
              getModelParticleSprite(state: net.minecraft.block.BlockState): net.minecraft.client.texture.Sprite;
              getModel(state: net.minecraft.block.BlockState): net.minecraft.client.render.model.BlockStateModel;
              getModelManager(): net.minecraft.client.render.model.BakedModelManager;
              setModels(models: Map<net.minecraft.block.BlockState, net.minecraft.client.render.model.BlockStateModel>): void;
            }
            const BlockModelRenderer: {
              render(entry: net.minecraft.client.util.math.MatrixStack$Entry, vertexConsumer: net.minecraft.client.render.VertexConsumer, model: net.minecraft.client.render.model.BlockStateModel, red: number, green: number, blue: number, light: number, overlay: number): void;
              enableBrightnessCache(): void;
              disableBrightnessCache(): void;
              new(colors: net.minecraft.client.color.block.BlockColors): net.minecraft.client.render.block.BlockModelRenderer;
            }
            interface BlockModelRenderer extends net.fabricmc.fabric.api.renderer.v1.render.FabricBlockModelRenderer { 
              render(world: net.minecraft.world.BlockRenderView, parts: Array<unknown>, state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer, cull: boolean, overlay: number): void;
              renderSmooth(world: net.minecraft.world.BlockRenderView, parts: Array<unknown>, state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer, cull: boolean, overlay: number): void;
              renderFlat(world: net.minecraft.world.BlockRenderView, parts: Array<unknown>, state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos, matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer, cull: boolean, overlay: number): void;
            }
          }
          namespace chunk {
            const BlockBufferAllocatorStorage: {
              EXPECTED_TOTAL_SIZE: number;
              new(): net.minecraft.client.render.chunk.BlockBufferAllocatorStorage;
            }
            interface BlockBufferAllocatorStorage extends java.lang.AutoCloseable { 
              get(layer: net.minecraft.client.render.BlockRenderLayer): net.minecraft.client.util.BufferAllocator;
              clear(): void;
              reset(): void;
            }
            const BlockBufferBuilderPool: {
              allocate(max: number): net.minecraft.client.render.chunk.BlockBufferBuilderPool;
            }
            interface BlockBufferBuilderPool { 
              acquire(): net.minecraft.client.render.chunk.BlockBufferAllocatorStorage | null | undefined;
              release(builders: net.minecraft.client.render.chunk.BlockBufferAllocatorStorage): void;
              hasNoAvailableBuilder(): boolean;
              getAvailableBuilderCount(): number;
            }
            const ChunkBuilder: {
              BuiltChunk: typeof net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk;
              new(world: net.minecraft.client.world.ClientWorld, worldRenderer: net.minecraft.client.render.WorldRenderer, executor: net.minecraft.util.thread.NameableExecutor, bufferBuilderStorage: net.minecraft.client.render.BufferBuilderStorage, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager, blockEntityRenderDispatcher: net.minecraft.client.render.block.entity.BlockEntityRenderManager): net.minecraft.client.render.chunk.ChunkBuilder;
            }
            interface ChunkBuilder { 
              setWorld(world: net.minecraft.client.world.ClientWorld): void;
              setCameraPosition(cameraPosition: net.minecraft.util.math.Vec3d): void;
              upload(): void;
              rebuild(chunk: net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk, builder: net.minecraft.client.render.chunk.ChunkRendererRegionBuilder): void;
              send(task: unknown): void;
              cancelAllTasks(): void;
              isEmpty(): boolean;
              stop(): void;
              getDebugString(): string;
              getScheduledTaskCount(): number;
              getChunksToUpload(): number;
              getFreeBufferCount(): number;
            }
            const ChunkBuilder$BuiltChunk: {
              Task: typeof net.minecraft.client.render.chunk.ChunkBuilder.ChunkBuilder$BuiltChunk$Task;
              CHUNK_SIZE: number;
              new(index: number, sectionPos: number): net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk;
            }
            interface ChunkBuilder$BuiltChunk { 
              index: number;
              currentRenderData: java.util.concurrent.atomic.AtomicReference<net.minecraft.client.render.chunk.AbstractChunkRenderData>;
              shouldBuild(): boolean;
              getBoundingBox(): net.minecraft.util.math.Box;
              uploadLayer(buffersByLayer: Map<net.minecraft.client.render.BlockRenderLayer, net.minecraft.client.render.BuiltBuffer>, renderData: net.minecraft.client.render.chunk.ChunkRenderData): java.util.concurrent.CompletableFuture<java.lang.Void>;
              uploadIndices(data: net.minecraft.client.render.chunk.ChunkRenderData, buffer: net.minecraft.client.util.BufferAllocator$CloseableBuffer, layer: net.minecraft.client.render.BlockRenderLayer): java.util.concurrent.CompletableFuture<java.lang.Void>;
              setSectionPos(sectionPos: number): void;
              getCurrentRenderData(): net.minecraft.client.render.chunk.AbstractChunkRenderData;
              clear(): void;
              getOrigin(): net.minecraft.util.math.BlockPos;
              getSectionPos(): number;
              scheduleRebuild(important: boolean): void;
              scheduleRebuild(builder: net.minecraft.client.render.chunk.ChunkRendererRegionBuilder): void;
              cancelRebuild(): void;
              needsRebuild(): boolean;
              needsImportantRebuild(): boolean;
              getOffsetSectionPos(direction: net.minecraft.util.math.Direction): number;
              scheduleSort(builder: net.minecraft.client.render.chunk.ChunkBuilder): void;
              hasTranslucentLayer(): boolean;
              isCurrentlySorting(): boolean;
              createRebuildTask(builder: net.minecraft.client.render.chunk.ChunkRendererRegionBuilder): unknown;
              rebuild(builder: net.minecraft.client.render.chunk.ChunkRendererRegionBuilder): void;
            }
            const ChunkBuilder$BuiltChunk$Task: {
              new(prioritized: boolean): unknown;
            }
            interface ChunkBuilder$BuiltChunk$Task { 
              run(buffers: net.minecraft.client.render.chunk.BlockBufferAllocatorStorage): java.util.concurrent.CompletableFuture<unknown>;
              cancel(): void;
              isPrioritized(): boolean;
              getOrigin(): net.minecraft.util.math.BlockPos;
            }
            const ChunkRenderData: {
              HIDDEN: net.minecraft.client.render.chunk.AbstractChunkRenderData;
              READY: net.minecraft.client.render.chunk.AbstractChunkRenderData;
              new(pos: net.minecraft.client.render.chunk.NormalizedRelativePos, renderData: net.minecraft.client.render.chunk.SectionBuilder$RenderData): net.minecraft.client.render.chunk.ChunkRenderData;
            }
            interface ChunkRenderData extends net.minecraft.client.render.chunk.AbstractChunkRenderData { 
              setPos(pos: net.minecraft.client.render.chunk.NormalizedRelativePos): void;
              upload(layer: net.minecraft.client.render.BlockRenderLayer, builtBuffer: net.minecraft.client.render.BuiltBuffer, sectionPos: number): void;
              uploadIndexBuffer(layer: net.minecraft.client.render.BlockRenderLayer, buffer: net.minecraft.client.util.BufferAllocator$CloseableBuffer, sectionPos: number): void;
              getTranslucencySortingData(): net.minecraft.client.render.BuiltBuffer$SortState | null | undefined;
            }
            interface AbstractChunkRenderData extends java.lang.AutoCloseable { 
              hasPosition(pos: net.minecraft.client.render.chunk.NormalizedRelativePos): boolean;
              hasData(): boolean;
              hasTranslucentLayers(): boolean;
              containsLayer(layer: net.minecraft.client.render.BlockRenderLayer): boolean;
              getBlockEntities(): Array<net.minecraft.block.entity.BlockEntity>;
              isVisibleThrough(from: net.minecraft.util.math.Direction, to: net.minecraft.util.math.Direction): boolean;
              getBuffersForLayer(layer: net.minecraft.client.render.BlockRenderLayer): net.minecraft.client.render.chunk.Buffers | null | undefined;
            }
            const NormalizedRelativePos: {
              of(cameraPos: net.minecraft.util.math.Vec3d, sectionPos: number): net.minecraft.client.render.chunk.NormalizedRelativePos;
              new(): net.minecraft.client.render.chunk.NormalizedRelativePos;
            }
            interface NormalizedRelativePos { 
              isOnCameraAxis(): boolean;
            }
            const Buffers: {
              new(vertexBuffer: com.mojang.blaze3d.buffers.GpuBuffer, indexBuffer: com.mojang.blaze3d.buffers.GpuBuffer | null | undefined, indexCount: number, indexType: com.mojang.blaze3d.vertex.VertexFormat$IndexType): net.minecraft.client.render.chunk.Buffers;
            }
            interface Buffers extends java.lang.AutoCloseable { 
              getVertexBuffer(): com.mojang.blaze3d.buffers.GpuBuffer;
              getIndexBuffer(): com.mojang.blaze3d.buffers.GpuBuffer | null | undefined;
              setIndexBuffer(indexBuffer: com.mojang.blaze3d.buffers.GpuBuffer | null | undefined): void;
              getIndexCount(): number;
              getIndexType(): com.mojang.blaze3d.vertex.VertexFormat$IndexType;
              setIndexType(indexType: com.mojang.blaze3d.vertex.VertexFormat$IndexType): void;
              setIndexCount(indexCount: number): void;
              setVertexBuffer(vertexBuffer: com.mojang.blaze3d.buffers.GpuBuffer): void;
            }
            const SectionBuilder$RenderData: {
              new(): net.minecraft.client.render.chunk.SectionBuilder$RenderData;
            }
            interface SectionBuilder$RenderData { 
              blockEntities: Array<net.minecraft.block.entity.BlockEntity>;
              buffers: Map<net.minecraft.client.render.BlockRenderLayer, net.minecraft.client.render.BuiltBuffer>;
              chunkOcclusionData: net.minecraft.client.render.chunk.ChunkOcclusionData;
              translucencySortingData: net.minecraft.client.render.BuiltBuffer$SortState | null | undefined;
              close(): void;
            }
            const ChunkOcclusionData: {
              new(): net.minecraft.client.render.chunk.ChunkOcclusionData;
            }
            interface ChunkOcclusionData { 
              addOpenEdgeFaces(faces: Set<net.minecraft.util.math.Direction>): void;
              setVisibleThrough(from: net.minecraft.util.math.Direction, to: net.minecraft.util.math.Direction, visible: boolean): void;
              fill(visible: boolean): void;
              isVisibleThrough(from: net.minecraft.util.math.Direction, to: net.minecraft.util.math.Direction): boolean;
            }
            const ChunkRendererRegionBuilder: {
              new(): net.minecraft.client.render.chunk.ChunkRendererRegionBuilder;
            }
            interface ChunkRendererRegionBuilder { 
              build(world: net.minecraft.world.World, sectionPos: number): net.minecraft.client.render.chunk.ChunkRendererRegion;
            }
            const ChunkRendererRegion: {
              field_52160: number;
              SIDE_LENGTH_CHUNKS: number;
              getIndex(xOffset: number, yOffset: number, zOffset: number, sectionX: number, sectionY: number, sectionZ: number): number;
            }
            interface ChunkRendererRegion extends net.minecraft.world.BlockRenderView { 
            }
            const Octree: {
              new(sectionPos: net.minecraft.util.math.ChunkSectionPos, viewDistance: number, sizeY: number, bottomY: number): net.minecraft.client.render.chunk.Octree;
            }
            interface Octree { 
              add(chunk: net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk): boolean;
              visit(visitor: net.minecraft.client.render.chunk.Octree$Visitor, frustum: net.minecraft.client.render.Frustum, margin: number): void;
            }
            interface Octree$Node { 
              visit(visitor: net.minecraft.client.render.chunk.Octree$Visitor, skipVisibilityCheck: boolean, frustum: net.minecraft.client.render.Frustum, depth: number, margin: number, nearCenter: boolean): void;
              getBuiltChunk(): net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk | null | undefined;
              getBoundingBox(): net.minecraft.util.math.Box;
            }
            interface Octree$Visitor { 
              visit(node: net.minecraft.client.render.chunk.Octree$Node, skipVisibilityCheck: boolean, depth: number, nearCenter: boolean): void;
              (node: net.minecraft.client.render.chunk.Octree$Node, skipVisibilityCheck: boolean, depth: number, nearCenter: boolean): void;
            }
          }
          namespace debug {
            const DebugRenderer: {
              getTargetedEntity(entity: net.minecraft.entity.Entity | null | undefined, maxDistance: number): java.util.Optional<net.minecraft.entity.Entity>;
              drawBlockBox(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, pos: net.minecraft.util.math.BlockPos, red: number, green: number, blue: number, alpha: number): void;
              drawBox(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, pos1: net.minecraft.util.math.BlockPos, pos2: net.minecraft.util.math.BlockPos, red: number, green: number, blue: number, alpha: number): void;
              drawBox(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, pos: net.minecraft.util.math.BlockPos, expand: number, red: number, green: number, blue: number, alpha: number): void;
              drawBox(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, box: net.minecraft.util.math.Box, red: number, green: number, blue: number, alpha: number): void;
              drawBox(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number, red: number, green: number, blue: number, alpha: number): void;
              drawFloatingText(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, string: string, pos: net.minecraft.util.math.BlockPos, lineNumber: number, color: number, size: number): void;
              drawLargeFloatingText(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, pos: net.minecraft.entity.Entity, lineNumber: number, string: string, color: number, size: number): void;
              drawString(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, string: string, x: number, y: number, z: number, color: number): void;
              drawString(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, string: string, x: number, y: number, z: number, color: number): void;
              drawString(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, string: string, x: number, y: number, z: number, color: number, size: number): void;
              drawString(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, string: string, x: number, y: number, z: number, color: number, size: number, center: boolean, offset: number, visibleThroughObjects: boolean): void;
              drawVoxelShapeOutlines(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumer: net.minecraft.client.render.VertexConsumer, shape: net.minecraft.util.shape.VoxelShape, offsetX: number, offsetY: number, offsetZ: number, red: number, green: number, blue: number, alpha: number, bl: boolean): void;
              new(): net.minecraft.client.render.debug.DebugRenderer;
            }
            interface DebugRenderer { 
              initRenderers(): void;
              render(matrices: net.minecraft.client.util.math.MatrixStack, frustum: net.minecraft.client.render.Frustum, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider$Immediate, cameraX: number, cameraY: number, cameraZ: number, lateDebug: boolean): void;
            }
            interface DebugRenderer$Renderer { 
              render(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider, cameraX: number, cameraY: number, cameraZ: number, store: net.minecraft.world.debug.DebugDataStore, frustum: net.minecraft.client.render.Frustum): void;
            }
            const GameTestDebugRenderer: {
              new(): net.minecraft.client.render.debug.GameTestDebugRenderer;
            }
            interface GameTestDebugRenderer { 
              addMarker(absolutePos: net.minecraft.util.math.BlockPos, relativePos: net.minecraft.util.math.BlockPos): void;
              clear(): void;
              renderMarkers(matrices: net.minecraft.client.util.math.MatrixStack, vertexConsumers: net.minecraft.client.render.VertexConsumerProvider): void;
            }
          }
          interface VertexConsumer { 
            vertex(x: number, y: number, z: number): net.minecraft.client.render.VertexConsumer;
            vertex(x: number, y: number, z: number, color: number, u: number, v: number, overlay: number, light: number, normalX: number, normalY: number, normalZ: number): void;
            vertex(vec: org.joml.Vector3f): net.minecraft.client.render.VertexConsumer;
            vertex(matrix: net.minecraft.client.util.math.MatrixStack$Entry, vec: org.joml.Vector3f): net.minecraft.client.render.VertexConsumer;
            vertex(matrix: net.minecraft.client.util.math.MatrixStack$Entry, x: number, y: number, z: number): net.minecraft.client.render.VertexConsumer;
            vertex(matrix: org.joml.Matrix4f, x: number, y: number, z: number): net.minecraft.client.render.VertexConsumer;
            vertex(matrix: org.joml.Matrix3x2f, x: number, y: number): net.minecraft.client.render.VertexConsumer;
            color(red: number, green: number, blue: number, alpha: number): net.minecraft.client.render.VertexConsumer;
            color(red: number, green: number, blue: number, alpha: number): net.minecraft.client.render.VertexConsumer;
            color(argb: number): net.minecraft.client.render.VertexConsumer;
            texture(u: number, v: number): net.minecraft.client.render.VertexConsumer;
            overlay(u: number, v: number): net.minecraft.client.render.VertexConsumer;
            overlay(uv: number): net.minecraft.client.render.VertexConsumer;
            light(u: number, v: number): net.minecraft.client.render.VertexConsumer;
            light(uv: number): net.minecraft.client.render.VertexConsumer;
            normal(x: number, y: number, z: number): net.minecraft.client.render.VertexConsumer;
            normal(matrix: net.minecraft.client.util.math.MatrixStack$Entry, x: number, y: number, z: number): net.minecraft.client.render.VertexConsumer;
            normal(matrix: net.minecraft.client.util.math.MatrixStack$Entry, vec: org.joml.Vector3f): net.minecraft.client.render.VertexConsumer;
            quad(matrixEntry: net.minecraft.client.util.math.MatrixStack$Entry, quad: net.minecraft.client.render.model.BakedQuad, red: number, green: number, blue: number, alpha: number, light: number, overlay: number): void;
            quad(matrixEntry: net.minecraft.client.util.math.MatrixStack$Entry, quad: net.minecraft.client.render.model.BakedQuad, brightnesses: kotlin.FloatArray, red: number, green: number, blue: number, alpha: number, lights: Array<number>, overlay: number, colorize: boolean): void;
          }
          const RenderLayer: {
            MultiPhaseParameters: typeof net.minecraft.client.render.RenderLayer$MultiPhaseParameters;
            MultiPhase: typeof net.minecraft.client.render.RenderLayer$MultiPhase;
            OutlineMode: typeof net.minecraft.client.render.RenderLayer$OutlineMode;
            SOLID_BUFFER_SIZE: number;
            CUTOUT_BUFFER_SIZE: number;
            DEFAULT_BUFFER_SIZE: number;
            LINES: net.minecraft.client.render.RenderLayer$MultiPhase;
            SECONDARY_BLOCK_OUTLINE: net.minecraft.client.render.RenderLayer$MultiPhase;
            LINE_STRIP: net.minecraft.client.render.RenderLayer$MultiPhase;
            getSolid(): net.minecraft.client.render.RenderLayer;
            getCutoutMipped(): net.minecraft.client.render.RenderLayer;
            getCutout(): net.minecraft.client.render.RenderLayer;
            getTranslucentMovingBlock(): net.minecraft.client.render.RenderLayer;
            getArmorCutoutNoCull(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            createArmorDecalCutoutNoCull(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            createArmorTranslucent(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntitySolid(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntitySolidZOffsetForward(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityCutout(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityCutoutNoCull(texture: net.minecraft.util.Identifier, affectsOutline: boolean): net.minecraft.client.render.RenderLayer;
            getEntityCutoutNoCull(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityCutoutNoCullZOffset(texture: net.minecraft.util.Identifier, affectsOutline: boolean): net.minecraft.client.render.RenderLayer;
            getEntityCutoutNoCullZOffset(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getItemEntityTranslucentCull(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityTranslucent(texture: net.minecraft.util.Identifier, affectsOutline: boolean): net.minecraft.client.render.RenderLayer;
            getEntityTranslucent(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityTranslucentEmissive(texture: net.minecraft.util.Identifier, affectsOutline: boolean): net.minecraft.client.render.RenderLayer;
            getEntityTranslucentEmissive(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntitySmoothCutout(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getBeaconBeam(texture: net.minecraft.util.Identifier, translucent: boolean): net.minecraft.client.render.RenderLayer;
            getEntityDecal(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityNoOutline(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityShadow(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityAlpha(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEyes(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getEntityTranslucentEmissiveNoOutline(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getBreezeWind(texture: net.minecraft.util.Identifier, x: number, y: number): net.minecraft.client.render.RenderLayer;
            getEnergySwirl(texture: net.minecraft.util.Identifier, x: number, y: number): net.minecraft.client.render.RenderLayer;
            getLeash(): net.minecraft.client.render.RenderLayer;
            getWaterMask(): net.minecraft.client.render.RenderLayer;
            getOutline(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getArmorEntityGlint(): net.minecraft.client.render.RenderLayer;
            getGlintTranslucent(): net.minecraft.client.render.RenderLayer;
            getGlint(): net.minecraft.client.render.RenderLayer;
            getEntityGlint(): net.minecraft.client.render.RenderLayer;
            getBlockBreaking(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getText(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getTextBackground(): net.minecraft.client.render.RenderLayer;
            getTextIntensity(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getTextPolygonOffset(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getTextIntensityPolygonOffset(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getTextSeeThrough(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getTextBackgroundSeeThrough(): net.minecraft.client.render.RenderLayer;
            getTextIntensitySeeThrough(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getLightning(): net.minecraft.client.render.RenderLayer;
            getDragonRays(): net.minecraft.client.render.RenderLayer;
            getDragonRaysDepth(): net.minecraft.client.render.RenderLayer;
            getTripwire(): net.minecraft.client.render.RenderLayer;
            getEndPortal(): net.minecraft.client.render.RenderLayer;
            getEndGateway(): net.minecraft.client.render.RenderLayer;
            getLines(): net.minecraft.client.render.RenderLayer;
            getSecondaryBlockOutline(): net.minecraft.client.render.RenderLayer;
            getLineStrip(): net.minecraft.client.render.RenderLayer;
            getDebugLineStrip(lineWidth: number): net.minecraft.client.render.RenderLayer;
            getDebugFilledBox(): net.minecraft.client.render.RenderLayer;
            getDebugQuads(): net.minecraft.client.render.RenderLayer;
            getDebugTriangleFan(): net.minecraft.client.render.RenderLayer;
            getDebugStructureQuads(): net.minecraft.client.render.RenderLayer;
            getDebugSectionQuads(): net.minecraft.client.render.RenderLayer;
            getWeather(texture: net.minecraft.util.Identifier, allMask: boolean): net.minecraft.client.render.RenderLayer;
            getBlockScreenEffect(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            getFireScreenEffect(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            of(name: string, size: number, pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, params: net.minecraft.client.render.RenderLayer$MultiPhaseParameters): net.minecraft.client.render.RenderLayer$MultiPhase;
            of(name: string, size: number, hasCrumbling: boolean, translucent: boolean, pipeline: com.mojang.blaze3d.pipeline.RenderPipeline, params: net.minecraft.client.render.RenderLayer$MultiPhaseParameters): net.minecraft.client.render.RenderLayer$MultiPhase;
            new(name: string, size: number, hasCrumbling: boolean, translucent: boolean, begin: java.lang.Runnable, end: java.lang.Runnable): net.minecraft.client.render.RenderLayer;
          }
          interface RenderLayer extends net.minecraft.client.render.RenderPhase { 
            draw(buffer: net.minecraft.client.render.BuiltBuffer): void;
            getExpectedBufferSize(): number;
            getVertexFormat(): com.mojang.blaze3d.vertex.VertexFormat;
            getDrawMode(): com.mojang.blaze3d.vertex.VertexFormat$DrawMode;
            getAffectedOutline(): java.util.Optional<net.minecraft.client.render.RenderLayer>;
            isOutline(): boolean;
            getRenderPipeline(): com.mojang.blaze3d.pipeline.RenderPipeline;
            hasCrumbling(): boolean;
            areVerticesNotShared(): boolean;
            isTranslucent(): boolean;
          }
          const RenderPhase: {
            Layering: typeof net.minecraft.client.render.RenderPhase$Layering;
            Overlay: typeof net.minecraft.client.render.RenderPhase$Overlay;
            Target: typeof net.minecraft.client.render.RenderPhase$Target;
            Texture: typeof net.minecraft.client.render.RenderPhase$Texture;
            Texturing: typeof net.minecraft.client.render.RenderPhase$Texturing;
            LineWidth: typeof net.minecraft.client.render.RenderPhase$LineWidth;
            Textures: typeof net.minecraft.client.render.RenderPhase$Textures;
            Lightmap: typeof net.minecraft.client.render.RenderPhase$Lightmap;
            TextureBase: typeof net.minecraft.client.render.RenderPhase$TextureBase;
            OffsetTexturing: typeof net.minecraft.client.render.RenderPhase$OffsetTexturing;
            field_42230: number;
            MIPMAP_BLOCK_ATLAS_TEXTURE: net.minecraft.client.render.RenderPhase$Texture;
            BLOCK_ATLAS_TEXTURE: net.minecraft.client.render.RenderPhase$Texture;
            NO_TEXTURE: net.minecraft.client.render.RenderPhase$TextureBase;
            DEFAULT_TEXTURING: net.minecraft.client.render.RenderPhase$Texturing;
            GLINT_TEXTURING: net.minecraft.client.render.RenderPhase$Texturing;
            ENTITY_GLINT_TEXTURING: net.minecraft.client.render.RenderPhase$Texturing;
            ARMOR_ENTITY_GLINT_TEXTURING: net.minecraft.client.render.RenderPhase$Texturing;
            ENABLE_LIGHTMAP: net.minecraft.client.render.RenderPhase$Lightmap;
            DISABLE_LIGHTMAP: net.minecraft.client.render.RenderPhase$Lightmap;
            ENABLE_OVERLAY_COLOR: net.minecraft.client.render.RenderPhase$Overlay;
            DISABLE_OVERLAY_COLOR: net.minecraft.client.render.RenderPhase$Overlay;
            NO_LAYERING: net.minecraft.client.render.RenderPhase$Layering;
            VIEW_OFFSET_Z_LAYERING: net.minecraft.client.render.RenderPhase$Layering;
            VIEW_OFFSET_Z_LAYERING_FORWARD: net.minecraft.client.render.RenderPhase$Layering;
            MAIN_TARGET: net.minecraft.client.render.RenderPhase$Target;
            OUTLINE_TARGET: net.minecraft.client.render.RenderPhase$Target;
            WEATHER_TARGET: net.minecraft.client.render.RenderPhase$Target;
            ITEM_ENTITY_TARGET: net.minecraft.client.render.RenderPhase$Target;
            FULL_LINE_WIDTH: net.minecraft.client.render.RenderPhase$LineWidth;
            new(name: string, beginAction: java.lang.Runnable, endAction: java.lang.Runnable): net.minecraft.client.render.RenderPhase;
          }
          interface RenderPhase { 
            startDrawing(): void;
            endDrawing(): void;
            getName(): string;
          }
          const RenderPhase$Layering: {
            new(string: string, runnable: java.lang.Runnable, runnable2: java.lang.Runnable): net.minecraft.client.render.RenderPhase$Layering;
          }
          interface RenderPhase$Layering extends net.minecraft.client.render.RenderPhase { 
          }
          const RenderPhase$Overlay: {
            new(overlayColor: boolean): net.minecraft.client.render.RenderPhase$Overlay;
          }
          interface RenderPhase$Overlay { 
          }
          const RenderPhase$Target: {
            new(name: string, framebuffer: unknown): net.minecraft.client.render.RenderPhase$Target;
          }
          interface RenderPhase$Target extends net.minecraft.client.render.RenderPhase { 
            get(): net.minecraft.client.gl.Framebuffer;
          }
          const RenderPhase$Texture: {
            new(id: net.minecraft.util.Identifier, mipmap: boolean): net.minecraft.client.render.RenderPhase$Texture;
          }
          interface RenderPhase$Texture extends net.minecraft.client.render.RenderPhase$TextureBase { 
          }
          const RenderPhase$TextureBase: {
            new(apply: java.lang.Runnable, unapply: java.lang.Runnable): net.minecraft.client.render.RenderPhase$TextureBase;
          }
          interface RenderPhase$TextureBase extends net.minecraft.client.render.RenderPhase { 
          }
          const RenderPhase$Texturing: {
            new(string: string, runnable: java.lang.Runnable, runnable2: java.lang.Runnable): net.minecraft.client.render.RenderPhase$Texturing;
          }
          interface RenderPhase$Texturing extends net.minecraft.client.render.RenderPhase { 
          }
          const RenderPhase$LineWidth: {
            new(width: java.util.OptionalDouble): net.minecraft.client.render.RenderPhase$LineWidth;
          }
          interface RenderPhase$LineWidth extends net.minecraft.client.render.RenderPhase { 
          }
          const RenderPhase$Textures: {
            Builder: typeof net.minecraft.client.render.RenderPhase.RenderPhase$Textures$Builder;
            create(): unknown;
          }
          interface RenderPhase$Textures extends net.minecraft.client.render.RenderPhase$TextureBase { 
          }
          const RenderPhase$Textures$Builder: {
            new(): unknown;
          }
          interface RenderPhase$Textures$Builder { 
            add(id: net.minecraft.util.Identifier, blur: boolean): unknown;
            build(): net.minecraft.client.render.RenderPhase$Textures;
          }
          const RenderPhase$Lightmap: {
            new(lightmap: boolean): net.minecraft.client.render.RenderPhase$Lightmap;
          }
          interface RenderPhase$Lightmap { 
          }
          const RenderPhase$OffsetTexturing: {
            new(x: number, y: number): net.minecraft.client.render.RenderPhase$OffsetTexturing;
          }
          interface RenderPhase$OffsetTexturing extends net.minecraft.client.render.RenderPhase$Texturing { 
          }
          const RenderLayer$MultiPhaseParameters: {
            Builder: typeof net.minecraft.client.render.RenderLayer.RenderLayer$MultiPhaseParameters$Builder;
            builder(): unknown;
          }
          interface RenderLayer$MultiPhaseParameters { 
          }
          interface RenderLayer$MultiPhaseParameters$Builder { 
            texture(texture: net.minecraft.client.render.RenderPhase$TextureBase): unknown;
            lightmap(lightmap: net.minecraft.client.render.RenderPhase$Lightmap): unknown;
            overlay(overlay: net.minecraft.client.render.RenderPhase$Overlay): unknown;
            layering(layering: net.minecraft.client.render.RenderPhase$Layering): unknown;
            target(target: net.minecraft.client.render.RenderPhase$Target): unknown;
            texturing(texturing: net.minecraft.client.render.RenderPhase$Texturing): unknown;
            lineWidth(lineWidth: net.minecraft.client.render.RenderPhase$LineWidth): unknown;
            build(affectsOutline: boolean): net.minecraft.client.render.RenderLayer$MultiPhaseParameters;
            build(outlineMode: net.minecraft.client.render.RenderLayer$OutlineMode): net.minecraft.client.render.RenderLayer$MultiPhaseParameters;
          }
          const RenderLayer$OutlineMode: {
            NONE: net.minecraft.client.render.RenderLayer$OutlineMode;
            IS_OUTLINE: net.minecraft.client.render.RenderLayer$OutlineMode;
            AFFECTS_OUTLINE: net.minecraft.client.render.RenderLayer$OutlineMode;
            valueOf(value: string): net.minecraft.client.render.RenderLayer$OutlineMode;
            values(): Array<net.minecraft.client.render.RenderLayer$OutlineMode>;
          }
          interface RenderLayer$OutlineMode extends kotlin.Enum<net.minecraft.client.render.RenderLayer$OutlineMode> { 
          }
          interface RenderLayer$MultiPhase extends net.minecraft.client.render.RenderLayer { 
          }
          const BuiltBuffer: {
            DrawParameters: typeof net.minecraft.client.render.BuiltBuffer$DrawParameters;
            SortState: typeof net.minecraft.client.render.BuiltBuffer$SortState;
            new(buffer: net.minecraft.client.util.BufferAllocator$CloseableBuffer, drawParameters: net.minecraft.client.render.BuiltBuffer$DrawParameters): net.minecraft.client.render.BuiltBuffer;
          }
          interface BuiltBuffer extends java.lang.AutoCloseable { 
            getBuffer(): java.nio.ByteBuffer;
            getSortedBuffer(): java.nio.ByteBuffer | null | undefined;
            getDrawParameters(): net.minecraft.client.render.BuiltBuffer$DrawParameters;
            sortQuads(allocator: net.minecraft.client.util.BufferAllocator, sorter: com.mojang.blaze3d.systems.VertexSorter): net.minecraft.client.render.BuiltBuffer$SortState | null | undefined;
          }
          const BuiltBuffer$DrawParameters: {
            new(vertexFormat: com.mojang.blaze3d.vertex.VertexFormat, i: number, j: number, drawMode: com.mojang.blaze3d.vertex.VertexFormat$DrawMode, indexType: com.mojang.blaze3d.vertex.VertexFormat$IndexType): net.minecraft.client.render.BuiltBuffer$DrawParameters;
          }
          interface BuiltBuffer$DrawParameters extends java.lang.Record { 
            format(): com.mojang.blaze3d.vertex.VertexFormat;
            vertexCount(): number;
            indexCount(): number;
            mode(): com.mojang.blaze3d.vertex.VertexFormat$DrawMode;
            indexType(): com.mojang.blaze3d.vertex.VertexFormat$IndexType;
          }
          const BuiltBuffer$SortState: {
            new(vec3fArray: net.minecraft.client.util.math.Vec3fArray, indexType: com.mojang.blaze3d.vertex.VertexFormat$IndexType): net.minecraft.client.render.BuiltBuffer$SortState;
          }
          interface BuiltBuffer$SortState extends java.lang.Record { 
            sortAndStore(allocator: net.minecraft.client.util.BufferAllocator, sorter: com.mojang.blaze3d.systems.VertexSorter): net.minecraft.client.util.BufferAllocator$CloseableBuffer | null | undefined;
            centroids(): net.minecraft.client.util.math.Vec3fArray;
            indexType(): com.mojang.blaze3d.vertex.VertexFormat$IndexType;
          }
          const VertexConsumerProvider: {
            Immediate: typeof net.minecraft.client.render.VertexConsumerProvider$Immediate;
            immediate(buffer: net.minecraft.client.util.BufferAllocator): net.minecraft.client.render.VertexConsumerProvider$Immediate;
            immediate(layerBuffers: java.util.SequencedMap<net.minecraft.client.render.RenderLayer, net.minecraft.client.util.BufferAllocator>, fallbackBuffer: net.minecraft.client.util.BufferAllocator): net.minecraft.client.render.VertexConsumerProvider$Immediate;
          }
          interface VertexConsumerProvider { 
            getBuffer(layer: net.minecraft.client.render.RenderLayer): net.minecraft.client.render.VertexConsumer;
          }
          interface VertexConsumerProvider$Immediate extends net.minecraft.client.render.VertexConsumerProvider { 
            drawCurrentLayer(): void;
            draw(): void;
            draw(layer: net.minecraft.client.render.RenderLayer): void;
          }
          const MapRenderState: {
            Decoration: typeof net.minecraft.client.render.MapRenderState$Decoration;
            new(): net.minecraft.client.render.MapRenderState;
          }
          interface MapRenderState extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
            texture: net.minecraft.util.Identifier | null | undefined;
            decorations: Array<net.minecraft.client.render.MapRenderState$Decoration>;
          }
          const MapRenderState$Decoration: {
            new(): net.minecraft.client.render.MapRenderState$Decoration;
          }
          interface MapRenderState$Decoration extends net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState { 
            sprite: net.minecraft.client.texture.Sprite | null | undefined;
            x: number;
            z: number;
            rotation: number;
            alwaysRendered: boolean;
            name: net.minecraft.text.Text | null | undefined;
          }
          const BlockRenderLayer: {
            SOLID: net.minecraft.client.render.BlockRenderLayer;
            CUTOUT_MIPPED: net.minecraft.client.render.BlockRenderLayer;
            CUTOUT: net.minecraft.client.render.BlockRenderLayer;
            TRANSLUCENT: net.minecraft.client.render.BlockRenderLayer;
            TRIPWIRE: net.minecraft.client.render.BlockRenderLayer;
            valueOf(value: string): net.minecraft.client.render.BlockRenderLayer;
            values(): Array<net.minecraft.client.render.BlockRenderLayer>;
          }
          interface BlockRenderLayer extends kotlin.Enum<net.minecraft.client.render.BlockRenderLayer> { 
            getPipeline(): com.mojang.blaze3d.pipeline.RenderPipeline;
            getBufferSize(): number;
            getName(): string;
            isTranslucent(): boolean;
            getTextureView(): com.mojang.blaze3d.textures.GpuTextureView;
          }
          const DimensionEffects: {
            Overworld: typeof net.minecraft.client.render.DimensionEffects$Overworld;
            Nether: typeof net.minecraft.client.render.DimensionEffects$Nether;
            End: typeof net.minecraft.client.render.DimensionEffects$End;
            SkyType: typeof net.minecraft.client.render.DimensionEffects$SkyType;
            byDimensionType(dimensionType: net.minecraft.world.dimension.DimensionType): net.minecraft.client.render.DimensionEffects;
            new(skyType: net.minecraft.client.render.DimensionEffects$SkyType, darkened: boolean, alternateSkyColor: boolean): net.minecraft.client.render.DimensionEffects;
          }
          interface DimensionEffects { 
            isSunRisingOrSetting(skyAngle: number): boolean;
            getSkyColor(skyAngle: number): number;
            adjustFogColor(color: net.minecraft.util.math.Vec3d, sunHeight: number): net.minecraft.util.math.Vec3d;
            useThickFog(camX: number, camY: number): boolean;
            getSkyType(): net.minecraft.client.render.DimensionEffects$SkyType;
            isDarkened(): boolean;
            hasAlternateSkyColor(): boolean;
          }
          const DimensionEffects$Overworld: {
            new(): net.minecraft.client.render.DimensionEffects$Overworld;
          }
          interface DimensionEffects$Overworld extends net.minecraft.client.render.DimensionEffects { 
          }
          const DimensionEffects$Nether: {
            new(): net.minecraft.client.render.DimensionEffects$Nether;
          }
          interface DimensionEffects$Nether extends net.minecraft.client.render.DimensionEffects { 
          }
          const DimensionEffects$End: {
            new(): net.minecraft.client.render.DimensionEffects$End;
          }
          interface DimensionEffects$End extends net.minecraft.client.render.DimensionEffects { 
          }
          const DimensionEffects$SkyType: {
            NONE: net.minecraft.client.render.DimensionEffects$SkyType;
            NORMAL: net.minecraft.client.render.DimensionEffects$SkyType;
            END: net.minecraft.client.render.DimensionEffects$SkyType;
            valueOf(value: string): net.minecraft.client.render.DimensionEffects$SkyType;
            values(): Array<net.minecraft.client.render.DimensionEffects$SkyType>;
          }
          interface DimensionEffects$SkyType extends kotlin.Enum<net.minecraft.client.render.DimensionEffects$SkyType> { 
          }
          const EndLightFlashManager: {
            field_62214: number;
            new(): net.minecraft.client.render.EndLightFlashManager;
          }
          interface EndLightFlashManager { 
            tick(time: number): void;
            getPitch(): number;
            getYaw(): number;
            getSkyFactor(tickProgress: number): number;
            shouldFlash(): boolean;
          }
          const Camera: {
            Projection: typeof net.minecraft.client.render.Camera$Projection;
            new(): net.minecraft.client.render.Camera;
          }
          interface Camera extends net.minecraft.world.waypoint.TrackedWaypoint$YawProvider { 
            update(area: net.minecraft.world.BlockView, focusedEntity: net.minecraft.entity.Entity, thirdPerson: boolean, inverseView: boolean, tickProgress: number): void;
            updateEyeHeight(): void;
            getPos(): net.minecraft.util.math.Vec3d;
            getBlockPos(): net.minecraft.util.math.BlockPos;
            getPitch(): number;
            getYaw(): number;
            getRotation(): org.joml.Quaternionf;
            getFocusedEntity(): net.minecraft.entity.Entity;
            isReady(): boolean;
            isThirdPerson(): boolean;
            getProjection(): net.minecraft.client.render.Camera$Projection;
            getSubmersionType(): net.minecraft.block.enums.CameraSubmersionType;
            getHorizontalPlane(): org.joml.Vector3f;
            getVerticalPlane(): org.joml.Vector3f;
            getDiagonalPlane(): org.joml.Vector3f;
            reset(): void;
            getLastTickProgress(): number;
          }
          interface Camera$Projection { 
            getBottomRight(): net.minecraft.util.math.Vec3d;
            getTopRight(): net.minecraft.util.math.Vec3d;
            getBottomLeft(): net.minecraft.util.math.Vec3d;
            getTopLeft(): net.minecraft.util.math.Vec3d;
            getPosition(factorX: number, factorY: number): net.minecraft.util.math.Vec3d;
          }
          const FrameGraphBuilder: {
            new(): net.minecraft.client.render.FrameGraphBuilder;
          }
          interface FrameGraphBuilder { 
            createPass(name: string): net.minecraft.client.render.FramePass;
            createObjectNode<T>(name: string, object: T): net.minecraft.client.util.Handle<T>;
            createResourceHandle<T>(name: string, factory: net.minecraft.client.util.ClosableFactory<T>): net.minecraft.client.util.Handle<T>;
            run(allocator: net.minecraft.client.util.ObjectAllocator): void;
            run(allocator: net.minecraft.client.util.ObjectAllocator, profiler: net.minecraft.client.render.FrameGraphBuilder$Profiler): void;
          }
          const FrameGraphBuilder$Profiler: {
            NONE: net.minecraft.client.render.FrameGraphBuilder$Profiler;
          }
          interface FrameGraphBuilder$Profiler { 
            acquire(name: string): void;
            release(name: string): void;
            push(location: string): void;
            pop(location: string): void;
          }
          interface FramePass { 
            addRequiredResource<T>(name: string, factory: net.minecraft.client.util.ClosableFactory<T>): net.minecraft.client.util.Handle<T>;
            dependsOn<T>(handle: net.minecraft.client.util.Handle<T>): void;
            transfer<T>(handle: net.minecraft.client.util.Handle<T>): net.minecraft.client.util.Handle<T>;
            addRequired(pass: net.minecraft.client.render.FramePass): void;
            markToBeVisited(): void;
            setRenderer(renderer: java.lang.Runnable): void;
          }
          const ProjectionMatrix2: {
            new(name: string, nearZ: number, farZ: number, invertY: boolean): net.minecraft.client.render.ProjectionMatrix2;
          }
          interface ProjectionMatrix2 extends java.lang.AutoCloseable { 
            set(width: number, height: number): com.mojang.blaze3d.buffers.GpuBufferSlice;
          }
          const Frustum: {
            RECESSION_SCALE: number;
            new(positionMatrix: org.joml.Matrix4f, projectionMatrix: org.joml.Matrix4f): net.minecraft.client.render.Frustum;
            new(frustum: net.minecraft.client.render.Frustum): net.minecraft.client.render.Frustum;
          }
          interface Frustum { 
            offset(f: number): net.minecraft.client.render.Frustum;
            coverBoxAroundSetPosition(boxSize: number): net.minecraft.client.render.Frustum;
            setPosition(cameraX: number, cameraY: number, cameraZ: number): void;
            isVisible(box: net.minecraft.util.math.Box): boolean;
            intersectAab(box: net.minecraft.util.math.BlockBox): number;
            intersectPoint(x: number, y: number, z: number): boolean;
            getBoundaryPoints(): Array<org.joml.Vector4f>;
            getX(): number;
            getY(): number;
            getZ(): number;
          }
          const MapRenderer: {
            DEFAULT_IMAGE_WIDTH: number;
            DEFAULT_IMAGE_HEIGHT: number;
            new(decorationsAtlasManager: net.minecraft.client.texture.AtlasManager, textureManager: net.minecraft.client.texture.MapTextureManager): net.minecraft.client.render.MapRenderer;
          }
          interface MapRenderer { 
            draw(state: net.minecraft.client.render.MapRenderState, matrices: net.minecraft.client.util.math.MatrixStack, queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, bl: boolean, light: number): void;
            update(mapId: net.minecraft.component.type.MapIdComponent, mapState: net.minecraft.item.map.MapState, renderState: net.minecraft.client.render.MapRenderState): void;
          }
          const RenderTickCounter: {
            Dynamic: typeof net.minecraft.client.render.RenderTickCounter$Dynamic;
            Constant: typeof net.minecraft.client.render.RenderTickCounter$Constant;
            ZERO: net.minecraft.client.render.RenderTickCounter;
            ONE: net.minecraft.client.render.RenderTickCounter;
          }
          interface RenderTickCounter { 
            getDynamicDeltaTicks(): number;
            getTickProgress(ignoreFreeze: boolean): number;
            getFixedDeltaTicks(): number;
          }
          const RenderTickCounter$Dynamic: {
            new(tps: number, timeMillis: number, targetMillisPerTick: it.unimi.dsi.fastutil.floats.FloatUnaryOperator): net.minecraft.client.render.RenderTickCounter$Dynamic;
          }
          interface RenderTickCounter$Dynamic extends net.minecraft.client.render.RenderTickCounter { 
            beginRenderTick(timeMillis: number, tick: boolean): number;
            tick(paused: boolean): void;
            setTickFrozen(tickFrozen: boolean): void;
          }
          interface RenderTickCounter$Constant extends net.minecraft.client.render.RenderTickCounter { 
          }
          const BufferBuilderStorage: {
            new(maxBlockBuildersPoolSize: number): net.minecraft.client.render.BufferBuilderStorage;
          }
          interface BufferBuilderStorage { 
            getBlockBufferBuilders(): net.minecraft.client.render.chunk.BlockBufferAllocatorStorage;
            getBlockBufferBuildersPool(): net.minecraft.client.render.chunk.BlockBufferBuilderPool;
            getEntityVertexConsumers(): net.minecraft.client.render.VertexConsumerProvider$Immediate;
            getEffectVertexConsumers(): net.minecraft.client.render.VertexConsumerProvider$Immediate;
            getOutlineVertexConsumers(): net.minecraft.client.render.OutlineVertexConsumerProvider;
          }
          const OutlineVertexConsumerProvider: {
            new(): net.minecraft.client.render.OutlineVertexConsumerProvider;
          }
          interface OutlineVertexConsumerProvider extends net.minecraft.client.render.VertexConsumerProvider { 
            setColor(red: number): void;
            draw(): void;
          }
          const WorldRenderer: {
            SECTION_SIZE: number;
            HALF_SECTION_SIZE: number;
            NEARBY_SECTION_DISTANCE: number;
            offsetFrustum(frustum: net.minecraft.client.render.Frustum): net.minecraft.client.render.Frustum;
            getLightmapCoordinates(world: net.minecraft.world.BlockRenderView, pos: net.minecraft.util.math.BlockPos): number;
            getLightmapCoordinates(brightnessGetter: net.minecraft.client.render.WorldRenderer$BrightnessGetter, world: net.minecraft.world.BlockRenderView, state: net.minecraft.block.BlockState, pos: net.minecraft.util.math.BlockPos): number;
            new(client: net.minecraft.client.MinecraftClient, entityRenderManager: net.minecraft.client.render.entity.EntityRenderManager, blockEntityRenderManager: net.minecraft.client.render.block.entity.BlockEntityRenderManager, bufferBuilders: net.minecraft.client.render.BufferBuilderStorage, worldRenderState: net.minecraft.client.render.state.WorldRenderState, entityRenderDispatcher: net.minecraft.client.render.command.RenderDispatcher): net.minecraft.client.render.WorldRenderer;
          }
          interface WorldRenderer extends net.minecraft.resource.SynchronousResourceReloader, java.lang.AutoCloseable { 
            debugRenderer: net.minecraft.client.render.debug.DebugRenderer;
            gameTestDebugRenderer: net.minecraft.client.render.debug.GameTestDebugRenderer;
            reload(): void;
            loadEntityOutlinePostProcessor(): void;
            drawEntityOutlinesFramebuffer(): void;
            setWorld(world: net.minecraft.client.world.ClientWorld | null | undefined): void;
            onResized(width: number, height: number): void;
            getChunksDebugString(): string | null | undefined;
            getChunkBuilder(): net.minecraft.client.render.chunk.ChunkBuilder | null | undefined;
            getChunkCount(): number;
            getViewDistance(): number;
            getCompletedChunkCount(): number;
            getEntitiesDebugString(): string | null | undefined;
            addBuiltChunk(chunk: net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk): void;
            render(allocator: net.minecraft.client.util.ObjectAllocator, tickCounter: net.minecraft.client.render.RenderTickCounter, renderBlockOutline: boolean, camera: net.minecraft.client.render.Camera, positionMatrix: org.joml.Matrix4f, matrix4f: org.joml.Matrix4f, projectionMatrix: org.joml.Matrix4f, fogBuffer: com.mojang.blaze3d.buffers.GpuBufferSlice, fogColor: org.joml.Vector4f, renderSky: boolean): void;
            rotate(): void;
            captureFrustum(): void;
            killFrustum(): void;
            tick(camera: net.minecraft.client.render.Camera): void;
            updateBlock(world: net.minecraft.world.BlockView, pos: net.minecraft.util.math.BlockPos, oldState: net.minecraft.block.BlockState, newState: net.minecraft.block.BlockState, flags: number): void;
            scheduleBlockRenders(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): void;
            scheduleBlockRerenderIfNeeded(pos: net.minecraft.util.math.BlockPos, old: net.minecraft.block.BlockState, updated: net.minecraft.block.BlockState): void;
            scheduleChunkRenders3x3x3(x: number, y: number, z: number): void;
            scheduleChunkRenders(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): void;
            scheduleChunkRender(chunkX: number, chunkY: number, chunkZ: number): void;
            onChunkUnload(sectionPos: number): void;
            setBlockBreakingInfo(entityId: number, pos: net.minecraft.util.math.BlockPos, stage: number): void;
            isTerrainRenderComplete(): boolean;
            scheduleNeighborUpdates(chunkPos: net.minecraft.util.math.ChunkPos): void;
            scheduleTerrainUpdate(): void;
            isRenderingReady(pos: net.minecraft.util.math.BlockPos): boolean;
            getEntityOutlinesFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getTranslucentFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getEntityFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getParticlesFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getWeatherFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getCloudsFramebuffer(): net.minecraft.client.gl.Framebuffer | null | undefined;
            getBuiltChunks(): it.unimi.dsi.fastutil.objects.ObjectArrayList<net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk>;
            getChunkRenderingDataPreparer(): net.minecraft.client.render.ChunkRenderingDataPreparer;
            getCapturedFrustum(): net.minecraft.client.render.Frustum | null | undefined;
            getCloudRenderer(): net.minecraft.client.render.CloudRenderer;
          }
          const WorldRenderer$BrightnessGetter: {
            DEFAULT: net.minecraft.client.render.WorldRenderer$BrightnessGetter;
          }
          interface WorldRenderer$BrightnessGetter { 
            packedBrightness(world: net.minecraft.world.BlockRenderView, pos: net.minecraft.util.math.BlockPos): number;
            (world: net.minecraft.world.BlockRenderView, pos: net.minecraft.util.math.BlockPos): number;
          }
          const ChunkRenderingDataPreparer: {
            ChunkInfo: typeof net.minecraft.client.render.ChunkRenderingDataPreparer$ChunkInfo;
            new(): net.minecraft.client.render.ChunkRenderingDataPreparer;
          }
          interface ChunkRenderingDataPreparer { 
            setStorage(storage: net.minecraft.client.render.BuiltChunkStorage | null | undefined): void;
            scheduleTerrainUpdate(): void;
            collectChunks(frustum: net.minecraft.client.render.Frustum, builtChunks: Array<net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk>, nearbyChunks: Array<net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk>): void;
            updateFrustum(): boolean;
            addNeighbors(chunkPos: net.minecraft.util.math.ChunkPos): void;
            schedulePropagationFrom(builtChunk: net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk): void;
            updateSectionOcclusionGraph(cullChunks: boolean, camera: net.minecraft.client.render.Camera, frustum: net.minecraft.client.render.Frustum, builtChunk: Array<net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk>, activeSections: it.unimi.dsi.fastutil.longs.LongOpenHashSet): void;
            getInfo(chunk: net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk): net.minecraft.client.render.ChunkRenderingDataPreparer$ChunkInfo | null | undefined;
            getOctree(): net.minecraft.client.render.chunk.Octree;
          }
          interface ChunkRenderingDataPreparer$ChunkInfo { 
            propagationLevel: number;
            hasDirection(ordinal: number): boolean;
          }
          const BuiltChunkStorage: {
            new(chunkBuilder: net.minecraft.client.render.chunk.ChunkBuilder, world: net.minecraft.world.World, viewDistance: number, worldRenderer: net.minecraft.client.render.WorldRenderer): net.minecraft.client.render.BuiltChunkStorage;
          }
          interface BuiltChunkStorage { 
            chunks: Array<net.minecraft.client.render.chunk.ChunkBuilder$BuiltChunk>;
            clear(): void;
            getViewDistance(): number;
            getWorld(): net.minecraft.world.HeightLimitView;
            updateCameraPosition(sectionPos: net.minecraft.util.math.ChunkSectionPos): void;
            getSectionPos(): net.minecraft.util.math.ChunkSectionPos;
            scheduleRebuild(x: number, y: number, z: number, important: boolean): void;
          }
          const CloudRenderer: {
            CloudCells: typeof net.minecraft.client.render.CloudRenderer$CloudCells;
            new(): net.minecraft.client.render.CloudRenderer;
          }
          interface CloudRenderer extends net.minecraft.resource.SinglePreparationResourceReloader<java.util.Optional<net.minecraft.client.render.CloudRenderer$CloudCells>>, java.lang.AutoCloseable { 
            renderClouds(color: number, mode: net.minecraft.client.option.CloudRenderMode, cloudHeight: number, cameraPos: net.minecraft.util.math.Vec3d, cloudPhase: number): void;
            scheduleTerrainUpdate(): void;
            rotate(): void;
          }
          const CloudRenderer$CloudCells: {
            new(ls: Array<number>, i: number, j: number): net.minecraft.client.render.CloudRenderer$CloudCells;
          }
          interface CloudRenderer$CloudCells extends java.lang.Record { 
            cells(): Array<number>;
            width(): number;
            height(): number;
          }
          const SubmittableBatch: {
            new(): net.minecraft.client.render.SubmittableBatch;
          }
          interface SubmittableBatch { 
            batch: Array<net.minecraft.client.render.Submittable>;
            onFrameEnd(): void;
            add(submittable: net.minecraft.client.render.Submittable): void;
            submit(queue: net.minecraft.client.render.command.OrderedRenderCommandQueueImpl, cameraRenderState: net.minecraft.client.render.state.CameraRenderState): void;
          }
          interface Submittable { 
            submit(queue: net.minecraft.client.render.command.OrderedRenderCommandQueue, cameraRenderState: net.minecraft.client.render.state.CameraRenderState): void;
            onFrameEnd(): void;
          }
          const GameRenderer: {
            field_49904: number;
            CAMERA_DEPTH: number;
            field_60107: number;
            getNightVisionStrength(entity: net.minecraft.entity.LivingEntity, tickProgress: number): number;
            new(client: net.minecraft.client.MinecraftClient, firstPersonHeldItemRenderer: net.minecraft.client.render.item.HeldItemRenderer, buffers: net.minecraft.client.render.BufferBuilderStorage, blockRenderManager: net.minecraft.client.render.block.BlockRenderManager): net.minecraft.client.render.GameRenderer;
          }
          interface GameRenderer extends net.minecraft.world.waypoint.TrackedWaypoint$PitchProvider, java.lang.AutoCloseable { 
            firstPersonRenderer: net.minecraft.client.render.item.HeldItemRenderer;
            getEntityRenderCommandQueue(): net.minecraft.client.render.command.OrderedRenderCommandQueueImpl;
            getEntityRenderDispatcher(): net.minecraft.client.render.command.RenderDispatcher;
            getEntityRenderStates(): net.minecraft.client.render.state.WorldRenderState;
            setBlockOutlineEnabled(blockOutlineEnabled: boolean): void;
            setRenderingPanorama(renderingPanorama: boolean): void;
            isRenderingPanorama(): boolean;
            clearPostProcessor(): void;
            togglePostProcessorEnabled(): void;
            onCameraEntitySet(entity: net.minecraft.entity.Entity | null | undefined): void;
            renderBlur(): void;
            preloadPrograms(factory: net.minecraft.resource.ResourceFactory): void;
            tick(): void;
            getPostProcessorId(): net.minecraft.util.Identifier | null | undefined;
            onResized(width: number, height: number): void;
            updateCrosshairTarget(tickProgress: number): void;
            getBasicProjectionMatrix(fovDegrees: number): org.joml.Matrix4f;
            getFarPlaneDistance(): number;
            render(tickCounter: net.minecraft.client.render.RenderTickCounter, tick: boolean): void;
            renderWorld(renderTickCounter: net.minecraft.client.render.RenderTickCounter): void;
            reset(): void;
            showFloatingItem(floatingItem: net.minecraft.item.ItemStack): void;
            getClient(): net.minecraft.client.MinecraftClient;
            getSkyDarkness(tickProgress: number): number;
            getViewDistanceBlocks(): number;
            getCamera(): net.minecraft.client.render.Camera;
            getLightmapTextureManager(): net.minecraft.client.render.LightmapTextureManager;
            getOverlayTexture(): net.minecraft.client.render.OverlayTexture;
            getGlobalSettings(): net.minecraft.client.gl.GlobalSettings;
            getDiffuseLighting(): net.minecraft.client.render.DiffuseLighting;
            setWorld(world: net.minecraft.client.world.ClientWorld | null | undefined): void;
            getRotatingPanoramaRenderer(): net.minecraft.client.gui.RotatingCubeMapRenderer;
          }
          const LightmapTextureManager: {
            MAX_LIGHT_COORDINATE: number;
            MAX_SKY_LIGHT_COORDINATE: number;
            MAX_BLOCK_LIGHT_COORDINATE: number;
            getBrightness(type: net.minecraft.world.dimension.DimensionType, lightLevel: number): number;
            getBrightness(ambientLight: number, lightLevel: number): number;
            pack(block: number, sky: number): number;
            getBlockLightCoordinates(light: number): number;
            getSkyLightCoordinates(light: number): number;
            applyEmission(light: number, lightEmission: number): number;
            new(renderer: net.minecraft.client.render.GameRenderer, client: net.minecraft.client.MinecraftClient): net.minecraft.client.render.LightmapTextureManager;
          }
          interface LightmapTextureManager extends java.lang.AutoCloseable { 
            getGlTextureView(): com.mojang.blaze3d.textures.GpuTextureView;
            tick(): void;
            disable(): void;
            enable(): void;
            update(tickProgress: number): void;
          }
          const OverlayTexture: {
            field_32953: number;
            field_32954: number;
            field_32955: number;
            DEFAULT_UV: number;
            getU(whiteOverlayProgress: number): number;
            getV(hurt: boolean): number;
            packUv(u: number, v: number): number;
            getUv(whiteOverlayProgress: number, hurt: boolean): number;
            new(): net.minecraft.client.render.OverlayTexture;
          }
          interface OverlayTexture extends java.lang.AutoCloseable { 
            setupOverlayColor(): void;
            teardownOverlayColor(): void;
          }
          const DiffuseLighting: {
            Type: typeof net.minecraft.client.render.DiffuseLighting$Type;
            UBO_SIZE: number;
            new(): net.minecraft.client.render.DiffuseLighting;
          }
          interface DiffuseLighting extends java.lang.AutoCloseable { 
            updateLevelBuffer(darkened: boolean): void;
            setShaderLights(type: net.minecraft.client.render.DiffuseLighting$Type): void;
          }
          const DiffuseLighting$Type: {
            LEVEL: net.minecraft.client.render.DiffuseLighting$Type;
            ITEMS_FLAT: net.minecraft.client.render.DiffuseLighting$Type;
            ITEMS_3D: net.minecraft.client.render.DiffuseLighting$Type;
            ENTITY_IN_UI: net.minecraft.client.render.DiffuseLighting$Type;
            PLAYER_SKIN: net.minecraft.client.render.DiffuseLighting$Type;
            valueOf(value: string): net.minecraft.client.render.DiffuseLighting$Type;
            values(): Array<net.minecraft.client.render.DiffuseLighting$Type>;
          }
          interface DiffuseLighting$Type extends kotlin.Enum<net.minecraft.client.render.DiffuseLighting$Type> { 
          }
        }
        namespace model {
          const Model: {
            SinglePartModel: typeof net.minecraft.client.model.Model$SinglePartModel;
            new<S>(root: net.minecraft.client.model.ModelPart, layerFactory: unknown): net.minecraft.client.model.Model<S>;
          }
          interface Model<S> { 
            getLayer(texture: net.minecraft.util.Identifier): net.minecraft.client.render.RenderLayer;
            render(matrices: net.minecraft.client.util.math.MatrixStack, vertices: net.minecraft.client.render.VertexConsumer, light: number, overlay: number, color: number): void;
            render(matrices: net.minecraft.client.util.math.MatrixStack, vertices: net.minecraft.client.render.VertexConsumer, light: number, overlay: number): void;
            getRootPart(): net.minecraft.client.model.ModelPart;
            getParts(): Array<net.minecraft.client.model.ModelPart>;
            setAngles(state: S): void;
            resetTransforms(): void;
          }
          const Model$SinglePartModel: {
            new(part: net.minecraft.client.model.ModelPart, layerFactory: unknown): net.minecraft.client.model.Model$SinglePartModel;
          }
          interface Model$SinglePartModel extends net.minecraft.client.model.Model<net.minecraft.util.Unit> { 
          }
          const ModelPart: {
            Cuboid: typeof net.minecraft.client.model.ModelPart$Cuboid;
            Quad: typeof net.minecraft.client.model.ModelPart$Quad;
            Vertex: typeof net.minecraft.client.model.ModelPart$Vertex;
            field_37937: number;
            new(cuboids: Array<net.minecraft.client.model.ModelPart$Cuboid>, children: Map<string, net.minecraft.client.model.ModelPart>): net.minecraft.client.model.ModelPart;
          }
          interface ModelPart { 
            originX: number;
            originY: number;
            originZ: number;
            pitch: number;
            yaw: number;
            roll: number;
            xScale: number;
            yScale: number;
            zScale: number;
            visible: boolean;
            hidden: boolean;
            getTransform(): net.minecraft.client.model.ModelTransform;
            getDefaultTransform(): net.minecraft.client.model.ModelTransform;
            setDefaultTransform(transform: net.minecraft.client.model.ModelTransform): void;
            resetTransform(): void;
            setTransform(transform: net.minecraft.client.model.ModelTransform): void;
            hasChild(child: string): boolean;
            getChild(name: string): net.minecraft.client.model.ModelPart;
            setOrigin(x: number, y: number, z: number): void;
            setAngles(pitch: number, yaw: number, roll: number): void;
            render(matrices: net.minecraft.client.util.math.MatrixStack, vertices: net.minecraft.client.render.VertexConsumer, light: number, overlay: number): void;
            render(matrices: net.minecraft.client.util.math.MatrixStack, vertices: net.minecraft.client.render.VertexConsumer, light: number, overlay: number, color: number): void;
            rotate(quaternion: org.joml.Quaternionf): void;
            rotate(vec3f: org.joml.Vector3f): void;
            collectVertices(matrices: net.minecraft.client.util.math.MatrixStack, vertices: Set<org.joml.Vector3f>): void;
            forEachCuboid(matrices: net.minecraft.client.util.math.MatrixStack, consumer: net.minecraft.client.model.ModelPart$CuboidConsumer): void;
            applyTransform(matrices: net.minecraft.client.util.math.MatrixStack): void;
            getRandomCuboid(random: net.minecraft.util.math.random.Random): net.minecraft.client.model.ModelPart$Cuboid;
            isEmpty(): boolean;
            moveOrigin(vec3f: org.joml.Vector3f): void;
            scale(vec3f: org.joml.Vector3f): void;
            traverse(): Array<net.minecraft.client.model.ModelPart>;
            createPartGetter(): unknown;
          }
          const ModelPart$Cuboid: {
            new(u: number, v: number, x: number, y: number, z: number, sizeX: number, sizeY: number, sizeZ: number, extraX: number, extraY: number, extraZ: number, mirror: boolean, textureWidth: number, textureHeight: number, sides: Set<net.minecraft.util.math.Direction>): net.minecraft.client.model.ModelPart$Cuboid;
          }
          interface ModelPart$Cuboid { 
            sides: Array<net.minecraft.client.model.ModelPart$Quad>;
            minX: number;
            minY: number;
            minZ: number;
            maxX: number;
            maxY: number;
            maxZ: number;
            renderCuboid(entry: net.minecraft.client.util.math.MatrixStack$Entry, vertexConsumer: net.minecraft.client.render.VertexConsumer, light: number, overlay: number, color: number): void;
          }
          const ModelPart$Quad: {
            new(vertices: Array<net.minecraft.client.model.ModelPart$Vertex>, u1: number, v1: number, u2: number, v2: number, squishU: number, squishV: number, flip: boolean, direction: net.minecraft.util.math.Direction): net.minecraft.client.model.ModelPart$Quad;
            new(vertexs: Array<net.minecraft.client.model.ModelPart$Vertex>, vector3fc: org.joml.Vector3fc): net.minecraft.client.model.ModelPart$Quad;
          }
          interface ModelPart$Quad extends java.lang.Record { 
            vertices(): Array<net.minecraft.client.model.ModelPart$Vertex>;
            direction(): org.joml.Vector3fc;
          }
          interface ModelPart$CuboidConsumer { 
            accept(matrix: net.minecraft.client.util.math.MatrixStack$Entry, path: string, index: number, cuboid: net.minecraft.client.model.ModelPart$Cuboid): void;
            (matrix: net.minecraft.client.util.math.MatrixStack$Entry, path: string, index: number, cuboid: net.minecraft.client.model.ModelPart$Cuboid): void;
          }
          const ModelPart$Vertex: {
            SCALE_FACTOR: number;
            new(f: number, g: number, h: number, i: number, j: number): net.minecraft.client.model.ModelPart$Vertex;
          }
          interface ModelPart$Vertex extends java.lang.Record { 
            remap(u: number, v: number): net.minecraft.client.model.ModelPart$Vertex;
            worldX(): number;
            worldY(): number;
            worldZ(): number;
            x(): number;
            y(): number;
            z(): number;
            u(): number;
            v(): number;
          }
          const ModelTransform: {
            NONE: net.minecraft.client.model.ModelTransform;
            origin(x: number, y: number, z: number): net.minecraft.client.model.ModelTransform;
            rotation(pitch: number, yaw: number, roll: number): net.minecraft.client.model.ModelTransform;
            of(originX: number, originY: number, originZ: number, pitch: number, yaw: number, roll: number): net.minecraft.client.model.ModelTransform;
            new(pivotX: number, pivotY: number, pivotZ: number, pitch: number, f: number, g: number, h: number, i: number, j: number): net.minecraft.client.model.ModelTransform;
          }
          interface ModelTransform extends java.lang.Record { 
            moveOrigin(x: number, y: number, z: number): net.minecraft.client.model.ModelTransform;
            withScale(scale: number): net.minecraft.client.model.ModelTransform;
            scaled(scale: number): net.minecraft.client.model.ModelTransform;
            scaled(xScale: number, yScale: number, zScale: number): net.minecraft.client.model.ModelTransform;
            x(): number;
            y(): number;
            z(): number;
            pitch(): number;
            yaw(): number;
            roll(): number;
            xScale(): number;
            yScale(): number;
            zScale(): number;
          }
          const Dilation: {
            NONE: net.minecraft.client.model.Dilation;
            new(radiusX: number, radiusY: number, radiusZ: number): net.minecraft.client.model.Dilation;
            new(radius: number): net.minecraft.client.model.Dilation;
          }
          interface Dilation { 
            add(radius: number): net.minecraft.client.model.Dilation;
            add(radiusX: number, radiusY: number, radiusZ: number): net.minecraft.client.model.Dilation;
          }
          const ModelData: {
            new(): net.minecraft.client.model.ModelData;
          }
          interface ModelData { 
            getRoot(): net.minecraft.client.model.ModelPartData;
            transform(transformer: unknown): net.minecraft.client.model.ModelData;
            transform(transformer: net.minecraft.client.render.entity.model.ModelTransformer): net.minecraft.client.model.ModelData;
          }
          interface ModelPartData { 
            addChild(name: string, builder: net.minecraft.client.model.ModelPartBuilder, transform: net.minecraft.client.model.ModelTransform): net.minecraft.client.model.ModelPartData;
            addChild(name: string, data: net.minecraft.client.model.ModelPartData): net.minecraft.client.model.ModelPartData;
            resetChildrenParts(): net.minecraft.client.model.ModelPartData;
            resetChildrenParts(name: string): net.minecraft.client.model.ModelPartData;
            resetChildrenExcept(names: Set<string>): void;
            resetChildrenExceptExact(names: Set<string>): void;
            createPart(textureWidth: number, textureHeight: number): net.minecraft.client.model.ModelPart;
            getChild(name: string): net.minecraft.client.model.ModelPartData;
            getChildren(): Set<kotlin.collections.MutableMap$MutableEntry<string, net.minecraft.client.model.ModelPartData>>;
            applyTransformer(transformer: unknown): net.minecraft.client.model.ModelPartData;
          }
          const ModelPartBuilder: {
            create(): net.minecraft.client.model.ModelPartBuilder;
            new(): net.minecraft.client.model.ModelPartBuilder;
          }
          interface ModelPartBuilder { 
            uv(textureX: number, textureY: number): net.minecraft.client.model.ModelPartBuilder;
            mirrored(): net.minecraft.client.model.ModelPartBuilder;
            mirrored(mirror: boolean): net.minecraft.client.model.ModelPartBuilder;
            cuboid(name: string, offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, extra: net.minecraft.client.model.Dilation, textureX: number, textureY: number): net.minecraft.client.model.ModelPartBuilder;
            cuboid(name: string, offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, textureX: number, textureY: number): net.minecraft.client.model.ModelPartBuilder;
            cuboid(offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number): net.minecraft.client.model.ModelPartBuilder;
            cuboid(offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, directions: Set<net.minecraft.util.math.Direction>): net.minecraft.client.model.ModelPartBuilder;
            cuboid(name: string, offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number): net.minecraft.client.model.ModelPartBuilder;
            cuboid(name: string, offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, extra: net.minecraft.client.model.Dilation): net.minecraft.client.model.ModelPartBuilder;
            cuboid(offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, mirror: boolean): net.minecraft.client.model.ModelPartBuilder;
            cuboid(offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, extra: net.minecraft.client.model.Dilation, textureScaleX: number, textureScaleY: number): net.minecraft.client.model.ModelPartBuilder;
            cuboid(offsetX: number, offsetY: number, offsetZ: number, sizeX: number, sizeY: number, sizeZ: number, extra: net.minecraft.client.model.Dilation): net.minecraft.client.model.ModelPartBuilder;
            build(): Array<unknown>;
          }
          const TexturedModelData: {
            of(partData: net.minecraft.client.model.ModelData, textureWidth: number, textureHeight: number): net.minecraft.client.model.TexturedModelData;
          }
          interface TexturedModelData { 
            transform(transformer: net.minecraft.client.render.entity.model.ModelTransformer): net.minecraft.client.model.TexturedModelData;
            createModel(): net.minecraft.client.model.ModelPart;
          }
        }
        namespace resource {
          namespace metadata {
            const TextureResourceMetadata: {
              field_32980: boolean;
              field_32981: boolean;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.resource.metadata.TextureResourceMetadata>;
              SERIALIZER: net.minecraft.resource.metadata.ResourceMetadataSerializer<net.minecraft.client.resource.metadata.TextureResourceMetadata>;
              new(blur: boolean, clamp: boolean): net.minecraft.client.resource.metadata.TextureResourceMetadata;
            }
            interface TextureResourceMetadata extends java.lang.Record { 
              blur(): boolean;
              clamp(): boolean;
            }
          }
          namespace server {
            const ServerResourcePackLoader: {
              new(client: net.minecraft.client.MinecraftClient, downloadsDirectory: java.nio.file.Path, runArgs: net.minecraft.client.RunArgs$Network): net.minecraft.client.resource.server.ServerResourcePackLoader;
            }
            interface ServerResourcePackLoader extends java.lang.AutoCloseable { 
              getPassthroughPackProvider(): net.minecraft.resource.ResourcePackProvider;
              onReloadFailure(): void;
              onForcedReloadFailure(): void;
              onReloadSuccess(): void;
              addResourcePack(id: java.util.UUID, url: java.net.URL, hash: string | null | undefined): void;
              addResourcePack(id: java.util.UUID, path: java.nio.file.Path): void;
              remove(id: java.util.UUID): void;
              removeAll(): void;
              init(connection: net.minecraft.network.ClientConnection, acceptanceStatus: net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus): void;
              initWorldPack(): void;
              acceptAll(): void;
              declineAll(): void;
              getPackLoadFuture(id: java.util.UUID): java.util.concurrent.CompletableFuture<java.lang.Void>;
              clear(): void;
            }
            const ServerResourcePackManager$AcceptanceStatus: {
              PENDING: net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus;
              ALLOWED: net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus;
              DECLINED: net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus;
              valueOf(value: string): net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus;
              values(): Array<net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus>;
            }
            interface ServerResourcePackManager$AcceptanceStatus extends kotlin.Enum<net.minecraft.client.resource.server.ServerResourcePackManager$AcceptanceStatus> { 
            }
          }
          namespace language {
            const LanguageManager: {
              new(languageCode: string, reloadCallback: unknown): net.minecraft.client.resource.language.LanguageManager;
            }
            interface LanguageManager extends net.minecraft.resource.SynchronousResourceReloader { 
              setLanguage(languageCode: string): void;
              getLanguage(): string;
              getLanguage(code: string): net.minecraft.client.resource.language.LanguageDefinition | null | undefined;
              getAllLanguages(): java.util.SortedMap<string, net.minecraft.client.resource.language.LanguageDefinition>;
            }
            const LanguageDefinition: {
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.resource.language.LanguageDefinition>;
              new(code: string, region: string, bl: boolean): net.minecraft.client.resource.language.LanguageDefinition;
            }
            interface LanguageDefinition extends java.lang.Record { 
              getDisplayText(): net.minecraft.text.Text;
              region(): string;
              name(): string;
              rightToLeft(): boolean;
            }
          }
          namespace waypoint {
            const WaypointStyleAssetManager: {
              new(): net.minecraft.client.resource.waypoint.WaypointStyleAssetManager;
            }
            interface WaypointStyleAssetManager extends net.minecraft.resource.JsonDataLoader<net.minecraft.client.resource.waypoint.WaypointStyleAsset> { 
              get(key: net.minecraft.registry.RegistryKey<unknown>): net.minecraft.client.resource.waypoint.WaypointStyleAsset;
            }
            const WaypointStyleAsset: {
              field_62050: string;
              DEFAULT_NEAR_DISTANCE: number;
              DEFAULT_FAR_DISTANCE: number;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.resource.waypoint.WaypointStyleAsset>;
              new(nearDistance: number, farDistance: number, sprites: Array<net.minecraft.util.Identifier>): net.minecraft.client.resource.waypoint.WaypointStyleAsset;
              new(i: number, j: number, list: Array<net.minecraft.util.Identifier>, list2: Array<net.minecraft.util.Identifier>): net.minecraft.client.resource.waypoint.WaypointStyleAsset;
            }
            interface WaypointStyleAsset extends java.lang.Record { 
              validate(): com.mojang.serialization.DataResult<net.minecraft.client.resource.waypoint.WaypointStyleAsset>;
              getSpriteForDistance(distance: number): net.minecraft.util.Identifier;
              nearDistance(): number;
              farDistance(): number;
              sprites(): Array<net.minecraft.util.Identifier>;
              spriteLocations(): Array<net.minecraft.util.Identifier>;
            }
          }
          const VideoWarningManager: {
            new(): net.minecraft.client.resource.VideoWarningManager;
          }
          interface VideoWarningManager extends net.minecraft.resource.SinglePreparationResourceReloader<unknown> { 
            hasWarning(): boolean;
            canWarn(): boolean;
            scheduleWarning(): void;
            acceptAfterWarnings(): void;
            cancelAfterWarnings(): void;
            shouldWarn(): boolean;
            hasCancelledAfterWarning(): boolean;
            reset(): void;
            getRendererWarning(): string | null | undefined;
            getVersionWarning(): string | null | undefined;
            getVendorWarning(): string | null | undefined;
            getWarningsAsString(): string | null | undefined;
          }
          const SplashTextResourceSupplier: {
            new(session: net.minecraft.client.session.Session): net.minecraft.client.resource.SplashTextResourceSupplier;
          }
          interface SplashTextResourceSupplier extends net.minecraft.resource.SinglePreparationResourceReloader<Array<string>> { 
            get(): net.minecraft.client.gui.screen.SplashTextRenderer | null | undefined;
          }
        }
        namespace particle {
          const BillboardParticleSubmittable$Buffers: {
            new(i: number, gpuBufferSlice: com.mojang.blaze3d.buffers.GpuBufferSlice, map: Map<unknown, unknown>): net.minecraft.client.particle.BillboardParticleSubmittable$Buffers;
          }
          interface BillboardParticleSubmittable$Buffers extends java.lang.Record { 
            indexCount(): number;
            dynamicTransforms(): com.mojang.blaze3d.buffers.GpuBufferSlice;
            layers(): Map<unknown, unknown>;
          }
          const ParticleManager: {
            new(world: net.minecraft.client.world.ClientWorld, spriteManager: net.minecraft.client.particle.ParticleSpriteManager): net.minecraft.client.particle.ParticleManager;
          }
          interface ParticleManager { 
            addEmitter(entity: net.minecraft.entity.Entity, parameters: net.minecraft.particle.ParticleEffect): void;
            addEmitter(entity: net.minecraft.entity.Entity, parameters: net.minecraft.particle.ParticleEffect, maxAge: number): void;
            addParticle(parameters: net.minecraft.particle.ParticleEffect, x: number, y: number, z: number, velocityX: number, velocityY: number, velocityZ: number): net.minecraft.client.particle.Particle | null | undefined;
            addParticle(particle: net.minecraft.client.particle.Particle): void;
            tick(): void;
            addToBatch(batch: net.minecraft.client.render.SubmittableBatch, frustum: net.minecraft.client.render.Frustum, camera: net.minecraft.client.render.Camera, tickProgress: number): void;
            setWorld(world: net.minecraft.client.world.ClientWorld | null | undefined): void;
            getDebugString(): string;
            clearParticles(): void;
          }
          const Particle: {
            DynamicAlpha: typeof net.minecraft.client.particle.Particle$DynamicAlpha;
            new(world: net.minecraft.client.world.ClientWorld, x: number, y: number, z: number, velocityX: number, velocityY: number, velocityZ: number): net.minecraft.client.particle.Particle;
          }
          interface Particle { 
            move(speed: number): net.minecraft.client.particle.Particle;
            move(dx: number, dy: number, dz: number): void;
            setVelocity(velocityX: number, velocityY: number, velocityZ: number): void;
            scale(scale: number): net.minecraft.client.particle.Particle;
            setMaxAge(maxAge: number): void;
            getMaxAge(): number;
            tick(): void;
            textureSheet(): net.minecraft.client.particle.ParticleTextureSheet;
            markDead(): void;
            setPos(x: number, y: number, z: number): void;
            isAlive(): boolean;
            getBoundingBox(): net.minecraft.util.math.Box;
            setBoundingBox(boundingBox: net.minecraft.util.math.Box): void;
            getGroup(): java.util.Optional<net.minecraft.particle.ParticleGroup>;
          }
          const Particle$DynamicAlpha: {
            OPAQUE: net.minecraft.client.particle.Particle$DynamicAlpha;
            new(f: number, g: number, h: number, i: number): net.minecraft.client.particle.Particle$DynamicAlpha;
          }
          interface Particle$DynamicAlpha extends java.lang.Record { 
            isOpaque(): boolean;
            getAlpha(age: number, maxAge: number, tickProgress: number): number;
            startAlpha(): number;
            endAlpha(): number;
            startAtNormalizedAge(): number;
            endAtNormalizedAge(): number;
          }
          const ParticleTextureSheet: {
            SINGLE_QUADS: net.minecraft.client.particle.ParticleTextureSheet;
            ITEM_PICKUP: net.minecraft.client.particle.ParticleTextureSheet;
            ELDER_GUARDIANS: net.minecraft.client.particle.ParticleTextureSheet;
            NO_RENDER: net.minecraft.client.particle.ParticleTextureSheet;
            new(string: string): net.minecraft.client.particle.ParticleTextureSheet;
          }
          interface ParticleTextureSheet extends java.lang.Record { 
            name(): string;
          }
          const ParticleSpriteManager: {
            new(): net.minecraft.client.particle.ParticleSpriteManager;
          }
          interface ParticleSpriteManager extends net.minecraft.resource.ResourceReloader { 
            setOnPreparedTask(onPreparedTask: java.lang.Runnable): void;
            getParticleFactories(): it.unimi.dsi.fastutil.ints.Int2ObjectMap<unknown>;
          }
        }
        namespace item {
          const ItemModelManager: {
            new(bakedModelManager: net.minecraft.client.render.model.BakedModelManager): net.minecraft.client.item.ItemModelManager;
          }
          interface ItemModelManager { 
            updateForLivingEntity(renderState: net.minecraft.client.render.item.ItemRenderState, stack: net.minecraft.item.ItemStack, displayContext: net.minecraft.item.ItemDisplayContext, entity: net.minecraft.entity.LivingEntity): void;
            updateForNonLivingEntity(renderState: net.minecraft.client.render.item.ItemRenderState, stack: net.minecraft.item.ItemStack, displayContext: net.minecraft.item.ItemDisplayContext, entity: net.minecraft.entity.Entity): void;
            clearAndUpdate(renderState: net.minecraft.client.render.item.ItemRenderState, stack: net.minecraft.item.ItemStack, displayContext: net.minecraft.item.ItemDisplayContext, world: net.minecraft.world.World | null | undefined, heldItemContext: net.minecraft.util.HeldItemContext | null | undefined, seed: number): void;
            update(renderState: net.minecraft.client.render.item.ItemRenderState, stack: net.minecraft.item.ItemStack, displayContext: net.minecraft.item.ItemDisplayContext, world: net.minecraft.world.World | null | undefined, heldItemContext: net.minecraft.util.HeldItemContext | null | undefined, seed: number): void;
            hasHandAnimationOnSwap(stack: net.minecraft.item.ItemStack): boolean;
          }
          const ItemAsset$Properties: {
            DEFAULT: net.minecraft.client.item.ItemAsset$Properties;
            CODEC: com.mojang.serialization.MapCodec<net.minecraft.client.item.ItemAsset$Properties>;
            new(bl: boolean, bl2: boolean): net.minecraft.client.item.ItemAsset$Properties;
          }
          interface ItemAsset$Properties extends java.lang.Record { 
            handAnimationOnSwap(): boolean;
            oversizedInGui(): boolean;
          }
        }
        namespace world {
          const ClientWorld: {
            Properties: typeof net.minecraft.client.world.ClientWorld$Properties;
            QUITTING_MULTIPLAYER_TEXT: net.minecraft.text.Text;
            new(networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler, properties: net.minecraft.client.world.ClientWorld$Properties, registryRef: net.minecraft.registry.RegistryKey<net.minecraft.world.World>, dimensionType: net.minecraft.registry.entry.RegistryEntry<net.minecraft.world.dimension.DimensionType>, loadDistance: number, simulationDistance: number, worldRenderer: net.minecraft.client.render.WorldRenderer, debugWorld: boolean, seed: number, seaLevel: number): net.minecraft.client.world.ClientWorld;
          }
          interface ClientWorld extends net.minecraft.world.World, net.minecraft.client.world.DataCache$CacheContext<net.minecraft.client.world.ClientWorld> { 
            tickEntity(entity: net.minecraft.entity.Entity): void;
            handlePlayerActionResponse(sequence: number): void;
            getBlockEntities(): Set<net.minecraft.block.entity.BlockEntity>;
            handleBlockUpdate(pos: net.minecraft.util.math.BlockPos, state: net.minecraft.block.BlockState, flags: number): void;
            processPendingUpdate(pos: net.minecraft.util.math.BlockPos, state: net.minecraft.block.BlockState, playerPos: net.minecraft.util.math.Vec3d): void;
            enqueueChunkUpdate(updater: java.lang.Runnable): void;
            runQueuedChunkUpdates(): void;
            getDimensionEffects(): net.minecraft.client.render.DimensionEffects;
            getEndLightFlashManager(): net.minecraft.client.render.EndLightFlashManager | null | undefined;
            tick(shouldKeepTicking: unknown): void;
            setTime(time: number, timeOfDay: number, shouldTickTimeOfDay: boolean): void;
            getEntities(): kotlin.collections.MutableIterable<net.minecraft.entity.Entity>;
            tickEntities(): void;
            hasEntity(entity: net.minecraft.entity.Entity): boolean;
            unloadBlockEntities(chunk: net.minecraft.world.chunk.WorldChunk): void;
            resetChunkColor(chunkPos: net.minecraft.util.math.ChunkPos): void;
            onChunkUnload(sectionPos: number): void;
            reloadColor(): void;
            getRegularEntityCount(): number;
            addEntity(entity: net.minecraft.entity.Entity): void;
            removeEntity(entityId: number, removalReason: net.minecraft.entity.Entity$RemovalReason): void;
            disconnect(reasonText: net.minecraft.text.Text): void;
            doRandomBlockDisplayTicks(centerX: number, centerY: number, centerZ: number): void;
            randomBlockDisplayTick(centerX: number, centerY: number, centerZ: number, radius: number, random: net.minecraft.util.math.random.Random, block: net.minecraft.block.Block | null | undefined, pos: net.minecraft.util.math.BlockPos$Mutable): void;
            putClientsideMapState(id: net.minecraft.component.type.MapIdComponent, state: net.minecraft.item.map.MapState): void;
            scheduleBlockRenders(x: number, y: number, z: number): void;
            scheduleChunkRenders(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): void;
            getSkyBrightness(tickProgress: number): number;
            getSkyColor(cameraPos: net.minecraft.util.math.Vec3d, tickProgress: number): number;
            getCloudsColor(tickProgress: number): number;
            getStarBrightness(tickProgress: number): number;
            getLightningTicksLeft(): number;
            calculateColor(pos: net.minecraft.util.math.BlockPos, colorResolver: net.minecraft.world.biome.ColorResolver): number;
            spawnBlockBreakingParticle(pos: net.minecraft.util.math.BlockPos, direction: net.minecraft.util.math.Direction): void;
            setSimulationDistance(simulationDistance: number): void;
            getSimulationDistance(): number;
            addBlockParticleEffects(center: net.minecraft.util.math.Vec3d, radius: number, blockCount: number, particles: net.minecraft.util.collection.Pool<unknown>): void;
          }
          interface DataCache$CacheContext<C> { 
            registerForCleaning(dataCache: net.minecraft.client.world.DataCache<C, any>): void;
            (dataCache: net.minecraft.client.world.DataCache<C, any>): void;
          }
          const DataCache: {
            new<C, D>(dataFunction: unknown): net.minecraft.client.world.DataCache<C, D>;
          }
          interface DataCache<C, D> { 
            compute(context: C): D;
            clean(): void;
          }
          const ClientWorld$Properties: {
            new(difficulty: net.minecraft.world.Difficulty, hardcore: boolean, flatWorld: boolean): net.minecraft.client.world.ClientWorld$Properties;
          }
          interface ClientWorld$Properties extends net.minecraft.world.MutableWorldProperties { 
            setTime(time: number): void;
            setTimeOfDay(timeOfDay: number): void;
            setDifficulty(difficulty: net.minecraft.world.Difficulty): void;
            setDifficultyLocked(difficultyLocked: boolean): void;
            getSkyDarknessHeight(world: net.minecraft.world.HeightLimitView): number;
            getVoidDarknessRange(): number;
          }
          const ClientChunkManager: {
            ClientChunkMap: typeof net.minecraft.client.world.ClientChunkManager$ClientChunkMap;
            new(world: net.minecraft.client.world.ClientWorld, loadDistance: number): net.minecraft.client.world.ClientChunkManager;
          }
          interface ClientChunkManager extends net.minecraft.world.chunk.ChunkManager { 
            unload(pos: net.minecraft.util.math.ChunkPos): void;
            onChunkBiomeData(x: number, z: number, buf: net.minecraft.network.PacketByteBuf): void;
            loadChunkFromPacket(x: number, z: number, buf: net.minecraft.network.PacketByteBuf, heightmaps: Map<net.minecraft.world.Heightmap$Type, Array<number>>, consumer: unknown): net.minecraft.world.chunk.WorldChunk | null | undefined;
            setChunkMapCenter(x: number, z: number): void;
            updateLoadDistance(loadDistance: number): void;
            getActiveSections(): it.unimi.dsi.fastutil.longs.LongOpenHashSet;
          }
          interface ClientChunkManager$ClientChunkMap { 
            onSectionStatusChanged(x: number, sectionY: number, z: number, previouslyEmpty: boolean): void;
          }
          const GeneratorOptionsHolder: {
            new(worldGenSettings: net.minecraft.world.level.WorldGenSettings, combinedDynamicRegistries: net.minecraft.registry.CombinedDynamicRegistries<unknown>, dataPackContents: net.minecraft.server.DataPackContents, dataConfiguration: net.minecraft.resource.DataConfiguration): net.minecraft.client.world.GeneratorOptionsHolder;
            new(generatorOptions: net.minecraft.world.gen.GeneratorOptions, selectedDimensions: net.minecraft.world.dimension.DimensionOptionsRegistryHolder, combinedDynamicRegistries: net.minecraft.registry.CombinedDynamicRegistries<unknown>, dataPackContents: net.minecraft.server.DataPackContents, dataConfiguration: net.minecraft.resource.DataConfiguration, initialWorldOptions: net.minecraft.client.gui.screen.world.InitialWorldOptions): net.minecraft.client.world.GeneratorOptionsHolder;
            new(generatorOptions: net.minecraft.world.gen.GeneratorOptions, registry: net.minecraft.registry.Registry<net.minecraft.world.dimension.DimensionOptions>, dimensionOptionsRegistryHolder: net.minecraft.world.dimension.DimensionOptionsRegistryHolder, combinedDynamicRegistries: net.minecraft.registry.CombinedDynamicRegistries<unknown>, dataPackContents: net.minecraft.server.DataPackContents, dataConfiguration: net.minecraft.resource.DataConfiguration, initialWorldOptions: net.minecraft.client.gui.screen.world.InitialWorldOptions): net.minecraft.client.world.GeneratorOptionsHolder;
          }
          interface GeneratorOptionsHolder extends java.lang.Record { 
            apply(modifier: net.minecraft.client.world.GeneratorOptionsHolder$Modifier): net.minecraft.client.world.GeneratorOptionsHolder;
            apply(modifier: net.minecraft.client.world.GeneratorOptionsHolder$RegistryAwareModifier): net.minecraft.client.world.GeneratorOptionsHolder;
            getCombinedRegistryManager(): net.minecraft.registry.DynamicRegistryManager$Immutable;
            initializeIndexedFeaturesLists(): void;
            generatorOptions(): net.minecraft.world.gen.GeneratorOptions;
            dimensionOptionsRegistry(): net.minecraft.registry.Registry<net.minecraft.world.dimension.DimensionOptions>;
            selectedDimensions(): net.minecraft.world.dimension.DimensionOptionsRegistryHolder;
            combinedDynamicRegistries(): net.minecraft.registry.CombinedDynamicRegistries<unknown>;
            dataPackContents(): net.minecraft.server.DataPackContents;
            dataConfiguration(): net.minecraft.resource.DataConfiguration;
            initialWorldCreationOptions(): net.minecraft.client.gui.screen.world.InitialWorldOptions;
          }
          interface GeneratorOptionsHolder$RegistryAwareModifier { 
          }
          interface GeneratorOptionsHolder$Modifier { 
          }
          const ClientChunkLoadProgress: {
            WAIT_UNTIL_READY_MILLIS: number;
            new(): net.minecraft.client.world.ClientChunkLoadProgress;
            new(l: number): net.minecraft.client.world.ClientChunkLoadProgress;
          }
          interface ClientChunkLoadProgress extends net.minecraft.world.chunk.ChunkLoadProgress { 
            setChunkLoadMap(map: net.minecraft.world.chunk.ChunkLoadMap): void;
            startWorldLoading(player: net.minecraft.client.network.ClientPlayerEntity, world: net.minecraft.client.world.ClientWorld, renderer: net.minecraft.client.render.WorldRenderer): void;
            tick(): void;
            isDone(): boolean;
            initialChunksComing(): void;
            getChunkLoadMap(): net.minecraft.world.chunk.ChunkLoadMap | null | undefined;
            getLoadProgress(): number;
            hasProgress(): boolean;
          }
          const ClientWaypointHandler: {
            new(): net.minecraft.client.world.ClientWaypointHandler;
          }
          interface ClientWaypointHandler extends net.minecraft.world.waypoint.TrackedWaypointHandler { 
            hasWaypoint(): boolean;
            forEachWaypoint(receiver: net.minecraft.entity.Entity, action: unknown): void;
          }
        }
        namespace network {
          namespace message {
            const MessageHandler: {
              new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.network.message.MessageHandler;
            }
            interface MessageHandler { 
              processDelayedMessages(): void;
              setChatDelay(chatDelay: number): void;
              process(): void;
              getUnprocessedMessageCount(): number;
              processAll(): void;
              removeDelayedMessage(signature: net.minecraft.network.message.MessageSignatureData): boolean;
              onChatMessage(message: net.minecraft.network.message.SignedMessage, sender: com.mojang.authlib.GameProfile, params: net.minecraft.network.message.MessageType$Parameters): void;
              onUnverifiedMessage(sender: java.util.UUID, signature: net.minecraft.network.message.MessageSignatureData | null | undefined, parameters: net.minecraft.network.message.MessageType$Parameters): void;
              onProfilelessMessage(content: net.minecraft.text.Text, params: net.minecraft.network.message.MessageType$Parameters): void;
              onGameMessage(message: net.minecraft.text.Text, overlay: boolean): void;
            }
          }
          const ClientPlayNetworkHandler: {
            field_54852: number;
            new(client: net.minecraft.client.MinecraftClient, clientConnection: net.minecraft.network.ClientConnection, clientConnectionState: net.minecraft.client.network.ClientConnectionState): net.minecraft.client.network.ClientPlayNetworkHandler;
          }
          interface ClientPlayNetworkHandler extends net.minecraft.client.network.ClientCommonNetworkHandler, net.minecraft.network.listener.ClientPlayPacketListener, net.minecraft.network.listener.TickablePacketListener { 
            getCommandSource(): net.minecraft.client.network.ClientCommandSource;
            unloadWorld(): void;
            clearWorld(): void;
            getRecipeManager(): net.minecraft.recipe.RecipeManager;
            getConnection(): net.minecraft.network.ClientConnection;
            getListedPlayerListEntries(): Array<net.minecraft.client.network.PlayerListEntry>;
            getPlayerList(): Array<net.minecraft.client.network.PlayerListEntry>;
            getPlayerUuids(): Array<java.util.UUID>;
            getPlayerListEntry(uuid: java.util.UUID): net.minecraft.client.network.PlayerListEntry | null | undefined;
            getPlayerListEntry(profileName: string): net.minecraft.client.network.PlayerListEntry | null | undefined;
            getSeenPlayers(): Map<java.util.UUID, net.minecraft.client.network.PlayerListEntry>;
            getCaseInsensitivePlayerInfo(name: string): net.minecraft.client.network.PlayerListEntry | null | undefined;
            getProfile(): com.mojang.authlib.GameProfile;
            getAdvancementHandler(): net.minecraft.client.network.ClientAdvancementManager;
            getCommandDispatcher(): com.mojang.brigadier.CommandDispatcher<net.minecraft.client.network.ClientCommandSource>;
            getWorld(): net.minecraft.client.world.ClientWorld;
            getDataQueryHandler(): net.minecraft.client.network.DataQueryHandler;
            getSessionId(): java.util.UUID;
            getWorldKeys(): Set<net.minecraft.registry.RegistryKey<net.minecraft.world.World>>;
            getRegistryManager(): net.minecraft.registry.DynamicRegistryManager$Immutable;
            acknowledge(signature: net.minecraft.network.message.MessageSignatureData, displayed: boolean): void;
            sendChatMessage(content: string): void;
            sendChatCommand(command: string): void;
            runClickEventCommand(command: string, afterActionScreen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
            syncOptions(syncedOptions: net.minecraft.network.packet.c2s.common.SyncedClientOptions): void;
            fetchProfileKey(): void;
            getServerInfo(): net.minecraft.client.network.ServerInfo | null | undefined;
            getEnabledFeatures(): net.minecraft.resource.featuretoggle.FeatureSet;
            hasFeature(feature: net.minecraft.resource.featuretoggle.FeatureSet): boolean;
            getScoreboard(): net.minecraft.scoreboard.Scoreboard;
            getBrewingRecipeRegistry(): net.minecraft.recipe.BrewingRecipeRegistry;
            getFuelRegistry(): net.minecraft.item.FuelRegistry;
            refreshSearchManager(): void;
            getSearchManager(): net.minecraft.client.search.SearchManager;
            registerForCleaning(dataCache: net.minecraft.client.world.DataCache<any, any>): void;
            getComponentHasher(): net.minecraft.screen.sync.ComponentChangesHash$ComponentHasher;
            getWaypointHandler(): net.minecraft.client.world.ClientWaypointHandler;
            getDebugDataStore(): net.minecraft.world.debug.DebugDataStore;
          }
          interface ClientCommonNetworkHandler extends net.minecraft.network.listener.ClientCommonPacketListener { 
            getServerLinks(): net.minecraft.server.ServerLinks;
            showDialog(dialog: net.minecraft.registry.entry.RegistryEntry<unknown>, previousScreen: net.minecraft.client.gui.screen.Screen | null | undefined): void;
            clearDialog(): void;
            sendPacket(packet: net.minecraft.network.packet.Packet<any>): void;
            getBrand(): string | null | undefined;
          }
          const ServerInfo: {
            ServerType: typeof net.minecraft.client.network.ServerInfo$ServerType;
            Status: typeof net.minecraft.client.network.ServerInfo$Status;
            ResourcePackPolicy: typeof net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            fromNbt(root: net.minecraft.nbt.NbtCompound): net.minecraft.client.network.ServerInfo;
            validateFavicon(favicon: Array<number>): Array<number>;
            new(name: string, address: string, serverType: net.minecraft.client.network.ServerInfo$ServerType): net.minecraft.client.network.ServerInfo;
          }
          interface ServerInfo { 
            name: string;
            address: string;
            playerCountLabel: net.minecraft.text.Text;
            label: net.minecraft.text.Text;
            players: net.minecraft.server.ServerMetadata$Players | null | undefined;
            ping: number;
            protocolVersion: number;
            version: net.minecraft.text.Text;
            playerListSummary: Array<net.minecraft.text.Text>;
            toNbt(): net.minecraft.nbt.NbtCompound;
            getResourcePackPolicy(): net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            setResourcePackPolicy(resourcePackPolicy: net.minecraft.client.network.ServerInfo$ResourcePackPolicy): void;
            getFavicon(): Array<number>;
            setFavicon(favicon: Array<number>): void;
            isLocal(): boolean;
            isRealm(): boolean;
            getServerType(): net.minecraft.client.network.ServerInfo$ServerType;
            hasAcceptedCodeOfConduct(codeOfConductText: string): boolean;
            setAcceptedCodeOfConduct(codeOfConductText: string): void;
            resetAcceptedCodeOfConduct(): void;
            copyFrom(serverInfo: net.minecraft.client.network.ServerInfo): void;
            copyWithSettingsFrom(serverInfo: net.minecraft.client.network.ServerInfo): void;
            getStatus(): net.minecraft.client.network.ServerInfo$Status;
            setStatus(status: net.minecraft.client.network.ServerInfo$Status): void;
          }
          const ServerInfo$ServerType: {
            LAN: net.minecraft.client.network.ServerInfo$ServerType;
            REALM: net.minecraft.client.network.ServerInfo$ServerType;
            OTHER: net.minecraft.client.network.ServerInfo$ServerType;
            valueOf(value: string): net.minecraft.client.network.ServerInfo$ServerType;
            values(): Array<net.minecraft.client.network.ServerInfo$ServerType>;
          }
          interface ServerInfo$ServerType extends kotlin.Enum<net.minecraft.client.network.ServerInfo$ServerType> { 
          }
          const ServerInfo$Status: {
            INITIAL: net.minecraft.client.network.ServerInfo$Status;
            PINGING: net.minecraft.client.network.ServerInfo$Status;
            UNREACHABLE: net.minecraft.client.network.ServerInfo$Status;
            INCOMPATIBLE: net.minecraft.client.network.ServerInfo$Status;
            SUCCESSFUL: net.minecraft.client.network.ServerInfo$Status;
            valueOf(value: string): net.minecraft.client.network.ServerInfo$Status;
            values(): Array<net.minecraft.client.network.ServerInfo$Status>;
          }
          interface ServerInfo$Status extends kotlin.Enum<net.minecraft.client.network.ServerInfo$Status> { 
          }
          const ServerInfo$ResourcePackPolicy: {
            ENABLED: net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            DISABLED: net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            PROMPT: net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            CODEC: com.mojang.serialization.MapCodec<net.minecraft.client.network.ServerInfo$ResourcePackPolicy>;
            valueOf(value: string): net.minecraft.client.network.ServerInfo$ResourcePackPolicy;
            values(): Array<net.minecraft.client.network.ServerInfo$ResourcePackPolicy>;
          }
          interface ServerInfo$ResourcePackPolicy extends kotlin.Enum<net.minecraft.client.network.ServerInfo$ResourcePackPolicy> { 
            getName(): net.minecraft.text.Text;
          }
          const AbstractClientPlayerEntity: {
            new(world: net.minecraft.client.world.ClientWorld, profile: com.mojang.authlib.GameProfile): net.minecraft.client.network.AbstractClientPlayerEntity;
          }
          interface AbstractClientPlayerEntity extends net.minecraft.entity.player.PlayerEntity, net.minecraft.client.network.ClientPlayerLikeEntity { 
            getFovMultiplier(firstPerson: boolean, fovEffectScale: number): number;
          }
          interface ClientPlayerLikeEntity { 
            getState(): net.minecraft.client.network.ClientPlayerLikeState;
            getSkin(): net.minecraft.entity.player.SkinTextures;
            getMannequinName(): net.minecraft.text.Text | null | undefined;
            getShoulderParrotVariant(leftShoulder: boolean): net.minecraft.entity.passive.ParrotEntity$Variant | null | undefined;
            hasExtraEars(): boolean;
          }
          const ClientPlayerLikeState: {
            new(): net.minecraft.client.network.ClientPlayerLikeState;
          }
          interface ClientPlayerLikeState { 
            tick(pos: net.minecraft.util.math.Vec3d, velocity: net.minecraft.util.math.Vec3d): void;
            addDistanceMoved(distanceMoved: number): void;
            getVelocity(): net.minecraft.util.math.Vec3d;
            lerpX(tickProgress: number): number;
            lerpY(tickProgress: number): number;
            lerpZ(tickProgress: number): number;
            tickMovement(movement: number): void;
            tickRiding(): void;
            lerpMovement(tickProgress: number): number;
            getReverseLerpedDistanceMoved(tickProgress: number): number;
            getLerpedDistanceMoved(tickProgress: number): number;
          }
          const PlayerListEntry: {
            new(profile: com.mojang.authlib.GameProfile, secureChatEnforced: boolean): net.minecraft.client.network.PlayerListEntry;
          }
          interface PlayerListEntry { 
            getProfile(): com.mojang.authlib.GameProfile;
            getSession(): net.minecraft.network.encryption.PublicPlayerSession | null | undefined;
            getMessageVerifier(): net.minecraft.network.message.MessageVerifier;
            hasPublicKey(): boolean;
            getGameMode(): net.minecraft.world.GameMode;
            getLatency(): number;
            getSkinTextures(): net.minecraft.entity.player.SkinTextures;
            getScoreboardTeam(): net.minecraft.scoreboard.Team | null | undefined;
            setDisplayName(displayName: net.minecraft.text.Text | null | undefined): void;
            getDisplayName(): net.minecraft.text.Text | null | undefined;
            setShowHat(showHat: boolean): void;
            shouldShowHat(): boolean;
            setListOrder(listOrder: number): void;
            getListOrder(): number;
          }
          const ClientPlayerEntity: {
            LOGGER: org.slf4j.Logger;
            field_55135: number;
            new(client: net.minecraft.client.MinecraftClient, world: net.minecraft.client.world.ClientWorld, networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler, stats: net.minecraft.stat.StatHandler, recipeBook: net.minecraft.client.recipebook.ClientRecipeBook, lastPlayerInput: net.minecraft.util.PlayerInput, lastSprinting: boolean): net.minecraft.client.network.ClientPlayerEntity;
          }
          interface ClientPlayerEntity extends net.minecraft.client.network.AbstractClientPlayerEntity { 
            networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler;
            input: net.minecraft.client.input.Input;
            experienceBarDisplayStartTime: number;
            renderYaw: number;
            renderPitch: number;
            lastRenderYaw: number;
            lastRenderPitch: number;
            nauseaIntensity: number;
            lastNauseaIntensity: number;
            getMoodPercentage(): number;
            dropSelectedItem(entireStack: boolean): boolean;
            closeScreen(): void;
            updateHealth(health: number): void;
            openRidingInventory(): void;
            getStatHandler(): net.minecraft.stat.StatHandler;
            getRecipeBook(): net.minecraft.client.recipebook.ClientRecipeBook;
            onRecipeDisplayed(recipeId: net.minecraft.recipe.NetworkRecipeId): void;
            setClientPermissionLevel(clientPermissionLevel: number): void;
            setExperience(progress: number, total: number, level: number): void;
            setShowsDeathScreen(showsDeathScreen: boolean): void;
            showsDeathScreen(): boolean;
            setLimitedCraftingEnabled(limitedCraftingEnabled: boolean): void;
            isLimitedCraftingEnabled(): boolean;
            getJumpingMount(): net.minecraft.entity.JumpingMount | null | undefined;
            getMountJumpStrength(): number;
            shouldSlowDown(): boolean;
            init(): void;
            getCurrentPortalEffect(): net.minecraft.block.Portal$Effect;
            isRiding(): boolean;
            isAutoJumpEnabled(): boolean;
            getUnderwaterVisibility(): number;
            onGameModeChanged(gameMode: net.minecraft.world.GameMode): void;
            getItemDropCooldown(): net.minecraft.util.Cooldown;
            getLastPlayerInput(): net.minecraft.util.PlayerInput;
          }
          const SocialInteractionsManager: {
            new(client: net.minecraft.client.MinecraftClient, userApiService: com.mojang.authlib.minecraft.UserApiService): net.minecraft.client.network.SocialInteractionsManager;
          }
          interface SocialInteractionsManager { 
            hidePlayer(uuid: java.util.UUID): void;
            showPlayer(uuid: java.util.UUID): void;
            isPlayerMuted(uuid: java.util.UUID): boolean;
            isPlayerHidden(uuid: java.util.UUID): boolean;
            loadBlockList(): void;
            unloadBlockList(): void;
            isPlayerBlocked(uuid: java.util.UUID): boolean;
            getHiddenPlayers(): Set<java.util.UUID>;
            getUuid(playerName: string): java.util.UUID;
            setPlayerOnline(player: net.minecraft.client.network.PlayerListEntry): void;
            setPlayerOffline(uuid: java.util.UUID): void;
          }
          const ClientPlayerInteractionManager: {
            new(client: net.minecraft.client.MinecraftClient, networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler): net.minecraft.client.network.ClientPlayerInteractionManager;
          }
          interface ClientPlayerInteractionManager { 
            copyAbilities(player: net.minecraft.entity.player.PlayerEntity): void;
            setGameModes(gameMode: net.minecraft.world.GameMode, previousGameMode: net.minecraft.world.GameMode | null | undefined): void;
            setGameMode(gameMode: net.minecraft.world.GameMode): void;
            hasStatusBars(): boolean;
            breakBlock(pos: net.minecraft.util.math.BlockPos): boolean;
            attackBlock(pos: net.minecraft.util.math.BlockPos, direction: net.minecraft.util.math.Direction): boolean;
            cancelBlockBreaking(): void;
            updateBlockBreakingProgress(pos: net.minecraft.util.math.BlockPos, direction: net.minecraft.util.math.Direction): boolean;
            tick(): void;
            interactBlock(player: net.minecraft.client.network.ClientPlayerEntity, hand: net.minecraft.util.Hand, hitResult: net.minecraft.util.hit.BlockHitResult): net.minecraft.util.ActionResult;
            interactItem(player: net.minecraft.entity.player.PlayerEntity, hand: net.minecraft.util.Hand): net.minecraft.util.ActionResult;
            createPlayer(world: net.minecraft.client.world.ClientWorld, statHandler: net.minecraft.stat.StatHandler, recipeBook: net.minecraft.client.recipebook.ClientRecipeBook): net.minecraft.client.network.ClientPlayerEntity;
            createPlayer(world: net.minecraft.client.world.ClientWorld, statHandler: net.minecraft.stat.StatHandler, recipeBook: net.minecraft.client.recipebook.ClientRecipeBook, lastPlayerInput: net.minecraft.util.PlayerInput, lastSprinting: boolean): net.minecraft.client.network.ClientPlayerEntity;
            attackEntity(player: net.minecraft.entity.player.PlayerEntity, target: net.minecraft.entity.Entity): void;
            interactEntity(player: net.minecraft.entity.player.PlayerEntity, entity: net.minecraft.entity.Entity, hand: net.minecraft.util.Hand): net.minecraft.util.ActionResult;
            interactEntityAtLocation(player: net.minecraft.entity.player.PlayerEntity, entity: net.minecraft.entity.Entity, hitResult: net.minecraft.util.hit.EntityHitResult, hand: net.minecraft.util.Hand): net.minecraft.util.ActionResult;
            clickSlot(syncId: number, slotId: number, button: number, actionType: net.minecraft.screen.slot.SlotActionType, player: net.minecraft.entity.player.PlayerEntity): void;
            clickRecipe(syncId: number, recipeId: net.minecraft.recipe.NetworkRecipeId, craftAll: boolean): void;
            clickButton(syncId: number, buttonId: number): void;
            clickCreativeStack(stack: net.minecraft.item.ItemStack, slotId: number): void;
            dropCreativeStack(stack: net.minecraft.item.ItemStack): void;
            stopUsingItem(player: net.minecraft.entity.player.PlayerEntity): void;
            hasExperienceBar(): boolean;
            hasLimitedAttackSpeed(): boolean;
            hasRidingInventory(): boolean;
            isFlyingLocked(): boolean;
            getPreviousGameMode(): net.minecraft.world.GameMode | null | undefined;
            getCurrentGameMode(): net.minecraft.world.GameMode;
            isBreakingBlock(): boolean;
            getBlockBreakingProgress(): number;
            pickItemFromBlock(pos: net.minecraft.util.math.BlockPos, includeData: boolean): void;
            pickItemFromEntity(entity: net.minecraft.entity.Entity, includeData: boolean): void;
            slotChangedState(slot: number, screenHandlerId: number, newState: boolean): void;
          }
          const ClientConnectionState: {
            new(clientChunkLoadProgress: net.minecraft.client.world.ClientChunkLoadProgress, gameProfile: com.mojang.authlib.GameProfile, worldSession: net.minecraft.client.session.telemetry.WorldSession, immutable: net.minecraft.registry.DynamicRegistryManager$Immutable, featureSet: net.minecraft.resource.featuretoggle.FeatureSet, string: string | null | undefined, serverInfo: net.minecraft.client.network.ServerInfo | null | undefined, screen: net.minecraft.client.gui.screen.Screen | null | undefined, map: Map<net.minecraft.util.Identifier, Array<number>>, chatState: net.minecraft.client.gui.hud.ChatHud$ChatState | null | undefined, map2: Map<string, string>, serverLinks: net.minecraft.server.ServerLinks, map3: Map<java.util.UUID, net.minecraft.client.network.PlayerListEntry>, bl: boolean): net.minecraft.client.network.ClientConnectionState;
          }
          interface ClientConnectionState extends java.lang.Record { 
            chunkLoadProgress(): net.minecraft.client.world.ClientChunkLoadProgress;
            localGameProfile(): com.mojang.authlib.GameProfile;
            worldSession(): net.minecraft.client.session.telemetry.WorldSession;
            receivedRegistries(): net.minecraft.registry.DynamicRegistryManager$Immutable;
            enabledFeatures(): net.minecraft.resource.featuretoggle.FeatureSet;
            serverBrand(): string | null | undefined;
            serverInfo(): net.minecraft.client.network.ServerInfo | null | undefined;
            postDisconnectScreen(): net.minecraft.client.gui.screen.Screen | null | undefined;
            serverCookies(): Map<net.minecraft.util.Identifier, Array<number>>;
            chatState(): net.minecraft.client.gui.hud.ChatHud$ChatState | null | undefined;
            customReportDetails(): Map<string, string>;
            serverLinks(): net.minecraft.server.ServerLinks;
            seenPlayers(): Map<java.util.UUID, net.minecraft.client.network.PlayerListEntry>;
            seenInsecureChatWarning(): boolean;
          }
          const ClientCommandSource: {
            new(networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler, client: net.minecraft.client.MinecraftClient, elevatedPermissions: boolean): net.minecraft.client.network.ClientCommandSource;
          }
          interface ClientCommandSource extends net.minecraft.command.PermissionLevelSource, net.minecraft.command.CommandSource { 
            onCommandSuggestions(completionId: number, suggestions: com.mojang.brigadier.suggestion.Suggestions): void;
            onChatSuggestions(action: net.minecraft.network.packet.s2c.play.ChatSuggestionsS2CPacket$Action, suggestions: Array<string>): void;
            isTrusted(): boolean;
          }
          const ClientAdvancementManager: {
            new(client: net.minecraft.client.MinecraftClient, worldSession: net.minecraft.client.session.telemetry.WorldSession): net.minecraft.client.network.ClientAdvancementManager;
          }
          interface ClientAdvancementManager { 
            onAdvancements(packet: net.minecraft.network.packet.s2c.play.AdvancementUpdateS2CPacket): void;
            getManager(): net.minecraft.advancement.AdvancementManager;
            selectTab(tab: net.minecraft.advancement.AdvancementEntry | null | undefined, local: boolean): void;
            setListener(listener: net.minecraft.client.network.ClientAdvancementManager$Listener | null | undefined): void;
            get(id: net.minecraft.util.Identifier): net.minecraft.advancement.AdvancementEntry | null | undefined;
          }
          interface ClientAdvancementManager$Listener extends net.minecraft.advancement.AdvancementManager$Listener { 
            setProgress(advancement: net.minecraft.advancement.PlacedAdvancement, progress: net.minecraft.advancement.AdvancementProgress): void;
            selectTab(advancement: net.minecraft.advancement.AdvancementEntry | null | undefined): void;
          }
          const DataQueryHandler: {
            new(networkHandler: net.minecraft.client.network.ClientPlayNetworkHandler): net.minecraft.client.network.DataQueryHandler;
          }
          interface DataQueryHandler { 
            handleQueryResponse(transactionId: number, nbt: net.minecraft.nbt.NbtCompound | null | undefined): boolean;
            queryEntityNbt(entityNetworkId: number, callback: unknown): void;
            queryBlockNbt(pos: net.minecraft.util.math.BlockPos, callback: unknown): void;
          }
        }
        namespace sound {
          const MusicTracker: {
            MusicFrequency: typeof net.minecraft.client.sound.MusicTracker$MusicFrequency;
            new(client: net.minecraft.client.MinecraftClient): net.minecraft.client.sound.MusicTracker;
          }
          interface MusicTracker { 
            tick(): void;
            play(instance: net.minecraft.client.sound.MusicInstance): void;
            tryShowToast(): void;
            stop(type: net.minecraft.sound.MusicSound): void;
            stop(): void;
            isPlayingType(type: net.minecraft.sound.MusicSound): boolean;
            getCurrentMusicTranslationKey(): string | null | undefined;
            setMusicFrequency(musicFrequency: net.minecraft.client.sound.MusicTracker$MusicFrequency): void;
          }
          const MusicTracker$MusicFrequency: {
            DEFAULT: net.minecraft.client.sound.MusicTracker$MusicFrequency;
            FREQUENT: net.minecraft.client.sound.MusicTracker$MusicFrequency;
            CONSTANT: net.minecraft.client.sound.MusicTracker$MusicFrequency;
            CODEC: com.mojang.serialization.Codec<net.minecraft.client.sound.MusicTracker$MusicFrequency>;
            valueOf(value: string): net.minecraft.client.sound.MusicTracker$MusicFrequency;
            values(): Array<net.minecraft.client.sound.MusicTracker$MusicFrequency>;
          }
          interface MusicTracker$MusicFrequency extends kotlin.Enum<net.minecraft.client.sound.MusicTracker$MusicFrequency>, net.minecraft.util.TranslatableOption, net.minecraft.util.StringIdentifiable { 
          }
          const MusicInstance: {
            new(music: net.minecraft.sound.MusicSound): net.minecraft.client.sound.MusicInstance;
            new(musicSound: net.minecraft.sound.MusicSound | null | undefined, f: number): net.minecraft.client.sound.MusicInstance;
          }
          interface MusicInstance extends java.lang.Record { 
            shouldReplace(sound: net.minecraft.client.sound.SoundInstance): boolean;
            music(): net.minecraft.sound.MusicSound | null | undefined;
            volume(): number;
          }
          const SoundInstance: {
            AttenuationType: typeof net.minecraft.client.sound.SoundInstance$AttenuationType;
            createRandom(): net.minecraft.util.math.random.Random;
          }
          interface SoundInstance extends net.fabricmc.fabric.api.client.sound.v1.FabricSoundInstance { 
            getId(): net.minecraft.util.Identifier;
            getSoundSet(soundManager: net.minecraft.client.sound.SoundManager): net.minecraft.client.sound.WeightedSoundSet | null | undefined;
            getSound(): net.minecraft.client.sound.Sound | null | undefined;
            getCategory(): net.minecraft.sound.SoundCategory;
            isRepeatable(): boolean;
            isRelative(): boolean;
            getRepeatDelay(): number;
            getVolume(): number;
            getPitch(): number;
            getX(): number;
            getY(): number;
            getZ(): number;
            getAttenuationType(): net.minecraft.client.sound.SoundInstance$AttenuationType;
            shouldAlwaysPlay(): boolean;
            canPlay(): boolean;
          }
          const SoundLoader: {
            new(resourceFactory: net.minecraft.resource.ResourceFactory): net.minecraft.client.sound.SoundLoader;
          }
          interface SoundLoader { 
            loadStatic(id: net.minecraft.util.Identifier): java.util.concurrent.CompletableFuture<unknown>;
            loadStatic(sounds: Array<net.minecraft.client.sound.Sound>): java.util.concurrent.CompletableFuture<any>;
            loadStreamed(id: net.minecraft.util.Identifier, repeatInstantly: boolean): java.util.concurrent.CompletableFuture<unknown>;
            close(): void;
          }
          const SoundInstance$AttenuationType: {
            NONE: net.minecraft.client.sound.SoundInstance$AttenuationType;
            LINEAR: net.minecraft.client.sound.SoundInstance$AttenuationType;
            valueOf(value: string): net.minecraft.client.sound.SoundInstance$AttenuationType;
            values(): Array<net.minecraft.client.sound.SoundInstance$AttenuationType>;
          }
          interface SoundInstance$AttenuationType extends kotlin.Enum<net.minecraft.client.sound.SoundInstance$AttenuationType> { 
          }
          const SoundManager: {
            EMPTY_ID: net.minecraft.util.Identifier;
            MISSING_SOUND: net.minecraft.client.sound.Sound;
            INTENTIONALLY_EMPTY_ID: net.minecraft.util.Identifier;
            INTENTIONALLY_EMPTY_SOUND_SET: net.minecraft.client.sound.WeightedSoundSet;
            INTENTIONALLY_EMPTY_SOUND: net.minecraft.client.sound.Sound;
            new(gameOptions: net.minecraft.client.option.GameOptions, musicTracker: net.minecraft.client.sound.MusicTracker): net.minecraft.client.sound.SoundManager;
          }
          interface SoundManager extends net.minecraft.resource.SinglePreparationResourceReloader<unknown> { 
            getSoundDevices(): Array<string>;
            getListenerTransform(): net.minecraft.client.sound.SoundListenerTransform;
            get(id: net.minecraft.util.Identifier): net.minecraft.client.sound.WeightedSoundSet | null | undefined;
            getKeys(): Array<net.minecraft.util.Identifier>;
            playNextTick(sound: net.minecraft.client.sound.TickableSoundInstance): void;
            play(sound: net.minecraft.client.sound.SoundInstance): net.minecraft.client.sound.SoundSystem$PlayResult;
            play(sound: net.minecraft.client.sound.SoundInstance, delay: number): void;
            updateListenerPosition(camera: net.minecraft.client.render.Camera): void;
            pauseAllExcept(categories: net.minecraft.sound.SoundCategory): void;
            stopAll(): void;
            close(): void;
            stopAbruptly(): void;
            tick(paused: boolean): void;
            resumeAll(): void;
            updateSoundVolume(soundCategory: net.minecraft.sound.SoundCategory): void;
            stop(sound: net.minecraft.client.sound.SoundInstance): void;
            setVolume(sound: net.minecraft.client.sound.SoundInstance, volume: number): void;
            isPlaying(sound: net.minecraft.client.sound.SoundInstance): boolean;
            registerListener(listener: net.minecraft.client.sound.SoundInstanceListener): void;
            unregisterListener(listener: net.minecraft.client.sound.SoundInstanceListener): void;
            stopSounds(id: net.minecraft.util.Identifier | null | undefined, soundCategory: net.minecraft.sound.SoundCategory | null | undefined): void;
            getDebugString(): string;
            reloadSounds(): void;
          }
          const SoundListenerTransform: {
            DEFAULT: net.minecraft.client.sound.SoundListenerTransform;
            new(vec3d: net.minecraft.util.math.Vec3d, vec3d2: net.minecraft.util.math.Vec3d, vec3d3: net.minecraft.util.math.Vec3d): net.minecraft.client.sound.SoundListenerTransform;
          }
          interface SoundListenerTransform extends java.lang.Record { 
            right(): net.minecraft.util.math.Vec3d;
            position(): net.minecraft.util.math.Vec3d;
            forward(): net.minecraft.util.math.Vec3d;
            up(): net.minecraft.util.math.Vec3d;
          }
          const WeightedSoundSet: {
            new(id: net.minecraft.util.Identifier, subtitle: string | null | undefined): net.minecraft.client.sound.WeightedSoundSet;
          }
          interface WeightedSoundSet extends net.minecraft.client.sound.SoundContainer<net.minecraft.client.sound.Sound> { 
            add(container: net.minecraft.client.sound.SoundContainer<net.minecraft.client.sound.Sound>): void;
            getSubtitle(): net.minecraft.text.Text | null | undefined;
          }
          interface SoundContainer<T> { 
            getWeight(): number;
            getSound(random: net.minecraft.util.math.random.Random): T;
            preload(soundSystem: net.minecraft.client.sound.SoundSystem): void;
          }
          const SoundSystem: {
            PlayResult: typeof net.minecraft.client.sound.SoundSystem$PlayResult;
            FOR_THE_DEBUG: string;
            OPENAL_SOFT_ON: string;
            OPENAL_SOFT_ON_LENGTH: number;
            new(musicTracker: net.minecraft.client.sound.MusicTracker, soundManager: net.minecraft.client.sound.SoundManager, options: net.minecraft.client.option.GameOptions, resourceFactory: net.minecraft.resource.ResourceFactory): net.minecraft.client.sound.SoundSystem;
          }
          interface SoundSystem { 
            reloadSounds(): void;
            updateSoundVolume(category: net.minecraft.sound.SoundCategory): void;
            stop(): void;
            stop(sound: net.minecraft.client.sound.SoundInstance): void;
            stopAbruptly(): void;
            setVolume(sound: net.minecraft.client.sound.SoundInstance, volume: number): void;
            stopAll(): void;
            registerListener(listener: net.minecraft.client.sound.SoundInstanceListener): void;
            unregisterListener(listener: net.minecraft.client.sound.SoundInstanceListener): void;
            tick(paused: boolean): void;
            isPlaying(sound: net.minecraft.client.sound.SoundInstance): boolean;
            play(sound: net.minecraft.client.sound.SoundInstance): net.minecraft.client.sound.SoundSystem$PlayResult;
            play(sound: net.minecraft.client.sound.SoundInstance, delay: number): void;
            playNextTick(sound: net.minecraft.client.sound.TickableSoundInstance): void;
            addPreloadedSound(sound: net.minecraft.client.sound.Sound): void;
            pauseAllExcept(categories: net.minecraft.sound.SoundCategory): void;
            resumeAll(): void;
            updateListenerPosition(camera: net.minecraft.client.render.Camera): void;
            stopSounds(id: net.minecraft.util.Identifier | null | undefined, category: net.minecraft.sound.SoundCategory | null | undefined): void;
            getDebugString(): string;
            getSoundDevices(): Array<string>;
            getListenerTransform(): net.minecraft.client.sound.SoundListenerTransform;
          }
          const SoundSystem$PlayResult: {
            STARTED: net.minecraft.client.sound.SoundSystem$PlayResult;
            STARTED_SILENTLY: net.minecraft.client.sound.SoundSystem$PlayResult;
            NOT_STARTED: net.minecraft.client.sound.SoundSystem$PlayResult;
            valueOf(value: string): net.minecraft.client.sound.SoundSystem$PlayResult;
            values(): Array<net.minecraft.client.sound.SoundSystem$PlayResult>;
          }
          interface SoundSystem$PlayResult extends kotlin.Enum<net.minecraft.client.sound.SoundSystem$PlayResult> { 
          }
          interface SoundInstanceListener { 
            onSoundPlayed(sound: net.minecraft.client.sound.SoundInstance, soundSet: net.minecraft.client.sound.WeightedSoundSet, range: number): void;
          }
          interface TickableSoundInstance extends net.minecraft.client.sound.SoundInstance { 
            isDone(): boolean;
            tick(): void;
          }
          const Sound: {
            RegistrationType: typeof net.minecraft.client.sound.Sound$RegistrationType;
            FINDER: net.minecraft.resource.ResourceFinder;
            new(id: net.minecraft.util.Identifier, volume: net.minecraft.util.math.floatprovider.FloatSupplier, pitch: net.minecraft.util.math.floatprovider.FloatSupplier, weight: number, registrationType: net.minecraft.client.sound.Sound$RegistrationType, stream: boolean, preload: boolean, attenuation: number): net.minecraft.client.sound.Sound;
          }
          interface Sound extends net.minecraft.client.sound.SoundContainer<net.minecraft.client.sound.Sound> { 
            getIdentifier(): net.minecraft.util.Identifier;
            getLocation(): net.minecraft.util.Identifier;
            getVolume(): net.minecraft.util.math.floatprovider.FloatSupplier;
            getPitch(): net.minecraft.util.math.floatprovider.FloatSupplier;
            getRegistrationType(): net.minecraft.client.sound.Sound$RegistrationType;
            isStreamed(): boolean;
            isPreloaded(): boolean;
            getAttenuation(): number;
          }
          const Sound$RegistrationType: {
            FILE: net.minecraft.client.sound.Sound$RegistrationType;
            SOUND_EVENT: net.minecraft.client.sound.Sound$RegistrationType;
            getByName(name: string): net.minecraft.client.sound.Sound$RegistrationType | null | undefined;
            valueOf(value: string): net.minecraft.client.sound.Sound$RegistrationType;
            values(): Array<net.minecraft.client.sound.Sound$RegistrationType>;
          }
          interface Sound$RegistrationType extends kotlin.Enum<net.minecraft.client.sound.Sound$RegistrationType> { 
          }
        }
        namespace tutorial {
          const TutorialStep: {
            MOVEMENT: net.minecraft.client.tutorial.TutorialStep;
            FIND_TREE: net.minecraft.client.tutorial.TutorialStep;
            PUNCH_TREE: net.minecraft.client.tutorial.TutorialStep;
            OPEN_INVENTORY: net.minecraft.client.tutorial.TutorialStep;
            CRAFT_PLANKS: net.minecraft.client.tutorial.TutorialStep;
            NONE: net.minecraft.client.tutorial.TutorialStep;
            byName(name: string): net.minecraft.client.tutorial.TutorialStep;
            valueOf(value: string): net.minecraft.client.tutorial.TutorialStep;
            values(): Array<net.minecraft.client.tutorial.TutorialStep>;
          }
          interface TutorialStep extends kotlin.Enum<net.minecraft.client.tutorial.TutorialStep> { 
            createHandler(manager: net.minecraft.client.tutorial.TutorialManager): net.minecraft.client.tutorial.TutorialStepHandler;
            getName(): string;
          }
          const TutorialManager: {
            keyToText(name: string): net.minecraft.text.Text;
            new(client: net.minecraft.client.MinecraftClient, options: net.minecraft.client.option.GameOptions): net.minecraft.client.tutorial.TutorialManager;
          }
          interface TutorialManager { 
            onMovement(input: net.minecraft.client.input.Input): void;
            onUpdateMouse(deltaX: number, deltaY: number): void;
            tick(world: net.minecraft.client.world.ClientWorld | null | undefined, hitResult: net.minecraft.util.hit.HitResult | null | undefined): void;
            tick(): void;
            onBlockBreaking(world: net.minecraft.client.world.ClientWorld, pos: net.minecraft.util.math.BlockPos, state: net.minecraft.block.BlockState, progress: number): void;
            onInventoryOpened(): void;
            onSlotUpdate(stack: net.minecraft.item.ItemStack): void;
            destroyHandler(): void;
            createHandler(): void;
            setStep(step: net.minecraft.client.tutorial.TutorialStep): void;
            getClient(): net.minecraft.client.MinecraftClient;
            isInSurvival(): boolean;
            onPickupSlotClick(cursorStack: net.minecraft.item.ItemStack, slotStack: net.minecraft.item.ItemStack, clickType: net.minecraft.util.ClickType): void;
          }
          interface TutorialStepHandler { 
            destroy(): void;
            tick(): void;
            onMovement(input: net.minecraft.client.input.Input): void;
            onMouseUpdate(deltaX: number, deltaY: number): void;
            onTarget(world: net.minecraft.client.world.ClientWorld, hitResult: net.minecraft.util.hit.HitResult): void;
            onBlockBreaking(client: net.minecraft.client.world.ClientWorld, pos: net.minecraft.util.math.BlockPos, state: net.minecraft.block.BlockState, progress: number): void;
            onInventoryOpened(): void;
            onSlotUpdate(stack: net.minecraft.item.ItemStack): void;
          }
        }
        namespace session {
          namespace telemetry {
            const TelemetryManager: {
              new(client: net.minecraft.client.MinecraftClient, userApiService: com.mojang.authlib.minecraft.UserApiService, session: net.minecraft.client.session.Session): net.minecraft.client.session.telemetry.TelemetryManager;
            }
            interface TelemetryManager extends java.lang.AutoCloseable { 
              createWorldSession(newWorld: boolean, worldLoadTime: java.time.Duration | null | undefined, minigameName: string | null | undefined): net.minecraft.client.session.telemetry.WorldSession;
              getSender(): net.minecraft.client.session.telemetry.TelemetrySender;
              getLogManager(): java.nio.file.Path;
            }
            const WorldSession: {
              new(sender: net.minecraft.client.session.telemetry.TelemetrySender, newWorld: boolean, worldLoadTime: java.time.Duration | null | undefined, minigameName: string | null | undefined): net.minecraft.client.session.telemetry.WorldSession;
            }
            interface WorldSession { 
              tick(): void;
              setGameMode(gameMode: net.minecraft.world.GameMode, hardcore: boolean): void;
              setBrand(brand: string): void;
              setTick(tick: number): void;
              onLoad(): void;
              onUnload(): void;
              onAdvancementMade(world: net.minecraft.world.World, advancement: net.minecraft.advancement.AdvancementEntry): void;
            }
            const TelemetrySender: {
              NOOP: net.minecraft.client.session.telemetry.TelemetrySender;
            }
            interface TelemetrySender { 
              decorate(decorationAdder: unknown): net.minecraft.client.session.telemetry.TelemetrySender;
              send(eventType: net.minecraft.client.session.telemetry.TelemetryEventType, propertyAdder: unknown): void;
              (eventType: net.minecraft.client.session.telemetry.TelemetryEventType, propertyAdder: unknown): void;
            }
            const TelemetryEventType: {
              Builder: typeof net.minecraft.client.session.telemetry.TelemetryEventType$Builder;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.session.telemetry.TelemetryEventType>;
              WORLD_LOADED: net.minecraft.client.session.telemetry.TelemetryEventType;
              PERFORMANCE_METRICS: net.minecraft.client.session.telemetry.TelemetryEventType;
              WORLD_LOAD_TIMES: net.minecraft.client.session.telemetry.TelemetryEventType;
              WORLD_UNLOADED: net.minecraft.client.session.telemetry.TelemetryEventType;
              ADVANCEMENT_MADE: net.minecraft.client.session.telemetry.TelemetryEventType;
              GAME_LOAD_TIMES: net.minecraft.client.session.telemetry.TelemetryEventType;
              builder(id: string, sentEventId: string): net.minecraft.client.session.telemetry.TelemetryEventType$Builder;
              getTypes(): Array<net.minecraft.client.session.telemetry.TelemetryEventType>;
            }
            interface TelemetryEventType { 
              getId(): string;
              getProperties(): Array<net.minecraft.client.session.telemetry.TelemetryEventProperty<any>>;
              getCodec(): com.mojang.serialization.MapCodec<unknown>;
              isOptional(): boolean;
              createEvent(session: com.mojang.authlib.minecraft.TelemetrySession, properties: net.minecraft.client.session.telemetry.PropertyMap): com.mojang.authlib.minecraft.TelemetryEvent;
              hasProperty<T>(property: net.minecraft.client.session.telemetry.TelemetryEventProperty<T>): boolean;
              getTitle(): net.minecraft.text.MutableText;
              getDescription(): net.minecraft.text.MutableText;
            }
            interface TelemetryEventType$Builder { 
              properties(properties: Array<net.minecraft.client.session.telemetry.TelemetryEventProperty<any>>): net.minecraft.client.session.telemetry.TelemetryEventType$Builder;
              properties<T>(property: net.minecraft.client.session.telemetry.TelemetryEventProperty<T>): net.minecraft.client.session.telemetry.TelemetryEventType$Builder;
              optional(): net.minecraft.client.session.telemetry.TelemetryEventType$Builder;
              build(): net.minecraft.client.session.telemetry.TelemetryEventType;
            }
            const TelemetryEventProperty: {
              ServerType: typeof net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType;
              GameMode: typeof net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              USER_ID: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              CLIENT_ID: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              MINECRAFT_SESSION_ID: net.minecraft.client.session.telemetry.TelemetryEventProperty<java.util.UUID>;
              GAME_VERSION: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              OPERATING_SYSTEM: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              PLATFORM: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              CLIENT_MODDED: net.minecraft.client.session.telemetry.TelemetryEventProperty<boolean>;
              LAUNCHER_NAME: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              WORLD_SESSION_ID: net.minecraft.client.session.telemetry.TelemetryEventProperty<java.util.UUID>;
              SERVER_MODDED: net.minecraft.client.session.telemetry.TelemetryEventProperty<boolean>;
              SERVER_TYPE: net.minecraft.client.session.telemetry.TelemetryEventProperty<net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType>;
              OPT_IN: net.minecraft.client.session.telemetry.TelemetryEventProperty<boolean>;
              EVENT_TIMESTAMP_UTC: net.minecraft.client.session.telemetry.TelemetryEventProperty<java.time.Instant>;
              GAME_MODE: net.minecraft.client.session.telemetry.TelemetryEventProperty<net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode>;
              REALMS_MAP_CONTENT: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              SECONDS_SINCE_LOAD: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              TICKS_SINCE_LOAD: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              FRAME_RATE_SAMPLES: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              RENDER_TIME_SAMPLES: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              USED_MEMORY_SAMPLES: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              NUMBER_OF_SAMPLES: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              RENDER_DISTANCE: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              DEDICATED_MEMORY_KB: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              WORLD_LOAD_TIME_MS: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              NEW_WORLD: net.minecraft.client.session.telemetry.TelemetryEventProperty<boolean>;
              LOAD_TIME_TOTAL_TIME_MS: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              LOAD_TIME_PRE_WINDOW_MS: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              LOAD_TIME_BOOTSTRAP_MS: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              LOAD_TIME_LOADING_OVERLAY_MS: net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              ADVANCEMENT_ID: net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              ADVANCEMENT_GAME_TIME: net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              of<T>(id: string, exportKey: string, codec: com.mojang.serialization.Codec<T>, exporter: net.minecraft.client.session.telemetry.TelemetryEventProperty$PropertyExporter<T>): net.minecraft.client.session.telemetry.TelemetryEventProperty<T>;
              ofBoolean(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<boolean>;
              ofString(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<string>;
              ofInteger(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              ofLong(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<number>;
              ofUuid(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<java.util.UUID>;
              ofTimeMeasurement(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              ofLongList(id: string, exportKey: string): net.minecraft.client.session.telemetry.TelemetryEventProperty<unknown>;
              new<T>(string: string, string2: string, codec: com.mojang.serialization.Codec<T>, propertyExporter: net.minecraft.client.session.telemetry.TelemetryEventProperty$PropertyExporter<T>): net.minecraft.client.session.telemetry.TelemetryEventProperty<T>;
            }
            interface TelemetryEventProperty<T> extends java.lang.Record { 
              addTo(map: net.minecraft.client.session.telemetry.PropertyMap, container: com.mojang.authlib.minecraft.TelemetryPropertyContainer): void;
              getTitle(): net.minecraft.text.MutableText;
              id(): string;
              exportKey(): string;
              codec(): com.mojang.serialization.Codec<T>;
              exporter(): net.minecraft.client.session.telemetry.TelemetryEventProperty$PropertyExporter<T>;
            }
            const TelemetryEventProperty$ServerType: {
              REALM: net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType;
              LOCAL: net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType;
              OTHER: net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType>;
              valueOf(value: string): net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType;
              values(): Array<net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType>;
            }
            interface TelemetryEventProperty$ServerType extends kotlin.Enum<net.minecraft.client.session.telemetry.TelemetryEventProperty$ServerType>, net.minecraft.util.StringIdentifiable { 
            }
            const TelemetryEventProperty$GameMode: {
              SURVIVAL: net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              CREATIVE: net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              ADVENTURE: net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              SPECTATOR: net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              HARDCORE: net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              CODEC: com.mojang.serialization.Codec<net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode>;
              valueOf(value: string): net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode;
              values(): Array<net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode>;
            }
            interface TelemetryEventProperty$GameMode extends kotlin.Enum<net.minecraft.client.session.telemetry.TelemetryEventProperty$GameMode>, net.minecraft.util.StringIdentifiable { 
              getRawId(): number;
            }
         