/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.block;

import appeng.block.AEBaseEntityBlock;
import com.mebeamformer.blockentity.BeamFormerBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BeamFormerBlock
extends AEBaseEntityBlock<BeamFormerBlockEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<Status> STATUS = EnumProperty.m_61587_((String)"status", Status.class);
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);

    public BeamFormerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_(STATUS, (Comparable)((Object)Status.OFF)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATUS});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BeamFormerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos, st, be) -> {
            if (be instanceof BeamFormerBlockEntity) {
                BeamFormerBlockEntity bf = (BeamFormerBlockEntity)be;
                if (lvl.f_46443_) {
                    BeamFormerBlockEntity.clientTick(lvl, pos, st, bf);
                } else {
                    BeamFormerBlockEntity.serverTick(lvl, pos, st, bf);
                }
            }
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_7820_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face)).m_61124_(STATUS, (Comparable)((Object)Status.OFF));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPES.get(facing);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPES.get(facing);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player.m_6144_() && (blockEntity = level.m_7702_(pos)) instanceof BeamFormerBlockEntity) {
            BeamFormerBlockEntity bf = (BeamFormerBlockEntity)blockEntity;
            if (!level.f_46443_) {
                bf.toggleBeamVisibility();
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    static {
        for (Direction facing : Direction.values()) {
            SHAPES.put(facing, switch (facing) {
                case Direction.NORTH -> Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)8.0);
                case Direction.SOUTH -> Block.m_49796_((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)16.0);
                case Direction.WEST -> Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0);
                case Direction.EAST -> Block.m_49796_((double)8.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
                case Direction.UP -> Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
                case Direction.DOWN -> Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
                default -> Block.m_49796_((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)16.0);
            });
        }
    }

    public static enum Status implements StringRepresentable
    {
        OFF("off"),
        ON("on"),
        BEAMING("beaming");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

