/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.mebeamformer.ME_Beam_Former;
import com.mebeamformer.blockentity.ILinkable;
import com.mebeamformer.energy.ILongEnergyStorage;
import com.mebeamformer.energy.MEBFCapabilities;
import com.mebeamformer.integration.AE2FluxIntegration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WirelessEnergyTowerBlockEntity
extends AENetworkBlockEntity
implements ILinkable {
    private final Set<BlockPos> links = new HashSet<BlockPos>();
    private List<BlockPos> clientLinks = Collections.emptyList();
    private final Set<BlockPos> lastSyncedLinks = new HashSet<BlockPos>();
    private static final long MAX_TRANSFER = Long.MAX_VALUE;
    private final LazyOptional<?>[] energyCaps = new LazyOptional[7];

    public WirelessEnergyTowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ME_Beam_Former.WIRELESS_ENERGY_TOWER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(0.0);
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateEnergyCaps();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateEnergyCaps();
    }

    private void invalidateEnergyCaps() {
        for (int i = 0; i < this.energyCaps.length; ++i) {
            if (this.energyCaps[i] == null) continue;
            this.energyCaps[i].invalidate();
            this.energyCaps[i] = null;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WirelessEnergyTowerBlockEntity be) {
        if (be.m_58901_()) {
            return;
        }
        HashSet<BlockPos> validLinks = new HashSet<BlockPos>();
        for (BlockPos targetPos : new HashSet<BlockPos>(be.links)) {
            BlockEntity targetBE = level.m_7702_(targetPos);
            if (targetBE == null) {
                be.removeLink(targetPos);
                continue;
            }
            be.pushEnergyToTarget(targetBE);
            validLinks.add(targetPos);
        }
        if (!validLinks.equals(be.lastSyncedLinks)) {
            be.lastSyncedLinks.clear();
            be.lastSyncedLinks.addAll(validLinks);
            be.markForUpdate();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WirelessEnergyTowerBlockEntity be) {
    }

    private void pushEnergyToTarget(BlockEntity target) {
        boolean transferred;
        if (this.f_58857_ == null) {
            return;
        }
        if (target instanceof WirelessEnergyTowerBlockEntity) {
            WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)target;
            this.pushEnergyToTower(targetTower);
            return;
        }
        if (AE2FluxIntegration.isAvailable() && (transferred = this.tryPushFromAE2Network(target))) {
            return;
        }
        transferred = this.tryPushGTEnergy(target);
        if (transferred) {
            return;
        }
        transferred = this.tryPushLongEnergy(target);
        if (!transferred) {
            this.tryPushForgeEnergy(target);
        }
    }

    private boolean tryPushFromAE2Network(BlockEntity target) {
        long extracted = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, Long.MAX_VALUE, true);
        if (extracted <= 0L) {
            return false;
        }
        long inserted = this.pushEnergyToTargetDirect(target, extracted, false);
        if (inserted > 0L) {
            AE2FluxIntegration.extractEnergyFromOwnNetwork(this, inserted, false);
            return true;
        }
        return false;
    }

    private void pushEnergyToTower(WirelessEnergyTowerBlockEntity targetTower) {
        int extracted;
        ILongEnergyStorage sourceLong;
        long inserted;
        long extracted2;
        long inserted2;
        long extracted3;
        if (this.f_58857_ == null) {
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        visited.add(this.f_58858_);
        if (AE2FluxIntegration.isAvailable() && (extracted3 = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, Long.MAX_VALUE, true)) > 0L && (inserted2 = targetTower.distributeEnergyInNetwork(extracted3, false, visited)) > 0L) {
            AE2FluxIntegration.extractEnergyFromOwnNetwork(this, inserted2, false);
            return;
        }
        Object sourceFlux = this.getNeighborFluxEnergy();
        if (sourceFlux != null) {
            try {
                Method extractMethod = sourceFlux.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
                extracted2 = (Long)extractMethod.invoke(sourceFlux, Long.MAX_VALUE, true);
                if (extracted2 > 0L && (inserted = targetTower.distributeEnergyInNetwork(extracted2, false, visited)) > 0L) {
                    extractMethod.invoke(sourceFlux, inserted, false);
                    return;
                }
            }
            catch (Exception extractMethod) {
                // empty catch block
            }
        }
        if ((sourceLong = this.getNeighborLongEnergy()) != null && (extracted2 = sourceLong.extractEnergyL(Long.MAX_VALUE, true)) > 0L && (inserted = targetTower.distributeEnergyInNetwork(extracted2, false, visited)) > 0L) {
            sourceLong.extractEnergyL(inserted, false);
            return;
        }
        IEnergyStorage sourceEnergy = this.getNeighborForgeEnergy();
        if (sourceEnergy != null && (extracted = sourceEnergy.extractEnergy(Integer.MAX_VALUE, true)) > 0 && (inserted = targetTower.distributeEnergyInNetwork(extracted, false, visited)) > 0L) {
            sourceEnergy.extractEnergy((int)Math.min(inserted, Integer.MAX_VALUE), false);
        }
    }

    private long receiveEnergyFromTower(long amount, boolean simulate, Set<BlockPos> visited) {
        if (this.f_58857_ == null || amount <= 0L) {
            return 0L;
        }
        if (!visited.add(this.f_58858_)) {
            return 0L;
        }
        long totalInserted = 0L;
        for (Direction dir : Direction.values()) {
            if (totalInserted >= amount) break;
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
            long remaining = amount - totalInserted;
            long inserted = this.pushEnergyToTargetDirect(neighborBE, remaining, simulate);
            totalInserted += inserted;
        }
        if (totalInserted < amount && !this.links.isEmpty()) {
            for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
                if (totalInserted >= amount) break;
                BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
                if (targetBE == null || targetBE instanceof WirelessEnergyTowerBlockEntity) continue;
                long remaining = amount - totalInserted;
                long inserted = this.pushEnergyToTargetDirect(targetBE, remaining, simulate);
                totalInserted += inserted;
            }
        }
        if (totalInserted < amount && !this.links.isEmpty()) {
            for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
                if (totalInserted >= amount) break;
                BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
                if (!(targetBE instanceof WirelessEnergyTowerBlockEntity)) continue;
                WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                if (visited.contains(targetPos)) continue;
                long remaining = amount - totalInserted;
                long inserted = targetTower.receiveEnergyFromTower(remaining, simulate, visited);
                totalInserted += inserted;
            }
        }
        return totalInserted;
    }

    private long distributeEnergyInNetwork(long amount, boolean simulate, Set<BlockPos> visited) {
        if (this.f_58857_ == null || amount <= 0L) {
            return 0L;
        }
        if (!visited.add(this.f_58858_)) {
            return 0L;
        }
        long totalInserted = 0L;
        for (Direction dir : Direction.values()) {
            ILongEnergyStorage storage;
            if (totalInserted >= amount) break;
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
            long remaining = amount - totalInserted;
            long fluxInserted = this.tryInsertFluxEnergy(neighborBE, dir.m_122424_(), remaining, simulate);
            if (fluxInserted > 0L) {
                totalInserted += fluxInserted;
                continue;
            }
            try {
                LazyOptional longCap = neighborBE.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir.m_122424_());
                if (longCap.isPresent() && (storage = (ILongEnergyStorage)longCap.resolve().orElse(null)) != null && storage.canReceive()) {
                    long inserted = storage.receiveEnergyL(remaining, simulate);
                    totalInserted += inserted;
                    continue;
                }
            }
            catch (ClassCastException longCap) {
                // empty catch block
            }
            try {
                int batchSize;
                int inserted;
                LazyOptional normalCap = neighborBE.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_());
                if (!normalCap.isPresent() || (storage = (IEnergyStorage)normalCap.resolve().orElse(null)) == null || !storage.canReceive()) continue;
                if (simulate) {
                    int batchSize2 = (int)Math.min(remaining, Integer.MAX_VALUE);
                    inserted = storage.receiveEnergy(batchSize2, true);
                    totalInserted += (long)inserted;
                    continue;
                }
                while (remaining > 0L && totalInserted < amount && (inserted = storage.receiveEnergy(batchSize = (int)Math.min(remaining, Integer.MAX_VALUE), false)) != 0) {
                    totalInserted += (long)inserted;
                    remaining -= (long)inserted;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (totalInserted < amount && !this.links.isEmpty()) {
            for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
                if (totalInserted >= amount) break;
                BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
                if (targetBE == null || targetBE instanceof WirelessEnergyTowerBlockEntity) continue;
                long remaining = amount - totalInserted;
                long inserted = this.pushEnergyToTargetDirect(targetBE, remaining, simulate);
                totalInserted += inserted;
            }
        }
        if (totalInserted < amount && !this.links.isEmpty()) {
            for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
                if (totalInserted >= amount) break;
                BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
                if (!(targetBE instanceof WirelessEnergyTowerBlockEntity)) continue;
                WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                if (visited.contains(targetPos)) continue;
                long remaining = amount - totalInserted;
                long inserted = targetTower.distributeEnergyInNetwork(remaining, simulate, visited);
                totalInserted += inserted;
            }
        }
        return totalInserted;
    }

    private long pushEnergyToTargetDirect(BlockEntity target, long amount, boolean simulate) {
        ILongEnergyStorage storage;
        if (this.f_58857_ == null || amount <= 0L) {
            return 0L;
        }
        for (Direction dir : Direction.values()) {
            long fluxInserted = this.tryInsertFluxEnergy(target, dir, amount, simulate);
            if (fluxInserted <= 0L) continue;
            return fluxInserted;
        }
        long inserted = this.tryPushGTEnergyDirect(target, amount, simulate);
        if (inserted > 0L) {
            return inserted;
        }
        for (Direction dir : Direction.values()) {
            try {
                LazyOptional longCap = target.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir);
                if (!longCap.isPresent() || (storage = (ILongEnergyStorage)longCap.resolve().orElse(null)) == null || !storage.canReceive()) continue;
                return storage.receiveEnergyL(amount, simulate);
            }
            catch (ClassCastException longCap) {
                // empty catch block
            }
        }
        for (Direction dir : Direction.values()) {
            try {
                int batchSize;
                int batchInserted;
                LazyOptional cap = target.getCapability(ForgeCapabilities.ENERGY, dir);
                if (!cap.isPresent() || (storage = (IEnergyStorage)cap.resolve().orElse(null)) == null || !storage.canReceive()) continue;
                if (simulate) {
                    int batchSize2 = (int)Math.min(amount, Integer.MAX_VALUE);
                    return storage.receiveEnergy(batchSize2, true);
                }
                long totalInserted = 0L;
                for (long remaining = amount; remaining > 0L && (batchInserted = storage.receiveEnergy(batchSize = (int)Math.min(remaining, Integer.MAX_VALUE), false)) != 0; remaining -= (long)batchInserted) {
                    totalInserted += (long)batchInserted;
                }
                return totalInserted;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private long tryInsertFluxEnergy(BlockEntity target, Direction side, long amount, boolean simulate) {
        try {
            Method canReceiveMethod;
            Object storage;
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            LazyOptional cap = target.getCapability(fluxCap, side);
            if (cap.isPresent() && (storage = cap.resolve().orElse(null)) != null && ((Boolean)(canReceiveMethod = storage.getClass().getMethod("canReceive", new Class[0])).invoke(storage, new Object[0])).booleanValue()) {
                Method receiveMethod = storage.getClass().getMethod("receiveEnergyL", Long.TYPE, Boolean.TYPE);
                return (Long)receiveMethod.invoke(storage, amount, simulate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private long tryPushGTEnergyDirect(BlockEntity target, long amountFE, boolean simulate) {
        try {
            Class<?> gtCapClass = Class.forName("com.gregtechceu.gtceu.api.capability.forge.GTCapability");
            Field field = gtCapClass.getField("CAPABILITY_ENERGY_CONTAINER");
            Capability gtCap = (Capability)field.get(null);
            for (Direction dir : Direction.values()) {
                Method inputsEnergyMethod;
                Object container;
                LazyOptional cap = target.getCapability(gtCap, dir);
                if (!cap.isPresent() || (container = cap.resolve().orElse(null)) == null || !((Boolean)(inputsEnergyMethod = container.getClass().getMethod("inputsEnergy", Direction.class)).invoke(container, dir)).booleanValue()) continue;
                long amountEU = amountFE >> 2;
                Method getInputVoltageMethod = container.getClass().getMethod("getInputVoltage", new Class[0]);
                Method getInputAmperageMethod = container.getClass().getMethod("getInputAmperage", new Class[0]);
                long voltage = (Long)getInputVoltageMethod.invoke(container, new Object[0]);
                long amperage = (Long)getInputAmperageMethod.invoke(container, new Object[0]);
                long actualVoltage = Math.min(voltage, amountEU);
                long actualAmperage = Math.min(amperage, amountEU / Math.max(actualVoltage, 1L));
                if (!simulate) {
                    Method acceptEnergyMethod = container.getClass().getMethod("acceptEnergyFromNetwork", Direction.class, Long.TYPE, Long.TYPE);
                    long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, dir, actualVoltage, actualAmperage);
                    long transferredEU = actualVoltage * acceptedAmperage;
                    return transferredEU << 2;
                }
                return actualVoltage * actualAmperage << 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean tryPushGTEnergy(BlockEntity target) {
        try {
            Class<?> gtCapClass = Class.forName("com.gregtechceu.gtceu.api.capability.forge.GTCapability");
            Field field = gtCapClass.getField("CAPABILITY_ENERGY_CONTAINER");
            Capability gtCap = (Capability)field.get(null);
            for (Direction dir : Direction.values()) {
                Method inputsEnergyMethod;
                Object container;
                LazyOptional cap = target.getCapability(gtCap, dir);
                if (!cap.isPresent() || (container = cap.resolve().orElse(null)) == null || !((Boolean)(inputsEnergyMethod = container.getClass().getMethod("inputsEnergy", Direction.class)).invoke(container, dir)).booleanValue()) continue;
                return this.pushToGTContainer(container, dir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean pushToGTContainer(Object container, Direction side) {
        try {
            long ae2Energy;
            Method getEnergyCanBeInsertedMethod = container.getClass().getMethod("getEnergyCanBeInserted", new Class[0]);
            long demand = (Long)getEnergyCanBeInsertedMethod.invoke(container, new Object[0]);
            if (demand == 0L) {
                return false;
            }
            Method getInputVoltageMethod = container.getClass().getMethod("getInputVoltage", new Class[0]);
            Method getInputAmperageMethod = container.getClass().getMethod("getInputAmperage", new Class[0]);
            Method acceptEnergyMethod = container.getClass().getMethod("acceptEnergyFromNetwork", Direction.class, Long.TYPE, Long.TYPE);
            long voltage = (Long)getInputVoltageMethod.invoke(container, new Object[0]);
            long amperage = (Long)getInputAmperageMethod.invoke(container, new Object[0]);
            if (AE2FluxIntegration.isAvailable() && (ae2Energy = this.tryExtractFromAE2Network(container, side, voltage, amperage, demand, acceptEnergyMethod)) > 0L) {
                return true;
            }
            Object sourceFlux = this.getNeighborFluxEnergy();
            if (sourceFlux != null) {
                return this.pushFluxToGT(sourceFlux, container, side, voltage, amperage, demand);
            }
            ILongEnergyStorage sourceLong = this.getNeighborLongEnergy();
            if (sourceLong != null) {
                return this.pushLongToGT(sourceLong, container, side, voltage, amperage, demand, acceptEnergyMethod);
            }
            IEnergyStorage sourceEnergy = this.getNeighborForgeEnergy();
            if (sourceEnergy == null) {
                return false;
            }
            int extractedFE = sourceEnergy.extractEnergy(Integer.MAX_VALUE, true);
            if (extractedFE == 0) {
                return false;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return false;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                int actualExtractFE = (int)Math.min(transferredEU << 2, Integer.MAX_VALUE);
                sourceEnergy.extractEnergy(actualExtractFE, false);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean pushLongToGT(ILongEnergyStorage source, Object container, Direction side, long voltage, long amperage, long demand, Method acceptEnergyMethod) {
        try {
            long extractedFE = source.extractEnergyL(Long.MAX_VALUE, true);
            if (extractedFE == 0L) {
                return false;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return false;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                long actualExtractFE = transferredEU << 2;
                source.extractEnergyL(actualExtractFE, false);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long tryExtractFromAE2Network(Object container, Direction side, long voltage, long amperage, long demand, Method acceptEnergyMethod) {
        try {
            long maxTransferEU = Math.min(voltage * amperage, demand);
            long maxTransferFE = maxTransferEU << 2;
            long extractedFE = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, maxTransferFE, true);
            if (extractedFE == 0L) {
                return 0L;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return 0L;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                long actualExtractFE = transferredEU << 2;
                AE2FluxIntegration.extractEnergyFromOwnNetwork(this, actualExtractFE, false);
                return transferredEU;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean pushFluxToGT(Object sourceFlux, Object container, Direction side, long voltage, long amperage, long demand) {
        try {
            Method extractMethod = sourceFlux.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
            Method acceptEnergyMethod = container.getClass().getMethod("acceptEnergyFromNetwork", Direction.class, Long.TYPE, Long.TYPE);
            long extractedFE = (Long)extractMethod.invoke(sourceFlux, Long.MAX_VALUE, true);
            if (extractedFE == 0L) {
                return false;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return false;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                long actualExtractFE = transferredEU << 2;
                extractMethod.invoke(sourceFlux, actualExtractFE, false);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean tryPushLongEnergy(BlockEntity target) {
        Object sourceFlux = this.getNeighborFluxEnergy();
        if (sourceFlux != null) {
            return this.pushFluxEnergy(sourceFlux, target);
        }
        ILongEnergyStorage sourceEnergy = this.getNeighborLongEnergy();
        if (sourceEnergy == null) {
            return false;
        }
        ILongEnergyStorage targetLongEnergy = null;
        for (Direction dir : Direction.values()) {
            try {
                LazyOptional cap = target.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir);
                if (!cap.isPresent()) continue;
                targetLongEnergy = cap.resolve().orElse(null);
                if (targetLongEnergy != null && targetLongEnergy.canReceive()) break;
                targetLongEnergy = null;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (targetLongEnergy != null) {
            long inserted;
            long extracted = sourceEnergy.extractEnergyL(Long.MAX_VALUE, true);
            if (extracted > 0L && (inserted = targetLongEnergy.receiveEnergyL(extracted, false)) > 0L) {
                sourceEnergy.extractEnergyL(inserted, false);
            }
            return true;
        }
        IEnergyStorage targetEnergy = null;
        for (Direction dir : Direction.values()) {
            try {
                LazyOptional cap = target.getCapability(ForgeCapabilities.ENERGY, dir);
                if (!cap.isPresent()) continue;
                targetEnergy = cap.resolve().orElse(null);
                if (targetEnergy != null && targetEnergy.canReceive()) break;
                targetEnergy = null;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (targetEnergy != null) {
            int inserted;
            long extracted = sourceEnergy.extractEnergyL(Integer.MAX_VALUE, true);
            if (extracted > 0L && (inserted = targetEnergy.receiveEnergy((int)Math.min(extracted, Integer.MAX_VALUE), false)) > 0) {
                sourceEnergy.extractEnergyL(inserted, false);
            }
            return true;
        }
        return false;
    }

    private Object getNeighborFluxEnergy() {
        if (this.f_58857_ == null) {
            return null;
        }
        try {
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            for (Direction dir : Direction.values()) {
                Method canExtractMethod;
                Object storage;
                LazyOptional cap;
                BlockPos neighborPos = this.f_58858_.m_121945_(dir);
                BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
                if (neighborBE == null || neighborBE == this || neighborBE instanceof WirelessEnergyTowerBlockEntity || !(cap = neighborBE.getCapability(fluxCap, dir.m_122424_())).isPresent() || (storage = cap.resolve().orElse(null)) == null || !((Boolean)(canExtractMethod = storage.getClass().getMethod("canExtract", new Class[0])).invoke(storage, new Object[0])).booleanValue()) continue;
                return storage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean pushFluxEnergy(Object sourceFlux, BlockEntity target) {
        try {
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            Object targetFlux = null;
            for (Direction dir : Direction.values()) {
                LazyOptional cap = target.getCapability(fluxCap, dir);
                if (!cap.isPresent() || (targetFlux = cap.resolve().orElse(null)) == null) continue;
                Method canReceiveMethod = targetFlux.getClass().getMethod("canReceive", new Class[0]);
                if (((Boolean)canReceiveMethod.invoke(targetFlux, new Object[0])).booleanValue()) break;
                targetFlux = null;
            }
            if (targetFlux != null) {
                long inserted;
                Method extractMethod = sourceFlux.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
                Method receiveMethod = targetFlux.getClass().getMethod("receiveEnergyL", Long.TYPE, Boolean.TYPE);
                long extracted = (Long)extractMethod.invoke(sourceFlux, Long.MAX_VALUE, true);
                if (extracted > 0L && (inserted = ((Long)receiveMethod.invoke(targetFlux, extracted, false)).longValue()) > 0L) {
                    extractMethod.invoke(sourceFlux, inserted, false);
                    return true;
                }
            } else {
                int inserted;
                Method extractMethod;
                long extracted;
                IEnergyStorage targetEnergy = null;
                for (Direction dir : Direction.values()) {
                    try {
                        LazyOptional cap = target.getCapability(ForgeCapabilities.ENERGY, dir);
                        if (!cap.isPresent()) continue;
                        targetEnergy = cap.resolve().orElse(null);
                        if (targetEnergy != null && targetEnergy.canReceive()) break;
                        targetEnergy = null;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (targetEnergy != null && (extracted = ((Long)(extractMethod = sourceFlux.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE)).invoke(sourceFlux, Integer.MAX_VALUE, true)).longValue()) > 0L && (inserted = targetEnergy.receiveEnergy((int)Math.min(extracted, Integer.MAX_VALUE), false)) > 0) {
                    extractMethod.invoke(sourceFlux, inserted, false);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private ILongEnergyStorage getNeighborLongEnergy() {
        if (this.f_58857_ == null) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
            try {
                ILongEnergyStorage storage;
                LazyOptional cap = neighborBE.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir.m_122424_());
                if (!cap.isPresent() || (storage = (ILongEnergyStorage)cap.resolve().orElse(null)) == null || !storage.canExtract()) continue;
                return storage;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return null;
    }

    private void tryPushForgeEnergy(BlockEntity target) {
        int inserted;
        IEnergyStorage sourceEnergy = this.getNeighborForgeEnergy();
        if (sourceEnergy == null) {
            return;
        }
        IEnergyStorage targetEnergy = null;
        for (Direction dir : Direction.values()) {
            try {
                LazyOptional cap = target.getCapability(ForgeCapabilities.ENERGY, dir);
                if (!cap.isPresent()) continue;
                targetEnergy = cap.resolve().orElse(null);
                if (targetEnergy != null && targetEnergy.canReceive()) break;
                targetEnergy = null;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (targetEnergy == null) {
            return;
        }
        int extracted = sourceEnergy.extractEnergy(Integer.MAX_VALUE, true);
        if (extracted > 0 && (inserted = targetEnergy.receiveEnergy(extracted, false)) > 0) {
            sourceEnergy.extractEnergy(inserted, false);
        }
    }

    private IEnergyStorage getNeighborForgeEnergy() {
        if (this.f_58857_ == null) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
            try {
                IEnergyStorage storage;
                LazyOptional cap = neighborBE.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_());
                if (!cap.isPresent() || (storage = (IEnergyStorage)cap.resolve().orElse(null)) == null || !storage.canExtract()) continue;
                return storage;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void addLink(BlockPos other) {
        if (other.equals((Object)this.m_58899_())) {
            return;
        }
        if (this.links.add(other)) {
            this.m_6596_();
        }
    }

    @Override
    public void removeLink(BlockPos other) {
        if (this.links.remove(other)) {
            this.m_6596_();
        }
    }

    @Override
    public Set<BlockPos> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public List<BlockPos> getClientLinks() {
        return this.clientLinks;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.m_130130_(this.lastSyncedLinks.size());
        for (BlockPos p : this.lastSyncedLinks) {
            data.m_130064_(p);
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        int n = data.m_130242_();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            list.add(data.m_130135_());
        }
        boolean linksChanged = !list.equals(this.clientLinks);
        this.clientLinks = list;
        return changed || linksChanged;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (BlockPos p : this.links) {
            CompoundTag t = new CompoundTag();
            t.m_128405_("x", p.m_123341_());
            t.m_128405_("y", p.m_123342_());
            t.m_128405_("z", p.m_123343_());
            list.add((Object)t);
        }
        tag.m_128365_("links", (Tag)list);
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.links.clear();
        if (tag.m_128425_("links", 9)) {
            ListTag list = tag.m_128437_("links", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.m_128728_(i);
                BlockPos pos = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
                this.links.add(pos);
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_()) {
            LazyOptional<?> handler;
            int index;
            if (this.isFluxEnergyCapability(cap)) {
                Object fluxAdapter;
                index = side == null ? 0 : side.m_122411_() + 1;
                handler = this.energyCaps[index];
                if (handler == null && (fluxAdapter = this.createFluxEnergyAdapter(side)) != null) {
                    this.energyCaps[index] = handler = LazyOptional.of(() -> fluxAdapter);
                }
                if (handler != null) {
                    return handler.cast();
                }
            }
            if (cap == ForgeCapabilities.ENERGY || cap == MEBFCapabilities.LONG_ENERGY_STORAGE) {
                index = side == null ? 0 : side.m_122411_() + 1;
                handler = this.energyCaps[index];
                if (handler == null) {
                    TowerEnergyStorage storage = new TowerEnergyStorage(side);
                    this.energyCaps[index] = handler = LazyOptional.of(() -> storage);
                }
                return handler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    private boolean isFluxEnergyCapability(Capability<?> cap) {
        try {
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            return cap == fluxCap;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object createFluxEnergyAdapter(Direction side) {
        try {
            Class<?> interfaceClass = Class.forName("sonar.fluxnetworks.api.energy.IFNEnergyStorage");
            return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (proxy, method, args) -> this.handleFluxMethod(method.getName(), args, side));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object handleFluxMethod(String methodName, Object[] args, Direction side) {
        switch (methodName) {
            case "extractEnergyL": {
                return this.handleExtractEnergyL(args);
            }
            case "receiveEnergyL": {
                return this.handleReceiveEnergyL(args);
            }
            case "getEnergyStoredL": {
                return this.getFluxEnergyStoredL();
            }
            case "getMaxEnergyStoredL": {
                return this.getFluxMaxEnergyStoredL();
            }
            case "canExtract": {
                return this.canNeighborExtract();
            }
            case "canReceive": {
                return this.canReceiveFromFlux();
            }
        }
        return null;
    }

    private long handleReceiveEnergyL(Object[] args) {
        if (args == null || args.length < 2) {
            return 0L;
        }
        long maxReceive = (Long)args[0];
        boolean simulate = (Boolean)args[1];
        if (maxReceive <= 0L || this.f_58857_ == null || this.links.isEmpty()) {
            return 0L;
        }
        long totalInserted = 0L;
        for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
            if (totalInserted >= maxReceive) break;
            BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
            if (targetBE == null) continue;
            long remaining = maxReceive - totalInserted;
            if (targetBE instanceof WirelessEnergyTowerBlockEntity) {
                WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                HashSet<BlockPos> visited = new HashSet<BlockPos>();
                visited.add(this.f_58858_);
                long inserted = targetTower.receiveEnergyFromTower(remaining, simulate, visited);
                totalInserted += inserted;
                continue;
            }
            long inserted = this.pushEnergyToTargetDirect(targetBE, remaining, simulate);
            totalInserted += inserted;
        }
        return totalInserted;
    }

    private boolean canReceiveFromFlux() {
        return this.f_58857_ != null && !this.links.isEmpty();
    }

    private long getFluxEnergyStoredL() {
        return 0L;
    }

    private long getFluxMaxEnergyStoredL() {
        if (this.f_58857_ == null || this.links.isEmpty()) {
            return 0L;
        }
        long totalCapacity = 0L;
        block2: for (BlockPos targetPos : new HashSet<BlockPos>(this.links)) {
            BlockEntity targetBE = this.f_58857_.m_7702_(targetPos);
            if (targetBE == null) continue;
            for (Direction dir : Direction.values()) {
                try {
                    IEnergyStorage storage;
                    ILongEnergyStorage storage2;
                    long fluxMax = this.tryGetFluxMaxEnergyStored(targetBE, dir);
                    if (fluxMax > 0L) {
                        totalCapacity += fluxMax;
                        continue block2;
                    }
                    LazyOptional longCap = targetBE.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir);
                    if (longCap.isPresent() && (storage2 = (ILongEnergyStorage)longCap.resolve().orElse(null)) != null) {
                        totalCapacity += storage2.getMaxEnergyStoredL();
                        continue block2;
                    }
                    LazyOptional normalCap = targetBE.getCapability(ForgeCapabilities.ENERGY, dir);
                    if (!normalCap.isPresent() || (storage = (IEnergyStorage)normalCap.resolve().orElse(null)) == null) continue;
                    totalCapacity += (long)storage.getMaxEnergyStored();
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Math.max(totalCapacity, 0x3FFFFFFFFFFFFFFFL);
    }

    private long handleExtractEnergyL(Object[] args) {
        if (args == null || args.length < 2) {
            return 0L;
        }
        long maxExtract = (Long)args[0];
        boolean simulate = (Boolean)args[1];
        if (maxExtract <= 0L || this.f_58857_ == null) {
            return 0L;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this) continue;
            long extracted = this.tryExtractFluxEnergy(neighborBE, dir, maxExtract, simulate);
            if (extracted > 0L) {
                return extracted;
            }
            IEnergyStorage storage = this.getForgeEnergyStorage(neighborBE, dir.m_122424_());
            if (storage == null || !storage.canExtract()) continue;
            int maxInt = (int)Math.min(maxExtract, Integer.MAX_VALUE);
            return storage.extractEnergy(maxInt, simulate);
        }
        return 0L;
    }

    private long tryExtractFluxEnergy(BlockEntity be, Direction side, long maxExtract, boolean simulate) {
        try {
            Object storage;
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            LazyOptional cap = be.getCapability(fluxCap, side.m_122424_());
            if (cap.isPresent() && (storage = cap.resolve().orElse(null)) != null) {
                Method extractMethod = storage.getClass().getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
                return (Long)extractMethod.invoke(storage, maxExtract, simulate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private long getNeighborEnergyStoredL() {
        if (this.f_58857_ == null) {
            return 0L;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this) continue;
            long stored = this.tryGetFluxEnergyStored(neighborBE, dir);
            if (stored > 0L) {
                return stored;
            }
            IEnergyStorage storage = this.getForgeEnergyStorage(neighborBE, dir.m_122424_());
            if (storage == null) continue;
            return storage.getEnergyStored();
        }
        return 0L;
    }

    private long getNeighborMaxEnergyStoredL() {
        if (this.f_58857_ == null) {
            return Long.MAX_VALUE;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this) continue;
            long max = this.tryGetFluxMaxEnergyStored(neighborBE, dir);
            if (max > 0L) {
                return max;
            }
            IEnergyStorage storage = this.getForgeEnergyStorage(neighborBE, dir.m_122424_());
            if (storage == null) continue;
            return storage.getMaxEnergyStored();
        }
        return Long.MAX_VALUE;
    }

    private boolean canNeighborExtract() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            IEnergyStorage storage;
            BlockPos neighborPos = this.f_58858_.m_121945_(dir);
            BlockEntity neighborBE = this.f_58857_.m_7702_(neighborPos);
            if (neighborBE == null || neighborBE == this || (storage = this.getForgeEnergyStorage(neighborBE, dir.m_122424_())) == null || !storage.canExtract()) continue;
            return true;
        }
        return false;
    }

    private long tryGetFluxEnergyStored(BlockEntity be, Direction side) {
        try {
            Object storage;
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            LazyOptional cap = be.getCapability(fluxCap, side.m_122424_());
            if (cap.isPresent() && (storage = cap.resolve().orElse(null)) != null) {
                Method method = storage.getClass().getMethod("getEnergyStoredL", new Class[0]);
                return (Long)method.invoke(storage, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private long tryGetFluxMaxEnergyStored(BlockEntity be, Direction side) {
        try {
            Object storage;
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            LazyOptional cap = be.getCapability(fluxCap, side.m_122424_());
            if (cap.isPresent() && (storage = cap.resolve().orElse(null)) != null) {
                Method method = storage.getClass().getMethod("getMaxEnergyStoredL", new Class[0]);
                return (Long)method.invoke(storage, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private IEnergyStorage getForgeEnergyStorage(BlockEntity be, Direction side) {
        try {
            LazyOptional cap = be.getCapability(ForgeCapabilities.ENERGY, side);
            return cap.resolve().orElse(null);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.clientLinks == null || this.clientLinks.isEmpty()) {
            BlockPos pos = this.m_58899_();
            return new AABB((double)(pos.m_123341_() - 5), (double)(pos.m_123342_() - 5), (double)(pos.m_123343_() - 5), (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 8), (double)(pos.m_123343_() + 6));
        }
        BlockPos pos = this.m_58899_();
        double minX = pos.m_123341_();
        double minY = pos.m_123342_();
        double minZ = pos.m_123343_();
        double maxX = pos.m_123341_() + 1;
        double maxY = pos.m_123342_() + 3;
        double maxZ = pos.m_123343_() + 1;
        for (BlockPos target : this.clientLinks) {
            minX = Math.min(minX, (double)target.m_123341_());
            minY = Math.min(minY, (double)target.m_123342_());
            minZ = Math.min(minZ, (double)target.m_123343_());
            maxX = Math.max(maxX, (double)(target.m_123341_() + 1));
            maxY = Math.max(maxY, (double)(target.m_123342_() + 1));
            maxZ = Math.max(maxZ, (double)(target.m_123343_() + 1));
        }
        double expansion = 5.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }

    private class TowerEnergyStorage
    implements IEnergyStorage,
    ILongEnergyStorage {
        @Nullable
        private final Direction side;

        public TowerEnergyStorage(Direction side) {
            this.side = side;
        }

        @Nullable
        private Object getNeighborStorage() {
            if (WirelessEnergyTowerBlockEntity.this.f_58857_ == null) {
                return null;
            }
            for (Direction dir : Direction.values()) {
                BlockPos neighborPos = WirelessEnergyTowerBlockEntity.this.f_58858_.m_121945_(dir);
                BlockEntity neighborBE = WirelessEnergyTowerBlockEntity.this.f_58857_.m_7702_(neighborPos);
                if (neighborBE == null || neighborBE == WirelessEnergyTowerBlockEntity.this || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
                try {
                    LazyOptional longCap = neighborBE.getCapability(MEBFCapabilities.LONG_ENERGY_STORAGE, dir.m_122424_());
                    if (longCap.isPresent()) {
                        return longCap.resolve().orElse(null);
                    }
                }
                catch (ClassCastException longCap) {
                    // empty catch block
                }
                try {
                    LazyOptional normalCap = neighborBE.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_());
                    if (!normalCap.isPresent()) continue;
                    return normalCap.resolve().orElse(null);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)Math.min(this.receiveEnergyL(maxReceive, simulate), Integer.MAX_VALUE);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            Object storage = this.getNeighborStorage();
            if (storage instanceof ILongEnergyStorage) {
                ILongEnergyStorage longStorage = (ILongEnergyStorage)storage;
                return (int)Math.min(longStorage.extractEnergyL(maxExtract, simulate), Integer.MAX_VALUE);
            }
            if (storage instanceof IEnergyStorage) {
                IEnergyStorage normalStorage = (IEnergyStorage)storage;
                return normalStorage.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
        }

        @Override
        public boolean canExtract() {
            Object storage = this.getNeighborStorage();
            if (storage instanceof ILongEnergyStorage) {
                ILongEnergyStorage longStorage = (ILongEnergyStorage)storage;
                return longStorage.canExtract();
            }
            if (storage instanceof IEnergyStorage) {
                IEnergyStorage normalStorage = (IEnergyStorage)storage;
                return normalStorage.canExtract();
            }
            return false;
        }

        @Override
        public boolean canReceive() {
            return WirelessEnergyTowerBlockEntity.this.f_58857_ != null && !WirelessEnergyTowerBlockEntity.this.links.isEmpty();
        }

        @Override
        public long receiveEnergyL(long maxReceive, boolean simulate) {
            if (WirelessEnergyTowerBlockEntity.this.f_58857_ == null || maxReceive <= 0L || WirelessEnergyTowerBlockEntity.this.links.isEmpty()) {
                return 0L;
            }
            long totalInserted = 0L;
            for (BlockPos targetPos : new HashSet<BlockPos>(WirelessEnergyTowerBlockEntity.this.links)) {
                if (totalInserted >= maxReceive) break;
                BlockEntity targetBE = WirelessEnergyTowerBlockEntity.this.f_58857_.m_7702_(targetPos);
                if (targetBE == null) continue;
                long remaining = maxReceive - totalInserted;
                if (targetBE instanceof WirelessEnergyTowerBlockEntity) {
                    WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                    HashSet<BlockPos> visited = new HashSet<BlockPos>();
                    visited.add(WirelessEnergyTowerBlockEntity.this.f_58858_);
                    long inserted = targetTower.receiveEnergyFromTower(remaining, simulate, visited);
                    totalInserted += inserted;
                    continue;
                }
                long inserted = WirelessEnergyTowerBlockEntity.this.pushEnergyToTargetDirect(targetBE, remaining, simulate);
                totalInserted += inserted;
            }
            return totalInserted;
        }

        @Override
        public long extractEnergyL(long maxExtract, boolean simulate) {
            Object storage = this.getNeighborStorage();
            if (storage instanceof ILongEnergyStorage) {
                ILongEnergyStorage longStorage = (ILongEnergyStorage)storage;
                return longStorage.extractEnergyL(maxExtract, simulate);
            }
            if (storage instanceof IEnergyStorage) {
                IEnergyStorage normalStorage = (IEnergyStorage)storage;
                return normalStorage.extractEnergy((int)Math.min(maxExtract, Integer.MAX_VALUE), simulate);
            }
            return 0L;
        }

        @Override
        public long getEnergyStoredL() {
            Object storage = this.getNeighborStorage();
            if (storage instanceof ILongEnergyStorage) {
                ILongEnergyStorage longStorage = (ILongEnergyStorage)storage;
                return longStorage.getEnergyStoredL();
            }
            if (storage instanceof IEnergyStorage) {
                IEnergyStorage normalStorage = (IEnergyStorage)storage;
                return normalStorage.getEnergyStored();
            }
            return 0L;
        }

        @Override
        public long getMaxEnergyStoredL() {
            Object storage = this.getNeighborStorage();
            if (storage instanceof ILongEnergyStorage) {
                ILongEnergyStorage longStorage = (ILongEnergyStorage)storage;
                return longStorage.getMaxEnergyStoredL();
            }
            if (storage instanceof IEnergyStorage) {
                IEnergyStorage normalStorage = (IEnergyStorage)storage;
                return normalStorage.getMaxEnergyStored();
            }
            return 0L;
        }
    }
}

