/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public final class BeamRenderHelper {
    private static final float MIN_THICKNESS = 0.15f;
    private static final ResourceLocation BEAM_TEX = new ResourceLocation("minecraft", "textures/misc/white.png");
    private static final float COLOR_BRIGHTNESS = 1.3f;
    private static final float COLOR_CONTRAST = 1.05f;
    private static final float COLOR_SAT_BOOST = 1.4f;
    private static final float COLOR_SAT_MIN = 0.6f;

    private static float adjustChannel(float c) {
        c = (c - 0.5f) * 1.05f + 0.5f;
        if ((c *= 1.3f) < 0.0f) {
            c = 0.0f;
        }
        if (c > 1.0f) {
            c = 1.0f;
        }
        return c;
    }

    private BeamRenderHelper() {
    }

    public static void renderColoredBeam(PoseStack poseStack, MultiBufferSource buffers, Direction dir, double length, float r, float g, float b, int light, int overlay) {
        BeamRenderHelper.renderColoredBeam(poseStack, buffers, dir, length, r, g, b, light, overlay, 0.15f);
    }

    public static void renderColoredBeam(PoseStack poseStack, MultiBufferSource buffers, Direction dir, double length, float r, float g, float b, int light, int overlay, float thickness) {
        float vy;
        float vx;
        float uz;
        float uy;
        float ux;
        boolean isAchromatic;
        if (length <= 0.0) {
            return;
        }
        float half = Math.max(0.001f, thickness) / 2.0f;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        switch (dir) {
            case NORTH: {
                dz = -length;
                break;
            }
            case SOUTH: {
                dz = length;
                break;
            }
            case WEST: {
                dx = -length;
                break;
            }
            case EAST: {
                dx = length;
                break;
            }
            case DOWN: {
                dy = -length;
                break;
            }
            case UP: {
                dy = length;
            }
        }
        float[] hsv = BeamRenderHelper.rgbToHsv(r, g, b);
        float h = hsv[0];
        float s = hsv[1];
        boolean bl = isAchromatic = s < 0.12f || Math.abs(r - g) < 0.05f && Math.abs(g - b) < 0.05f;
        if (isAchromatic) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            s = Math.min(1.0f, Math.max(s * 1.4f, 0.6f));
            float v = 1.0f;
            float[] rgb = BeamRenderHelper.hsvToRgb(h, s, v);
            r = rgb[0];
            g = rgb[1];
            b = rgb[2];
            r = BeamRenderHelper.adjustChannel(r);
            g = BeamRenderHelper.adjustChannel(g);
            b = BeamRenderHelper.adjustChannel(b);
        }
        boolean ACHRO = isAchromatic;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        double BACK_OFFSET = 0.75;
        double START = -0.25;
        poseStack.m_85837_((double)dir.m_122429_() * -0.25, (double)dir.m_122430_() * -0.25, (double)dir.m_122431_() * -0.25);
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f normalMat = last.m_252943_();
        VertexConsumer vcEmissive = buffers.m_6299_(RenderType.m_234338_((ResourceLocation)BEAM_TEX));
        float v0 = 0.0f;
        float v1 = 1.0f;
        float aOuter = 0.4f;
        float aInner = 1.0f;
        int SEGMENTS = 20;
        float[] SHELL_SCALE = new float[]{2.6f, 1.9f, 1.2f, 0.95f, 0.6f};
        float[] SHELL_ALPHA = new float[]{0.04f, 0.1f, 0.95f, 1.0f, 1.0f};
        float ax = (float)dx;
        float ay = (float)dy;
        float az = (float)dz;
        float vz = switch (dir) {
            case Direction.DOWN, Direction.UP -> {
                ux = 1.0f;
                uy = 0.0f;
                uz = 0.0f;
                vx = 0.0f;
                vy = 0.0f;
                yield 1.0f;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                ux = 1.0f;
                uy = 0.0f;
                uz = 0.0f;
                vx = 0.0f;
                vy = 1.0f;
                yield 0.0f;
            }
            case Direction.WEST, Direction.EAST -> {
                ux = 0.0f;
                uy = 1.0f;
                uz = 0.0f;
                vx = 0.0f;
                vy = 0.0f;
                yield 1.0f;
            }
            default -> {
                ux = 1.0f;
                uy = 0.0f;
                uz = 0.0f;
                vx = 0.0f;
                vy = 1.0f;
                yield 0.0f;
            }
        };
        int fullLight = 0xF000F0;
        long gt = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : 0L;
        float flicker = 0.8f + 0.2f * (float)Math.sin((double)gt * 0.45);
        for (int shell = 0; shell < SHELL_SCALE.length; ++shell) {
            float radius = half * SHELL_SCALE[shell];
            float alpha = SHELL_ALPHA[shell];
            if (shell <= 1) {
                alpha *= flicker;
            }
            for (int i = 0; i < 20; ++i) {
                float cb;
                float cg;
                float cr;
                double a0 = Math.PI * 2 * (double)i / 20.0;
                double a1 = Math.PI * 2 * (double)(i + 1) / 20.0;
                float c0 = (float)Math.cos(a0);
                float s0 = (float)Math.sin(a0);
                float c1 = (float)Math.cos(a1);
                float s1 = (float)Math.sin(a1);
                float sx0 = ux * c0 * radius + vx * s0 * radius;
                float sy0 = uy * c0 * radius + vy * s0 * radius;
                float sz0 = uz * c0 * radius + vz * s0 * radius;
                float sx1 = ux * c1 * radius + vx * s1 * radius;
                float sy1 = uy * c1 * radius + vy * s1 * radius;
                float sz1 = uz * c1 * radius + vz * s1 * radius;
                float EPS_SHIFT = 0.01f;
                float ox = 0.0f;
                float oy = 0.0f;
                float oz = 0.0f;
                if (shell <= 1) {
                    ox = (float)dir.m_122429_() * EPS_SHIFT;
                    oy = (float)dir.m_122430_() * EPS_SHIFT;
                    oz = (float)dir.m_122431_() * EPS_SHIFT;
                }
                float ex0 = sx0 + ax + ox;
                float ey0 = sy0 + ay + oy;
                float ez0 = sz0 + az + oz;
                float ex1 = sx1 + ax + ox;
                float ey1 = sy1 + ay + oy;
                float ez1 = sz1 + az + oz;
                float nx = 0.0f;
                float ny = 0.0f;
                float nz = 0.0f;
                float u0 = 0.0f;
                float u1 = 1.0f;
                VertexConsumer targetVc = vcEmissive;
                if (ACHRO) {
                    cr = 1.0f;
                    cg = 1.0f;
                    cb = 1.0f;
                } else if (shell >= 3) {
                    cr = 1.0f;
                    cg = 1.0f;
                    cb = 1.0f;
                } else if (shell == 2) {
                    float mix = 0.25f;
                    cr = r * (1.0f - mix) + 1.0f * mix;
                    cg = g * (1.0f - mix) + 1.0f * mix;
                    cb = b * (1.0f - mix) + 1.0f * mix;
                } else {
                    cr = r;
                    cg = g;
                    cb = b;
                }
                BeamRenderHelper.quadBothSides(pose, normalMat, targetVc, sx0, sy0, sz0, sx1, sy1, sz1, ex1, ey1, ez1, ex0, ey0, ez0, cr, cg, cb, alpha, u0, v0, u1, v1, fullLight, overlay, nx, ny, nz);
            }
        }
        poseStack.m_85849_();
    }

    public static void renderColoredBeamForPart(PoseStack poseStack, MultiBufferSource buffers, Direction dir, double length, float r, float g, float b, int light, int overlay) {
        BeamRenderHelper.renderColoredBeam(poseStack, buffers, dir, length, r, g, b, light, overlay, 0.15f);
    }

    public static void renderColoredBeamVector(PoseStack poseStack, MultiBufferSource buffers, float vx, float vy, float vz, float r, float g, float b, int light, int overlay, float thickness) {
        boolean isAchromatic;
        double len = Math.sqrt(vx * vx + vy * vy + vz * vz);
        if (len <= 1.0E-6) {
            return;
        }
        float half = Math.max(0.001f, thickness) / 2.0f;
        float[] hsv = BeamRenderHelper.rgbToHsv(r, g, b);
        float h = hsv[0];
        float s = hsv[1];
        boolean bl = isAchromatic = s < 0.12f || Math.abs(r - g) < 0.05f && Math.abs(g - b) < 0.05f;
        if (isAchromatic) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            s = Math.min(1.0f, Math.max(s * 1.4f, 0.6f));
            float v = 1.0f;
            float[] rgb = BeamRenderHelper.hsvToRgb(h, s, v);
            r = BeamRenderHelper.adjustChannel(rgb[0]);
            g = BeamRenderHelper.adjustChannel(rgb[1]);
            b = BeamRenderHelper.adjustChannel(rgb[2]);
        }
        boolean ACHRO = isAchromatic;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        double BACK_OFFSET = 0.75;
        double invLen = 1.0 / len;
        double nx = (double)vx * invLen;
        double ny = (double)vy * invLen;
        double nz = (double)vz * invLen;
        double startShift = -0.25;
        poseStack.m_85837_(nx * startShift, ny * startShift, nz * startShift);
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f normalMat = last.m_252943_();
        VertexConsumer vcEmissive = buffers.m_6299_(RenderType.m_234338_((ResourceLocation)BEAM_TEX));
        float v0 = 0.0f;
        float v1 = 1.0f;
        int SEGMENTS = 20;
        float[] SHELL_SCALE = new float[]{2.6f, 1.9f, 1.2f, 0.95f, 0.6f};
        float[] SHELL_ALPHA = new float[]{0.04f, 0.1f, 0.95f, 1.0f, 1.0f};
        float ax = vx;
        float ay = vy;
        float az = vz;
        float tax = ax;
        float tay = ay;
        float taz = az;
        float tLen = (float)Math.sqrt(tax * tax + tay * tay + taz * taz);
        float rx = Math.abs(tay /= tLen) < 0.99f ? 0.0f : 1.0f;
        float ry = Math.abs(tay) < 0.99f ? 1.0f : 0.0f;
        float rz = 0.0f;
        float ux = tay * rz - (taz /= tLen) * ry;
        float uy = taz * rx - (tax /= tLen) * rz;
        float uz = tax * ry - tay * rx;
        float uLen = (float)Math.sqrt(ux * ux + uy * uy + uz * uz);
        if (uLen < 1.0E-6f) {
            rx = 0.0f;
            ry = 0.0f;
            rz = 1.0f;
            ux = tay * rz - taz * ry;
            uy = taz * rx - tax * rz;
            uz = tax * ry - tay * rx;
            uLen = (float)Math.sqrt(ux * ux + uy * uy + uz * uz);
        }
        float vx2 = tay * (uz /= uLen) - taz * (uy /= uLen);
        float vy2 = taz * (ux /= uLen) - tax * uz;
        float vz2 = tax * uy - tay * ux;
        float vLen = (float)Math.sqrt(vx2 * vx2 + vy2 * vy2 + vz2 * vz2);
        vx2 /= vLen;
        vy2 /= vLen;
        vz2 /= vLen;
        int fullLight = 0xF000F0;
        long gt = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : 0L;
        float flicker = 0.8f + 0.2f * (float)Math.sin((double)gt * 0.45);
        for (int shell = 0; shell < SHELL_SCALE.length; ++shell) {
            float radius = half * SHELL_SCALE[shell];
            float alpha = SHELL_ALPHA[shell];
            if (shell <= 1) {
                alpha *= flicker;
            }
            for (int i = 0; i < 20; ++i) {
                float cb;
                float cg;
                float cr;
                double a0 = Math.PI * 2 * (double)i / 20.0;
                double a1 = Math.PI * 2 * (double)(i + 1) / 20.0;
                float c0 = (float)Math.cos(a0);
                float s0 = (float)Math.sin(a0);
                float c1 = (float)Math.cos(a1);
                float s1 = (float)Math.sin(a1);
                float sx0 = ux * c0 * radius + vx2 * s0 * radius;
                float sy0 = uy * c0 * radius + vy2 * s0 * radius;
                float sz0 = uz * c0 * radius + vz2 * s0 * radius;
                float sx1 = ux * c1 * radius + vx2 * s1 * radius;
                float sy1 = uy * c1 * radius + vy2 * s1 * radius;
                float sz1 = uz * c1 * radius + vz2 * s1 * radius;
                float EPS_SHIFT = 0.01f;
                float ox = tax * EPS_SHIFT;
                float oy = tay * EPS_SHIFT;
                float oz = taz * EPS_SHIFT;
                float ex0 = sx0 + ax + ox;
                float ey0 = sy0 + ay + oy;
                float ez0 = sz0 + az + oz;
                float ex1 = sx1 + ax + ox;
                float ey1 = sy1 + ay + oy;
                float ez1 = sz1 + az + oz;
                float nx0 = 0.0f;
                float ny0 = 0.0f;
                float nz0 = 0.0f;
                float u0 = 0.0f;
                float u1 = 1.0f;
                if (ACHRO) {
                    cr = 1.0f;
                    cg = 1.0f;
                    cb = 1.0f;
                } else if (shell >= 3) {
                    cr = 1.0f;
                    cg = 1.0f;
                    cb = 1.0f;
                } else if (shell == 2) {
                    float mix = 0.25f;
                    cr = r * (1.0f - mix) + 1.0f * mix;
                    cg = g * (1.0f - mix) + 1.0f * mix;
                    cb = b * (1.0f - mix) + 1.0f * mix;
                } else {
                    cr = r;
                    cg = g;
                    cb = b;
                }
                BeamRenderHelper.quadBothSides(pose, normalMat, vcEmissive, sx0, sy0, sz0, sx1, sy1, sz1, ex1, ey1, ez1, ex0, ey0, ez0, cr, cg, cb, alpha, u0, v0, u1, v1, fullLight, overlay, nx0, ny0, nz0);
            }
        }
        poseStack.m_85849_();
    }

    private static void quad(Matrix4f pose, Matrix3f normalMat, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a, float u0, float v0, float u1, float v1, int light, int overlay, float nx, float ny, float nz) {
        vc.m_252986_(pose, x1, y1, z1).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_252939_(normalMat, nx, ny, nz).m_5752_();
        vc.m_252986_(pose, x2, y2, z2).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_252939_(normalMat, nx, ny, nz).m_5752_();
        vc.m_252986_(pose, x3, y3, z3).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(normalMat, nx, ny, nz).m_5752_();
        vc.m_252986_(pose, x4, y4, z4).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_252939_(normalMat, nx, ny, nz).m_5752_();
    }

    private static void quadBothSides(Matrix4f pose, Matrix3f normalMat, VertexConsumer vc, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a, float u0, float v0, float u1, float v1, int light, int overlay, float nx, float ny, float nz) {
        BeamRenderHelper.quad(pose, normalMat, vc, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, r, g, b, a, u0, v0, u1, v1, light, overlay, nx, ny, nz);
        BeamRenderHelper.quad(pose, normalMat, vc, x4, y4, z4, x3, y3, z3, x2, y2, z2, x1, y1, z1, r, g, b, a, u0, v0, u1, v1, light, overlay, -nx, -ny, -nz);
    }

    private static float[] rgbToHsv(float r, float g, float b) {
        float min;
        float max = Math.max(r, Math.max(g, b));
        float delta = max - (min = Math.min(r, Math.min(g, b)));
        float h = delta == 0.0f ? 0.0f : (max == r ? (g - b) / delta % 6.0f : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        float v = max;
        return new float[]{h, s, v};
    }

    private static float[] hsvToRgb(float h, float s, float v) {
        float bf;
        float gf;
        float rf;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h * 6.0f % 2.0f - 1.0f));
        float m = v - c;
        float hp = h * 6.0f;
        if (hp < 1.0f) {
            rf = c;
            gf = x;
            bf = 0.0f;
        } else if (hp < 2.0f) {
            rf = x;
            gf = c;
            bf = 0.0f;
        } else if (hp < 3.0f) {
            rf = 0.0f;
            gf = c;
            bf = x;
        } else if (hp < 4.0f) {
            rf = 0.0f;
            gf = x;
            bf = c;
        } else if (hp < 5.0f) {
            rf = x;
            gf = 0.0f;
            bf = c;
        } else {
            rf = c;
            gf = 0.0f;
            bf = x;
        }
        return new float[]{rf + m, gf + m, bf + m};
    }
}

