/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.item;

import com.mebeamformer.block.WirelessEnergyTowerBlock;
import com.mebeamformer.blockentity.ILinkable;
import com.mebeamformer.blockentity.OmniBeamFormerBlockEntity;
import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class LaserBindingTool
extends Item {
    private static final String TAG_SOURCE = "SourcePos";
    private static final String TAG_SOURCE_TYPE = "SourceType";
    private static final String TYPE_TOWER = "tower";
    private static final String TYPE_OMNI = "omni";

    public LaserBindingTool(Item.Properties props) {
        super(props);
    }

    private BlockPos getTowerBasePos(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof WirelessEnergyTowerBlock) {
            int part = (Integer)state.m_61143_((Property)WirelessEnergyTowerBlock.PART);
            return pos.m_6625_(part);
        }
        return pos;
    }

    private WirelessEnergyTowerBlockEntity getTowerBlockEntity(Level level, BlockPos pos) {
        BlockPos basePos = this.getTowerBasePos(level, pos);
        BlockEntity be = level.m_7702_(basePos);
        if (be instanceof WirelessEnergyTowerBlockEntity) {
            WirelessEnergyTowerBlockEntity tower = (WirelessEnergyTowerBlockEntity)be;
            return tower;
        }
        return null;
    }

    private boolean hasEnergyCapability(BlockEntity be) {
        if (be == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (!be.getCapability(ForgeCapabilities.ENERGY, dir).isPresent()) continue;
            return true;
        }
        try {
            Class<?> gtCapClass = Class.forName("com.gregtechceu.gtceu.api.capability.forge.GTCapability");
            Field field = gtCapClass.getField("CAPABILITY_ENERGY_CONTAINER");
            Capability gtCap = (Capability)field.get(null);
            for (Direction dir : Direction.values()) {
                if (!be.getCapability(gtCap, dir).isPresent()) continue;
                return true;
            }
        }
        catch (Exception gtCapClass) {
            // empty catch block
        }
        try {
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field field = fluxCapClass.getField("FN_ENERGY_STORAGE");
            Capability fluxCap = (Capability)field.get(null);
            for (Direction dir : Direction.values()) {
                if (!be.getCapability(fluxCap, dir).isPresent()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        BlockPos pos = this.getTowerBasePos(level, clickedPos);
        BlockEntity be = level.m_7702_(pos);
        BlockState clickedState = level.m_8055_(clickedPos);
        boolean isClickedTower = clickedState.m_60734_() instanceof WirelessEnergyTowerBlock;
        CompoundTag tag = stack.m_41784_();
        boolean hasSource = tag.m_128441_(TAG_SOURCE);
        boolean isLinkable = be instanceof ILinkable;
        boolean hasEnergy = this.hasEnergyCapability(be);
        if (player != null && player.m_6144_()) {
            String sourceType;
            if (hasSource && TYPE_TOWER.equals(sourceType = tag.m_128461_(TAG_SOURCE_TYPE))) {
                boolean isTargetTower = isClickedTower;
                if (isTargetTower) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.tower_to_tower_needs_normal_click"), true);
                    return InteractionResult.SUCCESS;
                }
                if (!isLinkable) {
                    if (hasEnergy) {
                        CompoundTag t = tag.m_128469_(TAG_SOURCE);
                        BlockPos source = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
                        if (source.equals((Object)pos)) {
                            player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.self_link"), true);
                            return InteractionResult.SUCCESS;
                        }
                        WirelessEnergyTowerBlockEntity sourceEntity = this.getTowerBlockEntity(level, source);
                        if (sourceEntity != null) {
                            if (sourceEntity.getLinks().contains(pos)) {
                                sourceEntity.removeLink(pos);
                                player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.tower_unlinked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                            } else {
                                sourceEntity.addLink(pos);
                                player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.tower_linked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        tag.m_128473_(TAG_SOURCE);
                        tag.m_128473_(TAG_SOURCE_TYPE);
                        player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.invalid"), true);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            if (!isLinkable) {
                return InteractionResult.PASS;
            }
            CompoundTag t = new CompoundTag();
            t.m_128405_("x", pos.m_123341_());
            t.m_128405_("y", pos.m_123342_());
            t.m_128405_("z", pos.m_123343_());
            tag.m_128365_(TAG_SOURCE, (Tag)t);
            if (isClickedTower) {
                tag.m_128359_(TAG_SOURCE_TYPE, TYPE_TOWER);
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.set_tower", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            } else if (be instanceof OmniBeamFormerBlockEntity) {
                tag.m_128359_(TAG_SOURCE_TYPE, TYPE_OMNI);
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.set_omni", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            } else {
                tag.m_128359_(TAG_SOURCE_TYPE, TYPE_OMNI);
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.set", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!hasSource) {
            if (isLinkable) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.no_source"), true);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        String sourceType = tag.m_128461_(TAG_SOURCE_TYPE);
        if (TYPE_TOWER.equals(sourceType)) {
            boolean isTargetTower = isClickedTower;
            if (!isTargetTower) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.tower_needs_shift"), true);
                }
                return InteractionResult.SUCCESS;
            }
            CompoundTag t = tag.m_128469_(TAG_SOURCE);
            BlockPos source = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
            if (source.equals((Object)pos)) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.self_link"), true);
                }
                return InteractionResult.SUCCESS;
            }
            int dx = Math.abs(pos.m_123341_() - source.m_123341_());
            int dy = Math.abs(pos.m_123342_() - source.m_123342_());
            int dz = Math.abs(pos.m_123343_() - source.m_123343_());
            if (dx > 16 || dz > 16 || dy > 256) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.tower_out_of_range"), true);
                }
                return InteractionResult.SUCCESS;
            }
            WirelessEnergyTowerBlockEntity sourceEntity = this.getTowerBlockEntity(level, source);
            WirelessEnergyTowerBlockEntity targetEntity = this.getTowerBlockEntity(level, pos);
            if (sourceEntity != null && targetEntity != null) {
                boolean isLinked = sourceEntity.getLinks().contains(pos);
                if (isLinked) {
                    sourceEntity.removeLink(pos);
                    targetEntity.removeLink(source);
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.tower_to_tower_unlinked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                    }
                } else {
                    sourceEntity.addLink(pos);
                    targetEntity.addLink(source);
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.tower_to_tower_linked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            tag.m_128473_(TAG_SOURCE);
            tag.m_128473_(TAG_SOURCE_TYPE);
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.invalid"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(be instanceof OmniBeamFormerBlockEntity)) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.omni_only"), true);
            }
            return InteractionResult.SUCCESS;
        }
        CompoundTag t = tag.m_128469_(TAG_SOURCE);
        BlockPos source = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
        if (source.equals((Object)pos)) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.self_link"), true);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity beSource = level.m_7702_(source);
        if (beSource instanceof OmniBeamFormerBlockEntity) {
            OmniBeamFormerBlockEntity sourceEntity = (OmniBeamFormerBlockEntity)beSource;
            int dx = Math.abs(pos.m_123341_() - source.m_123341_());
            int dy = Math.abs(pos.m_123342_() - source.m_123342_());
            int dz = Math.abs(pos.m_123343_() - source.m_123343_());
            if (dx > 16 || dz > 16 || dy > 32) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.out_of_range"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (sourceEntity.getLinks().contains(pos)) {
                sourceEntity.removeLink(pos);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.omni_unlinked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                }
            } else {
                sourceEntity.addLink(pos);
                if (player != null) {
                    player.m_5661_((Component)Component.m_237110_((String)"tooltip.me_beam_former.binding.omni_linked", (Object[])new Object[]{source.m_123341_(), source.m_123342_(), source.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        tag.m_128473_(TAG_SOURCE);
        tag.m_128473_(TAG_SOURCE_TYPE);
        if (player != null) {
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.invalid"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        CompoundTag tag;
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6144_() && (tag = stack.m_41783_()) != null && tag.m_128441_(TAG_SOURCE)) {
            tag.m_128473_(TAG_SOURCE);
            tag.m_128473_(TAG_SOURCE_TYPE);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.me_beam_former.binding.cleared"), true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }
}

