/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer;

import appeng.api.AECapabilities;
import appeng.api.parts.PartModels;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import com.mebeamformer.Config;
import com.mebeamformer.block.BeamFormerBlock;
import com.mebeamformer.block.EnergyNetworkMonitorBlock;
import com.mebeamformer.block.OmniBeamFormerBlock;
import com.mebeamformer.block.WirelessEnergyTowerBlock;
import com.mebeamformer.blockentity.BeamFormerBlockEntity;
import com.mebeamformer.blockentity.EnergyNetworkMonitorBlockEntity;
import com.mebeamformer.blockentity.OmniBeamFormerBlockEntity;
import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import com.mebeamformer.client.render.BeamFormerBER;
import com.mebeamformer.client.render.OmniBeamFormerBER;
import com.mebeamformer.client.render.WirelessEnergyTowerRenderer;
import com.mebeamformer.energy.FluxEnergyAdapter;
import com.mebeamformer.energy.GTEnergyAdapter;
import com.mebeamformer.item.LaserBindingTool;
import com.mebeamformer.part.BeamFormerPart;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="me_beam_former")
public class MEBeamFormer {
    public static final String MODID = "me_beam_former";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"me_beam_former");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"me_beam_former");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"me_beam_former");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"me_beam_former");
    public static final DeferredItem<Item> BEAM_FORMER_PART_ITEM = ITEMS.register("beam_former_part", () -> new PartItem(new Item.Properties(), BeamFormerPart.class, BeamFormerPart::new));
    public static final DeferredBlock<Block> BEAM_FORMER_BLOCK = BLOCKS.register("beam_former_block", () -> new BeamFormerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.3f).sound(SoundType.GLASS).noOcclusion()));
    public static final DeferredItem<Item> BEAM_FORMER_BLOCK_ITEM = ITEMS.register("beam_former_block", () -> new BlockItem((Block)BEAM_FORMER_BLOCK.get(), new Item.Properties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BeamFormerBlockEntity>> BEAM_FORMER_BE = BLOCK_ENTITIES.register("beam_former_block", () -> BlockEntityType.Builder.of(BeamFormerBlockEntity::new, (Block[])new Block[]{(Block)BEAM_FORMER_BLOCK.get()}).build(null));
    public static final DeferredBlock<Block> OMNI_BEAM_FORMER_BLOCK = BLOCKS.register("omni_beam_former_block", () -> new OmniBeamFormerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.3f).sound(SoundType.GLASS).noOcclusion()));
    public static final DeferredItem<Item> OMNI_BEAM_FORMER_BLOCK_ITEM = ITEMS.register("omni_beam_former_block", () -> new BlockItem((Block)OMNI_BEAM_FORMER_BLOCK.get(), new Item.Properties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<OmniBeamFormerBlockEntity>> OMNI_BEAM_FORMER_BE = BLOCK_ENTITIES.register("omni_beam_former_block", () -> BlockEntityType.Builder.of(OmniBeamFormerBlockEntity::new, (Block[])new Block[]{(Block)OMNI_BEAM_FORMER_BLOCK.get()}).build(null));
    public static final DeferredItem<Item> LASER_BINDING_TOOL = ITEMS.register("laser_binding_tool", () -> new LaserBindingTool(new Item.Properties().stacksTo(1)));
    public static final DeferredBlock<Block> WIRELESS_ENERGY_TOWER_BLOCK = BLOCKS.register("wireless_energy_tower", () -> new WirelessEnergyTowerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion()));
    public static final DeferredItem<Item> WIRELESS_ENERGY_TOWER_ITEM = ITEMS.register("wireless_energy_tower", () -> new BlockItem((Block)WIRELESS_ENERGY_TOWER_BLOCK.get(), new Item.Properties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<WirelessEnergyTowerBlockEntity>> WIRELESS_ENERGY_TOWER_BE = BLOCK_ENTITIES.register("wireless_energy_tower", () -> BlockEntityType.Builder.of(WirelessEnergyTowerBlockEntity::new, (Block[])new Block[]{(Block)WIRELESS_ENERGY_TOWER_BLOCK.get()}).build(null));
    public static final DeferredBlock<Block> ENERGY_NETWORK_MONITOR_BLOCK = BLOCKS.register("energy_network_monitor", () -> new EnergyNetworkMonitorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f).sound(SoundType.METAL)));
    public static final DeferredItem<Item> ENERGY_NETWORK_MONITOR_ITEM = ITEMS.register("energy_network_monitor", () -> new BlockItem((Block)ENERGY_NETWORK_MONITOR_BLOCK.get(), new Item.Properties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EnergyNetworkMonitorBlockEntity>> ENERGY_NETWORK_MONITOR_BE = BLOCK_ENTITIES.register("energy_network_monitor", () -> BlockEntityType.Builder.of(EnergyNetworkMonitorBlockEntity::new, (Block[])new Block[]{(Block)ENERGY_NETWORK_MONITOR_BLOCK.get()}).build(null));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).title((Component)Component.translatable((String)"itemGroup.me_beam_former.example_tab")).icon(() -> ((Item)BEAM_FORMER_BLOCK_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)BEAM_FORMER_PART_ITEM.get());
        output.accept((ItemLike)BEAM_FORMER_BLOCK_ITEM.get());
        output.accept((ItemLike)OMNI_BEAM_FORMER_BLOCK_ITEM.get());
        output.accept((ItemLike)LASER_BINDING_TOOL.get());
        output.accept((ItemLike)WIRELESS_ENERGY_TOWER_ITEM.get());
    }).build());

    public MEBeamFormer(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(MEBeamFormer::registerCapabilities);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        try {
            PartModels.registerModels((Collection)PartModelsHelper.createModels(BeamFormerPart.class));
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register AE2 part models for BeamFormerPart", t);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                Object patt1$temp;
                Object patt0$temp = BEAM_FORMER_BLOCK.get();
                if (patt0$temp instanceof BeamFormerBlock) {
                    BeamFormerBlock bf = (BeamFormerBlock)((Object)((Object)patt0$temp));
                    bf.setBlockEntity(BeamFormerBlockEntity.class, (BlockEntityType)BEAM_FORMER_BE.get(), BeamFormerBlockEntity::clientTick, BeamFormerBlockEntity::serverTick);
                }
                if ((patt1$temp = OMNI_BEAM_FORMER_BLOCK.get()) instanceof OmniBeamFormerBlock) {
                    OmniBeamFormerBlock obf = (OmniBeamFormerBlock)((Object)((Object)patt1$temp));
                    obf.setBlockEntity(OmniBeamFormerBlockEntity.class, (BlockEntityType)OMNI_BEAM_FORMER_BE.get(), OmniBeamFormerBlockEntity::clientTick, OmniBeamFormerBlockEntity::serverTick);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to bind BlockEntities", t);
            }
        });
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)BEAM_FORMER_BE.get(), (blockEntity, context) -> blockEntity);
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)OMNI_BEAM_FORMER_BE.get(), (blockEntity, context) -> blockEntity);
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)WIRELESS_ENERGY_TOWER_BE.get(), (blockEntity, context) -> blockEntity);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)WIRELESS_ENERGY_TOWER_BE.get(), (blockEntity, context) -> blockEntity);
        try {
            Class<?> fluxCapClass = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
            Field blockCapField = fluxCapClass.getField("BLOCK");
            BlockCapability fluxCap = (BlockCapability)blockCapField.get(null);
            event.registerBlockEntity(fluxCap, (BlockEntityType)WIRELESS_ENERGY_TOWER_BE.get(), (blockEntity, context) -> FluxEnergyAdapter.createFluxAdapter(blockEntity));
            LOGGER.info("Successfully registered Flux Networks Long Energy capability for Wireless Energy Tower");
        }
        catch (Exception e) {
            LOGGER.info("Flux Networks not installed, Long Energy capability not registered");
        }
        try {
            Object gtCap;
            if (GTEnergyAdapter.isGTAvailable() && (gtCap = GTEnergyAdapter.getGTCapability()) != null) {
                BlockCapability gtCapability = (BlockCapability)gtCap;
                event.registerBlockEntity(gtCapability, (BlockEntityType)WIRELESS_ENERGY_TOWER_BE.get(), (blockEntity, context) -> GTEnergyAdapter.createGTAdapter(blockEntity));
                LOGGER.info("Successfully registered GregTech CEu Energy capability for Wireless Energy Tower (4 FE = 1 EU)");
            }
        }
        catch (Exception e) {
            LOGGER.info("GregTech CEu not installed, GT energy capability not registered: {}", (Object)e.getMessage());
        }
    }

    @EventBusSubscriber(modid="me_beam_former", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BEAM_FORMER_BE.get()), ctx -> new BeamFormerBER(ctx));
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)OMNI_BEAM_FORMER_BE.get()), ctx -> new OmniBeamFormerBER(ctx));
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)WIRELESS_ENERGY_TOWER_BE.get()), ctx -> new WirelessEnergyTowerRenderer(ctx));
            });
        }
    }
}

