/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import com.mebeamformer.MEBeamFormer;
import com.mebeamformer.block.OmniBeamFormerBlock;
import com.mebeamformer.blockentity.ILinkable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class OmniBeamFormerBlockEntity
extends AENetworkedBlockEntity
implements ILinkable {
    private final Set<BlockPos> links = new HashSet<BlockPos>();
    private final Map<BlockPos, IGridConnection> connections = new HashMap<BlockPos, IGridConnection>();
    private List<BlockPos> clientActiveTargets = Collections.emptyList();
    private final Set<BlockPos> lastActiveSet = new HashSet<BlockPos>();
    private Direction lastExposedBack = null;

    public OmniBeamFormerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MEBeamFormer.OMNI_BEAM_FORMER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    }

    public AECableType getCableConnectionType(Direction dir) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)OmniBeamFormerBlock.FACING);
        return dir == facing.getOpposite() ? AECableType.SMART : AECableType.NONE;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)OmniBeamFormerBlock.FACING);
        return EnumSet.of(facing.getOpposite());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OmniBeamFormerBlockEntity be) {
        OmniBeamFormerBlock.Status targetStatus;
        IManagedGridNode myManaged;
        IGridNode myNode;
        if (be.isRemoved()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)OmniBeamFormerBlock.FACING);
        Direction back = facing.getOpposite();
        if (be.lastExposedBack != back) {
            IManagedGridNode managed = be.getMainNode();
            if (managed != null) {
                managed.setExposedOnSides(EnumSet.of(back));
            }
            be.lastExposedBack = back;
        }
        IGridNode iGridNode = myNode = (myManaged = be.getMainNode()) != null ? myManaged.getNode() : null;
        if (myNode == null) {
            if (!be.lastActiveSet.isEmpty()) {
                be.lastActiveSet.clear();
                be.markForUpdate();
            }
            return;
        }
        HashSet<BlockPos> activeNow = new HashSet<BlockPos>();
        for (BlockPos targetPos : new HashSet<BlockPos>(be.links)) {
            boolean bOk;
            BlockEntity tBe = level.getBlockEntity(targetPos);
            if (!(tBe instanceof OmniBeamFormerBlockEntity)) {
                be.removeLink(targetPos);
                continue;
            }
            OmniBeamFormerBlockEntity other = (OmniBeamFormerBlockEntity)tBe;
            IManagedGridNode otherManaged = other.getMainNode();
            IGridNode otherNode = otherManaged != null ? otherManaged.getNode() : null;
            if (otherNode == null) continue;
            IGridConnection conn = be.connections.get(targetPos);
            if (conn == null || conn.getOtherSide(myNode) != otherNode) {
                IGridConnection existing = myNode.getConnections().stream().filter(c -> c.getOtherSide(myNode) == otherNode).findFirst().orElse(null);
                if (existing == null) {
                    try {
                        existing = GridHelper.createConnection((IGridNode)myNode, (IGridNode)otherNode);
                    }
                    catch (IllegalStateException ignored) {
                        existing = myNode.getConnections().stream().filter(c -> c.getOtherSide(myNode) == otherNode).findFirst().orElse(null);
                    }
                }
                if (existing != null) {
                    be.connections.put(targetPos, existing);
                    other.connections.put(pos, existing);
                }
            }
            boolean aOk = myManaged.isOnline() && myManaged.isPowered();
            boolean bl = bOk = otherManaged.isOnline() && otherManaged.isPowered();
            if (!aOk || !bOk) continue;
            activeNow.add(targetPos);
        }
        if (!be.lastActiveSet.equals(activeNow)) {
            be.lastActiveSet.clear();
            be.lastActiveSet.addAll(activeNow);
            be.markForUpdate();
        }
        BlockState curState = level.getBlockState(pos);
        OmniBeamFormerBlock.Status status = targetStatus = activeNow.isEmpty() ? OmniBeamFormerBlock.Status.ON : OmniBeamFormerBlock.Status.BEAMING;
        if (curState.getBlock() instanceof OmniBeamFormerBlock && curState.getValue(OmniBeamFormerBlock.STATUS) != targetStatus) {
            level.setBlock(pos, (BlockState)curState.setValue(OmniBeamFormerBlock.STATUS, (Comparable)((Object)targetStatus)), 3);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, OmniBeamFormerBlockEntity be) {
    }

    @Override
    public void addLink(BlockPos other) {
        if (other.equals((Object)this.getBlockPos())) {
            return;
        }
        if (this.links.add(other)) {
            this.setChanged();
        }
    }

    @Override
    public void removeLink(BlockPos other) {
        if (this.links.remove(other)) {
            IGridConnection c = this.connections.remove(other);
            if (c != null) {
                try {
                    c.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.setChanged();
        }
    }

    @Override
    public Set<BlockPos> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public List<BlockPos> getClientActiveTargets() {
        return this.clientActiveTargets;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        data.writeVarInt(this.lastActiveSet.size());
        for (BlockPos p : this.lastActiveSet) {
            data.writeBlockPos(p);
        }
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        int n = data.readVarInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            list.add(data.readBlockPos());
        }
        boolean changed = !list.equals(this.clientActiveTargets);
        this.clientActiveTargets = list;
        return changed;
    }

    public void onChunkUnloaded() {
        this.disconnectAll();
        super.onChunkUnloaded();
    }

    public void setRemoved() {
        super.setRemoved();
        this.disconnectAll();
    }

    private void disconnectAll() {
        for (IGridConnection c : this.connections.values()) {
            try {
                c.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.connections.clear();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag list = new ListTag();
        for (BlockPos p : this.links) {
            CompoundTag t = new CompoundTag();
            t.putInt("x", p.getX());
            t.putInt("y", p.getY());
            t.putInt("z", p.getZ());
            list.add((Object)t);
        }
        tag.put("links", (Tag)list);
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.links.clear();
        if (tag.contains("links", 9)) {
            ListTag list = tag.getList("links", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.getCompound(i);
                BlockPos pos = new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z"));
                this.links.add(pos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.clientActiveTargets == null || this.clientActiveTargets.isEmpty()) {
            BlockPos pos = this.getBlockPos();
            return new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 5), (double)(pos.getZ() - 5), (double)(pos.getX() + 6), (double)(pos.getY() + 6), (double)(pos.getZ() + 6));
        }
        BlockPos pos = this.getBlockPos();
        double minX = pos.getX();
        double minY = pos.getY();
        double minZ = pos.getZ();
        double maxX = pos.getX() + 1;
        double maxY = pos.getY() + 1;
        double maxZ = pos.getZ() + 1;
        for (BlockPos target : this.clientActiveTargets) {
            minX = Math.min(minX, (double)target.getX());
            minY = Math.min(minY, (double)target.getY());
            minZ = Math.min(minZ, (double)target.getZ());
            maxX = Math.max(maxX, (double)(target.getX() + 1));
            maxY = Math.max(maxY, (double)(target.getY() + 1));
            maxZ = Math.max(maxZ, (double)(target.getZ() + 1));
        }
        double expansion = 2.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }
}

