/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.util.AEColor;
import com.mebeamformer.block.BeamFormerBlock;
import com.mebeamformer.blockentity.BeamFormerBlockEntity;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BeamFormerBER
implements BlockEntityRenderer<BeamFormerBlockEntity> {
    public BeamFormerBER(BlockEntityRendererProvider.Context ctx) {
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(BeamFormerBlockEntity te) {
        return te != null && te.getBeamLength() > 0;
    }

    public void render(BeamFormerBlockEntity te, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        IColorableBlockEntity cbe;
        AEColor color;
        int checkLen;
        if (te == null) {
            return;
        }
        BlockState state = te.getBlockState();
        if (!(state.getBlock() instanceof BeamFormerBlock)) {
            return;
        }
        if (!te.shouldRenderBeam()) {
            return;
        }
        Direction dir = (Direction)state.getValue((Property)BeamFormerBlock.FACING);
        int len = Math.max(0, te.getBeamLength());
        double visibleLen = len;
        if (visibleLen <= 0.0) {
            return;
        }
        Level level = te.getLevel();
        BlockPos pos = te.getBlockPos();
        if (level == null) {
            return;
        }
        int n = checkLen = len > 0 ? len : 1;
        if (!this.isPathClearForRender(level, pos, dir, checkLen)) {
            return;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        BlockPos back = pos.relative(dir.getOpposite());
        BlockEntity backBe = level.getBlockEntity(back);
        if (backBe instanceof IColorableBlockEntity && (color = (cbe = (IColorableBlockEntity)backBe).getColor()) != null) {
            int hex = color.blackVariant;
            float scale = 255.0f;
            r = (float)(hex >> 16 & 0xFF) / scale;
            g = (float)(hex >> 8 & 0xFF) / scale;
            b = (float)(hex & 0xFF) / scale;
        }
        float thickness = 0.28f;
        BeamRenderHelper.renderColoredBeam(poseStack, buffers, dir, visibleLen, r, g, b, packedLight, packedOverlay, thickness);
    }

    private boolean isPathClearForRender(Level level, BlockPos start, Direction dir, int length) {
        BlockPos cur = start;
        for (int i = 0; i < length; ++i) {
            Direction otherFacing;
            BlockState state = level.getBlockState(cur = cur.relative(dir));
            if (state.canOcclude() && !state.isAir()) {
                BlockEntity other = level.getBlockEntity(cur);
                if (other instanceof BeamFormerBlockEntity) {
                    otherFacing = (Direction)level.getBlockState(cur).getValue((Property)BeamFormerBlock.FACING);
                    if (i == length - 1 && otherFacing == dir.getOpposite()) {
                        return true;
                    }
                }
                return false;
            }
            BlockEntity be = level.getBlockEntity(cur);
            if (!(be instanceof BeamFormerBlockEntity) || (otherFacing = (Direction)level.getBlockState(cur).getValue((Property)BeamFormerBlock.FACING)) != dir) continue;
            return false;
        }
        return true;
    }
}

