/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.util.AEColor;
import com.mebeamformer.block.BeamFormerBlock;
import com.mebeamformer.block.OmniBeamFormerBlock;
import com.mebeamformer.blockentity.OmniBeamFormerBlockEntity;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OmniBeamFormerBER
implements BlockEntityRenderer<OmniBeamFormerBlockEntity> {
    public OmniBeamFormerBER(BlockEntityRendererProvider.Context ctx) {
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(OmniBeamFormerBlockEntity be) {
        List<BlockPos> targets = be != null ? be.getClientActiveTargets() : null;
        return targets != null && !targets.isEmpty();
    }

    public void render(OmniBeamFormerBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        List<BlockPos> targets;
        if (be == null) {
            return;
        }
        BlockState state = be.getBlockState();
        if (!(state.getBlock() instanceof OmniBeamFormerBlock)) {
            return;
        }
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        BlockPos pos = be.getBlockPos();
        for (Direction d : Direction.values()) {
            IColorableBlockEntity cbe;
            AEColor color;
            BlockEntity adj = level.getBlockEntity(pos.relative(d));
            if (!(adj instanceof IColorableBlockEntity) || (color = (cbe = (IColorableBlockEntity)adj).getColor()) == null) continue;
            int hex = color.blackVariant;
            float scale = 255.0f;
            r = (float)(hex >> 16 & 0xFF) / scale;
            g = (float)(hex >> 8 & 0xFF) / scale;
            b = (float)(hex & 0xFF) / scale;
            break;
        }
        if ((targets = be.getClientActiveTargets()) == null || targets.isEmpty()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)OmniBeamFormerBlock.FACING);
        float thickness = 0.08f;
        for (BlockPos t : targets) {
            BlockState targetState = level.getBlockState(t);
            Direction targetFacing = Direction.SOUTH;
            if (targetState.getBlock() instanceof BeamFormerBlock) {
                targetFacing = (Direction)targetState.getValue((Property)BeamFormerBlock.FACING);
            } else if (targetState.getBlock() instanceof OmniBeamFormerBlock) {
                targetFacing = (Direction)targetState.getValue((Property)OmniBeamFormerBlock.FACING);
            }
            float targetX = (float)t.getX() + 0.5f + (float)targetFacing.getStepX() * 0.25f;
            float targetY = (float)t.getY() + 0.5f + (float)targetFacing.getStepY() * 0.25f;
            float targetZ = (float)t.getZ() + 0.5f + (float)targetFacing.getStepZ() * 0.25f;
            float startX = (float)pos.getX() + 0.5f + (float)facing.getStepX() * 0.25f;
            float startY = (float)pos.getY() + 0.5f + (float)facing.getStepY() * 0.25f;
            float startZ = (float)pos.getZ() + 0.5f + (float)facing.getStepZ() * 0.25f;
            float vx = targetX - startX;
            float vy = targetY - startY;
            float vz = targetZ - startZ;
            double vectorLength = Math.sqrt(vx * vx + vy * vy + vz * vz);
            if (vectorLength <= 0.2) continue;
            float normalizedVx = (float)((double)vx / vectorLength);
            float normalizedVy = (float)((double)vy / vectorLength);
            float normalizedVz = (float)((double)vz / vectorLength);
            float adjustedStartX = startX + normalizedVx * 0.2f;
            float adjustedStartY = startY + normalizedVy * 0.2f;
            float adjustedStartZ = startZ + normalizedVz * 0.2f;
            float adjustedTargetX = targetX + normalizedVx * 0.1f;
            float adjustedTargetY = targetY + normalizedVy * 0.1f;
            float adjustedTargetZ = targetZ + normalizedVz * 0.1f;
            float adjustedVx = adjustedTargetX - adjustedStartX;
            float adjustedVy = adjustedTargetY - adjustedStartY;
            float adjustedVz = adjustedTargetZ - adjustedStartZ;
            poseStack.pushPose();
            poseStack.translate(adjustedStartX - ((float)pos.getX() + 0.5f), adjustedStartY - ((float)pos.getY() + 0.5f), adjustedStartZ - ((float)pos.getZ() + 0.5f));
            BeamRenderHelper.renderColoredBeamVector(poseStack, buffers, adjustedVx, adjustedVy, adjustedVz, r, g, b, packedLight, packedOverlay, thickness);
            poseStack.popPose();
        }
    }
}

