/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import com.mebeamformer.Config;
import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mebeamformer.item.LaserBindingTool;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WirelessEnergyTowerRenderer
implements BlockEntityRenderer<WirelessEnergyTowerBlockEntity> {
    public WirelessEnergyTowerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public int getViewDistance() {
        return 512;
    }

    public boolean shouldRenderOffScreen(WirelessEnergyTowerBlockEntity be) {
        List<BlockPos> links = be != null ? be.getClientLinks() : null;
        return links != null && !links.isEmpty();
    }

    public void render(WirelessEnergyTowerBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        List<BlockPos> links;
        if (be == null) {
            return;
        }
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        if (!Config.alwaysRenderBeams) {
            boolean holdingBindingTool;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            boolean bl = holdingBindingTool = player.getMainHandItem().getItem() instanceof LaserBindingTool || player.getOffhandItem().getItem() instanceof LaserBindingTool;
            if (!holdingBindingTool) {
                return;
            }
        }
        if ((links = be.getClientLinks()) == null || links.isEmpty()) {
            return;
        }
        BlockPos towerBasePos = be.getBlockPos();
        float towerTopCenterX = (float)towerBasePos.getX() + 0.5f;
        float towerTopCenterY = (float)towerBasePos.getY() + 2.75f;
        float towerTopCenterZ = (float)towerBasePos.getZ() + 0.5f;
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float thickness = 0.04f;
        for (BlockPos targetPos : links) {
            float vz;
            float vy;
            float vx;
            double vectorLength;
            BlockEntity targetBE = level.getBlockEntity(targetPos);
            boolean isTargetTower = targetBE instanceof WirelessEnergyTowerBlockEntity;
            float targetCenterX = (float)targetPos.getX() + 0.5f;
            float targetCenterY = (float)targetPos.getY() + 0.5f;
            float targetCenterZ = (float)targetPos.getZ() + 0.5f;
            if (isTargetTower) {
                targetCenterY = (float)targetPos.getY() + 2.75f;
            }
            if ((vectorLength = Math.sqrt((vx = targetCenterX - towerTopCenterX) * vx + (vy = targetCenterY - towerTopCenterY) * vy + (vz = targetCenterZ - towerTopCenterZ) * vz)) <= 0.1) continue;
            float normalizedVx = (float)((double)vx / vectorLength);
            float normalizedVy = (float)((double)vy / vectorLength);
            float normalizedVz = (float)((double)vz / vectorLength);
            float startOffsetX = normalizedVx * 0.25f;
            float startOffsetY = normalizedVy * 0.25f;
            float startOffsetZ = normalizedVz * 0.25f;
            float endOffsetX = isTargetTower ? -normalizedVx * 0.25f : 0.0f;
            float endOffsetY = isTargetTower ? -normalizedVy * 0.25f : 0.0f;
            float endOffsetZ = isTargetTower ? -normalizedVz * 0.25f : 0.0f;
            float adjustedVx = vx - startOffsetX - endOffsetX;
            float adjustedVy = vy - startOffsetY - endOffsetY;
            float adjustedVz = vz - startOffsetZ - endOffsetZ;
            poseStack.pushPose();
            poseStack.translate((double)startOffsetX, 2.25 + (double)startOffsetY, (double)startOffsetZ);
            BeamRenderHelper.renderColoredBeamVector(poseStack, buffers, adjustedVx, adjustedVy, adjustedVz, r, g, b, packedLight, packedOverlay, thickness);
            poseStack.popPose();
        }
    }
}

