/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.energy;

import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.minecraft.core.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTEnergyAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GTEnergyAdapter.class);
    private static volatile boolean GT_INITIALIZED = false;
    private static Class<?> GT_ENERGY_CONTAINER_CLASS = null;
    private static Class<?> GT_CAPABILITY_CLASS = null;
    public static final long FE_TO_EU_RATIO = 4L;
    public static final long EU_TO_FE_RATIO = 4L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initGTReflection() {
        if (GT_INITIALIZED) {
            return;
        }
        Class<GTEnergyAdapter> clazz = GTEnergyAdapter.class;
        synchronized (GTEnergyAdapter.class) {
            if (GT_INITIALIZED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                GT_ENERGY_CONTAINER_CLASS = Class.forName("com.gregtechceu.gtceu.api.capability.IEnergyContainer");
                GT_CAPABILITY_CLASS = Class.forName("com.gregtechceu.gtceu.api.capability.GTCapability");
                LOGGER.info("GregTech CEu detected, energy conversion enabled (4 FE = 1 EU)");
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("GregTech CEu not installed, GT energy support disabled");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to initialize GregTech reflection: {}", (Object)e.getMessage());
            }
            GT_INITIALIZED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isGTAvailable() {
        GTEnergyAdapter.initGTReflection();
        return GT_ENERGY_CONTAINER_CLASS != null;
    }

    public static Object getGTCapability() {
        GTEnergyAdapter.initGTReflection();
        if (GT_CAPABILITY_CLASS == null) {
            return null;
        }
        try {
            Field capField = GT_CAPABILITY_CLASS.getField("CAPABILITY_ENERGY_CONTAINER");
            return capField.get(null);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get GT energy capability: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Object createGTAdapter(WirelessEnergyTowerBlockEntity tower) {
        GTEnergyAdapter.initGTReflection();
        if (GT_ENERGY_CONTAINER_CLASS == null) {
            throw new IllegalStateException("GregTech not available");
        }
        return Proxy.newProxyInstance(GT_ENERGY_CONTAINER_CLASS.getClassLoader(), new Class[]{GT_ENERGY_CONTAINER_CLASS}, (InvocationHandler)new GTInvocationHandler(tower));
    }

    public static long feToEU(long fe) {
        return fe / 4L;
    }

    public static long euToFE(long eu) {
        return eu * 4L;
    }

    private static class GTInvocationHandler
    implements InvocationHandler {
        private final WirelessEnergyTowerBlockEntity tower;

        public GTInvocationHandler(WirelessEnergyTowerBlockEntity tower) {
            this.tower = tower;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            try {
                switch (methodName) {
                    case "acceptEnergyFromNetwork": {
                        if (args != null && args.length == 3) {
                            Direction side = (Direction)args[0];
                            long voltage = (Long)args[1];
                            long amperage = (Long)args[2];
                            long totalEU = voltage * amperage;
                            long totalFE = totalEU * 4L;
                            long receivedFE = this.tower.receiveEnergyL(totalFE, false);
                            long receivedEU = receivedFE / 4L;
                            long receivedAmperage = voltage > 0L ? receivedEU / voltage : 0L;
                            return receivedAmperage;
                        }
                        return 0L;
                    }
                    case "inputsEnergy": {
                        return true;
                    }
                    case "changeEnergy": {
                        if (args != null && args.length == 1) {
                            long differenceEU = (Long)args[0];
                            long differenceFE = differenceEU * 4L;
                            if (differenceFE > 0L) {
                                long receivedFE = this.tower.receiveEnergyL(differenceFE, false);
                                return receivedFE / 4L;
                            }
                            if (differenceFE < 0L) {
                                long extractedFE = this.tower.extractEnergyL(-differenceFE, false);
                                return -(extractedFE / 4L);
                            }
                        }
                        return 0L;
                    }
                    case "getEnergyCanBeInserted": {
                        long spaceEU = (this.tower.getMaxEnergyStoredL() - this.tower.getEnergyStoredL()) / 4L;
                        return spaceEU;
                    }
                    case "getInputAmperage": {
                        return 0x3FFFFFFFFFFFFFL;
                    }
                    case "getInputVoltage": {
                        return 8192L;
                    }
                    case "outputsEnergy": {
                        return this.tower.hasTargets();
                    }
                    case "getEnergyStored": {
                        long storedFE = this.tower.getEnergyStoredL();
                        return storedFE / 4L;
                    }
                    case "getEnergyCapacity": {
                        long capacityFE = this.tower.getMaxEnergyStoredL();
                        return capacityFE / 4L;
                    }
                    case "getOutputAmperage": {
                        return 64L;
                    }
                    case "getOutputVoltage": {
                        return 8192L;
                    }
                    case "toString": {
                        return "GTEnergyAdapter[" + String.valueOf(this.tower) + "]";
                    }
                    case "hashCode": {
                        return this.tower.hashCode();
                    }
                    case "equals": {
                        InvocationHandler handler;
                        Object other;
                        if (args != null && args.length == 1 && Proxy.isProxyClass((other = args[0]).getClass()) && (handler = Proxy.getInvocationHandler(other)) instanceof GTInvocationHandler) {
                            return this.tower.equals(((GTInvocationHandler)handler).tower);
                        }
                        return false;
                    }
                }
                LOGGER.warn("Unhandled GT IEnergyContainer method: {} ({})", (Object)methodName, (Object)method);
                Class<?> returnType = method.getReturnType();
                if (returnType == Boolean.TYPE) {
                    return false;
                }
                if (returnType == Long.TYPE) {
                    return 0L;
                }
                if (returnType == Integer.TYPE) {
                    return 0;
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Error invoking GT method {}: {}", new Object[]{methodName, e.getMessage(), e});
                throw e;
            }
        }
    }
}

