/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.integration;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class AE2FluxIntegration {
    private static final boolean APPFLUX_LOADED = ModList.get().isLoaded("appflux");
    private static Class<?> fluxKeyClass;
    private static Class<?> energyTypeClass;
    private static Method fluxKeyOfMethod;
    private static Object energyTypeFE;

    private static void initializeAppfluxReflection() throws Exception {
        fluxKeyClass = Class.forName("com.glodblock.github.appflux.common.me.key.FluxKey");
        energyTypeClass = Class.forName("com.glodblock.github.appflux.common.me.key.type.EnergyType");
        fluxKeyOfMethod = fluxKeyClass.getMethod("of", energyTypeClass);
        energyTypeFE = energyTypeClass.getField("FE").get(null);
    }

    public static boolean isAvailable() {
        return APPFLUX_LOADED && fluxKeyClass != null;
    }

    public static long extractEnergyFromOwnNetwork(AENetworkedBlockEntity aeBlockEntity, long amount, boolean simulate) {
        if (!AE2FluxIntegration.isAvailable() || amount <= 0L) {
            return 0L;
        }
        try {
            return AE2FluxIntegration.extractFromAEBlockEntity(aeBlockEntity, amount, simulate);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long extractEnergyFromNetwork(@Nullable Level level, BlockPos pos, long amount, boolean simulate) {
        if (!AE2FluxIntegration.isAvailable() || level == null || amount <= 0L) {
            return 0L;
        }
        try {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        AENetworkedBlockEntity aeBlockEntity;
                        long extracted;
                        BlockPos checkPos = pos.offset(dx, dy, dz);
                        BlockEntity be = level.getBlockEntity(checkPos);
                        if (!(be instanceof AENetworkedBlockEntity) || (extracted = AE2FluxIntegration.extractFromAEBlockEntity(aeBlockEntity = (AENetworkedBlockEntity)be, amount, simulate)) <= 0L) continue;
                        return extracted;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private static long extractFromAEBlockEntity(AENetworkedBlockEntity be, long amount, boolean simulate) throws Exception {
        IManagedGridNode mainNode = be.getMainNode();
        if (mainNode == null || !mainNode.isReady()) {
            return 0L;
        }
        IGrid grid = mainNode.getGrid();
        if (grid == null) {
            return 0L;
        }
        IStorageService storageService = grid.getStorageService();
        if (storageService == null) {
            return 0L;
        }
        MEStorage inventory = storageService.getInventory();
        if (inventory == null) {
            return 0L;
        }
        Object fluxKeyObj = fluxKeyOfMethod.invoke(null, energyTypeFE);
        if (!(fluxKeyObj instanceof AEKey)) {
            return 0L;
        }
        AEKey fluxKey = (AEKey)fluxKeyObj;
        Actionable actionable = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        IActionSource actionSource = IActionSource.ofMachine((IActionHost)be);
        long result = inventory.extract(fluxKey, amount, actionable, actionSource);
        return result;
    }

    public static boolean hasNearbyNetwork(@Nullable Level level, BlockPos pos) {
        if (!AE2FluxIntegration.isAvailable() || level == null) {
            return false;
        }
        try {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        IGrid grid;
                        AENetworkedBlockEntity aeBlockEntity;
                        IManagedGridNode mainNode;
                        BlockPos checkPos = pos.offset(dx, dy, dz);
                        BlockEntity be = level.getBlockEntity(checkPos);
                        if (!(be instanceof AENetworkedBlockEntity) || (mainNode = (aeBlockEntity = (AENetworkedBlockEntity)be).getMainNode()) == null || !mainNode.isReady() || (grid = mainNode.getGrid()) == null) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        if (APPFLUX_LOADED) {
            try {
                AE2FluxIntegration.initializeAppfluxReflection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

