/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.item;

import com.mebeamformer.block.WirelessEnergyTowerBlock;
import com.mebeamformer.blockentity.ILinkable;
import com.mebeamformer.blockentity.OmniBeamFormerBlockEntity;
import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class LaserBindingTool
extends Item {
    private static final String TAG_SOURCE = "SourcePos";
    private static final String TAG_SOURCE_TYPE = "SourceType";
    private static final String TYPE_TOWER = "tower";
    private static final String TYPE_OMNI = "omni";

    public LaserBindingTool(Item.Properties props) {
        super(props);
    }

    private BlockPos getTowerBasePos(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof WirelessEnergyTowerBlock) {
            int part = (Integer)state.getValue((Property)WirelessEnergyTowerBlock.PART);
            return pos.below(part);
        }
        return pos;
    }

    private WirelessEnergyTowerBlockEntity getTowerBlockEntity(Level level, BlockPos pos) {
        BlockPos basePos = this.getTowerBasePos(level, pos);
        BlockEntity be = level.getBlockEntity(basePos);
        if (be instanceof WirelessEnergyTowerBlockEntity) {
            WirelessEnergyTowerBlockEntity tower = (WirelessEnergyTowerBlockEntity)be;
            return tower;
        }
        return null;
    }

    private boolean hasEnergyCapability(BlockEntity be) {
        if (be == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            IEnergyStorage cap = (IEnergyStorage)be.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)dir);
            if (cap == null) continue;
            return true;
        }
        try {
            Class<?> exception = Class.forName("com.gregtechceu.gtceu.api.capability.GTCapability");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        BlockPos pos = this.getTowerBasePos(level, clickedPos);
        BlockEntity be = level.getBlockEntity(pos);
        BlockState clickedState = level.getBlockState(clickedPos);
        boolean isClickedTower = clickedState.getBlock() instanceof WirelessEnergyTowerBlock;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        boolean hasSource = tag.contains(TAG_SOURCE);
        boolean isLinkable = be instanceof ILinkable;
        boolean hasEnergy = this.hasEnergyCapability(be);
        if (player != null && player.isShiftKeyDown()) {
            String sourceType;
            if (hasSource && TYPE_TOWER.equals(sourceType = tag.getString(TAG_SOURCE_TYPE))) {
                boolean isTargetTower = isClickedTower;
                if (isTargetTower) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_to_tower_needs_normal_click"), true);
                    return InteractionResult.SUCCESS;
                }
                if (!isLinkable) {
                    if (hasEnergy) {
                        CompoundTag t = tag.getCompound(TAG_SOURCE);
                        BlockPos source = new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z"));
                        if (source.equals((Object)pos)) {
                            player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.self_link"), true);
                            return InteractionResult.SUCCESS;
                        }
                        WirelessEnergyTowerBlockEntity sourceEntity = this.getTowerBlockEntity(level, source);
                        if (sourceEntity != null) {
                            if (sourceEntity.getLinks().contains(pos)) {
                                sourceEntity.removeLink(pos);
                                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_unlinked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                            } else {
                                sourceEntity.addLink(pos);
                                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_linked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        tag.remove(TAG_SOURCE);
                        tag.remove(TAG_SOURCE_TYPE);
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.invalid"), true);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            if (!isLinkable) {
                return InteractionResult.PASS;
            }
            CompoundTag t = new CompoundTag();
            t.putInt("x", pos.getX());
            t.putInt("y", pos.getY());
            t.putInt("z", pos.getZ());
            tag.put(TAG_SOURCE, (Tag)t);
            if (isClickedTower) {
                tag.putString(TAG_SOURCE_TYPE, TYPE_TOWER);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.set_tower", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
            } else if (be instanceof OmniBeamFormerBlockEntity) {
                tag.putString(TAG_SOURCE_TYPE, TYPE_OMNI);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.set_omni", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
            } else {
                tag.putString(TAG_SOURCE_TYPE, TYPE_OMNI);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.set", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
            }
            return InteractionResult.CONSUME;
        }
        if (!hasSource) {
            if (isLinkable) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.no_source"), true);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        String sourceType = tag.getString(TAG_SOURCE_TYPE);
        if (TYPE_TOWER.equals(sourceType)) {
            boolean isTargetTower = isClickedTower;
            if (!isTargetTower) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_needs_shift"), true);
                }
                return InteractionResult.SUCCESS;
            }
            CompoundTag t = tag.getCompound(TAG_SOURCE);
            BlockPos source = new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z"));
            if (source.equals((Object)pos)) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.self_link"), true);
                }
                return InteractionResult.SUCCESS;
            }
            int dx = Math.abs(pos.getX() - source.getX());
            int dy = Math.abs(pos.getY() - source.getY());
            int dz = Math.abs(pos.getZ() - source.getZ());
            if (dx > 20 || dz > 20 || dy > 256) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_out_of_range"), true);
                }
                return InteractionResult.SUCCESS;
            }
            WirelessEnergyTowerBlockEntity sourceEntity = this.getTowerBlockEntity(level, source);
            WirelessEnergyTowerBlockEntity targetEntity = this.getTowerBlockEntity(level, pos);
            if (sourceEntity != null && targetEntity != null) {
                boolean isLinked = sourceEntity.getLinks().contains(pos);
                if (isLinked) {
                    sourceEntity.removeLink(pos);
                    targetEntity.removeLink(source);
                    if (player != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_to_tower_unlinked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                    }
                } else {
                    sourceEntity.addLink(pos);
                    targetEntity.addLink(source);
                    if (player != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.tower_to_tower_linked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            tag.remove(TAG_SOURCE);
            tag.remove(TAG_SOURCE_TYPE);
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.invalid"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(be instanceof OmniBeamFormerBlockEntity)) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.omni_only"), true);
            }
            return InteractionResult.SUCCESS;
        }
        CompoundTag t = tag.getCompound(TAG_SOURCE);
        BlockPos source = new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z"));
        if (source.equals((Object)pos)) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.self_link"), true);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity beSource = level.getBlockEntity(source);
        if (beSource instanceof OmniBeamFormerBlockEntity) {
            OmniBeamFormerBlockEntity sourceEntity = (OmniBeamFormerBlockEntity)beSource;
            int dx = Math.abs(pos.getX() - source.getX());
            int dy = Math.abs(pos.getY() - source.getY());
            int dz = Math.abs(pos.getZ() - source.getZ());
            if (dx > 16 || dz > 16 || dy > 32) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.out_of_range"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (sourceEntity.getLinks().contains(pos)) {
                sourceEntity.removeLink(pos);
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.omni_unlinked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                }
            } else {
                sourceEntity.addLink(pos);
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.omni_linked", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), pos.getX(), pos.getY(), pos.getZ()}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        tag.remove(TAG_SOURCE);
        tag.remove(TAG_SOURCE_TYPE);
        if (player != null) {
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.invalid"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        CompoundTag tag;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown() && (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains(TAG_SOURCE)) {
            tag.remove(TAG_SOURCE);
            tag.remove(TAG_SOURCE_TYPE);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.me_beam_former.binding.cleared"), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, hand);
    }
}

