/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.mebeamformer.ME_Beam_Former;
import com.mebeamformer.block.BeamFormerBlock;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeamFormerBlockEntity
extends AENetworkBlockEntity {
    private int beamLength = 0;
    private IGridConnection connection = null;
    private boolean hideBeam = false;
    private Direction lastExposedBack = null;

    public BeamFormerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ME_Beam_Former.BEAM_FORMER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    }

    public AECableType getCableConnectionType(Direction dir) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BeamFormerBlock.FACING);
        if (dir == facing.m_122424_()) {
            return AECableType.SMART;
        }
        return AECableType.NONE;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BeamFormerBlock.FACING);
        return EnumSet.of(facing.m_122424_());
    }

    public int getBeamLength() {
        return this.beamLength;
    }

    public boolean isHideBeam() {
        return this.hideBeam;
    }

    public boolean shouldRenderBeam() {
        return !this.hideBeam && this.beamLength > 0;
    }

    public void toggleBeamVisibility() {
        boolean bl = this.hideBeam = !this.hideBeam;
        if (this.connection != null) {
            try {
                Object owner;
                IGridNode otherNode;
                IGridNode myNode = this.getMainNode().getNode();
                if (myNode != null && (otherNode = this.connection.getOtherSide(myNode)) != null && (owner = otherNode.getOwner()) instanceof BeamFormerBlockEntity) {
                    BeamFormerBlockEntity other = (BeamFormerBlockEntity)((Object)owner);
                    other.hideBeam = this.hideBeam;
                    other.markForUpdate();
                    other.m_6596_();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.markForUpdate();
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BeamFormerBlockEntity be) {
        IManagedGridNode mainNode;
        IGridNode aNode;
        if (be.m_58901_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BeamFormerBlock.FACING);
        Direction back = facing.m_122424_();
        if (be.lastExposedBack != back) {
            be.getMainNode().setExposedOnSides(EnumSet.of(back));
            be.lastExposedBack = back;
        }
        IGridNode iGridNode = aNode = (mainNode = be.getMainNode()) == null ? null : mainNode.getNode();
        if (aNode == null) {
            int old = be.beamLength;
            be.beamLength = 0;
            if (!be.m_58901_() && state.m_61143_(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                level.m_7731_(pos, (BlockState)state.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
            }
            if (old != 0) {
                be.markForUpdate();
            }
            return;
        }
        BlockPos cur = pos;
        int max = 32;
        int len = 0;
        BeamFormerBlockEntity target = null;
        for (int i = 0; i < max; ++i) {
            Direction otherFacing;
            BeamFormerBlockEntity other;
            BlockState bs = level.m_8055_(cur = cur.m_121945_(facing));
            if (bs.m_60815_() && !bs.m_60795_()) {
                BlockEntity obe = level.m_7702_(cur);
                if (!(obe instanceof BeamFormerBlockEntity)) break;
                other = (BeamFormerBlockEntity)obe;
                otherFacing = (Direction)level.m_8055_(cur).m_61143_((Property)BeamFormerBlock.FACING);
                if (otherFacing != facing.m_122424_()) break;
                target = other;
                len = i;
                break;
            }
            len = i + 1;
            BlockEntity pbe = level.m_7702_(cur);
            if (!(pbe instanceof BeamFormerBlockEntity)) continue;
            other = (BeamFormerBlockEntity)pbe;
            otherFacing = (Direction)level.m_8055_(cur).m_61143_((Property)BeamFormerBlock.FACING);
            if (otherFacing == facing) {
                target = null;
                break;
            }
            if (otherFacing != facing.m_122424_()) continue;
            target = other;
            break;
        }
        if (target != null) {
            IGridNode tNode;
            IManagedGridNode tManaged = target.getMainNode();
            IGridNode iGridNode2 = tNode = tManaged == null ? null : tManaged.getNode();
            if (tNode != null) {
                boolean bOk;
                be.tryConnect(target, len);
                IManagedGridNode aManaged = be.getMainNode();
                boolean aOk = aManaged != null && aManaged.isOnline() && aManaged.isPowered();
                boolean bl = bOk = tManaged.isOnline() && tManaged.isPowered();
                if (aOk && bOk) {
                    if (!be.m_58901_() && state.m_61143_(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.BEAMING) {
                        level.m_7731_(pos, (BlockState)state.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.BEAMING)), 3);
                    }
                } else {
                    int oldA = be.beamLength;
                    be.beamLength = 0;
                    if (!be.m_58901_() && state.m_61143_(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                        level.m_7731_(pos, (BlockState)state.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                    if (oldA != 0) {
                        be.markForUpdate();
                    }
                    BlockState tState = target.m_58900_();
                    int oldB = target.beamLength;
                    target.beamLength = 0;
                    if (!target.m_58901_() && tState.m_61143_(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                        level.m_7731_(target.m_58899_(), (BlockState)tState.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                    if (oldB != 0) {
                        target.markForUpdate();
                    }
                }
            }
        } else {
            int old = be.beamLength;
            be.disconnect();
            if (!be.m_58901_() && state.m_61143_(BeamFormerBlock.STATUS) != BeamFormerBlock.Status.ON) {
                level.m_7731_(pos, (BlockState)state.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
            }
            be.beamLength = 0;
            if (old != 0) {
                be.markForUpdate();
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BeamFormerBlockEntity be) {
    }

    private void tryConnect(BeamFormerBlockEntity target, int len) {
        IGridConnection existing;
        block13: {
            IManagedGridNode a = this.getMainNode();
            IManagedGridNode b = target.getMainNode();
            if (a == null || b == null) {
                return;
            }
            IGridNode aNode = a.getNode();
            IGridNode bNode = b.getNode();
            if (aNode == null || bNode == null) {
                return;
            }
            if (this.connection != null) {
                IGridNode other = this.connection.getOtherSide(aNode);
                if (other == bNode) {
                    int oldA = this.beamLength;
                    int oldB = target.beamLength;
                    this.beamLength = len;
                    target.beamLength = len;
                    if (target.connection == null) {
                        target.connection = this.connection;
                    }
                    if (this.f_58857_ != null && oldA != this.beamLength) {
                        this.markForUpdate();
                    }
                    if (target.f_58857_ != null && oldB != target.beamLength) {
                        target.markForUpdate();
                    }
                    return;
                }
                this.disconnect();
            }
            if ((existing = (IGridConnection)aNode.getConnections().stream().filter(c -> c.getOtherSide(aNode) == bNode).findFirst().orElse(null)) == null) {
                try {
                    existing = GridHelper.createConnection((IGridNode)aNode, (IGridNode)bNode);
                }
                catch (IllegalStateException ignored) {
                    existing = aNode.getConnections().stream().filter(c -> c.getOtherSide(aNode) == bNode).findFirst().orElse(null);
                    if (existing != null) break block13;
                    int oldA = this.beamLength;
                    this.beamLength = len;
                    if (this.f_58857_ != null && oldA != this.beamLength) {
                        this.markForUpdate();
                    }
                    return;
                }
            }
        }
        this.connection = existing;
        target.connection = existing;
        int oldA = this.beamLength;
        int oldB = target.beamLength;
        this.beamLength = len;
        target.beamLength = len;
        if (this.f_58857_ != null && oldA != this.beamLength) {
            this.markForUpdate();
        }
        if (target.f_58857_ != null && oldB != target.beamLength) {
            target.markForUpdate();
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                Object owner;
                IGridNode otherNode;
                IGridNode myNode = this.getMainNode().getNode();
                if (myNode != null && (otherNode = this.connection.getOtherSide(myNode)) != null && (owner = otherNode.getOwner()) instanceof BeamFormerBlockEntity) {
                    BeamFormerBlockEntity otherBe = (BeamFormerBlockEntity)((Object)owner);
                    int old = otherBe.beamLength;
                    otherBe.beamLength = 0;
                    if (otherBe.f_58857_ != null && old != 0) {
                        otherBe.markForUpdate();
                    }
                    BlockState st = otherBe.m_58900_();
                    if (!otherBe.m_58901_() && st.m_61143_(BeamFormerBlock.STATUS) == BeamFormerBlock.Status.BEAMING) {
                        otherBe.f_58857_.m_7731_(otherBe.m_58899_(), (BlockState)st.m_61124_(BeamFormerBlock.STATUS, (Comparable)((Object)BeamFormerBlock.Status.ON)), 3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection.destroy();
            this.connection = null;
        }
    }

    protected void writeToStream(FriendlyByteBuf data) {
        data.m_130130_(this.beamLength);
        data.writeBoolean(this.hideBeam);
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        int oldLength = this.beamLength;
        boolean oldHide = this.hideBeam;
        this.beamLength = data.m_130242_();
        this.hideBeam = data.readBoolean();
        return oldLength != this.beamLength || oldHide != this.hideBeam;
    }

    public void onChunkUnloaded() {
        this.disconnect();
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        this.disconnect();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("hideBeam", this.hideBeam);
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.hideBeam = tag.m_128471_("hideBeam");
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof BeamFormerBlock)) {
            return new AABB((double)(pos.m_123341_() - 5), (double)(pos.m_123342_() - 5), (double)(pos.m_123343_() - 5), (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 6), (double)(pos.m_123343_() + 6));
        }
        Direction dir = (Direction)state.m_61143_((Property)BeamFormerBlock.FACING);
        int len = Math.max(0, this.beamLength);
        if (len <= 0) {
            return new AABB((double)(pos.m_123341_() - 5), (double)(pos.m_123342_() - 5), (double)(pos.m_123343_() - 5), (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 6), (double)(pos.m_123343_() + 6));
        }
        BlockPos endPos = pos.m_5484_(dir, len);
        double minX = Math.min(pos.m_123341_(), endPos.m_123341_());
        double minY = Math.min(pos.m_123342_(), endPos.m_123342_());
        double minZ = Math.min(pos.m_123343_(), endPos.m_123343_());
        double maxX = Math.max(pos.m_123341_() + 1, endPos.m_123341_() + 1);
        double maxY = Math.max(pos.m_123342_() + 1, endPos.m_123342_() + 1);
        double maxZ = Math.max(pos.m_123343_() + 1, endPos.m_123343_() + 1);
        double expansion = 2.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }
}

