/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.mebeamformer.ME_Beam_Former;
import com.mebeamformer.block.OmniBeamFormerBlock;
import com.mebeamformer.blockentity.ILinkable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OmniBeamFormerBlockEntity
extends AENetworkBlockEntity
implements ILinkable {
    private final Set<BlockPos> links = new HashSet<BlockPos>();
    private final Map<BlockPos, IGridConnection> connections = new HashMap<BlockPos, IGridConnection>();
    private List<BlockPos> clientActiveTargets = Collections.emptyList();
    private final Set<BlockPos> lastActiveSet = new HashSet<BlockPos>();
    private Direction lastExposedBack = null;

    public OmniBeamFormerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ME_Beam_Former.OMNI_BEAM_FORMER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    }

    public AECableType getCableConnectionType(Direction dir) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)OmniBeamFormerBlock.FACING);
        return dir == facing.m_122424_() ? AECableType.SMART : AECableType.NONE;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)OmniBeamFormerBlock.FACING);
        return EnumSet.of(facing.m_122424_());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OmniBeamFormerBlockEntity be) {
        OmniBeamFormerBlock.Status targetStatus;
        IManagedGridNode myManaged;
        IGridNode myNode;
        if (be.m_58901_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)OmniBeamFormerBlock.FACING);
        Direction back = facing.m_122424_();
        if (be.lastExposedBack != back) {
            IManagedGridNode managed = be.getMainNode();
            if (managed != null) {
                managed.setExposedOnSides(EnumSet.of(back));
            }
            be.lastExposedBack = back;
        }
        IGridNode iGridNode = myNode = (myManaged = be.getMainNode()) != null ? myManaged.getNode() : null;
        if (myNode == null) {
            if (!be.lastActiveSet.isEmpty()) {
                be.lastActiveSet.clear();
                be.markForUpdate();
            }
            return;
        }
        HashSet<BlockPos> activeNow = new HashSet<BlockPos>();
        for (BlockPos targetPos : new HashSet<BlockPos>(be.links)) {
            boolean bOk;
            BlockEntity tBe = level.m_7702_(targetPos);
            if (!(tBe instanceof OmniBeamFormerBlockEntity)) {
                be.removeLink(targetPos);
                continue;
            }
            OmniBeamFormerBlockEntity other = (OmniBeamFormerBlockEntity)tBe;
            IManagedGridNode otherManaged = other.getMainNode();
            IGridNode otherNode = otherManaged != null ? otherManaged.getNode() : null;
            if (otherNode == null) continue;
            IGridConnection conn = be.connections.get(targetPos);
            if (conn == null || conn.getOtherSide(myNode) != otherNode) {
                IGridConnection existing = myNode.getConnections().stream().filter(c -> c.getOtherSide(myNode) == otherNode).findFirst().orElse(null);
                if (existing == null) {
                    try {
                        existing = GridHelper.createConnection((IGridNode)myNode, (IGridNode)otherNode);
                    }
                    catch (IllegalStateException ignored) {
                        existing = myNode.getConnections().stream().filter(c -> c.getOtherSide(myNode) == otherNode).findFirst().orElse(null);
                    }
                }
                if (existing != null) {
                    be.connections.put(targetPos, existing);
                    other.connections.put(pos, existing);
                }
            }
            boolean aOk = myManaged.isOnline() && myManaged.isPowered();
            boolean bl = bOk = otherManaged.isOnline() && otherManaged.isPowered();
            if (!aOk || !bOk) continue;
            activeNow.add(targetPos);
        }
        if (!be.lastActiveSet.equals(activeNow)) {
            be.lastActiveSet.clear();
            be.lastActiveSet.addAll(activeNow);
            be.markForUpdate();
        }
        BlockState curState = level.m_8055_(pos);
        OmniBeamFormerBlock.Status status = targetStatus = activeNow.isEmpty() ? OmniBeamFormerBlock.Status.ON : OmniBeamFormerBlock.Status.BEAMING;
        if (curState.m_60734_() instanceof OmniBeamFormerBlock && curState.m_61143_(OmniBeamFormerBlock.STATUS) != targetStatus) {
            level.m_7731_(pos, (BlockState)curState.m_61124_(OmniBeamFormerBlock.STATUS, (Comparable)((Object)targetStatus)), 3);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, OmniBeamFormerBlockEntity be) {
    }

    @Override
    public void addLink(BlockPos other) {
        if (other.equals((Object)this.m_58899_())) {
            return;
        }
        if (this.links.add(other)) {
            this.m_6596_();
        }
    }

    @Override
    public void removeLink(BlockPos other) {
        if (this.links.remove(other)) {
            IGridConnection c = this.connections.remove(other);
            if (c != null) {
                try {
                    c.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_6596_();
        }
    }

    @Override
    public Set<BlockPos> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public List<BlockPos> getClientActiveTargets() {
        return this.clientActiveTargets;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        data.m_130130_(this.lastActiveSet.size());
        for (BlockPos p : this.lastActiveSet) {
            data.m_130064_(p);
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        int n = data.m_130242_();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            list.add(data.m_130135_());
        }
        boolean changed = !list.equals(this.clientActiveTargets);
        this.clientActiveTargets = list;
        return changed;
    }

    public void onChunkUnloaded() {
        this.disconnectAll();
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        this.disconnectAll();
    }

    private void disconnectAll() {
        for (IGridConnection c : this.connections.values()) {
            try {
                c.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.connections.clear();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (BlockPos p : this.links) {
            CompoundTag t = new CompoundTag();
            t.m_128405_("x", p.m_123341_());
            t.m_128405_("y", p.m_123342_());
            t.m_128405_("z", p.m_123343_());
            list.add((Object)t);
        }
        tag.m_128365_("links", (Tag)list);
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.links.clear();
        if (tag.m_128425_("links", 9)) {
            ListTag list = tag.m_128437_("links", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.m_128728_(i);
                BlockPos pos = new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z"));
                this.links.add(pos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.clientActiveTargets == null || this.clientActiveTargets.isEmpty()) {
            BlockPos pos = this.m_58899_();
            return new AABB((double)(pos.m_123341_() - 5), (double)(pos.m_123342_() - 5), (double)(pos.m_123343_() - 5), (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 6), (double)(pos.m_123343_() + 6));
        }
        BlockPos pos = this.m_58899_();
        double minX = pos.m_123341_();
        double minY = pos.m_123342_();
        double minZ = pos.m_123343_();
        double maxX = pos.m_123341_() + 1;
        double maxY = pos.m_123342_() + 1;
        double maxZ = pos.m_123343_() + 1;
        for (BlockPos target : this.clientActiveTargets) {
            minX = Math.min(minX, (double)target.m_123341_());
            minY = Math.min(minY, (double)target.m_123342_());
            minZ = Math.min(minZ, (double)target.m_123343_());
            maxX = Math.max(maxX, (double)(target.m_123341_() + 1));
            maxY = Math.max(maxY, (double)(target.m_123342_() + 1));
            maxZ = Math.max(maxZ, (double)(target.m_123343_() + 1));
        }
        double expansion = 2.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }
}

