/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.util.AEColor;
import com.mebeamformer.block.BeamFormerBlock;
import com.mebeamformer.blockentity.BeamFormerBlockEntity;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BeamFormerBER
implements BlockEntityRenderer<BeamFormerBlockEntity> {
    public BeamFormerBER(BlockEntityRendererProvider.Context ctx) {
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(BeamFormerBlockEntity te) {
        return te != null && te.getBeamLength() > 0;
    }

    public void render(BeamFormerBlockEntity te, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        IColorableBlockEntity cbe;
        AEColor color;
        int checkLen;
        if (te == null) {
            return;
        }
        BlockState state = te.m_58900_();
        if (!(state.m_60734_() instanceof BeamFormerBlock)) {
            return;
        }
        if (!te.shouldRenderBeam()) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)BeamFormerBlock.FACING);
        int len = Math.max(0, te.getBeamLength());
        double visibleLen = len;
        if (visibleLen <= 0.0) {
            return;
        }
        Level level = te.m_58904_();
        BlockPos pos = te.m_58899_();
        if (level == null) {
            return;
        }
        int n = checkLen = len > 0 ? len : 1;
        if (!this.isPathClearForRender(level, pos, dir, checkLen)) {
            return;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        BlockPos back = pos.m_121945_(dir.m_122424_());
        BlockEntity backBe = level.m_7702_(back);
        if (backBe instanceof IColorableBlockEntity && (color = (cbe = (IColorableBlockEntity)backBe).getColor()) != null) {
            int hex = color.blackVariant;
            float scale = 255.0f;
            r = (float)(hex >> 16 & 0xFF) / scale;
            g = (float)(hex >> 8 & 0xFF) / scale;
            b = (float)(hex & 0xFF) / scale;
        }
        float thickness = 0.28f;
        BeamRenderHelper.renderColoredBeam(poseStack, buffers, dir, visibleLen, r, g, b, packedLight, packedOverlay, thickness);
    }

    private boolean isPathClearForRender(Level level, BlockPos start, Direction dir, int length) {
        BlockPos cur = start;
        for (int i = 0; i < length; ++i) {
            Direction otherFacing;
            BlockState state = level.m_8055_(cur = cur.m_121945_(dir));
            if (state.m_60815_() && !state.m_60795_()) {
                BlockEntity other = level.m_7702_(cur);
                if (other instanceof BeamFormerBlockEntity) {
                    otherFacing = (Direction)level.m_8055_(cur).m_61143_((Property)BeamFormerBlock.FACING);
                    if (i == length - 1 && otherFacing == dir.m_122424_()) {
                        return true;
                    }
                }
                return false;
            }
            BlockEntity be = level.m_7702_(cur);
            if (!(be instanceof BeamFormerBlockEntity) || (otherFacing = (Direction)level.m_8055_(cur).m_61143_((Property)BeamFormerBlock.FACING)) != dir) continue;
            return false;
        }
        return true;
    }
}

