/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.client.render;

import com.mebeamformer.Config;
import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mebeamformer.item.LaserBindingTool;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WirelessEnergyTowerRenderer
implements BlockEntityRenderer<WirelessEnergyTowerBlockEntity> {
    public WirelessEnergyTowerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public int m_142163_() {
        return 512;
    }

    public boolean shouldRenderOffScreen(WirelessEnergyTowerBlockEntity be) {
        List<BlockPos> links = be != null ? be.getClientLinks() : null;
        return links != null && !links.isEmpty();
    }

    public void render(WirelessEnergyTowerBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        List<BlockPos> links;
        if (be == null) {
            return;
        }
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        if (!Config.alwaysRenderBeams) {
            boolean holdingBindingTool;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            boolean bl = holdingBindingTool = player.m_21205_().m_41720_() instanceof LaserBindingTool || player.m_21206_().m_41720_() instanceof LaserBindingTool;
            if (!holdingBindingTool) {
                return;
            }
        }
        if ((links = be.getClientLinks()) == null || links.isEmpty()) {
            return;
        }
        BlockPos towerBasePos = be.m_58899_();
        float towerTopCenterX = (float)towerBasePos.m_123341_() + 0.5f;
        float towerTopCenterY = (float)towerBasePos.m_123342_() + 2.75f;
        float towerTopCenterZ = (float)towerBasePos.m_123343_() + 0.5f;
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float thickness = 0.04f;
        for (BlockPos targetPos : links) {
            float vz;
            float vy;
            float vx;
            double vectorLength;
            BlockEntity targetBE = level.m_7702_(targetPos);
            boolean isTargetTower = targetBE instanceof WirelessEnergyTowerBlockEntity;
            float targetCenterX = (float)targetPos.m_123341_() + 0.5f;
            float targetCenterY = (float)targetPos.m_123342_() + 0.5f;
            float targetCenterZ = (float)targetPos.m_123343_() + 0.5f;
            if (isTargetTower) {
                targetCenterY = (float)targetPos.m_123342_() + 2.75f;
            }
            if ((vectorLength = Math.sqrt((vx = targetCenterX - towerTopCenterX) * vx + (vy = targetCenterY - towerTopCenterY) * vy + (vz = targetCenterZ - towerTopCenterZ) * vz)) <= 0.1) continue;
            float normalizedVx = (float)((double)vx / vectorLength);
            float normalizedVy = (float)((double)vy / vectorLength);
            float normalizedVz = (float)((double)vz / vectorLength);
            float startOffsetX = normalizedVx * 0.25f;
            float startOffsetY = normalizedVy * 0.25f;
            float startOffsetZ = normalizedVz * 0.25f;
            float endOffsetX = isTargetTower ? -normalizedVx * 0.25f : 0.0f;
            float endOffsetY = isTargetTower ? -normalizedVy * 0.25f : 0.0f;
            float endOffsetZ = isTargetTower ? -normalizedVz * 0.25f : 0.0f;
            float adjustedVx = vx - startOffsetX - endOffsetX;
            float adjustedVy = vy - startOffsetY - endOffsetY;
            float adjustedVz = vz - startOffsetZ - endOffsetZ;
            poseStack.m_85836_();
            poseStack.m_85837_((double)startOffsetX, 2.25 + (double)startOffsetY, (double)startOffsetZ);
            BeamRenderHelper.renderColoredBeamVector(poseStack, buffers, adjustedVx, adjustedVy, adjustedVz, r, g, b, packedLight, packedOverlay, thickness);
            poseStack.m_85849_();
        }
    }
}

