/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.connection;

import com.mebeamformer.blockentity.WirelessEnergyTowerBlockEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="me_beam_former")
public class WirelessEnergyNetwork {
    private static volatile WirelessEnergyNetwork instance;
    private final Map<BlockPos, WirelessEnergyTowerBlockEntity> registeredTowers = new ConcurrentHashMap<BlockPos, WirelessEnergyTowerBlockEntity>();
    private final Map<Level, List<WirelessEnergyTowerBlockEntity>> towersByLevel = new ConcurrentHashMap<Level, List<WirelessEnergyTowerBlockEntity>>();
    private long lastExecutedTick = -1L;
    private boolean executedByMonitor = false;

    private WirelessEnergyNetwork() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WirelessEnergyNetwork getInstance() {
        if (instance != null) return instance;
        Class<WirelessEnergyNetwork> clazz = WirelessEnergyNetwork.class;
        synchronized (WirelessEnergyNetwork.class) {
            if (instance != null) return instance;
            instance = new WirelessEnergyNetwork();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WirelessEnergyNetwork.getInstance().tickIfNeeded(false);
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        WirelessEnergyNetwork.getInstance().clear();
    }

    public void registerTower(WirelessEnergyTowerBlockEntity tower) {
        if (tower == null || tower.m_58901_()) {
            return;
        }
        BlockPos pos = tower.m_58899_();
        Level level = tower.m_58904_();
        if (level == null) {
            return;
        }
        this.registeredTowers.put(pos, tower);
        this.towersByLevel.computeIfAbsent(level, k -> new ArrayList()).add(tower);
    }

    public void unregisterTower(WirelessEnergyTowerBlockEntity tower) {
        List<WirelessEnergyTowerBlockEntity> towers;
        if (tower == null) {
            return;
        }
        BlockPos pos = tower.m_58899_();
        Level level = tower.m_58904_();
        this.registeredTowers.remove(pos);
        if (level != null && (towers = this.towersByLevel.get(level)) != null) {
            towers.remove(tower);
            if (towers.isEmpty()) {
                this.towersByLevel.remove(level);
            }
        }
    }

    private void tickIfNeeded(boolean fromMonitor) {
        if (this.registeredTowers.isEmpty()) {
            return;
        }
        long currentTick = this.getCurrentGameTime();
        if (currentTick == this.lastExecutedTick) {
            return;
        }
        this.lastExecutedTick = currentTick;
        this.executedByMonitor = fromMonitor;
        this.tick();
    }

    private void tick() {
        if (this.registeredTowers.isEmpty()) {
            return;
        }
        for (Map.Entry<Level, List<WirelessEnergyTowerBlockEntity>> entry : this.towersByLevel.entrySet()) {
            Level level = entry.getKey();
            List<WirelessEnergyTowerBlockEntity> towers = entry.getValue();
            if (towers.isEmpty()) continue;
            this.processTowersInLevel(level, towers);
        }
    }

    private long getCurrentGameTime() {
        for (WirelessEnergyTowerBlockEntity tower : this.registeredTowers.values()) {
            if (tower.m_58904_() == null) continue;
            return tower.m_58904_().m_46467_();
        }
        return System.currentTimeMillis() / 50L;
    }

    private void processTowersInLevel(Level level, List<WirelessEnergyTowerBlockEntity> towers) {
        towers.removeIf(tower -> tower.m_58901_() || tower.m_58904_() == null);
        for (WirelessEnergyTowerBlockEntity tower2 : towers) {
            this.processSingleTower(tower2);
        }
    }

    private void processSingleTower(WirelessEnergyTowerBlockEntity tower) {
        if (tower.m_58901_()) {
            return;
        }
        Level level = tower.m_58904_();
        if (level == null) {
            return;
        }
        Set<BlockPos> links = tower.getLinks();
        if (links.isEmpty()) {
            return;
        }
        HashSet<BlockPos> validLinks = new HashSet<BlockPos>();
        for (BlockPos targetPos : new HashSet<BlockPos>(links)) {
            BlockEntity targetBE = level.m_7702_(targetPos);
            if (targetBE == null) {
                tower.removeLink(targetPos);
                continue;
            }
            tower.pushEnergyToTarget(targetBE);
            validLinks.add(targetPos);
        }
        if (!validLinks.equals(tower.getLastSyncedLinks())) {
            tower.updateSyncedLinks(validLinks);
        }
    }

    private void clear() {
        this.registeredTowers.clear();
        this.towersByLevel.clear();
    }

    public int getRegisteredTowerCount() {
        return this.registeredTowers.size();
    }

    public int getTowerCountInLevel(Level level) {
        List<WirelessEnergyTowerBlockEntity> towers = this.towersByLevel.get(level);
        return towers == null ? 0 : towers.size();
    }

    public void triggerPerformanceCheck() {
        this.tickIfNeeded(true);
    }
}

