/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.part;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import com.mebeamformer.client.render.BeamRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeamFormerPart
extends AEBasePart
implements IGridTickable {
    private static final ResourceLocation MODEL_BASE_LOC = new ResourceLocation("me_beam_former", "part/beam_former_base");
    private static final ResourceLocation STATUS_OFF_LOC = new ResourceLocation("me_beam_former", "part/beam_former_status_off");
    private static final ResourceLocation STATUS_ON_LOC = new ResourceLocation("me_beam_former", "part/beam_former_status_on");
    private static final ResourceLocation STATUS_BEAMING_LOC = new ResourceLocation("me_beam_former", "part/beam_former_status_beaming");
    private static final ResourceLocation PRISM_LOC = new ResourceLocation("me_beam_former", "part/beam_former_prism");
    private static final IPartModel MODEL_BEAMING = new PartModel(new ResourceLocation[]{STATUS_BEAMING_LOC, MODEL_BASE_LOC});
    private static final IPartModel MODEL_ON = new PartModel(new ResourceLocation[]{STATUS_ON_LOC, MODEL_BASE_LOC, PRISM_LOC});
    private static final IPartModel MODEL_OFF = new PartModel(new ResourceLocation[]{STATUS_OFF_LOC, MODEL_BASE_LOC, PRISM_LOC});
    private int beamLength = 0;
    private BeamFormerPart other = null;
    private IGridConnection connection = null;
    private boolean hideBeam = false;

    public BeamFormerPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return List.of(MODEL_OFF, MODEL_ON, MODEL_BEAMING);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(10.0, 10.0, 12.0, 6.0, 6.0, 11.0);
        bch.addBox(10.0, 10.0, 13.0, 6.0, 6.0, 12.0);
        bch.addBox(10.0, 6.0, 14.0, 6.0, 5.0, 13.0);
        bch.addBox(11.0, 9.0, 17.0, 10.0, 7.0, 14.0);
        bch.addBox(9.0, 11.0, 17.0, 7.0, 10.0, 14.0);
        bch.addBox(6.0, 9.0, 17.0, 5.0, 7.0, 14.0);
        bch.addBox(9.0, 6.0, 17.0, 7.0, 5.0, 14.0);
        bch.addBox(10.0, 11.0, 14.0, 6.0, 10.0, 13.0);
        bch.addBox(6.0, 10.0, 14.0, 5.0, 6.0, 13.0);
        bch.addBox(11.0, 9.0, 13.0, 10.0, 7.0, 12.0);
        bch.addBox(6.0, 9.0, 13.0, 5.0, 7.0, 12.0);
        bch.addBox(9.0, 6.0, 13.0, 7.0, 5.0, 12.0);
        bch.addBox(9.0, 11.0, 13.0, 7.0, 10.0, 12.0);
        bch.addBox(11.0, 10.0, 14.0, 10.0, 6.0, 13.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (player.m_6144_()) {
            boolean bl = this.hideBeam = !this.hideBeam;
            if (this.other != null) {
                this.other.hideBeam = this.hideBeam;
                this.other.getHost().markForUpdate();
                this.other.getHost().markForSave();
                this.other.getHost().partChanged();
            }
            this.getHost().markForUpdate();
            this.getHost().markForSave();
            this.getHost().partChanged();
            return true;
        }
        return false;
    }

    public IPartModel getStaticModels() {
        if (this.beamLength > 0 || this.other != null) {
            return MODEL_BEAMING;
        }
        if (this.isActive()) {
            return MODEL_ON;
        }
        return MODEL_OFF;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.LightTunnel, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        IPartHost host = this.getHost();
        BlockEntity be = host.getBlockEntity();
        Level level = be.m_58904_();
        if (level == null) {
            return TickRateModulation.SLEEP;
        }
        Direction dir = this.getSide();
        BlockPos cur = be.m_58899_();
        Direction facing = dir;
        LinkedHashSet<BlockPos> path = new LinkedHashSet<BlockPos>();
        boolean found = false;
        BeamFormerPart target = null;
        for (int i = 0; i < 32; ++i) {
            cur = cur.m_121945_(facing);
            BlockState state = level.m_8055_(cur);
            BlockEntity otherBe = level.m_7702_(cur);
            boolean hasBeamFormerPart = false;
            if (otherBe instanceof IPartHost) {
                IPartHost ph = (IPartHost)otherBe;
                Direction opposite = facing.m_122424_();
                IPart p = ph.getPart(opposite);
                if (p instanceof BeamFormerPart) {
                    BeamFormerPart bf;
                    target = bf = (BeamFormerPart)p;
                    found = true;
                }
                for (Direction d : Direction.values()) {
                    if (!(ph.getPart(d) instanceof BeamFormerPart)) continue;
                    hasBeamFormerPart = true;
                    break;
                }
            }
            if (state.m_60815_() && !state.m_60795_()) {
                if (hasBeamFormerPart) {
                    path.add(cur);
                    if (!found || target == null || otherBe != target.getBlockEntity()) continue;
                    break;
                }
                this.disconnect(null);
                return TickRateModulation.SLOWER;
            }
            path.add(cur);
            if (found && target != null) break;
        }
        if (found && target != null) {
            if (this.other == target && target.other == this && this.connection != null) {
                int oldLen = this.beamLength;
                this.beamLength = path.size();
                if (oldLen != this.beamLength) {
                    this.getHost().markForUpdate();
                }
                return TickRateModulation.SLOWER;
            }
            this.tryConnect(target, path);
            return TickRateModulation.SLOWER;
        }
        if (this.connection != null || this.other != null || this.beamLength != 0) {
            this.disconnect(null);
            return TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    public Direction getDirection() {
        return this.getSide();
    }

    public boolean isValidClient() {
        BlockEntity be = this.getBlockEntity();
        Level level = be != null ? be.m_58904_() : null;
        return level != null && level == Minecraft.m_91087_().f_91073_;
    }

    public int getBeamLength() {
        return this.beamLength;
    }

    public boolean shouldRenderBeam() {
        if (this.hideBeam) {
            return false;
        }
        if (this.beamLength <= 0 && this.other == null) {
            return false;
        }
        if (!this.isPowered()) {
            return false;
        }
        return this.other == null || this.other.isPowered();
    }

    public AABB getExtendedRenderBoundingBox(AABB baseBox) {
        if (this.beamLength <= 0 || !this.shouldRenderBeam()) {
            return baseBox;
        }
        BlockEntity be = this.getBlockEntity();
        if (be == null) {
            return baseBox;
        }
        BlockPos pos = be.m_58899_();
        Direction dir = this.getSide();
        BlockPos endPos = pos.m_5484_(dir, this.beamLength);
        return new AABB(pos, endPos).m_82400_(1.0);
    }

    public int getLightLevel() {
        return this.shouldRenderBeam() ? 15 : 0;
    }

    public boolean requireDynamicRender() {
        return true;
    }

    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        int checkLen;
        if (!this.shouldRenderBeam()) {
            return;
        }
        BlockEntity be = this.getBlockEntity();
        Level levelRD = be != null ? be.m_58904_() : null;
        Direction dirRD = this.getSide();
        int n = checkLen = this.beamLength > 0 ? this.beamLength : 1;
        if (levelRD != null && !this.isPathClearForRender(levelRD, be.m_58899_(), dirRD, checkLen)) {
            return;
        }
        AEColor color = this.getHost().getColor();
        float scale = 255.0f;
        float r = (float)(color.blackVariant >> 16 & 0xFF) / scale;
        float g = (float)(color.blackVariant >> 8 & 0xFF) / scale;
        float b = (float)(color.blackVariant & 0xFF) / scale;
        Direction dir = this.getSide();
        double visibleLen = this.beamLength > 0 ? (double)this.beamLength : 0.5;
        BeamRenderHelper.renderColoredBeamForPart(poseStack, buffers, dir, visibleLen, r, g, b, combinedLightIn, combinedOverlayIn);
    }

    private boolean isPathClearForRender(Level level, BlockPos start, Direction dir, int length) {
        BlockPos cur = start;
        for (int i = 0; i < length; ++i) {
            BlockState state = level.m_8055_(cur = cur.m_121945_(dir));
            if (!state.m_60815_() || state.m_60795_()) continue;
            BlockEntity otherBe = level.m_7702_(cur);
            if (otherBe instanceof IPartHost) {
                IPartHost ph = (IPartHost)otherBe;
                boolean hasBeamFormerPart = false;
                for (Direction d : Direction.values()) {
                    if (!(ph.getPart(d) instanceof BeamFormerPart)) continue;
                    hasBeamFormerPart = true;
                    break;
                }
                if (hasBeamFormerPart) continue;
            }
            return false;
        }
        return true;
    }

    private void tryConnect(BeamFormerPart target, Set<BlockPos> path) {
        IGridNode a = this.getGridNode();
        IGridNode b = target.getGridNode();
        if (a == null || b == null) {
            return;
        }
        this.disconnect(null);
        target.disconnect(null);
        this.connection = GridHelper.createConnection((IGridNode)a, (IGridNode)b);
        this.other = target;
        target.other = this;
        this.beamLength = path.size();
        target.beamLength = path.size();
        if (this.hideBeam || target.hideBeam) {
            this.hideBeam = true;
            target.hideBeam = true;
        }
        this.getHost().markForUpdate();
        this.getHost().markForSave();
        this.getHost().partChanged();
        target.getHost().markForUpdate();
        target.getHost().markForSave();
        target.getHost().partChanged();
    }

    public boolean disconnect(BlockPos breakPos) {
        boolean changed = false;
        if (this.connection != null) {
            this.connection.destroy();
            this.connection = null;
            changed = true;
        }
        if (this.other != null) {
            this.other.other = null;
            this.other.getHost().markForUpdate();
            this.other.getHost().markForSave();
            this.other = null;
            changed = true;
        }
        this.beamLength = breakPos != null ? Math.max(0, Math.min(this.beamLength, breakPos.m_123333_((Vec3i)this.getBlockEntity().m_58899_()))) : 0;
        if (changed) {
            this.getHost().markForUpdate();
            this.getHost().markForSave();
            this.getHost().partChanged();
        }
        return changed;
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.m_130130_(this.beamLength);
        data.writeBoolean(this.hideBeam);
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        boolean redraw = super.readFromStream(data);
        int oldLen = this.beamLength;
        boolean oldHide = this.hideBeam;
        this.beamLength = data.m_130242_();
        this.hideBeam = data.readBoolean();
        return redraw || oldLen != this.beamLength || oldHide != this.hideBeam;
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag v = new CompoundTag();
        v.m_128405_("beamLength", this.beamLength);
        v.m_128379_("hideBeam", this.hideBeam);
        tag.m_128365_("beamFormer", (Tag)v);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        if (tag.m_128441_("beamFormer")) {
            CompoundTag v = tag.m_128469_("beamFormer");
            this.beamLength = v.m_128451_("beamLength");
            this.hideBeam = v.m_128471_("hideBeam");
        }
    }
}

