/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.computerized_vehicles.api;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import io.github.techtastic.computerized_vehicles.api.FuelTank;
import io.github.techtastic.computerized_vehicles.api.base.EntityDefinable;
import io.github.techtastic.computerized_vehicles.api.part.BasePart;
import io.github.techtastic.computerized_vehicles.api.part.EnginePart;
import io.github.techtastic.computerized_vehicles.api.part.GenericPart;
import io.github.techtastic.computerized_vehicles.api.part.GroundPart;
import io.github.techtastic.computerized_vehicles.api.part.GunPart;
import io.github.techtastic.computerized_vehicles.api.part.InteractablePart;
import io.github.techtastic.computerized_vehicles.api.part.PropellorPart;
import io.github.techtastic.computerized_vehicles.api.part.SeatPart;
import io.github.techtastic.computerized_vehicles.networking.packet.PacketEntityColorChangeComputer;
import io.github.techtastic.computerized_vehicles.util.LuaConversions;
import java.util.List;
import java.util.Objects;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGeneric;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketBase;

public class Vehicle
extends EntityDefinable {
    protected Vehicle(EntityVehicleF_Physics vehicle) {
        super((AEntityD_Definable<?>)vehicle);
    }

    private EntityVehicleF_Physics getVehicle() throws LuaException {
        AEntityB_Existing aEntityB_Existing = this.getEntity();
        if (aEntityB_Existing instanceof EntityVehicleF_Physics) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)aEntityB_Existing;
            return vehicle;
        }
        throw new LuaException("the vehicle with ID " + String.valueOf(this.id) + " no longer exists!");
    }

    private void toggleActive(ComputedVariable variable, IArguments args, int index) throws LuaException {
        boolean oldState;
        boolean newState = args.optBoolean(index, !(oldState = variable.isActive));
        if (oldState != newState) {
            variable.setActive(newState, true);
        }
    }

    private <T extends APart> BasePart<T> getPart(T part) {
        if (part instanceof PartGeneric) {
            PartGeneric generic = (PartGeneric)part;
            return new GenericPart(generic);
        }
        if (part instanceof PartGroundDevice) {
            PartGroundDevice ground = (PartGroundDevice)part;
            return new GroundPart(ground);
        }
        if (part instanceof PartGun) {
            PartGun gun = (PartGun)part;
            return new GunPart(gun);
        }
        if (part instanceof PartInteractable) {
            PartInteractable interact = (PartInteractable)part;
            return new InteractablePart(interact);
        }
        if (part instanceof PartEngine) {
            PartEngine engine = (PartEngine)part;
            return new EnginePart(engine);
        }
        if (part instanceof PartSeat) {
            PartSeat seat = (PartSeat)part;
            return new SeatPart(seat);
        }
        if (part instanceof PartPropeller) {
            PartPropeller propeller = (PartPropeller)part;
            return new PropellorPart(propeller);
        }
        return null;
    }

    @LuaFunction
    public final Object getDefinition() throws LuaException {
        return LuaConversions.toLuaAny(this.getVehicle().definition);
    }

    @LuaFunction
    public final double getSpeed() throws LuaException {
        return this.getVehicle().indicatedSpeed;
    }

    @LuaFunction
    public final boolean isBeingFueled() throws LuaException {
        return this.getVehicle().beingFueled;
    }

    @LuaFunction
    public final FuelTank getFuelTank() throws LuaException {
        return new FuelTank(this.getVehicle().fuelTank);
    }

    @LuaFunction
    public final List<EnginePart> getEngines() throws LuaException {
        return this.getVehicle().engines.stream().map(EnginePart::new).toList();
    }

    @LuaFunction
    public final List<SeatPart> getSeats() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartSeat) {
                PartSeat seat = (PartSeat)part;
                return new SeatPart(seat);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final List<GunPart> getGuns() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                return new GunPart(gun);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final List<GenericPart> getGenericParts() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartGeneric) {
                PartGeneric generic = (PartGeneric)part;
                return new GenericPart(generic);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final List<GroundPart> getGroundDevices() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartGroundDevice) {
                PartGroundDevice ground = (PartGroundDevice)part;
                return new GroundPart(ground);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final List<InteractablePart> getInteractables() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartInteractable) {
                PartInteractable interactable = (PartInteractable)part;
                return new InteractablePart(interactable);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final List<PropellorPart> getPropellors() throws LuaException {
        return this.getVehicle().partsInSlots.stream().map(part -> {
            if (part instanceof PartPropeller) {
                PartPropeller prop = (PartPropeller)part;
                return new PropellorPart(prop);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    @LuaFunction
    public final BasePart<?> addPart(IArguments args) throws LuaException {
        AItemPart partItem = LuaConversions.getPart(args, 0);
        int slot = args.getInt(1);
        EntityVehicleF_Physics vehicle = this.getVehicle();
        JSONPartDefinition newPartDef = (JSONPartDefinition)((JSONVehicle)vehicle.definition).parts.get(slot);
        if (!partItem.isPartValidForPackDef(newPartDef, vehicle.subDefinition, !newPartDef.bypassSlotMinMax)) {
            throw LuaValues.badArgument((int)0, (String)("valid IV/MTS part for " + ((JSONVehicle)vehicle.definition).packID + " pack"), (String)partItem.getItemName());
        }
        return this.getPart(vehicle.addPartFromStack(partItem.getNewStack(null), null, slot, false, true));
    }

    @LuaFunction
    public final void removePart(int slot) throws LuaException {
        EntityVehicleF_Physics vehicle = this.getVehicle();
        APart part = (APart)vehicle.partsInSlots.get(slot);
        vehicle.removePart(part, true, true);
    }

    @LuaFunction
    public final List<String> getVariants() throws LuaException {
        return ((JSONVehicle)this.getVehicle().definition).definitions.stream().map(def -> def.subName).toList();
    }

    @LuaFunction
    public final void changeVariant(String variant) throws LuaException {
        EntityVehicleF_Physics vehicle = this.getVehicle();
        vehicle.updateSubDefinition(variant);
        vehicle.parts.forEach(part -> part.updateTone(true));
        InterfaceManager.packetInterface.sendToAllClients((APacketBase)new PacketEntityColorChangeComputer((AEntityD_Definable<?>)vehicle, variant));
    }

    @LuaFunction
    public final void setMudAccumulation(double mud) throws LuaException {
        EntityVehicleF_Physics vehicle = this.getVehicle();
        if (vehicle.containsVariable("mudAcc")) {
            vehicle.getOrCreateVariable("mudAcc").setTo(mud, true);
        }
        throw new LuaException("This vehicle does not handle mud!");
    }

    @LuaFunction
    public final double getThrottle() throws LuaException {
        return this.getVehicle().throttleVar.getValue();
    }

    @LuaFunction
    public final void setThrottle(double throttle) throws LuaException {
        this.getVehicle().throttleVar.setTo(Math.max(0.0, Math.min(1.0, throttle)), true);
    }

    @LuaFunction
    public final double getBrakeLevel() throws LuaException {
        return this.getVehicle().brakeVar.getValue();
    }

    @LuaFunction
    public final void setBrakeLevel(double brakeLevel) throws LuaException {
        this.getVehicle().brakeVar.setTo(Math.max(0.0, Math.min(1.0, brakeLevel)), true);
    }

    @LuaFunction
    public final boolean isParkingBrakeActive() throws LuaException {
        return this.getVehicle().parkingBrakeVar.isActive;
    }

    @LuaFunction
    public final void setParkingBrakeActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().parkingBrakeVar, args, 0);
    }

    @LuaFunction
    public final double getTurningInput() throws LuaException {
        return this.getVehicle().rudderInputVar.getValue();
    }

    @LuaFunction
    public final void setTurningInput(double angle) throws LuaException {
        this.getVehicle().rudderInputVar.setTo(angle, true);
    }

    @LuaFunction
    public final boolean isHornActive() throws LuaException {
        return this.getVehicle().hornVar.isActive;
    }

    @LuaFunction
    public final void setHornActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().hornVar, args, 0);
    }

    @LuaFunction
    public final boolean isTurnSignalActive(boolean left) throws LuaException {
        if (left) {
            return this.getVehicle().leftTurnLightVar.isActive;
        }
        return this.getVehicle().rightTurnLightVar.isActive;
    }

    @LuaFunction
    public final void setTurnSignalActive(boolean left, IArguments args) throws LuaException {
        if (left) {
            this.toggleActive(this.getVehicle().leftTurnLightVar, args, 1);
        } else {
            this.toggleActive(this.getVehicle().rightTurnLightVar, args, 1);
        }
    }

    @LuaFunction
    public final boolean getHeadLightActive() throws LuaException {
        return this.getVehicle().headLightVar.isActive;
    }

    @LuaFunction
    public final void setHeadLightActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().headLightVar, args, 0);
    }

    @LuaFunction
    public final boolean getLandingLightActive() throws LuaException {
        return this.getVehicle().landingLightVar.isActive;
    }

    @LuaFunction
    public final void setLandingLightActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().landingLightVar, args, 0);
    }

    @LuaFunction
    public final boolean getNavLightsActive() throws LuaException {
        return this.getVehicle().navigationLightVar.isActive;
    }

    @LuaFunction
    public final void setNavLightsActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().navigationLightVar, args, 0);
    }

    @LuaFunction
    public final boolean getRunningLightActive() throws LuaException {
        return this.getVehicle().runningLightVar.isActive;
    }

    @LuaFunction
    public final void setRunningLightActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().runningLightVar, args, 0);
    }

    @LuaFunction
    public final boolean getStrobeLightActive() throws LuaException {
        return this.getVehicle().strobeLightVar.isActive;
    }

    @LuaFunction
    public final void setStrobeLightActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().strobeLightVar, args, 0);
    }

    @LuaFunction
    public final boolean getTaxiLightActive() throws LuaException {
        return this.getVehicle().taxiLightVar.isActive;
    }

    @LuaFunction
    public final void setTaxiLightActive(IArguments args) throws LuaException {
        this.toggleActive(this.getVehicle().taxiLightVar, args, 0);
    }
}

