/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.computerized_vehicles.util;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mcinterface1201.BuilderItem;
import mcinterface1201.WrapperEntity;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class LuaConversions {
    public static WrapperEntity getEntity(IArguments args, int index, AWrapperWorld world) throws LuaException {
        String str = args.getString(index);
        try {
            UUID uniqueUUID = UUID.fromString(args.getString(index));
            IWrapperEntity entity = world.getExternalEntity(uniqueUUID);
            if (entity instanceof WrapperEntity) {
                WrapperEntity wrapper = (WrapperEntity)entity;
                return wrapper;
            }
            throw LuaValues.badArgument((int)index, (String)"valid UUID of Minecraft Entity", (String)str);
        }
        catch (LuaException | IllegalArgumentException e) {
            if (e instanceof LuaException) {
                LuaException lua = (LuaException)e;
                throw lua;
            }
            throw LuaValues.badArgument((int)index, (String)"a valid UUID", (String)str);
        }
    }

    public static <T extends AItemBase> T getMTSItem(IArguments args, int index, Class<T> type) throws LuaException {
        String str = args.getString(index);
        ResourceLocation location = ResourceLocation.m_135820_((String)str);
        if (location == null) {
            throw LuaValues.badArgument((int)index, (String)"item ID", (String)str);
        }
        Optional optItem = ForgeRegistries.ITEMS.getDelegate(location);
        if (optItem.isEmpty()) {
            throw LuaValues.badArgument((int)index, (String)"valid item ID", (String)location.toString());
        }
        Item item = (Item)((Holder.Reference)optItem.get()).m_203334_();
        if (!(item instanceof BuilderItem)) {
            throw LuaValues.badArgument((int)index, (String)"valid IV/MTS item", (String)location.toString());
        }
        BuilderItem builderItem = (BuilderItem)item;
        try {
            return (T)builderItem.getWrappedItem();
        }
        catch (ClassCastException ignored) {
            throw LuaValues.badArgument((int)index, (String)("valid IV/MTS " + type.getSimpleName() + " item"), (String)location.toString());
        }
    }

    public static AItemPart getPart(IArguments args, int index) throws LuaException {
        return LuaConversions.getMTSItem(args, index, AItemPart.class);
    }

    public static EntityVehicleF_Physics getVehicle(IArguments args, int index, WrapperWorld world) throws LuaException {
        String str = args.getString(index);
        try {
            UUID uniqueUUID = UUID.fromString(args.getString(index));
            AEntityA_Base entity = world.getEntity(uniqueUUID);
            if (entity instanceof EntityVehicleF_Physics) {
                EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
                return vehicle;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw LuaValues.badArgument((int)index, (String)"unique UUID of vehicle", (String)str);
    }

    public static UUID getUUID(IArguments args, int index) throws LuaException {
        String str = args.getString(index);
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException e) {
            throw LuaValues.badArgument((int)index, (String)"UUID", (String)str);
        }
    }

    public static Point3D optPoint(IArguments args, int index, Point3D def) throws LuaException {
        Object v;
        Object v2;
        Object v3;
        Optional optTable = args.optTable(index);
        if (optTable.isEmpty()) {
            return def;
        }
        Map table = (Map)optTable.get();
        if (!table.containsKey("x") || !((v3 = table.get("x")) instanceof Double)) {
            throw LuaValues.badField((String)"x", (String)"number", (String)table.get("x").getClass().toString());
        }
        Double x = (Double)v3;
        if (!table.containsKey("y") || !((v2 = table.get("y")) instanceof Double)) {
            throw LuaValues.badField((String)"y", (String)"number", (String)table.get("y").getClass().toString());
        }
        Double y = (Double)v2;
        if (!table.containsKey("z") || !((v = table.get("z")) instanceof Double)) {
            throw LuaValues.badField((String)"z", (String)"number", (String)table.get("z").getClass().toString());
        }
        Double z = (Double)v;
        return new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public static Map<String, Double> toLua(Point3D point) {
        return Map.of("x", point.x, "y", point.y, "z", point.z);
    }

    public static Map<String, Object> toLuaAny(Object object) {
        HashMap<String, Object> table = new HashMap<String, Object>();
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getFields()) {
            if (!field.canAccess(object) || field.isAnnotationPresent(Deprecated.class) || Modifier.isStatic(field.getModifiers())) continue;
            if (field.getType().isPrimitive()) {
                Object o = LuaConversions.handlePrimitive(field, object);
                if (o == null) continue;
                table.put(field.getName(), o);
            }
            try {
                table.put(field.getName(), LuaConversions.handleNonPrimitive(field.get(object)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return table;
    }

    private static Object handlePrimitive(Field field, Object o) {
        try {
            return field.getBoolean(o);
        }
        catch (Exception exception) {
            try {
                return field.getByte(o);
            }
            catch (Exception exception2) {
                try {
                    return field.getShort(o);
                }
                catch (Exception exception3) {
                    try {
                        return field.getInt(o);
                    }
                    catch (Exception exception4) {
                        try {
                            return field.getLong(o);
                        }
                        catch (Exception exception5) {
                            try {
                                return field.getDouble(o);
                            }
                            catch (Exception exception6) {
                                try {
                                    return (double)field.getFloat(o);
                                }
                                catch (Exception exception7) {
                                    try {
                                        return Character.valueOf(field.getChar(o));
                                    }
                                    catch (Exception exception8) {
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static Object convertObject(Object o) {
        if (o.getClass().isPrimitive()) {
            return LuaConversions.handlePrimitive(o);
        }
        return LuaConversions.handleNonPrimitive(o);
    }

    private static Object handlePrimitive(Object o) {
        try {
            return (double)Float.parseFloat(o.toString());
        }
        catch (Exception ignored) {
            return o;
        }
    }

    private static Object handleNonPrimitive(Object o) {
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            HashMap newMap = new HashMap();
            map.forEach((k, v) -> newMap.put(k.toString(), LuaConversions.convertObject(v)));
            return newMap;
        }
        if (o instanceof List) {
            List list = (List)o;
            return list.stream().map(LuaConversions::convertObject).toList();
        }
        if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            return Arrays.stream(arr).map(LuaConversions::convertObject).toArray();
        }
        if (o instanceof Point3D) {
            Point3D point = (Point3D)o;
            return LuaConversions.toLua(point);
        }
        if (o instanceof RotationMatrix) {
            RotationMatrix matrix = (RotationMatrix)o;
            return LuaConversions.toLua(matrix.angles);
        }
        return LuaConversions.toLuaAny(o);
    }
}

