/*
 * Decompiled with CFR 0.152.
 */
package io.github.techtastic.computerized_vehicles.api;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import io.github.techtastic.computerized_vehicles.api.Vehicle;
import io.github.techtastic.computerized_vehicles.util.LuaConversions;
import java.util.List;
import java.util.UUID;
import mcinterface1201.BuilderEntityExisting;
import mcinterface1201.BuilderItem;
import mcinterface1201.WrapperEntity;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class VehicleAPI
implements ILuaAPI {
    private final IComputerSystem system;

    public VehicleAPI(IComputerSystem system) {
        this.system = system;
    }

    private ServerLevel getLevel() {
        return this.system.getLevel();
    }

    private BlockPos getPosition() {
        return this.system.getPosition();
    }

    private WrapperWorld getWrapperWorld() {
        return WrapperWorld.getWrapperFor((Level)this.getLevel());
    }

    public String[] getNames() {
        return new String[]{"vehicles"};
    }

    @LuaFunction
    public final Vehicle getVehicle(IArguments args) throws LuaException {
        return new Vehicle(LuaConversions.getVehicle(args, 0, this.getWrapperWorld()));
    }

    @LuaFunction
    public final List<String> getAllPossibleVehicles() {
        return ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> {
            BuilderItem item;
            Object patt2172$temp = entry.getValue();
            return patt2172$temp instanceof BuilderItem && (item = (BuilderItem)patt2172$temp).getWrappedItem() instanceof ItemVehicle;
        }).map(entry -> ((ResourceKey)entry.getKey()).m_135782_().toString()).toList();
    }

    @LuaFunction
    public final List<String> getAllPossibleParts() {
        return ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> {
            BuilderItem item;
            Object patt2521$temp = entry.getValue();
            return patt2521$temp instanceof BuilderItem && (item = (BuilderItem)patt2521$temp).getWrappedItem() instanceof AItemPart;
        }).map(entry -> ((ResourceKey)entry.getKey()).m_135782_().toString()).toList();
    }

    @LuaFunction
    public final List<String> getAllPossibleBullets() {
        return ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> {
            BuilderItem item;
            Object patt2870$temp = entry.getValue();
            return patt2870$temp instanceof BuilderItem && (item = (BuilderItem)patt2870$temp).getWrappedItem() instanceof ItemBullet;
        }).map(entry -> ((ResourceKey)entry.getKey()).m_135782_().toString()).toList();
    }

    @LuaFunction
    public final List<Vehicle> getAllVehiclesInArea(IArguments args) throws LuaException {
        Point3D min = LuaConversions.optPoint(args, 0, new Point3D());
        Point3D max = LuaConversions.optPoint(args, 1, new Point3D());
        BoundingBox area = new BoundingBox(min, max);
        return this.getWrapperWorld().getEntitiesExtendingType(EntityVehicleF_Physics.class).stream().filter(phys -> area.isPointInside(phys.position, new Point3D())).map(Vehicle::new).toList();
    }

    @LuaFunction
    public final Vehicle spawnVehicle(IArguments args) throws LuaException {
        IWrapperNBT nbt;
        WrapperWorld world = this.getWrapperWorld();
        try {
            Class<?> clazz = ClassLoader.getPlatformClassLoader().loadClass("mcinterface1201.WrapperNBT");
            nbt = (IWrapperNBT)clazz.newInstance();
        }
        catch (Exception ignored) {
            nbt = null;
        }
        EntityVehicleF_Physics vehicle = new EntityVehicleF_Physics((AWrapperWorld)world, null, LuaConversions.getMTSItem(args, 0, ItemVehicle.class), nbt);
        Direction facing = (Direction)this.getLevel().m_8055_(this.getPosition()).m_61143_((Property)BlockStateProperties.f_61374_);
        Vec3 vec = this.getPosition().m_252807_().m_231075_(Direction.UP, vehicle.boundingBox.heightRadius + 0.5).m_231075_(facing, 0.5);
        Point3D pos = LuaConversions.optPoint(args, 1, new Point3D(vec.f_82479_, vec.f_82480_, vec.f_82481_));
        Point3D angles = LuaConversions.optPoint(args, 2, new Point3D(0.0, (double)facing.m_122435_(), 0.0));
        Point3D motion = LuaConversions.optPoint(args, 3, new Point3D());
        vehicle.position.set(pos);
        vehicle.prevPosition.set(new Point3D());
        vehicle.orientation.setToAngles(angles);
        vehicle.prevOrientation.setToAngles(new Point3D());
        vehicle.motion.set(motion);
        vehicle.prevMotion.set(new Point3D());
        if (vehicle.containsVariable("mudAcc")) {
            vehicle.getOrCreateVariable("mudAcc").setTo(args.optDouble(4, 0.0), false);
        }
        world.spawnEntity((AEntityB_Existing)vehicle);
        vehicle.addPartsPostAddition(null, nbt);
        return new Vehicle(vehicle);
    }

    @LuaFunction
    public final void deleteVehicle(IArguments args) throws LuaException {
        UUID uniqueUUID;
        WrapperWorld world = this.getWrapperWorld();
        AEntityA_Base entity = world.getEntity(uniqueUUID = LuaConversions.getUUID(args, 0));
        if (entity == null) {
            throw LuaValues.badArgument((int)0, (String)"IV/MTS placed entity", (String)"nil");
        }
        if (!(entity instanceof AEntityB_Existing)) {
            throw LuaValues.badArgument((int)0, (String)"IV/MTS placed entity", (String)uniqueUUID.toString());
        }
        AEntityB_Existing existing = (AEntityB_Existing)entity;
        this.getLevel().m_45976_(BuilderEntityExisting.class, AABB.m_165882_((Vec3)new Vec3(existing.boundingBox.globalCenter.x, existing.boundingBox.globalCenter.y, existing.boundingBox.globalCenter.z), (double)(existing.boundingBox.widthRadius * 2.0), (double)(existing.boundingBox.heightRadius * 2.0), (double)(existing.boundingBox.depthRadius * 2.0))).stream().filter(e -> {
            WrapperEntity wrapper = world.getExternalEntity(e.m_20148_());
            if (wrapper == null) {
                return false;
            }
            IWrapperNBT data = wrapper.getData();
            return data.hasKey("uniqueUUID") && data.getUUID("uniqueUUID").equals(existing.uniqueUUID);
        }).forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
    }
}

