/*
 * Decompiled with CFR 0.152.
 */
package top.vmctcn.vmtu.mod.options;

import java.nio.file.Path;
import top.vmctcn.vmtu.mod.ModPlatform;
import top.vmctcn.vmtu.mod.VMTranslationUpdate;
import top.vmctcn.vmtu.mod.config.ModConfigHelper;
import top.vmctcn.vmtu.mod.helper.LanguageHelper;
import top.vmctcn.vmtu.mod.modpack.ModpackInfoReader;
import vmtu.include.core.VMTUCore;
import vmtu.include.core.pack.GameOptionsWriter;
import vmtu.include.core.pack.PackSource;

public class GameOptionsSetter {
    public static void init(Path gamePath) {
        if (ModConfigHelper.getConfig().autoSwitchLanguage && ModpackInfoReader.getModpackInfo().getModpack().getTranslation().getLanguage() != null) {
            try {
                GameOptionsWriter writer = new GameOptionsWriter(gamePath.resolve("options.txt"));
                String lang = ModpackInfoReader.getModpackInfo().getModpack().getTranslation().getLanguage();
                writer.switchLanguage(LanguageHelper.getFixedLanguage(lang));
            }
            catch (Exception e) {
                VMTranslationUpdate.LOGGER.warn("Failed to switch language: ", (Throwable)e);
            }
        }
        if (ModConfigHelper.getConfig().autoDownloadVMTranslationPack) {
            String gameVersion = ModPlatform.INSTANCE.getGameVersion();
            PackSource resPackSource = ModConfigHelper.getConfig().translationPackSource;
            String resPackName = ModpackInfoReader.getModpackInfo().getModpack().getTranslation().getResourcePackName();
            VMTUCore.init(gamePath, gameVersion, resPackName, resPackSource);
        }
    }
}

