/*
 * Decompiled with CFR 0.152.
 */
package vmtu.include.core;

import com.google.gson.Gson;
import include.org.slf4j.Logger;
import include.org.slf4j.LoggerFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import vmtu.include.core.metadata.GameAssetDetail;
import vmtu.include.core.metadata.MetadataReader;
import vmtu.include.core.pack.GameOptionsWriter;
import vmtu.include.core.pack.PackSource;
import vmtu.include.core.pack.ResourcePack;
import vmtu.include.core.pack.ResourcePackConverter;
import vmtu.include.core.util.FileUtil;

public class VMTUCore {
    public static final String LOCAL_PATH = "vmtu";
    public static final Logger LOGGER = LoggerFactory.getLogger(VMTUCore.class);
    public static final Gson GSON = new Gson();

    public static void init(Path minecraftPath, String minecraftVersion, String packName, PackSource packSource) {
        LOGGER.debug(String.format("Minecraft path: %s", minecraftPath));
        String localStorage = VMTUCore.getLocalStoragePos(minecraftPath);
        LOGGER.debug(String.format("Local Storage Pos: %s", localStorage));
        try {
            Class.forName("com.netease.mc.mod.network.common.Library");
            LOGGER.warn("VMTUCore will get resource pack from Internet, whose content is uncontrolled.");
            LOGGER.warn("This behavior contraries to Netease Minecraft developer content review rule: forbidden the content in game not match the content for reviewing.");
            LOGGER.warn("To follow this rule, VMTUCore won't download any thing.");
            LOGGER.warn("VMTUCore\u4f1a\u4ece\u4e92\u8054\u7f51\u83b7\u53d6\u5185\u5bb9\u4e0d\u53ef\u63a7\u7684\u8d44\u6e90\u5305\u3002");
            LOGGER.warn("\u8fd9\u4e00\u884c\u4e3a\u8fdd\u80cc\u4e86\u7f51\u6613\u6211\u7684\u4e16\u754c\u300c\u5f00\u53d1\u8005\u5185\u5bb9\u5ba1\u6838\u5236\u5ea6\u300d\uff1a\u7981\u6b62\u4e0a\u4f20\u4e0e\u63d0\u5ba1\u5185\u5bb9\u4e0d\u4e00\u81f4\u7684\u6e38\u620f\u5185\u5bb9\u3002");
            LOGGER.warn("\u4e3a\u4e86\u9075\u5faa\u8fd9\u4e00\u5236\u5ea6\uff0cVMTUCore\u4e0d\u4f1a\u4e0b\u8f7d\u4efb\u4f55\u5185\u5bb9\u3002");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FileUtil.setResourcePackDirPath(minecraftPath.resolve("resourcepacks"));
            int minecraftMajorVersion = Integer.parseInt(minecraftVersion.split("\\.")[1]);
            try {
                GameAssetDetail assets = MetadataReader.getAssetDetail(minecraftVersion, packSource);
                ArrayList<ResourcePack> languagePacks = new ArrayList<ResourcePack>();
                boolean convertNotNeed = assets.downloads.size() == 1 && assets.downloads.get((int)0).targetVersion.equals(minecraftVersion);
                String applyFileName = assets.downloads.get((int)0).fileName;
                for (GameAssetDetail.AssetDownloadDetail it : assets.downloads) {
                    FileUtil.setTemporaryDirPath(Paths.get(localStorage, ".vmtu", it.targetVersion));
                    ResourcePack languagePack = new ResourcePack(it.fileName, convertNotNeed);
                    languagePack.checkUpdate(it.fileUrl);
                    languagePacks.add(languagePack);
                }
                if (!convertNotNeed) {
                    FileUtil.setTemporaryDirPath(Paths.get(localStorage, ".vmtu", minecraftVersion));
                    applyFileName = assets.covertFileName;
                    ResourcePackConverter converter = new ResourcePackConverter(languagePacks, applyFileName);
                    converter.convert(assets.covertPackFormat, VMTUCore.getResourcePackDescription(assets.downloads));
                }
                GameOptionsWriter writer = new GameOptionsWriter(minecraftPath.resolve("options.txt"));
                writer.addResourcePack(packName, (minecraftMajorVersion <= 12 ? "" : "file/") + applyFileName);
                writer.writeToFile();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to update resource pack: %s", e));
            }
            return;
        }
    }

    private static String getResourcePackDescription(List<GameAssetDetail.AssetDownloadDetail> downloads) {
        return downloads.size() > 1 ? String.format("\u8be5\u5305\u7531%s\u7248\u672c\u5408\u5e76\n\u4f5c\u8005\uff1aVM\u6c49\u5316\u7ec4", downloads.stream().map(it -> it.targetVersion).collect(Collectors.joining("\u548c"))) : String.format("\u8be5\u5305\u5bf9\u5e94\u7684\u5b98\u65b9\u652f\u6301\u7248\u672c\u4e3a%s\n\u4f5c\u8005\uff1aVM\u6c49\u5316\u7ec4", downloads.get((int)0).targetVersion);
    }

    public static String getLocalStoragePos(Path minecraftPath) {
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        Path oldPath = userHome.resolve(".vmtu");
        if (Files.exists(oldPath, new LinkOption[0])) {
            return userHome.toString();
        }
        String macAppSupport = System.getProperty("os.name").contains("OS X") ? userHome.resolve("Library/Application Support").toString() : null;
        String localAppData = System.getenv("LocalAppData");
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome == null) {
            xdgDataHome = userHome.resolve(".local/share").toString();
        }
        return Stream.of(localAppData, macAppSupport).filter(Objects::nonNull).findFirst().orElse(xdgDataHome);
    }
}

