/*
 * Decompiled with CFR 0.152.
 */
package vmtu.include.core.pack;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import vmtu.include.core.VMTUCore;
import vmtu.include.core.util.AssetUtil;
import vmtu.include.core.util.FileUtil;

public class ResourcePack {
    private static final long UPDATE_TIME_GAP = TimeUnit.DAYS.toMillis(1L);
    private final String filename;
    private final Path filePath;
    private final Path tmpFilePath;
    private final boolean saveToGame;

    public ResourcePack(String filename, boolean saveToGame) {
        this.saveToGame = saveToGame;
        this.filename = filename;
        this.filePath = FileUtil.getResourcePackPath(filename);
        this.tmpFilePath = FileUtil.getTemporaryPath(filename);
        try {
            FileUtil.syncTmpFile(this.filePath, this.tmpFilePath, saveToGame);
        }
        catch (Exception e) {
            VMTUCore.LOGGER.warn(String.format("Error while sync temp file %s <-> %s: %s", this.filePath, this.tmpFilePath, e));
        }
    }

    public void checkUpdate(String fileUrl) throws IOException {
        this.downloadFull(fileUrl);
    }

    private void downloadFull(String fileUrl) throws IOException {
        try {
            Path downloadTmp = FileUtil.getTemporaryPath(this.filename + ".tmp");
            AssetUtil.download(fileUrl, downloadTmp);
            Files.move(downloadTmp, this.tmpFilePath, StandardCopyOption.REPLACE_EXISTING);
            VMTUCore.LOGGER.debug(String.format("Updates temp file: %s", this.tmpFilePath));
        }
        catch (Exception e) {
            VMTUCore.LOGGER.warn("Error while downloading: %s", e);
        }
        if (!Files.exists(this.tmpFilePath, new LinkOption[0])) {
            throw new FileNotFoundException("Tmp file not found.");
        }
        FileUtil.syncTmpFile(this.filePath, this.tmpFilePath, this.saveToGame);
    }

    public Path getTmpFilePath() {
        return this.tmpFilePath;
    }

    public String getFilename() {
        return this.filename;
    }
}

