/*
 * Decompiled with CFR 0.152.
 */
package vmtu.include.core.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import vmtu.include.core.VMTUCore;
import vmtu.include.core.pack.ResourcePack;
import vmtu.include.core.util.FileUtil;

public class ResourcePackConverter {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<Path> sourcePath;
    private final Path filePath;
    private final Path tmpFilePath;

    public ResourcePackConverter(List<ResourcePack> resourcePack, String filename) {
        this.sourcePath = resourcePack.stream().map(ResourcePack::getTmpFilePath).collect(Collectors.toList());
        this.filePath = FileUtil.getResourcePackPath(filename);
        this.tmpFilePath = FileUtil.getTemporaryPath(filename);
    }

    public void convert(int packFormat, String description) throws Exception {
        HashSet<String> fileList = new HashSet<String>();
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(this.tmpFilePath, new OpenOption[0]), StandardCharsets.UTF_8);){
            for (Path p : this.sourcePath) {
                VMTUCore.LOGGER.info("Converting: " + p);
                try (ZipFile zf = new ZipFile(p.toFile(), StandardCharsets.UTF_8);){
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        String name = ze.getName();
                        if (fileList.contains(name)) continue;
                        fileList.add(name);
                        zos.putNextEntry(new ZipEntry(name));
                        InputStream is = zf.getInputStream(ze);
                        if (name.equalsIgnoreCase("pack.mcmeta")) {
                            zos.write(this.convertPackMeta(is, packFormat, description));
                        } else {
                            IOUtils.copy((InputStream)is, (OutputStream)zos);
                        }
                        zos.closeEntry();
                    }
                }
            }
            zos.close();
            VMTUCore.LOGGER.info("Converted: %s -> %s", (Object)this.sourcePath, (Object)this.tmpFilePath);
            FileUtil.syncTmpFile(this.tmpFilePath, this.filePath, true);
        }
        catch (Exception e) {
            throw new Exception(String.format("Error converting %s to %s: %s", this.sourcePath, this.tmpFilePath, e));
        }
    }

    private byte[] convertPackMeta(InputStream is, int packFormat, String description) {
        PackMeta meta = (PackMeta)GSON.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), PackMeta.class);
        meta.pack.pack_format = packFormat;
        meta.pack.description = description;
        return GSON.toJson((Object)meta).getBytes(StandardCharsets.UTF_8);
    }

    private static class PackMeta {
        Pack pack;

        private PackMeta() {
        }

        private static class Pack {
            int pack_format;
            String description;

            private Pack() {
            }
        }
    }
}

