/*
 * Decompiled with CFR 0.152.
 */
package vmtu.include.core.util.version;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    public final String version;
    private final List<Integer> versions = new ArrayList<Integer>();

    @Nullable
    public static Version from(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        return new Version(version);
    }

    private Version(@NotNull String version) {
        this.version = version;
        this.parseVersion(version);
    }

    private void parseVersion(@NotNull String version) {
        VersionParseState state = VersionParseState.START;
        StringBuilder buffer = new StringBuilder();
        block4: for (char c : version.toCharArray()) {
            switch (state.ordinal()) {
                case 0: {
                    if (Character.isDigit(c)) {
                        buffer.append(c);
                        state = VersionParseState.READING_NUMBER;
                        continue block4;
                    }
                    return;
                }
                case 1: {
                    if (Character.isDigit(c)) {
                        buffer.append(c);
                        continue block4;
                    }
                    this.versions.add(Integer.parseInt(buffer.toString()));
                    buffer = new StringBuilder();
                    if (c == '.') {
                        state = VersionParseState.START;
                        continue block4;
                    }
                    return;
                }
            }
        }
        this.versions.add(Integer.parseInt(buffer.toString()));
    }

    @Override
    public int compareTo(@NotNull Version o) {
        int min = Math.min(this.versions.size(), o.versions.size());
        for (int i = 0; i < min; ++i) {
            if (Objects.equals(this.versions.get(i), o.versions.get(i))) continue;
            return Integer.compare(this.versions.get(i), o.versions.get(i));
        }
        return Integer.compare(this.versions.size(), o.versions.size());
    }

    static enum VersionParseState {
        START,
        READING_NUMBER;

    }
}

