/*
 * Decompiled with CFR 0.152.
 */
package vmtu.include.core.util.version;

import org.jetbrains.annotations.NotNull;
import vmtu.include.core.util.version.Version;

public class VersionRange {
    private Version fromVersion;
    private boolean containsLeft;
    private Version toVersion;
    private boolean containsRight;

    public VersionRange(String range) {
        this.parseVersionRange(range);
    }

    private void parseVersionRange(@NotNull String range) {
        RangeParseState state = RangeParseState.START;
        StringBuilder buffer = new StringBuilder();
        block5: for (char c : range.toCharArray()) {
            switch (state.ordinal()) {
                case 0: {
                    state = RangeParseState.READING_FIRST_VERSION;
                    if (c == '[') {
                        this.containsLeft = true;
                        continue block5;
                    }
                    if (c == '(') {
                        this.containsLeft = false;
                        continue block5;
                    }
                    throw new IllegalArgumentException("Range illegal");
                }
                case 1: {
                    if (c == ',') {
                        this.fromVersion = Version.from(buffer.toString());
                        buffer = new StringBuilder();
                        state = RangeParseState.READING_SECOND_VERSION;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == ']') {
                        this.toVersion = Version.from(buffer.toString());
                        this.containsRight = true;
                        return;
                    }
                    if (c == ')') {
                        this.toVersion = Version.from(buffer.toString());
                        this.containsRight = false;
                        return;
                    }
                    buffer.append(c);
                }
            }
        }
        throw new IllegalArgumentException("Range illegal");
    }

    public boolean contains(@NotNull Version version) {
        int cmp;
        if (this.fromVersion != null && ((cmp = version.compareTo(this.fromVersion)) < 0 || !this.containsLeft && cmp == 0)) {
            return false;
        }
        if (this.toVersion != null) {
            cmp = version.compareTo(this.toVersion);
            return cmp <= 0 && (this.containsRight || cmp != 0);
        }
        return true;
    }

    static enum RangeParseState {
        START,
        READING_FIRST_VERSION,
        READING_SECOND_VERSION;

    }
}

