/*
 * Decompiled with CFR 0.152.
 */
package top.vmctcn.vmtu.mod.helper;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import top.vmctcn.vmtu.mod.VMTranslationUpdate;

public class LanguageHelper {
    private static final String DEFAULT_LANGUAGE = "en_us";

    public static String getFixedLanguage(String lang) {
        String language = (Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry()).toLowerCase();
        if (lang.equals(DEFAULT_LANGUAGE) && !lang.equals(language)) {
            Locale[] locales = (Locale[])Arrays.stream(Locale.class.getFields()).filter(f -> f.getType().equals(Locale.class)).map(f -> {
                try {
                    return (Locale)f.get(Locale.getDefault());
                }
                catch (IllegalAccessException e) {
                    VMTranslationUpdate.LOGGER.error("Failed to get locale from field {}", (Object)f.getName(), (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).filter(l -> !l.getLanguage().isEmpty() && !l.getCountry().isEmpty()).toArray(Locale[]::new);
            String[] languageCodes = (String[])Arrays.stream(locales).map(l -> (l.getLanguage() + "_" + l.getCountry()).toLowerCase()).distinct().toArray(String[]::new);
            String fixedFrom = language;
            if (Arrays.stream(languageCodes).anyMatch(l -> l.split("_")[1].equals(Locale.getDefault().getCountry().toLowerCase()))) {
                language = Arrays.stream(languageCodes).filter(l -> l.split("_")[1].equals(Locale.getDefault().getCountry().toLowerCase())).findFirst().orElse(DEFAULT_LANGUAGE);
            }
            VMTranslationUpdate.LOGGER.info("Switching language to {}{}", (Object)language, !fixedFrom.equals(language) ? ", fixed from " + fixedFrom + "." : "...");
            return language;
        }
        return DEFAULT_LANGUAGE;
    }
}

