/*
 * Decompiled with CFR 0.152.
 */
package top.vmctcn.vmtu.mod.modpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import top.vmctcn.vmtu.mod.ModPlatform;
import top.vmctcn.vmtu.mod.VMTranslationUpdate;
import top.vmctcn.vmtu.mod.modpack.ModpackInfo;

public class ModpackInfoReader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ModpackInfo modpackInfo;
    private static final Path gamePath;
    private static final Path modpackInfoPath;

    public static void init() {
        if (Files.exists(modpackInfoPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(modpackInfoPath, StandardCharsets.UTF_8);){
                modpackInfo = (ModpackInfo)GSON.fromJson((Reader)reader, ModpackInfo.class);
                if (modpackInfo == null) {
                    VMTranslationUpdate.LOGGER.warn("modpackinfo.json is empty or invalid, generating default file.");
                    ModpackInfoReader.generateDefaultModpackInfo();
                }
            }
            catch (Exception e) {
                VMTranslationUpdate.LOGGER.warn("Error reading modpackinfo.json, generating default file.", (Throwable)e);
                ModpackInfoReader.generateDefaultModpackInfo();
            }
        } else {
            VMTranslationUpdate.LOGGER.warn("modpackinfo.json does not exist, generating default file.");
            ModpackInfoReader.generateDefaultModpackInfo();
        }
    }

    private static void generateDefaultModpackInfo() {
        modpackInfo = new ModpackInfo();
        ModpackInfoReader.modpackInfo.modpack = new ModpackInfo.Modpack();
        ModpackInfoReader.modpackInfo.modpack.name = "ExampleModpack";
        ModpackInfoReader.modpackInfo.modpack.version = "v0.1.0";
        ModpackInfoReader.modpackInfo.modpack.translation = new ModpackInfo.Translation();
        ModpackInfoReader.modpackInfo.modpack.translation.url = "https://vmct-cn.top/modpacks/example/";
        ModpackInfoReader.modpackInfo.modpack.translation.language = "zh_cn";
        ModpackInfoReader.modpackInfo.modpack.translation.version = "1.0.0";
        ModpackInfoReader.modpackInfo.modpack.translation.updateCheckUrl = "https://gitee.com/Wulian233/vmtu/raw/main/update/example.txt";
        ModpackInfoReader.modpackInfo.modpack.translation.resourcePackName = "VM\u6c49\u5316\u7ec4\u6a21\u7ec4\u6c49\u5316\u53051.19\u53ca\u4ee5\u4e0a";
        try {
            Files.writeString(modpackInfoPath, (CharSequence)GSON.toJson((Object)modpackInfo), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            VMTranslationUpdate.LOGGER.info("Default modpackinfo.json generated.");
            try (BufferedReader reader = Files.newBufferedReader(modpackInfoPath, StandardCharsets.UTF_8);){
                modpackInfo = (ModpackInfo)GSON.fromJson((Reader)reader, ModpackInfo.class);
            }
        }
        catch (IOException e) {
            VMTranslationUpdate.LOGGER.error("Failed to generate default modpackinfo.json", (Throwable)e);
        }
    }

    public static ModpackInfo getModpackInfo() {
        return modpackInfo;
    }

    static {
        gamePath = ModPlatform.INSTANCE.getGameDir();
        modpackInfoPath = gamePath.resolve("modpackinfo.json");
        ModpackInfoReader.init();
    }
}

