/*
 * Decompiled with CFR 0.152.
 */
package top.vmctcn.vmtu.mod.screen;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import top.vmctcn.vmtu.mod.config.ModConfigHelper;
import top.vmctcn.vmtu.mod.helper.ScreenHelper;

public class SuggestModScreen
extends Screen {
    public static boolean i18nUpdateModPresent = SuggestModScreen.isCoreModClassLoaded("i18nupdatemod.I18nUpdateMod");
    public static boolean vaultPatcherPresent = SuggestModScreen.isCoreModClassLoaded("me.fengming.vaultpatcher_asm.VaultPatcher");
    public static final Component downloadButtonText = Component.translatable((String)"mco.brokenworld.download");
    public static final Component ignoreButtonText = Component.translatable((String)"selectWorld.backupJoinSkipButton");
    public final Screen lastScreen;
    private static final int HEADER_HEIGHT = 40;
    private static final int FOOTER_HEIGHT = 50;

    public SuggestModScreen(Screen lastScreen) {
        super((Component)SuggestModScreen.getSuggestTitle().copy().withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        int centerX = this.width / 2;
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)downloadButtonText, buttonWidget -> {
            if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent && ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
                ScreenHelper.openUrlOnScreen(this.minecraft, this, "https://www.curseforge.com/minecraft/mc-mods/i18nupdatemod/files/");
                ScreenHelper.openUrlOnScreen(this.minecraft, this, "https://www.curseforge.com/minecraft/mc-mods/vault-patcher/files/");
            } else if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent) {
                ScreenHelper.openUrlOnScreen(this.minecraft, this, "https://www.curseforge.com/minecraft/mc-mods/i18nupdatemod/files/");
            } else if (ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
                ScreenHelper.openUrlOnScreen(this.minecraft, this, "https://www.curseforge.com/minecraft/mc-mods/vault-patcher/files/");
            }
        }).bounds(centerX - 5 - 150, this.height - 25 - 10, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ignoreButtonText, buttonWidget -> this.onClose()).bounds(centerX + 5, this.height - 25 - 10, 150, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        ScreenHelper.drawCenteredTextWithShadow(context, this.font, this.title, n, 20 - 9 / 2, -1);
        ScreenHelper.drawCenteredTextWithShadow(context, this.font, SuggestModScreen.getSuggestText(), this.width / 2, 70, -1);
        ScreenHelper.drawCenteredTextWithShadow(context, this.font, (Component)Component.translatable((String)"vmtranslationupdate.warn.text2"), this.width / 2, 80, -1);
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float partial) {
        super.renderBackground(context, mouseX, mouseY, partial);
        GlStateManager._enableBlend();
        ScreenHelper.resetShaderColor();
        ScreenHelper.drawGuiTexture(context, Screen.HEADER_SEPARATOR, 0, 38, 0.0f, 0.0f, this.width, 2, 32, 2);
        ScreenHelper.drawGuiTexture(context, Screen.FOOTER_SEPARATOR, 0, this.height - 50, 0.0f, 0.0f, this.width, 2, 32, 2);
        ScreenHelper.resetShaderColor();
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    public static boolean isCoreModClassLoaded(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Component getSuggestTitle() {
        MutableComponent titleText = Component.empty();
        if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent && ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
            titleText = Component.translatable((String)"vmtranslationupdate.warn.title", (Object[])new Object[]{"I18nUpdateMod & VaultPatcher"});
        } else if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent) {
            titleText = Component.translatable((String)"vmtranslationupdate.warn.title", (Object[])new Object[]{"I18nUpdateMod"});
        } else if (ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
            titleText = Component.translatable((String)"vmtranslationupdate.warn.title", (Object[])new Object[]{"VaultPatcher"});
        }
        return titleText;
    }

    private static Component getSuggestText() {
        MutableComponent context = Component.empty();
        if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent && ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
            context = Component.translatable((String)"vmtranslationupdate.warn.text", (Object[])new Object[]{"I18nUpdateMod & VaultPatcher"});
        } else if (ModConfigHelper.getConfig().i18nUpdateModCheck && !i18nUpdateModPresent) {
            context = Component.translatable((String)"vmtranslationupdate.warn.text", (Object[])new Object[]{"I18nUpdateMod"});
        } else if (ModConfigHelper.getConfig().vaultPatcherCheck && !vaultPatcherPresent) {
            context = Component.translatable((String)"vmtranslationupdate.warn.text", (Object[])new Object[]{"VaultPatcher"});
        }
        return context;
    }
}

