/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.RotatableBlock;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallRotatableBlock
extends RotatableBlock
implements ITallBlock {
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TallRotatableBlock(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE);
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties.m_278166_(PushReaction.BLOCK));
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity player, @Nonnull ItemStack stack) {
        if (this.isReplaceable(level, pos.m_7494_())) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        } else {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            if (player instanceof Player) {
                ItemStack giveStack = stack.m_41777_();
                giveStack.m_41764_(1);
                ((Player)player).m_150109_().m_36054_(giveStack);
            }
        }
        this.tryCopyVariant(level, pos, stack);
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing == Direction.UP && ((Boolean)stateIn.m_61143_((Property)ISBOTTOM)).booleanValue() || facing == Direction.DOWN && !((Boolean)stateIn.m_61143_((Property)ISBOTTOM)).booleanValue()) {
            if (facingState.m_60713_((Block)this)) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

