/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.menus;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasyMultiBGSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class MoneySlot
extends EasyMultiBGSlot {
    private final List<Pair<ResourceLocation, ResourceLocation>> backgrounds;
    private final Player player;

    public MoneySlot(@Nonnull Container container, int index, int x, int y, @Nonnull Player player) {
        super(container, index, x, y);
        this.player = player;
        ArrayList temp = new ArrayList();
        for (CurrencyType type : MoneyAPI.getApi().AllCurrencyTypes()) {
            type.addMoneySlotBackground(temp::add, rl -> temp.add(Pair.of((Object)InventoryMenu.f_39692_, (Object)rl)));
        }
        this.backgrounds = ImmutableList.copyOf(temp);
    }

    @Override
    protected List<Pair<ResourceLocation, ResourceLocation>> getPossibleNoItemIcons() {
        return this.backgrounds;
    }

    @Override
    public boolean m_5857_(@Nonnull ItemStack stack) {
        if (this.locked) {
            return false;
        }
        return MoneyAPI.getApi().ItemAllowedInMoneySlot(this.player, stack);
    }
}

