/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplayData;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.ValueDisplaySerializer;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValuePair;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CoinDisplay
extends ValueDisplayData {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("coin");
    public static final ValueDisplaySerializer SERIALIZER = new Serializer();
    private final List<ItemData> displayData;

    @Override
    @Nonnull
    public ValueDisplaySerializer getSerializer() {
        return SERIALIZER;
    }

    @Nonnull
    private ItemData getDataForCoin(@Nonnull CoinEntry entry) {
        for (ItemData data : this.displayData) {
            if (!entry.matches(data.coin)) continue;
            return data;
        }
        return new ItemData(entry.getCoin());
    }

    @Nullable
    private ItemData getDataForItem(@Nonnull ItemStack item) {
        for (ItemData data : this.displayData) {
            if (item.m_41720_() != data.coin) continue;
            return data;
        }
        return null;
    }

    protected CoinDisplay(@Nonnull List<ItemData> displayData) {
        this.displayData = displayData;
    }

    @Override
    @Nonnull
    public MutableComponent formatValue(@Nonnull CoinValue value, @Nonnull MutableComponent emptyText) {
        if (value.getEntries().isEmpty()) {
            return emptyText;
        }
        MutableComponent result = EasyText.empty();
        for (CoinValuePair pair : value.getEntries()) {
            long amount = pair.amount;
            ItemData data = this.getDataForCoin(this.getParent().findEntry(pair.coin));
            result.m_7220_((Component)EasyText.literal(Long.toString(amount))).m_7220_(data.getInitial());
        }
        return result;
    }

    @Override
    public void formatCoinTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip) {
        Pair<CoinEntry, Integer> upperExchange;
        ChainData parent = this.getParent();
        if (parent == null) {
            return;
        }
        ItemData data = this.getDataForItem(stack);
        if (data == null) {
            return;
        }
        Pair<CoinEntry, Integer> lowerExchange = parent.getLowerExchange(data.coin);
        if (lowerExchange != null) {
            ItemData otherData = this.getDataForCoin((CoinEntry)lowerExchange.getFirst());
            tooltip.add((Component)LCText.TOOLTIP_COIN_WORTH_DOWN.get(lowerExchange.getSecond(), otherData.getPlural()).m_130940_(ChatFormatting.YELLOW));
        }
        if ((upperExchange = parent.getUpperExchange(data.coin)) != null) {
            tooltip.add((Component)LCText.TOOLTIP_COIN_WORTH_UP.get(upperExchange.getSecond(), LCText.TOOLTIP_COIN_DISPLAY_WORTH.get(((CoinEntry)upperExchange.getFirst()).getName(), CoinDisplay.getIcon(((CoinEntry)upperExchange.getFirst()).getCoin()))).m_130940_(ChatFormatting.YELLOW));
        }
    }

    public static CoinDisplay easyDefine() {
        return CoinDisplay.easyDefine((NonNullFunction<Item, Component>)((NonNullFunction)coin -> {
            String type = "item.";
            if (coin instanceof BlockItem) {
                type = "block.";
            }
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey(coin);
            return Component.m_237115_((String)(type + itemID.m_135827_() + "." + itemID.m_135815_() + ".initial"));
        }), (NonNullFunction<Item, Component>)((NonNullFunction)coin -> {
            String type = "item.";
            if (coin instanceof BlockItem) {
                type = "block.";
            }
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey(coin);
            return Component.m_237115_((String)(type + itemID.m_135827_() + "." + itemID.m_135815_() + ".plural"));
        }));
    }

    public static CoinDisplay easyDefine(@Nonnull NonNullFunction<Item, Component> initialGenerator, @Nonnull NonNullFunction<Item, Component> pluralGenerator) {
        Builder builder = CoinDisplay.builder();
        for (CoinEntry entry : builder.possibleCoinEntries()) {
            Item coin = entry.getCoin();
            builder.defineFor(entry, (Component)initialGenerator.apply((Object)coin), (Component)pluralGenerator.apply((Object)coin));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ItemData {
        private final Item coin;
        @Nullable
        protected Component initial = null;
        @Nullable
        protected Component plural = null;

        @Nonnull
        public Component getInitial() {
            return LCText.TOOLTIP_COIN_DISPLAY.get(Objects.requireNonNullElseGet(this.initial, () -> {
                String name = new ItemStack((ItemLike)this.coin).m_41786_().getString();
                if (!name.isEmpty()) {
                    return EasyText.literal(name.substring(0, 1).toLowerCase());
                }
                return EasyText.literal("X");
            }), this.getIcon());
        }

        @Nonnull
        public Component getPlural() {
            return LCText.TOOLTIP_COIN_DISPLAY_WORTH.get(Objects.requireNonNullElseGet(this.plural, () -> LCText.MISC_GENERIC_PLURAL.get(new ItemStack((ItemLike)this.coin).m_41786_())), this.getIcon());
        }

        private Component getIcon() {
            return ValueDisplayData.getIcon(this.coin);
        }

        ItemData(@Nonnull Item coin) {
            this.coin = coin;
        }
    }

    public static class Builder {
        private final ChainData.Builder parent = ChainData.Builder.getLatest();
        List<ItemData> displayData = new ArrayList<ItemData>();

        private Builder() {
        }

        protected List<CoinEntry> possibleCoinEntries() {
            ArrayList<CoinEntry> entries = new ArrayList<CoinEntry>();
            if (this.parent == null) {
                return entries;
            }
            entries.addAll(this.parent.getCoreChain().getEntries());
            for (ChainData.Builder.ChainBuilder sideChain : this.parent.getSideChains()) {
                entries.addAll(sideChain.getEntries());
            }
            return entries;
        }

        public Builder defineFor(@Nonnull RegistryObject<? extends ItemLike> coin, @Nonnull Component initial, @Nonnull Component plural) {
            return this.defineFor((ItemLike)coin.get(), initial, plural);
        }

        private void defineFor(@Nullable CoinEntry coin, @Nonnull Component initial, @Nonnull Component plural) {
            this.defineFor((ItemLike)coin.getCoin(), initial, plural);
        }

        public Builder defineFor(@Nullable ItemLike coin, @Nonnull Component initial, @Nonnull Component plural) {
            if (coin == null) {
                return this;
            }
            ItemData data = new ItemData(coin.m_5456_());
            data.initial = initial;
            data.plural = plural;
            this.displayData.add(data);
            return this;
        }

        public CoinDisplay build() {
            return new CoinDisplay(this.displayData);
        }
    }

    protected static class Serializer
    extends ValueDisplaySerializer {
        private final List<ItemData> displayData = new ArrayList<ItemData>();

        protected Serializer() {
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public void resetBuilder() {
            this.displayData.clear();
        }

        @Override
        public void parseAdditional(@Nonnull JsonObject chainJson) {
        }

        @Override
        public void writeAdditional(@Nonnull ValueDisplayData data, @Nonnull JsonObject chainJson) {
        }

        @Override
        public void parseAdditionalFromCoin(@Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) {
            ItemData data = new ItemData(coin.getCoin());
            if (coinEntry.has("initial")) {
                data.initial = Component.Serializer.m_130691_((JsonElement)coinEntry.get("initial"));
            }
            if (coinEntry.has("plural")) {
                data.plural = Component.Serializer.m_130691_((JsonElement)coinEntry.get("plural"));
            }
            this.displayData.add(data);
        }

        @Override
        public void writeAdditionalToCoin(@Nonnull ValueDisplayData data, @Nonnull CoinEntry coin, @Nonnull JsonObject coinEntry) {
            if (data instanceof CoinDisplay) {
                CoinDisplay display = (CoinDisplay)data;
                ItemData d = display.getDataForCoin(coin);
                if (d.initial != null) {
                    coinEntry.add("initial", Component.Serializer.m_130716_((Component)d.initial));
                }
                if (d.plural != null) {
                    coinEntry.add("plural", Component.Serializer.m_130716_((Component)d.plural));
                }
            }
        }

        @Override
        @Nonnull
        public CoinDisplay build() {
            return new CoinDisplay((List<ItemData>)ImmutableList.copyOf(this.displayData));
        }
    }
}

