/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnerType;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class PlayerOwner
extends Owner {
    public static final OwnerType TYPE = OwnerType.create(VersionUtil.lcResource("player"), tag -> PlayerOwner.of(PlayerReference.load(tag.m_128469_("Player"))));
    public final PlayerReference player;

    private PlayerOwner(@Nonnull PlayerReference player) {
        this.player = player;
    }

    @Nonnull
    public static PlayerOwner of(@Nonnull Player player) {
        return PlayerOwner.of(PlayerReference.of(player));
    }

    @Nonnull
    public static PlayerOwner of(@Nonnull PlayerReference player) {
        return new PlayerOwner(player);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.player.getNameComponent(this.isClient());
    }

    @Override
    @Nonnull
    public MutableComponent getCommandLabel() {
        return LCText.COMMAND_LCADMIN_DATA_OWNER_PLAYER.get(this.player.getName(false), this.player.id.toString());
    }

    @Override
    public boolean stillValid() {
        return true;
    }

    @Override
    public boolean alwaysValid() {
        return true;
    }

    @Override
    public boolean isOnline() {
        if (this.isClient()) {
            return false;
        }
        return this.player.isOnline();
    }

    @Override
    public boolean isAdmin(@Nonnull PlayerReference player) {
        return this.player.is(player);
    }

    @Override
    public boolean isMember(@Nonnull PlayerReference player) {
        return this.isAdmin(player);
    }

    @Override
    @Nonnull
    public PlayerReference asPlayerReference() {
        return this.player;
    }

    @Override
    @Nullable
    public BankReference asBankReference() {
        return PlayerBankReference.of(this.player).flagAsClient(this);
    }

    @Override
    public void pushNotification(@Nonnull Supplier<? extends Notification> notificationSource, int notificationLevel, boolean sendToChat) {
        NotificationAPI.getApi().PushPlayerNotification(this.player.id, notificationSource.get(), sendToChat);
    }

    @Override
    @Nonnull
    public OwnerType getType() {
        return TYPE;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.m_128365_("Player", (Tag)this.player.save());
    }

    @Override
    @Nonnull
    public Owner copy() {
        return new PlayerOwner(this.player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@Nonnull Owner other) {
        if (!(other instanceof PlayerOwner)) return false;
        PlayerOwner po = (PlayerOwner)other;
        if (!po.player.is(this.player)) return false;
        return true;
    }
}

