/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.settings.pretty;

import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class PrettyTextWriter {
    public static final PrettyTextWriter DEFAULT = new DefaultWriter();
    private static final List<PrettyTextWriter> registry = new ArrayList<PrettyTextWriter>();

    public static void register(PrettyTextWriter writer) {
        if (!registry.contains(writer)) {
            registry.add(writer);
        }
    }

    public static PrettyTextWriter getForStack(ItemStack stack) {
        for (PrettyTextWriter writer : registry) {
            if (!writer.worksOnStack(stack)) continue;
            return writer;
        }
        return DEFAULT;
    }

    public abstract boolean worksOnStack(ItemStack var1);

    public abstract ItemStack writeLinesToStack(@Nullable Player var1, ItemStack var2, PrettyTextData var3);

    private static class DefaultWriter
    extends PrettyTextWriter {
        private DefaultWriter() {
        }

        @Override
        public boolean worksOnStack(ItemStack stack) {
            return true;
        }

        @Override
        public ItemStack writeLinesToStack(@Nullable Player player, ItemStack stack, PrettyTextData data) {
            stack.m_41714_(data.machineName());
            return stack;
        }
    }
}

